/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.evaluation;

import com.intellij.ml.llm.evaluation.CallLocation;
import com.intellij.ml.llm.evaluation.IntentionCallContext;
import com.intellij.ml.llm.evaluation.TextRangeCallLocationKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/evaluation/TextRangeCallLocation;", "Lcom/intellij/ml/llm/evaluation/CallLocation;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/util/TextRange;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getFile", "()Lcom/intellij/psi/PsiFile;", "getTextRange", "()Lcom/intellij/openapi/util/TextRange;", "getIntentionCallContext", "Lcom/intellij/ml/llm/evaluation/IntentionCallContext;", "toJson", "", "intellij.ml.llm.core"})
public final class TextRangeCallLocation
implements CallLocation {
    @NotNull
    private final Project project;
    @NotNull
    private final PsiFile file;
    @NotNull
    private final TextRange textRange;

    public TextRangeCallLocation(@NotNull Project project, @NotNull PsiFile file, @NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        this.project = project;
        this.file = file;
        this.textRange = textRange;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final PsiFile getFile() {
        return this.file;
    }

    @NotNull
    public final TextRange getTextRange() {
        return this.textRange;
    }

    @Override
    @NotNull
    public IntentionCallContext getIntentionCallContext() {
        Editor editor;
        block0: {
            OpenFileDescriptor openFileDescriptor;
            FileEditorManager editorManager = FileEditorManager.getInstance((Project)this.project);
            editor = editorManager.openTextEditor(openFileDescriptor = new OpenFileDescriptor(this.project, this.file.getVirtualFile()), false);
            Editor editor2 = editor;
            if (editor2 == null || (editor2 = editor2.getSelectionModel()) == null) break block0;
            editor2.setSelection(this.textRange.getStartOffset(), this.textRange.getEndOffset());
        }
        return new IntentionCallContext(this.project, editor, this.file);
    }

    @Override
    @NotNull
    public String toJson() {
        VirtualFile virtualFile = this.file.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        String filePathInProject = TextRangeCallLocationKt.relativeName(virtualFile, this.project);
        return "{\"file\": \"" + filePathInProject + "\", \"startOffset\": " + this.textRange.getStartOffset() + ", \"endOffset\": " + this.textRange.getEndOffset() + "}";
    }
}

