/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.grazie.tasks.documentation;

import com.intellij.ml.llm.grazie.tasks.documentation.PhpFrameworkContextRenderKt;
import com.intellij.ml.llm.grazie.tasks.documentation.WdAttachmentItem;
import com.intellij.ml.llm.grazie.tasks.documentation.WdPrompt;
import com.intellij.ml.llm.grazie.tasks.documentation.WdPromptCustomization;
import com.intellij.ml.llm.grazie.tasks.documentation.WdPromptInstructions;
import com.intellij.ml.llm.grazie.tasks.documentation.WdPromptOptions;
import com.intellij.ml.llm.grazie.tasks.documentation.WdRiderEntity;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConcatenateBuilder;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.PSStringOperatorsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0007\u001a\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0002\u001a\u00020\bH\u0002\u001a\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0002\u001a\u00020\tH\u0002\u001a\u0014\u0010\n\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\n\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u000bH\u0002\u001a\u0014\u0010\n\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0002\u001a\u00020\fH\u0002\u001a\u0014\u0010\n\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0002\u001a\u00020\rH\u0002\u001a\u0014\u0010\n\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u000eH\u0002\u001a\u0014\u0010\u000f\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0002\u001a\u00020\rH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0016\u0010\u0013\u001a\u00020\u0005*\u00020\u00062\b\u0010\u0002\u001a\u0004\u0018\u00010\u0014H\u0002\u001a\u0014\u0010\u0013\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0015H\u0002\u001a\u0014\u0010\u0013\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0002\u001a\u00020\fH\u0002\u001a\u0014\u0010\u0013\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u000eH\u0002\u001a\u0014\u0010\n\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0016H\u0002\u001a\u0014\u0010\n\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0017H\u0002\u001a\u0014\u0010\n\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0018H\u0002\u001a\u0014\u0010\u0019\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\n\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u001bH\u0002\u001a\u0014\u0010\u001c\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u00a8\u0006\u001f"}, d2={"renderSystem", "Lcom/intellij/ml/llm/privacy/PSString;", "options", "Lcom/intellij/ml/llm/grazie/tasks/documentation/WdPrompt;", "render", "", "Lcom/intellij/ml/llm/privacy/trustedStringBuilders/ConcatenateBuilder;", "Lcom/intellij/ml/llm/grazie/tasks/documentation/WdPromptCustomization;", "Lcom/intellij/ml/llm/grazie/tasks/documentation/WdPromptCustomization$DefaultForLanguage;", "Lcom/intellij/ml/llm/grazie/tasks/documentation/WdPromptCustomization$User;", "renderContext", "Lcom/intellij/ml/llm/grazie/tasks/documentation/WdPromptOptions$Php;", "Lcom/intellij/ml/llm/grazie/tasks/documentation/WdPromptOptions$Go;", "Lcom/intellij/ml/llm/grazie/tasks/documentation/WdPromptOptions$Rider;", "Lcom/intellij/ml/llm/grazie/tasks/documentation/WdPromptOptions$Ruby;", "renderMethodContext", "contextEntryName", "entity", "Lcom/intellij/ml/llm/grazie/tasks/documentation/WdRiderEntity;", "renderAfterTask", "Lcom/intellij/ml/llm/grazie/tasks/documentation/WdPromptOptions;", "Lcom/intellij/ml/llm/grazie/tasks/documentation/WdPromptOptions$Python;", "Lcom/intellij/ml/llm/grazie/tasks/documentation/WdPromptOptions$GenericClass;", "Lcom/intellij/ml/llm/grazie/tasks/documentation/WdPromptOptions$Generic;", "Lcom/intellij/ml/llm/grazie/tasks/documentation/WdPromptOptions$GenericMethod;", "renderTask", "language", "Lcom/intellij/ml/llm/grazie/tasks/documentation/WdPromptOptions$GenericVariable;", "renderTarget", "sample", "Lcom/intellij/ml/llm/grazie/tasks/documentation/WdPromptInstructions;", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nWriteDocumentationTaskRender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WriteDocumentationTaskRender.kt\ncom/intellij/ml/llm/grazie/tasks/documentation/WriteDocumentationTaskRenderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,221:1\n1869#2,2:222\n*S KotlinDebug\n*F\n+ 1 WriteDocumentationTaskRender.kt\ncom/intellij/ml/llm/grazie/tasks/documentation/WriteDocumentationTaskRenderKt\n*L\n215#1:222,2\n*E\n"})
public final class WriteDocumentationTaskRenderKt {
    @NotNull
    public static final PSString renderSystem(@NotNull WdPrompt options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return ConstantsKt.getPrivacyConst((String)"You are a software developer. Reply only with doc comment.");
    }

    @NotNull
    public static final PSString render(@NotNull WdPrompt options) {
        ConcatenateBuilder concatenateBuilder;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        ConcatenateBuilder $this$render_u24lambda_u240 = concatenateBuilder = new ConcatenateBuilder(null, 1, null);
        boolean bl = false;
        WriteDocumentationTaskRenderKt.renderContext($this$render_u24lambda_u240, options);
        WriteDocumentationTaskRenderKt.render($this$render_u24lambda_u240, options.getCustomization());
        WriteDocumentationTaskRenderKt.renderAfterTask($this$render_u24lambda_u240, options.getLanguageOptions());
        WriteDocumentationTaskRenderKt.renderTarget($this$render_u24lambda_u240, options.getTarget());
        return concatenateBuilder.toPSString();
    }

    public static final void render(@NotNull ConcatenateBuilder $this$render, @NotNull WdPromptCustomization options) {
        Intrinsics.checkNotNullParameter((Object)$this$render, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        WdPromptCustomization wdPromptCustomization = options;
        if (wdPromptCustomization instanceof WdPromptCustomization.DefaultForLanguage) {
            WriteDocumentationTaskRenderKt.render($this$render, (WdPromptCustomization.DefaultForLanguage)options);
        } else if (wdPromptCustomization instanceof WdPromptCustomization.User) {
            WriteDocumentationTaskRenderKt.render($this$render, (WdPromptCustomization.User)options);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final void render(ConcatenateBuilder $this$render, WdPromptCustomization.DefaultForLanguage options) {
        WriteDocumentationTaskRenderKt.renderTask($this$render, options.getLanguage());
    }

    private static final void render(ConcatenateBuilder $this$render, WdPromptCustomization.User options) {
        $this$render.appendLine(options.getPrompt());
    }

    private static final void renderContext(ConcatenateBuilder $this$renderContext, WdPrompt options) {
        WdPromptOptions languageOptions = options.getLanguageOptions();
        if (languageOptions instanceof WdPromptOptions.Php) {
            WriteDocumentationTaskRenderKt.renderContext($this$renderContext, (WdPromptOptions.Php)languageOptions);
        } else if (languageOptions instanceof WdPromptOptions.Go) {
            WriteDocumentationTaskRenderKt.renderContext($this$renderContext, (WdPromptOptions.Go)languageOptions);
        } else if (languageOptions instanceof WdPromptOptions.Rider) {
            WriteDocumentationTaskRenderKt.renderContext($this$renderContext, (WdPromptOptions.Rider)languageOptions);
        } else if (languageOptions instanceof WdPromptOptions.Ruby) {
            WriteDocumentationTaskRenderKt.renderContext($this$renderContext, (WdPromptOptions.Ruby)languageOptions);
        } else if (languageOptions instanceof WdPromptOptions.GenericVariable) {
            WriteDocumentationTaskRenderKt.renderContext($this$renderContext, (WdPromptOptions.GenericVariable)languageOptions);
        } else if (languageOptions instanceof WdPromptOptions.GenericClass) {
            WriteDocumentationTaskRenderKt.renderContext($this$renderContext, (WdPromptOptions.GenericClass)languageOptions);
        } else if (languageOptions instanceof WdPromptOptions.GenericMethod) {
            WriteDocumentationTaskRenderKt.renderContext($this$renderContext, (WdPromptOptions.GenericMethod)languageOptions);
        } else {
            WriteDocumentationTaskRenderKt.renderContext($this$renderContext, new WdPromptOptions.Generic());
        }
    }

    private static final void renderContext(ConcatenateBuilder $this$renderContext, WdPromptOptions.Php options) {
        PhpFrameworkContextRenderKt.render($this$renderContext, options.getFrameworkContext());
    }

    private static final void renderContext(ConcatenateBuilder $this$renderContext, WdPromptOptions.Go options) {
        if (options.isCommentedAfter()) {
            v0 = $this$renderContext.appendLine(ConstantsKt.getPrivacyConst((String)"Write only one line."));
        } else {
            PSString pSString = options.getTargetTitle();
            if (pSString == null) {
                pSString = ConstantsKt.getPrivacyConst((String)"following code");
            }
            PSString fallbackTitle = pSString;
            PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{fallbackTitle};
            $this$renderContext.appendLine(ConstantsKt.getPrivacyConst((String)"Write some brief documentation ONLY for the %s.").format(pSStringConvertibleArray));
            $this$renderContext.appendLine(ConstantsKt.getPrivacyConst((String)"Do not append any additional information like examples, usages and surrounding code. "));
            if (options.getTargetTitle() != null) {
                $this$renderContext.appendLine(ConstantsKt.getPrivacyConst((String)"START comment strictly with its NAME. "));
            }
            $this$renderContext.appendLine(ConstantsKt.getPrivacyConst((String)"DO NOT DUPLICATE THE DECLARATION CODE! "));
            v0 = $this$renderContext.appendLine(ConstantsKt.getPrivacyConst((String)"Do not mention the containing package."));
        }
    }

    private static final void renderContext(ConcatenateBuilder $this$renderContext, WdPromptOptions.Rider options) {
        switch (WhenMappings.$EnumSwitchMapping$0[options.getEntity().ordinal()]) {
            case 1: {
                PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{options.getName()};
                Unit unit = $this$renderContext.appendLine(ConstantsKt.getPrivacyConst((String)"Write documentation for given class $%s").format(pSStringConvertibleArray));
                break;
            }
            case 2: {
                PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{options.getName()};
                Unit unit = $this$renderContext.appendLine(ConstantsKt.getPrivacyConst((String)"Write documentation for given struct $%s").format(pSStringConvertibleArray));
                break;
            }
            case 3: {
                PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{options.getName()};
                Unit unit = $this$renderContext.appendLine(ConstantsKt.getPrivacyConst((String)"Write documentation for given interface %s.").format(pSStringConvertibleArray));
                break;
            }
            case 4: {
                PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{options.getName()};
                Unit unit = $this$renderContext.appendLine(ConstantsKt.getPrivacyConst((String)"Write documentation for given property %s.").format(pSStringConvertibleArray));
                break;
            }
            case 5: {
                WriteDocumentationTaskRenderKt.renderMethodContext($this$renderContext, options);
                Unit unit = Unit.INSTANCE;
                break;
            }
            case 6: {
                PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{options.getName()};
                Unit unit = $this$renderContext.appendLine(ConstantsKt.getPrivacyConst((String)"Write documentation for given variable %s.").format(pSStringConvertibleArray));
                break;
            }
            case 7: {
                PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{options.getName()};
                Unit unit = $this$renderContext.appendLine(ConstantsKt.getPrivacyConst((String)"Write documentation for given enum %s.").format(pSStringConvertibleArray));
                break;
            }
            case 8: {
                PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{options.getName(), options.getEnumName()};
                Unit unit = $this$renderContext.appendLine(ConstantsKt.getPrivacyConst((String)"Write documentation for given enum member %s of enum %s.").format(pSStringConvertibleArray));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private static final void renderContext(ConcatenateBuilder $this$renderContext, WdPromptOptions.Ruby options) {
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{options.getType(), options.getName()};
        $this$renderContext.appendLine(ConstantsKt.getPrivacyConst((String)"Write documentation for the given %s %s.").format(pSStringConvertibleArray));
        if (StringsKt.contains$default((CharSequence)options.getType().unwrap(), (CharSequence)"method", (boolean)false, (int)2, null)) {
            $this$renderContext.appendLine(ConstantsKt.getPrivacyConst((String)"Do not describe the method visibility."));
            $this$renderContext.appendLine(ConstantsKt.getPrivacyConst((String)"Do not use YARD tags for the parameters and return type."));
        }
    }

    private static final void renderMethodContext(ConcatenateBuilder $this$renderMethodContext, WdPromptOptions.Rider options) {
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{WriteDocumentationTaskRenderKt.contextEntryName(options.getEntity())};
        $this$renderMethodContext.appendLine(ConstantsKt.getPrivacyConst((String)"Write documentation for given %s. ").format(pSStringConvertibleArray));
        if (options.getHasParams()) {
            pSStringConvertibleArray = new PSStringConvertible[]{options.getParamsTag()};
            $this$renderMethodContext.appendLine(ConstantsKt.getPrivacyConst((String)"Use %s tag.").format(pSStringConvertibleArray));
        }
        if (options.getHasReturnType()) {
            pSStringConvertibleArray = new PSStringConvertible[]{options.getReturnsTag()};
            $this$renderMethodContext.appendLine(ConstantsKt.getPrivacyConst((String)"Use %s tag.").format(pSStringConvertibleArray));
        }
    }

    private static final PSString contextEntryName(WdRiderEntity entity) {
        return switch (WhenMappings.$EnumSwitchMapping$0[entity.ordinal()]) {
            case 1 -> ConstantsKt.getPrivacyConst((String)"class");
            case 2 -> ConstantsKt.getPrivacyConst((String)"struct");
            case 3 -> ConstantsKt.getPrivacyConst((String)"interface");
            case 4 -> ConstantsKt.getPrivacyConst((String)"property");
            case 5 -> ConstantsKt.getPrivacyConst((String)"method");
            case 6 -> ConstantsKt.getPrivacyConst((String)"variable");
            case 7 -> ConstantsKt.getPrivacyConst((String)"enum");
            case 8 -> ConstantsKt.getPrivacyConst((String)"enum member");
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final void renderAfterTask(ConcatenateBuilder $this$renderAfterTask, WdPromptOptions options) {
        WdPromptOptions wdPromptOptions = options;
        if (wdPromptOptions instanceof WdPromptOptions.Python) {
            WriteDocumentationTaskRenderKt.renderAfterTask($this$renderAfterTask, (WdPromptOptions.Python)options);
        } else if (wdPromptOptions instanceof WdPromptOptions.Go) {
            WriteDocumentationTaskRenderKt.renderAfterTask($this$renderAfterTask, (WdPromptOptions.Go)options);
        } else if (wdPromptOptions instanceof WdPromptOptions.Ruby) {
            WriteDocumentationTaskRenderKt.renderAfterTask($this$renderAfterTask, (WdPromptOptions.Ruby)options);
        }
    }

    private static final void renderAfterTask(ConcatenateBuilder $this$renderAfterTask, WdPromptOptions.Python options) {
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{options.getFormatName(), options.getFormatName(), options.getFormatName(), options.getExampleWithProperIndent()};
        $this$renderAfterTask.appendLine(ConstantsKt.getPrivacyConst((String)"\nyou MUST use %s format for python docstring and follow its specification strictly\nyou MUST add all possible docstring sections for %s docstring format\nyou MUST add detailed summary before all docstring sections\nyou MUST NOT add description of the class methods in class docstring\nyou MUST NOT describe raised errors, args/parameters, return value anywhere but in corresponding section/tag\nyou MUST specify types of the parameters or class attributes accordingly to docstring format %s\nyou MUST NOT describe types in docstring if there are type hints for them\nyou MUST NOT describe types anywhere but in description of corresponding parameters/attributes\nyou MUST wrap long lines\nyou MUST NOT add common indent\nformat:\n%s\n").format(pSStringConvertibleArray).trimIndent());
    }

    private static final void renderAfterTask(ConcatenateBuilder $this$renderAfterTask, WdPromptOptions.Go options) {
        $this$renderAfterTask.appendLine(ConstantsKt.getPrivacyConst((String)"USE only single-line COMMENTS that START WITH `//`! "));
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{PSStringOperatorsKt.toPSString((int)options.getRightMargin())};
        $this$renderAfterTask.appendLine(ConstantsKt.getPrivacyConst((String)"Comments should not exceed the length of %s characters!").format(pSStringConvertibleArray));
    }

    private static final void renderAfterTask(ConcatenateBuilder $this$renderAfterTask, WdPromptOptions.Ruby options) {
        $this$renderAfterTask.appendLine(ConstantsKt.getPrivacyConst((String)"You MUST use the RDoc Markup format"));
        if (StringsKt.contains$default((CharSequence)options.getType().unwrap(), (CharSequence)"method", (boolean)false, (int)2, null)) {
            $this$renderAfterTask.appendLine(ConstantsKt.getPrivacyConst((String)"You MUST NOT specify the method visibility"));
            $this$renderAfterTask.appendLine(ConstantsKt.getPrivacyConst((String)"You MAY use YARD tags for the parameters and return type"));
        }
    }

    private static final void renderContext(ConcatenateBuilder $this$renderContext, WdPromptOptions.GenericClass options) {
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{options.getCode()};
        $this$renderContext.appendLine(ConstantsKt.getPrivacyConst((String)"Write documentation for given class %s").format(pSStringConvertibleArray));
    }

    private static final void renderContext(ConcatenateBuilder $this$renderContext, WdPromptOptions.Generic options) {
        $this$renderContext.appendLine(ConstantsKt.getPrivacyConst((String)"Write documentation for given code"));
    }

    private static final void renderContext(ConcatenateBuilder $this$renderContext, WdPromptOptions.GenericMethod options) {
        WdPromptOptions.GenericMethod $this$renderContext_u24lambda_u241 = options;
        boolean bl = false;
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{$this$renderContext_u24lambda_u241.getCode()};
        $this$renderContext.appendLine(ConstantsKt.getPrivacyConst((String)"Write documentation for given method %s.").format(pSStringConvertibleArray));
        if ($this$renderContext_u24lambda_u241.getParamsTag() != null) {
            pSStringConvertibleArray = new PSStringConvertible[]{$this$renderContext_u24lambda_u241.getParamsTag()};
            $this$renderContext.appendLine(ConstantsKt.getPrivacyConst((String)"Use %s tag.").format(pSStringConvertibleArray));
        }
        if ($this$renderContext_u24lambda_u241.getReturnsTag() != null) {
            pSStringConvertibleArray = new PSStringConvertible[]{$this$renderContext_u24lambda_u241.getReturnsTag()};
            $this$renderContext.appendLine(ConstantsKt.getPrivacyConst((String)"Use %s tag.").format(pSStringConvertibleArray));
        }
    }

    private static final void renderTask(ConcatenateBuilder $this$renderTask, PSString language) {
        PSString prompt;
        switch ((String)language.unwrap()) {
            case "PHP": {
                PSString pSString = ConstantsKt.getPrivacyConst((String)"Write PHPDoc.");
                break;
            }
            case "ObjectiveC": {
                PSString pSString = ConstantsKt.getPrivacyConst((String)"Write doxygen.");
                break;
            }
            case "go": {
                PSString pSString = ConstantsKt.getPrivacyConst((String)"Write Go Doc.");
                break;
            }
            case "JAVA": {
                PSString pSString = ConstantsKt.getPrivacyConst((String)"Write javadoc.");
                break;
            }
            case "JavaScript": {
                PSString pSString = ConstantsKt.getPrivacyConst((String)"Write JSDoc.");
                break;
            }
            case "TypeScript": {
                PSString pSString = ConstantsKt.getPrivacyConst((String)"Write JSDoc.");
                break;
            }
            case "HTML": {
                PSString pSString = ConstantsKt.getPrivacyConst((String)"Write JSDoc.");
                break;
            }
            case "kotlin": {
                PSString pSString = ConstantsKt.getPrivacyConst((String)"Write KDoc.");
                break;
            }
            case "C#": {
                PSString pSString = ConstantsKt.getPrivacyConst((String)"Write C# doc.");
                break;
            }
            case "F#": {
                PSString pSString = ConstantsKt.getPrivacyConst((String)"Write F# doc.");
                break;
            }
            case "C++": {
                PSString pSString = ConstantsKt.getPrivacyConst((String)"Write doxygen, do not use @file tag.");
                break;
            }
            case "Ruby": {
                PSString pSString = ConstantsKt.getPrivacyConst((String)"Write RDoc documentation.");
                break;
            }
            default: {
                PSString pSString = prompt = ConstantsKt.getPrivacyConst((String)"");
            }
        }
        if (((CharSequence)prompt).length() > 0) {
            $this$renderTask.appendLine(prompt);
        }
    }

    private static final void renderContext(ConcatenateBuilder $this$renderContext, WdPromptOptions.GenericVariable options) {
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{options.getCode()};
        $this$renderContext.appendLine(ConstantsKt.getPrivacyConst((String)"Write documentation for given variable %s.").format(pSStringConvertibleArray));
    }

    private static final void renderTarget(ConcatenateBuilder $this$renderTarget, WdPromptInstructions sample) {
        if (sample.getDeclaration() != null) {
            PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{sample.getDeclaration().getDeclarationSample(), sample.getDeclaration().getDocumentationSample()};
            $this$renderTarget.appendLine(ConstantsKt.getPrivacyConst((String)"Here is an example of documented declaration:\n             Q: %s\n             A: %s\n             Without duplicating the example above, document the following code:\n         ").format(pSStringConvertibleArray).trimIndent());
        }
        $this$renderTarget.appendLine(sample.getFallbackDocTargetSnippet());
        if (sample.getAttachment() != null) {
            $this$renderTarget.appendLine(ConstantsKt.getPrivacyConst((String)"The following information might be helpful, but don't show it in the results:\n"));
            Iterable $this$forEach$iv = sample.getAttachment().getItems();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WdAttachmentItem attachment = (WdAttachmentItem)element$iv;
                boolean bl = false;
                $this$renderTarget.appendLine(attachment.getName());
                $this$renderTarget.appendLine(attachment.getText());
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WdRiderEntity.values().length];
            try {
                nArray[WdRiderEntity.ClassContextEntry.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WdRiderEntity.StructContextEntry.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WdRiderEntity.InterfaceContextEntry.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WdRiderEntity.PropertyContextEntry.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WdRiderEntity.MethodContextEntry.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WdRiderEntity.VariableContextEntry.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WdRiderEntity.EnumContextEntry.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WdRiderEntity.EnumEntryContextEntry.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

