/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.hub;

import com.intellij.ml.llm.core.chat.ui.NotificationUI;
import com.intellij.ml.llm.hub.AIHubNotificationManager;
import com.intellij.ml.llm.hub.statistics.AIHubLogger;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/hub/HubLogHelper;", "", "project", "Lcom/intellij/openapi/project/Project;", "notification", "Lcom/intellij/ml/llm/hub/AIHubNotificationManager$Notification;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/hub/AIHubNotificationManager$Notification;)V", "onShowNotification", "", "onCloseNotification", "onActionNotification", "actionType", "Lcom/intellij/ml/llm/core/chat/ui/NotificationUI$ActionType;", "logActionClicked", "action", "Lcom/intellij/ml/llm/hub/statistics/AIHubLogger$NotificationAction;", "intellij.ml.llm.core"})
@ApiStatus.Internal
public final class HubLogHelper {
    @NotNull
    private final Project project;
    @NotNull
    private final AIHubNotificationManager.Notification notification;

    public HubLogHelper(@NotNull Project project, @NotNull AIHubNotificationManager.Notification notification) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)notification), (String)"notification");
        this.project = project;
        this.notification = notification;
    }

    public final void onShowNotification() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.notification.ordinal()]) {
            case 1: {
                AIHubLogger.INSTANCE.logProTrialShown(this.project, AIHubLogger.NotificationTypeProTrialShown.TRIAL_EXPIRES_5_DAYS);
                break;
            }
            case 2: {
                AIHubLogger.INSTANCE.logProTrialShown(this.project, AIHubLogger.NotificationTypeProTrialShown.TRIAL_EXPIRED);
                break;
            }
            case 3: {
                AIHubLogger.INSTANCE.logProShown(this.project, AIHubLogger.NotificationTypeProShown.PRO_EXPIRES_5_DAYS);
                break;
            }
            case 4: {
                AIHubLogger.INSTANCE.logProShown(this.project, AIHubLogger.NotificationTypeProShown.PRO_EXPIRED);
                break;
            }
            case 5: {
                AIHubLogger.INSTANCE.logProShown(this.project, AIHubLogger.NotificationTypeProShown.PRO_EXPIRED_AND_TOP_UP_REMAINED);
                break;
            }
            case 6: {
                AIHubLogger.INSTANCE.logBusinessTrialShown(this.project, AIHubLogger.NotificationTypeBusinessTrialShown.EXPIRES_5_DAYS);
                break;
            }
            case 7: {
                AIHubLogger.INSTANCE.logBusinessTrialShown(this.project, AIHubLogger.NotificationTypeBusinessTrialShown.EXPIRED);
                break;
            }
            case 8: {
                AIHubLogger.INSTANCE.logBusinessShown(this.project, AIHubLogger.NotificationTypeBusinessShown.EXPIRES_5_DAYS);
                break;
            }
            case 9: {
                AIHubLogger.INSTANCE.logBusinessShown(this.project, AIHubLogger.NotificationTypeBusinessShown.EXPIRED);
                break;
            }
            case 10: {
                AIHubLogger.INSTANCE.logBusinessShown(this.project, AIHubLogger.NotificationTypeBusinessShown.EXPIRED_AND_TOP_UP_REMAINED);
                break;
            }
            case 11: {
                AIHubLogger.INSTANCE.logQuotaShown(this.project, AIHubLogger.NotificationTypeQuotaShown.FREE);
                break;
            }
            case 12: {
                AIHubLogger.INSTANCE.logQuotaShown(this.project, AIHubLogger.NotificationTypeQuotaShown.PRO);
                break;
            }
            case 13: {
                AIHubLogger.INSTANCE.logQuotaShown(this.project, AIHubLogger.NotificationTypeQuotaShown.PRO_TOP_UP);
                break;
            }
            case 14: {
                AIHubLogger.INSTANCE.logQuotaShown(this.project, AIHubLogger.NotificationTypeQuotaShown.PRO_TRIAL);
                break;
            }
            case 15: {
                AIHubLogger.INSTANCE.logQuotaShown(this.project, AIHubLogger.NotificationTypeQuotaShown.BUSINESS);
                break;
            }
            case 16: {
                AIHubLogger.INSTANCE.logQuotaShown(this.project, AIHubLogger.NotificationTypeQuotaShown.BUSINESS_TRIAL);
                break;
            }
            case 17: {
                AIHubLogger.INSTANCE.logQuotaShown(this.project, AIHubLogger.NotificationTypeQuotaShown.ULTIMATE);
                break;
            }
            case 18: {
                AIHubLogger.INSTANCE.logQuotaShown(this.project, AIHubLogger.NotificationTypeQuotaShown.ULTIMATE_TOP_UP);
                break;
            }
            case 19: {
                AIHubLogger.INSTANCE.logQuotaShown(this.project, AIHubLogger.NotificationTypeQuotaShown.ENTERPRISE);
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final void onCloseNotification() {
        this.logActionClicked(AIHubLogger.NotificationAction.CLOSE);
    }

    public final void onActionNotification(@NotNull NotificationUI.ActionType actionType) {
        AIHubLogger.NotificationAction notificationAction;
        Intrinsics.checkNotNullParameter((Object)((Object)actionType), (String)"actionType");
        switch (WhenMappings.$EnumSwitchMapping$1[actionType.ordinal()]) {
            case 1: {
                notificationAction = AIHubLogger.NotificationAction.UPGRADE_NOW;
                break;
            }
            case 2: {
                notificationAction = AIHubLogger.NotificationAction.RENEW_NOW;
                break;
            }
            case 3: {
                notificationAction = AIHubLogger.NotificationAction.UPGRADE_TO_ULTIMATE;
                break;
            }
            case 4: {
                notificationAction = AIHubLogger.NotificationAction.TOP_UP_CREDITS;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                return;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        AIHubLogger.NotificationAction action = notificationAction;
        this.logActionClicked(action);
    }

    private final void logActionClicked(AIHubLogger.NotificationAction action) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.notification.ordinal()]) {
            case 1: {
                AIHubLogger.INSTANCE.logProTrialActionClicked(this.project, AIHubLogger.NotificationTypeProTrialShown.TRIAL_EXPIRES_5_DAYS, action);
                break;
            }
            case 2: {
                AIHubLogger.INSTANCE.logProTrialActionClicked(this.project, AIHubLogger.NotificationTypeProTrialShown.TRIAL_EXPIRED, action);
                break;
            }
            case 3: {
                AIHubLogger.INSTANCE.logProActionClicked(this.project, AIHubLogger.NotificationTypeProShown.PRO_EXPIRES_5_DAYS, action);
                break;
            }
            case 4: {
                AIHubLogger.INSTANCE.logProActionClicked(this.project, AIHubLogger.NotificationTypeProShown.PRO_EXPIRED, action);
                break;
            }
            case 6: {
                AIHubLogger.INSTANCE.logBusinessTrialActionClicked(this.project, AIHubLogger.NotificationTypeBusinessTrialShown.EXPIRES_5_DAYS, action);
                break;
            }
            case 7: {
                AIHubLogger.INSTANCE.logBusinessTrialActionClicked(this.project, AIHubLogger.NotificationTypeBusinessTrialShown.EXPIRED, action);
                break;
            }
            case 8: {
                AIHubLogger.INSTANCE.logBusinessActionClicked(this.project, AIHubLogger.NotificationTypeBusinessShown.EXPIRES_5_DAYS, action);
                break;
            }
            case 9: {
                AIHubLogger.INSTANCE.logBusinessActionClicked(this.project, AIHubLogger.NotificationTypeBusinessShown.EXPIRED, action);
                break;
            }
            case 11: {
                AIHubLogger.INSTANCE.logQuotaActionClicked(this.project, AIHubLogger.NotificationTypeQuotaShown.FREE, action);
                break;
            }
            case 12: {
                AIHubLogger.INSTANCE.logQuotaActionClicked(this.project, AIHubLogger.NotificationTypeQuotaShown.PRO, action);
                break;
            }
            case 14: {
                AIHubLogger.INSTANCE.logQuotaActionClicked(this.project, AIHubLogger.NotificationTypeQuotaShown.PRO_TRIAL, action);
                break;
            }
            case 15: {
                AIHubLogger.INSTANCE.logQuotaActionClicked(this.project, AIHubLogger.NotificationTypeQuotaShown.BUSINESS, action);
                break;
            }
            case 16: {
                AIHubLogger.INSTANCE.logQuotaActionClicked(this.project, AIHubLogger.NotificationTypeQuotaShown.BUSINESS_TRIAL, action);
                break;
            }
            case 17: {
                AIHubLogger.INSTANCE.logQuotaActionClicked(this.project, AIHubLogger.NotificationTypeQuotaShown.ULTIMATE, action);
                break;
            }
            case 19: {
                AIHubLogger.INSTANCE.logQuotaActionClicked(this.project, AIHubLogger.NotificationTypeQuotaShown.ENTERPRISE, action);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[AIHubNotificationManager.Notification.values().length];
            try {
                nArray[AIHubNotificationManager.Notification.PRO_TRIAL_EXPIRING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.PRO_TRIAL_EXPIRED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.PRO_EXPIRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.PRO_EXPIRED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.PRO_EXPIRED_AND_TOP_UP_REMAINED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.BUSINESS_TRIAL_EXPIRING.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.BUSINESS_TRIAL_EXPIRED.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.BUSINESS_EXPIRING.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.BUSINESS_EXPIRED.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.BUSINESS_EXPIRED_AND_TOP_UP_REMAINED.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.FREE_QUOTA_EXCEEDED.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.PRO_QUOTA_EXCEEDED.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.PRO_TOP_UP_QUOTA_EXCEEDED.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.PRO_TRIAL_QUOTA_EXCEEDED.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.BUSINESS_QUOTA_EXCEEDED.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.BUSINESS_TRIAL_QUOTA_EXCEEDED.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.ULTIMATE_QUOTA_EXCEEDED.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.ULTIMATE_TOP_UP_QUOTA_EXCEEDED.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.ENTERPRISE_QUOTA_EXCEEDED.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.FREE_ENABLED.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.LICENSE_EXPIRED_AND_FREE_ENABLED.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.LICENSE_EXPIRED_AND_TOP_UP_REMAINED_AND_FREE_ENABLED.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.QUOTA_ALMOST_REACHED.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.THIRD_PARTY_PROVIDERS_BLOCKED.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.NO_LOCAL_MODELS.ordinal()] = 25;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AIHubNotificationManager.Notification.UPDATE_AVAILABLE.ordinal()] = 26;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[NotificationUI.ActionType.values().length];
            try {
                nArray[NotificationUI.ActionType.UPGRADE_NOW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotificationUI.ActionType.RENEW_NOW.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotificationUI.ActionType.UPGRADE_TO_ULTIMATE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotificationUI.ActionType.TOP_UP_CREDITS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotificationUI.ActionType.LOCAL_MODELS_SETUP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotificationUI.ActionType.LOCAL_MODELS_TURN_OFF.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotificationUI.ActionType.UPDATE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

