/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.refactorings;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManagerListener;
import com.intellij.codeInsight.lookup.impl.LookupCellRenderer;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeWithMe.ClientId;
import com.intellij.lang.Language;
import com.intellij.ml.llm.core.AIAssistantBranding;
import com.intellij.ml.llm.core.AIFirstUseKt;
import com.intellij.ml.llm.core.chat.services.AIAssistantServiceScope;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtil;
import com.intellij.ml.llm.core.refactoring.NameSuggestionContextProvider;
import com.intellij.ml.llm.core.settings.LLMSettingsManager;
import com.intellij.ml.llm.core.statistics.CommonLoggerService;
import com.intellij.ml.llm.core.statistics.CompositeStatisticsIdeActivity;
import com.intellij.ml.llm.core.statistics.ScoreResult;
import com.intellij.ml.llm.privacy.PrivacyPathCheckerKt;
import com.intellij.ml.llm.refactorings.LlmLookupContextProvider;
import com.intellij.ml.llm.refactorings.LlmLookupManagerListener;
import com.intellij.ml.llm.refactorings.LlmNameProviderKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import com.intellij.util.ui.EmptyIcon;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0016J2\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0082@\u00a2\u0006\u0002\u0010\u0015J2\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\fH\u0002J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/ml/llm/refactorings/LlmLookupManagerListener;", "Lcom/intellij/codeInsight/lookup/LookupManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "activeLookupChanged", "", "oldLookup", "Lcom/intellij/codeInsight/lookup/Lookup;", "newLookup", "findTargetElementAtCaret", "Lcom/intellij/psi/PsiElement;", "language", "Lcom/intellij/lang/Language;", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "editor", "Lcom/intellij/openapi/editor/Editor;", "targetElementUtil", "Lcom/intellij/codeInsight/TargetElementUtil;", "(Lcom/intellij/lang/Language;Lcom/intellij/codeInsight/lookup/impl/LookupImpl;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/codeInsight/TargetElementUtil;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getStandardNameSuggestions", "", "", "targetElement", "originalPosition", "getLlmLookupContextProvider", "Lcom/intellij/ml/llm/refactorings/LlmLookupContextProvider;", "isLanguageAtOffsetSupported", "", "LlmLookupElement", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nLlmLookupManagerListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LlmLookupManagerListener.kt\ncom/intellij/ml/llm/refactorings/LlmLookupManagerListener\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,182:1\n40#2,3:183\n1#3:186\n1#3:197\n1617#4,9:187\n1869#4:196\n1870#4:198\n1626#4:199\n*S KotlinDebug\n*F\n+ 1 LlmLookupManagerListener.kt\ncom/intellij/ml/llm/refactorings/LlmLookupManagerListener\n*L\n42#1:183,3\n127#1:197\n127#1:187,9\n127#1:196\n127#1:198\n127#1:199\n*E\n"})
public final class LlmLookupManagerListener
implements LookupManagerListener {
    @NotNull
    private final Project project;

    public LlmLookupManagerListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public void activeLookupChanged(@Nullable Lookup oldLookup, @Nullable Lookup newLookup) {
        Language language;
        Class<Object> clazz;
        Integer originalElement;
        Integer n;
        CommonLoggerService loggerService;
        TargetElementUtil targetElementUtil;
        Editor editor;
        LookupImpl lookup;
        block13: {
            block12: {
                boolean $i$f$service = false;
                Class<LLMSettingsManager> serviceClass$iv = LLMSettingsManager.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                LLMSettingsManager llmSettingsManager = (LLMSettingsManager)object;
                if (!llmSettingsManager.isNameSuggestionsEnabled()) {
                    return;
                }
                LookupImpl lookupImpl = newLookup instanceof LookupImpl ? (LookupImpl)newLookup : null;
                if (lookupImpl == null) {
                    return;
                }
                lookup = lookupImpl;
                if (PrivacyPathCheckerKt.isAiIgnoreBlocked((Project)this.project, (PsiFile)lookup.getPsiFile())) {
                    return;
                }
                Editor editor2 = lookup.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                editor = editor2;
                if (TemplateManager.getInstance((Project)this.project).getActiveTemplate(editor) == null) {
                    return;
                }
                targetElementUtil = TargetElementUtil.getInstance();
                if (!AIFirstUseKt.isMockResponseEnabled() && !AIAssistantUIUtil.INSTANCE.isAssistantActive(this.project)) {
                    return;
                }
                loggerService = CommonLoggerService.Companion.getInstance();
                Integer n2 = lookup.getLookupOriginalStart();
                int it = ((Number)n2).intValue();
                boolean bl = false;
                n = it > -1 ? n2 : null;
                if (n == null) break block12;
                int it2 = ((Number)n).intValue();
                boolean bl2 = false;
                PsiFile psiFile = lookup.getPsiFile();
                Object object2 = psiFile != null ? psiFile.findElementAt(it2) : null;
                n = object2;
                if (object2 != null) break block13;
            }
            n = lookup.getPsiElement();
        }
        Integer it = originalElement = n;
        boolean bl = false;
        if (it instanceof LeafPsiElement || it instanceof PsiWhiteSpace) {
            PsiElement psiElement = it.getParent();
            clazz = psiElement != null ? psiElement.getClass() : null;
        } else {
            Integer n3 = it;
            clazz = n3 != null ? n3.getClass() : null;
        }
        Class<PsiElement> clazz2 = clazz;
        PsiElement psiElement = lookup.getPsiElement();
        Object object = language = psiElement != null ? psiElement.getLanguage() : null;
        if (!this.isLanguageAtOffsetSupported(editor)) {
            return;
        }
        CompositeStatisticsIdeActivity statistic = loggerService.logNameSuggestionStarted(this.project, clazz2, language);
        lookup.addPresentationCustomizer(new LookupCellRenderer.ItemPresentationCustomizer(){

            public LookupElementPresentation customizePresentation(LookupElement item, LookupElementPresentation presentation) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
                if (!(item instanceof LlmLookupElement) && presentation.getIcon() == null) {
                    LookupElementPresentation lookupElementPresentation;
                    LookupElementPresentation newPresentation = lookupElementPresentation = new LookupElementPresentation();
                    boolean bl = false;
                    newPresentation.copyFrom(presentation);
                    newPresentation.setIcon(EmptyIcon.ICON_16);
                    return lookupElementPresentation;
                }
                return presentation;
            }

            public Icon customizeEmptyIcon(Icon emptyIcon) {
                Icon icon;
                Intrinsics.checkNotNullParameter((Object)emptyIcon, (String)"emptyIcon");
                if (emptyIcon.getIconWidth() < EmptyIcon.ICON_16.getIconWidth()) {
                    Icon icon2 = EmptyIcon.ICON_16;
                    icon = icon2;
                    Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"ICON_16");
                } else {
                    icon = emptyIcon;
                }
                return icon;
            }
        });
        Job updatingLookupJob2 = BuildersKt.launch$default((CoroutineScope)AIAssistantServiceScope.Companion.getScope(this.project), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, language, lookup, editor, targetElementUtil, loggerService, statistic, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            Object L$6;
            Object L$7;
            Object L$8;
            Object L$9;
            Object L$10;
            Object L$11;
            Object L$12;
            int I$0;
            int I$1;
            int I$2;
            long J$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ LlmLookupManagerListener this$0;
            final /* synthetic */ Language $language;
            final /* synthetic */ LookupImpl $lookup;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ TargetElementUtil $targetElementUtil;
            final /* synthetic */ CommonLoggerService $loggerService;
            final /* synthetic */ CompositeStatisticsIdeActivity $statistic;
            {
                this.this$0 = $receiver;
                this.$language = $language;
                this.$lookup = $lookup;
                this.$editor = $editor;
                this.$targetElementUtil = $targetElementUtil;
                this.$loggerService = $loggerService;
                this.$statistic = $statistic;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var22_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = $this$launch;
                        this.label = 1;
                        v0 = CoroutinesKt.edtWriteAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.codeInsight.lookup.impl.LookupImpl ), ()Lkotlin/Unit;)((LookupImpl)this.$lookup), (Continuation)((Continuation)this));
                        if (v0 == var22_3) {
                            return var22_3;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        if (AIFirstUseKt.isMockResponseEnabled() || AIAssistantUIUtil.INSTANCE.isAssistantActive(LlmLookupManagerListener.access$getProject$p(this.this$0))) break;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                        this.label = 2;
                        v1 = CoroutinesKt.edtWriteAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$1(com.intellij.codeInsight.lookup.impl.LookupImpl ), ()Lkotlin/Unit;)((LookupImpl)this.$lookup), (Continuation)((Continuation)this));
                        if (v1 == var22_3) {
                            return var22_3;
                        }
                        ** GOTO lbl25
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl25:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                var4_4 = this.$targetElementUtil;
                Intrinsics.checkNotNull((Object)var4_4);
                this.L$0 = $this$launch;
                this.label = 3;
                v2 = LlmLookupManagerListener.access$findTargetElementAtCaret(this.this$0, this.$language, this.$lookup, this.$editor, var4_4, (Continuation)this);
                if (v2 == var22_3) {
                    return var22_3;
                }
                ** GOTO lbl37
                {
                    case 3: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl37:
                        // 2 sources

                        if ((targetElement = (PsiElement)v2) != null) break;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)targetElement);
                        this.label = 4;
                        v3 = CoroutinesKt.edtWriteAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$2(com.intellij.codeInsight.lookup.impl.LookupImpl ), ()Lkotlin/Unit;)((LookupImpl)this.$lookup), (Continuation)((Continuation)this));
                        if (v3 == var22_3) {
                            return var22_3;
                        }
                        ** GOTO lbl49
                    }
                    case 4: {
                        targetElement = (PsiElement)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl49:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                var5_7 = this.this$0;
                var6_10 = this.$statistic;
                $i$f$measureTimeMillisWithResult = 0;
                start$iv = System.currentTimeMillis();
                $i$a$-measureTimeMillisWithResult-LlmLookupManagerListener$activeLookupChanged$updatingLookupJob$1$4 = 0;
                this.L$0 = $this$launch;
                this.L$1 = targetElement;
                this.I$0 = $i$f$measureTimeMillisWithResult;
                this.J$0 = start$iv;
                this.I$1 = $i$a$-measureTimeMillisWithResult-LlmLookupManagerListener$activeLookupChanged$updatingLookupJob$1$4;
                this.label = 5;
                v4 = LlmNameProviderKt.suggestNames(LlmLookupManagerListener.access$getProject$p(var5_7), targetElement, null, var6_10, (Continuation<? super List<String>>)this);
                if (v4 == var22_3) {
                    return var22_3;
                }
                ** GOTO lbl72
                {
                    case 5: {
                        $i$a$-measureTimeMillisWithResult-LlmLookupManagerListener$activeLookupChanged$updatingLookupJob$1$4 = this.I$1;
                        start$iv = this.J$0;
                        $i$f$measureTimeMillisWithResult = this.I$0;
                        targetElement = (PsiElement)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl72:
                        // 2 sources

                        result$iv = (List)v4;
                        var4_4 = new Pair((Object)Boxing.boxLong((long)(System.currentTimeMillis() - start$iv)), (Object)result$iv);
                        duration = ((Number)var4_4.component1()).longValue();
                        suggestedNames = (List)var4_4.component2();
                        this.L$0 = $this$launch;
                        this.L$1 = targetElement;
                        this.L$2 = suggestedNames;
                        this.J$0 = duration;
                        this.label = 6;
                        v5 = CoroutinesKt.smartReadAction((Project)LlmLookupManagerListener.access$getProject$p(this.this$0), (Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$4(com.intellij.psi.PsiElement ), ()Lcom/intellij/lang/Language;)((PsiElement)targetElement), (Continuation)((Continuation)this));
                        if (v5 == var22_3) {
                            return var22_3;
                        }
                        ** GOTO lbl91
                    }
                    case 6: {
                        duration = this.J$0;
                        suggestedNames = (List)this.L$2;
                        targetElement = (PsiElement)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
lbl91:
                        // 2 sources

                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"smartReadAction(...)");
                        targetElementLanguage = (Language)v5;
                        this.$loggerService.logSendNameSuggestionResponse(this.$statistic, duration, CollectionsKt.joinToString$default((Iterable)suggestedNames, (CharSequence)",", null, null, (int)0, null, null, (int)62, null), targetElement, targetElementLanguage);
                        standardSuggestions = BuildersKt.async$default((CoroutineScope)$this$launch, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Set<? extends String>>, Object>(this.this$0, targetElementLanguage, this.$lookup, targetElement, null){
                            int label;
                            final /* synthetic */ LlmLookupManagerListener this$0;
                            final /* synthetic */ Language $targetElementLanguage;
                            final /* synthetic */ LookupImpl $lookup;
                            final /* synthetic */ PsiElement $targetElement;
                            {
                                this.this$0 = $receiver;
                                this.$targetElementLanguage = $targetElementLanguage;
                                this.$lookup = $lookup;
                                this.$targetElement = $targetElement;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = CoroutinesKt.smartReadAction((Project)LlmLookupManagerListener.access$getProject$p(this.this$0), () -> activeLookupChanged.updatingLookupJob.standardSuggestions.1.invokeSuspend$lambda$0(this.this$0, this.$targetElementLanguage, this.$lookup, this.$targetElement), (Continuation)((Continuation)this));
                                        if (object2 != object) return object2;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return object2;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Set<String>> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            private static final Set invokeSuspend$lambda$0(LlmLookupManagerListener this$0, Language $targetElementLanguage, LookupImpl $lookup, PsiElement $targetElement) {
                                return LlmLookupManagerListener.access$getStandardNameSuggestions(this$0, $targetElementLanguage, $lookup, $targetElement, $lookup.getPsiElement());
                            }
                        }), (int)3, null);
                        if (this.$lookup.isLookupDisposed()) ** GOTO lbl264
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                        this.L$1 = targetElement;
                        this.L$2 = suggestedNames;
                        this.L$3 = targetElementLanguage;
                        this.L$4 = standardSuggestions;
                        this.J$0 = duration;
                        this.label = 7;
                        v6 = CoroutinesKt.smartReadAction((Project)LlmLookupManagerListener.access$getProject$p(this.this$0), (Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$5(com.intellij.psi.PsiElement ), ()Ljava/lang/String;)((PsiElement)targetElement), (Continuation)((Continuation)this));
                        if (v6 == var22_3) {
                            return var22_3;
                        }
                        ** GOTO lbl115
                    }
                    case 7: {
                        duration = this.J$0;
                        standardSuggestions = (Deferred)this.L$4;
                        targetElementLanguage = (Language)this.L$3;
                        suggestedNames = (List)this.L$2;
                        targetElement = (PsiElement)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v6 = $result;
lbl115:
                        // 2 sources

                        originalName = (String)v6;
                        var12_23 = suggestedNames;
                        $i$f$filter = 0;
                        var14_26 = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = 0;
                        var17_31 = $this$filterTo$iv$iv.iterator();
lbl123:
                        // 3 sources

                        while (var17_31.hasNext()) {
                            element$iv$iv = var17_31.next();
                            it = (String)element$iv$iv;
                            $i$a$-filter-LlmLookupManagerListener$activeLookupChanged$updatingLookupJob$1$uniqNames$1 = 0;
                            if (Intrinsics.areEqual((Object)it, (Object)originalName)) ** GOTO lbl-1000
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                            this.L$1 = targetElement;
                            this.L$2 = SpillingKt.nullOutSpilledVariable((Object)suggestedNames);
                            this.L$3 = targetElementLanguage;
                            this.L$4 = standardSuggestions;
                            this.L$5 = originalName;
                            this.L$6 = SpillingKt.nullOutSpilledVariable((Object)$this$filter$iv);
                            this.L$7 = SpillingKt.nullOutSpilledVariable((Object)$this$filterTo$iv$iv);
                            this.L$8 = destination$iv$iv;
                            this.L$9 = var17_31;
                            this.L$10 = element$iv$iv;
                            this.L$11 = it;
                            this.J$0 = duration;
                            this.I$0 = $i$f$filter;
                            this.I$1 = $i$f$filterTo;
                            this.I$2 = $i$a$-filter-LlmLookupManagerListener$activeLookupChanged$updatingLookupJob$1$uniqNames$1;
                            this.label = 8;
                            v7 = standardSuggestions.await((Continuation)this);
                            if (v7 == var22_3) {
                                return var22_3;
                            }
                            ** GOTO lbl168
                        }
                        break;
                    }
                    case 8: {
                        $i$a$-filter-LlmLookupManagerListener$activeLookupChanged$updatingLookupJob$1$uniqNames$1 = this.I$2;
                        $i$f$filterTo = this.I$1;
                        $i$f$filter = this.I$0;
                        duration = this.J$0;
                        it = (String)this.L$11;
                        element$iv$iv = this.L$10;
                        var17_31 = (Iterator<T>)this.L$9;
                        destination$iv$iv = (Collection)this.L$8;
                        $this$filterTo$iv$iv = (Iterable)this.L$7;
                        $this$filter$iv = (Iterable)this.L$6;
                        originalName = (String)this.L$5;
                        standardSuggestions = (Deferred)this.L$4;
                        targetElementLanguage = (Language)this.L$3;
                        suggestedNames = (List)this.L$2;
                        targetElement = (PsiElement)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v7 = $result;
lbl168:
                        // 2 sources

                        if (!((Set)v7).contains(it)) {
                            v8 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v8 = false;
                        }
                        if (!v8) ** GOTO lbl123
                        destination$iv$iv.add(element$iv$iv);
                        ** GOTO lbl123
                    }
                }
                $this$filter$iv = (List)destination$iv$iv;
                var13_25 = this.this$0;
                $i$f$filter = 0;
                destination$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = 0;
                var18_33 = $this$filterTo$iv$iv.iterator();
lbl183:
                // 3 sources

                while (var18_33.hasNext()) {
                    element$iv$iv = var18_33.next();
                    it = (String)element$iv$iv;
                    $i$a$-filter-LlmLookupManagerListener$activeLookupChanged$updatingLookupJob$1$uniqNames$2 = 0;
                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                    this.L$1 = targetElement;
                    this.L$2 = SpillingKt.nullOutSpilledVariable((Object)suggestedNames);
                    this.L$3 = targetElementLanguage;
                    this.L$4 = SpillingKt.nullOutSpilledVariable((Object)standardSuggestions);
                    this.L$5 = SpillingKt.nullOutSpilledVariable((Object)originalName);
                    this.L$6 = SpillingKt.nullOutSpilledVariable((Object)$this$filter$iv);
                    this.L$7 = var13_25;
                    this.L$8 = SpillingKt.nullOutSpilledVariable((Object)$this$filterTo$iv$iv);
                    this.L$9 = destination$iv$iv;
                    this.L$10 = var18_33;
                    this.L$11 = element$iv$iv;
                    this.L$12 = SpillingKt.nullOutSpilledVariable((Object)it);
                    this.J$0 = duration;
                    this.I$0 = $i$f$filter;
                    this.I$1 = $i$f$filterTo;
                    this.I$2 = $i$a$-filter-LlmLookupManagerListener$activeLookupChanged$updatingLookupJob$1$uniqNames$2;
                    this.label = 9;
                    v9 = NameSuggestionContextProvider.Companion.isNameValid(LlmLookupManagerListener.access$getProject$p(var13_25), it, targetElement, (Continuation<? super Boolean>)this);
                    if (v9 == var22_3) {
                        return var22_3;
                    }
                    ** GOTO lbl229
                }
                {
                    break;
                    case 9: {
                        $i$a$-filter-LlmLookupManagerListener$activeLookupChanged$updatingLookupJob$1$uniqNames$2 = this.I$2;
                        $i$f$filterTo = this.I$1;
                        $i$f$filter = this.I$0;
                        duration = this.J$0;
                        it = (String)this.L$12;
                        element$iv$iv = this.L$11;
                        var18_33 = (Iterator<T>)this.L$10;
                        destination$iv$iv = (Collection)this.L$9;
                        $this$filterTo$iv$iv = (Iterable)this.L$8;
                        var13_25 = (LlmLookupManagerListener)this.L$7;
                        $this$filter$iv = (Iterable)this.L$6;
                        originalName = (String)this.L$5;
                        standardSuggestions = (Deferred)this.L$4;
                        targetElementLanguage = (Language)this.L$3;
                        suggestedNames = (List)this.L$2;
                        targetElement = (PsiElement)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v9 = $result;
lbl229:
                        // 2 sources

                        if (!((Boolean)v9).booleanValue()) ** GOTO lbl183
                        destination$iv$iv.add(element$iv$iv);
                        ** GOTO lbl183
                    }
                }
                uniqNames = (List)destination$iv$iv;
                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                this.L$1 = targetElement;
                this.L$2 = SpillingKt.nullOutSpilledVariable((Object)suggestedNames);
                this.L$3 = targetElementLanguage;
                this.L$4 = SpillingKt.nullOutSpilledVariable((Object)standardSuggestions);
                this.L$5 = SpillingKt.nullOutSpilledVariable((Object)originalName);
                this.L$6 = SpillingKt.nullOutSpilledVariable((Object)uniqNames);
                this.L$7 = null;
                this.L$8 = null;
                this.L$9 = null;
                this.L$10 = null;
                this.L$11 = null;
                this.L$12 = null;
                this.J$0 = duration;
                this.label = 10;
                v10 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((List<String>)uniqNames, this.$lookup, null){
                    int label;
                    final /* synthetic */ List<String> $uniqNames;
                    final /* synthetic */ LookupImpl $lookup;
                    {
                        this.$uniqNames = $uniqNames;
                        this.$lookup = $lookup;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void $this$forEach$iv;
                                void $this$mapTo$iv$iv;
                                ResultKt.throwOnFailure((Object)$result);
                                Iterable $this$map$iv = this.$uniqNames;
                                boolean $i$f$map = false;
                                Iterable iterable = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void it;
                                    String string = (String)item$iv$iv;
                                    Collection collection = destination$iv$iv;
                                    boolean bl = false;
                                    collection.add(new LlmLookupElement((String)it));
                                }
                                $this$map$iv = (List)destination$iv$iv;
                                LookupImpl lookupImpl = this.$lookup;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    LlmLookupElement it = (LlmLookupElement)((Object)element$iv);
                                    boolean bl = false;
                                    lookupImpl.addItem((LookupElement)it, PrefixMatcher.ALWAYS_TRUE);
                                }
                                this.$lookup.setCalculating(false);
                                this.$lookup.refreshUi(true, false);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)((Continuation)this));
                if (v10 == var22_3) {
                    return var22_3;
                }
                ** GOTO lbl263
                {
                    case 10: {
                        duration = this.J$0;
                        uniqNames = (List)this.L$6;
                        originalName = (String)this.L$5;
                        standardSuggestions = (Deferred)this.L$4;
                        targetElementLanguage = (Language)this.L$3;
                        suggestedNames = (List)this.L$2;
                        targetElement = (PsiElement)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v10 = $result;
lbl263:
                        // 2 sources

                        this.$loggerService.logShowNameSuggestions(this.$statistic, targetElement, targetElementLanguage);
lbl264:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(LookupImpl $lookup) {
                $lookup.setCalculating(true);
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$1(LookupImpl $lookup) {
                $lookup.setCalculating(false);
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$2(LookupImpl $lookup) {
                $lookup.setCalculating(false);
                return Unit.INSTANCE;
            }

            private static final Language invokeSuspend$lambda$4(PsiElement $targetElement) {
                return $targetElement.getLanguage();
            }

            private static final String invokeSuspend$lambda$5(PsiElement $targetElement) {
                Object object = $targetElement instanceof PsiNamedElement ? (PsiNamedElement)$targetElement : null;
                if (object == null || (object = object.getName()) == null) {
                    object = $targetElement.getText();
                }
                return object;
            }
        }), (int)2, null);
        lookup.addLookupListener(new LookupListener(updatingLookupJob2, loggerService, statistic, clazz2, language, editor){
            final /* synthetic */ Job $updatingLookupJob;
            final /* synthetic */ CommonLoggerService $loggerService;
            final /* synthetic */ CompositeStatisticsIdeActivity $statistic;
            final /* synthetic */ Class<PsiElement> $clazz;
            final /* synthetic */ Language $language;
            final /* synthetic */ Editor $editor;
            {
                this.$updatingLookupJob = $updatingLookupJob;
                this.$loggerService = $loggerService;
                this.$statistic = $statistic;
                this.$clazz = $clazz;
                this.$language = $language;
                this.$editor = $editor;
            }

            public void lookupCanceled(LookupEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Job.DefaultImpls.cancel$default((Job)this.$updatingLookupJob, null, (int)1, null);
                this.$loggerService.logNameSuggestionFinished(this.$statistic, null, ScoreResult.NO, this.$clazz, this.$language);
            }

            public void itemSelected(LookupEvent event) {
                String lookupString;
                LookupElement item;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Job.DefaultImpls.cancel$default((Job)this.$updatingLookupJob, null, (int)1, null);
                LookupElement lookupElement = item = event.getItem();
                String string = lookupString = lookupElement != null ? lookupElement.getLookupString() : null;
                if (item instanceof LlmLookupElement) {
                    this.$loggerService.logNameSuggestionFinished(this.$statistic, lookupString, ScoreResult.YES, this.$clazz, this.$language);
                    ((LlmLookupElement)item).handleInsert(this.$editor);
                } else {
                    this.$loggerService.logNameSuggestionFinished(this.$statistic, lookupString, ScoreResult.NO, this.$clazz, this.$language);
                }
            }
        });
    }

    private final Object findTargetElementAtCaret(Language language, LookupImpl lookup, Editor editor, TargetElementUtil targetElementUtil, Continuation<? super PsiElement> $completion) {
        return CoroutinesKt.smartReadAction((Project)this.project, () -> LlmLookupManagerListener.findTargetElementAtCaret$lambda$4(this, language, editor, lookup, targetElementUtil), $completion);
    }

    private final Set<String> getStandardNameSuggestions(Language language, LookupImpl lookup, PsiElement targetElement, PsiElement originalPosition) {
        Set set;
        LlmLookupContextProvider contextProvider = this.getLlmLookupContextProvider(language);
        if (contextProvider == null) {
            Set result2 = new LinkedHashSet();
            NameSuggestionProvider.suggestNames((PsiElement)targetElement, (PsiElement)originalPosition, (Set)result2);
            set = result2;
        } else {
            set = contextProvider.provideStandardSuggestions(lookup);
        }
        return set;
    }

    private final LlmLookupContextProvider getLlmLookupContextProvider(Language language) {
        return language != null ? (LlmLookupContextProvider)LlmLookupContextProvider.Companion.getEP_NAME().forLanguage(language) : null;
    }

    private final boolean isLanguageAtOffsetSupported(Editor editor) {
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            Language language;
            Intrinsics.checkNotNullExpressionValue((Object)PsiUtilCore.getLanguageAtOffset((PsiFile)PsiEditorUtil.getPsiFile((Editor)editor), (int)caret.getOffset()), (String)"getLanguageAtOffset(...)");
            if (!NameSuggestionContextProvider.Companion.isSupportedForLanguage(language)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final PsiElement findTargetElementAtCaret$lambda$4(LlmLookupManagerListener this$0, Language $language, Editor $editor, LookupImpl $lookup, TargetElementUtil $targetElementUtil) {
        PsiElement psiElement;
        LlmLookupContextProvider contextProvider = this$0.getLlmLookupContextProvider($language);
        if (contextProvider == null) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            List list = $editor.getCaretModel().getAllCarets();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllCarets(...)");
            Iterable iterable = list;
            boolean $i$f$mapNotNull = false;
            void var8_8 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                PsiElement it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Caret it = (Caret)element$iv$iv;
                boolean bl2 = false;
                if ($targetElementUtil.findTargetElement($editor, $targetElementUtil.getAllAccepted(), it.getOffset()) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            psiElement = (PsiElement)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
        } else {
            psiElement = contextProvider.provideTargetElement($lookup);
        }
        return psiElement;
    }

    public static final /* synthetic */ Project access$getProject$p(LlmLookupManagerListener $this) {
        return $this.project;
    }

    public static final /* synthetic */ Object access$findTargetElementAtCaret(LlmLookupManagerListener $this, Language language, LookupImpl lookup, Editor editor, TargetElementUtil targetElementUtil, Continuation $completion) {
        return $this.findTargetElementAtCaret(language, lookup, editor, targetElementUtil, (Continuation<? super PsiElement>)$completion);
    }

    public static final /* synthetic */ Set access$getStandardNameSuggestions(LlmLookupManagerListener $this, Language language, LookupImpl lookup, PsiElement targetElement, PsiElement originalPosition) {
        return $this.getStandardNameSuggestions(language, lookup, targetElement, originalPosition);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/refactorings/LlmLookupManagerListener$LlmLookupElement;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "lookup", "", "<init>", "(Ljava/lang/String;)V", "getLookupString", "handleInsert", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "renderElement", "presentation", "Lcom/intellij/codeInsight/lookup/LookupElementPresentation;", "intellij.ml.llm.core"})
    public static final class LlmLookupElement
    extends LookupElement {
        @NotNull
        private final String lookup;

        public LlmLookupElement(@NotNull String lookup) {
            Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
            this.lookup = lookup;
        }

        @NotNull
        public String getLookupString() {
            return this.lookup;
        }

        public final void handleInsert(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)editor);
            if (templateState == null) {
                return;
            }
            TemplateState templateState2 = templateState;
            if (!templateState2.isFinished()) {
                templateState2.update();
                templateState2.considerNextTabOnLookupItemSelected((LookupElement)this);
            }
        }

        public void renderElement(@NotNull LookupElementPresentation presentation) {
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            presentation.setIcon(AIAssistantBranding.Logo16Colored);
            super.renderElement(presentation);
        }
    }
}

