/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.ds.latest.agents.letsPlotEda.service;

import com.intellij.charts.dataframe.DataFrame;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.editor.TableEditorBase;
import com.intellij.dataspell.jupyter.customCells.visualization.letsPlot.LetsPlotGridModelUtil;
import com.intellij.grid.charts.impl.DataGridConversionUtil;
import com.intellij.jupyter.core.jupyter.editor.JupyterFileEditor;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.ml.llm.ds.latest.agents.letsPlotEda.models.LetsPlotEDAModel;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.python.scientific.powerfuldataviewer.editor.DataViewFileEditor;
import com.intellij.scientific.tables.api.DSDataFrameInfo;
import com.intellij.scientific.tables.api.DSTableDataProvider;
import com.intellij.scientific.tables.api.DSTableOutputData;
import com.intellij.scientific.tables.api.TableDataProviderFactory;
import com.intellij.scientific.tables.editor.DSTableFileEditor;
import com.intellij.scientific.tables.editor.DsTablePanel;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\b\u001a\u0004\u0018\u00010\tH\u0000\u00a2\u0006\u0002\b\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/ds/latest/agents/letsPlotEda/service/LetsPlotEDAService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "modelIdCounter", "", "findLetsPlotEDA", "Lcom/intellij/ml/llm/ds/latest/agents/letsPlotEda/models/LetsPlotEDAModel;", "findLetsPlotEDA$intellij_ml_llm_ds_latest", "Companion", "intellij.ml.llm.ds.latest"})
@SourceDebugExtension(value={"SMAP\nLetsPlotEDAService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LetsPlotEDAService.kt\ncom/intellij/ml/llm/ds/latest/agents/letsPlotEda/service/LetsPlotEDAService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,115:1\n1#2:116\n14#3:117\n*S KotlinDebug\n*F\n+ 1 LetsPlotEDAService.kt\ncom/intellij/ml/llm/ds/latest/agents/letsPlotEda/service/LetsPlotEDAService\n*L\n94#1:117\n*E\n"})
public final class LetsPlotEDAService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private int modelIdCounter;
    @NotNull
    private static final Logger logger;

    public LetsPlotEDAService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Nullable
    public final LetsPlotEDAModel findLetsPlotEDA$intellij_ml_llm_ds_latest() {
        LetsPlotEDAModel letsPlotEDAModel;
        DataFrame dataFrame;
        FileEditor selectedEditor;
        logger.warn("Finding Lets-Plot EDA context");
        JupyterCell visualizationCell = null;
        FileEditor fileEditor = selectedEditor = FileEditorManager.getInstance((Project)this.project).getSelectedEditor();
        if (fileEditor instanceof DSTableFileEditor) {
            JComponent jComponent = ((DSTableFileEditor)selectedEditor).getComponent();
            Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.scientific.tables.editor.DsTablePanel");
            DsTablePanel tablePanel = (DsTablePanel)jComponent;
            LetsPlotEDAService.Companion.loadDataFromDsTablePanel(this.project, tablePanel);
            v1 = null;
        } else if (fileEditor instanceof TableEditorBase) {
            DataGrid dataGrid = ((TableEditorBase)selectedEditor).getDataGrid();
            Intrinsics.checkNotNullExpressionValue((Object)dataGrid, (String)"getDataGrid(...)");
            dataGrid = dataGrid;
            v1 = DataGridConversionUtil.INSTANCE.getDataFrameFromDataGrid(dataGrid);
        } else if (fileEditor instanceof DataViewFileEditor) {
            DataGrid dataGrid = dataGrid = (DataGrid)((DataViewFileEditor)selectedEditor).getDataViewerPanel().getGridMutableStateFlow().getValue();
            if (dataGrid != null) {
                DataGrid it = dataGrid;
                boolean bl = false;
                v1 = DataGridConversionUtil.INSTANCE.getDataFrameFromDataGrid(it);
            } else {
                v1 = null;
            }
        } else if (fileEditor instanceof JupyterFileEditor) {
            JupyterCell jupyterCell;
            JupyterHelper jupyterHelper = JupyterHelper.INSTANCE;
            Editor editor = ((JupyterFileEditor)selectedEditor).getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            List selectedIntervals = jupyterHelper.getSelectedIntervals(editor);
            Editor editor2 = ((JupyterFileEditor)selectedEditor).getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
            JupyterNotebook notebook = jupyterHelper.getJupyterNotebook(editor2);
            List list = selectedIntervals;
            if (list != null && (list = (NotebookCellLines.Interval)CollectionsKt.firstOrNull((List)list)) != null) {
                List interval = list;
                boolean bl = false;
                JupyterNotebook jupyterNotebook = notebook;
                jupyterCell = jupyterNotebook != null ? jupyterNotebook.getCellOrNull(interval.getOrdinal()) : null;
            } else {
                jupyterCell = null;
            }
            JupyterCell cell = jupyterCell;
            VirtualFile notebookVirtualFile = ((JupyterFileEditor)selectedEditor).getNotebookFile();
            if (cell != null && cell.getCellType() == JupyterCellType.VISUALIZATION) {
                DataFrame dataFrame2 = LetsPlotGridModelUtil.INSTANCE.createDataFrameFromPyDebugValue(cell, this.project, notebookVirtualFile);
                if (dataFrame2 == null) {
                    return null;
                }
                DataFrame dataFrame3 = dataFrame2;
                visualizationCell = cell;
                v1 = dataFrame3;
            } else {
                logger.warn("No selected Jupyter cell with Visualization type");
                v1 = null;
            }
        } else {
            v1 = dataFrame = null;
        }
        if (dataFrame != null) {
            logger.warn("Loaded data info: " + dataFrame.getColumns());
        } else if (selectedEditor != null) {
            logger.warn("Unable to load data info from " + Reflection.getOrCreateKotlinClass(selectedEditor.getClass()).getSimpleName() + ".");
        } else {
            logger.warn("Unable to load data info.");
        }
        DataFrame dataFrame4 = dataFrame;
        if (dataFrame4 != null) {
            DataFrame it = dataFrame4;
            boolean bl = false;
            int n = this.modelIdCounter;
            this.modelIdCounter = n + 1;
            LetsPlotEDAModel letsPlotEDAModel2 = new LetsPlotEDAModel(StringsKt.padStart((String)String.valueOf(n), (int)3, (char)'0'), it, visualizationCell);
            letsPlotEDAModel = letsPlotEDAModel2;
        } else {
            letsPlotEDAModel = null;
        }
        return letsPlotEDAModel;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LetsPlotEDAService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LetsPlotEDAService.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/ds/latest/agents/letsPlotEda/service/LetsPlotEDAService$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "loadDataFromDsTablePanel", "", "project", "Lcom/intellij/openapi/project/Project;", "tablePanel", "Lcom/intellij/scientific/tables/editor/DsTablePanel;", "intellij.ml.llm.ds.latest"})
    public static final class Companion {
        private Companion() {
        }

        private final void loadDataFromDsTablePanel(Project project, DsTablePanel tablePanel) {
            DSTableOutputData data2 = tablePanel.getTableVirtualFile().getOutputData();
            if (data2 != null) {
                DSTableDataProvider provider = TableDataProviderFactory.Companion.getTableDataProvider(project, data2.getDataType(), data2.getTableText());
                DSDataFrameInfo frameInfo = provider.parseStaticTableToFrameInfo(data2.getTableText().getStaticTableText());
                logger.warn("Loaded frame info: " + frameInfo + " ");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

