/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.common;

import ai.grazie.nlp.patterns.AggregatedPattern;
import ai.grazie.nlp.patterns.Pattern;
import ai.grazie.nlp.patterns.ext.AbbreviationPatterns;
import ai.grazie.nlp.patterns.standard.LikelyPatterns;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.PairedPunctuation;
import ai.grazie.rules.common.Quotes;
import ai.grazie.rules.common.TreeMigration;
import ai.grazie.rules.common.ZeroWidthSpaceRule;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.Parameter;
import ai.grazie.rules.tree.TextRange;
import ai.grazie.rules.tree.Tree;
import ai.grazie.rules.tree.TreeCache;
import ai.grazie.rules.tree.TreeSupport;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.Nullable;

public class FormattingIssues {
    private static final NodePattern anyQuote = NodePattern.N.form("['\"\u201c\u201d\u201e\u00ab\u00bb`\u2018\u2019]\\)?");
    public static final NodePattern capitalizedDotCapitalized = NodePattern.N.formCaseSensitive("\\p{Lu}\\p{Ll}+").withNeighbor(1, CommonPatterns.dot).withNeighbor(2, NodePattern.N.formCaseSensitive("\\p{Lu}\\p{Ll}+"));
    public static final NodePattern latinWordDotCapitalized1 = NodePattern.N.formCaseSensitive("[a-zA-Z]+\\.[A-Z][a-zA-Z]*").noFormCaseSensitive("[A-Z]+\\.[A-Z]+");
    public static final NodePattern latinWordDotCapitalized3 = NodePattern.N.formCaseSensitive("[a-zA-Z]+").withNeighbor(1, CommonPatterns.dot).withNeighbor(2, NodePattern.N.formCaseSensitive("[A-Z][a-zA-Z]*"));
    public static final NodePattern hyphenTextHighlightingStart = CommonPatterns.HYPHEN_NODE.spaceBefore().noSpaceAfter().and(n -> ((StreamEx)n.forward().skip(1L)).findAny(i -> CommonPatterns.HYPHEN_NODE.noSpaceBefore().spaceAfter().matches((Node)i)).isPresent());
    private static final NodePattern multiColon = NodePattern.N.inFormSequence(1, ":", ":").andOr(NodePattern.N.withNeighbor(-2, anyQuote.noSpaceAfter()), NodePattern.N.withNeighbor(-2, NodePattern.N.formCaseSensitive("[a-z]+").noSpaceAfter()), NodePattern.N.directlyBefore(anyQuote.noSpaceBefore()), NodePattern.N.spaceAfter().withNeighbor(-2, NodePattern.N.spaceBefore()), NodePattern.N.directlyBefore(CommonPatterns.colon), NodePattern.N.withNeighbor(-2, CommonPatterns.colon));
    public static final NodePattern namedEmojiInColons = CommonPatterns.colon.noSpaceAfter().directlyBefore(NodePattern.N.formCaseSensitive("[a-z][-_a-z\\d]+[a-z\\d].*").noSpaceAfter().directlyBefore(CommonPatterns.colon));
    private static final NodePattern inQuotedCharList = NodePattern.custom(n -> {
        Node quoteBefore = n.skipBack(NodePattern.not(anyQuote)::matches);
        Node quoteAfter = n.skipForward(NodePattern.not(anyQuote)::matches);
        if (quoteBefore == null) return false;
        if (quoteAfter == null) return false;
        if (!quoteBefore.nextUntil(quoteAfter).allMatch(NodePattern.N.noSpaceAround()::matches)) return false;
        return true;
    });
    public static final NodePattern doublePunctuation = NodePattern.or(NodePattern.N.form("\\.\\.").andNot(NodePattern.N.noSpaceBefore().directlyAfter(NodePattern.N.form("[?!]"))).andNot(NodePattern.N.noSpaceAfter().directlyAfter(NodePattern.N.noSpaceAfter()).directlyBefore(NodePattern.N)).and(CommonPatterns.reportWithPrevWord).correct(NodeCorrector.replace(".", "\u2026")), NodePattern.N.form("[.,;:]").sameWordAs(-1).withNeighbor(-2, NodePattern.N).reportEverythingTouched().andNot(multiColon).correct(NodeCorrector.replace("")), NodePattern.N.inFormSequence(0, "[,;:]", "[,;:.?!]").andNot(NodePattern.N.directlyBefore(NodePattern.N.spaceBefore().noSpaceAfter().andOr(NodePattern.N.inFormSequence(0, "!", "[*/a-z].*"), NodePattern.N.inFormSequence(0, ":", "[a-z][a-z\\d_-]+")))).and(n -> !n.form().equals(n.neighbor(1).form())).andNot(CommonPatterns.colon.andOr(NodePattern.N.noSpaceAround().directlyBefore(NodePattern.N.form("[,;:]")).directlyAfter(CommonPatterns.letterWord), NodePattern.N.withNeighbor(-2, namedEmojiInColons))).reportEverythingTouched().and(CommonPatterns.reportWithPrevWord).and((p1, match) -> {
        Node p2 = p1.neighbor(1);
        int start = p1.prevNode() != null ? p1.prevNode().endOffset() : p1.startOffset();
        return match.withCorrectors(List.of(NodeCorrector.rawReplace(start, p2.endOffset(), p1.form()), NodeCorrector.rawReplace(start, p2.endOffset(), p2.form())));
    })).andNot(inQuotedCharList);
    public static final NodePattern smileyColonLike = PairedPunctuation.smileyStart.and(CommonPatterns.beforeSkipping(CommonPatterns.HYPHEN_NODE, NodePattern.N.form("[()></\\\\]")));
    private static final java.util.regex.Pattern pyDocParamName = java.util.regex.Pattern.compile("(^|.*\n\\s*)[\\p{LD}_]+", 32);
    private static final java.util.regex.Pattern pyDocParamTypeDescr = java.util.regex.Pattern.compile("\\S+[\\s^\n]*\n.*", 32);
    private static final NodePattern pyDocColon = CommonPatterns.colon.and(n -> {
        String sentence = n.tree().text();
        String textBefore = sentence.substring(0, n.startOffset()).strip();
        String textAfter = sentence.substring(n.endOffset()).strip();
        return pyDocParamName.matcher(textBefore).matches() && pyDocParamTypeDescr.matcher(textAfter).matches();
    });
    public static final NodePattern possiblyChainedReference3 = NodePattern.N.inFormSequence(0, "[a-z]+", "\\.", "[a-z]+");
    private static final String chemicalSymbol = "H|He|Li|Be|B|C|N|O|F|Ne|Na|Mg|Al|Si|P|S|Cl|Ar|K|Ca|Sc|Ti|V|Cr|Mn|Fe|Co|Ni|Cu|Zn|Ga|Ge|As|Se|Br|Kr|Rb|Sr|Y|Zr|Nb|Mo|Tc|Ru|Rh|Pd|Ag|Cd|In|Sn|Sb|Te|I|Xe|Cs|Ba|La|Ce|Pr|Nd|Pm|Sm|Eu|Gd|Tb|Dy|Ho|Er|Tm|Yb|Lu|Hf|Ta|W|Re|Os|Ir|Pt|Au|Hg|Tl|Pb|Bi|Po|At|Rn|Fr|Ra|Ac|Th|Pa|U|Np|Pu|Am|Cm|Bk|Cf|Es|Fm|Md|No|Lr|Rf|Db|Sg|Bh|Hs|Mt|Ds|Rg|Cn|Nh|Fl|Mc|Lv|Ts|Og";
    private static final NodePattern chemicalFormula = NodePattern.N.formCaseSensitive("((H|He|Li|Be|B|C|N|O|F|Ne|Na|Mg|Al|Si|P|S|Cl|Ar|K|Ca|Sc|Ti|V|Cr|Mn|Fe|Co|Ni|Cu|Zn|Ga|Ge|As|Se|Br|Kr|Rb|Sr|Y|Zr|Nb|Mo|Tc|Ru|Rh|Pd|Ag|Cd|In|Sn|Sb|Te|I|Xe|Cs|Ba|La|Ce|Pr|Nd|Pm|Sm|Eu|Gd|Tb|Dy|Ho|Er|Tm|Yb|Lu|Hf|Ta|W|Re|Os|Ir|Pt|Au|Hg|Tl|Pb|Bi|Po|At|Rn|Fr|Ra|Ac|Th|Pa|U|Np|Pu|Am|Cm|Bk|Cf|Es|Fm|Md|No|Lr|Rf|Db|Sg|Bh|Hs|Mt|Ds|Rg|Cn|Nh|Fl|Mc|Lv|Ts|Og)\\d?)+");
    public static final NodePattern properlySpacedColon = CommonPatterns.colon.spaceAfter().noSpaceBefore().directlyAfter(NodePattern.N);
    private static final NodePattern firstOfPairedQuotes = anyQuote.and(n -> {
        if (!((StreamEx)n.back().skip(1L)).noneMatch(anyQuote::matches)) return false;
        if (((StreamEx)((StreamEx)n.forward().skip(2L)).filter(anyQuote::matches)).count() % 2L != 1L) return false;
        return true;
    });
    public static final NodePattern chatEmoji = NodePattern.N.inFormSequence(2, ":", "\\w+", ":");
    private static final String id = "[a-zA-Z_$][a-zA-Z0-9_$]*";
    private static final String idChain = "[a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z_$][a-zA-Z0-9_$]*";
    private static final String assignment = "= ['\"]";
    private static final String pyFString = "\\bf\"";
    private static final String commonCharEscape = "\\\\[ntbru]";
    private static final String call = "[a-zA-Z_$][a-zA-Z0-9_$]*\\(.*\\)";
    private static final String keyColonValue = "\\n *[a-zA-Z0-9_$'\"-]+: *[a-zA-Z0-9_$'\"-]+";
    private static final String cSharpTypeOrValueTuple = "([a-zA-Z_$][a-zA-Z0-9_$]*|\\([a-zA-Z_$][a-zA-Z0-9_$]*(, *[a-zA-Z_$][a-zA-Z0-9_$]*)+\\))";
    private static final String cSharpGenericTypeParameter = "(((in|out) +)?([a-zA-Z_$][a-zA-Z0-9_$]*|\\([a-zA-Z_$][a-zA-Z0-9_$]*(, *[a-zA-Z_$][a-zA-Z0-9_$]*)+\\)))";
    private static final String cSharpGenericMethod = "[a-zA-Z_$][a-zA-Z0-9_$]*<(((in|out) +)?([a-zA-Z_$][a-zA-Z0-9_$]*|\\([a-zA-Z_$][a-zA-Z0-9_$]*(, *[a-zA-Z_$][a-zA-Z0-9_$]*)+\\)))(, *(((in|out) +)?([a-zA-Z_$][a-zA-Z0-9_$]*|\\([a-zA-Z_$][a-zA-Z0-9_$]*(, *[a-zA-Z_$][a-zA-Z0-9_$]*)+\\))))*>\\(";
    private static final String scala_todo = "= ?\\?\\?\\?";
    private static final java.util.regex.Pattern CODE_LIKE_PATTERN = java.util.regex.Pattern.compile("= ['\"]|[a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z_$][a-zA-Z0-9_$]*|[a-zA-Z_$][a-zA-Z0-9_$]*\\(.*\\)|\\bf\"|\\\\[ntbru]|\\n *[a-zA-Z0-9_$'\"-]+: *[a-zA-Z0-9_$'\"-]+|[a-zA-Z_$][a-zA-Z0-9_$]*<(((in|out) +)?([a-zA-Z_$][a-zA-Z0-9_$]*|\\([a-zA-Z_$][a-zA-Z0-9_$]*(, *[a-zA-Z_$][a-zA-Z0-9_$]*)+\\)))(, *(((in|out) +)?([a-zA-Z_$][a-zA-Z0-9_$]*|\\([a-zA-Z_$][a-zA-Z0-9_$]*(, *[a-zA-Z_$][a-zA-Z0-9_$]*)+\\))))*>\\(|= ?\\?\\?\\?");
    private static final java.util.regex.Pattern JAVA_VARIABLE = java.util.regex.Pattern.compile("\\b([A-Z])([a-zA-Z_$][a-zA-Z0-9_$]*) ([a-z])(\\2) ?[;:,)=]");
    public static final NodePattern movePunctBeforeQuote = NodePattern.PUNCT.noSpaceBefore().includeIntoReport().withNeighbor(-1, anyQuote.noForm("`").noSpaceBefore().includeIntoReport()).withNeighbor(-2, NodePattern.not(NodePattern.PUNCT).noForm("[]}]").includeIntoReport()).and((n, match) -> match.withCorrector(NodeCorrector.replace(n, "").join(NodeCorrector.insertBefore(n.neighbor(-1), n.form()))));
    private static final NodePattern quotedIdWithTrailingPunct = NodePattern.N.form("[:.]").noSpaceBefore().directlyAfter(CommonPatterns.latin.directlyAfter(NodePattern.or(anyQuote, CommonPatterns.HYPHEN_NODE.directlyAfter(CommonPatterns.latin.directlyAfter(anyQuote))))).directlyBefore(NodePattern.not(CommonPatterns.lastToken));
    private static final NodePattern elvisOperator = NodePattern.N.inFormSequence(1, "\\?", ":");
    public static final NodePattern punctQuoteSentenceEnd = NodePattern.PUNCT.noSpaceAround().withNeighbor(1, anyQuote.noSpaceAfter()).withNeighbor(2, NodePattern.N.form("[?!.]")).withNeighbor(-1, NodePattern.not(NodePattern.PUNCT)).reportEverythingTouched();
    private static final NodePattern innerDot = NodePattern.not(CommonPatterns.lastToken).and(CommonPatterns.dot).andNot(NodePattern.N.directlyBefore(CommonPatterns.dot));

    public static NodePattern multiWhiteSpace(String message) {
        NodePattern multiWS = NodePattern.custom((node, match) -> {
            Node prev = node.prevNode();
            if (prev != null && prev.endOffset() + 1 < node.startOffset() && !FormattingIssues.isLineStart(node)) {
                if ("*".equals(prev.form()) && FormattingIssues.isLineStart(prev)) {
                    return null;
                }
                TextRange between = new TextRange(prev.endOffset(), node.startOffset());
                String ws = ZeroWidthSpaceRule.removeZeroWidthSpaces(between.substring(node.tree().text()));
                if (ws.length() < 2) {
                    return null;
                }
                String replacement = ws.contains("\t") ? "\t" : " ";
                return match.withMessage(message).withCorrector(NodeCorrector.rawReplace(between, replacement));
            }
            return null;
        });
        TreeCache<Boolean> manyMultiWhitespaces = new TreeCache<Boolean>("manyMultiWhitespaces", tree -> {
            List<Node> nodes = tree.nodes();
            return ((StreamEx)StreamEx.of(nodes).filter(multiWS::matches)).count() >= 2L;
        });
        NodePattern looksLikeTable = NodePattern.N.inPhrase(NodePattern.ROOT.andOr(NodePattern.N.withDependent("list|<unk>", multiWS), CommonPatterns.upperCase.directlyBefore(CommonPatterns.upperCase.and(multiWS)))).and(n -> (Boolean)n.tree().getCached(manyMultiWhitespaces));
        return multiWS.andNot(looksLikeTable);
    }

    private static boolean isLineStart(Node node) {
        return node.prevNode() == null || node.tree().text().substring(node.prevNode().endOffset(), node.startOffset()).contains("\n");
    }

    public static NodePattern quoteWhitespace(String missingWsMessage, String extraWsMessage) {
        NodePattern pattern = NodePattern.N.form("['\"]").andOr(NodePattern.N.noSpaceAround(), NodePattern.or(CommonPatterns.firstToken, NodePattern.N.spaceBefore()).andOr(CommonPatterns.lastToken, NodePattern.N.spaceAfter(), NodePattern.N.directlyBefore(NodePattern.or(CommonPatterns.comma, CommonPatterns.dot.and(CommonPatterns.lastToken))))).and((node, match) -> {
            PairedPunctuation kind = PairedPunctuation.guessMisformattedQuoteKind(node);
            return kind == null ? null : kind.checkSpace(missingWsMessage, extraWsMessage).match(node, match);
        });
        return FormattingIssues.joinAdjacentFixes(pattern, pattern);
    }

    public static NodePattern trailingComma(NodePattern clause, String message) {
        return CommonPatterns.comma.and(CommonPatterns.lastToken).includeIntoReport().directlyAfter(NodePattern.N.includeIntoReport().inPhrase(NodePattern.ROOT.and(clause))).correct(NodeCorrector.replace(".", "?", "!")).and((__, match) -> match.withSuppressableKind(NodeMatch.SuppressableKind.UNFINISHED_SENTENCE)).message(message);
    }

    public static NodePattern endWhitespace(Function<NodeMatch, String> message) {
        NodePattern shortcutPart = NodePattern.N.directlyAfter(NodePattern.N.form("\\+").spaceBefore());
        NodePattern possiblySmiley = TreeMigration.revise("check after tokenization changes", CommonPatterns.punctForm.andOr(NodePattern.N.form(".{2,}"), NodePattern.N.directlyAfter(NodePattern.N.form("[:;=]").noSpaceAfter())));
        return CommonPatterns.lastToken.form("[.!?]").spaceBefore().andNot(CommonPatterns.firstWord).andNot(shortcutPart).andNot(NodePattern.N.directlyAfter(possiblySmiley)).and(CommonPatterns.reportWithPrevWord).and((node, match) -> {
            Node prev = node.neighbor(-1);
            if (ZeroWidthSpaceRule.removeZeroWidthSpaces(node.tree().text().substring(prev.endOffset(), node.startOffset())).isEmpty()) {
                return null;
            }
            return match.withMessage((String)message.apply(match.withAnchor(node))).withReportedRange(new TextRange(prev.startOffset(), node.endOffset()), node.tree()).withCorrector(NodeCorrector.rawReplace(new TextRange(prev.endOffset(), node.startOffset()), ""));
        });
    }

    public static NodePattern punctWhitespace(Function<NodeMatch, String> message) {
        NodePattern mavenArtifact = NodePattern.N.noSpaceAfter().inFormSequence(0, ":", "[a-z0-9-]+:\\d.*");
        NodePattern shaHashOutput = NodePattern.N.noSpaceAfter().inFormSequence(1, "sha(512|384|256|1)", ":", "[a-z0-9-]*");
        NodePattern sshaHashOutput = NodePattern.N.noSpaceAfter().inFormSequence(1, "ssha", ":", "[a-z0-9-]*");
        NodePattern webProtocol = NodePattern.N.noSpaceAround().inFormSequence(0, ":", "//?");
        NodePattern maskPattern = NodePattern.N.noSpaceAround().inFormSequence(0, ":", "\\*");
        NodePattern bashPattern = NodePattern.N.noSpaceAround().inFormSequence(1, ".+\\{.+", ",");
        NodePattern inCharEnumeration = NodePattern.N.noSpaceAround().directlyAfter(NodePattern.not(CommonPatterns.letterWord)).directlyBefore(NodePattern.not(CommonPatterns.letterWord)).and(CommonPatterns.insideQuotes);
        return NodePattern.N.form("[,;:]").andNot(NodePattern.N.noSpaceAfter().directlyBefore(NodePattern.or(anyQuote.andNot(firstOfPairedQuotes), NodePattern.N.form("'s")))).andNot(NodePattern.N.noSpaceAfter().inFormSequence(0, ":", "[,:]")).andNot(smileyColonLike).andNot(chatEmoji).andNot(pyDocColon).andNot(mavenArtifact).andNot(webProtocol).andNot(maskPattern).andNot(NodePattern.N.noSpaceAfter().inFormSequence(0, ":", "\\d{2,5}").trace("colon port number")).andNot(bashPattern).andNot(shaHashOutput).andNot(sshaHashOutput).andNot(inCharEnumeration).and((node, match) -> {
            Node prev = node.prevNode();
            Node next = node.nextNode();
            if (prev == null || next == null || doublePunctuation.matches(node) || doublePunctuation.matches(next)) {
                return null;
            }
            int nextStart = next.startOffset();
            int prevEnd = prev.endOffset();
            if (prevEnd < node.startOffset() || nextStart == node.endOffset()) {
                match = match.withMessage((String)message.apply(match.withAnchor(node)));
                Node afterNext = next.nextNode();
                if (afterNext != null && firstOfPairedQuotes.spaceAfter().matches(next)) {
                    return match.withReportedRange(prev.startOffset(), afterNext.startOffset(), node.tree()).withCorrector(NodeCorrector.rawReplace(prevEnd, afterNext.startOffset(), node.form() + " " + next.form()));
                }
                return match.withReportedRange(prev.startOffset(), node.endOffset(), node.tree()).withCorrector(NodeCorrector.rawReplace(prevEnd, nextStart, node.form() + " "));
            }
            return null;
        });
    }

    public static NodePattern joinAdjacentFixes(NodePattern p1, NodePattern p2) {
        NodePattern wordContinuation = CommonPatterns.reportingWordPart.noSpaceBefore();
        NodePattern joining = p1.and((punct1, match1) -> {
            List<NodeCorrector> correctors1 = match1.correctors();
            List<TextRange> ranges1 = match1.reportedRanges();
            if (correctors1.size() != 1 || ranges1.size() != 1 || NodePattern.PUNCT.matches(punct1.nextNode())) {
                return match1;
            }
            for (Node punct2 : (StreamEx)((StreamEx)((StreamEx)punct1.forward().skip(2L)).dropWhile(wordContinuation::matches)).takeWhile(NodePattern.PUNCT::matches)) {
                NodeMatch match2 = p2.match(punct2);
                if (match2 == null) continue;
                List<NodeCorrector> correctors2 = match2.correctors();
                List<TextRange> ranges2 = match2.reportedRanges();
                if (correctors2.size() != 1 || ranges2.size() != 1 || !ranges1.get(0).overlaps(ranges2.get(0))) break;
                Tree tree = punct1.tree();
                int treeStart = tree.startOffset();
                return NodeMatch.EMPTY.withAnchor(punct1).withCorrector(correctors1.get(0).join(correctors2.get(0))).withMessage(match1.message()).withReportedRange(ranges1.get(0).start() - treeStart, ranges2.get(0).end() - treeStart, tree);
            }
            return match1;
        });
        return p1 == p2 ? joining : NodePattern.or(joining, p2);
    }

    public static NodePattern wordSplittingHyphen(String message) {
        return CommonPatterns.HYPHEN_NODE.message(message).markAs("Hyphen").andOr(NodePattern.N.noSpaceAfter(), NodePattern.N.noSpaceBefore()).directlyAfter(NodePattern.N.form("..+").markAs("Prev").andNot(NodePattern.N.directlyAfter(CommonPatterns.HYPHEN_NODE))).directlyBefore(NodePattern.N.formCaseSensitive("\\p{Ll}.+").markAs("Next").andNot(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_NODE))).andOr(NodePattern.markedNodeMatches("Prev", NodePattern.N.noPos()), NodePattern.markedNodeMatches("Next", NodePattern.N.noPos())).and((node, match) -> {
            Node prev = match.getMarkedNode("Prev");
            Node next = match.getMarkedNode("Next");
            TreeSupport support = node.tree().treeSupport();
            String concat = prev.form() + next.form();
            if (!support.tagToken(prev.form() + "-" + next.form()).hasPos(".*") && support.tagToken(concat).hasPos(".*") && !support.tagToken(concat).hasPos(".*:bad")) {
                return match.withCorrector(NodeCorrector.replaceNodes(prev, next, concat));
            }
            return null;
        });
    }

    public static NodePattern singleHyphenWhitespace(String messageUnnecessarySpace, String messageMissingSpace, NodePattern needHyphen) {
        NodePattern neighborNodesHaveTooManyDependents = NodePattern.or(NodePattern.N.directlyBefore(NodePattern.not(NodePattern.N.withHeadRelation("root|parataxis|a(dv)?cl(:relcl)?")).spaceAfter().withDependent(".*", NodePattern.N.afterHead().noHeadRelation("conj|nmod|appos"))), NodePattern.N.directlyAfter(NodePattern.not(NodePattern.N.withHeadRelation("root|parataxis|a(dv)?cl(:relcl)?")).spaceBefore().withDependent(".*", NodePattern.N.beforeHead().noHeadRelation("cc|amod|det|appos|case|nummod.*|punct").andNot(NodePattern.N.withHeadRelation("advmod").andNot(NodePattern.N.withHead(NodePattern.N.withHeadRelation("advmod")))))));
        NodePattern apposWithConj = NodePattern.N.withHeadRelation("appos").withDependent("conj");
        NodePattern hyphenAfter = NodePattern.N.noSpaceAfter().directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE);
        NodePattern mayBeACompoundPart = NodePattern.or(NodePattern.not(NodePattern.N.withHeadRelation("root|parataxis|a(dv)?cl(:relcl)?")), NodePattern.N.directlyAfter(CommonPatterns.skipBack(NodePattern.PUNCT, NodePattern.N.withHeadRelation("compound|a(dv)?mod").noDependents(".*", NodePattern.N.beforeHead())))).andNot(NodePattern.N.withHeadRelation("appos").withDependent("[na]mod", NodePattern.N.afterHead().withDependent(".*"))).noDependents("acl(:relcl)?");
        NodePattern compoundRel = CommonPatterns.skipConjUp(NodePattern.N.withHeadRelation("compound|flat.*|appos|fixed|a(dv)?mod|.*npmod|nummod"));
        NodePattern negativeIon = NodePattern.N.noSpaceBefore().directlyAfter(chemicalFormula.andOr(NodePattern.N.form(".{2,}"), NodePattern.N.form("[HFPI]")));
        NodePattern infix = NodePattern.or(NodePattern.N.form("\\p{L}{1,3}").noSpaceAround().directlyAfter(CommonPatterns.HYPHEN_NODE), NodePattern.N.form(".*-\\p{L}{1,3}"));
        return CommonPatterns.HYPHEN_NODE.includeIntoReport().directlyAfter(NodePattern.not(CommonPatterns.punctForm).andNot(NodePattern.N.noSpaceAfter().form("\\d.*")).noHeadRelation("det").andNot(infix).markAs("Prev").includeIntoReport()).andNot(negativeIon).directlyBefore(NodePattern.N.anyPos().markAs("Next").includeIntoReport()).andNot(NodePattern.N.noSpaceAfter().andOr(NodePattern.N.directlyBefore(NodePattern.N.formCaseSensitive("\\d.*|XX|D")), NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("conj")).directlyAfter(NodePattern.N.withHeadRelation("cc")))).and((node, match) -> {
            Node prev = match.getMarkedNode("Prev");
            Node next = match.getMarkedNode("Next");
            if (next.startOffset() - prev.endOffset() == 2) {
                String concat = prev.form() + next.form();
                String concatWithHyphen = prev.form() + "-" + next.form();
                TreeSupport support = node.tree().treeSupport();
                if (support.tagToken(concat).hasPos(".*") && support.isAcceptedBySpellchecker(concat) && !next.hasHeadRelation("case") && !CommonPatterns.capitalizedMiddle.matches(next)) {
                    match = match.withCorrector(NodeCorrector.replaceNodes(prev, next, concat));
                    if (support.tagToken(concatWithHyphen).hasPos(".*")) {
                        match = match.withCorrector(CommonPatterns.replaceWithWhitespace(node, "-"));
                    }
                    return match.withMessage(messageUnnecessarySpace);
                }
                if (!(next.head() != prev && !prev.isInPhraseOf(next) && prev.head() != next.head() && !hyphenAfter.matches(next) || !mayBeACompoundPart.matches(next) || !compoundRel.matches(prev) && !compoundRel.matches(next) || apposWithConj.matches(next) || neighborNodesHaveTooManyDependents.matches(node) || next.hasHeadRelation("amod") && !prev.hasHeadRelation("a(dv)?mod|.*npmod|compound"))) {
                    return match.withCorrector(NodeCorrector.replaceNodes(prev, next, concatWithHyphen)).withMessage(messageUnnecessarySpace);
                }
                match = match.withCorrector(CommonPatterns.replaceWithWhitespace(node, " \u2014 "));
                if (needHyphen.matches(node)) {
                    match = match.withCorrector(CommonPatterns.replaceWithWhitespace(node, "-"));
                }
                return match.withMessage(messageMissingSpace);
            }
            return null;
        });
    }

    public static NodePattern sentenceStartingPunctuation(String message) {
        return CommonPatterns.firstToken.form("[.,;:]").inSentenceWith(CommonPatterns.letterWord).andNot(CommonPatterns.colon.noSpaceAfter()).correct(NodeCorrector.replace("")).message(message).and((node, match) -> match.withSuppressableKind(NodeMatch.SuppressableKind.UNLIKELY_OPENING_PUNCTUATION));
    }

    public static NodePattern excessiveEllipsis(String message) {
        return NodePattern.N.form("\\.{4,8}").correct(NodeCorrector.replace("\u2026")).message(message);
    }

    public static NodePattern wordInternalPunctuation(String message, String frequentBeginningWords) {
        String regexBeforePunct = "\\p{L}{3,}";
        String regexAfterPunct = "[\\p{L}\\d][\\p{L}\\d:/.]*";
        String regex = "(" + regexBeforePunct + ")([.,;:!?()'\"\u201c\u201d\u201e\u00ab\u00bb`\u2018\u2019<>]+)(" + regexAfterPunct + ")";
        java.util.regex.Pattern pattern = java.util.regex.Pattern.compile(regex);
        NodePattern clauseStart = NodePattern.not(NodePattern.PUNCT).markAs("Start").inPhrase(NodePattern.N.withHeadRelation("advcl|acl:relcl|parataxis").after("Start").withPhraseStart(NodePattern.N.alreadyMarkedAs("Start")));
        NodePattern chainedReference1 = NodePattern.N.form("[a-z]+\\.[a-z]+").andNot(latinWordDotCapitalized1.directlyBefore(clauseStart)).noForm(".+\\.(" + frequentBeginningWords + ")");
        NodePattern chainedReference3 = possiblyChainedReference3.andNot(latinWordDotCapitalized3.withNeighbor(2, clauseStart.noFormCaseSensitive("[A-Z]{2}.*")));
        NodePattern wordWithApostrophe = NodePattern.N.form("\\p{L}+['\u2019\u2018]\\p{L}+");
        NodePattern oneToken = NodePattern.N.form(regex).noPos().andOr(NodePattern.N.spaceAfter(), NodePattern.N.directlyBefore(NodePattern.PUNCT.spaceAfter()), CommonPatterns.lastWord).andOr(NodePattern.N.spaceBefore(), NodePattern.N.directlyAfter(NodePattern.PUNCT.spaceBefore()), CommonPatterns.firstWord).noForm(".+!1+").noForm("[a-z]+\\([a-z0-9]+").noForm(".*::.*").noForm("\\p{L}+>?:\\d{4}").noFormCaseSensitive("[A-Z]+[.:]\\d+").noForm(".*[:;=][)\\](\\[/\\\\*opd3\u043e\u0440\u0437]").noForm("Fritz!(Box(en)?|Fons?|Powerline|WLAN|DECT|Repeater|App)").andNot(NodePattern.N.noForm(".*['\"\u201c\u201d\u201e\u00ab\u00bb`\u2018\u2019].*").directlyBefore(anyQuote).directlyAfter(anyQuote)).andNot(chainedReference1).andNot(wordWithApostrophe).and((node, match) -> {
            int i;
            String form = node.form();
            Matcher matcher = pattern.matcher(form);
            if (!matcher.matches()) {
                return null;
            }
            String word1 = matcher.group(1);
            String word2 = matcher.group(3);
            String innerPunct = matcher.group(2);
            TreeSupport support = node.tree().treeSupport();
            if (!(!innerPunct.matches("([(:'\u2019`\u2018\u00b4].*)|(.*\\..*)") || FormattingIssues.seemsValidToken(word1, support) && FormattingIssues.seemsValidToken(word2, support))) {
                return null;
            }
            if (innerPunct.matches("[;?]") && !FormattingIssues.seemsValidToken(word1, support) && !FormattingIssues.seemsValidToken(word2, support)) {
                return null;
            }
            for (i = matcher.end(1); i < form.length() && !Character.isLetterOrDigit(form.charAt(i)) && !FormattingIssues.leansRight(form, i); ++i) {
            }
            String part1 = form.substring(0, i);
            if (part1.matches(".*[?.!]['\"\u201c\u201d\u201e\u00ab\u00bb`\u2018\u2019]?")) {
                match = match.withSuppressableKind(NodeMatch.SuppressableKind.UNDECORATED_SENTENCE_SEPARATION);
            }
            return match.withMessage(message).withCorrector(NodeCorrector.replace(node, part1 + " " + form.substring(i)));
        });
        NodePattern seemsValidToken = NodePattern.custom(n -> FormattingIssues.seemsValidToken(n.form(), n.tree().treeSupport()));
        NodePattern threeTokens = NodePattern.N.inFormSequence(0, regexBeforePunct, "[.!?]", regexAfterPunct).noSpaceAfter().directlyBefore(NodePattern.N.noSpaceAfter().correct(NodeCorrector.insertAfter(" "))).and(seemsValidToken).withNeighbor(2, seemsValidToken).andNot(chainedReference3).andNot(NodePattern.N.label("PERSON").withNeighbor(2, NodePattern.N.label("PERSON"))).andNot(NodePattern.N.directlyAfter(anyQuote).withNeighbor(3, anyQuote)).andNot(NodePattern.N.inFormSequence(0, "Fritz", "!", "(Box(en)?|Fons?|Powerline|WLAN|DECT|Repeater|App)")).reportEverythingTouched().message(message).and((__, m) -> m.withSuppressableKind(NodeMatch.SuppressableKind.UNDECORATED_SENTENCE_SEPARATION));
        return NodePattern.or(oneToken, threeTokens);
    }

    private static boolean seemsValidToken(String word, TreeSupport support) {
        return support.tagToken(word).tokenReadings().stream().anyMatch(r -> r.pos() != null) || word.matches("\\d+") || AbbreviationPatterns.All.matches(word) || word.contains("//") && LikelyPatterns.IsURL.matches(word);
    }

    public static NodePattern leadingHyphen(String message) {
        NodePattern misattachedLeftHyphen = CommonPatterns.HYPHEN_NODE.noSpaceAfter().spaceBefore();
        NodePattern withAnotherHyphenTokenBefore = NodePattern.or(NodePattern.N.directlyBefore(NodePattern.N.withPrevSibling(misattachedLeftHyphen)), NodePattern.N.directlyBefore(NodePattern.N.withPrevSibling(NodePattern.N.withPhraseEnd(NodePattern.N.directlyAfter(CommonPatterns.HYPHEN_NODE.noSpaceAfter())))), NodePattern.N.directlyBefore(NodePattern.N.withPhraseStart(NodePattern.N.directlyAfter(NodePattern.N.directlyAfter(CommonPatterns.HYPHEN_NODE.noSpaceAfter())))));
        NodePattern commandLineArg = NodePattern.N.directlyBefore(NodePattern.N.formCaseSensitive("XX|[A-Za-z]"));
        NodePattern negativeNumber = NodePattern.N.directlyBefore(NodePattern.N.formCaseSensitive("\\d.*"));
        NodePattern looksLikeDirectSpeechLeftEdge = CommonPatterns.HYPHEN_LIKE_NODE.noSpaceAfter().spaceBefore().directlyAfter(CommonPatterns.colon.noSpaceBefore());
        NodePattern possibleEnding = NodePattern.N.directlyBefore(CommonPatterns.lowerCase.form("\\p{L}{1,4}").noLemma(".*"));
        NodePattern directSpeechStartBefore = NodePattern.custom(n -> n.back().anyMatch(i -> looksLikeDirectSpeechLeftEdge.matches((Node)i)));
        return misattachedLeftHyphen.andNot(withAnotherHyphenTokenBefore).andNot(CommonPatterns.insideQuotes).andNot(directSpeechStartBefore).andNot(NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.noPos(), NodePattern.PUNCT))).andNot(commandLineArg).andNot(negativeNumber).andNot(possibleEnding).andNot(hyphenTextHighlightingStart).correct(NodeCorrector.replace("")).and(CommonPatterns.reportWithPrevWord).message(message);
    }

    public static boolean looksLikeCode(String input) {
        if (CODE_LIKE_PATTERN.matcher(input).find()) {
            return true;
        }
        Matcher matcher = JAVA_VARIABLE.matcher(input);
        if (matcher.find() && matcher.group(1).equalsIgnoreCase(matcher.group(3).toUpperCase(Locale.ROOT))) {
            return true;
        }
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) <= '\u007f') continue;
            return false;
        }
        int codeChars = 0;
        int textTokens = 0;
        boolean inToken = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                if (inToken) continue;
                inToken = true;
                ++textTokens;
                continue;
            }
            inToken = false;
            if ("(){}[]<>=+-*/%|&!;,.:\\@$#^".indexOf(c) == -1) continue;
            ++codeChars;
        }
        return codeChars > 0 && textTokens < codeChars;
    }

    public static NodePattern noSpaceWithBrackets(String message) {
        NodePattern openingBrackets = NodePattern.N.form("[(\\[]");
        NodePattern closingBrackets = NodePattern.N.form("[)\\]]");
        NodePattern notPunctuationWithMorphology = NodePattern.not(CommonPatterns.punctForm).anyPos();
        NodePattern severalWordsInBrackets = NodePattern.custom(n -> ((StreamEx)((StreamEx)n.back().skip(1L)).takeWhile(node -> !openingBrackets.matches((Node)node))).count() > 1L);
        NodePattern afterSpaceNoComma = NodePattern.N.spaceBefore().andNot(NodePattern.N.directlyAfter(CommonPatterns.comma));
        NodePattern looksLikeFunctionArgs = NodePattern.custom(n -> {
            List bracketNodes = ((StreamEx)((StreamEx)n.forward().skip(1L)).takeWhile(node -> !closingBrackets.matches((Node)node))).toList();
            if (bracketNodes.size() == 1) {
                String form = ((Node)bracketNodes.get(0)).form();
                return StringUtils.isAllLowerCase((CharSequence)form) || !CommonPatterns.letterWord.matches((Node)bracketNodes.get(0));
            }
            if (bracketNodes.size() > 3) {
                return false;
            }
            if (bracketNodes.stream().anyMatch(node -> afterSpaceNoComma.matches((Node)node))) {
                return false;
            }
            return bracketNodes.stream().noneMatch(node -> !node.hasForm(",") && !StringUtils.isAllLowerCase((CharSequence)node.form()) && !StringUtils.isAllUpperCase((CharSequence)node.form()) && !node.hasForm("['\"\u201c\u201d\u201e\u00ab\u00bb`\u2018\u2019]") && !StringUtils.isNumeric((CharSequence)node.form()));
        });
        NodePattern annotationBracket = NodePattern.or(NodePattern.N.inFormSequence(1, "#", "\\[", "[A-Z]\\w*"), NodePattern.N.inFormSequence(1, "@[A-Z]\\w+", "\\("));
        NodePattern optionalSuffix = NodePattern.N.formCaseSensitive("\\p{Ll}{1,4}").noSpaceAfter().and(CommonPatterns.beforeSkipping(NodePattern.N.form("\\?").noSpaceAfter(), CommonPatterns.closingParen));
        return NodePattern.or(openingBrackets.directlyAfter(CommonPatterns.skipBack(anyQuote.noSpaceBefore(), notPunctuationWithMorphology)).noSpaceBefore().directlyBefore(CommonPatterns.skipForward(anyQuote, notPunctuationWithMorphology.noForm(".*\\).*")).andNot(optionalSuffix)).andNot(looksLikeFunctionArgs.directlyAfter(CommonPatterns.latin)).andNot(annotationBracket).correct(NodeCorrector.insertBefore(" ")), closingBrackets.directlyBefore(notPunctuationWithMorphology).noSpaceAfter().includeIntoReport().directlyAfter(notPunctuationWithMorphology.includeIntoReport()).and(severalWordsInBrackets).correct(NodeCorrector.insertAfter(" "))).andNot(CommonPatterns.insideQuotes).message(message);
    }

    private static boolean leansRight(String form, int offset) {
        char c = form.charAt(offset);
        if (form.charAt(offset - 1) == ':') {
            return true;
        }
        if (c == '\'' || c == '\"') {
            return offset + 1 < form.length() && Character.isLetterOrDigit(form.charAt(offset + 1));
        }
        return c == '(' || c == '<';
    }

    public static NodePattern punctBeforeQuote(Pattern abbrPattern) {
        return NodePattern.PUNCT.noSpaceAround().includeIntoReport().directlyAfter(NodePattern.not(NodePattern.PUNCT).includeIntoReport()).directlyBefore(anyQuote.includeIntoReport()).andNot(quotedIdWithTrailingPunct).andNot(FormattingIssues.abbrOrNameDot(abbrPattern)).andNot(elvisOperator);
    }

    public static NodePattern abbrOrNameDot(Pattern abbrPattern) {
        AggregatedPattern pattern = new AggregatedPattern(abbrPattern, LikelyPatterns.NameInitials);
        return CommonPatterns.dot.noSpaceBefore().andNot(CommonPatterns.lastToken).andOr(NodePattern.custom(n -> pattern.find(n.tree().text()).stream().anyMatch(r -> r.getEndExclusive() == n.endOffset())), NodePattern.N.directlyAfter(NodePattern.N.formCaseSensitive("\\p{Lu}(\\.\\p{Lu})+")));
    }

    public static NodePattern missingSentenceDotAfterQuotedAbbreviation(Pattern abbrPattern) {
        return FormattingIssues.abbrOrNameDot(abbrPattern).noSpaceAfter().directlyAfter(NodePattern.N).directlyBefore(anyQuote.and(CommonPatterns.lastToken).correct(NodeCorrector.insertAfter("."))).reportEverythingTouched();
    }

    public static NodePattern movePunctAfterQuote(Pattern abbrPattern) {
        NodePattern insertSpaceBeforeQuote = NodePattern.N.form("[:;]").withNeighbor(2, NodePattern.not(NodePattern.PUNCT).spaceBefore()).and((n, match) -> {
            Node prevQuote = n.back().findFirst(anyQuote::matches).orElse(null);
            if (Quotes.openingPosition.matches(prevQuote)) {
                return null;
            }
            return match.withCorrector(NodeCorrector.rawReplace(n.endOffset(), n.neighbor(2).startOffset(), " " + n.neighbor(1).form()));
        });
        return FormattingIssues.punctBeforeQuote(abbrPattern).andNot(multiColon).andNot(NodePattern.N.withNeighbor(2, NodePattern.PUNCT).andNot(CommonPatterns.comma.withNeighbor(2, anyQuote))).andOptionally(insertSpaceBeforeQuote).and((n, match) -> match.withCorrector(NodeCorrector.replace(n, "").join(NodeCorrector.insertAfter(n.neighbor(1), n.form()))));
    }

    public static NodePattern spacesAfterNumbers(List<String> nextTokenTexts, String message, boolean correctSpace) {
        String numberRegexp = "(\\d|\\d[\\d,.\\s]*\\d|\\d+/\\d+)";
        String spaceRegexp = "(?!\u00a0\\s)\\s*";
        String stringRegexp = "(" + String.join((CharSequence)"|", nextTokenTexts) + ")";
        String lookahead = "(?![\\p{L}\\d-\u2013\u2014+]|\\..+)";
        java.util.regex.Pattern pattern = correctSpace ? java.util.regex.Pattern.compile(numberRegexp + spaceRegexp + stringRegexp + lookahead) : java.util.regex.Pattern.compile(numberRegexp + stringRegexp + lookahead);
        return NodePattern.N.form("[0-9]+.*").and((node, match) -> {
            int startOffset = node.startOffset();
            String text2 = node.tree().text().substring(startOffset);
            Matcher matcher = pattern.matcher(text2);
            if (!matcher.lookingAt()) {
                return null;
            }
            return match.withCorrector(NodeCorrector.rawReplace(startOffset, startOffset + matcher.end(), matcher.group(1) + "\u00a0" + matcher.group(2)).batchCapable("NumbersNbsp")).withMessage(message).enableAutoFix();
        });
    }

    public static NodePattern spacesWithNameInitials(@Nullable Parameter spacesInNameInitials, String messageUseSpaces, String messageNoSpaces, NodePattern exception) {
        return CommonPatterns.nerPerson.and(CommonPatterns.capitalized).andNot(exception).and((firstNode, match) -> {
            String spaceInInitialsParameter;
            boolean spaceInInitials;
            List personNodes = ((StreamEx)firstNode.forward().takeWhile(n -> CommonPatterns.nerPerson.matches((Node)n) || innerDot.matches((Node)n))).toList();
            String sentence = firstNode.tree().text();
            Node lastNode = (Node)personNodes.get(personNodes.size() - 1);
            String personText = sentence.substring(firstNode.startOffset(), lastNode.endOffset());
            if (personText.contains(")") || personText.contains("(") || personText.contains(",")) {
                return null;
            }
            String dotBeforeNoInitial = "(?<=\\p{Lu})\\.[\\s\u00a0]*(?=\\p{L}{3,})";
            String dotBeforeInitial = "(?<=\\p{Lu})\\.[\\s\u00a0]*(?=\\p{L}{1,2}(\\.|$))";
            String replacedDotsBeforeNoInitials = personText.replaceAll(dotBeforeNoInitial, ".\u00a0");
            String resultReplacement = replacedDotsBeforeNoInitials.replaceAll(dotBeforeInitial, (spaceInInitials = (spaceInInitialsParameter = spacesInNameInitials != null ? spacesInNameInitials.getValue(firstNode.tree()) : "").isEmpty() || spaceInInitialsParameter.equals("useSpaces")) ? ".\u00a0" : ".");
            if (resultReplacement.equals(personText)) {
                return null;
            }
            String message = spaceInInitials ? messageUseSpaces : messageNoSpaces;
            return match.withCorrector(NodeCorrector.rawReplace(new TextRange(firstNode.startOffset(), lastNode.endOffset()), resultReplacement).batchCapable("InitialsNbsp")).withReportedRange(firstNode.startOffset(), lastNode.endOffset(), firstNode.tree()).withMessage(message).enableAutoFix();
        });
    }

    public static NodePattern ibanFormatting(String message) {
        java.util.regex.Pattern pattern = java.util.regex.Pattern.compile("[\\p{Lu}\\d][\\p{Lu}\\d\\s.-]+[\\p{Lu}\\d]");
        NodePattern numStart = NodePattern.custom((firstNode, match) -> {
            Matcher matcher = pattern.matcher(firstNode.tree().text().substring(firstNode.startOffset()));
            if (!matcher.lookingAt()) {
                return null;
            }
            int end = matcher.end();
            String ibanText = matcher.group();
            String ibanTextClean = ibanText.replaceAll("[^\\d\\p{Lu}]", "");
            if (ibanTextClean.length() < 15) {
                return null;
            }
            String replacement = ibanTextClean.replaceAll("(.{4})", "$1\u00a0").replaceAll("\u00a0$", "");
            if (replacement.equals(ibanText)) {
                return null;
            }
            return match.withCorrector(NodeCorrector.rawReplace(firstNode.startOffset(), firstNode.startOffset() + end, replacement)).withMessage(message).withReportedRange(firstNode.startOffset(), firstNode.startOffset() + end, firstNode.tree());
        });
        return NodePattern.N.form("iban").directlyBefore(CommonPatterns.skipForward(NodePattern.PUNCT, numStart));
    }

    public static NodePattern colonDash(String message) {
        return properlySpacedColon.includeIntoReport().directlyBefore(CommonPatterns.DASH_NODE.includeIntoReport()).withNeighbor(2, NodePattern.not(CommonPatterns.punctForm)).and((colon, match) -> {
            Node dash = colon.neighbor(1);
            if (colon.tree().text().substring(colon.endOffset(), dash.startOffset()).contains("\n")) {
                return null;
            }
            return match.withCorrector(NodeCorrector.replaceNodes(colon, dash, ":\n" + dash.form()));
        }).message(message);
    }

    public static NodePattern joinedNumberWord(String message, @Language(value="RegExp") String properNamePos, Predicate<Tree.Token> splitBeforeWord) {
        Predicate<String> isProperNamePos = java.util.regex.Pattern.compile(properNamePos).asMatchPredicate();
        return NodePattern.N.form("[0-9]+\\p{L}+").noForm("1password").and((node, match) -> {
            String form = node.form();
            int digits = (int)form.chars().takeWhile(Character::isDigit).count();
            String word = form.substring(digits);
            Tree.Token tagged = node.tree().treeSupport().tagToken(word);
            if (tagged.posReadings().isEmpty() || !splitBeforeWord.test(tagged)) {
                return null;
            }
            if (word.length() > 1 && word.chars().skip(1L).anyMatch(Character::isUpperCase) && tagged.posReadings().stream().noneMatch(isProperNamePos)) {
                return null;
            }
            boolean sentenceBreak = node.tree().treeSupport().getGrazieLanguage() != ai.grazie.nlp.langs.Language.GERMAN && Character.isUpperCase(word.charAt(0)) && tagged.posReadings().stream().anyMatch(isProperNamePos.negate());
            return match.withCorrector(NodeCorrector.replace(node, form.substring(0, digits) + (sentenceBreak ? ". " : " ") + word));
        }).message(message);
    }
}

