/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.common;

import ai.grazie.rules.tree.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

public record PhraseReplacement(String phrase, List<String> wordsLow, List<String> replacements) {
    public static Map<String, List<PhraseReplacement>> parseLines(List<String> lines) {
        HashMap<String, List<PhraseReplacement>> entries2 = new HashMap<String, List<PhraseReplacement>>();
        for (String line : lines) {
            PhraseReplacement replacement = PhraseReplacement.parse(line);
            List list = entries2.computeIfAbsent(replacement.wordsLow().get(0), __ -> new ArrayList());
            if (list.stream().anyMatch(e -> e.phrase.equals(replacement.phrase))) {
                throw new IllegalArgumentException("Duplicate entry for " + replacement.phrase);
            }
            list.add(replacement);
        }
        return entries2;
    }

    private static PhraseReplacement parse(String line) {
        String[] parts = line.split(":");
        List wordsLow = StreamEx.of((Object[])parts[0].split(" ")).map(s -> s.toLowerCase(Locale.ROOT)).toList();
        List corrections = StreamEx.of((Object[])parts[1].split("\\|")).map(String::trim).toList();
        return new PhraseReplacement(parts[0], wordsLow, corrections);
    }

    public boolean matches(Node node, MatchStrategy strategy) {
        return this.wordsLow.equals(((StreamEx)node.forward().limit((long)this.wordsLow.size())).map(strategy::nodeString).toList());
    }

    public int tokenCount() {
        return this.wordsLow.size();
    }

    public static enum MatchStrategy {
        Form,
        Lemma;


        public String nodeString(Node n) {
            return this == Form ? n.lowForm() : n.lemmaReadings().stream().findFirst().orElse(n.form()).toLowerCase(Locale.ROOT);
        }

        @Nullable
        public PhraseReplacement findRule(Node node, Map<String, List<PhraseReplacement>> index) {
            return StreamEx.of((Collection)index.getOrDefault(this.nodeString(node), List.of())).findFirst(p -> p.matches(node, this)).orElse(null);
        }
    }
}

