/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.de;

import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.de.AgreementSet;
import ai.grazie.rules.de.Capitalization;
import ai.grazie.rules.de.Case;
import ai.grazie.rules.de.GermanDateChecker;
import ai.grazie.rules.de.GermanTreePatterns;
import ai.grazie.rules.de.GermanValences;
import ai.grazie.rules.de.Redundancy;
import ai.grazie.rules.de.ReflexivePronouns;
import ai.grazie.rules.de.SemanticRules;
import ai.grazie.rules.de.SpellingRules;
import ai.grazie.rules.de.StyleRules;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodeMatcher;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import ai.grazie.rules.tree.TreeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import kotlin.Pair;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.tools.StringTools;

class WordSeparation {
    static final String JOIN_WORDS_MSG = "Sollten diese W\u00f6rter zusammengeschrieben werden?";
    private static final String HYPHEN_CAPITALIZE_MSG = "Schreiben Sie gegens\u00e4tzliche Begriffe gro\u00df und mit Bindestrichen";
    private static final String HYPHEN_SHORTED_VERBS_MSG = "Verbinden Sie verk\u00fcrzte Verben mit Bindestrich, um Handlungen zu verkn\u00fcpfen";
    private static final String HYPHEN_SHORTED_NOUNS_MSG = "Schreiben Sie Teile zusammengesetzter Nomen gro\u00df und mit Bindestrichen";
    private static final String HYPHEN_SHORTED_ADJ_MSG = "Schreiben Sie Teile zusammengesetzter Adjektive mit Bindestrichen";
    private static final String HYPHEN_MSG = "Schreiben Sie aufeinanderfolgende Begriffe mit Bindestrichen";
    private static final String ADV_SPELLED_TOGETHER_MSG = "Dieses Adverb wird zusammengeschrieben";
    private static final String ADJ_SPELLED_TOGETHER_MSG = "Dieses Adjektiv wird zusammengeschrieben";
    private static final String MISSING_HYPHEN_MSG = "Fehlt ein Bindestrich?";
    private static final String WORD_IS_COMPOUND_MSG = "Dieses Wort wird zusammengeschrieben";
    public static final String INFINITIVE_WITH_ZU_MSG = "Trennbare Verben werden in Infinitivs\u00e4tzen zusammengeschrieben";
    private static final NodePattern zuOnlyWithComplexInfinitives = NodePattern.N.lemma("helfen|lehren|lernen");
    private static final NodePattern verbZuInf = NodePattern.or(Case.mayHaveArg("zuInf").andNot(zuOnlyWithComplexInfinitives), zuOnlyWithComplexInfinitives.withDependent("xcomp", NodePattern.N.withDependent(".*", NodePattern.N.beforeHead()).noForm("kennen|spielen")), NodePattern.N.lemma("haben").withDependent("obj", NodePattern.N.form("absicht|angst|lust|problem|spa\u00df|zeit")), NodePattern.N.form("bereit|entschlossen|erlaubt|erstaunt|falsch|gesund|gewohnt|gut|leicht|richtig|(\u00fc|ue)berzeugt|verboten|wichtig|freude").withDependent("cop"));
    static final NodePattern withDependentEs = NodePattern.N.withDependent("expl|nsubj", NodePattern.N.form("es"));
    static final NodePattern csubjWithDependentEs = NodePattern.N.withHead("csubj|acl", withDependentEs);
    static final NodePattern csubjWithMissingDependentEs = NodePattern.N.withHead("csubj", NodePattern.not(withDependentEs).pos("ADJ:PRD:GRU")).andOr(NodePattern.N.withNextSibling(NodePattern.PUNCT), NodePattern.not(NodePattern.N.withNextSibling(NodePattern.N)));
    static final NodePattern infinitiveWithZuPhraseHead = NodePattern.or(NodePattern.N.pos("VER:INF.*").noPos("VER:PA2.*"), NodePattern.N.noPos().form(".+en").withHeadRelation("xcomp").noForm("zuteil.+|.+zu.+").and(CommonPatterns.lastWord)).noDependents("nsubj.*|flat|cop|aux").andNot(NodePattern.N.directlyAfter(SpellingRules.zu)).noDependents("conj", NodePattern.N.withDependent("aux", NodePattern.N.directlyAfter(SpellingRules.zu))).andNot(CommonPatterns.insideQuotes).andOr(csubjWithDependentEs, csubjWithMissingDependentEs, NodePattern.not(NodePattern.N.withHeadRelation("csubj"))).andOr(NodePattern.N.withHead("conj", NodePattern.N.noDependents("nsubj.*|cop").andNot(NodePattern.N.withHead(NodePattern.N.withDependent("aux", NodePattern.N.pos("VER:MOD.*"))))), NodePattern.not(NodePattern.N.withHeadRelation("conj"))).and(CommonPatterns.skipUp("conj|cop", NodePattern.or(NodePattern.N.inFormSequence(1, "teuer", "zustehen").withHead(NodePattern.N.lemma("kommen")), NodePattern.N.withHeadRelation("nsubj").withDependent("det", NodePattern.N.form("das").directlyBeforeHead()).withHead(withDependentEs), NodePattern.N.withHead("xcomp|acl|csubj", NodePattern.or(verbZuInf, NodePattern.N.pos("ADJ:PRD:GRU").withDependent("cop"), NodePattern.ROOT.lemma("sein").onlyPos("VER.*").and(withDependentEs))).afterHead(), NodePattern.N.afterHead().withHead("acl", SpellingRules.noun.withHead("obj|nsubj", NodePattern.not(NodePattern.N.lemma("sehen|h\u00f6ren|helfen|gehen|fahren|kommen|bleiben|le(rn|hr)en")))).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("zum"))).andNot(NodePattern.N.noDependents()).andNot(NodePattern.N.withDependent("obj", CommonPatterns.firstChildPhrase.pos("ART:DEF.*"))), NodePattern.N.withHead("mark", NodePattern.N.withHeadRelation("xcomp").pos("PA2.*")).directlyAfterHead(), csubjWithDependentEs, NodePattern.N.withDependent("mark|case", NodePattern.N.form("um|ohne|au(\u00df|ss)er|(an)?statt")).andOr(NodePattern.N.withHeadRelation("advcl"), NodePattern.N.withHeadRelation("obl").withDependent("ob[jl]|iobj", NodePattern.N.beforeHead())).andNot(NodePattern.N.withHead(NodePattern.N.pos("VER:MOD.*"))), NodePattern.N.withDependent("mark", NodePattern.N.form("als")).withHead("advcl", NodePattern.or(CommonPatterns.lowercasedHasPos(".*KOM.*"), NodePattern.N.lemma("machern|tun").withDependent("obj", NodePattern.N.form("nichts"))))).noDependents("aux.*", NodePattern.N.afterHead())));
    private static final NodePattern drauflosVerb = NodePattern.N.lemma("reden|gehen|arbeiten|fabulieren|feuern|schwatzen|fahren|reiten|schie(\u00df|ss)en|rennen|schwimmen|schimpfen|laufen|schlagen|bauen|f\u00fchren|sprechen|h\u00e4mmern|watscheln|wirtschaften|raten|starten|klicken|posten|schreiben|malen|plappern");
    static final NodePattern grobVorstellung = GermanTreePatterns.lemmaAfterForm("Vorstellung", "grob");
    static final String questionWords = "(wer|wen|wem|wann|wie|wo(hin|her)?|welch)";
    static final NodePattern verbsWithPrefixZurecht = NodePattern.N.lemma("(zu)?(kommen|biegen|finden|legen|machen|schneiden|weisen|sitzen|schieben|r\u00fccken|richten)");
    private static final NodePattern wordsMakeCompoundWithErsteHilfe = NodePattern.N.lemma("Kurs|(Ausbild|Schul|Ausr\u00fcst|Anleit)ung|Dienst|Station|Punkt|Ma(ss|\u00df)nahme|Leitfaden|Set|Kasten|Tasche|Koffer|Rucksack|Box|Pass|App");
    static final NodePattern abbrAsPartOfCompound = NodePattern.N.formCaseSensitive("[A-Z\u00c4\u00d6\u00dc]{2,5}[a-z\u00e4\u00f6\u00fc\u00df]*(s|[A-Z\u00c4\u00d6\u00dc])?|[A-Z\u00c4\u00d6\u00dc]{1,5}[a-z\u00e4\u00f6\u00fc\u00df][A-Z\u00c4\u00d6\u00dc].*");
    static final String relativeDays = "((\u00fcber)?morgen|heute|(vor)?gestern)";
    static final NodePattern directlyAfterIntensifier = NodePattern.N.directlyAfter(NodePattern.N.form("ganz|so|zu|sehr|extrem|richtig|wirklich|echt|total|dementsprechend|\u00e4u\u00dferst|stark"));
    static final NodePattern inseparableVerbsWithUnter = NodePattern.or(NodePattern.N.lemma("scheiden|st\u00fctzen|brechen|dr\u00fccken|lassen|richten|suchen|schreiben|fertigen"), NodePattern.N.lemma("halten").withDependent("det:poss", NodePattern.N.lemma("sich")));
    static final NodePattern inseparableVerbsWithWider = NodePattern.or(NodePattern.N.lemma("sprechen|rufen"), NodePattern.N.lemma("setzen").withDependent("det:poss", NodePattern.N.lemma("sich")));
    static final NodePattern inseparableVerbsWithUm = NodePattern.or(NodePattern.N.lemma("geben|kreisen|ringen"), NodePattern.N.form("arm(en?|s?t|te(st|t|n)?)"));
    static final NodePattern inseparableVerbsWithHinter = NodePattern.or(NodePattern.N.lemma("gehen|fragen"), NodePattern.N.form("gangen"));
    static final NodePattern inseparableVerbsWithDurch = NodePattern.or(NodePattern.N.lemma("leben|suchen|schauen"), NodePattern.N.form("quer(en?|s?t|te(st|t|n)?)"));
    static final String zuVerb = "((arbeit|bau|bei(\u00df|ss)|bekomm|bereit|betonier|billig|bind|bring|deck|denk|dien|diktier|dreh|dr\u00fcck|eign|erkenn|fall|fax|flieg|flie(\u00df|ss)|frier|f\u00fcg|f\u00fchr|ge[bh]|(ge)?h\u00f6r|gesell|gesteh|gie(\u00df|ss)|greif|hak|halt|h\u00e4ng|hau|heil|jauchz|kauf|kehr|kiff|kleb|klink|klapp|knall|kn\u00f6pf|komm|kork|krieg|lach|lad|lang|lass|lauf|leg|leit|l\u00f6t|mach|mess|misch|mut|n\u00e4h|nehm|neig|ordn|pack|park|pfropf|prost|rat|raun|rechn|red|reich|reit|richt|roll|ruf|r\u00fcst|sag|schal[tz]|schau|schick|schieb|schl?ie(ss|\u00df)|schlag|schmei(\u00df|ss)|schmier|schnall|schnapp|schneid|schn\u00fcr|schraub|schreib?|sch\u00fctt|schwell|s\u00e4g|seh|send|setz|sperr|spiel|spitz|sprech|spring|stec[hk]|steh|stell|stimm|stopf|sto(\u00df|ss)|streb|str\u00f6m|st\u00fcrz|text|teil|trag|trau|treff|trink|wachs|wart|weis|werf|wink|zieh)en|zurren|(sich|fl\u00fcst)ern)";
    static final NodePattern zuNotAdvmod = NodePattern.N.form("zu").noHeadRelation("advmod");
    private static final String gehenOrLaufen = "(gehen|laufen)";
    private static final NodePattern inseparableVerbsWithUeber = NodePattern.or(NodePattern.N.lemma("zeugen|blicken|leben|fallen|raschen|setzen|treiben|weisen|sehen|dehnen|lappen|lagern|k\u00e4mmen|winden"), NodePattern.N.lemma("geben").andOr(NodePattern.N.withDependent("obj", NodePattern.N.pos("PRO:REF.*")), NodePattern.N.withDependent("expl:pv")));
    private static final NodePattern ziehenTreten = NodePattern.N.lemma("ziehen|treten");
    private static final NodePattern securityForces = NodePattern.N.lemma(".*(Poliz(ei|ist)|Beamte|Milit\u00e4r)|Sicherheits(dienst|kraft)|(Ordnungs|Kriminal)amt|(Euro|Inter)pol");
    private static final NodePattern withAnimateOrReflOrName = NodePattern.N.withDependent("obj", NodePattern.or(NodePattern.N.pos("(PRO:REF|EIG).*"), SemanticRules.animate));
    private static final NodePattern withPartsOfDayOrTime = NodePattern.N.withDependent("obl", NodePattern.N.lemma(SemanticRules.timeUnit + "|((nach|vor)?mittag|abend|nacht|morgen)"));
    static final NodePattern einanderGegenseitig = NodePattern.N.form("einander|gegenseitig");
    static final NodePattern mass = NodePattern.N.form("ma(\u00df|ss)");
    static final NodePattern halten = NodePattern.N.lemma("haltend?");
    static final NodePattern wordsStartingWithMass = NodePattern.or(NodePattern.N.lemma("regeln|schneidern"), NodePattern.N.lemma("ge(schneidert|recht|fertigt|arbeitet|bend)"), NodePattern.N.form("geblich"));
    private static final NodePattern rabattCode = NodePattern.N.inFormSequence(0, "Rabatt", "Codes?");
    private static final NodePattern nonstopFlugOrKino = NodePattern.N.inFormSequence(0, "nonstop", "(Fl(ug(e?s)?|\u00fcgen?)|Kinos?)");
    static final NodePattern withDependentsDetCaseAmod = NodePattern.N.withDependent("det(:poss)?|case|amod", NodePattern.N.beforeHead().andNot(NodePattern.N.onlyPos("ADV:MOD")));
    static final NodePattern compoundNounWithInFrage = NodePattern.N.inFormSequence(2, "in", "frage", "stehen|kommen|stellen|stellung(en)?").and(withDependentsDetCaseAmod).noDependents("obj");
    private static final NodePattern masterBachelorCompound = NodePattern.N.label("MISC").andOr(SpellingRules.noun, CommonPatterns.upperCase).directlyBefore(NodePattern.N.form("(Master|Bachelor)(s|studi(ums?|engang(e?s)?)|(abschluss|zeugnis)(es)?)?").label("MISC")).andOr(NodePattern.N.directlyBeforeHead(), NodePattern.N.withNeighbor(1, NodePattern.N.directlyAfterHead()));
    private static final NodePattern englishWordsInSequence = GermanTreePatterns.englishWord.directlyBefore(GermanTreePatterns.englishWord);
    private static final NodeMatcher hyphenateNeighbors = (node, match) -> match.withCorrector(CommonPatterns.hyphenateNeighbors(node, node.neighbor(1)));
    static final NodePattern nullkommanichts = NodePattern.N.inFormSequence(0, "null", "komma", "ni(chts|x)");
    static final NodePattern withImBeforeHead = NodePattern.N.withDependent("case", NodePattern.N.form("im").directlyBeforeHead());
    private static final Set<String> compoundsNotKnownForSpellchecker = Set.of("Schokokuchen", "Knotenchart", "Regenerierungsplan", "Naturalismusvariante", "Spanischschule", "Kaffeeklatschen", "Diskriminierungsgesetze", "Gassigehen", "Homerule", "Hometrainer", "Homeplate", "Homeshopping", "Homesitter", "Homesitterin", "Homespun", "Homeland", "Homefighter", "Homecare", "Homebase", "Homecomputer", "Zurverf\u00fcgungstellung", "Zurverf\u00fcgungstellen", "Pinguinkost\u00fcm");
    private static final NodePattern makeCompoundWithNext = NodePattern.custom((node, match) -> {
        String compound = WordSeparation.makeCompoundWithNext(node);
        return compound == null ? null : match.withCorrector(NodeCorrector.replaceNodes(node, node.neighbor(1), compound));
    });
    private static final NodePattern validFirstPartCompound = NodePattern.N.form(".{3,}").withHeadRelation("compound").directlyBeforeHead().withNeighbor(1, CommonPatterns.capitalizedHasPos("SUB.*")).noForm("Herrn?|Frau|.+ss").noPos("EIG.*").andNot(CommonPatterns.lowercasedHasPos("ADJ.*")).andNot(SemanticRules.units);
    private static final NodePattern anAbAuf = NodePattern.N.form("a(n|b|uf)");
    private static final NodePattern berg = NodePattern.N.form("Berg");
    static final String adjEndings = "(e[rnsm]?)?";
    static final NodePattern abbrOrNoPos = NodePattern.or(NodePattern.N.form("([A-Z\u00c4\u00d6\u00dc]([a-z\u00e4\u00f6\u00fc\u00df]+)?[A-Z\u00c4\u00d6\u00dc]+|[A-Z\u00c4\u00d6\u00dc])").noPos(), NodePattern.N.pos("ABK.*"));
    private static final String gross = "gro(\u00df|ss)";
    static final NodePattern fest = NodePattern.N.form("fest");
    static final NodePattern withDependentAnAm = NodePattern.N.withDependent("case", NodePattern.N.form("a[nm]"));
    static final NodePattern zahlOrEin = NodePattern.or(SpellingRules.zal, NodePattern.N.form("ein"));
    static final String predicativeAdj = "ADJ:PRD:GRU";
    private static final NodePattern currencyOrPercent = NodePattern.or(NodePattern.N.form("[$\u00a3\u20ac\u00a5\u20bd]|Prozent|%"), SemanticRules.currencyName);
    private static final String gaenge = "G\u00e4nge";
    private static final Set<String> lowerCaseMiddleCompoundParts = Set.of("ml", "l", "g", "kg", "m", "t", "how", "hoc", "off", "per", "private", "up", "on", "go", "out", "down", "of", "in", "it", "together", "have", "over", "even", "by", "away", "back");
    static final NodePattern vonOrGen = NodePattern.or(NodePattern.N.form("von"), NodePattern.N.pos(".*:GEN:.*"));
    static final NodePattern alleNaselang = NodePattern.N.inFormSequence(1, "alle", "nas(en?)?", "lang");
    private static final String verbsWithUps = "pop|make|push|stand|line|close";
    static final String naJaWords = "(ja{1,4}|gut|also|bitte|prima|super|toll|klasse|klar|und|sch\u00f6n)";

    WordSeparation() {
    }

    static Rule.PatternRule rule() {
        return new Rule.PatternRule("Spelling.WORD_SEPARATION", "Getrennt- und Zusammenschreibung", "Wortgruppen werden getrennt geschrieben, Zusammensetzungen werden zusammengeschrieben. Trennbare Verben werden in Infinitivs\u00e4tzen zusammengeschrieben.", "https://dict.leo.org/grammatik/deutsch/Rechtschreibung/Regeln/Getrennt-zusammen", NodePattern.or(WordSeparation.nounSeparation(), WordSeparation.compoundsContainAbbr(), WordSeparation.verbPrefixSeparation(), WordSeparation.adverbSeparation(), WordSeparation.adjectiveSeparation(), WordSeparation.soSeparation("bald"), WordSeparation.soSeparation("sehr"), WordSeparation.nachDemSeparation(), WordSeparation.soWeitSeparation(), WordSeparation.soVielSeparation(), WordSeparation.daMitSeparation(), WordSeparation.sowiesoSeparation(), WordSeparation.emailSeparation(), WordSeparation.miscSeparation(), WordSeparation.coordinatedCompoundPartsPattern(), WordSeparation.hyphenRequiringCompound(), WordSeparation.pronomenSeparation(), WordSeparation.numberSeparation(), WordSeparation.dankeSchoen(), WordSeparation.einEntwederOder(), WordSeparation.trotzAlledem(), WordSeparation.zumalSeparation(), WordSeparation.demZuFolge(), WordSeparation.colorBasedVerbsPattern(), WordSeparation.bescheidVerbs(), WordSeparation.imVorhinein(), WordSeparation.desWeiteren(), WordSeparation.vornHerein(), WordSeparation.infolgedessen(), WordSeparation.irgendCompound(), WordSeparation.jeUmSo(), WordSeparation.wieSoAdverb(), WordSeparation.vielMehr(), WordSeparation.lebenLang(), WordSeparation.ausAnderen(), WordSeparation.anhand(), WordSeparation.ebensoGenauso(), WordSeparation.colorCompounds(), WordSeparation.hinZu(), WordSeparation.amSonsten(), WordSeparation.englishElementCompoundNoun(), WordSeparation.jahreLang(), WordSeparation.wirGefuehl(), WordSeparation.wordsStartingWithMass(), WordSeparation.multiKulti(), WordSeparation.alleNaselang(), WordSeparation.compoundSplittingIntoPhrase(), WordSeparation.soLange(), WordSeparation.germanizedAnglicismsWithHyphenPattern(), WordSeparation.denWegLaufen(), WordSeparation.superGAU(), WordSeparation.topNoun(), WordSeparation.zurZeit(), WordSeparation.naja()), new Example("Ein <b>Antigen Test</b>.", JOIN_WORDS_MSG, "Ein <b>Antigentest</b>."), new Example("Hier ein paar <b>vorher nachher Effekte</b>.", HYPHEN_CAPITALIZE_MSG, "Hier ein paar <b>Vorher-Nachher-Effekte</b>."), new Example("Ein stilisierter Baum ziert die <b>2 Euro M\u00fcnzen</b> Frankreichs.", HYPHEN_MSG, "Ein stilisierter Baum ziert die <b>2-Euro-M\u00fcnzen</b> Frankreichs."), new Example("<b>7 Liter-Motor</b>.", HYPHEN_MSG, "<b>7-Liter-Motor</b>.")).honorCrazyParses();
    }

    private static NodePattern secondPartInComplexPreposition(String first, String second) {
        return NodePattern.N.form(second).afterHead().withHead(NodePattern.N.withDependent("case", NodePattern.N.form(first).beforeHead()));
    }

    private static NodePattern directlyBeforeOrWithHead(String lemma) {
        return NodePattern.or(NodePattern.N.withHead(NodePattern.N.lemma(lemma)), NodePattern.N.directlyBefore(NodePattern.N.lemma(lemma)));
    }

    private static NodePattern verbPrefixSeparation() {
        NodePattern zuPrefix = zuNotAdvmod.directlyBefore(NodePattern.N.lemma(zuVerb).noPos(".*ZUS")).andNot(NodePattern.N.withHead("mark", NodePattern.or(NodePattern.N.withDependent("xcomp|dep"), NodePattern.N.withHeadRelation("conj"), NodePattern.N.withHead(NodePattern.N.withDependent("mark", NodePattern.N.form("zu"))), CommonPatterns.skipConjUp(NodePattern.N.withDependent("mark|case", NodePattern.N.form("ohne|um|als|f\u00fcr|statt"))), CommonPatterns.skipConjUp(NodePattern.N.withHeadRelation("csubj.*|ccomp|acl")), NodePattern.N.withDependent("advmod", NodePattern.N.form("da|hier")), NodePattern.N.noPos("PA2.*").withDependent("aux", NodePattern.N.lemma("haben")), NodePattern.N.withDependent("cop|aux(:pass)?", NodePattern.or(NodePattern.N.lemma("sein"), NodePattern.N.form("waer(en?|s?t)"))), NodePattern.N.withHeadRelation("xcomp").noDependents("aux").andNot(NodePattern.N.withHead(NodePattern.N.lemma("lassen"))), NodePattern.N.withHeadRelation("parataxis").withDependent("aux"), NodePattern.N.withHeadRelation("advcl").noDependents("nsubj"), NodePattern.N.lemma("schauen").withDependent("obj", NodePattern.not(NodePattern.N.pos(".*DAT.*")))))).andNot(NodePattern.N.withHeadRelation("case").directlyBefore(NodePattern.N.lemma("gehen"))).andNot(NodePattern.N.inFormSequence(1, "wieder", "zu", "sehen")).andNot(NodePattern.N.inFormSequence(2, "ab", "und", "zu"));
        String verbsStartingWithHoch = "schalten|rechnen|stapeln|steigen|fahren|gehen|biegen|blicken|bringen|drehen|pusc?hen|gucken|halten|heben|kurbeln|werfen|ziehen|bekommen|binden|dienen|fliegen|holen|hopsen|jagen|jubeln|kommen|kraxeln|langen|leben|nehmen|peitschen|ragen|rappeln|p\u00e4ppeln|rei(\u00df|ss)en|schaukeln|scheuchen|schicken|schieben|schnellen|schrauben|schrecken|sehen|senden|spielen|springen|stecken|stemmen|tragen|treiben|w\u00f6lben|wuchten|arbeiten|klettern|krempeln||schleppen|preisen|stehen|stellen|stilisieren|winden|wirbeln|bocken|branden|brechen|dr\u00fccken|d\u00fcrfen|h\u00fcpfen|k\u00e4mmen|klappen|kochen|k\u00f6nnen|kriechen|kriegen|schauen|schichten|schie(\u00df|ss)en|schlagen|schleichen|schleudern|sch\u00fcrzen|schwingen|scrollen|sollen|sp\u00fclen|streben|strecken|streifen|st\u00fclpen|t\u00fcrmen|lagern|wischen|k\u00e4mpfen|krabbeln|laden|laufen|pumpen|legen|rutschen|stechen|tragen";
        NodePattern bedienen = NodePattern.N.lemma("bedienen");
        NodePattern separablePrefix = NodePattern.or(NodePattern.N.form("a[nb]|abhanden|anheim|au[fs]|dar|ein(her)?|ent(gegen|zwei)|fehl|fort|her(an|aus|bei|ein|nieder|unter|um|\u00fcber|vor)?|hin(ein|\u00fcber|weg)|inne|nieder|umh(er|in)|unter|weg|wider|\u00fcberhand").andNot(anAbAuf.directlyAfter(berg.andNot(withDependentsDetCaseAmod))).andNot(NodePattern.N.directlyBefore(NodePattern.N.lemma("sein"))).andNot(NodePattern.N.form("weg").withHead(NodePattern.N.lemma("beobachten"))).andNot(NodePattern.N.form("unter").withHead(inseparableVerbsWithUnter)).andNot(NodePattern.N.form("wider").withHead(inseparableVerbsWithWider)).andNot(NodePattern.N.form("her").directlyAfterHead().withHead("case", NodePattern.N.withHeadRelation("obl").withDependent("case", NodePattern.N.form("von").beforeHead()))).noHeadRelation("nsubj(:pass)?"), NodePattern.N.form("(zu)?r\u00fcck").noHeadRelation("mark").withHead(NodePattern.N.pos("(VER|PA2).*").noLemma("sein|wissen").noDependents("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.lemma("Weg|Pfad|Strecke|Stra(\u00df|ss)e|Bahn|Bus|Zug"))), NodePattern.N.form("bei").withHead(NodePattern.N.lemma("behalten|bringen|geben|legen|pflichten|setzen|springen|steuern|tragen|treten|wohnen")), NodePattern.N.form("vorbei").andNot(NodePattern.N.withHead(NodePattern.N.lemma("abf\u00e4lschen|einen|entt\u00e4uschen|f\u00fchren|scheinen|sein|verlaufen|werden"))), NodePattern.N.form("aufrecht").withHead(NodePattern.N.lemma("erhalten")), NodePattern.N.form("daneben").withHead(NodePattern.N.lemma("benehmen").withDependent("expl:pv|obj", NodePattern.N.pos("PRO:REF.*"))), NodePattern.N.form("auseinander").withHead(NodePattern.N.noLemma("sein|folgen|ergeben|hervorgehen|zwingen")).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("weit"))), NodePattern.N.form("heilig").withHead(NodePattern.N.lemma("sprechen|halten")), NodePattern.N.form("hops").withHead(NodePattern.N.lemma("gehen|nehmen")), NodePattern.N.form("krank").withHead(NodePattern.N.lemma("schreiben|melden|feiern|lachen|schie\u00dfen")), NodePattern.N.form("klein").withHead(NodePattern.N.lemma("reden|kriegen|bekommen")), NodePattern.N.form("k\u00fcrzer").withHead(NodePattern.N.lemma("treten")), NodePattern.N.form("drauflos").withHead(drauflosVerb), NodePattern.N.form("durch").withHead(NodePattern.N.lemma("boxen|schauen|starten|kreuzen|steigen|stehen|spielen|sprechen|st(\u00f6|oe)bern|se?uchen|graben|atmen|bei(\u00df|ss)en|beissen|bekommen|checken|denken|drehen|fahren|fallen|fegen|feiern|(gehen|laufen)|halten|impfen|jagen|kauen|k\u00e4mpfen|kitzeln|klettern|lassen|wachsen|leben|machen|mischen|nehmen|nummerieren|n(\u00e4|ae)ssen|pauken|planen|rauschen|rechnen|testen|tasten|v(\u00f6|oe)geln|setzen|fluten|flie(\u00df|ss)en|bohren|winken|schleudern|sickern|w(\u00fc|ue)hlen|leuchten|d\u00fcsen|lesen|ziehen|probieren|blicken|ficken|greifen|schneiden|brechen|wechseln")), NodePattern.N.form("raus|rein|ru(nter|m)|r\u00fcber").directlyBefore(NodePattern.N.lemma("lassen")), NodePattern.N.form("rum").and(WordSeparation.directlyBeforeOrWithHead("albern")), NodePattern.N.form("vor").andNot(NodePattern.N.directlyAfter(NodePattern.N.form("au\u00dfen|aussen"))).andNot(NodePattern.N.withHead(NodePattern.N.withDependent("aux", NodePattern.N.lemma("haben").beforeHead()))), NodePattern.N.form("los").andNot(NodePattern.N.withHead(NodePattern.N.lemma("sein"))).andNot(NodePattern.N.inFormSequence(0, "los", "geht", "'s")), NodePattern.N.form("leid").and(WordSeparation.directlyBeforeOrWithHead("tun")), NodePattern.N.form("bereit").and(WordSeparation.directlyBeforeOrWithHead("halten|li?egen|ste(h|ll)en")), NodePattern.or(fest.andOr(WordSeparation.directlyBeforeOrWithHead("nageln|halten|stellen|legen|setzen"), NodePattern.N.withHead(NodePattern.N.lemma("binden").andOr(NodePattern.N.withDependent("obj|nsubj:pass", NodePattern.or(NodePattern.N.pos("PRO:PER.*"), SemanticRules.animate, NodePattern.N.lemma("Haar")).andNot(NodePattern.N.lemma("Schleife|Band(age)?|Verband|Schn\u00fcrsenkel|Seil|Leine|Schnur|.*Gummi"))), NodePattern.N.withDependent("obl", SpellingRules.noun.withDependent("case", NodePattern.N.form("mit|a[nm]|unterm?"))))), NodePattern.N.withHead("compound:prt", NodePattern.or(NodePattern.N.lemma("dr\u00fccken").withDependent("obj", NodePattern.not(SemanticRules.animate)), NodePattern.N.lemma("nehmen").andOr(NodePattern.N.withDependent("nsubj(:pass)?|i?obj|obl|nmod|compound", securityForces), NodePattern.N.withDependent("obj|nsubj:pass", SemanticRules.animate.andNot(SemanticRules.familyMembers).andNot(NodePattern.N.lemma("Leiter").withDependent("det(:poss)?", NodePattern.N.pos("ART:.*:FEM"))))).noDependents("obl", withDependentAnAm), NodePattern.N.lemma("stehen|gestanden").withDependent("expl|nsubj(:pass)?", NodePattern.N.form("d(ie|a)s|es"))))), NodePattern.N.form("sch(\u00f6|oe)n").and(WordSeparation.directlyBeforeOrWithHead("reden")), NodePattern.N.form("dicht").withHead(NodePattern.N.lemma("machen").noDependents("obj")), NodePattern.N.form("dr\u00fcber").and(WordSeparation.directlyBeforeOrWithHead("lesen|steigen|fahren|schauen|streuen").andNot(NodePattern.N.withNeighbor(1, NodePattern.N.form("gelesen")))), NodePattern.N.form("stark|irre?").and(WordSeparation.directlyBeforeOrWithHead("machen")), NodePattern.N.form("sicher").and(WordSeparation.directlyBeforeOrWithHead("stellen")), NodePattern.N.form("satt").and(WordSeparation.directlyBeforeOrWithHead("haben")), NodePattern.N.form("statt").and(WordSeparation.directlyBeforeOrWithHead("finden|geben|haben")), NodePattern.N.form("kaputt").and(WordSeparation.directlyBeforeOrWithHead("lachen|freuen|reden|rei(\u00df|ss)en|trampeln|arbeiten|gehen|hauen|bei\u00dfen|sparen|schneiden|schmei(\u00df|ss)en")), NodePattern.N.form("tot").and(WordSeparation.directlyBeforeOrWithHead("lachen|weinen|reden|reiten|treten|trinken|trampeln|fallen|fahren|gehen|hetzen|kriegen|laufen|machen|bei\u00dfen|schlagen")), NodePattern.N.form("hoch").and(WordSeparation.directlyBeforeOrWithHead(verbsStartingWithHoch)).andNot(NodePattern.N.withHead("advmod", NodePattern.N.lemma("legen").withDependent("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.lemma("(Mess)?Latte")))), NodePattern.N.form("zufrieden").and(WordSeparation.directlyBeforeOrWithHead("lassen"))).andNot(directlyAfterIntensifier), NodePattern.N.form("allein").directlyBefore(NodePattern.N.lemma("lassen").withHead(NodePattern.N.lemma("f\u00fchlen"))), NodePattern.N.form("stand").and(WordSeparation.directlyBeforeOrWithHead("halten")), NodePattern.N.form("teil").and(WordSeparation.directlyBeforeOrWithHead("haben")), NodePattern.N.form("fern").and(WordSeparation.directlyBeforeOrWithHead("sehen|gucken|schauen|bleiben|trauen|sprechen|stehen|steuern|lenken|halten|heizen|kopieren|liegen|z\u00fcnden")).andNot(NodePattern.N.withHead(bedienen)), NodePattern.N.form("preis").and(WordSeparation.directlyBeforeOrWithHead("geben")), NodePattern.N.form("voraus").and(WordSeparation.directlyBeforeOrWithHead("gehen")), NodePattern.N.form("vonstatten").and(WordSeparation.directlyBeforeOrWithHead("gehen")), NodePattern.N.form("gegen").and(WordSeparation.directlyBeforeOrWithHead("checken|pr\u00fcfen")), NodePattern.N.form(gross).and(WordSeparation.directlyBeforeOrWithHead("tun|ziehen")), NodePattern.N.form("zusammen").withHead("advmod", NodePattern.N.lemma("schreiben").withDependent("nsubj(:pass)?", NodePattern.not(SemanticRules.animate))), NodePattern.N.form("um").withHeadRelation("compound:prt").andNot(NodePattern.N.withHead(inseparableVerbsWithUm)), NodePattern.N.form("voll").and(WordSeparation.directlyBeforeOrWithHead("dr\u00f6hnen")), NodePattern.N.form("hin").and(WordSeparation.directlyBeforeOrWithHead("bringen|weisen|deuten|fahren")), NodePattern.N.form("hinunter").and(WordSeparation.directlyBeforeOrWithHead("ziehen")), NodePattern.N.form("vorlieb|teil|vorweg").and(WordSeparation.directlyBeforeOrWithHead("nehmen")), NodePattern.N.form("vorw\u00e4rts").and(WordSeparation.directlyBeforeOrWithHead("dr\u00e4ngen")), NodePattern.N.form("wert").and(WordSeparation.directlyBeforeOrWithHead("sch\u00e4tzen")), NodePattern.N.form("zuteil").and(WordSeparation.directlyBeforeOrWithHead("werden")), NodePattern.N.form("zufrieden").andOr(WordSeparation.directlyBeforeOrWithHead("lassen"), WordSeparation.directlyBeforeOrWithHead("geben").and(NodePattern.N.withHead(NodePattern.N.withDependent("expl:pv")))), NodePattern.N.form("dazu").and(WordSeparation.directlyBeforeOrWithHead("verdienen")), NodePattern.N.form("mit").and(WordSeparation.directlyBeforeOrWithHead("arbeiten|bauen|bekommen|benutzen|bestimmen|bieten|bringen|denken|empfinden|erleben|essen|fahren|feiern|fiebern|finanzieren|fliegen|f\u00fchlen|f\u00fchren|geben|gehen|helfen|h\u00f6ren|kommen|kriegen|k\u00e4mpfen|laufen|leiden|lernen|machen|marschieren|nehmen|pfeifen|rauchen|rechnen|reden|regieren|reisen|rei(\u00df|ss)en|schicken|singen|spielen|sprechen|stimmen|teilen|tragen|tun|verdienen|vollziehen|wirken|wollen|ziehen|z\u00e4hlen|reden")), NodePattern.N.form("nach").and(WordSeparation.directlyBeforeOrWithHead("vollziehen|holen|geben|fassen")), NodePattern.N.form("kurz").and(WordSeparation.directlyBeforeOrWithHead("fassen")), NodePattern.N.form("hinter").and(WordSeparation.directlyBeforeOrWithHead("bleiben|bringen|fangen|f\u00fcllen|haken|kippen|laufen|mauern|schlucken|sinnen|treiben|schlingen|ziehen|her(rennen|werfen|tragen|rufen|schauen|gehen|fahren|kommen|laufen|hinken|jagen|blicken|kleckern|schicken|hecheln|schreien|telefonieren|spionieren)")).andNot(NodePattern.N.withHead(inseparableVerbsWithHinter)), NodePattern.N.form("hintereinander").and(WordSeparation.directlyBeforeOrWithHead(gehenOrLaufen)), NodePattern.N.form("hinterher").and(WordSeparation.directlyBeforeOrWithHead("blicken|fahren|gehen|hecheln|hinken|jagen|kleckern|kommen|laufen|rennen|rufen|schauen|schicken|schreien|spionieren|telefonieren|tragen|werfen")), NodePattern.N.form("drauf").and(WordSeparation.directlyBeforeOrWithHead("gehen|gucken|halten|hauen|h\u00e4mmern|klicken|knallen|kritzeln|legen|malen|packen|satteln|schauen|schlagen|schrauben|schreiben|springen|stehen|zahlen")), NodePattern.N.form("\u00fcber").withHeadRelation("dep|compound:prt|fixed").directlyBefore(NodePattern.N.pos("VER.*").andNot(NodePattern.or(inseparableVerbsWithUeber, ziehenTreten)))).andNot(NodePattern.N.inFormSequence(1, "verkehrt", "herum")).andNot(NodePattern.N.inFormSequence(2, "nach", "wie", "vor")).andNot(NodePattern.N.inFormSequence(2, "hin", "und", "her")).andNot(WordSeparation.secondPartInComplexPreposition("ins?", "hinein").andNot(NodePattern.N.directlyBefore(NodePattern.N.lemma("fressen")))).andNot(WordSeparation.secondPartInComplexPreposition("vo[nm]", "an|aus|auf")).andNot(WordSeparation.secondPartInComplexPreposition("vor", "her")).andNot(WordSeparation.secondPartInComplexPreposition("a[mn]", "vorbei")).andNot(WordSeparation.secondPartInComplexPreposition("aus", "heraus")).andNot(WordSeparation.secondPartInComplexPreposition("ums?", "her(um)?")).andNot(WordSeparation.secondPartInComplexPreposition("durch|(\u00fc|ue)bers?", "hinweg")).andNot(NodePattern.N.noSpaceBefore().directlyAfter(CommonPatterns.HYPHEN_NODE)).noHeadRelation("flat:name").andNot(NodePattern.N.withDependent("det.*|case|[an]mod|cc|mark").noForm("gut")).andNot(NodePattern.N.withHeadRelation("conj").withDependent("nsubj.*"));
        NodePattern noCase = NodePattern.N.noHeadRelation("case");
        NodePattern separableInseparablePrefix = NodePattern.or(NodePattern.N.form("um|\u00fcber").withHead(NodePattern.N.lemma("fahren")), NodePattern.N.form("unter").withHead(NodePattern.N.lemma("halten")), NodePattern.N.form("wieder").withHead(NodePattern.N.lemma("holen")), NodePattern.N.form("\u00fcber").withHead(ziehenTreten), NodePattern.N.form("hinter").withHead(NodePattern.N.lemma("lassen|legen|gehen")), NodePattern.N.form("wieder").withHead(NodePattern.N.lemma("w\u00e4hlen").withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("zu[rm]?|als"))))).and(noCase);
        NodePattern alwaysInseparableVerbs = NodePattern.or(inseparableVerbsWithDurch.directlyAfter(NodePattern.N.form("durch")), inseparableVerbsWithUnter.directlyAfter(NodePattern.N.form("unter")), inseparableVerbsWithWider.directlyAfter(NodePattern.N.form("wider")), inseparableVerbsWithHinter.directlyAfter(NodePattern.N.form("hinter")), inseparableVerbsWithUm.directlyAfter(NodePattern.N.form("um")), inseparableVerbsWithUeber.directlyAfter(NodePattern.N.form("\u00fcber")), bedienen.directlyAfter(NodePattern.N.form("fern")), NodePattern.N.lemma("wandeln").directlyAfter(CommonPatterns.lowerCase.form("schlaf").noDependents("case|det(:poss)?")), NodePattern.N.pos("VER.*").directlyAfter(NodePattern.N.form("ver|be|emp|ent|miss|zer")), NodePattern.N.lemma("lingen").directlyAfter(NodePattern.N.form("ge"))).directlyAfter(NodePattern.N.noHeadRelation("det")).andNot(NodePattern.N.withDependent("case", NodePattern.N.beforeHead()).noForm("gangen"));
        NodePattern letter = NodePattern.N.form("[a-z\u00e4\u00f6\u00fc\u00df]");
        NodePattern lastWordOrBeforeComma = NodePattern.or(CommonPatterns.lastWord, NodePattern.N.directlyBefore(CommonPatterns.comma));
        return NodePattern.or(WordSeparation.infinitiveWithPrefixBeforeZu(separablePrefix), NodePattern.or(NodePattern.N.pos("VER:IMP.*").noDependents("nsubj"), NodePattern.N.pos("VER.*").andNot(CommonPatterns.skipConjUp(NodePattern.ROOT).noDependents("cop|aux").noLemma("streuen").andOr(NodePattern.N.onlyPos(".*PA2.*").noDependents("aux(:pass)?"), NodePattern.not(NodePattern.N.onlyPos(".*PA2.*")).noDependents("aux(:pass)?", NodePattern.N.lemma("werden")).noLemma("gestanden")))).noForm("einen?").noPos(".*NEB|ZAL|.*EIZ.*").directlyAfter(NodePattern.or(separablePrefix, separableInseparablePrefix, zuPrefix).noHeadRelation("det").markAs("Prefix").andNot(NodePattern.N.inFormSequence(1, "bis", "her"))).andOr(NodePattern.N.withHeadRelation("root|a(dv)?cl|[cx]comp|csubj|parataxis"), NodePattern.N.withHeadRelation("conj").directlyAfter(NodePattern.N.alreadyMarkedAs("Prefix").directlyBeforeHead().noHeadRelation("case|cc"))).andNot(NodePattern.N.inFormSequence(2, "nichts?", "zu", "sagen")).andNot(NodePattern.N.pos("VER:[123].*").directlyBeforeHead().andOr(NodePattern.N.withHead(NodePattern.N.pos("VER:[123].*").noPos("VER:MOD.*")), NodePattern.N.noPos("VER:INF.*"))).andOr(NodePattern.not(NodePattern.N.lemma("treffen").directlyAfter(NodePattern.N.form("zu"))), NodePattern.not(CommonPatterns.possiblyConj(NodePattern.N.withDependent("nsubj", NodePattern.N.form("ich|du|wir|ihr"))))).andNot(infinitiveWithZuPhraseHead).andNot(Redundancy.antworten.withDependent("compound:prt|advmod", Redundancy.zurueck)).and((verb, match) -> {
            Node prefix = match.getMarkedNode("Prefix");
            String concat = (!CommonPatterns.firstToken.matches(prefix) ? prefix.lowForm() : prefix.form()) + verb.lowForm();
            return match.withCorrector(NodeCorrector.rawReplace(prefix.startOffset(), verb.endOffset(), concat));
        }).message("Verben werden im Infinitiv, am Ende eines Nebensatzes und als Partizip zusammengeschrieben"), NodePattern.or(NodePattern.N.form("dazu").directlyBefore(NodePattern.or(NodePattern.N.lemma("verdienen|stellen").withDependent("expl:pv"), NodePattern.N.lemma("kommen").noDependents("advcl|[xc]comp|csubj:pass", NodePattern.N.withDependent("mark", NodePattern.N.form("zu|da(ss|\u00df)|weil"))).noDependents("aux", NodePattern.N.lemma("werden")), NodePattern.N.lemma("tun").withDependent("obj", NodePattern.N.pos("SUB:AKK:.*")), NodePattern.N.lemma("schreiben").withDependent("obj", NodePattern.N.lemma("Zeile")))), NodePattern.N.form("hier(hin|her)").directlyBefore(NodePattern.or(NodePattern.N.lemma("rufen|bem\u00fchen|bitten|blicken|fahren|fliegen|f\u00fchren|geh\u00f6ren|gelangen|holen|schicken|nehmen|kriegen|legen|locken|laufen|setzen|schauen|treiben|ziehen|wagen|schleppen"), NodePattern.N.lemma("kommen").withDependent("advmod", NodePattern.N.form("denn|mal"))))).andNot(NodePattern.N.withHead("advmod", NodePattern.N.withDependent("nsubj(:pass)?", NodePattern.N.afterHead()))).withNeighbor(1, NodePattern.or(NodePattern.N.pos("VER:INF:(NON|SFT)|VER:PA2.*"), NodePattern.N.noPos()).markAs("Verb")).message("Das Verb \u201e$_$Verb\u201c wird zusammengeschrieben").and(WordSeparation.joinWithNextNode()), NodePattern.N.form("dichtmachen").withDependent("obj").correct(NodeCorrector.replace("dicht machen")).message("Im Sinne von \u201eabdichten\u201c wird \u201edicht machen\u201c getrennt geschrieben"), NodePattern.N.lemma("n\u00e4her((zu|ge)?(kommen|stehen|treten|r\u00fccken)|gestanden)").andOr(NodePattern.N.pos("VER:EIZ:.*").correct(NodeCorrector.regexReplace("n\u00e4herzu(.*)", "n\u00e4her zu $1")), NodePattern.N.pos("(VER:INF|.*PA2).*").correct(NodeCorrector.regexReplace("n\u00e4her(.*)", "n\u00e4her $1"))).noDependents("advmod", NodePattern.N.form("wieder|fr\u00fcher").directlyBeforeHead()).andNot(NodePattern.N.withDependent("iobj", NodePattern.or(NodePattern.N.pos("PRO:PER.*"), SemanticRules.animate, NodePattern.N.form("einander"))).noDependents("advmod", NodePattern.N.directlyBeforeHead())).message("Schreiben Sie Verbindungen von \u201en\u00e4her\u201c und einem Verb getrennt, wenn eine geringere \u00f6rtliche oder zeitliche Distanz gemeint ist"), NodePattern.N.form("wach(ge|zu)?halten").andOr(withAnimateOrReflOrName, withPartsOfDayOrTime).correct(NodeCorrector.regexReplace("wach(ge|zu)?(halten)", "wach $1$2")).message("Im Sinne von \u201emunter\u201c wird \u201ewach\u201c getrennt geschrieben"), NodePattern.N.form("gro(\u00df|ss)|klein").directlyBefore(NodePattern.N.lemma("schreiben").noDependents("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.or(NodePattern.N.lemma("Buchstabe|.+Wort"), letter)).andNot(NodePattern.N.withHead("acl", NodePattern.N.withHead("xcomp", NodePattern.N.withDependent("nsubj(:pass)?|i?obj|obl|nmod|compound", letter))))).noDependents("advmod").message("Wenn die Gro\u00df- oder Kleinschreibung von W\u00f6rtern gemeint ist, nicht bezogen auf die Schriftgr\u00f6\u00dfe, schreiben Sie beide W\u00f6rter zusammen").and(WordSeparation.joinWithNextNode()), NodePattern.N.form("fu(ss|\u00df)((zu)?fassen|gefasst)").andOr(NodePattern.N.form(".+zufassen").correct(NodeCorrector.regexReplace("fu(.+)zu(fassen)", "Fu$1 zu $2")), NodePattern.N.correct(NodeCorrector.regexReplace("fu(.+)(fassen|gefasst)", "Fu$1 $2"))).andNot(withDependentsDetCaseAmod).message("Schreiben Sie \u201eFu\u00df fassen\u201c getrennt"), WordSeparation.verbsWithDrumHerum(), WordSeparation.verbsWithZurecht(), WordSeparation.verbsInFigurativeMeaning(), NodePattern.N.lemma("vorlassen").directlyAfter(NodePattern.N.form("au\u00dfen")).and((node, match) -> {
            String replacement = "au\u00dfen vor " + node.lowForm().substring(3);
            return match.withCorrector(NodeCorrector.replaceNodes(node.neighbor(-1), node, replacement)).withMessage("Im Sinne von \u201ejemanden ausschlie\u00dfen / nicht beteiligen / nicht informieren\u201c wird \u201eau\u00dfen vor lassen\u201c getrennt geschrieben");
        }), NodePattern.or(NodePattern.N.inFormSequence(1, "von", "statten").withHead(NodePattern.N.lemma("gehen")), NodePattern.N.inFormSequence(1, "zu", "teil")).withNeighbor(-1, NodePattern.N.markAs("Start")).andOr(NodePattern.N.form("teil").andNot(lastWordOrBeforeComma).andNot(NodePattern.N.withHead(NodePattern.N.lemma("werden|geworden"))).andNot(NodePattern.N.withDependent("appos", NodePattern.or(Capitalization.cardinal, NodePattern.N.form("[0-9]")))).correct(NodeCorrector.replace(NodePointer.neighbor(-1), "zum")).message("Meinten Sie \u201ezum Teil\u201c?"), NodePattern.N.directlyBeforeHead().and((middle, match) -> {
            Node start = match.getMarkedNode("Start");
            String replacement = start.lowForm() + middle.lowForm() + middle.neighbor(1).lowForm();
            return match.withCorrector(NodeCorrector.replaceNodes(start, middle.neighbor(1), replacement)).withMessage("Das Verb \u201e" + replacement + "\u201c wird zusammengeschrieben");
        }), NodePattern.N.directlyBefore(NodePattern.N.form("zu").directlyBeforeHead()).and((middle, match) -> {
            Node start = match.getMarkedNode("Start");
            String replacement = start.lowForm() + middle.lowForm() + "zu" + middle.neighbor(2).lowForm();
            return match.withCorrector(NodeCorrector.replaceNodes(start, middle.neighbor(2), replacement)).withMessage(INFINITIVE_WITH_ZU_MSG);
        }), lastWordOrBeforeComma.message("Meinten Sie das Verbpr\u00e4fix \u201e$Start$_\u201c?").and(CommonPatterns.forceConcatWithPrev)), NodePattern.N.lemma("kommen|halten").directlyAfter(NodePattern.or(NodePattern.N.form("gute").directlyAfter(NodePattern.N.form("zu").markAs("Start")), NodePattern.N.form("zugute").markAs("Start"))).and((node, match) -> {
            Node start = match.getMarkedNode("Start");
            String replacement = "zugute" + node.lowForm();
            return match.withCorrector(NodeCorrector.replaceNodes(start, node, replacement)).withMessage("Das Verb \u201e" + replacement + "\u201c wird zusammengeschrieben");
        }), NodePattern.or(alwaysInseparableVerbs.message("Untrennbare Verben werden immer zusammengeschrieben"), NodePattern.N.pos("VER:INF:NON|VER:IMP:PLU:SFT").directlyAfter(NodePattern.N.form("ge")).message("Beim Partizip Perfekt wird \u201ege-\u201c zusammengeschrieben")).and(CommonPatterns.forceConcatWithPrev), NodePattern.or(NodePattern.ROOT, NodePattern.N.withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis")).noLemma("abf\u00e4lschen|einen|entt\u00e4uschen|f\u00fchren|scheinen|sein|verlaufen|werden").directlyAfter(NodePattern.N.form("bei").directlyAfter(NodePattern.N.form("vor").andNot(NodePattern.N.afterHead().withHead(NodePattern.N.withDependent("case", NodePattern.N.form("a[mn]")))).markAs("Start"))).and((node, match) -> {
            Node start = match.getMarkedNode("Start");
            String replacement = "vorbei" + node.lowForm();
            return match.withCorrector(NodeCorrector.replaceNodes(start, node, replacement)).withMessage("Das Verb \u201e" + replacement + "\u201c wird zusammengeschrieben");
        }), NodePattern.N.lemma("machen").directlyAfter(NodePattern.or(NodePattern.N.form("nichte").directlyAfter(NodePattern.N.form("zu").markAs("Start")), NodePattern.N.form("zunichte").markAs("Start"))).and((node, match) -> {
            Node start = match.getMarkedNode("Start");
            String replacement = "zunichte" + node.lowForm();
            return match.withCorrector(NodeCorrector.replaceNodes(start, node, replacement)).withMessage("Das Verb \u201e" + replacement + "\u201c wird zusammengeschrieben");
        }), NodePattern.N.form("daraufhin").withHead(NodePattern.N.lemma("weisen|deuten").withDependent("ccomp").markAs("HeadVerb")).andOr(NodePattern.not(NodePattern.N.directlyBefore(NodePattern.N.alreadyMarkedAs("HeadVerb"))).correct(NodeCorrector.replace("darauf hin")).and((node, match) -> {
            Node headVerb = match.getMarkedNode("HeadVerb");
            return match.withMessage("\u201eHin\u201c ist ein trennbares Pr\u00e4fix von \u201e" + headVerb.lowForm() + "\u201c");
        }), NodePattern.N.directlyBefore(NodePattern.N.alreadyMarkedAs("HeadVerb")).and((node, match) -> {
            Node headVerb = match.findMarkedNode("HeadVerb");
            if (headVerb == null) {
                return null;
            }
            return match.withCorrector(NodeCorrector.replaceNodes(node, headVerb, "darauf hin" + headVerb.lowForm())).withMessage("Mit \u201ehin" + headVerb.lowForm() + "\u201c muss \u201edarauf\u201c getrennt geschrieben werden");
        })), drauflosVerb.andOr(NodePattern.N.directlyAfter(NodePattern.N.form("zu").directlyAfter(NodePattern.N.form("los").directlyAfter(NodePattern.N.form("drauf").markAs("Start")))), NodePattern.N.directlyAfter(NodePattern.N.form("los").directlyAfter(NodePattern.N.form("drauf").markAs("Start")))).and((node, match) -> {
            Node start = match.getMarkedNode("Start");
            String replacement = "draufloszu" + node.lowForm();
            return match.withCorrector(NodeCorrector.replaceNodes(start, node, replacement)).withMessage("Das Verb \u201e" + replacement + "\u201c wird zusammengeschrieben");
        }), NodePattern.N.form("(gut)(hab(en?|t)|has?t|gehaben|hatte(n|s?t))").withDependent("nsubj").noDependents("obj", NodePattern.N.noForm("es")).correct(NodeCorrector.regexReplace("gut(.+)", "gut $1")).message("Im Sinne von \u201ees geht jmdm. gut\u201c wird \u201ees gut haben\u201c getrennt geschrieben"), NodePattern.N.form("zulange").andOr(NodePattern.N.withHeadRelation("advmod"), NodePattern.N.withDependent("cop"), NodePattern.ROOT).correct(NodeCorrector.replace("zu lange")).message("Das Adverb \u201elange\u201c muss mit \u201ezu\u201c getrennt geschrieben werden"), NodePattern.or(infinitiveWithZuPhraseHead.andNot(NodePattern.N.directlyAfter(NodePattern.N.form("zu"))).andNot(NodePattern.custom(node -> GermanValences.get(node).stream().anyMatch(as -> as.hasAllObligatoryArguments((Node)node)))), NodePattern.N.withHead("xcomp", NodePattern.N.withDependent("cop")).noDependents().afterHead()).form("zu.+").noForm("zu(recht|sammen).+").correct(NodeCorrector.regexReplace("zu(.+)", "zu $1")).message("\u201eZu\u201c mit Infinitiven wird in Infinitivgruppen getrennt geschrieben"), NodePattern.N.inFormSequence(1, "zu", "er").withNeighbor(1, NodePattern.N.pos("VER:INF.*").markAs("Verb")).and((node, match) -> {
            String concat = node.form() + node.neighbor(1).form();
            if (node.tree().treeSupport().tagToken(concat).hasPos("VER.*")) {
                return match.withCorrector(NodeCorrector.replaceNodes(node, node.neighbor(1), concat));
            }
            return null;
        }).message("Meinten Sie das Verb \u201e$_$Verb\u201c?")).andNot(GermanTreePatterns.headInQuotes.andNot(GermanTreePatterns.clause.withOnlyDependents(NodePattern.or(CommonPatterns.insideQuotes, NodePattern.PUNCT))));
    }

    private static NodePattern verbsInFigurativeMeaning() {
        NodePattern personalPronInDative = NodePattern.N.pos("PRO:PER:DAT.*");
        NodePattern noIobj = NodePattern.N.noDependents("i?obj");
        NodePattern withIntensifierZu = NodePattern.N.withDependent("advmod", NodePattern.or(NodePattern.N.inFormSequence(0, "viel", "zu"), NodePattern.N.form("(all)?zu")));
        return NodePattern.or(NodePattern.N.form("wach").withHead(NodePattern.N.lemma("halten").markAs("Verb").andNot(withAnimateOrReflOrName).andNot(withPartsOfDayOrTime)), NodePattern.N.form("nahe").withHead(NodePattern.N.lemma("treten|stehen|gehen|bringen").markAs("Verb").withDependent("i?obj", NodePattern.or(SemanticRules.animate, NodePattern.N.form("Bantu"), NodePattern.N.pos("PRO:(POS|PER).*"), NodePattern.N.pos("EIG.*"), einanderGegenseitig))).andNot(withIntensifierZu), NodePattern.N.form("schief").withHead(NodePattern.N.lemma("(gehen|laufen)|lachen|liegen").markAs("Verb")).and(NodePattern.N.noDependents("advmod")), NodePattern.N.form("schwer").withHead(NodePattern.N.lemma("fallen|tun").markAs("Verb").andOr(NodePattern.N.withDependent("i?obj", NodePattern.or(SemanticRules.animate, personalPronInDative, NodePattern.N.pos("PRO:REF.*"))), noIobj).noDependents("obl", NodePattern.N.withDependent("case", NodePattern.N.form("vo[nm]|aus|nach")))).andNot(withIntensifierZu), NodePattern.N.form("klar").withHead(NodePattern.N.lemma("machen").markAs("Verb").andOr(NodePattern.N.withDependent("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.lemma("Schiff|Leine")), NodePattern.N.withDependent("i?obj", NodePattern.or(personalPronInDative, SemanticRules.animate, NodePattern.N.pos("(ART:DEF|PRO:PER):AKK.*"))), noIobj)).noDependents("nsubj"), NodePattern.N.form("kalt").withHead(NodePattern.N.lemma("stellen|lassen").markAs("Verb").andOr(NodePattern.N.withDependent("obj", NodePattern.or(NodePattern.N.pos(".*AKK.*").and(SemanticRules.animate), NodePattern.N.pos("PRO:PER:AKK.*"))).andNot(NodePattern.N.withHead(NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound").andNot(SemanticRules.animate))).andNot(CommonPatterns.possiblyConj(NodePattern.N.withHead(NodePattern.N.withDependent("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.not(SemanticRules.animate))))), NodePattern.N.withDependent("obj", NodePattern.or(NodePattern.N.pos("PRO:REF:AKK.*"), NodePattern.N.lemma("Konkurrenz"))), NodePattern.N.withDependent("advmod", einanderGegenseitig))), NodePattern.N.form("gut").andOr(NodePattern.N.withHead(NodePattern.N.lemma("hei(ss|\u00df)en").markAs("Verb")).withHead(NodePattern.N.withDependent("obj", NodePattern.or(NodePattern.N.pos(".*AKK.*"), NodePattern.N.form("etwas")))), NodePattern.N.withHead(NodePattern.N.lemma("schreiben|haben").markAs("Verb").withDependent("i?obj|obl", NodePattern.or(NodePattern.N.lemma("(.*)(Betrag|Konto|Provision|Geb\u00fchr|Summe|Geld|Kosten|Punkt|Goal|Guthaben|Bonus|Rabatt|Zins|Zahlung|Ver(g\u00fctung|m\u00f6gen)|Entsch\u00e4digung|Pr\u00e4mie|Rechnung|Gewinn|Zuschuss|Erstattung|Gut(schrift|haben)|Kredit|R\u00fcckstand|Mittel|Dividende|\u00dcberweisung|(Gegen)?wert|(Geld)?menge|Nachlass|Bestand|Kaution)|[$\u00a3\u20ac\u00a5\u20bd]"), NodePattern.N.pos("PRO:REF.*").noDependents("case"), NodePattern.N.form("Touchdowns?"), SemanticRules.currencyName))), NodePattern.N.withHead(NodePattern.N.lemma("sagen").markAs("Verb").withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("f\u00fcr")))), NodePattern.N.withHead(NodePattern.N.lemma("sprechen").markAs("Verb").and(CommonPatterns.possiblyConj(NodePattern.N.withDependent("i?obj", NodePattern.or(NodePattern.N.pos(".*DAT.*"), einanderGegenseitig)))).andNot(CommonPatterns.possiblyConj(NodePattern.N.withDependent("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.label("LANGUAGE")))))), NodePattern.N.form("glatt").withHead(NodePattern.or(NodePattern.N.lemma("(gehen|laufen)|stellen"), NodePattern.N.lemma("machen").withDependent("obj", NodePattern.N.lemma("Rechnung|(Geld)?schuld"))).markAs("Verb"))).andOr(NodePattern.N.directlyBefore(NodePattern.N.form("zu")).withNeighbor(2, NodePattern.N.alreadyMarkedAs("Verb")).and(WordSeparation.joinThreeNodes()), NodePattern.N.directlyBeforeHead().andOr(NodePattern.N.directlyAfter(NodePattern.N.form("f\u00fcr")).directlyBefore(NodePattern.N.form("hei(ss|\u00df)en")).and((node, match) -> {
            String replacement = node.form() + node.neighbor(1).form();
            return match.withCorrector(NodeCorrector.replaceNodes(node.neighbor(-1), node.neighbor(1), replacement));
        }), WordSeparation.joinWithNextNode())).andNot(NodePattern.N.withHead(NodePattern.N.withHeadRelation("nsubj"))).message("In \u00fcbertragener Bedeutung schreiben Sie \u201e$_$Verb\u201c zusammen");
    }

    private static NodePattern verbsWithZurecht() {
        NodePattern beforeZu = NodePattern.N.directlyBefore(NodePattern.N.form("zu"));
        NodePattern zurecht = NodePattern.N.form("zurecht");
        return NodePattern.or(zurecht.withHeadRelation("advmod").message("Meinten Sie \u201ezu Recht\u201c (im Sinne von \u201eberechtigterweise\u201c)?").correct(NodeCorrector.replace("zu Recht")), NodePattern.or(zurecht.withHeadRelation("compound:prt|mark").markAs("Start").andOr(NodePattern.N.directlyBeforeHead().and(WordSeparation.joinWithNextNode()), beforeZu.and(WordSeparation.joinThreeNodes())), NodePattern.N.formCaseSensitive("recht").directlyAfter(SpellingRules.zu.markAs("Start")).andOr(NodePattern.N.directlyBeforeHead().and(NodePattern.markedNodeMatches("Start", WordSeparation.joinThreeNodes())), NodePattern.markedNodeMatches("Start", WordSeparation.joinWithNextNode()).correct(NodeCorrector.replace("Recht")))).withHead(verbsWithPrefixZurecht.markAs("End")).message("Meinten Sie das Verbpr\u00e4fix \u201ezurecht\u201c oder \u201ezu Recht\u201c (im Sinne von \u201eberechtigterweise\u201c)?").andOptionally(NodePattern.or(NodePattern.N.directlyBeforeHead(), beforeZu).andNot(NodePattern.N.withHead(NodePattern.N.lemma("kommen").withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("mit"))))).and((node, match) -> {
            Node start = match.getMarkedNode("Start");
            Node end = match.getMarkedNode("End");
            String verb = node.neighbor(1).hasForm("zu.+") ? "zu " + end.form().substring("zu".length()) : (node.neighbor(1).hasForm("zu") ? "zu " + end.form() : end.form());
            return match.withCorrector(NodeCorrector.replaceNodes(start, end, "zu Recht " + verb));
        })));
    }

    private static NodePattern infinitiveWithPrefixBeforeZu(NodePattern separablePrefix) {
        return zuNotAdvmod.andOr(NodePattern.N.directlyBefore(NodePattern.N.lemma("zu((arbeit|bau|bei(\u00df|ss)|bekomm|bereit|betonier|billig|bind|bring|deck|denk|dien|diktier|dreh|dr\u00fcck|eign|erkenn|fall|fax|flieg|flie(\u00df|ss)|frier|f\u00fcg|f\u00fchr|ge[bh]|(ge)?h\u00f6r|gesell|gesteh|gie(\u00df|ss)|greif|hak|halt|h\u00e4ng|hau|heil|jauchz|kauf|kehr|kiff|kleb|klink|klapp|knall|kn\u00f6pf|komm|kork|krieg|lach|lad|lang|lass|lauf|leg|leit|l\u00f6t|mach|mess|misch|mut|n\u00e4h|nehm|neig|ordn|pack|park|pfropf|prost|rat|raun|rechn|red|reich|reit|richt|roll|ruf|r\u00fcst|sag|schal[tz]|schau|schick|schieb|schl?ie(ss|\u00df)|schlag|schmei(\u00df|ss)|schmier|schnall|schnapp|schneid|schn\u00fcr|schraub|schreib?|sch\u00fctt|schwell|s\u00e4g|seh|send|setz|sperr|spiel|spitz|sprech|spring|stec[hk]|steh|stell|stimm|stopf|sto(\u00df|ss)|streb|str\u00f6m|st\u00fcrz|text|teil|trag|trau|treff|trink|wachs|wart|weis|werf|wink|zieh)en|zurren|(sich|fl\u00fcst)ern)")).and(WordSeparation.joinWithNextNode()), NodePattern.N.directlyBefore(NodePattern.N.pos("VER:INF:.*").andNot(NodePattern.N.form("sein").andNot(NodePattern.N.inFormSequence(2, "los", "zu", ".*"))).markAs("Verb")).directlyAfter(NodePattern.or(NodePattern.N.withHead(NodePattern.N.alreadyMarkedAs("Verb")), NodePattern.N.inFormSequence(0, "hinweg", "zu", "kommen")).andOr(separablePrefix, NodePattern.N.form("zu"), NodePattern.N.inFormSequence(0, "sicher", "zu", "gehen")).markAs("Prefix")).and((zu, match) -> {
            Node prefix = match.getMarkedNode("Prefix");
            Node verb = match.getMarkedNode("Verb");
            String concat = (!CommonPatterns.firstToken.matches(prefix) ? prefix.lowForm() : prefix.form()) + "zu" + verb.lowForm();
            return match.withCorrector(NodeCorrector.rawReplace(prefix.startOffset(), verb.endOffset(), concat));
        })).message(INFINITIVE_WITH_ZU_MSG);
    }

    private static NodePattern verbsWithDrumHerum() {
        return NodePattern.or(NodePattern.N.form("da?rumherum").directlyBefore(NodePattern.N.pos("VER:(INF|PA2):(SFT|NON)").noLemma("sein|entstehen")).and((node, match) -> {
            String concat = "herum" + node.neighbor(1).form();
            if (node.tree().treeSupport().tagToken(concat).hasPos("VER.*")) {
                String adv = node.hasForm("darum.+") ? "darum" : "drum";
                return match.withCorrector(NodeCorrector.replace(node.neighbor(1), adv + " herum" + node.neighbor(1).form()).join(NodeCorrector.removeNode(node)));
            }
            return null;
        }), NodePattern.N.form("da?rumherum.+").noPos().correct(NodeCorrector.regexReplace("d(a)?rum(.*)", "d$1rum $2"))).andNot(withDependentsDetCaseAmod).andNot(NodePattern.N.withHeadRelation("advmod").afterHead()).message("\u201eD(a)rum\u201c wird getrennt geschrieben, \u201eherum\u201c ist ein Verbpr\u00e4fix");
    }

    private static NodePattern wordsStartingWithMass() {
        return NodePattern.or(mass.directlyBefore(wordsStartingWithMass.message("Das Wort \u201ema\u00df$_\u201c wird zusammengeschrieben")).noDependents(withDependentsDetCaseAmod), NodePattern.N.formCaseSensitive("ma(\u00df|ss)").directlyBefore(halten.message("Die empfohlene Schreibung ist \u201ema\u00df$_\u201c"))).and(WordSeparation.joinWithNextNodeBothLowForm());
    }

    static NodePattern nounSeparation() {
        String singleWord = "(Bachelor|Master)(abschluss|studium)|Fragezeichens?|Pflege(fall(e?s)?|f\u00e4llen?)|Studentenwohnheim(e?s|en?)?|Fu(ss|\u00df)ballspieler(in(nen)?|[sn])?|Weltkriege?s?|Deutschkurs(es?)?|Tagesreisen?|(Abend|Mittag)essens?|Pr\u00e4sidentenmaschinen?|Praxisf\u00e4higkeit(en?)";
        NodePattern candidateWithDependentFlat = NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound").withDependent("flat", NodePattern.N.directlyAfterHead().noDependents("punct", CommonPatterns.HYPHEN_NODE).noPos("ZAL").noLabel("EVENT|PERSON|GEO_POLITICAL_ENTITY")).andNot(CommonPatterns.lowercasedHasPos("Adj.*").andNot(NodePattern.N.noPos(".*PRD:GRU"))).noLabel("PRODUCT|PERSON").noDependents("punct", CommonPatterns.HYPHEN_NODE).andNot(NodePattern.N.directlyAfter(GermanTreePatterns.openingQuotation));
        NodePattern labels = NodePattern.N.label("PERSON|ORGANIZATION");
        NodePattern location = NodePattern.N.label("LOCATION");
        NodePattern formStartsWithTwoCapitalLetters = NodePattern.N.formCaseSensitive("[A-Z]{2}.*");
        NodePattern noSpaceNumNoun = NodePattern.N.form("\\d(Zimmer|Tage|Sterne|Zoll|Stunden|Farben|Minuten|G\u00e4nge|Jahres|L\u00e4nder|Klassen|Seiten)");
        NodePattern riesenDank = NodePattern.N.inFormSequence(1, "Riesen", "Dank");
        NodePattern willenOrMail = NodePattern.N.form("Willen|Mail");
        NodePattern product = NodePattern.N.label("PRODUCT");
        NodePattern ersteHilfeTerms = NodePattern.N.inFormSequence(1, "Erste", "Hilfe").withNeighbor(-1, NodePattern.N.markAs("Start")).directlyBefore(wordsMakeCompoundWithErsteHilfe.markAs("End"));
        return NodePattern.or(WordSeparation.threeWordCompoundNoun(), WordSeparation.nounsStartingWithRiesen(), WordSeparation.compoundNounsFormedByAdjOrAdverbAndNouns(), NodePattern.or(candidateWithDependentFlat, NodePattern.N.directlyBeforeHead().withHead("compound", SpellingRules.noun.andNot(labels).andNot(willenOrMail).andNot(riesenDank).andNot(formStartsWithTwoCapitalLetters))).noDependents("nummod").andNot(englishWordsInSequence).andOr(SemanticRules.units, NodePattern.custom(first -> {
            AgreementSet headSet = AgreementSet.createRelaxed(Objects.requireNonNull(first.head()));
            if (headSet == null) {
                return false;
            }
            AgreementSet firstSet = headSet.withMain((Node)first);
            if (firstSet == null) {
                return false;
            }
            return firstSet.hasGovernmentIssue() || firstSet.hasAgreementIssue();
        }), noSpaceNumNoun).and((node, match) -> {
            Node next = node.neighbor(1);
            Node prev = node.prevNode();
            if (prev != null && prev.prevNode() != null) {
                if (noSpaceNumNoun.matches(node)) {
                    return match.withCorrector(NodeCorrector.replaceNodes(node, next, node.form().charAt(0) + "-" + node.form().substring(1) + "-" + next.form()));
                }
                String firstPartHyphenSecondPart = node.form() + "-" + next.form();
                if (prev.hasForm("-") && !prev.prevNode().hasForm("anti")) {
                    return match.withCorrector(NodeCorrector.replaceNodes(node, next, firstPartHyphenSecondPart));
                }
            }
            return makeCompoundWithNext.match(node, match);
        }), NodePattern.or(candidateWithDependentFlat, NodePattern.N.directlyBeforeHead().withHead("compound|nmod", NodePattern.or(SpellingRules.noun, NodePattern.N.noPos()).noHeadRelation("amod").andNot(labels).andNot(willenOrMail).andNot(riesenDank).andNot(formStartsWithTwoCapitalLetters)).andOr(NodePattern.N.withDependent("case", NodePattern.N.form("von")), NodePattern.N.withDependent("det", NodePattern.N.form("alle")), NodePattern.N.noDependents().andNot(SemanticRules.dayOfWeek.directlyBefore(NodePattern.N.form("((nach|vor)?mittag|abend|nacht|morgen)"))))).andOr(NodePattern.not(englishWordsInSequence), NodePattern.N.inFormSequence(0, "Bade?", "Zimmer"), NodePattern.N.inFormSequence(0, "Bar", "Geld")).andNot(NodePattern.N.inFormSequence(1, "ein", "zimmer", "wohnung(en)?")).noLabel("PERSON|MISC|GEO_POLITICAL_ENTITY|ORGANIZATION|NATIONALITY_OR_GROUP").andNot(location.noForm("S\u00fcd|Nord").andNot(NodePattern.N.withHead(location))).noForm("Anfang|Mitte|Ende|Herr|Frau|Unions|menge").andNot(NodePattern.N.inFormSequence(0, "Blick", "Kick")).andNot(NodePattern.N.inFormSequence(0, relativeDays, "((nach|vor)?mittag|abend|nacht|morgen)")).andNot(NodePattern.N.inFormSequence(0, "Arbeite", "Reis")).andNot(NodePattern.N.inFormSequence(0, "Laut", "Musik")).andNot(NodePattern.N.inFormSequence(0, "Herren", "Wohnungsamt")).andNot(NodePattern.N.inFormSequence(0, "Tagesbuch", "Format")).andNot(NodePattern.N.inFormSequence(0, "Gaste|Gr\u00f6\u00dfe", ".*").withNeighbor(1, CommonPatterns.capitalizedHasPos("SUB.*"))).andNot(NodePattern.N.label("LANGUAGE").pos("SUB.*SIN:NEU").directlyBefore(NodePattern.N.lemma("Sprache"))).andNot(NodePattern.N.directlyAfter(NodePattern.N.noPos().withHeadRelation("compound|case"))).andNot(Capitalization.cardinal.and(CommonPatterns.capitalized).directlyBefore(NodePattern.N.lemma("Besen|Kaiser|K\u00f6nig|Zwerg|Apostel|Gebot"))).andNot(NodePattern.N.inFormSequence(0, "Echtzeit", ".+erkennung")).and(makeCompoundWithNext), CommonPatterns.capitalized.markAs("First").noDependents().directlyBefore(NodePattern.N.markAs("Second").pos("VER:INF.*").noDependents("punct", GermanTreePatterns.anyQuotation).noDependents("aux|nsubj").andNot(NodePattern.N.withHead("conj", NodePattern.N.withDependent("aux|nsubj"))).noDependents("nmod", NodePattern.N.beforeHead())).withHead("compound|obj", NodePattern.N.alreadyMarkedAs("Second").withDependent("case", NodePattern.N.before("First"))).and((first, match) -> {
            Node second = match.getMarkedNode("Second");
            return match.withCorrector(NodeCorrector.replaceNodes(first, second, first.form() + second.lowForm())).withReportedNodes(first, second);
        }), CommonPatterns.capitalized.and(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound|root"))).directlyBefore(CommonPatterns.skipForward(CommonPatterns.HYPHEN_LIKE_NODE, CommonPatterns.capitalized.and(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound|root|dep|appos|flat"))).markAs("Second"))).and(NodePattern.custom((first, match) -> {
            Node second = match.getMarkedNode("Second");
            String concat = first.form() + second.lowForm();
            if (!concat.matches(singleWord)) {
                return null;
            }
            return match.withCorrector(NodeCorrector.replaceNodes(first, second, concat)).withReportedRange(first.startOffset(), second.endOffset(), first.tree());
        })), NodePattern.or(CommonPatterns.capitalized.directlyBefore(CommonPatterns.capitalized.markAs("Second")).andOr(NodePattern.N.inFormSequence(0, "PCR|Antigen", "Tests?"), NodePattern.N.form("PCR").withDependent("appos", SpellingRules.noun), NodePattern.N.form("HNO").andOr(NodePattern.N.withHead("compound", SpellingRules.noun).directlyBeforeHead(), NodePattern.N.withDependent("flat", NodePattern.N.directlyAfterHead())), SpellingRules.noun.withDependent("case", NodePattern.N.directlyBeforeHead().noForm("pro")).directlyBeforeHead().withHead("nmod", SpellingRules.noun.withHeadRelation("nmod").noDependents("case")), NodePattern.N.inFormSequence(0, "Krypto", "M[a\u00e4]rkt.*"), NodePattern.N.form("Support").withDependent("appos|flat", SpellingRules.noun.directlyAfterHead()).noHeadRelation("appos|flat"), NodePattern.or(NodePattern.or(NodePattern.N.label("MISC|ORGANIZATION|PRODUCT"), SpellingRules.noun.label("EVENT|NATIONALITY_OR_GROUP"), NodePattern.N.noPos().label("GEO_POLITICAL_ENTITY")).andOr(AgreementSet.agreementIssues, NodePattern.N.form("(Libre|Open|Star)Office"), Case.hasMisparsedFlatHeadDependent.andNot(NodePattern.N.withOnlyDependents(NodePattern.or(NodePattern.N.withHeadRelation("nummod"), NodePattern.N.afterHead())))).andNot(NodePattern.N.withDependent("flat", NodePattern.N.label("PERSON"))).andNot(NodePattern.N.onlyPos("SUB:GEN:SIN.*")).andNot(NodePattern.N.inFormSequence(0, "Governance", "Kodex")).andNot(NodePattern.N.inFormSequence(1, "roten?", "Armee", "Fraktion")).andNot(NodePattern.N.pos("EIG.*STD")), NodePattern.N.pos("SUB:GEN:PLU.*").noPos("SUB:.*SIN.*").withDependent("amod").withDependent("det").directlyBefore(SpellingRules.noun), NodePattern.N.noPos().directlyBefore(NodePattern.N.form("Lizenz|Konfiguration"))).withDependent("appos|flat", SpellingRules.noun.alreadyMarkedAs("Second").andNot(NodePattern.N.formCaseSensitive("[A-Z\u00c4\u00d6\u00dc][a-z\u00e4\u00f6\u00fc\u00df]*[A-Z\u00c4\u00d6\u00dc]")).andNot(GermanTreePatterns.englishWord).noDependents(NodePattern.N.label("PERSON")).noDependents(NodePattern.N.withHeadRelation("appos|flat").andNot(product)).andNot(NodePattern.N.label("GEO_POLITICAL_ENTITY")).andNot(NodePattern.N.noSpaceAfter().directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE))).andNot(SemanticRules.currencyName).andNot(NodePattern.N.withHeadRelation("obl").andNot(NodePattern.N.label("NATIONALITY_OR_GROUP|GEO_POLITICAL_ENTITY|PRODUCT"))).andNot(NodePattern.N.label("PRODUCT").directlyBefore(NodePattern.N.label("PRODUCT")).noDependents("det|amod")), GermanTreePatterns.englishCompoundEmbeddingToHyphenate.andNot(NodePattern.N.withHead("obl", Case.definitelyTransitive.noDependents("obj")))).andOr(NodePattern.not(SemanticRules.units).and(NodePattern.N.noForm("Menge")), NodePattern.N.directlyAfter(CommonPatterns.HYPHEN_NODE)).andNot(NodePattern.N.withHead("nsubj", Case.definitelyTransitive.andOr(NodePattern.N.noDependents("obj"), NodePattern.N.withDependent("obj", NodePattern.N.withDependent("case"))))).andNot(NodePattern.N.label("GEO_POLITICAL_ENTITY").directlyBefore(NodePattern.N.label("LOCATION"))).andNot(NodePattern.N.directlyBefore(CommonPatterns.lowercasedHasPos("ZAL.*"))).noForm("Visual").noDependents("nummod").andNot(NodePattern.N.directlyAfter(GermanTreePatterns.openingQuotation)).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("Studio"))).andNot(NodePattern.N.directlyAfter(NodePattern.N.pos(predicativeAdj))), NodePattern.N.label("PRODUCT|ORGANIZATION").withDependent("case", NodePattern.N.pos(".*GEN.*")).withDependent("appos", NodePattern.N.pos("SUB:GEN:.*").directlyAfterHead().noLabel("PRODUCT").markAs("Second"))).andOr(makeCompoundWithNext, NodePattern.custom(hyphenateNeighbors)), NodePattern.or(NodePattern.N.form("content|e|WLAN|Bluetooth").withDependent("flat|appos", NodePattern.N.directlyAfterHead().noForm("Mail.*")).withDependent("case|det(:poss)?|amod"), GermanTreePatterns.englishWord.withDependent("flat", GermanTreePatterns.englishWord.directlyAfterHead().directlyBefore(CommonPatterns.HYPHEN_NODE.markAs("Hyphen").noSpaceBefore())).withDependent("flat", NodePattern.N.directlyAfter(NodePattern.N.alreadyMarkedAs("Hyphen")).noLabel("PERSON").andNot(NodePattern.N.directlyBefore(GermanTreePatterns.englishWord.withHeadRelation("flat")))).andNot(NodePattern.N.inFormSequence(0, "git", "filter", "-", "repo").withHead(NodePattern.N.lemma("ausf\u00fchren"))).noForm("#|[$\u00a3\u20ac\u00a5\u20bd]").noPos("PRP.*").andNot(product.directlyBefore(product)).andNot(NodePattern.N.inFormSequence(0, "Single", "Sign", "-", "On")).andNot(NodePattern.N.inFormSequence(0, "Channel", "space", "-", "insiders")).noDependents("amod", NodePattern.N.withDependent("compound", product)).andNot(NodePattern.N.withHead("nsubj", NodePattern.N.pos("VER.*").and(Case.definitelyTransitive).noDependents("i?obj"))), CommonPatterns.capitalizedHasPos("SUB:GEN:SIN.*").markAs("FirstCompound").withHead("compound", NodePattern.N.withDependent("compound", CommonPatterns.possiblySkipDown("compound", GermanTreePatterns.englishWord.directlyAfter(NodePattern.N.alreadyMarkedAs("FirstCompound"))))).andNot(GermanTreePatterns.englishWord)).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("['`\u00b4\u2019]s"))).andNot(NodePattern.N.directlyAfter(GermanTreePatterns.openingQuotation)).andOr(NodePattern.markedNodeMatches("FirstCompound", NodePattern.custom((node, match) -> match.withCorrector(NodeCorrector.replaceNodes(node, node.neighbor(1), StringTools.uppercaseFirstChar((String)node.form()) + "-" + node.neighbor(1).form())))), NodePattern.custom(hyphenateNeighbors)), NodePattern.N.inFormSequence(0, "dolce", "far", "niente").and(withDependentsDetCaseAmod).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(2), "Dolcefarniente")), SemanticRules.dayOfWeek.markAs("FirstDayOfWeek").andOr(NodePattern.or(NodePattern.N.directlyBefore(NodePattern.N.form("((nach|vor)?mittag|abend|nacht|morgen)").and(withDependentsDetCaseAmod)), withDependentsDetCaseAmod.directlyBefore(NodePattern.N.form("((nach|vor)?mittag|abend|nacht|morgen)"))).and(makeCompoundWithNext), withDependentsDetCaseAmod.markAs("Start").andOptionally(NodePattern.N.withDependent("conj", SemanticRules.dayOfWeek.andNot(NodePattern.N.directlyBefore(NodePattern.N.form("((nach|vor)?mittag|abend|nacht|morgen)"))).markAs("Middle"))).withDependent("conj", SemanticRules.dayOfWeek.directlyBefore(NodePattern.N.form("((nach|vor)?mittag|abend|nacht|morgen)")).and((node, match) -> {
            String compound = node.form() + node.neighbor(1).lowForm();
            Node start = match.getMarkedNode("Start");
            Node middle = match.findMarkedNode("Middle");
            return match.withCorrector(NodeCorrector.replaceNodes(node, node.neighbor(1), compound).join(middle != null && SemanticRules.dayOfWeek.matches(start.neighbor(1)) ? NodeCorrector.insertAfter(start, "-,") : NodeCorrector.insertAfter(start, "-")).join(middle != null ? NodeCorrector.insertAfter(middle, "-") : null));
        })), withDependentsDetCaseAmod.markAs("Start").directlyBefore(SemanticRules.dayOfWeek.directlyBefore(NodePattern.N.form("((nach|vor)?mittag|abend|nacht|morgen)")).and((node, match) -> {
            String compound = node.form() + node.neighbor(1).lowForm();
            return match.withCorrector(NodeCorrector.replaceNodes(node, node.neighbor(1), compound).join(NodeCorrector.insertAfter(match.getMarkedNode("Start"), "-,")));
        }))), NodePattern.or(NodePattern.N.inFormSequence(0, "Reihen", "Folgen?").andNot(NodePattern.N.withNeighbor(1, NodePattern.ROOT)), NodePattern.N.inFormSequence(0, "Boulevard", "Pressen?"), NodePattern.N.label("MISC").withHead("compound", NodePattern.N.lemma("Pflanze")), NodePattern.N.inFormSequence(0, "Bruder", "Stuhls?|St\u00fchlen?"), NodePattern.N.form("Krypto").directlyBeforeHead().withHead("compound", SpellingRules.noun), NodePattern.N.inFormSequence(0, "Task", "Forces?").noLabel("ORGANIZATION"), NodePattern.N.inFormSequence(0, "Nach", "L\u00e4ssigkeit").andOr(NodePattern.N.withNeighbor(1, NodePattern.N.afterHead().withHead("nmod", NodePattern.N.withHeadRelation("nsubj").pos("ADJ.*").withDependent("det(:poss)?", NodePattern.N.beforeHead()))), NodePattern.N.directlyAfter(NodePattern.or(NodePattern.N.withHeadRelation("case"), NodePattern.N.pos("PRO:(DEM|POS).*"))), NodePattern.N.withNeighbor(1, NodePattern.N.withHead("obl", NodePattern.or(NodePattern.N.noDependents("nsubj(:pass)?"), NodePattern.N.withDependent("nsubj", NodePattern.N.form("etwas"))))), NodePattern.N.withNeighbor(1, NodePattern.N.withHead("conj", NodePattern.N.withHeadRelation("nsubj(:pass)?")))), NodePattern.N.inFormSequence(0, "sieben", "Sachen").withNeighbor(1, withDependentsDetCaseAmod), NodePattern.N.inFormSequence(0, "zur", "Verf\u00fcgungstell(ung|en)"), NodePattern.N.inFormSequence(0, "Schnick", "Schnack(e?s)?"), NodePattern.N.inFormSequence(0, "bekannt", "werden").directlyAfter(NodePattern.N.form("seit|nach")), NodePattern.N.inFormSequence(0, "Eins", "sein").and(withDependentsDetCaseAmod).withNeighbor(1, NodePattern.N.pos("VER.*")), NodePattern.N.inFormSequence(0, "Style", "Guides").and(withDependentsDetCaseAmod)).and(makeCompoundWithNext), NodePattern.N.inFormSequence(0, "Biker", "Boots?").and(hyphenateNeighbors), NodePattern.N.inFormSequence(1, "Universit\u00e4ts?", "studiumabschl(u(ss|\u00df)(es)?|\u00fc(ss|\u00df)en?)").correct(NodeCorrector.regexReplace("studium(.*)", "Universit\u00e4ts$1").join(NodeCorrector.replace(NodePointer.neighbor(-1), "")))).andNot(NodePattern.or(nonstopFlugOrKino, rabattCode)).noPos("PRO:IND.*").andNot(NodePattern.N.directlyBefore(NodePattern.N.label("PERSON"))).andNot(NodePattern.N.inFormSequence(0, "komplett", "Spektrum")).andNot(GermanTreePatterns.englishWord.form(".+ed").noPos()).andNot(NodePattern.N.inFormSequence(0, "steil", "Berg").withNeighbor(2, anAbAuf)).andNot(NodePattern.N.inFormSequence(0, "Menge", "Firma")).andNot(NodePattern.N.inFormSequence(0, "Heimatlandes", "Traditionen")).andNot(NodePattern.N.inFormSequence(0, "Interesse", "Frauen")).andNot(NodePattern.N.inFormSequence(0, "Gottes", "Wort|N\u00e4he|Wege|Freund.*")).andNot(NodePattern.N.inFormSequence(0, "sch\u00f6n", "Gr[\u00fcu]\u00df(en?)?|Tage?")).andNot(NodePattern.N.inFormSequence(0, "Teufels", "K\u00fcche").label("LOCATION")).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("Fu\u00dffassen"))).andNot(NodePattern.or(NodePattern.N.form("email"), NodePattern.N.inFormSequence(0, "e", "-", "mail"))).andNot(NodePattern.N.withHead(NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound").pos("VER:INF.*").withDependent("conj", NodePattern.N.onlyPos("VER.*")))).andNot(ersteHilfeTerms).andNot(Capitalization.eineHandvoll.withDependent("flat", NodePattern.N.directlyAfterHead())).andNot(abbrAsPartOfCompound).andNot(masterBachelorCompound).message(JOIN_WORDS_MSG);
    }

    private static NodePattern compoundsContainAbbr() {
        NodePattern organisation = NodePattern.N.label("ORGANIZATION");
        NodePattern nounAfterHead = SpellingRules.noun.form("[a-z]+").directlyAfterHead().andNot(GermanTreePatterns.englishWord).andNot(NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("flat|appos")));
        NodePattern beforeHyphen = NodePattern.N.directlyBefore(NodePattern.N.alreadyMarkedAs("Hyphen"));
        return abbrAsPartOfCompound.andOr(NodePattern.or(NodePattern.N.noPos().andOr(NodePattern.N.label("GEO_POLITICAL_ENTITY|MISC|EVENT|ORGANIZATION").withDependent("flat|appos", SpellingRules.noun.directlyAfterHead().noLabel(".*")).andOr(NodePattern.N.withHead("appos", NodePattern.N.pos("EIG.*")), NodePattern.or(CommonPatterns.possiblyConj(withDependentsDetCaseAmod), NodePattern.N.directlyBefore(SemanticRules.job)).noForm("RR")), NodePattern.N.label("PRODUCT").withDependent("det(:poss)?").withDependent("flat", nounAfterHead), NodePattern.N.label(".*").directlyBeforeHead().withHead("compound", SpellingRules.noun.andOr(withDependentsDetCaseAmod, SemanticRules.job).andNot(NodePattern.N.withDependent("case", NodePattern.N.noPos(".*")))), NodePattern.N.noLabel(".*").withDependent("flat", nounAfterHead).withHead("nsubj", NodePattern.N)).andNot(SemanticRules.currencyName).andNot(NodePattern.N.withDependent("flat", NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("flat")))).andNot(organisation.directlyBefore(organisation)), SpellingRules.noun.andOr(NodePattern.N.label("PRODUCT").withDependent("flat", nounAfterHead.label("PRODUCT")), NodePattern.N.label("ORGANIZATION").withDependent("flat|appos", nounAfterHead.noPos("EIG.*").noDependents("flat|appos")).andNot(NodePattern.N.onlyPos("SUB:GEN.*")).noForm("FC|TSV").andNot(organisation.directlyBefore(organisation.andOr(NodePattern.N.pos("EIG.*"), NodePattern.N.form("Schweiz")))), NodePattern.N.andOr(NodePattern.N.label("GEO_POLITICAL_ENTITY|EVENT|MISC|LOCATION|LAW"), NodePattern.N.noLabel(".*")).withDependent("appos|flat", SpellingRules.noun.directlyAfterHead().andNot(NodePattern.N.label("MISC").withDependent("nmod", NodePattern.N.label("MISC")))).andNot(GermanTreePatterns.englishWord.directlyBefore(GermanTreePatterns.englishWord).andOr(NodePattern.N.withDependent("case", NodePattern.N.pos(".*DAT\\+AKK")), NodePattern.N.noDependents("det(:poss)?"))), NodePattern.N.directlyBeforeHead().withHead("compound", SpellingRules.noun)).andOr(withDependentsDetCaseAmod, NodePattern.N.directlyAfter(CommonPatterns.HYPHEN_LIKE_NODE.markAs("Hyphen")).andOr(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("compound").and(beforeHyphen)), NodePattern.N.withDependent("compound", beforeHyphen))), NodePattern.N.form("E(U|DV)").withDependent("appos", SpellingRules.noun.directlyAfterHead())).and(hyphenateNeighbors), NodePattern.or(SpellingRules.noun.withDependent("appos|flat|compound", NodePattern.N.form(".+s").directlyBeforeHead().noDependents("compound")), NodePattern.N.inFormSequence(1, "Kabel", "TV").andOr(NodePattern.N.directlyAfterHead(), NodePattern.N.withNeighbor(-1, NodePattern.N.directlyBeforeHead()))).withNeighbor(-1, NodePattern.N.and(hyphenateNeighbors))).message(JOIN_WORDS_MSG);
    }

    private static NodePattern compoundNounsFormedByAdjOrAdverbAndNouns() {
        NodePattern einOrDas = NodePattern.N.form("ein(e[sm])?|d[ae]s|dem");
        return NodePattern.or(NodePattern.or(NodePattern.N.pos(predicativeAdj).noPos("ADV.*MOD").noPos("ADJ.*(SOL|DEF|IND)").noForm("k\u00fchl|einfach").markAs("FirstPart").directlyBeforeHead().withHead("amod|advmod|compound", NodePattern.or(SpellingRules.noun, NodePattern.N.noPos()).and(CommonPatterns.capitalized).andNot(NodePattern.N.withDependent("case", NodePattern.not(NodePattern.N.form("als").directlyBefore(NodePattern.N.alreadyMarkedAs("FirstPart"))))).andNot(NodePattern.N.withDependent("det(:poss)?", NodePattern.not(NodePattern.N.form("viel").directlyBefore(NodePattern.N.alreadyMarkedAs("FirstPart"))))).andNot(NodePattern.N.withDependent(".*", NodePattern.N.pos("PRO:IND.*").noLemma("viel"))).andNot(NodePattern.N.label("MISC").noPos())).noDependents().andNot(englishWordsInSequence.label("PRODUCT")).noLabel("ORGANIZATION|LOCATION").andNot(NodePattern.N.form("halb").andNot(NodePattern.N.directlyBefore(NodePattern.N.lemma("Schwester|Bruder|Geschwister")))).andNot(NodePattern.N.inFormSequence(0, "tief", "Luft")).andNot(NodePattern.N.inFormSequence(0, "dick", "Butter")).andNot(NodePattern.N.inFormSequence(0, "voll", "Wut|Groll")).andNot(NodePattern.N.inFormSequence(0, "teilbar", "Kaffeel\u00f6ffel")).andNot(NodePattern.N.inFormSequence(0, "schnell", "Geschichte")).andNot(NodePattern.N.inFormSequence(0, "lang", "Zeit")).andNot(GermanTreePatterns.positivProzess), NodePattern.or(NodePattern.N.pos("ADV:MOD").directlyAfter(NodePattern.N.withHeadRelation("det")).andNot(NodePattern.N.pos(predicativeAdj)).andNot(NodePattern.N.inFormSequence(0, "mehr", "Schuld")), NodePattern.N.noPos().form("mindest|best|kleinst|lieblings")).directlyBeforeHead().withHead("advmod|amod|compound", SpellingRules.noun), NodePattern.or(NodePattern.N.form("Doppel|(zwei|drei)?((drit|vier|f\u00fcnf|sechs|ach|zehn)tel)"), NodePattern.N.formCaseSensitive("Halb")).andOr(NodePattern.N.withDependent("flat", SpellingRules.noun.directlyAfterHead()), NodePattern.N.withHead("amod", SpellingRules.noun).directlyBeforeHead()), NodePattern.N.form("selbst").directlyBeforeHead().withHead("advmod", NodePattern.N.pos("ADJ.*SUP.*").withDependent("det(:poss)?"))).andNot(NodePattern.N.inFormSequence(0, "gro\u00df", ".*zimmer")).and((node, match) -> {
            Node next = node.neighbor(1);
            String replacement = StringTools.uppercaseFirstChar((String)(node.form() + next.lowForm()));
            TreeSupport support = node.tree().treeSupport();
            if (support.isAcceptedBySpellchecker(replacement)) {
                return match.withCorrector(NodeCorrector.replaceNodes(node, next, replacement));
            }
            return null;
        }), NodePattern.or(GermanTreePatterns.freiTag.andOr(NodePattern.N.directlyAfter(NodePattern.or(CommonPatterns.capitalized, NodePattern.N.directlyAfter(NodePattern.N.form("bis")))), NodePattern.N.directlyBefore(NodePattern.N.form("((nach|vor)?mittag|abend|nacht|morgen)")), NodePattern.N.withDependent("appos", GermanDateChecker.monthName), NodePattern.N.pos(".*SIN.*").noDependents("det(:poss)?").andNot(NodePattern.N.directlyAfter(NodePattern.N.directlyAfter(NodePattern.N.pos("PRO:IND.*")))), NodePattern.N.label("MISC"), NodePattern.N.withHead("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.lemma("nehmen").withDependent("mark", NodePattern.N.form("frei")))), GermanTreePatterns.grossRolle.andOr(NodePattern.N.directlyAfter(CommonPatterns.capitalized), NodePattern.N.withHead("nsubj(:pass)?|i?obj|obl|nmod|compound|root", NodePattern.or(CommonPatterns.possiblySkipDown("root", NodePattern.N.withDependent("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.lemma("Volumen|L\u00e4nge|Breite|teuer|billig|g\u00fcnstig"))), CommonPatterns.possiblySkipDown("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.lemma("kaufen|be(sorgen|stellen|nutzen|n\u00f6tigen)|anschaffen|wechseln|ver(wenden|legen)|aufwickeln|reichen|(aus)?schneiden|herstellen")))), NodePattern.N.withDependent("det", NodePattern.N.pos("PRO:DEM.*")).withHead("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.withDependent("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.lemma("Haushalt"))), NodePattern.N.pos(".*SIN.*").noDependents("det"), NodePattern.N.withDependent("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.form("[mc]?m}")), NodePattern.N.withDependent("amod", NodePattern.or(NodePattern.N.lemma("(.*)(lagig|wei\u00df)|transparent|universal|grob"), NodePattern.N.form("naturfarbenen?"))), NodePattern.N.withDependent("appos", NodePattern.N.lemma("(Toiletten)?papier|(.*)?(Krepp|Folie|Vlies|Band|Tapete|Rasen|Marke|Heu)|(Hand)?tuch|Alu(minium?)|(rauh?)faser"))), NodePattern.or(GermanTreePatterns.lemmaAfterForm("Oma|Opa|Vater|Mutter|Tante|Onkel", "((ur){0,2})?gro\u00df|ur"), GermanTreePatterns.lemmaAfterForm("Medizin(er)?|Arzt", "allgemein"), GermanTreePatterns.lemmaAfterForm("Mail", "rund"), GermanTreePatterns.lemmaAfterForm("Schwester|Bruder|Geschwister", "halb"), GermanTreePatterns.lemmaAfterForm("Bewerbung", "initiativ"), GermanTreePatterns.lemmaAfterForm("Lage", "nieder"), GermanTreePatterns.lemmaAfterForm("Bild|Foto", "nackt"), GermanTreePatterns.lemmaAfterForm("Station|Medizin|Kurs|Zimmer|Bett|Patient", "intensiv"), GermanTreePatterns.lemmaAfterForm("Zeit", "echt"), GermanTreePatterns.lemmaAfterForm("Idee", "spitzen"), GermanTreePatterns.lemmaAfterForm("Teig", "m\u00fcrbe"), GermanTreePatterns.lemmaAfterForm("Wunsch|Klasse|Sitzung", "extra|sonder"), GermanTreePatterns.lemmaAfterForm("Parkplatz|Rat|Sport(ler)?|Recht|Verband|(.*)?dienst|beauftragte|beirat", "behinderten")).reportEverythingTouched().andOr(NodePattern.N.withDependent("det(:poss)?|case"), NodePattern.N.withDependent(".*", NodePattern.N.pos("PRO:IND.*")), NodePattern.N.withDependent("amod", NodePattern.N.lemma("viel|wenig").directlyBefore(NodePattern.N.alreadyMarkedAs("Form"))), NodePattern.N.withHeadRelation("appos").withDependent("punct", NodePattern.N.beforeHead())), GermanTreePatterns.lemmaAfterForm("Weile", "lange"), GermanTreePatterns.lemmaAfterForm("Start|Kauf|Jahr|Lese|Aufsteher|Aussiedler|Stadium|Sommer|Herbst|Winter|Fr\u00fchling", "sp\u00e4t|fr\u00fch"), GermanTreePatterns.lemmaAfterForm("Schicht", "sp\u00e4t|fr\u00fch").directlyAfter(NodePattern.N.noDependents()), GermanTreePatterns.lemmaAfterForm("Akquise|Wasser.+|Getr\u00e4nk|Speise|(Lauf)?Phase|Herzigkeit|Winter(.*)?|Start|Ton", "kalt|warm"), GermanTreePatterns.lemmaAfterForm("Beton|Kunststoff|Seife|D\u00fcnger|Extraktion|Kleber|Gas(.*)?|Kapsel|Nahrung|Waschmittel", "fl\u00fcssig|hart"), GermanTreePatterns.lemmaAfterForm("Extraktion|Waschmittel", "fl\u00fcssig"), GermanTreePatterns.lemmaAfterForm("D\u00fcnken", "gut"), GermanTreePatterns.positivProzess.andOr(NodePattern.N.withDependent(".*", NodePattern.N.lemma("analog|mittels")), NodePattern.N.withHead("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.lemma("(nach)?belichten|abdunkeln|unterziehen|verzerren"))), GermanTreePatterns.lemmaAfterForm("Krieg", "gro\u00df").andNot(NodePattern.N.directlyAfter(NodePattern.N.label("EVENT"))), grobVorstellung.andOr(NodePattern.N.withDependent("nmod"), NodePattern.N.withHead("nmod", SpellingRules.noun), NodePattern.N.noDependents(NodePattern.N.withHeadRelation("det(:poss)?"))), GermanTreePatterns.lemmaAfterForm("Kompetenz|Ausweis", "personal"), NodePattern.N.form("Raucher([sn]|in(nen)?)?").directlyAfter(NodePattern.N.form("passiv|aktiv")), NodePattern.N.form("(Denker|Berufler)([sn]|in(nen)?)?").directlyAfter(NodePattern.N.form("frei")), NodePattern.N.inFormSequence(1, "zu", "(viel|wenig)s?").withNeighbor(-1, NodePattern.N.directlyBeforeHead()).andOr(NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound").withNeighbor(-2, einOrDas), NodePattern.N.withHead("conj", NodePattern.N.withDependent("det|nsubj", einOrDas)))).and((node, match) -> {
            Node prev = node.neighbor(-1);
            String replacement = StringTools.uppercaseFirstChar((String)(prev.form() + node.lowForm()));
            return match.withCorrector(NodeCorrector.replaceNodes(prev, node, replacement));
        }));
    }

    private static NodePattern compoundSplittingIntoPhrase() {
        return NodePattern.or(NodePattern.N.form("Teufelsk\u00fcche").noLabel("LOCATION").message("Schreiben Sie die Wendung \u201ein Teufels K\u00fcche\u201c (im Sinne von \u201ein Schwierigkeiten\u201c) getrennt").correct(NodeCorrector.replace("Teufels K\u00fcche")), NodePattern.N.form("((\u00fcber)?morgen|heute|(vor)?gestern)((nach|vor)?mittag|abend|nacht|morgen)").and((node, match) -> {
            int prefix;
            int n = node.lowForm().startsWith("heute") ? 5 : (node.lowForm().startsWith("morgen") ? 6 : (prefix = node.lowForm().startsWith("gestern") ? 7 : 10));
            if (node.form().length() <= prefix) {
                return null;
            }
            String word1 = node.lowForm().substring(0, prefix);
            String word2 = StringTools.uppercaseFirstChar((String)node.form().substring(prefix));
            return match.withCorrector(NodeCorrector.replace(node, word1 + " " + word2)).withMessage("\u201e" + word1 + " " + word2 + "\u201c wird getrennt geschrieben");
        }), GermanTreePatterns.zuEnde.message("Schreiben Sie die Wendung \u201ezu Ende\u201c getrennt").correct(NodeCorrector.replace("zu Ende")), NodePattern.N.form("Nullkommani(chts|x)").directlyAfter(NodePattern.N.form("in")).message("Schreiben Sie die Wendung \u201ein null Komma nichts\u201c getrennt").and((node, match) -> match.withCorrector(NodeCorrector.rawReplace(node.textRange(), "null Komma " + node.form().substring(9)))), NodePattern.N.inFormSequence(0, "pro", "-", "rata").message("Schreiben Sie die Wendung \u201epro rata\u201c getrennt").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(2), "pro rata")), NodePattern.N.inFormSequence(2, "ein", "f\u00fcr", "allemale?").message("Schreiben Sie die Wendung \u201eein f\u00fcr alle Mal(e)\u201c getrennt").correct(NodeCorrector.regexReplace("allemal(.*)", "alle Mal$1")), NodePattern.N.form("nachwievor").message("Schreiben Sie die Wendung \u201enach wie vor\u201c getrennt").correct(NodeCorrector.replace("nach wie vor")), NodePattern.N.form("einpaar").and(SpellingRules.typoReplacement("ein paar")), NodePattern.N.form("unteranderem").and(SpellingRules.typoReplacement("unter anderem")), NodePattern.N.form("(de[rsmn]|die|das)gleichen?").withHeadRelation("det").and(SpellingRules.typoRegexReplacement("(.*)(g.*)", "$1 $2")), NodePattern.N.form("zugrunde\\p{L}{3,9}").noPos("(AD[JV]).*").noHeadRelation("a(dv)?mod").andNot(withDependentsDetCaseAmod).and((node, match) -> {
            String verb = node.lowForm().replace("zugrunde", "");
            if (!node.tree().treeSupport().tagToken(verb).hasPos("VER:(PA2|[123]).*")) {
                return null;
            }
            String verbNoZu = verb.replaceFirst("zu", "");
            String replacement = verb.startsWith("zu") && node.tree().treeSupport().tagToken(verbNoZu).hasPos("VER.*") ? "zu " + verbNoZu : verb;
            return match.withCorrector(NodeCorrector.replace(node, "zugrunde " + replacement)).withMessage("Schreiben Sie \u201ezugrunde\u201c vom folgenden Verb getrennt");
        }));
    }

    private static NodePattern nounsStartingWithRiesen() {
        return NodePattern.N.form("rie?sen").directlyBeforeHead().withHead("amod|compound", CommonPatterns.capitalizedHasPos("SUB.*").andOptionally(NodePattern.N.withDependent("det", NodePattern.N.markAs("Det"))).and((node, match) -> {
            boolean detIsNotNull;
            Node prev = node.neighbor(-1);
            Node det = match.findMarkedNode("Det");
            AgreementSet headSet = AgreementSet.create(node);
            if (headSet == null) {
                return match;
            }
            AgreementSet.Gender gender = StyleRules.pickGender(node);
            boolean bl = detIsNotNull = det != null;
            AgreementSet.Number number = detIsNotNull ? StyleRules.pickNumber(node, headSet) : (!node.hasPos(".*PLU.*") ? "SIN" : "PLU");
            Iterator<Case> iterator = headSet.possibleCases.allowed().iterator();
            if (iterator.hasNext()) {
                Case caze = iterator.next();
                TreeSupport support = node.tree().treeSupport();
                caze = detIsNotNull && det.hasPos("ART:IND:AKK:.*") && !det.hasPos("ART:IND:NOM.*") ? Case.AKK : Case.valueOf(caze.name());
                ArrayList<String> result2 = new ArrayList<String>(support.synthesize("riesengro\u00df", "riesengro\u00df", predicativeAdj, "ADJ:" + caze + ":" + (Serializable)((Object)number) + ":" + gender.name() + ":GRU:.*" + headSet.adjDeclination));
                return result2.isEmpty() ? null : match.withCorrector(NodeCorrector.replace(prev, result2));
            }
            return match;
        }).and((node, match) -> {
            Node prev = node.neighbor(-1);
            String compound = "Riesen" + node.lowForm();
            if (WordSeparation.formCompound(node.tree().treeSupport(), compound)) {
                return match.withCorrector(NodeCorrector.replaceNodes(prev, node, compound));
            }
            return null;
        }));
    }

    private static NodePattern fourWordCompoundNounPattern() {
        return NodePattern.or(WordSeparation.fourWordCompoundNoun("all", "in", "one"), WordSeparation.fourWordCompoundNoun("pay", "per", "page|view|click|lead|download|use|impression|call|action|sale|order"), WordSeparation.fourWordCompoundNoun("save", "the", "date"), WordSeparation.fourWordCompoundNoun("copy", "[au]nd|&", "pastes?"), WordSeparation.fourWordCompoundNoun("drag", "[au]nd|&", "drops?"), NodePattern.N.inFormSequence(0, "copy", "-", "pastes?").withNeighbor(2, NodePattern.custom((node, match) -> match.withCorrector(NodeCorrector.replaceNodes(node.neighbor(-2), node, "Copy and " + node.form())))));
    }

    private static NodePattern fourWordCompoundNoun(String word1, String word2, String word3) {
        NodePattern directlyAfterThirdPart = NodePattern.N.directlyAfter(NodePattern.N.alreadyMarkedAs("ThirdPart"));
        return NodePattern.or(NodePattern.N.form(word1), SpellingRules.noun).markAs("Noun").directlyBefore(CommonPatterns.skipForward(CommonPatterns.HYPHEN_LIKE_NODE, NodePattern.or(NodePattern.N.form(word2), NodePattern.N.withHeadRelation("case")).markAs("SecondPart").directlyBefore(CommonPatterns.skipForward(CommonPatterns.HYPHEN_LIKE_NODE, NodePattern.or(NodePattern.N.form(word3), NodePattern.N.sameWordAs("Noun")).markAs("ThirdPart"))))).andOr(NodePattern.N.withDependent("appos|flat", directlyAfterThirdPart), NodePattern.N.withHead("nmod|compound", SpellingRules.noun.and(directlyAfterThirdPart)), NodePattern.N.withHead("nmod", NodePattern.N.withDependent("nsubj", directlyAfterThirdPart))).and((node, match) -> {
            Node secondPart = match.getMarkedNode("SecondPart");
            Node thirdPart = match.getMarkedNode("ThirdPart");
            Node fourPart = thirdPart.neighbor(1);
            String thirdPartUpperOrLow = thirdPart.hasForm("one") ? thirdPart.lowForm() : StringTools.uppercaseFirstChar((String)thirdPart.form());
            String secondPartModified = secondPart.hasForm("[au]nd|&") ? "and" : secondPart.lowForm();
            return match.withCorrector(NodeCorrector.replaceNodes(node, fourPart, StringTools.uppercaseFirstChar((String)node.form()) + "-" + secondPartModified + "-" + thirdPartUpperOrLow + "-" + fourPart.form()));
        });
    }

    private static NodePattern threeWordCompoundNoun() {
        NodePattern middleElement = CommonPatterns.capitalizedHasPos("SUB.*").markAs("Middle");
        NodePattern lastElement = CommonPatterns.capitalizedHasPos("SUB.*").markAs("End").noPos("VER:3:PLU.*(NON|SFT)|PA2.*").andNot(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_NODE));
        return NodePattern.or(compoundNounWithInFrage.withNeighbor(-2, NodePattern.N.markAs("Start")).correct(NodeCorrector.replaceNodes(NodePointer.marked("Start"), NodePointer.anchor(), m -> List.of("Infrage" + StringTools.lowercaseFirstChar((String)m.anchor().form())))), NodePattern.or(Capitalization.cardinal.directlyBefore(CommonPatterns.skipForward(CommonPatterns.HYPHEN_LIKE_NODE, middleElement.withHeadRelation("compound|nmod").directlyBefore(CommonPatterns.skipForward(CommonPatterns.HYPHEN_NODE, lastElement.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound|xcomp|root").andNot(NodePattern.N.withDependent("compound", NodePattern.not(NodePattern.N.alreadyMarkedAs("Middle")))))).andNot(SemanticRules.units).andNot(SemanticRules.currencyName).andNot(Capitalization.cardinal).noForm("Millionen"))).andOr(NodePattern.N.withHead("nummod", NodePattern.N.alreadyMarkedAs("Middle")), NodePattern.N.afterHead().withHead("conj", Capitalization.cardinal.markAs("SecondCardinal").withHead("nummod", NodePattern.N.alreadyMarkedAs("Middle")))), NodePattern.N.form("ein").markAs("Start").directlyBefore(CommonPatterns.skipForward(CommonPatterns.HYPHEN_LIKE_NODE, middleElement.andNot(Capitalization.cardinal).directlyBefore(CommonPatterns.skipForward(CommonPatterns.HYPHEN_LIKE_NODE, lastElement)))).andOr(AgreementSet.agreementIssues, NodePattern.markedNodeMatches("End", NodePattern.or(NodePattern.N.withDependent("det", NodePattern.N.before("Start")), CommonPatterns.capitalizedHasPos(".*PLU.*").andNot(CommonPatterns.capitalizedHasPos(".*SIN.*")))), NodePattern.N.inFormSequence(0, "ein", "zimmer", "wohnung(en)?"), NodePattern.N.inFormSequence(0, "ein", "Kind", "politik(en)?"), NodePattern.N.inFormSequence(0, "ein", "Stunden", "Takt(e?s|en?)?")), NodePattern.or(NodePattern.or(NodePattern.N.inFormSequence(0, "in", "kraft", "treten"), NodePattern.N.inFormSequence(0, "in", "verkehr", "bringen"), NodePattern.N.inFormSequence(0, "zu", "stande", "kommen")).withNeighbor(2, NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound|conj|root|flat").and(withDependentsDetCaseAmod)), NodePattern.N.inFormSequence(0, "schock", "schwere", "not"), NodePattern.N.inFormSequence(0, "non", "plus", "ultra").withDependent("det(:poss)?"), nullkommanichts.and(withImBeforeHead)).withNeighbor(2, NodePattern.N.markAs("End")).withNeighbor(1, NodePattern.N.markAs("Middle")), Capitalization.bisZumGehtNichtMehr).andNot(NodePattern.N.inFormSequence(0, ".*", "-", "platz", "-", "(mini|maxi)mum")).andNot(NodePattern.N.inFormSequence(0, "drei", "-", "finger", "-", "gru(\u00df|ss)")).andNot(NodePattern.N.inFormSequence(0, ".*", "-", "punkte|G\u00e4nge", "-", "men\u00fc.*")).andNot(NodePattern.N.inFormSequence(0, ".*", "-", "Wort|Satz", "-", "(Ebene|\u00c4u\u00dferung)(e?n)?")).and((start, match) -> {
            Node end = match.getMarkedNode("End");
            Node middle = match.getMarkedNode("Middle");
            Node secondCardinal = match.findMarkedNode("SecondCardinal");
            String concat = StringTools.uppercaseFirstChar((String)start.form()) + middle.lowForm() + end.lowForm();
            if (start.tree().treeSupport().isAcceptedBySpellchecker(concat) && WordSeparation.nonThreeWordCompound(middle, concat) || concat.matches("Einkindpolitik")) {
                if (secondCardinal != null && !secondCardinal.neighbor(1).hasForm("-")) {
                    return match.withCorrector(NodeCorrector.replaceNodes(start, end, concat).join(NodeCorrector.replace(secondCardinal, StringTools.uppercaseFirstChar((String)secondCardinal.form()) + "-")));
                }
                return match.withCorrector(NodeCorrector.replaceNodes(start, end, concat));
            }
            return null;
        }));
    }

    private static boolean nonThreeWordCompound(Node middle, String concat) {
        return !SemanticRules.timeUnit.matches(middle) && !concat.contains("bruder");
    }

    @Nullable
    private static String makeCompoundWithNext(Node node) {
        Object compound;
        Node next = node.neighbor(1);
        TreeSupport support = node.tree().treeSupport();
        Object object = node.hasLemma("Gesundheitsf\u00fcrsorge") && next.hasLemma("System") ? "Gesundheits" + next.lowForm() : (compound = node.hasLemma("Hauptbeschlu\u00dffassung") && next.hasLemma("Organ") ? "Hauptbeschlussfassungs" + next.lowForm() : StringTools.uppercaseFirstChar((String)(node.form() + next.lowForm())));
        if (WordSeparation.formCompound(support, (String)compound)) {
            return compound;
        }
        Object[] linkingElements = new String[]{"e", "n", "s", "en", "er", "es"};
        if (validFirstPartCompound.matches(node)) {
            for (String element : StreamEx.of((Object)"").append(linkingElements)) {
                if (!node.form().endsWith(element)) continue;
                String modifiedNodeForm = node.form().substring(0, node.form().length() - element.length());
                for (String newElement : StreamEx.of((Object)"").append(linkingElements)) {
                    if (newElement.equals(element) || !WordSeparation.formCompound(support, (String)(compound = StringTools.uppercaseFirstChar((String)(modifiedNodeForm + newElement + next.lowForm())))) || AgreementSet.prohibitedCompounds.contains((String)compound)) continue;
                    return compound;
                }
            }
        }
        return null;
    }

    private static boolean formCompound(TreeSupport support, String compound) {
        return support.tagToken(compound).hasPos("SUB.*") && support.isAcceptedBySpellchecker(compound) || compoundsNotKnownForSpellchecker.contains(compound);
    }

    private static NodePattern joinWithNextNodeBothLowForm() {
        return NodePattern.N.correct(NodeCorrector.concatenate(1));
    }

    private static NodePattern joinWithNextNodeLowerCaseNoun() {
        return NodePattern.custom((node, match) -> match.withCorrector(NodeCorrector.rawReplace(node.textRange(), node.lowForm() + node.neighbor(1).lowForm()).join(NodeCorrector.removeNode(node.neighbor(1)))));
    }

    static NodePattern joinWithNextNode() {
        return NodePattern.N.correct(NodeCorrector.concatenate(1).preservingCase());
    }

    private static NodePattern joinThreeNodes() {
        return NodePattern.N.correct(NodeCorrector.concatenate(2).preservingCase());
    }

    private static NodePattern superGAU() {
        return NodePattern.N.form("super").and(CommonPatterns.beforeSkipping(CommonPatterns.HYPHEN_NODE, NodePattern.N.form("gaus?").markAs("Gau"))).andNot(NodePattern.N.formCaseSensitive("Super").directlyBefore(CommonPatterns.noSpaceHyphen).withNeighbor(2, NodePattern.N.formCaseSensitive("G(au|AU)s?"))).and(NodePattern.custom((sup, match) -> {
            Node gau = match.getMarkedNode("Gau");
            String hyphenated = "Super-" + StringTools.uppercaseFirstChar((String)gau.form());
            return match.withCorrector(NodeCorrector.replaceNodes(sup, gau, hyphenated, "Super" + gau.lowForm()));
        })).message("Meinten Sie eine Katastrophe?");
    }

    private static NodePattern adverbSeparation() {
        String zuAllerAdverbs = "(erst|letzt|oberst|unterst|meist)";
        return NodePattern.or(NodePattern.or(NodePattern.or(NodePattern.N.inFormSequence(0, "drauf", "los").andNot(NodePattern.N.withHead(drauflosVerb)), NodePattern.N.form("wohl").noDependents(".*").directlyBefore(NodePattern.N.form("gemerkt").noDependents("aux")), NodePattern.N.inFormSequence(0, "mit", "einander"), NodePattern.N.form("h\u00f6chst").directlyBeforeHead().withHead(NodePattern.N.pos("(ADV|ADJ:PRD).*").directlyBefore(NodePattern.N.withHeadRelation("advmod|xcomp")))).and(WordSeparation.joinWithNextNode()), NodePattern.or(NodePattern.N.inFormSequence(0, "mit", "ein", "ander").withNeighbor(2, NodePattern.N.noHeadRelation("amod")), NodePattern.N.inFormSequence(0, "in", "wie", "weit|fern"), NodePattern.N.inFormSequence(0, "so", "zu", "sagen").withNeighbor(2, NodePattern.or(NodePattern.N.withHeadRelation("parataxis"), NodePattern.N.withHeadRelation("acl|xcomp").andNot(CommonPatterns.lastChildPhrase)))).and(WordSeparation.joinThreeNodes()), NodePattern.N.directlyBefore(NodePattern.N.form("seits")).and((node, match) -> {
            String newWord = node.form() + node.neighbor(1).form();
            if (node.hasPos("ADJ.*") && node.hasForm(".+er") || node.tree().treeSupport().tagToken(newWord).hasPos("ADV.*|PRP.*LOK:GEN")) {
                return match.withCorrector(NodeCorrector.replaceNodes(node, node.neighbor(1), newWord));
            }
            return null;
        }), NodePattern.N.withHeadRelation("case").directlyBefore(NodePattern.N.form("einander")).andOr(NodePattern.N.form("fuer").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "f\u00fcreinander")), WordSeparation.joinWithNextNode()), NodePattern.N.inFormSequence(1, "bis|von|ab", "fr\u00fch|sp\u00e4t", "((nach|vor)?mittag|abend|nacht|morgen)").withNeighbor(1, NodePattern.N.markAs("PartsOfDay")).and((node, match) -> match.withCorrector(NodeCorrector.replaceNodes(node, node.neighbor(1), node.lowForm() + node.neighbor(1).lowForm() + "s"))), NodePattern.or(NodePattern.or(NodePattern.N.form("fr\u00fch|sp\u00e4t"), SemanticRules.dayOfWeek).directlyBefore(NodePattern.N.form("((nach|vor)?mittag|abend|nacht|morgen)s")), NodePattern.N.form("weit").withDependent("case", NodePattern.N.form("aus").directlyAfterHead()), WordSeparation.twoWordAdverbs("jede[rn]", "Zeit|Falls").withNeighbor(1, NodePattern.N.noDependents("case", NodePattern.N.beforeHead())), WordSeparation.twoWordAdverbs("nach|vor", "mittags"), WordSeparation.twoWordAdverbs("vor|zu", "erst").andNot(NodePattern.N.withNeighbor(1, NodePattern.N.withHead("advmod", NodePattern.N.withHeadRelation("nummod")))), WordSeparation.twoWordAdverbs("viel", "leicht").andNot(NodePattern.N.withNeighbor(1, NodePattern.N.withHead("advmod", NodePattern.N.withHeadRelation("amod")))), WordSeparation.twoWordAdverbs("au\u00dfer", "ordentlich").withNeighbor(1, NodePattern.N.withHeadRelation("advmod")).andNot(NodePattern.N.withHead("case", NodePattern.N.withHeadRelation("obl").pos("VER:INF:SFT"))), WordSeparation.twoWordAdverbs("dies", "mal").noHeadRelation("nsubj(:pass)?"), WordSeparation.twoWordAdverbs("eben|gleich", "falls"), WordSeparation.twoWordAdverbs("ge?rade", "heraus").andOr(NodePattern.N.withNeighbor(1, NodePattern.N.withHead("advmod", NodePattern.N.withDependent("compound:prt"))), NodePattern.N.withHead("advmod", NodePattern.N.lemma("sagen|(aus)?sprechen|reden|antworten|erkl\u00e4ren|zugeben|be(schreiben|kennen|richten)|erwidern")), NodePattern.N.withDependent("advmod", NodePattern.N.directlyAfterHead())), WordSeparation.twoWordAdverbs("nebeneinander", "her"), WordSeparation.twoWordAdverbs(".+er", "ma(ss|\u00df)en").pos("(PA2|ADJ).*"), WordSeparation.twoWordAdverbs("bei", "leibe").withNeighbor(1, CommonPatterns.beforeSkipping(NodePattern.N.withHeadRelation("advmod"), NodePattern.N.form("nicht|keine?"))), WordSeparation.twoWordAdverbs("trotz", "dem").andNot(NodePattern.N.withNeighbor(1, NodePattern.N.withHead("det", NodePattern.not(NodePattern.N.onlyPos("SUB:GEN:SIN:.+"))))).correct(NodeCorrector.replace(NodePointer.neighbor(1), "des")), WordSeparation.twoWordAdverbs("des", "wegen"), WordSeparation.twoWordAdverbs("selbst", "redend"), WordSeparation.twoWordAdverbs("so", "eben").andNot(NodePattern.N.withNeighbor(1, NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("advmod")))), WordSeparation.twoWordAdverbs("hin", "weg").directlyAfterHead().andOr(NodePattern.N.withHead("advmod|case|fixed", NodePattern.N.withDependent("case", NodePattern.N.form("\u00fcber|von"))), NodePattern.N.withHead("advmod", NodePattern.N.form("da(r\u00fcber|von)"))), WordSeparation.twoWordAdverbs("bei", "Zeiten").directlyBefore(NodePattern.N.withOnlyDependents(NodePattern.N.directlyBeforeHead())), WordSeparation.twoWordAdverbs("einst", "weilen").andNot(NodePattern.N.directlyBefore(NodePattern.ROOT)), WordSeparation.twoWordAdverbs("bei", "Leibe").withNeighbor(2, NodePattern.N.form("nicht")).andNot(NodePattern.N.withNeighbor(1, NodePattern.N.withHead(NodePattern.or(NodePattern.N.withDependent("nsubj", NodePattern.or(SemanticRules.animate, NodePattern.N.pos("PRO:PER.*"))).withDependent("cop"), NodePattern.N.lemma("f\u00fchlen").withDependent("obj", NodePattern.N.pos("PRO:REF.*")))))), WordSeparation.twoWordAdverbs("bis", "her|lang").andOr(NodePattern.N.directlyBeforeHead().withHead("case", NodePattern.N.withHeadRelation("advmod|obl")), NodePattern.N.withDependent("fixed", NodePattern.N.directlyAfterHead())).andNot(NodePattern.N.withNeighbor(2, NodePattern.N.form("nach"))), WordSeparation.twoWordAdverbs("nahe", "zu").withNeighbor(1, NodePattern.or(NodePattern.N.withHeadRelation("advmod"), NodePattern.N.withHead("case", NodePattern.N.withHeadRelation("nummod")))), NodePattern.or(NodePattern.N.form("ausnahms"), NodePattern.N.form(".+er").pos("(ADJ|PA2).*")).withHead("advmod|amod", NodePattern.N.form("weise").noDependents("case", NodePattern.N.beforeHead())), WordSeparation.twoWordAdverbs("dutzend", "mal").noDependents("det"), WordSeparation.twoWordAdverbs("wo", "anders").andNot(NodePattern.N.withNeighbor(2, NodePattern.N.form("als"))), WordSeparation.twoWordAdverbs("rund", "um").withNeighbor(1, NodePattern.not(NodePattern.N.withHead("case", NodePattern.N.withHeadRelation("conj")))), WordSeparation.twoWordAdverbs("schei\u00df", "egal").noDependents(), WordSeparation.twoWordAdverbs("von", "N\u00f6ten").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "notwendig")), WordSeparation.twoWordAdverbs("nirgends?", "wo|her|hin"), WordSeparation.twoWordAdverbs("nirgend", "wo?(her|hin)"), WordSeparation.twoWordAdverbs("zeit", "lebens").withOnlyDependents(NodePattern.N.form("lebens")), NodePattern.N.directlyBeforeHead().withHead("compound", NodePattern.N.form("a(u[fs]|b)w\u00e4rts")).and(CommonPatterns.capitalizedHasPos("SUB.*")).andNot(withDependentsDetCaseAmod), berg.directlyBefore(anAbAuf).andOr(NodePattern.not(withDependentsDetCaseAmod), NodePattern.N.withOnlyDependents(NodePattern.N.form("steil").directlyBeforeHead()))).and(WordSeparation.joinWithNextNodeBothLowForm()), NodePattern.or(NodePattern.N.inFormSequence(0, "zu", "aller").markAs("Start").withNeighbor(2, NodePattern.or(NodePattern.N.form(zuAllerAdverbs).correct(NodeCorrector.replaceNodes(NodePointer.marked("Start"), NodePointer.anchor(), m -> List.of("zualler" + m.anchor().form()))), NodePattern.N.inFormSequence(0, "aller", zuAllerAdverbs).withNeighbor(1, NodePattern.N.correct(NodeCorrector.replaceNodes(NodePointer.marked("Start"), NodePointer.anchor(), m -> List.of("zualleraller" + m.anchor().form())))))), NodePattern.N.inFormSequence(0, "zu", "n\u00e4chst|gleich|(aller){0,2}" + zuAllerAdverbs).andNot(NodePattern.N.withNeighbor(1, NodePattern.N.withHead("advmod", NodePattern.N.withHeadRelation("det")))).and(WordSeparation.joinWithNextNodeBothLowForm()))).message(ADV_SPELLED_TOGETHER_MSG), NodePattern.N.inFormSequence(0, "aller", "Hand").withNeighbor(1, NodePattern.N.noDependents("det:poss|case")).message("Das Wort \u201eallerhand\u201c wird zusammengeschrieben").and(WordSeparation.joinWithNextNode()), NodePattern.N.form("x").directlyBefore(NodePattern.N.form("mal")).message(MISSING_HYPHEN_MSG).and((node, match) -> match.withCorrector(WordSeparation.hyphenateNeighborsLastLowForm(node))), NodePattern.N.form("hinaus.+").andOr(NodePattern.N.pos("VER.*"), NodePattern.N.noPos(".*")).noLemma("hinaus(gehen|kommen|reichen|sollen)").andOr(NodePattern.N.directlyAfter(NodePattern.N.form("dar\u00fcber")).correct(NodeCorrector.regexReplace("hinaus(.*)", "hinaus $1")), NodePattern.N.withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("\u00fcber")).directlyBeforeHead()).and((node, match) -> {
            if (node.tree().treeSupport().isAcceptedBySpellchecker(node.form())) {
                return null;
            }
            return match.withCorrector(NodeCorrector.replace(node, "hinaus " + node.form().substring(6)));
        })).message("\u201eHinaus\u201c ist ein Adverb (kein Pr\u00e4fix) und wird getrennt geschrieben"));
    }

    private static NodePattern twoWordAdverbs(String word1, String word2) {
        return NodePattern.N.form(word1).directlyBefore(NodePattern.N.form(word2).andNot(NodePattern.N.withHead("case", NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound").noForm("nirgends?|des"))));
    }

    private static NodePattern adjectiveSeparation() {
        String prozentigLike = "(fach|armig|b\u00e4ndig|geschossig|eckig|j\u00e4hrig|k\u00f6pfig|lagig|malig|min\u00fctig|monatig|prozentig|r\u00e4umig|schichtig|seitig|sek\u00fcndig|spurig|stellig|st\u00f6ckig|st\u00fcndig|teilig|zeilig|t\u00e4gig|t\u00fcrig|w\u00f6chig|z\u00e4hnig)(e[rsnm]?)?";
        NodePattern nummod = NodePattern.N.withHeadRelation("nummod");
        String einOrMehr = "ein|mehr";
        NodePattern adjStartingWithHoch = NodePattern.N.lemma("qualitativ|wirksam|wertig|wachsend|wohlgeboren|explosiv|elegant|effizient|effektiv|empfindlich|energetisch|erfreulich|erhoben|rangig|r\u00e4de?rig|technologisch|t\u00f6nend|trabend|tourig|tonig|unges\u00e4ttigt|integriert|interessant|intelligent|ohmig|offiziell|politisch|preisig|produktiv|profitabel|prozentig|achtbar|ade?lig|aktiv|aktuell|altrig|dramatisch|deutsch|differenziert|deckend|dekoriert|frequent|fest|fein|florig|gemut|gelehrt|geistig|gef\u00e4hrlich|gebildet|modern|modisch|m\u00f6gend|molekular|m\u00fctig|n\u00e4sig|nobel|kultiviert|notpeinlich|versichert|vornehm|aufl\u00f6send|riskant|professionell|verf\u00fcgbar|verdient|sensibel|komplex|befriedigt|l\u00e4ufig|beinig|bejahrt|beladen|bepackt|ber\u00fchmt|betagt|verzinslich|verr\u00e4terisch|verehrt(est)?|verdichtet|chinesisch|zufrieden|zivilisiert|zeitlich|(wohl?)l\u00f6blich|leistungsf\u00e4hig|lehnig|l\u00e4ndisch|klassig|klappbar|kar\u00e4tig|kantig|herzig|herrschaftlich|heilig|hackig|gl\u00e4nzend|sprachlich|gradig|w\u00fcchsig|mechanisiert|willkommen|achtungsvoll|busig|br\u00fcstig|geboren|geschlossen|bef\u00e4higt|gestimmt|gez\u00fcchtet|schulte?rig|w\u00fcrdig(st)?|acht(end|ungsvoll)|feudal|gesch\u00fcrzt|gesinnt|glanzpoliert|");
        NodePattern superlative = NodePattern.N.pos("ADJ:.+:SUP.*");
        String fromZweitToZwoelftNoErstSiebtAcht = "zweit|dritt|viert|f\u00fcnft|sechst|neunt|zehnt|elft|zw\u00f6lft";
        String mehrOrViel = "mehr|viel";
        String kurzOrLang = "kurz|lang";
        String condition = "blass|bleich|kupfer|derb";
        String dickOrDuenn = "dick|d\u00fcnn";
        NodePattern formEndsWithEsNoPos = NodePattern.N.form(".+s").noPos();
        NodePattern abbrOrLabel = NodePattern.or(NodePattern.N.formCaseSensitive("[A-Z]{2,}"), NodePattern.N.label("ORGANIZATION|PRODUCT").andOr(NodePattern.N.pos("EIG.*"), NodePattern.N.noPos()));
        return NodePattern.or(NodePattern.or(NodePattern.or(NodePattern.or(NodePattern.N.label("LANGUAGE"), SpellingRules.zal, NodePattern.N.form(einOrMehr + "|viel|fremd")).directlyBefore(NodePattern.or(NodePattern.N.lemma("st\u00e4mmig"), NodePattern.N.form("sprachig(e[rnsm]?)?"))), NodePattern.N.inFormSequence(0, "obdach|zweifel", "los.*"), NodePattern.N.inFormSequence(0, "erst", "klassig.*"), NodePattern.N.inFormSequence(0, "schwer", "(f(\u00e4|ae)llig|fl(\u00fc|ue)(cht|ss)ig|g(\u00e4|ae)ngig|h(\u00f6|oe)rig|gewichtig|reich).*"), NodePattern.or(SpellingRules.zal, NodePattern.N.form(einOrMehr)).and(nummod).directlyBefore(NodePattern.N.form(prozentigLike)), NodePattern.N.form("hoch").directlyBeforeHead().withHead("advmod", adjStartingWithHoch.andOr(NodePattern.N.pos("(ADJ|PA1).*"), NodePattern.N.pos("PA2.*(GRU|SUP):.*:VER").andNot(NodePattern.N.withNeighbor(-1, directlyAfterIntensifier)))), NodePattern.N.form("aller|" + fromZweitToZwoelftNoErstSiebtAcht + "|siebt").directlyBefore(superlative).directlyAfter(CommonPatterns.skipBack(NodePattern.N.withHeadRelation("advmod"), NodePattern.N.withHeadRelation("det(:poss)?|case"))), NodePattern.N.form(fromZweitToZwoelftNoErstSiebtAcht).directlyBefore(superlative), NodePattern.N.withHeadRelation("advmod|compound").directlyBefore(NodePattern.N.lemma("technisch|m\u00e4\u00dfig|reich")).andOr(CommonPatterns.capitalizedHasPos("SUB.*"), NodePattern.N.form(".+s").andNot(CommonPatterns.capitalizedHasPos(".*"))).noPos("PRO.*"), NodePattern.N.directlyBeforeHead().noPos("ADJ.*").withHead("compound|obj|advmod", NodePattern.N.lemma("ge(richtet|recht)|orientiert|f\u00fchrend|(in)?tolerant").andNot(ReflexivePronouns.reflexiveVerb)).and(CommonPatterns.capitalizedHasPos("SUB.*")).andNot(withDependentsDetCaseAmod).noDependents("advmod"), NodePattern.N.inFormSequence(0, "hilf", "reich(e[rsnm]?)?"), NodePattern.N.form("\u00fcber").withHeadRelation("advmod").directlyBefore(NodePattern.N.form("(fl\u00fcssig|wiegend|gl\u00fccklich|zeugend|raschend|f\u00e4llig|empfindlich|durchschnittlich|m\u00e4\u00dfig|sichlich|schaubar|treffbar|w\u00e4ltigend|gewichtig|tragbar|fallsartig|greifend|erregbar|lappend|quellend)(e[rnsm]?)?")), NodePattern.N.form("au\u00dfer").directlyBefore(NodePattern.N.lemma("ordentlich").withHead("amod", NodePattern.not(NodePattern.N.withHead("obl", NodePattern.N.withDependent("obj"))))), NodePattern.N.form("(nord|s\u00fcd)?(west|ost)|nord|s\u00fcd").directlyBefore(NodePattern.N.lemma("(.*deutsch|(alt)?irisch|.*(alban|amhar|arab|aserbaidschan|bask|belarus|bengal|bulgar|chines|d(\u00e4|ae)n|engl|estn|finn|franz(\u00f6|oe)s|f(\u00e4|ae)r(\u00f6|oe)|galic|georg|griech|g(\u00e4|ae)l|haitian|hebr(\u00e4|ae)|holl(\u00e4|ae)nd|indones|isl(\u00e4|ae)nd|italien|japan|javan|jidd|katalan|kirgis|korean|kreol|kurd|lett|litau|luxembourg|malai|maltes|mazedon|mongol|niederl(\u00e4|ae)nd|norweg|paschtun|pers|poln|portugies|rum\u00e4n|russ|serb|singhales|slowak|slowen|span|tadschik|tamil|thail(\u00e4|ae)nd|tschech|turkmen|t(\u00fc|ue)rk|uigur|ukrain|ungar|vietnames|walis)isch)|asiatisch|europ\u00e4isch|afrikanisch|(latein)?amerikanisch|australisch|friesisch|germanisch")), NodePattern.or(NodePattern.N.form("((dunkel|hell)?(beige|blau|(kupfer)?(braun|rot)|gelb|grau|gr(\u00fc|ue)n|lila|orange|rosa)?|(kohl|tief)?schwarz|wei(\u00df|ss)|golden|silbern)"), NodePattern.N.form("tulpen|apfel|pfirsich|breit|schmal|rund|frisch|hohl|dick|rosen|fett|voll|" + condition)).directlyBefore(NodePattern.N.form("wangig(e[rnsm]?)?")), NodePattern.or(NodePattern.N.form("((dunkel|hell)?(beige|blau|(kupfer)?(braun|rot)|gelb|grau|gr(\u00fc|ue)n|lila|orange|rosa)?|(kohl|tief)?schwarz|wei(\u00df|ss)|golden|silbern)"), NodePattern.N.form(condition + "|" + dickOrDuenn + "|glatt|weich|trocken")).directlyBefore(NodePattern.N.form("h\u00e4utig(e[rnsm]?)?")), NodePattern.or(NodePattern.N.form(mehrOrViel), SpellingRules.zal, NodePattern.N.form("((dunkel|hell)?(beige|blau|(kupfer)?(braun|rot)|gelb|grau|gr(\u00fc|ue)n|lila|orange|rosa)?|(kohl|tief)?schwarz|wei(\u00df|ss)|golden|silbern)")).directlyBefore(NodePattern.N.form("\u00e4ugig(e[rnsm]?)?")), NodePattern.or(NodePattern.N.form(kurzOrLang + "|" + dickOrDuenn + "|glatt|silber|blond|rau|stichel"), NodePattern.N.form("((dunkel|hell)?(beige|blau|(kupfer)?(braun|rot)|gelb|grau|gr(\u00fc|ue)n|lila|orange|rosa)?|(kohl|tief)?schwarz|wei(\u00df|ss)|golden|silbern)")).directlyBefore(NodePattern.N.form("haarig(e[rnsm]?)?")), NodePattern.or(NodePattern.N.form(kurzOrLang + "|" + mehrOrViel + "|dick|quer|st(ur|arr)|janus|gro(ss|\u00df)|flach|glatz|kahl|wirr|brause"), SpellingRules.zal, NodePattern.N.form("((dunkel|hell)?(beige|blau|(kupfer)?(braun|rot)|gelb|grau|gr(\u00fc|ue)n|lila|orange|rosa)?|(kohl|tief)?schwarz|wei(\u00df|ss)|golden|silbern)")).directlyBefore(NodePattern.N.form("k\u00f6pfig(e[rnsm]?)?")), NodePattern.N.form("best").directlyBeforeHead().withHead("advmod", NodePattern.N.withHeadRelation("amod")), NodePattern.N.form("dem").directlyBeforeHead().withHead(NodePattern.N.form("entsprechend|gem\u00e4(\u00df|ss)(e[rnsm]?)?")), NodePattern.N.form("meist").directlyBefore(NodePattern.N.form("(ge(lesen|h\u00f6rt|kauft|sucht|fragt|nannt|braucht|\u00fcbt|stellt|googelt|klickt|streamt|likt)|belastet|konsumiert|empfohlen|gebr\u00e4uchlich|ver(kauft|breitet)|be(sucht|g\u00fcnstigt|teiligt)|(ge|be)nutzt|eingesetzt|diskutiert)(e[rnsm]?)?").withHeadRelation("amod")), NodePattern.N.form("e?in").directlyBefore(NodePattern.N.lemma("begriffen").noDependents("nmod", NodePattern.N.withDependent("case", NodePattern.N.form("wie|von"))).andNot(NodePattern.N.withHead("conj", NodePattern.N.withDependent("case", NodePattern.N.form("in"))))), NodePattern.N.inFormSequence(0, "gr\u00f6\u00dfen", "wahnsinnig(e[rnsm]?)?").directlyBeforeHead(), NodePattern.or(NodePattern.N.inFormSequence(0, "(Sekund|Minut|Stund|Woch)en|(Tag|Monat)e|Jahr(zehnt|hundert|tausend)e", "lang(e[rnsm]?)?"), NodePattern.N.inFormSequence(0, "Jahr(zehnt|hundert|tausend)e", "alt(e[rnsm]?)?")).withNeighbor(1, NodePattern.N.markAs("Amod")).andOr(NodePattern.N.noDependents(), NodePattern.N.withOnlyDependents(NodePattern.N.alreadyMarkedAs("Amod"))), SpellingRules.noun.noForm("(Jahr|Monat|Tag|Woch)en?").directlyBefore(NodePattern.N.form("haft(e[rnsm]?)?").noLabel("PERSON")).andNot(NodePattern.N.withNeighbor(1, NodePattern.N.pos("VER.*"))).noLabel("GEO_POLITICAL_ENTITY|PERSON"), fest.directlyBefore(NodePattern.or(NodePattern.N.lemma("ge(setzt|legt|halten|bunden|stellt|nagelt|dr\u00fcckt)"), NodePattern.N.lemma("genommen").withHead(SemanticRules.animate).andOptionally(NodePattern.N.withDependent("obl|nmod", NodePattern.or(securityForces, withDependentAnAm)))).withHeadRelation("amod")).andNot(directlyAfterIntensifier), NodePattern.N.form("selbst").directlyBeforeHead().withHead("advmod", NodePattern.or(NodePattern.N.pos("PA1.*"), NodePattern.N.form("verfasst|vergessen|verantwortet|bezogen|mordgef\u00e4hrdet(e[rnsm]?)?")).withHeadRelation("a(dv)?mod")).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("redend.*"))), NodePattern.N.inFormSequence(0, "Fieber|Blutdruck|Cholesterin", "senkend(e[rnsm]?)?"), NodePattern.N.inFormSequence(0, "Fieber", "(gl\u00e4nz|gl\u00fch)end(e[rnsm]?)?"), NodePattern.N.withHead("compound", NodePattern.N.lemma("frei")).directlyBeforeHead().noDependents()).and(WordSeparation.joinWithNextNodeBothLowForm()), NodePattern.N.form(gross).directlyBefore(NodePattern.N.form("m[u\u00fc]tig(e[rnsm]?)?").correct(NodeCorrector.regexReplace("m[u\u00fc]tig(.*)", "gro\u00dfm\u00fctig$1").join(NodeCorrector.replace(NodePointer.neighbor(-1), "")))), NodePattern.N.inFormSequence(0, "wie", "[vf]ielt.*").withNeighbor(1, NodePattern.N.noDependents("nsubj")).correct(NodeCorrector.regexReplace(NodePointer.neighbor(1), "[vf]ielt(.*)", "wievielt$1").join(NodeCorrector.replace(NodePointer.anchor(), ""))), NodePattern.N.form("die?s").directlyBefore(NodePattern.N.form("bez\u00fcglich(e[rnsm]?)?").andNot(NodePattern.N.beforeHead().withHeadRelation("case")).correct(NodeCorrector.regexReplace("(bez\u00fcglich.*)", "dies$1").join(NodeCorrector.replace(NodePointer.neighbor(-1), "")))), NodePattern.N.inFormSequence(0, "super", "-").markAs("Super").withHead("compound", NodePattern.N.pos("ADJ.*").withNeighbor(-2, NodePattern.N.alreadyMarkedAs("Super"))).reportEverythingTouched().withNeighbor(1, NodePattern.N.correct(NodeCorrector.replace(""))), NodePattern.N.inFormSequence(1, "tipp?", "topp?(e[rnsm]?)?").correct(NodeCorrector.regexReplace("topp?(.*)", "tipptopp$1").join(NodeCorrector.replace(NodePointer.neighbor(-1), ""))), WordSeparation.compoundAdjEndsWithBasiertBezogen(abbrOrLabel, formEndsWithEsNoPos), NodePattern.or(NodePattern.N.form("mit").withHead("advmod|compound:prt", NodePattern.N.pos("(PA1|ADJ).*")), NodePattern.N.form("selbst|eigen").withHead("advmod", NodePattern.N.withHeadRelation("a(dv)?mod|root").pos("ADJ.*").noDependents("det(:poss)?")), NodePattern.or(NodePattern.N.pos("SUB.*"), CommonPatterns.capitalizedHasPos("SUB.*").noPos(".*")).withHead("obj|advmod", NodePattern.N.pos("(PA1|ADJ).*")).and(directlyAfterIntensifier), CommonPatterns.capitalizedHasPos("SUB.*").noPos(".*").noForm(".+haft.*").withHead("obj|compound|advmod", NodePattern.N.pos("(PA1|ADJ).*").andOr(NodePattern.N.withHeadRelation("amod|xcomp"), NodePattern.ROOT.withDependent("cop"))), NodePattern.N.withHead("compound", NodePattern.N.form("los(e[rnsm]?)?").withHeadRelation("amod"))).directlyBeforeHead().and((node, match) -> {
            String concat = node.lowForm() + node.neighbor(1).form();
            if (node.tree().treeSupport().tagToken(concat).hasPos("(ADJ|PA1).*")) {
                return match.withCorrector(NodeCorrector.replaceNodes(node, node.neighbor(1), concat));
            }
            return null;
        })).message(ADJ_SPELLED_TOGETHER_MSG), NodePattern.or(NodePattern.N.form("\\d+" + prozentigLike).and((node, match) -> {
            String firstPart = node.form().replaceAll("(\\d+)(\\D+)", "$1");
            String lastPart = node.form().substring(firstPart.length()).toLowerCase(Locale.ROOT);
            return match.withCorrector(NodeCorrector.replace(node, firstPart + "-" + lastPart));
        }), NodePattern.N.form("\\d{1,3}").andOr(NodePattern.N.directlyBefore(NodePattern.N.form(prozentigLike)).and((node, match) -> match.withCorrector(WordSeparation.hyphenateNeighborsLastLowForm(node))), NodePattern.N.inFormSequence(0, "\\d+", "oder|und|bis|,", "\\d+", prozentigLike).and((node, match) -> match.withCorrector(WordSeparation.hyphenateNeighborsLastLowForm(node.neighbor(2)).join(NodeCorrector.insertAfter(node, "-"))))), NodePattern.or(NodePattern.N.inFormSequence(0, "\\d+", "tlg"), abbrOrNoPos.label("ORGANIZATION").directlyBefore(NodePattern.N.lemma("gepr\u00fcft|zertifiziert")).noHeadRelation("nsubj").andNot(withDependentsDetCaseAmod)).andOr(NodePattern.N.form("t\u00fcv").and((node, match) -> match.withCorrector(NodeCorrector.replaceNodes(node, node.neighbor(1), "T\u00dcV-" + node.neighbor(1).form()))), NodePattern.custom((node, match) -> match.withCorrector(CommonPatterns.hyphenateNeighbors(node, node.neighbor(1))))), SemanticRules.languageName.withHead("compound|advmod", NodePattern.N.form("(.*deutsch|(alt)?irisch|.*(alban|amhar|arab|aserbaidschan|bask|belarus|bengal|bulgar|chines|d(\u00e4|ae)n|engl|estn|finn|franz(\u00f6|oe)s|f(\u00e4|ae)r(\u00f6|oe)|galic|georg|griech|g(\u00e4|ae)l|haitian|hebr(\u00e4|ae)|holl(\u00e4|ae)nd|indones|isl(\u00e4|ae)nd|italien|japan|javan|jidd|katalan|kirgis|korean|kreol|kurd|lett|litau|luxembourg|malai|maltes|mazedon|mongol|niederl(\u00e4|ae)nd|norweg|paschtun|pers|poln|portugies|rum\u00e4n|russ|serb|singhales|slowak|slowen|span|tadschik|tamil|thail(\u00e4|ae)nd|tschech|turkmen|t(\u00fc|ue)rk|uigur|ukrain|ungar|vietnames|walis)isch)(e[rnsm]?)?").withHeadRelation("amod")).directlyBeforeHead().noDependents().and((node, match) -> match.withCorrector(CommonPatterns.hyphenateNeighbors(node, node.neighbor(1))))).message(MISSING_HYPHEN_MSG), NodePattern.N.form("freiverk\u00e4uflich(e[rnsm]?)?").message("Schreiben Sie \u201efrei verk\u00e4uflich\u201c getrennt").correct(NodeCorrector.regexReplace("frei(.*)", "frei $1"))).andNot(NodePattern.N.directlyBefore(NodePattern.N.lemma("eckig").withHead("amod", NodePattern.N.pos(".*PLU.*"))));
    }

    private static NodePattern compoundAdjEndsWithBasiertBezogen(NodePattern abbrOrLabel, NodePattern formEndsWithEsNoPos) {
        return NodePattern.N.directlyBefore(CommonPatterns.skipForward(CommonPatterns.HYPHEN_NODE, NodePattern.N.lemma("basiert|bedingt|orientiert|bezogen").markAs("Adj"))).withHeadRelation("compound|ob[jl]|amod").andNot(withDependentsDetCaseAmod).andOr(abbrOrLabel.directlyBeforeHead().andNot(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_NODE)).and((node, match) -> match.withCorrector(CommonPatterns.hyphenateNeighbors(node, node.neighbor(1)))), formEndsWithEsNoPos.directlyBeforeHead().and(WordSeparation.joinWithNextNodeLowerCaseNoun()), CommonPatterns.capitalizedHasPos("SUB.*").andNot(abbrOrLabel).and((node, match) -> {
            Node adj = match.getMarkedNode("Adj");
            String concat = node.lowForm() + adj.lowForm();
            TreeSupport support = node.tree().treeSupport();
            if (support.tagToken(concat).hasPos("(PA2|ADJ).*") && support.isAcceptedBySpellchecker(concat) && !concat.matches("(performanceorientiert|blockchainbasiert).*")) {
                return match.withCorrector(NodeCorrector.replaceNodes(node, adj, concat));
            }
            return null;
        }));
    }

    @NotNull
    private static NodeCorrector hyphenateNeighborsLastLowForm(Node node) {
        return NodeCorrector.replaceNodes(node, node.neighbor(1), node.form() + "-" + node.neighbor(1).lowForm());
    }

    private static NodePattern soSeparation(String word) {
        return NodePattern.or(CommonPatterns.firstChildPhrase.inFormSequence(1, "so", word).andNot(NodePattern.N.directlyBeforeHead()).andNot(NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("cop|aux(:pass)?"))).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "so" + word)).message("Die Konjunktion \u201eso" + word + "\u201c wird zusammengeschrieben"), NodePattern.N.form("so" + word).andNot(NodePattern.or(CommonPatterns.firstChildPhrase, NodePattern.N.directlyAfter(CommonPatterns.comma)).withHead("advmod|mark", NodePattern.N.withHeadRelation("root|advcl|[cx]comp"))).noDependents(NodePattern.N.beforeHead()).correct(NodeCorrector.replace("so " + word)).message("Meinten Sie \u201eso " + word + "\u201c?"));
    }

    private static NodePattern zumalSeparation() {
        String allzumalMsg = "Das Adverb \u201eallzumal\u201c wird zusammengeschrieben";
        return NodePattern.or(NodePattern.N.form("all").directlyBefore(NodePattern.or(NodePattern.N.form("zu").andNot(NodePattern.N.withHead("advmod", NodePattern.N.pos(predicativeAdj))).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("mal"))).message("Das Adverb \u201eallzu\u201c wird zusammengeschrieben"), NodePattern.N.form("zumal").noHeadRelation("nsubj").message(allzumalMsg))).noPos("SUB.*").and(WordSeparation.joinWithNextNode()), NodePattern.N.inFormSequence(0, "zu", "mal").andNot(NodePattern.N.directlyAfter(NodePattern.or(NodePattern.N.form("Mal"), NodePattern.N.inFormSequence(1, "ab", "und")))).andOr(NodePattern.N.directlyAfter(NodePattern.N.form("all").message(allzumalMsg).and(WordSeparation.joinThreeNodes())), NodePattern.N.message("Die Konjunktion sowie die Pr\u00e4position \u201ezumal\u201c werden zusammengeschrieben").and(WordSeparation.joinWithNextNodeBothLowForm())));
    }

    private static NodePattern demZuFolge() {
        NodePattern acl = NodePattern.N.withHeadRelation("acl");
        return NodePattern.or(NodePattern.N.inFormSequence(0, "zu", "folge").andNot(NodePattern.N.directlyAfter(NodePattern.N.inFormSequence(1, "von", "Folge"))).andNot(NodePattern.N.withNeighbor(1, NodePattern.or(NodePattern.N.withDependent("flat"), NodePattern.N.withHead("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.lemma("haben"))))).andOr(NodePattern.N.directlyAfter(NodePattern.N.form("dem").and(WordSeparation.joinThreeNodes()).message("Das Adverb \u201edemzufolge\u201c wird zusammengeschrieben")).andNot(NodePattern.N.withNeighbor(1, NodePattern.N.withHead("nsubj(:pass)?|i?obj|obl|nmod|compound", acl))), NodePattern.N.message("Die Pr\u00e4position \u201ezufolge\u201c wird zusammengeschrieben").and(WordSeparation.joinWithNextNodeBothLowForm())), NodePattern.N.form("demzufolge").directlyAfter(CommonPatterns.comma).withHead("advmod", acl).message("Meinten Sie das Relativpronomen \u201edem\u201c und die Pr\u00e4position \u201ezufolge\u201c?").correct(NodeCorrector.replace("dem zufolge")));
    }

    private static NodePattern daMitSeparation() {
        return NodePattern.or(NodePattern.N.form("mit").message("Die Konjunktion \u201edamit\u201c wird zusammengeschrieben"), NodePattern.N.form("durch").message("Das Adverb \u201edadurch\u201c wird zusammengeschrieben")).markAs("Anchor").directlyAfter(NodePattern.N.form("da").and(WordSeparation.joinWithNextNode())).andNot(NodePattern.N.withHead(NodePattern.N.lemma("sein").pos(".*AUX.*"))).withHead(NodePattern.N.markAs("Head").noDependents("punct", NodePattern.N.between("Head", "Anchor"))).andNot(NodePattern.N.withHeadRelation("case").beforeHead());
    }

    private static NodePattern nachDemSeparation() {
        NodePattern seit = NodePattern.N.form("seit").message("Die Konjunktion \u201eseitdem\u201c wird zusammengeschrieben").correct(NodeCorrector.removeNodes(NodePointer.neighbor(1), NodePointer.neighbor(1)));
        NodePattern je = NodePattern.N.form("je");
        NodePattern nach = NodePattern.N.form("nach").andOr(NodePattern.N.directlyAfter(je).message("H\u00e4ufiger Fehler: Im Sinne von \u201eEs kommt darauf an\u201c schreiben Sie \u201eje nachdem\u201c"), NodePattern.N.message("Die Konjunktion \u201enachdem\u201c wird zusammengeschrieben"));
        NodePattern noCommaBeforeSeitNach = NodePattern.N.directlyAfter(NodePattern.not(CommonPatterns.comma).noHeadRelation("advmod"));
        NodePattern seitOrNach = NodePattern.or(seit, nach).and((seitNach, match) -> match.withCorrector(NodeCorrector.replaceNodes(seitNach, seitNach.neighbor(1), seitNach.lowForm() + "dem").join(noCommaBeforeSeitNach.matches(seitNach) ? NodeCorrector.insertAfter(seitNach.neighbor(-1), ",") : null)));
        return NodePattern.or(NodePattern.or(CommonPatterns.firstChildPhrase.withDependent("case", NodePattern.N.beforeHead().and(seitOrNach)), NodePattern.N.directlyAfter(seitOrNach)).form("dem").markAs("Dem").andOr(NodePattern.N.withHead("obl|mark|nmod", NodePattern.or(NodePattern.N.withHeadRelation("advcl"), NodePattern.N.noPos("SUB.*").andOr(NodePattern.N.withHead("acl", NodePattern.N.noPos("(SUB|EIG).*").noDependents("i?obj|obl", NodePattern.not(NodePattern.N.after("Dem")))), NodePattern.N.withHead("acl|ccomp", CommonPatterns.possiblySkipUp("i?obj|obl", NodePattern.N.pos("VER:IMP:SIN.*").noDependents("nsubj")))).noDependents("ccomp"))), NodePattern.N.withHeadRelation("obl").withNeighbor(-2, je).withDependent("acl"), NodePattern.N.withHeadRelation("root"), CommonPatterns.lastWord, NodePattern.N.directlyBefore(CommonPatterns.skipForward(CommonPatterns.comma, NodePattern.N.withHeadRelation("mark|advmod"))).withDependent("ccomp|acl")), NodePattern.N.form("(nach|seit|au(\u00df|ss)er)dem").withHead("case", NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound").noPos("VER.*")).noDependents().andOr(NodePattern.N.withHead(NodePattern.N.noDependents("det(:poss)?")).correct(NodeCorrector.regexReplace("(.+)dem", "$1 dem")).message("Pr\u00e4position und Artikel werden getrennt geschrieben"), NodePattern.N.correct(NodeCorrector.regexReplace("(.+)dem", "$1")).message("Die Pr\u00e4position passt hier besser als die Konjunktion")), NodePattern.N.form("sei[dt]").withHeadRelation("advmod").directlyBefore(NodePattern.N.form("her")).message("Meinten Sie das Adverb \u201eseither\u201c (= seitdem)?").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "seither")));
    }

    private static NodePattern soVielSeparation() {
        return NodePattern.or(NodePattern.N.form("soviel").andOr(NodePattern.N.markAs("Soviel").withDependent("nmod", NodePattern.N.withDependent("case", NodePattern.N.form("wie").directlyAfter("Soviel"))).andNot(NodePattern.N.withHead("obj", NodePattern.N.lemma("bedeuten|hei\u00dfen"))), NodePattern.N.noDependents().withHeadRelation("obj")).andNot(CommonPatterns.firstChildPhrase.withHead(NodePattern.N.withHeadRelation("a(dv)?cl"))).andNot(GermanTreePatterns.headInQuotes).and(SpellingRules.typoReplacement("so viel")), CommonPatterns.firstChildPhrase.inFormSequence(1, "so", "viel").withHead("advmod", NodePattern.N.withHeadRelation("a(dv)?cl")).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "soviel")).message("Die Konjunktion \u201esoviel\u201c wird zusammengeschrieben"), NodePattern.N.form("soviele[mnsr]?").withHeadRelation("amod|det").and(SpellingRules.typoRegexReplacement("(so)(v.+)", "$1 $2")));
    }

    private static NodePattern soWeitSeparation() {
        return NodePattern.or(NodePattern.N.form("soweit").andOr(NodePattern.N.withHead("mark", NodePattern.N.lemma("reichen")), NodePattern.N.noHeadRelation("cc|mark").andNot(NodePattern.N.withHeadRelation("advmod").andOr(NodePattern.N.withHead(NodePattern.N.withHeadRelation("advmod|advcl")).directlyBeforeHead(), NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("nsubj").andOr(NodePattern.N.directlyBeforeHead(), NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("aux(:pass)?|cop"))))))).correct(NodeCorrector.replace("so weit")).message("\u201eSoweit\u201c wird nur dann zusammengeschrieben, wenn es einen Nebensatz einleitet"), CommonPatterns.firstChildPhrase.form("weit").withDependent("advmod", NodePattern.N.form("so")).withHead("advmod", NodePattern.or(NodePattern.N.withHeadRelation("ccomp"), NodePattern.N.lemma("wissen|verstehen|einsch\u00e4tzen|beurteilen").withHeadRelation("a(dv)?cl"))).noDependents("advcl").andNot(NodePattern.N.directlyBeforeHead()).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "soweit")).message("Die Konjunktion \u201esoweit\u201c wird zusammengeschrieben")).andNot(GermanTreePatterns.headInQuotes);
    }

    private static NodePattern zurZeit() {
        NodePattern von = NodePattern.N.form("von");
        NodePattern nounOrName = NodePattern.N.pos("(SUB|EIG).*");
        return NodePattern.or(NodePattern.N.form("zurzeit").andOr(NodePattern.N.beforeHead().withHead("advmod", NodePattern.N.onlyPos("SUB:GEN.*")), NodePattern.N.directlyBefore(von.withHead("case", nounOrName.andNot(NodePattern.N.withHead("obl", NodePattern.N.withDependent("aux:pass")))))).message("Meinten Sie \u201ezur Zeit\u201c (einen Zeitabschnitt)?").correct(NodeCorrector.replace("zur Zeit")), NodePattern.N.inFormSequence(1, "zur", "Zeit").withOnlyDependents(NodePattern.N.withHeadRelation("case").directlyBeforeHead()).andNot(NodePattern.N.directlyBefore(von.withHead("case", nounOrName.withHead("obl", NodePattern.N.withDependent("compound:prt", NodePattern.N.form("weg")))))).message("Meinten Sie \u201ezurzeit\u201c im Sinne von \u201emomentan\u201c?").correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "zurzeit")));
    }

    private static NodePattern emailSeparation() {
        NodePattern verbsWithEmail = NodePattern.N.lemma("(ver)?(schicken|senden|fassen)|erhalten|bekommen|empfangen|schreiben|lesen|entwerfen|archivieren|organisieren|sortieren|(weiter)?leiten|speichern|l\u00f6schen|blockieren|(be)?antworten|\u00fcberpr\u00fcfen|\u00f6ffnen|verschl\u00fcsseln|abonnieren|zur\u00fcckrufen");
        NodePattern nominalHeadOrRoot = NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound|root|appos|flat|conj").noDependents("aux").andNot(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE));
        NodePattern e = NodePattern.N.form("e");
        NodePattern mail = NodePattern.N.form("mail");
        NodePattern email = NodePattern.N.form("email");
        NodePattern start = NodePattern.N.markAs("Start");
        return NodePattern.or(nominalHeadOrRoot.andOr(SpellingRules.noun, NodePattern.N.noPos("VER.*")).andNot(verbsWithEmail).andOr(NodePattern.N.directlyAfter(email.and(start)), NodePattern.N.directlyAfter(CommonPatterns.HYPHEN_LIKE_NODE.andOr(NodePattern.N.directlyAfter(email.and(start)), NodePattern.N.directlyAfter(mail.directlyAfter(e.and(start))), NodePattern.N.directlyAfter(NodePattern.N.formCaseSensitive("mail").directlyAfter(CommonPatterns.skipBack(CommonPatterns.HYPHEN_LIKE_NODE, e.and(start)))))), NodePattern.N.directlyAfter(mail.directlyAfter(CommonPatterns.skipBack(CommonPatterns.HYPHEN_LIKE_NODE, e.and(start))))).andNot(GermanTreePatterns.englishWord.withHead("obl|flat", GermanTreePatterns.englishWord.andNot(NodePattern.N.alreadyMarkedAs("Start")))).andNot(NodePattern.N.withNextSibling(GermanTreePatterns.englishWord.withDependent(".*", GermanTreePatterns.englishWord))).correct(NodeCorrector.replaceNodes(NodePointer.marked("Start"), NodePointer.anchor(), m -> List.of("E-Mail-" + StringTools.uppercaseFirstChar((String)m.anchor().form())))), NodePattern.N.form("E?mailing").andOr(NodePattern.N.directlyAfter(e).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "E-Mailing")), NodePattern.N.form("e.*").correct(NodeCorrector.replace("E-Mailing"))), NodePattern.N.form("mail.{3,}").noForm("mailing").and(CommonPatterns.afterSkipping(CommonPatterns.HYPHEN_LIKE_NODE, e.and(start))).and((node, match) -> {
            Node eAsStart = match.getMarkedNode("Start");
            String secondPart = StringTools.uppercaseFirstChar((String)node.lowForm().substring("mail".length()));
            return match.withCorrector(NodeCorrector.replaceNodes(eAsStart, node, "E-Mail-" + secondPart));
        }), NodePattern.N.formCaseSensitive("mails?").directlyAfter(CommonPatterns.HYPHEN_LIKE_NODE.directlyAfter(e)).andOr(NodePattern.N.form(".*s").correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-2), NodePointer.anchor(), "E-Mails")), NodePattern.N.correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-2), NodePointer.anchor(), "E-Mail"))), NodePattern.N.form("mails?").directlyAfter(e).andNot(NodePattern.N.directlyBefore(nominalHeadOrRoot.andNot(verbsWithEmail))).andOr(NodePattern.N.form(".*s").correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "E-Mails")), NodePattern.N.correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "E-Mail"))), NodePattern.N.form("emails?").andNot(NodePattern.N.noSpaceBefore().directlyAfter(NodePattern.N.form("[{]"))).andOr(NodePattern.N.withDependent(".*", NodePattern.N.label("EMAIL")), NodePattern.N.withHead("nsubj(:pass)?|i?obj|obl|nmod|compound", verbsWithEmail), NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE).withHead("compound", NodePattern.not(nominalHeadOrRoot)), NodePattern.N.directlyAfter(CommonPatterns.HYPHEN_LIKE_NODE).withDependent("compound", NodePattern.N)).correct(NodeCorrector.regexReplace("email(s)?", "E-Mail$1"))).message("\u201eE-Mail\u201c und davon abgeleitete W\u00f6rter werden mit Bindestrich geschrieben, beide Wortteile werden gro\u00dfgeschrieben");
    }

    private static NodePattern sowiesoSeparation() {
        NodePattern adverbOnAdjOrAdv = NodePattern.N.withHead("advmod", NodePattern.not(NodePattern.ROOT).pos("(ADV|ADJ:PRD).*").withDependent("advcl|amod", NodePattern.N.afterHead())).directlyBeforeHead();
        return NodePattern.or(NodePattern.or(NodePattern.N.form("so").directlyAfter(NodePattern.N.form("wie").directlyAfter(NodePattern.N.form("so").markAs("Begin"))), NodePattern.N.form("wieso").directlyAfter(NodePattern.N.form("so").markAs("Begin")), NodePattern.N.form("so").directlyAfter(NodePattern.N.form("sowie").markAs("Begin"))).andNot(adverbOnAdjOrAdv).correct(NodeCorrector.replaceNodes(NodePointer.marked("Begin"), NodePointer.anchor(), "sowieso")).correct(NodeCorrector.replaceNodes(NodePointer.marked("Begin"), NodePointer.anchor(), "ohnehin")).message("Im Sinne von \u201eohnehin\u201c wird \u201esowieso\u201c zusammengeschrieben"), NodePattern.or(NodePattern.N.form("sowieso").correct(NodeCorrector.replace("sowie so")), NodePattern.or(NodePattern.N.form("so").directlyAfter(NodePattern.N.form("wie").directlyAfter(NodePattern.N.form("so").markAs("Begin"))), NodePattern.N.form("wieso").directlyAfter(NodePattern.N.form("so").markAs("Begin"))).correct(NodeCorrector.replaceNodes(NodePointer.marked("Begin"), NodePointer.anchor(), "sowie so"))).and(adverbOnAdjOrAdv).message("Die Konjunktion \u201esowie\u201c wird getrennt von einem folgenden Adverb \u201eso\u201c geschrieben"));
    }

    private static NodePattern miscSeparation() {
        return NodePattern.or(NodePattern.N.form("ausversehen").withHeadRelation("advmod").and(SpellingRules.typoReplacement("aus Versehen")), NodePattern.N.formCaseSensitive("EBook").correct(NodeCorrector.replace("E-Book")).message("Die Standardschreibweise ist \u201eE-Book\u201c"), NodePattern.N.form("zurfolge").correct(NodeCorrector.replace("zur Folge")).message("Das Substantiv \u201eFolge\u201c wird mit einer vorangestellten Pr\u00e4position getrennt geschrieben"), NodePattern.N.form("sofern").andNot(NodePattern.N.directlyAfter(CommonPatterns.skipBack(NodePattern.not(CommonPatterns.letterWord), NodePattern.N.form("in")))).andNot(NodePattern.or(CommonPatterns.firstChildPhrase.withHead(NodePattern.N.withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis")), NodePattern.N.withHeadRelation("mark"), GermanTreePatterns.headInQuotes)).correct(NodeCorrector.replace("so fern")).message("\u201eSofern\u201c wird nur als Konjunktion zusammengeschrieben"), NodePattern.N.form("(viel)?zu(viel|wenig)(e[rn]?)?").noDependents("det(:poss)?").andNot(NodePattern.N.withHead("conj", NodePattern.N.withDependent("det(:poss)?"))).andOr(NodePattern.N.form("zu.+").correct(NodeCorrector.regexReplace("zu(.+)", "zu $1")), NodePattern.N.correct(NodeCorrector.regexReplace("vielzu(.*)", "viel zu $1"))).message("\u201eZu\u201c wird mit nachgestelltem Adjektiv oder Adverb auseinandergeschrieben"), NodePattern.N.form("jedesmal").correct(NodeCorrector.replace("jedes Mal")).message("\u201eJedesmal\u201c ist eine veraltete Schreibweise"), NodePattern.N.form("letztenmal").correct(NodeCorrector.replace("letzten Mal")).message("\u201eLetztenmal\u201c ist eine veraltete Schreibweise"), NodePattern.N.formCaseSensitive("fach").withDependent("de[pt]", NodePattern.N.form("ein").directlyBeforeHead()).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "einfach", "ein Fach")).message("Meinten Sie \u201eeinfach\u201c oder \u201eein Fach\u201c?"), NodePattern.N.form("inder").withHeadRelation("case").and(SpellingRules.typoReplacement("in der")), NodePattern.or(NodePattern.N.form("tun|hause").directlyAfter(NodePattern.N.form("zu").directlyAfter(CommonPatterns.skipBack(NodePattern.N.withHeadRelation("amod"), NodePattern.N.pos("PRO:POS.*"))).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), m -> List.of("Zu" + m.anchor().neighbor(1).lowForm())))), NodePattern.N.inFormSequence(2, "zum", "bei", "spiel").correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "Beispiel")), NodePattern.N.inFormSequence(2, "zum|beim|ans|f\u00fcrs", "selber", "machen").noDependents("aux|nsubj").noDependents("nmod", NodePattern.N.beforeHead()).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "Selbermachen")), NodePattern.N.inFormSequence(2, "zum", "abend|mittag", "essen").noDependents("aux|nsubj").noDependents("nmod", NodePattern.N.beforeHead()).directlyAfter(WordSeparation.joinWithNextNode()), NodePattern.or(NodePattern.N.inFormSequence(0, "best", "(bezahlt|bekannt|ge(hasst|kleidet)|m(\u00f6|oe)glich|renommiert).*"), NodePattern.N.inFormSequence(0, "weitest", "m(\u00f6|oe)glich.*"), NodePattern.N.inFormSequence(0, "n(\u00e4|ae)chst", "(m\u00f6glich|gelegen|liegend|besser|folgend).*"), NodePattern.N.inFormSequence(0, "letzt", "(m\u00f6glich|endlich|malig|genannt|geboren|h\u00e4ndig|instanzlich|j\u00e4hrig|platziert|verbindlich|w\u00f6chig|willig).*")).withHeadRelation("advmod").directlyBefore(NodePattern.N.withHeadRelation("a(dv)?mod|root")).and(WordSeparation.joinWithNextNode()), NodePattern.N.form("da").markAs("Da").directlyBefore(NodePattern.N.form("bei|f\u00fcr|gegen|hin|nach|neben|ra(uf|n)|runter|vor").andNot(NodePattern.N.withHead("case", NodePattern.not(NodePattern.N.alreadyMarkedAs("Da"))))).andNot(NodePattern.N.withHead(NodePattern.or(NodePattern.N.pos(".*IMP.*").noDependents("nsubj"), NodePattern.N.pos(".*INF.*").withDependent("nsubj", NodePattern.N.form("sie")))).afterHead()).and(WordSeparation.joinWithNextNode()), NodePattern.N.form("wo").markAs("Wo").directlyBefore(NodePattern.N.form("von").andNot(NodePattern.N.withHead("case", NodePattern.not(NodePattern.N.alreadyMarkedAs("Wo"))))).and(WordSeparation.joinWithNextNode()), NodePattern.N.form("durch").directlyBefore(NodePattern.N.form("aus").noHeadRelation("case|compound:prt")).and(WordSeparation.joinWithNextNode()), NodePattern.N.form("ge?rade").directlyBefore(NodePattern.N.form("aus").noHeadRelation("case")).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "geradeaus")), GermanTreePatterns.firstInPhraseAfterCommasOrConj.form("zu").directlyBefore(NodePattern.N.form("dem").noHeadRelation("det").noDependents("acl").withHead(NodePattern.ROOT.noDependents("acl"))).and(WordSeparation.joinWithNextNode()), NodePattern.N.form("statt").directlyBefore(NodePattern.N.form("dessen").noHeadRelation("det").andNot(CommonPatterns.firstChildPhrase.withHead("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.withHeadRelation("acl")))).and(WordSeparation.joinWithNextNode()), NodePattern.N.form("zwischen").directlyBefore(NodePattern.N.form("durch").noHeadRelation("case|compound:prt")).and(WordSeparation.joinWithNextNode()), NodePattern.N.form("so").directlyBefore(NodePattern.N.form("wohl")).andNot(NodePattern.N.directlyBeforeHead()).and(WordSeparation.joinWithNextNode()), NodePattern.N.form("mit").directlyBefore(NodePattern.N.form("unter").noHeadRelation("case|compound:prt")).and(WordSeparation.joinWithNextNode()), NodePattern.N.form("hier").directlyBefore(NodePattern.N.form("f(\u00fc|ue)r|bei").noHeadRelation("case|compound:prt")).and(WordSeparation.joinWithNextNode()), NodePattern.N.form("an").directlyBefore(NodePattern.N.form("statt").noHeadRelation("compound:prt")).and(WordSeparation.joinWithNextNode()), NodePattern.N.form("so").directlyBefore(CommonPatterns.firstChildPhrase.form("fern").withHead(NodePattern.N.withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis"))).and(WordSeparation.joinWithNextNode()), NodePattern.N.form("immer").directlyBefore(NodePattern.N.form("hin").noDependents().noHeadRelation("compound:prt").andNot(NodePattern.N.directlyBeforeHead())).and(WordSeparation.joinWithNextNode()), NodePattern.N.form("hier|so").directlyBefore(NodePattern.N.form("mit").noHeadRelation("compound:prt").andOr(NodePattern.N.noHeadRelation("case"), NodePattern.N.withHeadRelation("case").directlyBefore(NodePattern.N.withHeadRelation("det(:poss)?").noPos(".*DAT.*")))).and(WordSeparation.joinWithNextNode()), NodePattern.N.form("zu").andOr(NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.form("gute").withHead(NodePattern.N.lemma("halten|kommen")), NodePattern.N.form("nichte").withHead(CommonPatterns.skipUp("xcomp", NodePattern.N.lemma("machen"))), NodePattern.N.form("liebe").withHead(NodePattern.N.lemma("tun")), NodePattern.N.formCaseSensitive("nutze").withHead(NodePattern.N.lemma("machen")).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "zu Nutze"))).andNot(NodePattern.N.directlyBeforeHead())), NodePattern.N.withHead("case", NodePattern.N.form("folge").withHead("nmod", NodePattern.N.pos("(SUB|EIG).*")).afterHead().withOnlyDependents(NodePattern.N.directlyBeforeHead()))).and(WordSeparation.joinWithNextNode()), NodePattern.N.lemma("der").withHead(NodePattern.N.form("jenige[mnsr]?")).directlyBeforeHead().and(WordSeparation.joinWithNextNode()), NodePattern.N.form("zahl").withDependent("amod", NodePattern.N.form("viel").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "Vielzahl"))).withDependent("det(:poss)?")).message(WORD_IS_COMPOUND_MSG));
    }

    private static NodePattern numberSeparation() {
        NodePattern und = NodePattern.N.form("und");
        NodePattern dozens = NodePattern.N.form(".+(z|ss|\u00df)ig");
        NodePattern eins = NodePattern.N.form("eins");
        NodePattern digitEndsWithZehn = NodePattern.N.form(".+zehn");
        String hundertOrTausend = "hundert|tausend";
        NodePattern concatenateDigits = NodePattern.custom((node, match) -> {
            Node start = match.getMarkedNode("Start");
            Node end = match.getMarkedNode("End");
            return match.withCorrector(NodeCorrector.replaceNodes(start, end, ((StreamEx)start.forward().takeWhileInclusive(n -> n != end)).map(n -> n.lowForm()).joining((CharSequence)"")));
        });
        NodePattern beforeZalMarkedAsEnd = NodePattern.N.directlyBefore(SpellingRules.zal.markAs("End"));
        NodePattern beforeZahlOrDigit = NodePattern.N.directlyBefore(NodePattern.or(SpellingRules.zal, NodePattern.N.form("\\d+")).andNot(CommonPatterns.possiblyConj(NodePattern.N.withHead("nummod", NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound").andNot(SemanticRules.units)))));
        NodeCorrector.Relative separateAndCapitalizeMal = NodeCorrector.regexReplace("(.*)mal", "$1 Mal");
        NodePattern withHeadDigit = NodePattern.N.withHead("advmod|compound|nmod", NodePattern.or(NodePattern.N.pos("ZAL"), NodePattern.N.withHeadRelation("nummod"), NodePattern.N.form("\\d+")));
        NodePattern mal = NodePattern.N.formCaseSensitive("mal");
        return NodePattern.or(NodePattern.N.withHeadRelation("nummod|det|compound|obj|root").markAs("Start").andOr(zahlOrEin.andOr(NodePattern.N.directlyBefore(SpellingRules.zal.markAs("SecondNum").andOptionally(beforeZalMarkedAsEnd)), NodePattern.N.directlyBefore(NodePattern.N.form("hundert").markAs("SecondNum").andOptionally(beforeZalMarkedAsEnd))).andNot(NodePattern.N.directlyBefore(NodePattern.N.directlyBefore(und))).andNot(NodePattern.N.withNeighbor(2, NodePattern.N.form("mal"))).andOr(NodePattern.markedNodeMatches("End", concatenateDigits), NodePattern.custom((node, match) -> match.withCorrector(NodeCorrector.replaceNodes(node, node.neighbor(1), node.form() + StringTools.lowercaseFirstChar((String)node.neighbor(1).form()))))), SpellingRules.zal.directlyBefore(und.directlyBefore(SpellingRules.zal.markAs("SecondNum").andOptionally(NodePattern.N.directlyBefore(SpellingRules.zal.markAs("End"))))).andOr(NodePattern.N.directlyAfter(SpellingRules.zal).and((node, match) -> match.withCorrector(NodeCorrector.replaceNodes(node.neighbor(-1), node.neighbor(2), node.neighbor(-1).form() + node.form() + "und" + node.neighbor(2).form()))), NodePattern.markedNodeMatches("End", concatenateDigits), NodePattern.custom((node, match) -> match.withCorrector(NodeCorrector.replaceNodes(node, node.neighbor(2), node.form() + "und" + node.neighbor(2).form()))))).andOr(NodePattern.or(Capitalization.cardinal, NodePattern.N.form("sieb")).directlyBefore(NodePattern.N.form("zehn")).andNot(NodePattern.N.form("zw(ei|o|\u00f6lf)|sieben|zehn|elf")), NodePattern.or(Capitalization.cardinal, NodePattern.N.form("ein"), dozens).directlyBefore(NodePattern.N.form(hundertOrTausend)).andNot(dozens.directlyBefore(NodePattern.N.form("hundert"))), NodePattern.or(NodePattern.N.form("ein"), Capitalization.cardinal).directlyBefore(und.directlyBefore(dozens)).andNot(NodePattern.N.form("zw(\u00f6lf|o)|zehn|elf")), NodePattern.N.form(".*(" + hundertOrTausend + ")").andOr(NodePattern.N.directlyBefore(NodePattern.or(Capitalization.cardinal, dozens, eins, digitEndsWithZehn)), NodePattern.N.directlyBefore(NodePattern.N.form("und").directlyBefore(NodePattern.or(Capitalization.cardinal, dozens, eins, digitEndsWithZehn)))), dozens.directlyBefore(NodePattern.N.form("tausend.*"))).andNot(NodePattern.N.withHead("det", NodePattern.N.withDependent("amod"))).andNot(NodePattern.N.withHead("nummod", NodePattern.N.withDependent("case"))).andNot(NodePattern.N.withHead("nummod", NodePattern.N.withHead("nummod", NodePattern.N.withHead("nmod", NodePattern.N.withHeadRelation("amod"))))).andNot(NodePattern.N.withHead("nsubj", NodePattern.or(NodePattern.N.lemma("ergeben|machen"), NodePattern.N.pos("ZAL").withDependent("cop")))).noDependents("case").andNot(NodePattern.N.withHead("obj", NodePattern.N.lemma("zusammen(rechnen|z\u00e4hlen)|addieren").withDependent("nsubj", NodePattern.N.form("man")))).message("Schreiben Sie Zahlen unter einer Million zusammen"), zahlOrEin.andOr(NodePattern.N.directlyBefore(NodePattern.N.form("einhalb")).and(WordSeparation.joinWithNextNode()), NodePattern.N.directlyBefore(NodePattern.N.inFormSequence(0, "(a|ei)n", "halb")).and((node, match) -> match.withCorrector(NodeCorrector.replaceNodes(node, node.neighbor(2), node.form() + "einhalb")))).message("Zahlw\u00f6rter auf \u201e-einhalb\u201c werden zusammengeschrieben"), NodePattern.N.inFormSequence(0, "\\d{0,3}", "er").andOr(NodePattern.N.withNeighbor(1, NodePattern.N.directlyBeforeHead().withHead(SpellingRules.noun.noLabel("PRODUCT"))).and((node, match) -> match.withCorrector(NodeCorrector.replaceNodes(node, node.neighbor(2), node.form() + "er-" + node.neighbor(2).form()))), WordSeparation.joinWithNextNode()).message("H\u00e4ngen Sie die Endung bei Zahlen direkt an"), NodePattern.or(NodePattern.or(NodePattern.N.form("\\d+mal").andOr(NodePattern.N.withHead("conj", NodePattern.N.withHeadRelation("nummod")).directlyAfter(CommonPatterns.HYPHEN_LIKE_NODE).correct(separateAndCapitalizeMal.join(NodeCorrector.replace(NodePointer.neighbor(-1), "bis"))), NodePattern.N.correct(NodeCorrector.regexReplace("(.*)mal", "$1-mal")).correct(separateAndCapitalizeMal)), NodePattern.N.form("\\d+").directlyBeforeHead().withHead("nummod", mal.andNot(withHeadDigit)).andNot(NodePattern.N.form("[123][0-9]{3}")).andOptionally(NodePattern.N.noDependents("nummod", NodePattern.N.directlyBeforeHead()).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), m -> List.of(m.anchor().form() + "-mal")))).correct(NodeCorrector.replace(NodePointer.neighbor(1), "Mal"))).message("Schreiben Sie \u201emal\u201c mit Bindestrich oder gro\u00df"), zahlOrEin.directlyBeforeHead().withHead("nummod|det", mal.andNot(withHeadDigit)).message(ADV_SPELLED_TOGETHER_MSG).andOr(NodePattern.N.withNeighbor(-1, zahlOrEin.and(WordSeparation.joinThreeNodes())), WordSeparation.joinWithNextNode()), NodePattern.N.form(".+mal").and(node -> node.tree().treeSupport().tagToken(node.form().replaceAll("(.+)mal", "$1")).hasPos("ZAL")).andOr(NodePattern.N.directlyAfter(zahlOrEin.directlyBeforeHead().and(WordSeparation.joinWithNextNode())).message(ADV_SPELLED_TOGETHER_MSG), beforeZahlOrDigit.message("In mathematischen Ausdr\u00fccken wird \u201emal\u201c getrennt geschrieben").correct(NodeCorrector.regexReplace("(.*)(mal)", "$1 $2")))));
    }

    private static NodePattern coordinatedCompoundPartsPattern() {
        String roomTypesAndWellness = "Bade|Schlaf|Wohn|Ess|Arbeits|Dusch|Kinder|K\u00f6rper|Yoga|Peeling|Erlebnis|Hand|Sauna|Strand|Pflege|Massage|Brause|Freizeit";
        NodePattern rechtschreibSchwaeche = NodePattern.N.lemma("Rechtschreib(schw\u00e4che|st\u00f6rung)");
        NodeCorrector.Relative removeTagUnd = NodeCorrector.replaceNodes(NodePointer.marked("Tag"), NodePointer.marked("Und"), "");
        return NodePattern.or(WordSeparation.coordinatedCompoundParts("(R\u00fcstungs|Raumfahrt|Luft(fahrt)?)", "(R\u00fcstung|(Raum|Luft)fahrt)s?(technologie|konzern|industrie|branche|unternehmen).*"), WordSeparation.coordinatedCompoundParts("(Natur|Umwelt)(schutz)?", "(Natur|Umwelt).+").noLabel("ORGANIZATION"), WordSeparation.coordinatedCompoundParts("Preis|Leistungs|Kosten", "(Leistungs|Preis|Kosten).+|Fahrplanausk[u\u00fc]nft.*"), WordSeparation.coordinatedCompoundParts("Grund|Mittel|Gemeinschafts|Ober|Haupt", "(Grund|Mittel|Gemeinschafts|Ober|Haupt)schule.*"), WordSeparation.coordinatedCompoundParts("Wohnungs|Hof|Haus", "(Badeordnung|(Wohnungs|Hof|Haus).+|Grund(besitzer|st\u00fcck).*)"), WordSeparation.coordinatedCompoundParts("Sport|Spiel|Fitness", "(Sport|Spiel|Fitness).+|.+zentrum|.+hotel.*"), WordSeparation.coordinatedCompoundParts("Ober|Unter"), WordSeparation.coordinatedCompoundParts("Einzel|Gruppe|Paar|Mannschafts|Doppel|Gesamt|Regel|Geschwister"), WordSeparation.coordinatedCompoundParts("Neu|Bestands|Alt|Gebraucht"), WordSeparation.coordinatedCompoundParts("Stand|H([\u00e4a])nge"), WordSeparation.coordinatedCompoundParts("Gefrier|W[\u00e4a]rm|K\u00fchl"), WordSeparation.coordinatedCompoundParts("Gro\u00df|Klein"), WordSeparation.coordinatedCompoundParts("Damen|Herren"), WordSeparation.coordinatedCompoundParts("Gewinn|Verlust"), WordSeparation.coordinatedCompoundParts("Stil|Grammatik"), WordSeparation.coordinatedCompoundParts("Tag|Nacht"), WordSeparation.coordinatedCompoundParts("Lese|Rechtschreib").andNot(NodePattern.N.withNeighbor(2, rechtschreibSchwaeche)), NodePattern.N.form("Tag").markAs("Tag").directlyBefore(CommonPatterns.skipForward(CommonPatterns.HYPHEN_LIKE_NODE, NodePattern.N.inFormSequence(0, "und", "Nachtgleiche").markAs("Und").withNeighbor(1, NodePattern.N.correct(NodeCorrector.regexReplace("Nachtgleiche(.*)", "Tagundnachtgleiche$1").join(removeTagUnd)).correct(NodeCorrector.regexReplace("Nachtgleiche(.*)", "Tag-und-Nacht-Gleiche$1").join(removeTagUnd))))).message("Schreiben Sie dieses Wort zusammen oder mit Bindestrichen"), rechtschreibSchwaeche.afterHead().withHead("conj", NodePattern.N.form("Lese").directlyBefore(CommonPatterns.skipForward(CommonPatterns.HYPHEN_LIKE_NODE, NodePattern.N.withHeadRelation("cc").directlyBeforeHead()))).and((node, match) -> {
            String schwaeche = StringTools.uppercaseFirstChar((String)node.form().substring(12));
            return match.withCorrector(NodeCorrector.replaceNodes(node.neighbor(-2), node, "Lese-Rechtschreib-" + schwaeche)).withMessage("Meinten Sie \u201eLese-Rechtschreib-" + schwaeche + "\u201c?");
        }), WordSeparation.coordinatedCompoundParts("Nah|Fern"), WordSeparation.coordinatedCompoundParts("Sonn|Feier"), WordSeparation.coordinatedCompoundParts("Lohn|Gehalts"), WordSeparation.coordinatedCompoundParts("Hotel|Gastst\u00e4tten"), WordSeparation.coordinatedCompoundParts("Industrie", "Handelskammer.*"), WordSeparation.coordinatedCompoundParts(roomTypesAndWellness, "(" + roomTypesAndWellness + ")(zimmer|seife|gel|(pflege)?set|pflege|produkt|creme|tuch|salz|welt|tuch|wanne|anlage|\u00f6l|liege|schutz|armatur|hose|kabine)"), WordSeparation.coordinatedCompoundParts("Frist|Form"), WordSeparation.coordinatedCompoundParts("Start|Lande"), WordSeparation.coordinatedCompoundParts("Hieb|Stich"), WordSeparation.coordinatedCompoundParts("Garten|Landschafts"), WordSeparation.coordinatedCompoundParts("(Rechts)?anwalts|Notar"), WordSeparation.coordinatedCompoundParts("Hals|Mast", "(Bein|Schot)bruch"), WordSeparation.coordinatedCompoundParts("Bu(\u00df|ss)", "Bettag"), WordSeparation.coordinatedCompoundParts("Voll|Teil"), NodePattern.or(NodePattern.N.form("Hals|Mast").directlyBefore(NodePattern.N.form("und|oder|/|sowie|plus|bzw|beziehungsweise|&").directlyBefore(NodePattern.N.form("(Bein|Schot)bruch"))), NodePattern.N.formCaseSensitive("\u00d6l").withDependent("conj", NodePattern.N.form("(Gas|Schmier|Fett).+")), NodePattern.N.form("Summen").withDependent("conj", NodePattern.N.form("Saldenlisten?")), NodePattern.N.form("Antigen").withDependent("conj", NodePattern.N.form("PCR").and(CommonPatterns.beforeSkipping(CommonPatterns.HYPHEN_LIKE_NODE, NodePattern.N.lemma("Test"))))).andNot(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_NODE)).message(HYPHEN_SHORTED_NOUNS_MSG).correct(NodeCorrector.insertAfter(NodePointer.anchor(), "-")));
    }

    private static NodePattern coordinatedCompoundParts(String prefix) {
        return WordSeparation.coordinatedCompoundParts(prefix, "(" + prefix + ").+");
    }

    private static NodePattern coordinatedCompoundParts(String firstPart, String secondPart) {
        NodePattern nachher = NodePattern.N.form("nachher").markAs("Nachher");
        NodePattern vorher = NodePattern.N.form("vorher").markAs("Vorher");
        NodePattern beforeHyphen = NodePattern.N.noSpaceAfter().and(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE).markAs("Hyphen"));
        NodePattern hin = NodePattern.N.form("hin").markAs("Hin");
        String nonVerbPrefixes = "r\u00fcck|durch|\u00fcber|um|unter|wider|hinter|ober|ver|in|im|ex|be|ent|(vor|r\u00fcck)w\u00e4rts";
        String allSeparablePrefixes = "(r?(ab|an|auf|aus(einander)?|unter)|bei|da(bei)?|dar(an|zwischen)?|ein|empor|ent(gegen|lang|zwei)?|fehl|fern|fest|fort|frei|gegen\u00fcber|gleich|heim|her(ab|an|auf|aus|bei|ein|um|unter|vor|\u00fcber)?|hin(ab|auf|aus|ein|terher|unter|weg|zu)?|hoch|los|mit|nach|nebenher|nieder|statt|vor(an|aus|bei|weg|\u00fcber)?|weg|weiter|zu(recht|r\u00fcck|sammen)?)|" + nonVerbPrefixes;
        NodePattern baseWithPrefix = NodePattern.N.form("((r?(ab|an|auf|aus(einander)?|unter)|bei|da(bei)?|dar(an|zwischen)?|ein|empor|ent(gegen|lang|zwei)?|fehl|fern|fest|fort|frei|gegen\u00fcber|gleich|heim|her(ab|an|auf|aus|bei|ein|um|unter|vor|\u00fcber)?|hin(ab|auf|aus|ein|terher|unter|weg|zu)?|hoch|los|mit|nach|nebenher|nieder|statt|vor(an|aus|bei|weg|\u00fcber)?|weg|weiter|zu(recht|r\u00fcck|sammen)?)|" + nonVerbPrefixes + ").{3,}");
        NodePattern insertHyphenBeforePrefix = NodePattern.N.correct(NodeCorrector.insertAfter(NodePointer.marked("FirstPrefix"), "-"));
        NodePattern directlyAfterFirstPrefix = NodePattern.N.directlyAfter(NodePattern.N.alreadyMarkedAs("FirstPrefix"));
        NodePattern insertHyphenBeforeFirstPrefixInCompoundVerb = NodePattern.N.pos("VER(:PA2.*|.*NON)").withDependent("cc", directlyAfterFirstPrefix).markAs("ShortedVerb").message(HYPHEN_SHORTED_VERBS_MSG).and(insertHyphenBeforePrefix);
        NodePattern dependentVerWithZu = NodePattern.N.withDependent("conj|xcomp", NodePattern.N.pos("VER:EIZ.*").and(baseWithPrefix));
        String separatedPrefix = "compound:prt";
        NodePattern cc = NodePattern.N.withHeadRelation("cc|punct").form("und|oder|/|sowie|plus|bzw|beziehungsweise|&");
        NodePattern directlyBeforeHyphen = NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_NODE);
        NodePattern secondPartPosSub = NodePattern.N.lemma(secondPart).and(SpellingRules.noun).andNot(NodePattern.N.alreadyMarkedAs("Start"));
        return NodePattern.or(NodePattern.or(NodePattern.N.pos("ADJ.*"), NodePattern.N.noPos()).directlyAfter(cc.markAs("CC")).andOr(NodePattern.N.withHead("conj", NodePattern.N.withHeadRelation("amod|advmod|acl").markAs("FirstPrefix").andNot(directlyBeforeHyphen).noPos("(ADJ|PA2|VER:INF).*").noForm(".*weise")), NodePattern.N.withHead("amod", SpellingRules.noun.withHead("conj", NodePattern.N.withHeadRelation("obj").markAs("FirstPrefix").directlyBefore(NodePattern.N.alreadyMarkedAs("CC")).noPos().andNot(directlyBeforeHyphen)))).and((node, match) -> {
            Node firstPrefix = match.getMarkedNode("FirstPrefix");
            for (int i = node.form().length() - 1; i >= 1; --i) {
                String substring = node.lowForm().substring(i);
                if (!node.tree().treeSupport().tagToken(substring).hasPos("(ADJ|ADV).*")) continue;
                String newAdj = firstPrefix.lowForm() + substring;
                if (!node.tree().treeSupport().isAcceptedBySpellchecker(newAdj) && !node.tree().treeSupport().tagToken(newAdj).hasPos("ADJ.*") && !newAdj.matches("sanglos|nietfest")) continue;
                return match.withCorrector(NodeCorrector.insertAfter(firstPrefix, "-"));
            }
            return null;
        }).message(HYPHEN_SHORTED_ADJ_MSG), NodePattern.N.inFormSequence(0, "hin", "und", "her", "gerissen").reportEverythingTouched().correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(3), "hin- und hergerissen")).message("Die feste Redewendung \u201ehin- und hergerissen\u201c wird mit einem Bindestrich und zusammen geschrieben"), NodePattern.N.form(allSeparablePrefixes).andOr(NodePattern.or(NodePattern.N.withHeadRelation(separatedPrefix).and(dependentVerWithZu), NodePattern.N.withHead(separatedPrefix, NodePattern.or(dependentVerWithZu, NodePattern.N.withHeadRelation("conj|xcomp").pos("VER:EIZ.*").and(baseWithPrefix))).noDependents("conj", NodePattern.N.pos("ADV:LOK")), NodePattern.N.withHeadRelation("xcomp").pos("(ADV:LOK|ADJ:PRD:GRU)").and(dependentVerWithZu), NodePattern.ROOT.withDependent("conj", NodePattern.N.pos("(VER|PA2).*").directlyAfter(cc).afterHead()).noDependents("case")).message(HYPHEN_SHORTED_VERBS_MSG), NodePattern.N.withHeadRelation("case|det|advmod|amod").form(allSeparablePrefixes).withDependent("conj", NodePattern.or(NodePattern.N.pos("(PA1.*|ADJ:PRD:GRU)").noPos("PRP.*"), NodePattern.N.noPos()).and(baseWithPrefix)).message(HYPHEN_SHORTED_ADJ_MSG)).directlyBefore(cc).andNot(directlyBeforeHyphen).correct(NodeCorrector.insertAfter(NodePointer.anchor(), "-")), NodePattern.or(CommonPatterns.lowercasedHasPos("VER:IMP:SIN.*").andNot(NodePattern.N.directlyBefore(NodePattern.N.form("/"))).noPos("SUB.*"), NodePattern.N.form(".+(e|s|ens?|er|es)").noPos("SUB.*INF"), NodePattern.N.pos(predicativeAdj)).markAs("FirstPrefix").directlyBefore(cc.markAs("CC")).withDependent("conj", NodePattern.or(NodePattern.N.pos("SUB.*"), NodePattern.N.noPos().andNot(CommonPatterns.lowercasedHasPos("ADJ.*"))).directlyAfter(NodePattern.N.alreadyMarkedAs("CC")).and((node, match) -> {
            Node firstPrefix = match.getMarkedNode("FirstPrefix");
            for (int i = node.form().length() - 1; i > 1; --i) {
                String lastPartInCompound = StringTools.uppercaseFirstChar((String)node.lowForm().substring(i));
                TreeSupport support = node.tree().treeSupport();
                if (!support.tagToken(lastPartInCompound).hasPos("SUB.*")) continue;
                String lowercasedLastPartInCompound = lastPartInCompound.toLowerCase(Locale.ROOT);
                String newNoun = StringTools.uppercaseFirstChar((String)(firstPrefix.form() + lowercasedLastPartInCompound));
                String prefixNoLinkingElement = firstPrefix.form().replaceAll("(e|s|ens?|er|es)$", "");
                String firstPartInCompound = node.form().substring(lastPartInCompound.length());
                if (!support.isAcceptedBySpellchecker(newNoun) || firstPrefix.lowForm().endsWith(lowercasedLastPartInCompound) || firstPrefix.lowForm().startsWith(firstPartInCompound.toLowerCase(Locale.ROOT)) || node.hasForm(".*spezifisch") || node.lowForm().equals(firstPrefix.lowForm()) || (!support.tagToken(firstPrefix.lowForm()).hasPos("ADJ:PRD:GRU|VER:IMP.*") || support.tagToken(firstPrefix.form()).hasPos("SUB.*")) && (!support.isAcceptedBySpellchecker(prefixNoLinkingElement) || !support.tagToken(prefixNoLinkingElement).hasPos("SUB.*") || !firstPrefix.hasPos("SUB:GEN:SIN.*") || firstPrefix.hasPos("SUB.*PLU.*"))) continue;
                return match.withCorrector(NodeCorrector.insertAfter(firstPrefix, "-").join(CommonPatterns.capitalizeNode(firstPrefix))).withMessage(HYPHEN_SHORTED_NOUNS_MSG);
            }
            return null;
        })), NodePattern.N.form(firstPart).markAs("Start").andOr(SpellingRules.noun, NodePattern.N.noPos()).andOr(NodePattern.N.withDependent("conj", secondPartPosSub.afterHead().noDependents("det(:poss)?")), NodePattern.N.beforeHead().withHead("compound|amod", secondPartPosSub.noDependents("det(:poss)?", NodePattern.N.after("Start")))).markAs("FirstPrefix").and((node, match) -> match.withCorrector(NodeCorrector.insertAfter(node, "-").join(CommonPatterns.capitalizeNode(node))).withMessage(HYPHEN_SHORTED_NOUNS_MSG)).andNot(directlyBeforeHyphen).noDependents("compound").noLabel("GEO_POLITICAL_ENTITY"), NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound|advmod|root|compound:prt|xcomp|mark").markAs("FirstPrefix").noDependents("cop").andOr(NodePattern.or(NodePattern.N.withDependent("compound", vorher.withDependent("flat|conj", nachher.noDependents("det"))), NodePattern.N.withDependent("advmod", vorher.directlyBefore(nachher)), NodePattern.N.withDependent("amod", nachher.withDependent("advmod", vorher))).message(HYPHEN_CAPITALIZE_MSG).correct(NodeCorrector.replaceNodes(NodePointer.marked("Vorher"), NodePointer.anchor(), m -> List.of("Vorher-Nachher-" + StringTools.uppercaseFirstChar((String)m.anchor().form())))), NodePattern.N.withDependent("compound", vorher.withDependent("flat|conj", nachher.withDependent("det")).andNot(beforeHyphen)).correct(NodeCorrector.replace(NodePointer.marked("Vorher"), "Vorher-").join(NodeCorrector.replaceNodes(NodePointer.marked("Nachher"), NodePointer.anchor(), m -> List.of("Nachher-" + StringTools.uppercaseFirstChar((String)m.anchor().form()))))).message(HYPHEN_CAPITALIZE_MSG), NodePattern.N.withDependent("compound", hin.withDependent("conj", NodePattern.N.form("R\u00fcck").markAs("Rueck")).andNot(beforeHyphen)).correct(NodeCorrector.replace(NodePointer.marked("Hin"), "Hin-").join(NodeCorrector.replaceNodes(NodePointer.marked("Rueck"), NodePointer.anchor(), m -> List.of("R\u00fcck" + StringTools.lowercaseFirstChar((String)m.anchor().form()))))).message(HYPHEN_SHORTED_NOUNS_MSG), NodePattern.or(NodePattern.N.form(allSeparablePrefixes).andNot(beforeHyphen), NodePattern.N.formCaseSensitive(allSeparablePrefixes).and(beforeHyphen)).andOr(NodePattern.N.withDependent("conj", baseWithPrefix.noPos("VER:EIZ.*").andOr(insertHyphenBeforeFirstPrefixInCompoundVerb, NodePattern.N.noPos("(PRO|PA[12])(.*)").withDependent("cc", NodePattern.N.directlyBeforeHead()).andOr(NodePattern.N.withHead("conj", NodePattern.N.withDependent("det(:poss)?|case")), NodePattern.N.noPos("(ADV|PRP|KON).*").noPos("VER(.*NON|:INF).*").noPos(predicativeAdj).noDependents("det(:poss)?|case")).markAs("Compound").and((node, match) -> {
            Node firstPrefix = match.getMarkedNode("FirstPrefix");
            String capitalizedPrefix = StringTools.uppercaseFirstChar((String)firstPrefix.form());
            Object replacement = beforeHyphen.matches(firstPrefix) ? capitalizedPrefix : capitalizedPrefix + "-";
            return match.withCorrector(CommonPatterns.capitalizeNode(node).join(NodeCorrector.replace(firstPrefix, new String[]{replacement})));
        }).message(HYPHEN_SHORTED_NOUNS_MSG))), NodePattern.N.withHead("compound:prt", baseWithPrefix.and(insertHyphenBeforeFirstPrefixInCompoundVerb))).andNot(NodePattern.ROOT.noDependents("nsubj.*|expl").andNot(withDependentsDetCaseAmod))).noLabel("LOCATION|ORGANIZATION"));
    }

    private static NodePattern hyphenRequiringCompound() {
        String msgSpellingTogether = "Schreiben Sie beide W\u00f6rter zusammen";
        return NodePattern.or(NodePattern.or(WordSeparation.twoWordCompoundNounWithHyphenBothCapitalized(), WordSeparation.fourWordCompoundNounPattern(), NodePattern.or(WordSeparation.threeWordCompoundWithHyphen(), WordSeparation.threeWordCompoundWithUnitsAndHyphens(), WordSeparation.threeWordCompoundWithCurrencyOrPercentAndHyphens()).andNot(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_NODE).directlyAfter(CommonPatterns.HYPHEN_NODE)).and(WordSeparation.hyphenateThreeCompoundParts()), NodePattern.N.withHead("nummod", NodePattern.N.lemma(".+(takt|intervall|rhythmus)")).directlyBeforeHead().noPos().and((node, match) -> match.withCorrector(CommonPatterns.hyphenateNeighbors(node, node.neighbor(1)))), NodePattern.N.inFormSequence(0, "rund", "um", "die", "Uhr").markAs("Start").withNeighbor(3, NodePattern.N.directlyBeforeHead().withHead("nmod", SpellingRules.noun.correct(NodeCorrector.replaceNodes(NodePointer.marked("Start"), NodePointer.anchor(), m -> List.of("Rund-um-die-Uhr-" + StringTools.uppercaseFirstChar((String)m.anchor().form()))))))).message(HYPHEN_MSG), NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound").form("Teilers?").withDependent("dep|det|nummod", NodePattern.N.pos("ART.*")).andOr(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("nummod").noForm(".*,.*").andOr(NodePattern.N.pos("ZAL|ART.*").message(msgSpellingTogether), NodePattern.N.message(HYPHEN_MSG))), NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("det").form("ein").message(msgSpellingTogether))).and((teiler, match) -> {
            Node numeral = teiler.neighbor(-1);
            String numeralForm = numeral.form();
            String replacement = numeral.hasPos("ZAL") || numeral.hasForm("ein") ? StringTools.uppercaseFirstChar((String)numeralForm) + teiler.lowForm() : numeralForm + "-" + teiler.form();
            return match.withCorrector(NodeCorrector.replaceNodes(numeral, teiler, replacement));
        }), NodePattern.N.inFormSequence(0, "Gef\u00e4llt", "mir").withNeighbor(1, NodePattern.N.markAs("Mir")).withHead(NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound|root").directlyAfter(CommonPatterns.skipBack(GermanTreePatterns.closingQuotation, NodePattern.N.alreadyMarkedAs("Mir")))).andOr(NodePattern.N.directlyAfter(GermanTreePatterns.openingQuotation).withNeighbor(2, GermanTreePatterns.closingQuotation.and((node, match) -> match.withCorrector(CommonPatterns.hyphenateNeighbors(node, node.neighbor(1))).withMessage(MISSING_HYPHEN_MSG))), NodePattern.custom((node, match) -> {
            String secondNeighbor = node.neighbor(2).form();
            Pair<Character, Character> quotes = GermanTreePatterns.primaryQuotes(node);
            String replacement = quotes.getFirst() + "Gef\u00e4llt mir" + quotes.getSecond() + "-" + secondNeighbor;
            return match.withCorrector(NodeCorrector.replaceNodes(node, node.neighbor(2), replacement)).withMessage("F\u00fcgen Sie einen Bindestrich ein und setzen Sie \u201eGef\u00e4llt mir\u201c in Anf\u00fchrungszeichen, um es als spezifischen Text zu kennzeichnen");
        })));
    }

    private static NodePattern threeWordCompoundWithCurrencyOrPercentAndHyphens() {
        NodePattern markNummodStart = NodePattern.N.markAs("Nummod").includeIntoReport().markAs("Start");
        return currencyOrPercent.includeIntoReport().markAs("Middle").noDependents("punct", CommonPatterns.HYPHEN_LIKE_NODE.label("MISC")).noDependents("case").andOr(NodePattern.N.directlyBeforeHead().withHead("compound", SpellingRules.noun.includeIntoReport().markAs("End")).withDependent("nummod", markNummodStart.withOptionalDependent("punct", CommonPatterns.HYPHEN_LIKE_NODE.directlyAfterHead())), NodePattern.N.withDependent("nummod", markNummodStart.directlyBeforeHead()).withDependent("flat|appos", NodePattern.N.markAs("Flat").directlyAfterHead().noForm("[$\u00a3\u20ac\u00a5\u20bd]").includeIntoReport().markAs("End")).andOr(NodePattern.N.withDependent("det"), NodePattern.markedNodeMatches("Flat", NodePattern.N.withDependent("det"))));
    }

    private static NodePattern threeWordCompoundWithUnitsAndHyphens() {
        NodePattern withDetOrAmod = NodePattern.N.withDependent("det(:poss)?|amod");
        NodePattern withBeimOrIm = NodePattern.N.withDependent("case", NodePattern.N.form("beim?|i[nm]"));
        return NodePattern.or(NodePattern.N.form("liter|m?l").directlyBefore(CommonPatterns.skipForward(CommonPatterns.HYPHEN_LIKE_NODE, NodePattern.N.lemma(".*(flasche|motor|topf|kanister|eimer|tank|krug|becher|beh\u00e4lter|rucksack|k\u00fchler|kanne|fass|schrank|karaffe|tasse|wanne|getr\u00e4nkekarton|aquarium|form|box|kocher|staubsauger|presse|kompressor|koffer|kasserolle|tasche|tonne|bidon|pool|bad|teich|speicher|bottich|hub(raum|volumen))").markAs("End"))), NodePattern.N.form("Kilo|k?g").directlyBefore(CommonPatterns.skipForward(CommonPatterns.HYPHEN_LIKE_NODE, NodePattern.N.lemma(".*(schale|s[a\u00e4]ck(chen)?|becher|pa(ket|ckung)|trommel|beutel|t\u00fcte|dose|glas|karton|kiste|schachtel|box)").markAs("End"))), NodePattern.N.form("(Kilo)?Meter|m").directlyBefore(CommonPatterns.skipForward(CommonPatterns.HYPHEN_LIKE_NODE, NodePattern.N.lemma(".*(fl\u00e4che|brett|bau)").markAs("End"))), NodePattern.N.form("Tonnen|t").directlyBefore(CommonPatterns.skipForward(CommonPatterns.HYPHEN_LIKE_NODE, NodePattern.N.lemma("Lkw").markAs("End"))), NodePattern.N.form("Zoll").directlyBefore(CommonPatterns.skipForward(CommonPatterns.HYPHEN_LIKE_NODE, NodePattern.N.lemma(".*(rad|reifen|bildschirm|display|monitor|fernseher|laptop|handy|phone|tablett?|leinwand|pergament|klinge)").markAs("End"))), SemanticRules.timeUnit.andOr(NodePattern.N.directlyBeforeHead().withHead("nmod|compound", NodePattern.N.withHead("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.pos("VER.*")).markAs("End").andOr(withBeimOrIm, withDetOrAmod, NodePattern.N.withDependent("nmod", NodePattern.N.lemma("kein")))).noDependents("case"), NodePattern.N.withDependent("appos", NodePattern.N.directlyAfterHead().markAs("End")).andOr(withBeimOrIm, withDetOrAmod))).markAs("Middle").withDependent("nummod", NodePattern.N.markAs("Start").directlyBefore(CommonPatterns.skipForward(CommonPatterns.HYPHEN_LIKE_NODE, NodePattern.N.alreadyMarkedAs("Middle"))).andNot(NodePattern.N.withDependent("advmod", NodePattern.N.pos("PRP.*"))));
    }

    private static NodePattern threeWordCompoundWithHyphen() {
        return NodePattern.or(NodePattern.N.inFormSequence(1, "Erste", "Hilfe").withNeighbor(-1, NodePattern.N.markAs("Start")).directlyBefore(wordsMakeCompoundWithErsteHilfe.markAs("End")), NodePattern.N.form("Initializr").directlyAfter(CommonPatterns.skipBack(CommonPatterns.HYPHEN_LIKE_NODE, NodePattern.N.form("Spring").markAs("Start"))).directlyBefore(CommonPatterns.skipForward(CommonPatterns.HYPHEN_LIKE_NODE, SpellingRules.noun.withHead(NodePattern.N.alreadyMarkedAs("Start")).markAs("End"))), NodePattern.N.form("Ort|hoc").directlyAfter(CommonPatterns.skipBack(CommonPatterns.HYPHEN_LIKE_NODE, NodePattern.N.form("vor|ad").markAs("Start"))).andOr(NodePattern.N.directlyBeforeHead().withHead("compound|nmod", NodePattern.N.pos("SUB.*").markAs("End")), NodePattern.N.directlyBefore(NodePattern.N.pos("SUB.*").markAs("End")).noHeadRelation("obl|obj")), NodePattern.N.form("Off").directlyAfter(CommonPatterns.skipBack(NodePattern.N.form("/"), NodePattern.N.form("on").markAs("Start"))).directlyBefore(CommonPatterns.skipForward(CommonPatterns.HYPHEN_LIKE_NODE, SpellingRules.noun.markAs("End").withDependent("compound", NodePattern.N.alreadyMarkedAs("Start")))), NodePattern.N.inFormSequence(1, "Pay", "per").withNeighbor(-1, NodePattern.N.markAs("Start")).withNeighbor(1, NodePattern.or(SpellingRules.noun, GermanTreePatterns.englishWord).markAs("End").withHead("nmod|flat|appos", NodePattern.N.alreadyMarkedAs("Start"))), NodePattern.N.inFormSequence(1, "Public", "private", "Partnerships?").withNeighbor(-1, NodePattern.N.markAs("Start")).withNeighbor(1, NodePattern.N.markAs("End")), SpellingRules.noun.markAs("Middle").andOr(NodePattern.N.withDependent("appos", SpellingRules.noun.directlyAfterHead().markAs("End").andNot(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE)).noDependents("flat")).and(withDependentsDetCaseAmod).noDependents("conj").andNot(NodePattern.or(NodePattern.N.lemma("(Kilo)?(gramm|meter)|Liter|Tonne|Zoll|(Zenti|Quadrat)?meter|Meile|Prozent|Paar"), SemanticRules.timeUnit, SemanticRules.currencyName)).andNot(NodePattern.or(NodePattern.N.inFormSequence(0, "Stimmen", "(Mehr|Minder)heit"), NodePattern.N.inFormSequence(0, "Knoten", ".*Geschwindigkeit"))), NodePattern.N.directlyBeforeHead().withHead("compound", SpellingRules.noun.markAs("End").and(withDependentsDetCaseAmod))).withDependent("nummod", NodePattern.N.noDependents(NodePattern.N.afterHead().andNot(CommonPatterns.HYPHEN_LIKE_NODE)).markAs("Start")));
    }

    private static NodeMatcher hyphenateThreeCompoundParts() {
        return (middleElement, match) -> {
            Node start = match.getMarkedNode("Start");
            Node end = match.getMarkedNode("End");
            String capitalizedEnd = StringTools.uppercaseFirstChar((String)end.form());
            if (middleElement.hasForm(gaenge) || middleElement.hasForm("Klassen")) {
                String spelledNumber = Objects.requireNonNull(SpellingRules.spellOut(Integer.parseInt(start.form())));
                if (middleElement.hasForm(gaenge)) {
                    String replacement = StringTools.uppercaseFirstChar((String)spelledNumber) + "-" + middleElement.form() + "-" + end.form();
                    match = match.withCorrector(NodeCorrector.replaceNodes(start, end, replacement));
                }
                return match.withCorrector(WordSeparation.numberToWordAndJoinNodes(middleElement, start, end, spelledNumber));
            }
            String middleForm = middleElement.tree().treeSupport().synthesize(middleElement.form(), middleElement.lemmaReadings().stream().findFirst().orElse(middleElement.form()), "SUB.*", "SUB:NOM:PLU.*").stream().findFirst().orElse(null);
            if (middleForm == null || middleForm.matches("[Oo]rte|Prozente|Privaten|Kilos|[Gg]os|Hilfen")) {
                middleForm = middleElement.form();
            }
            List<String> middleElements = middleElement.hasForm("\u20ac") ? List.of("Euro") : (middleElement.hasForm("%") ? List.of("%", "Prozent") : List.of(StringTools.uppercaseFirstChar((String)middleForm)));
            for (String middle : middleElements) {
                String modifiedForm = WordSeparation.constructModifiedForm(start, middle, capitalizedEnd);
                match = match.withCorrectors(List.of(NodeCorrector.replaceNodes(start, end, modifiedForm)));
            }
            return match;
        };
    }

    private static NodeCorrector numberToWordAndJoinNodes(Node middleElement, Node start, Node end, String spelledNumber) {
        return NodeCorrector.replaceNodes(start, end, StringTools.uppercaseFirstChar((String)spelledNumber) + middleElement.lowForm() + end.lowForm());
    }

    private static NodePattern twoWordCompoundNounWithHyphenBothCapitalized() {
        return NodePattern.or(NodePattern.or(NodePattern.N.form("Netflix|Insta(gram)?|Threads|Spotify|Twitter|WhatsApp|Facebook|YouTube|TikTok|Snapchat|Twitch|Vimeo|SoundCloud|Pinterest|Reddit|Clubhouse|Telegram|Discord|BeReal|Tumblr"), NodePattern.N.formCaseSensitive("X").directlyBefore(NodePattern.or(NodePattern.N.lemma("Kanal|Konto|Video|Story|Beitrag|Umfrage|Bild|Foto|.*Nachricht|Kommentar"), NodePattern.N.form("Stories|Posts?")))).andOr(withDependentsDetCaseAmod, NodePattern.N.withDependent("nummod")).withDependent("flat|appos", SpellingRules.noun.directlyAfterHead()), nonstopFlugOrKino, rabattCode, masterBachelorCompound, NodePattern.N.form("[0-9]+(er|s?tel)").directlyBeforeHead().withHead("nummod|amod", SpellingRules.noun.noForm("Jahren?"))).and((node, match) -> {
            String replacement = StringTools.uppercaseFirstChar((String)(node.form() + "-" + StringTools.uppercaseFirstChar((String)node.neighbor(1).form())));
            return match.withCorrector(NodeCorrector.replaceNodes(node, node.neighbor(1), replacement));
        });
    }

    private static String constructModifiedForm(Node start, String middleElement, String capitalizedEnd) {
        String capitalizedStart = StringTools.uppercaseFirstChar((String)start.form());
        String middle = lowerCaseMiddleCompoundParts.contains(middleElement.toLowerCase(Locale.ROOT)) ? StringTools.lowercaseFirstChar((String)middleElement) : StringTools.uppercaseFirstChar((String)middleElement);
        return capitalizedStart + "-" + middle + "-" + capitalizedEnd;
    }

    private static NodePattern imVorhinein() {
        return NodePattern.N.inFormSequence(1, "im", "vor|nach", "hinein").message("Schreiben Sie die Substantive \u201eVorhinein\u201c und \u201eNachhinein\u201c zusammen").and((node, match) -> match.withCorrector(NodeCorrector.replaceNodes(node, node.neighbor(1), StringTools.uppercaseFirstChar((String)node.form()) + "hinein")));
    }

    private static NodePattern pronomenSeparation() {
        NodePattern concatDerSelbe = NodePattern.N.correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), m -> List.of(m.anchor().neighbor(-1).lowForm() + m.anchor().lowForm())));
        String selbFlexion = "selb(en)?";
        return NodePattern.or(NodePattern.N.form("selben?").directlyAfter(NodePattern.N.lemma("der")).and(concatDerSelbe).andOptionally(NodePattern.or(NodePattern.N.withHead(NodePattern.N.noHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound|root|det")).correct(NodeCorrector.regexReplace(selbFlexion, "Gleich$1")), NodePattern.N.noHeadRelation("conj").noDependents("det").correct(NodeCorrector.regexReplace(selbFlexion, "gleich$1")))).message("Meinen Sie das Demonstrativpronomen \u201ederselbe\u201c oder das Adjektiv \u201egleich\u201c?"), NodePattern.N.form("([smd]ein|ihr)es|(unsere?|unsere)s").withHead("det:poss", NodePattern.N.form("gleichen")).directlyBeforeHead().message("Dieses Pronomen wird zusammengeschrieben").and(WordSeparation.joinWithNextNode()));
    }

    private static NodePattern dankeSchoen() {
        Function<NodeMatch, List<String>> compound = m -> List.of(StringTools.uppercaseFirstChar((String)(m.anchor().form() + "sch\u00f6n")));
        return NodePattern.or(NodePattern.N.form("danke|bitte").withDependent("advmod", NodePattern.N.form("sch\u00f6n").directlyAfterHead()).and(CommonPatterns.possiblyConj(withDependentsDetCaseAmod)).andOr(NodePattern.N.form("danke").message("Das Nomen \u201eDankesch\u00f6n\u201c wird zusammengeschrieben"), NodePattern.N.message("Das Nomen \u201eBittesch\u00f6n\u201c wird zusammengeschrieben")).andOr(NodePattern.N.directlyAfter(GermanTreePatterns.openingQuotation).directlyBefore(NodePattern.N.directlyBefore(GermanTreePatterns.closingQuotation)).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.neighbor(2), compound)), NodePattern.N.correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), compound))), NodePattern.N.form("Danke(sch\u00f6n|sehr)").andNot(withDependentsDetCaseAmod).noHeadRelation("conj").andNot(GermanTreePatterns.headInQuotes).message("Bei der Danksagung schreiben Sie beide W\u00f6rter getrennt").correct(NodeCorrector.regexReplace("(.+)(sch\u00f6n|sehr)", "$1 $2")));
    }

    private static NodePattern einEntwederOder() {
        NodePattern hyphenWithSpaceAround = CommonPatterns.HYPHEN_LIKE_NODE.spaceAround();
        return NodePattern.or(NodePattern.N.form("Entweder").markAs("Start").and(withDependentsDetCaseAmod).directlyBefore(CommonPatterns.skipForward(hyphenWithSpaceAround, NodePattern.N.form("oder").markAs("End"))).message("Schreiben Sie das Nomen \u201eEntweder-oder\u201c gro\u00df und mit Bindestrich").correct(NodeCorrector.replaceNodes(NodePointer.marked("Start"), NodePointer.marked("End"), "Entweder-oder")), NodePattern.N.form("Sowohl").markAs("Start").and(withDependentsDetCaseAmod).directlyBefore(CommonPatterns.skipForward(hyphenWithSpaceAround, NodePattern.N.form("als").directlyBefore(CommonPatterns.skipForward(hyphenWithSpaceAround, NodePattern.N.form("auch").markAs("End"))))).correct(NodeCorrector.replaceNodes(NodePointer.marked("Start"), NodePointer.marked("End"), "Sowohl-als-auch")).message("Schreiben Sie das Nomen \u201eSowohl-als-auch\u201c gro\u00df und mit Bindestrich"));
    }

    private static NodePattern trotzAlledem() {
        return NodePattern.N.inFormSequence(1, "bei|trotz|nach|von|hinter|mit|aus|zu", "alle?", "dem").withNeighbor(1, NodePattern.N.noDependents("acl")).message("Schreiben Sie \u201eall(e)dem\u201c in Verbindung mit einer Pr\u00e4position zusammen").and(WordSeparation.joinWithNextNode());
    }

    private static NodePattern colorBasedVerbsPattern() {
        NodePattern verbWithColoredDependent = NodePattern.N.withNeighbor(1, NodePattern.N.withDependent("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.lemma("Bild|Papier|Ecke|Bildschirm")));
        return NodePattern.or(WordSeparation.colorBasedVerbs("schwarz", "fahren|arbeiten|gehen|h\u00f6ren|kopieren|brennen|schlachten", "au\u00dferhalb legaler ethischer Grenzen handeln"), WordSeparation.colorBasedVerbs("wei(\u00df|ss)", "waschen", "sich von einer Schuld befreien"), NodePattern.or(WordSeparation.colorBasedVerbs("schwarz", "sehen|malen", "etwas pessimistisch erwarten"), WordSeparation.colorBasedVerbs("rot", "sehen", "keinen Ausweg sehen"), WordSeparation.colorBasedVerbs("blau", "machen", "schw\u00e4nzen")).andNot(verbWithColoredDependent));
    }

    private static NodePattern bescheidVerbs() {
        NodePattern withDependentNsubj = NodePattern.N.withDependent("nsubj(:pass)?");
        return NodePattern.N.form("bescheid.{5,10}").andOr(withDependentNsubj, NodePattern.or(NodePattern.ROOT, NodePattern.N.withHeadRelation("parataxis")).andNot(withDependentNsubj.andOr(CommonPatterns.firstChildPhrase, CommonPatterns.lastWord)), NodePattern.N.noDependents()).message("\u201eBescheid\u201c wird in Verbindungen immer gro\u00df und getrennt geschrieben").and((node, match) -> {
            String verb = node.form().substring(8);
            TreeSupport support = node.tree().treeSupport();
            if (!support.tagToken(verb).hasPos("VER.*")) {
                return null;
            }
            String verbWithoutZu = verb.substring(2);
            String replacement = support.tagToken(verb).form().startsWith("zu") && support.tagToken(verbWithoutZu).hasPos("VER.*") ? "Bescheid zu " + verbWithoutZu : "Bescheid " + verb;
            return match.withCorrector(NodeCorrector.replace(node, replacement));
        });
    }

    private static NodePattern colorBasedVerbs(String color, String verb, String msg) {
        return NodePattern.N.form(color).markAs("Start").directlyBefore(CommonPatterns.skipForward(NodePattern.N.form("zu"), NodePattern.N.lemma(verb).markAs("End").andNot(NodePattern.N.directlyAfter(NodePattern.N.alreadyMarkedAs("Start")).withHeadRelation("root").noPos(".*PA[12].*").withDependent("nsubj", NodePattern.N.afterHead())))).noDependents().noHeadRelation("nsubj").noLabel("PERSON").andNot(NodePattern.N.withHead("appos", NodePattern.N.lemma(".*Farbe"))).andNot(NodePattern.N.withHead("conj", NodePattern.N.form("((dunkel|hell)?(beige|blau|(kupfer)?(braun|rot)|gelb|grau|gr(\u00fc|ue)n|lila|orange|rosa)?|(kohl|tief)?schwarz|wei(\u00df|ss)|golden|silbern)"))).message("Im Sinne von \u201e" + msg + "\u201c schreiben Sie das Verb zusammen").and((node, match) -> {
            Node end = match.getMarkedNode("End");
            String replacement = node.neighbor(1).hasForm("zu") ? node.form() + "zu" + end.lowForm() : node.form() + end.lowForm();
            return match.withCorrector(NodeCorrector.replaceNodes(node, end, replacement));
        });
    }

    private static NodePattern desWeiteren() {
        return NodePattern.N.form("desweitere?n").message("Das Wort \u201eWeiteren\u201c wird im Ausdruck \u201edes Weiteren\u201c gro\u00df- und getrenntgeschrieben").correct(NodeCorrector.replace("des Weiteren"));
    }

    private static NodePattern vornHerein() {
        NodePattern afterVon = NodePattern.N.directlyAfter(NodePattern.N.form("von"));
        return NodePattern.or(NodePattern.N.inFormSequence(0, "vorne?", "herein").and(afterVon).message("Das Wort \u201evorn(e)herein\u201c im Ausdruck \u201evon vorn(e)herein\u201c wird zusammengeschrieben").and(WordSeparation.joinWithNextNode()).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), " Anfang an")), NodePattern.N.form("vorne?herein").withHeadRelation("advmod").andNot(afterVon).correct(NodeCorrector.regexReplace("(.*)herein", "$1 herein")).message("Meinten Sie das Adverb \u201evorn(e)\u201c und das Verbpr\u00e4fix \u201eherein\u201c?"));
    }

    private static NodePattern infolgedessen() {
        NodePattern afterComma = NodePattern.N.directlyAfter(CommonPatterns.comma);
        NodePattern withReferenceToNoun = NodePattern.N.withHead("acl", NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound"));
        NodePattern inFolgeDessenInSequence = NodePattern.N.inFormSequence(0, "in", "folge", "dessen");
        return NodePattern.or(NodePattern.or(NodePattern.N.form("infolgedessen").and(afterComma).withHead("advmod", withReferenceToNoun).correct(NodeCorrector.replace("infolge dessen")), NodePattern.or(NodePattern.N.inFormSequence(0, "infolge", "dessen").andNot(afterComma.withNeighbor(1, NodePattern.N.withHead("obl", withReferenceToNoun))), inFolgeDessenInSequence.and(afterComma.withNeighbor(1, NodePattern.N.withHead("obl", withReferenceToNoun)))).and(WordSeparation.joinWithNextNodeBothLowForm())).message("Schreiben Sie \u201einfolge dessen\u201c getrennt, wenn sich \u201edessen\u201c auf ein Substantiv bezieht"), inFolgeDessenInSequence.message("Das Adverb \u201einfolgedessen\u201c wird zusammengeschrieben, wenn es im Sinne von \u201edeshalb\u201c verwendet wird").and(WordSeparation.joinThreeNodes())).andNot(CommonPatterns.insideQuotes);
    }

    private static NodePattern irgendCompound() {
        return NodePattern.N.form("irgend").directlyBefore(NodePattern.N.form("(et)?was|jemand(e[smn])?|ein(e[rsnm]?|s|mal)?|(wer|wen|wem|wann|wie|wo(hin|her)?|welch)(e[rnsm]?)?").markAs("End")).message("Das Wort \u201e$_$End\u201c wird zusammengeschrieben").and(WordSeparation.joinWithNextNodeBothLowForm());
    }

    private static NodePattern wieSoAdverb() {
        NodePattern withQuestionLikePunctuation = NodePattern.N.withDependent("punct", NodePattern.or(CommonPatterns.ellipsis, NodePattern.N.form("[!?].*")));
        return NodePattern.or(NodePattern.N.inFormSequence(0, "wie", "so").andOr(NodePattern.or(CommonPatterns.possiblySkipDown("nsubj", withQuestionLikePunctuation), NodePattern.N.withHead("advmod", withQuestionLikePunctuation.andNot(NodePattern.N.pos("ADJ.*")))), NodePattern.N.withHead("advmod|mark", NodePattern.N.withHeadRelation("ccomp|acl")).andNot(NodePattern.N.withNeighbor(1, NodePattern.N.directlyBeforeHead().withHead("advmod", NodePattern.N.withHeadRelation("nsubj(:pass)?"))))).message("\u201eWieso\u201c im Sinne von \u201ewarum\u201c wird zusammengeschrieben").and(WordSeparation.joinWithNextNode()), NodePattern.N.form("wieso").directlyBeforeHead().withHead("advmod", NodePattern.N.withHeadRelation("advmod").andNot(NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("nsubj(:pass)?")))).message("\u201eWie so\u201c wird getrennt geschrieben, wenn es nicht als Fragewort verwendet wird").correct(NodeCorrector.replace("wie so")));
    }

    private static NodePattern jeUmSo() {
        return NodePattern.N.inFormSequence(0, "um", "so").withNeighbor(2, NodePattern.N.pos("(ADJ.*|ADV:MOD)").andNot(NodePattern.N.withHead("advmod|amod|obj|advcl", CommonPatterns.possiblySkipUp("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.or(NodePattern.N.pos("VER:EIZ:SFT"), NodePattern.N.pos("VER:INF:.*").directlyAfter(NodePattern.N.form("zu"))))))).message("Die Konjunktion \u201eumso\u201c wird zusammengeschrieben").and(WordSeparation.joinWithNextNode());
    }

    private static NodePattern lebenLang() {
        return NodePattern.or(NodePattern.N.form("lebenlang").withDependent("det(:poss)?").message("\u201eLeben lang\u201c wird getrennt geschrieben"), Capitalization.zeitlang.withDependent("amod|det", NodePattern.N.pos("ADJ.*")).message("\u201eZeit lang\u201c wird nach Adjektiven getrennt geschrieben"), NodePattern.N.formCaseSensitive("zeitlang").withDependent("det", NodePattern.or(NodePattern.N.pos("ART:IND.*"), NodePattern.N.form("ne"))).message("Die empfohlene Schreibung ist \u201eZeit lang\u201c")).and((node, match) -> {
            String noun = StringTools.uppercaseFirstChar((String)node.form().substring(0, node.form().length() - 4));
            return match.withCorrector(NodeCorrector.replace(node, noun + " lang"));
        });
    }

    private static NodePattern vielMehr() {
        return NodePattern.or(NodePattern.N.form("vielmehr").andOr(NodePattern.ROOT, NodePattern.N.directlyBefore(NodePattern.N.form("als")), NodePattern.N.withDependent("advmod")).andNot(NodePattern.N.after(NodePattern.N.form("sondern"))).message("Vor dem Komparativ \u201emehr\u201c wird das Gradadverb \u201eviel\u201c getrennt geschrieben").correct(NodeCorrector.replace("viel mehr")), NodePattern.N.inFormSequence(0, "viel", "mehr").andOr(CommonPatterns.afterSkipping(NodePattern.N.form("sondern"), CommonPatterns.comma).andOr(NodePattern.N.withNeighbor(1, NodePattern.N.withHead("advmod", NodePattern.N.withHeadRelation("conj").pos("VER.*"))), NodePattern.N.withNeighbor(2, CommonPatterns.possiblySkipUp("det(:poss)?|case|amod", NodePattern.N.pos("(SUB|PRO|ADJ|EIG).*").withHead("nsubj(:pass)?|appos|conj", NodePattern.not(NodePattern.N.directlyAfter(NodePattern.N.inFormSequence(1, "viel", "mehr")))).andNot(NodePattern.N.before(NodePattern.N.form("als")))))), NodePattern.N.withNeighbor(2, NodePattern.N.withHeadRelation("det|case").noForm("als")).and(NodePattern.N.inPhrase(NodePattern.ROOT.withPhraseEnd(NodePattern.N.form("[.!?:;].*")))).andNot(NodePattern.N.withNeighbor(1, NodePattern.N.withHeadRelation("obj|nsubj"))).andNot(NodePattern.N.after(NodePattern.N.form("weniger")))).message("Das Adverb sowie die Konjunktion \u201evielmehr\u201c werden zusammengeschrieben").and(WordSeparation.joinWithNextNode()));
    }

    private static NodePattern ausAnderen() {
        return NodePattern.N.inFormSequence(0, "an", "(de?re[rnms]?|der[nm])").directlyAfter(NodePattern.or(Case.accPreposition, Case.accDatPreposition, Case.datPreposition, Case.genPreposition)).andNot(NodePattern.N.withHeadRelation("case").directlyAfter(NodePattern.N.withHeadRelation("case"))).andNot(NodePattern.N.withNeighbor(-1, NodePattern.N.form("um").withHead("mark", NodePattern.N.withHeadRelation("advcl")))).message("Meinten Sie das Pronomen \u201eandere\u201c?").and(WordSeparation.joinWithNextNode());
    }

    private static NodePattern anhand() {
        return NodePattern.N.inFormSequence(0, "an", "hand").withNeighbor(2, vonOrGen).message("Die Pr\u00e4position \u201eanhand\u201c wird zusammengeschrieben").and(WordSeparation.joinWithNextNodeBothLowForm());
    }

    private static NodePattern hinZu() {
        return NodePattern.N.form("hinzu").andOr(NodePattern.N.beforeHead().withHead("case|advmod", NodePattern.N.pos("(SUB|PRO:PER).*")), NodePattern.N.directlyAfter(NodePattern.N.pos("PRO:REF.*").withDependent("case", NodePattern.N.directlyBeforeHead().form("vor")))).noHeadRelation("compound:prt").and(SpellingRules.typoReplacement("hin zu"));
    }

    private static NodePattern colorCompounds() {
        return NodePattern.N.inFormSequence(0, "((dunkel|hell)?(beige|blau|(kupfer)?(braun|rot)|gelb|grau|gr(\u00fc|ue)n|lila|orange|rosa)?|(kohl|tief)?schwarz|wei(\u00df|ss)|golden|silbern)", "((dunkel|hell)?(beige|blau|(kupfer)?(braun|rot)|gelb|grau|gr(\u00fc|ue)n|lila|orange|rosa)?|(kohl|tief)?schwarz|wei(\u00df|ss)|golden|silbern)", "((dunkel|hell)?(beige|blau|(kupfer)?(braun|rot)|gelb|grau|gr(\u00fc|ue)n|lila|orange|rosa)?|(kohl|tief)?schwarz|wei(\u00df|ss)|golden|silbern)(e[rnsm]?)?|Gold|Silber").and((node, match) -> {
            Node neighbor2 = node.neighbor(2);
            String concat = neighbor2.hasHeadRelation("amod") || neighbor2.hasHeadRelation("root") && neighbor2.hasPos(predicativeAdj) ? node.form() + "-" + node.neighbor(1).form() + "-" + neighbor2.form() : StringTools.uppercaseFirstChar((String)node.form()) + "-" + StringTools.uppercaseFirstChar((String)node.neighbor(1).form()) + "-" + StringTools.uppercaseFirstChar((String)neighbor2.form());
            return match.withCorrector(NodeCorrector.replaceNodes(node, neighbor2, concat)).withMessage(MISSING_HYPHEN_MSG);
        });
    }

    private static NodePattern ebensoGenauso() {
        NodeCorrector.Relative advEndsSovielmal = NodeCorrector.regexReplace(NodePointer.neighbor(-2), "(.+)", "$1sovielmal");
        NodePattern withAdvcl = NodePattern.N.withDependent("advcl");
        NodePattern oblWithCase = NodePattern.N.withHeadRelation("obl").withDependent("case", NodePattern.N.directlyAfter(NodePattern.N.alreadyMarkedAs("So")));
        return NodePattern.N.inFormSequence(0, "eben|genau", "so").withNeighbor(1, NodePattern.N.markAs("So")).withNeighbor(1, NodePattern.or(NodePattern.N.directlyBeforeHead().withHead("advmod", NodePattern.or(NodePattern.or(NodePattern.N.pos("(ADV|ADJ).*").noForm("wie|viel(mal)?").andNot(NodePattern.N.withHeadRelation("conj|root").and(withAdvcl)), NodePattern.N.lemma("viel").pos("(PRO:IND|ADV).*").andNot(NodePattern.N.withHead("amod", CommonPatterns.possiblySkipUp("obj", withAdvcl))).andOptionally(NodePattern.N.directlyBefore(NodePattern.N.form("Mal")).correct(advEndsSovielmal.join(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.neighbor(1), ""))))).correct(NodeCorrector.regexReplace(NodePointer.neighbor(-2), "(.+)", "$1so").join(NodeCorrector.replace(NodePointer.neighbor(-1), ""))), NodePattern.N.form("vielmal").correct(advEndsSovielmal.join(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), ""))))), NodePattern.or(NodePattern.N.withNextSibling(oblWithCase.andNot(SemanticRules.timeUnit.withDependent("case", NodePattern.N.form("\u00fcber")))), NodePattern.N.withHead("advmod", oblWithCase), NodePattern.N.directlyBefore(NodePattern.N.form("leid"))).correct(NodeCorrector.regexReplace(NodePointer.neighbor(-1), "(.+)", "$1so").join(NodeCorrector.replace(NodePointer.anchor(), ""))))).andOr(NodePattern.N.form("genau").message("Im Sinne von \u201ein demselben Ma\u00dfe\u201c wird \u201egenauso\u201c zusammengeschrieben"), NodePattern.N.message("Das Adverb \u201eebenso(vielmal)\u201c wird zusammengeschrieben"));
    }

    private static NodePattern amSonsten() {
        return NodePattern.N.inFormSequence(0, "a[nm]", "sonn?sten").message("Meinten Sie \u201eansonsten\u201c?").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "ansonsten"));
    }

    private static NodePattern englishElementCompoundNoun() {
        NodePattern flatOrAppos = NodePattern.N.withHeadRelation("flat|appos");
        return NodePattern.or(NodePattern.N.inFormSequence(0, "sozial(e[rn]?)?", "Media").markAs("Sozial").andOr(NodePattern.N.withNeighbor(2, NodePattern.or(flatOrAppos, NodePattern.N.withDependent("amod", NodePattern.N.alreadyMarkedAs("Sozial")))).message(HYPHEN_MSG).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(2), m -> List.of("Social-Media-" + StringTools.uppercaseFirstChar((String)m.anchor().neighbor(2).form())))), NodePattern.N.correct(NodeCorrector.replace("Social")).message("Meinten Sie \u201eSocial Media\u201c?")), NodePattern.or(NodePattern.N.inFormSequence(0, "Landing", "Page"), NodePattern.N.inFormSequence(0, "Home", "(office|learning|schooling|sitter|shopping|trainer|run|base|plate|banking|computer|care|land|fighter|story|spun|page)s?|sitterin(nen)?|rule|dress(e[sn]?)?"), NodePattern.N.form("online")).withDependent("flat|appos", NodePattern.N.directlyAfterHead()).andOptionally(NodePattern.N.withNeighbor(1, flatOrAppos).withNeighbor(2, flatOrAppos.markAs("LastWord"))).and((node, match) -> {
            Node compoundLastWord = match.findMarkedNode("LastWord");
            Object compound = WordSeparation.makeCompoundWithNext(node);
            Node next = node.neighbor(1);
            if (compoundLastWord != null) {
                if (compound == null) {
                    compound = StringTools.uppercaseFirstChar((String)node.form()) + "-" + StringTools.uppercaseFirstChar((String)next.form());
                }
                String concat = (String)compound + "-" + node.neighbor(2).form();
                return match.withCorrector(NodeCorrector.replaceNodes(node, node.neighbor(2), concat)).withMessage("Meinten Sie \u201e" + concat + "\u201c?");
            }
            if (node.hasForm("Online") && next.hasLemma("Event|Veranstaltung|Shop")) {
                return match.withCorrector(CommonPatterns.hyphenateNeighbors(node, next)).withMessage(HYPHEN_MSG);
            }
            if (compound == null) {
                return null;
            }
            return match.withCorrector(NodeCorrector.replaceNodes(node, next, new String[]{compound})).withMessage("Meinten Sie \u201e" + (String)compound + "\u201c?");
        }));
    }

    private static NodePattern jahreLang() {
        return NodePattern.N.form("jahrelang").andOr(NodePattern.N.withDependent("nummod", NodePattern.N.directlyBeforeHead()), NodePattern.N.directlyAfter(NodePattern.or(NodePattern.N.form("([2-9]|[1-9][0-9]{1,3}|10000)|(viel|mehrer|einig|etlich|gewiss)e"), NodePattern.N.pos("ZAL"), NodePattern.N.inFormSequence(1, "ein", "Paar")).noHeadRelation("nsubj(:pass)?"))).message("Schreiben Sie \u201eJahre lang\u201c getrennt, wenn sich ein Zahlwort auf \u201eJahre\u201c bezieht").correct(NodeCorrector.replace("Jahre lang"));
    }

    private static NodePattern wirGefuehl() {
        NodeMatcher hyphenateNeighborsUpperCasePronoun = (node, match) -> match.withCorrector(NodeCorrector.replaceNodes(node, node.neighbor(1), StringTools.uppercaseFirstChar((String)node.form()) + "-" + node.neighbor(1).form()));
        return NodePattern.N.inFormSequence(0, "wir|ich", "gef\u00fchl(e?s?)?").andOr(NodePattern.N.form("ich").and(hyphenateNeighborsUpperCasePronoun).message("Die empfohlene Schreibung ist mit Bindestrich"), WordSeparation.joinWithNextNode().and(hyphenateNeighborsUpperCasePronoun).message("Schreiben Sie \u201eWirgef\u00fchl\u201c zusammen oder mit Bindestrich")).andOr(withDependentsDetCaseAmod, NodePattern.N.withNeighbor(1, withDependentsDetCaseAmod));
    }

    private static NodePattern multiKulti() {
        return NodePattern.N.form("multi").directlyBefore(CommonPatterns.skipForward(CommonPatterns.HYPHEN_LIKE_NODE, NodePattern.N.form("kulti").markAs("End"))).andOr(NodePattern.or(NodePattern.N.withHeadRelation("amod"), NodePattern.N.withHeadRelation("nsubj").withNeighbor(2, SpellingRules.noun.afterHead())).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.marked("End"), "multikulti")), NodePattern.N.correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.marked("End"), "Multikulti"))).message(WORD_IS_COMPOUND_MSG);
    }

    private static NodePattern alleNaselang() {
        return NodePattern.or(alleNaselang.and((node, match) -> match.withCorrector(NodeCorrector.rawReplace(node.startOffset(), node.neighbor(1).endOffset(), node.lowForm() + "lang"))), NodePattern.N.formCaseSensitive("Nas(en?)?lang").directlyAfter(NodePattern.N.form("alle")).and((node, match) -> match.withCorrector(NodeCorrector.rawReplace(node.textRange(), node.lowForm())))).message("Schreiben Sie \u201ealle naselang\u201c");
    }

    private static NodePattern germanizedAnglicismsWithHyphenPattern() {
        return NodePattern.or(WordSeparation.germanizedAnglicismsWithHyphen("pop|make|push|stand|line|close|start|follow|check|back|sit|mash|pi(ck|n)|scale|round|trading|cover|warm|lock", "ups?"), WordSeparation.germanizedAnglicismsWithHyphen("add", "ons?"), WordSeparation.germanizedAnglicismsWithHyphen("(dri|lo)ve|(che|smo)ck|call|teach|fade|phone|tie|go|sit", "ins?"), WordSeparation.germanizedAnglicismsWithHyphen("post", "its?"), WordSeparation.germanizedAnglicismsWithHyphen("no", "gos?"), WordSeparation.germanizedAnglicismsWithHyphen("know", "hows?"), WordSeparation.germanizedAnglicismsWithHyphen("check|buy|drop", "(out|in)s?"), WordSeparation.germanizedAnglicismsWithHyphen("get", "togethers?"), WordSeparation.germanizedAnglicismsWithHyphen("making|best", "ofs?"), WordSeparation.germanizedAnglicismsWithHyphen("must", "haves?"), WordSeparation.germanizedAnglicismsWithHyphen("burn|bore|fade|blow|chill|(qu|s)ick|(act|com|s)ing|sell|flame|pay|log|work|time|opt", "outs?"), WordSeparation.germanizedAnglicismsWithHyphen("kick|cool|come|pull|button", "downs?"), WordSeparation.germanizedAnglicismsWithHyphen("fly|take", "overs?"), WordSeparation.germanizedAnglicismsWithHyphen("break", "evens?"), WordSeparation.germanizedAnglicismsWithHyphen("fly|swing", "bys?"), WordSeparation.germanizedAnglicismsWithHyphen("give", "aways?"), WordSeparation.germanizedAnglicismsWithHyphen("kick", "backs?"), WordSeparation.germanizedAnglicismsWithHyphen("roll", "(back|out|over|up)s?"), WordSeparation.germanizedAnglicismsWithHyphen("take", "(off|out|over|away)s?"), WordSeparation.germanizedAnglicismsWithHyphen("kick|play|spin", "offs?"), WordSeparation.germanizedAnglicismsWithHyphen("log", "ins?").afterHead().withHead("flat", NodePattern.N.form("log").andNot(NodePattern.N.withHead("ob[jl]", NodePattern.N.lemma("klicken|dr\u00fccken")))).noDependents(NodePattern.N.form("to")), WordSeparation.germanizedAnglicismsWithHyphen("plug", "ins?").andNot(NodePattern.N.withHead(NodePattern.N.directlyAfter(GermanTreePatterns.openingQuotation))).andNot(NodePattern.N.directlyAfter(CommonPatterns.HYPHEN_NODE)));
    }

    private static NodePattern germanizedAnglicismsWithHyphen(String form1, String form2) {
        NodePattern nounEnd = SpellingRules.noun.directlyAfter("Middle").markAs("End");
        NodePattern markedMiddle = NodePattern.N.alreadyMarkedAs("Middle");
        NodePattern noPos = NodePattern.N.noPos();
        return NodePattern.or(NodePattern.or(NodePattern.N.form("(pop|make|push|stand|line|close)ups?|addons?"), NodePattern.N.formCaseSensitive("FollowUps?"), NodePattern.N.form("Plugins?").withHeadRelation("flat|compound|appos").andOr(NodePattern.N.directlyBeforeHead(), NodePattern.N.directlyAfterHead().andNot(NodePattern.N.withHead(NodePattern.or(NodePattern.N.label("PRODUCT"), NodePattern.N.lemma("Seite"), NodePattern.N.withHeadRelation("appos"))))), NodePattern.N.form("startups?").andNot(NodePattern.N.directlyBefore(NodePattern.or(CommonPatterns.HYPHEN_NODE, NodePattern.N.form("scripts?")))), NodePattern.N.form("checkins?").andNot(NodePattern.N.inFormSequence(2, "VCS", "-", "Checkins?")), NodePattern.N.form("checkouts?").noLabel("PRODUCT|ORGANIZATION").andNot(NodePattern.N.withHead(NodePattern.N.form("(Ak|Op)tion(en)?|Git"))).andNot(NodePattern.N.directlyBefore(NodePattern.or(CommonPatterns.HYPHEN_NODE, NodePattern.N.form("auf|feature")))).andNot(NodePattern.N.withDependent("nmod", NodePattern.or(NodePattern.N.withDependent("case", NodePattern.N.form("auf").beforeHead()), NodePattern.N.form("Repositorys?|Commits?")))).andNot(NodePattern.N.directlyAfter(NodePattern.or(NodePattern.N.form("git"), NodePattern.N.inFormSequence(1, "Self", "-")))).noDependents("case|flat|appos", NodePattern.or(GermanTreePatterns.englishWord.and(noPos), NodePattern.N.form("v?[0-9].*"))), NodePattern.N.form("((best|making)of|drivein|buy(out|in))s?")).andNot(NodePattern.N.directlyAfter(GermanTreePatterns.openingQuotation)).markAs("Start").andOptionally(NodePattern.or(NodePattern.N.withDependent("flat|appos", NodePattern.N.directlyAfterHead().and(SpellingRules.noun.markAs("End"))), NodePattern.N.directlyBefore(CommonPatterns.skipForward(CommonPatterns.HYPHEN_LIKE_NODE, SpellingRules.noun.markAs("End"))))).andOptionally(NodePattern.N.directlyAfterHead().withHead("appos", SpellingRules.noun.markAs("Prev"))).andOptionally(NodePattern.N.withDependent("compound", NodePattern.N.directlyBeforeHead().markAs("Prev"))).andNot(NodePattern.N.noDependents().withHead(GermanTreePatterns.englishWord.andNot(withDependentsDetCaseAmod))).and((start, match) -> {
            Node end = match.findMarkedNode("End");
            Node prev = match.findMarkedNode("Prev");
            String secondPart = start.lowForm().replaceFirst("(pop|make|push|stand|line|close|add|follow|plug|start|check|best|making|drive|buy)", "");
            String firstPart = StringTools.uppercaseFirstChar((String)start.lowForm().replaceFirst(secondPart, ""));
            String concat = firstPart + "-" + secondPart;
            if (prev != null) {
                match = match.withCorrector(NodeCorrector.replaceNodes(prev, start, prev.form() + "-" + concat));
                if (start.hasForm("Plugins?")) {
                    match = match.withCorrector(NodeCorrector.replaceNodes(prev, start, prev.form() + "-" + start.form()));
                }
                return match;
            }
            if (end != null) {
                match = match.withCorrector(NodeCorrector.replaceNodes(start, end, concat + "-" + end.form()));
                if (start.hasForm("Plugins?")) {
                    match = match.withCorrector(NodeCorrector.replaceNodes(start, end, start.form() + "-" + end.form()));
                }
                return match;
            }
            return match.withCorrector(NodeCorrector.replace(start, concat));
        }), NodePattern.N.form(form2).noHeadRelation("case").markAs("Middle").directlyAfter(CommonPatterns.skipBack(CommonPatterns.HYPHEN_LIKE_NODE, NodePattern.N.form(form1).andNot(NodePattern.N.directlyAfter(GermanTreePatterns.openingQuotation)).markAs("Start"))).andOr(NodePattern.markedNodeMatches("Start", NodePattern.or(NodePattern.N.withHead("compound", nounEnd), NodePattern.N.withDependent("appos|flat", NodePattern.N.directlyAfter("Middle").and(CommonPatterns.capitalizedHasPos("SUB.*")).noDependents(GermanTreePatterns.englishWord).markAs("End")).andNot(NodePattern.N.withHead("compound|nmod", NodePattern.N.withHeadRelation("obl").andOr(NodePattern.N.onlyPos("VER.*"), NodePattern.N.lemma("Symbol")))).andNot(NodePattern.N.withDependent("flat", NodePattern.or(noPos.andNot(CommonPatterns.capitalizedHasPos("SUB.*")).andNot(markedMiddle.and(noPos)), NodePattern.N.label("EVENT").directlyAfter(markedMiddle)))))).and(WordSeparation.hyphenateThreeCompoundParts()), NodePattern.markedNodeMatches("Start", NodePattern.or(NodePattern.or(NodePattern.N.withHead("appos|flat", SpellingRules.noun).directlyAfterHead(), NodePattern.N.withDependent("compound|flat", SpellingRules.noun.directlyBeforeHead()), NodePattern.N.inFormSequence(1, "Selbst", "check").withNeighbor(-1, NodePattern.N)).directlyBefore(CommonPatterns.skipForward(CommonPatterns.HYPHEN_LIKE_NODE, NodePattern.N.markAs("End"))).and((node, match) -> {
            Node end = match.getMarkedNode("End");
            String concat = node.neighbor(-1).form() + "-" + StringTools.uppercaseFirstChar((String)node.form()) + "-" + end.lowForm();
            return match.withCorrector(NodeCorrector.replaceNodes(node.neighbor(-1), end, concat));
        }), NodePattern.or(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_NODE.directlyBefore(CommonPatterns.capitalized.markAs("End"))).noFormCaseSensitive("[A-Z]{2,}").noForm("No"), withDependentsDetCaseAmod.andNot(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_NODE)).directlyBefore(NodePattern.N.markAs("End"))).and((node, match) -> {
            Node end = match.getMarkedNode("End");
            String lastPart = end.hasForm("Go") ? StringTools.uppercaseFirstChar((String)end.form()) : end.lowForm();
            return match.withCorrector(NodeCorrector.replaceNodes(node, end, StringTools.uppercaseFirstChar((String)node.form()) + "-" + lastPart));
        }))))).message(MISSING_HYPHEN_MSG);
    }

    private static NodePattern soLange() {
        NodePattern withDepAdvcl = NodePattern.N.withDependent("advcl", NodePattern.N.pos("VER.*"));
        NodePattern advcl = NodePattern.N.withHeadRelation("advcl");
        return NodePattern.or(NodePattern.N.form("solange?").andOr(NodePattern.N.withHead("advmod", NodePattern.or(advcl, withDepAdvcl, NodePattern.N.withHead("xcomp", withDepAdvcl), NodePattern.ROOT.andOr(NodePattern.not(withDepAdvcl), NodePattern.N.withDependent("advcl", NodePattern.N.pos("ADJ.*"))))), withDepAdvcl).andNot(NodePattern.N.directlyBefore(CommonPatterns.skipForward(CommonPatterns.comma, NodePattern.N.form("als")))).message("Schreiben Sie die adverbiale F\u00fcgung \u201eso lang(e)\u201c getrennt").correct(NodeCorrector.regexReplace("solang(.*)", "so lang$1")), NodePattern.N.inFormSequence(0, "so", "lange?").andOr(NodePattern.or(CommonPatterns.firstWord, NodePattern.N.directlyAfter(CommonPatterns.comma)).withNeighbor(1, NodePattern.N.withHead(advcl)), NodePattern.N.withNeighbor(1, NodePattern.N.withHead(NodePattern.N.withHeadRelation("parataxis|conj").noDependents("acl|ccomp")).noDependents("advcl"))).andNot(NodePattern.N.withNeighbor(2, NodePattern.N.form("her"))).message("Die Konjunktion sowie das Adverb \u201esolang(e)\u201c werden zusammengeschrieben").and(WordSeparation.joinWithNextNode()));
    }

    private static NodePattern denWegLaufen() {
        return NodePattern.N.lemma("weg(gehen|laufen)").withDependent("obl|det", NodePattern.N.form("de[nm]").beforeHead()).andNot(NodePattern.N.withHead("nmod", NodePattern.N.withHeadRelation("nsubj(:pass)?"))).message("In dieser Redewendung ist \u201eWeg\u201c ein Nomen und wird getrennt geschrieben").correct(NodeCorrector.regexReplace("weg(.*)", "Weg $1"));
    }

    private static NodePattern topNoun() {
        NodePattern top = NodePattern.N.formCaseSensitive("Top");
        return top.andOr(NodePattern.or(NodePattern.N.directlyBeforeHead().withHead("compound", SpellingRules.noun.andNot(CommonPatterns.lowercasedHasPos("ADJ.*"))), NodePattern.N.withDependent("appos|flat", SpellingRules.noun.directlyAfterHead())).andNot(NodePattern.N.withNeighbor(1, NodePattern.or(NodePattern.N.form("Sites"), NodePattern.N.label("ORGANIZATION")))), NodePattern.N.inFormSequence(3, "Germany", "['`\u00b4\u2019]s", "next", "Top", "Model").markAs("Gntm")).message("Schreiben Sie \u201eTop\u201c im zusammengesetzten Nomen zusammen oder mit Bindestrich. Als Adjektiv wird \u201etop\u201c kleingeschrieben.").and((node, match) -> {
            Node gntm = match.findMarkedNode("Gntm");
            String topCompound = node.form() + node.neighbor(1).lowForm();
            if (node.tree().treeSupport().tagToken(topCompound).hasPos("SUB.*")) {
                match = match.withCorrector(NodeCorrector.replaceNodes(node, node.neighbor(1), topCompound));
            }
            if (gntm == null) {
                match = match.withCorrector(CommonPatterns.hyphenateNeighbors(node, node.neighbor(1))).withCorrector(NodeCorrector.replace(node, "top"));
            }
            return match;
        });
    }

    private static NodePattern naja() {
        return NodePattern.N.form("na(ja{1,4}|gut|also|bitte|prima|super|toll|klasse|klar|und|sch\u00f6n)").withHeadRelation("discourse|dep|root|nsubj|advmod").noLabel(".*").andNot(withDependentsDetCaseAmod).andOr(NodePattern.N.form("naja").message("H\u00e4ufiger Fehler: Der Ausdruck \u201ena ja\u201c wird getrennt geschrieben"), NodePattern.N.message("Dieser Ausdruck wird getrennt geschrieben")).correct(NodeCorrector.regexReplace("na(.*)", "na $1"));
    }
}

