/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.common.Argument;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.Valence;
import ai.grazie.rules.common.ValenceParser;
import ai.grazie.rules.en.Questions;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.Tree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EnglishValences {
    static final Argument XCOMP = new Argument("xcomp", NodePattern.N.withHeadRelation("xcomp")){

        @Override
        public boolean isObligatory() {
            return true;
        }
    };
    static final Argument CCOMP = new Argument("ccomp", NodePattern.or(NodePattern.N.withHeadRelation("ccomp"), Questions.misparsedWhCcomp, NodePattern.N.afterHead().withHeadRelation("advcl").withDependent("mark|advmod", NodePattern.N.form("when"))).andNot(CommonPatterns.phraseStartsWithComma)){

        @Override
        public boolean isObligatory() {
            return true;
        }
    };
    static final Argument HOW = new Argument("how", NodePattern.N.withHeadRelation("advmod|xcomp")){

        @Override
        public boolean isObligatory() {
            return true;
        }
    };
    static final Argument BY_INANIM = new NominalArgument("by:Inanim", "by"){

        @Override
        public boolean matchesLexically(Node node) {
            Semantics.Animacy animacy = Semantics.animacy(node);
            return animacy == null || animacy == Semantics.Animacy.inanimate;
        }
    };
    private static final ValenceParser parser = new ValenceParser(new Argument[]{XCOMP, CCOMP, HOW, BY_INANIM}){

        @Override
        public Argument arg(String arg) {
            return NominalArgument.parse(arg);
        }
    };
    static final Argument OBJ = parser.arg("obj");
    private static final Map<String, List<Valence>> verbValences = parser.fromResource("en/words/verb_arg_structures.txt");
    private static final Map<String, List<Valence>> nounValences = parser.fromResource("en/words/noun_arg_structures.txt");
    static final NodePattern adjunct = NodePattern.or(NodePattern.N.lemma("time"), Semantics.timeUnits).withDependent("case", NodePattern.N.form("for"));
    static final NodePattern lacksObligatoryArguments = NodePattern.custom(n -> {
        List<Valence> valences = EnglishValences.potentialValences(n);
        return !valences.isEmpty() && valences.stream().noneMatch(as -> as.hasAllObligatoryArguments((Node)n));
    });
    private static final NodePattern possiblyPhrasalVerb = NodePattern.or(NodePattern.N.withDependent("compound:prt"), NodePattern.N.withDependent("advmod", NodePattern.N.directlyAfterHead().form("back")));
    static final NodePattern definitelyTransitive = NodePattern.or(NodePattern.custom(node -> {
        List<Valence> valences = EnglishValences.potentialValences(node);
        return !valences.isEmpty() && valences.stream().allMatch(a -> a.has("obj"));
    }), NodePattern.N.lemma("bring").withDependent("advmod", NodePattern.N.form("back")));
    static final NodePattern definitelyIntransitive = NodePattern.custom(node -> {
        List<Valence> valences = EnglishValences.potentialValences(node);
        return !valences.isEmpty() && valences.stream().noneMatch(a -> a.has("obj"));
    });
    static final NodePattern mayHaveTwoObjects = NodePattern.custom(node -> EnglishValences.potentialValences(node).stream().anyMatch(a -> a.has("obj") && a.has("iobj")));
    static final NodePattern isArgument = NodePattern.custom(node -> {
        Node head = node.head();
        if (head == null) {
            return false;
        }
        return EnglishValences.potentialValences(head).stream().anyMatch(a -> a.recognizesArgument((Node)node));
    });

    EnglishValences() {
    }

    @NotNull
    static List<Valence> valences(Node node) {
        return EnglishValences.valences(node, node.tokenReadings());
    }

    @NotNull
    static List<Valence> potentialValences(Node node) {
        return EnglishValences.valences(node, node.tagIndependently().tokenReadings());
    }

    @NotNull
    private static List<Valence> valences(Node node, List<Tree.Reading> readings) {
        if (possiblyPhrasalVerb.matches(node)) {
            return List.of();
        }
        LinkedHashSet<Valence> result2 = new LinkedHashSet<Valence>();
        boolean hasVerbPos = node.posReadings().stream().anyMatch(p -> p.startsWith("VB"));
        for (Tree.Reading reading : readings) {
            List<Valence> valences;
            String pos = reading.pos();
            if (pos == null) {
                return List.of();
            }
            if (pos.startsWith("VB")) {
                valences = verbValences.get(reading.lemma());
                if (valences == null) {
                    return List.of();
                }
                result2.addAll(valences);
            }
            if (!pos.startsWith("NN") || hasVerbPos) continue;
            valences = nounValences.get(reading.lemma());
            if (valences == null) {
                return List.of();
            }
            result2.addAll(valences);
        }
        return new ArrayList<Valence>(result2);
    }

    static boolean needsObject(Node node) {
        List<Valence> valences = EnglishValences.valences(node);
        if (valences.stream().anyMatch(as -> !as.arguments.contains(OBJ) && as.hasAllObligatoryArguments(node) && as.hasAnyArgument(node, adjunct))) {
            return false;
        }
        List withObligatory = ((StreamEx)StreamEx.of(valences).filter(as -> as.hasAllObligatoryArguments(node, OBJ))).toList();
        if (withObligatory.isEmpty()) {
            return false;
        }
        List withAnyArg = ((StreamEx)StreamEx.of((Collection)withObligatory).filter(as -> as.hasAnyArgument(node, adjunct))).toList();
        List matching = withAnyArg.isEmpty() ? withObligatory : withAnyArg;
        return matching.stream().allMatch(as -> as.arguments.contains(OBJ));
    }

    static NodePattern mayHaveArgument(String arg) {
        return NodePattern.custom(node -> EnglishValences.potentialValences(node).stream().anyMatch(as -> as.has(arg)));
    }

    static class NominalArgument
    extends Argument {
        @Nullable
        final String preposition;

        private NominalArgument(String presentable, @Nullable String preposition) {
            super(presentable, NodePattern.N.withHeadRelation(presentable.endsWith("obj") ? presentable : "obl(:agent)?|nmod").and(node -> {
                Node prep = node.findSingleDependent("case");
                if (preposition == null) {
                    return prep == null;
                }
                return prep != null && prep.lowForm().equals(preposition);
            }));
            this.preposition = preposition;
        }

        static NominalArgument parse(String presentable) {
            String preposition = presentable.endsWith("obj") ? null : (presentable.endsWith("!") ? presentable.substring(0, presentable.length() - 1) : presentable);
            return new NominalArgument(presentable, preposition);
        }

        @Override
        public boolean isObligatory() {
            return "obj".equals(this.presentable) || this.presentable.endsWith("!");
        }
    }
}

