/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.nlp.langs.Language;
import ai.grazie.nlp.patterns.ext.AbbreviationPatterns;
import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.StyleFlavor;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.DateChecker;
import ai.grazie.rules.common.FeatureUtil;
import ai.grazie.rules.en.Commas;
import ai.grazie.rules.en.EnglishDateChecker;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.EnglishValences;
import ai.grazie.rules.en.NegativePhrases;
import ai.grazie.rules.en.Number;
import ai.grazie.rules.en.PunctuationRules;
import ai.grazie.rules.en.Questions;
import ai.grazie.rules.en.SemanticRules;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.en.SubjectVerbAgreement;
import ai.grazie.rules.en.VerbInflectionNumber;
import ai.grazie.rules.tree.Formatter;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodeRange;
import ai.grazie.rules.tree.TextChange;
import ai.grazie.rules.tree.TextRange;
import ai.grazie.rules.tree.TreeSupport;
import ai.grazie.rules.tree.UnformattedChange;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PassiveToActive {
    private static final NodePattern nonPassiveBy = NodePattern.or(Semantics.timePoints, NodePattern.N.form(StreamEx.of((Collection)EnglishDateChecker.INSTANCE.monthNames).append((Collection)EnglishDateChecker.INSTANCE.dayNames).joining((CharSequence)"|")), Semantics.timeUnits, Semantics.isTransport.formPattern, NodePattern.N.lemma("post|(snail|e)?mail|point|either"), NodePattern.N.lemma("one").noDependents("amod"), Semantics.orderOfMagnitude, NodePattern.N.form("number").noDependents("det|nmod"), NodePattern.N.form("name").withHead(NodePattern.N.lemma("call")), Number.anyPercent.withHead(NodePattern.N.lemma("increase|decrease|fluctuate|double|decline|dwindle|shrink|diminish|raise|lower|reduce")), NodePattern.N.pos("CD"));
    static final NodePattern hasPassiveLikeArguments = NodePattern.N.withDependent("obl(:agent)?", EnglishTreePatterns.byPP.afterHead().andNot(nonPassiveBy).noDependents("nummod")).noDependents("obj");
    static final NodePattern passiveAgent = EnglishTreePatterns.byPP.withDependent("case", NodePattern.N.markAs("By")).noDependents("advmod", NodePattern.N.before("By")).andNot(nonPassiveBy).noLemmaCaseSensitive("time|date|moment|margin|default|transfer|mistake|hand|luck|method|pint|dozen|horn|design|means").andNot(NodePattern.custom(node -> {
        for (Node head : (StreamEx)node.hierarchy().skip(1L)) {
            if (!EnglishValences.potentialValences(head).stream().anyMatch(a -> a.recognizesArgument((Node)node))) continue;
            return true;
        }
        return false;
    })).andNot(NodePattern.N.inFormSequence(0, "nature", "of")).andNot(NodePattern.N.noPos("NNP").withHead("obl(:agent)?", NodePattern.N.inPhrase(NodePattern.N.lemma("send|publish"))));
    private static final String AUX_PASS_COP = "aux:pass|cop";
    static final NodePattern PASSIVE_VOICE = NodePattern.N.pos("VBN").noHeadRelation("xcomp").noDependents("advmod", NodePattern.N.form("as")).withDependent("aux:pass|cop", NodePattern.not(NodePattern.custom(aux -> PassiveToActive.hasQuotationsBetween(aux, aux.head()))).andNot(EnglishTreePatterns.apostropheS.withHead(NodePattern.N.withDependent("obj")))).andNot(NodePattern.N.withDependent("obj", NodePattern.N.pos("NN.*").directlyAfterHead().noPos("VBG").noLemma("much|little")).and(EnglishValences.mayHaveArgument("obj").andNot(EnglishValences.mayHaveArgument("iobj"))).trace("misparsed 'they were valued members'"));
    private static final NodePattern withSubjectModifier = NodePattern.N.withDependent("advcl", SemanticRules.subjectModifier);
    private static final NodePattern ruleCommon = PASSIVE_VOICE.markAs("Participle").withOptionalDependent("cop|aux|aux:pass", NodePattern.N.lemma("be").reportRangeTo("Participle")).withDependent("cop|aux|aux:pass", NodePattern.N.lemma("be").noPos("VBG")).andNot(CommonPatterns.insideQuotes).noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl", SubjectVerbAgreement.errorPattern).andNot(NodePattern.N.directlyBefore(CommonPatterns.noSpaceHyphen)).noLemma("please|devastate|bore|interest").andOr(NodePattern.N.withDependent("obl(:agent)?", passiveAgent.unmark("By")), NodePattern.N.lemma("know").withDependent("(nsubj|csubj).*").withDependent("expl"), NodePattern.N.noLemma("bind|mean|suppose|get|marry|addict|condition|lose|know|commit|prepare|oppose").andNot(NodePattern.N.form("left").withDependent("xcomp")).noForm(".*shit").noPos("JJ")).andNot(NodePattern.N.form("wed").and(CommonPatterns.capitalizedMiddle).trace("Wednesday")).andNot(NodePattern.N.form("made").withDependent("nsubj:pass", NodePattern.N.form("rules?|promises?")));
    private static final NodePattern withSubject = NodePattern.or(NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.markAs("Subj").andNot(NodePattern.custom(node -> PassiveToActive.hasQuotationsBetween(node.phraseStart(), node.phraseEnd())))), NodePattern.N.withDependent("expl", NodePattern.N.form("it").markAs("Subj")).noDependents("cop|aux|aux:pass", NodePattern.N.form("are|were")));
    private static final NodePattern needCommaAfter = CommonPatterns.possiblySkipDown("acl", NodePattern.N.withDependent("advcl|acl:relcl", CommonPatterns.phraseStartsWithComma));
    private static final String ANY_PASSIVE_MSG = "Passive voice can make your text less comprehensible";
    private static final String LESS_READABLE_MSG = "This sentence might be clearer in the active voice";
    private static final NodePattern awkwardPostHeadAdverb = NodePattern.N.form("only|(any|some|no|every)(day|where)");
    private static final NodePattern parentheticalDashLike = NodePattern.or(CommonPatterns.dashLikeHyphens.spaceAround(), CommonPatterns.DASH_NODE).andNot(NodePattern.N.noSpaceAround().directlyAfter(CommonPatterns.withNumberLikeForm).directlyBefore(CommonPatterns.withNumberLikeForm));
    private static final NodePattern unclosedParenthetical = NodePattern.custom(n -> ((StreamEx)n.phraseStart().nextUntil(n.phraseEnd()).filter(parentheticalDashLike::matches)).count() % 2L == 1L);
    private static final NodePattern abbrDot = CommonPatterns.dot.and(n -> AbbreviationPatterns.withPunctCaseSensitive(Language.ENGLISH).find(n.tree().text()).stream().anyMatch(r -> r.getEndExclusive() == n.endOffset()));
    private static final NodePattern abbrOrSentenceEndDot = abbrDot.andNot(NodePattern.N.directlyBefore(CommonPatterns.lowerCase));
    private static final NodePattern withApposLike = NodePattern.or(NodePattern.N.withDependent("appos|compound", NodePattern.N.afterHead().and(CommonPatterns.phraseStartsWithComma).andNot(CommonPatterns.parenthesizedPhrase)), NodePattern.N.withDependent("conj", NodePattern.N.markAs("Conj1")).andOr(NodePattern.not(CommonPatterns.severalDependents("conj")).and(NodePattern.markedNodeMatches("Conj1", NodePattern.N.noDependents("cc"))), NodePattern.N.pos("NNS").withDependent("conj", NodePattern.N.after("Conj1").markAs("Conj2")).noDependents("conj", NodePattern.N.after("Conj2")).and(NodePattern.markedNodeMatches("Conj1", NodePattern.N.noDependents("cc"))).and(NodePattern.markedNodeMatches("Conj2", NodePattern.N.withDependent("cc").noDependents("punct", CommonPatterns.comma)))), NodePattern.N.withDependent("amod", NodePattern.N.afterHead().and(CommonPatterns.phraseStartsWithComma)));
    private static final NodePattern nonMovableAgent = NodePattern.or(NodePattern.N.form("the|any(one|body|thing)"), NodePattern.N.withDependent("nmod:poss", NodePattern.N.form("his|her|its|their")), NodePattern.N.withDependent("conj", NodePattern.or(NodePattern.N.pos("VBN"), NodePattern.N.withDependent("case", NodePattern.N.form("by")))), NodePattern.N.pos("NN.*").withDependent("nmod", NodePattern.N.withDependent("case", NodePattern.N.form("in|at"))), NodePattern.N.withPhraseEnd(NodePattern.or(NodePattern.N.directlyBefore(NodePattern.N.form("from")), abbrOrSentenceEndDot, NodePattern.N.directlyBefore(abbrOrSentenceEndDot), awkwardPostHeadAdverb, NodePattern.N.directlyBefore(awkwardPostHeadAdverb.withHead(EnglishTreePatterns.clause)))), NodePattern.N.withNextSibling(NodePattern.or(CommonPatterns.comma.withNextSibling(NodePattern.N.withHeadRelation("obl").withDependent("conj")).trace("misparsed appos followed by agent conj"), DateChecker.year.and(CommonPatterns.parenthesizedPhrase).trace("misattached academic citation"))), unclosedParenthetical, CommonPatterns.parenthesizedPhrase, NodePattern.N.withDependent("appos", NodePattern.N.withDependent("mark|det", NodePattern.N.form("that"))), withApposLike.andNot(needCommaAfter), NodePattern.N.withDependent("nmod", NodePattern.N.afterHead().and(withApposLike)), NodePattern.N.withPhraseEnd(CommonPatterns.openingParen));
    static final NodePattern expletiveIt = NodePattern.N.form("it").withHead("nsubj:pass|expl", NodePattern.N.withDependent("ccomp|csubj(:pass)?"));
    private static final NodePattern misparsedExpletiveIt = NodePattern.N.form("it").withHead("nsubj:pass|expl", NodePattern.or(NodePattern.N.withDependent("obl(:agent)?", EnglishTreePatterns.byPP.withDependent("acl:relcl", EnglishTreePatterns.withThatMark)), NodePattern.N.withDependent("parataxis", NodePattern.N.withDependent("nsubj.*|mark", NodePattern.N.form("that")))));
    private static final NodePattern thatComplementizerPronounAmbiguity = NodePattern.N.pos("NNP?").withHead("nsubj.*", NodePattern.N.afterHead().withHeadRelation("ccomp|acl:relcl")).withDependent("det", CommonPatterns.firstChildPhrase.form("that"));
    private static final NodePattern withExternalSubjectModifyingPhrase = NodePattern.N.markAs("Subj").withHead("nsubj:pass", NodePattern.N.withDependent("obl", NodePattern.N.before("Subj").withDependent("case", NodePattern.N.form("like"))));
    private static final NodePattern nonMovablePatient = NodePattern.or(CommonPatterns.letterWord.noPos().andNot(CommonPatterns.capitalized.label("PERSON|PRODUCT|ORGANIZATION")), misparsedExpletiveIt, withExternalSubjectModifyingPhrase, thatComplementizerPronounAmbiguity, NodePattern.N.withPhraseEnd(NodePattern.or(EnglishTreePatterns.dashes, NodePattern.N.directlyBefore(EnglishTreePatterns.dashes), NodePattern.N.directlyBefore(PunctuationRules.unmandatedComma), CommonPatterns.beforeSkipping(CommonPatterns.comma, NodePattern.N.inFormSequence(0, "too", ",")))));
    private static final NodePattern movableAdverb = NodePattern.N.beforeHead().andOr(NodePattern.N.form("well"), NodePattern.N.form("all").withHead(NodePattern.N.withDependent("nsubj:pass", NodePattern.N.pos("W.*|PRP"))));
    private static final NodePattern skipSuggestion = NodePattern.or(withSubjectModifier, NodePattern.N.withDependent("nsubj:pass", NodePattern.N.withDependent("det", NodePattern.N.pos("WP\\$?"))), NodePattern.N.withDependent("nsubj:pass", Questions.whPhrase).withHead("conj", NodePattern.N.withHead("advcl", NodePattern.N.withHeadRelation("acl:relcl"))), NodePattern.N.withPrevSibling(NodePattern.N.pos("WP\\$?").afterHead()), NodePattern.N.withDependent("cc:preconj|advmod", NodePattern.N.directlyAfter(EnglishTreePatterns.notOnly)), NodePattern.N.withDependent("advmod", NodePattern.or(movableAdverb.directlyBefore(CommonPatterns.HYPHEN_NODE), NodePattern.N.inFormSequence(0, "solely|only|exactly|precisely|exclusively", "by"))), CommonPatterns.severalDependents("obl:agent"), NodePattern.N.withDependent("obl", NodePattern.N.noDependents("case", NodePattern.N.form("by")).afterHead()).withDependent("conj", NodePattern.N.noDependents("nsubj")), NodePattern.N.withDependent("advmod", NodePattern.N.afterHead().directlyBefore(CommonPatterns.comma).directlyAfter(CommonPatterns.comma)));
    private static final NodePattern seemsProminent = NodePattern.or(NodePattern.N.pos("JJS"), NodePattern.N.withDependent("amod", NodePattern.or(NodePattern.N.pos("JJS"), NodePattern.N.withDependent("advmod", NodePattern.N.form("very|only")))), NodePattern.N.withPhraseStart(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("cc.*"))));
    private static final NodePattern seemsIndefinite = NodePattern.or(NodePattern.N.withDependent("det", NodePattern.N.form("an?")), NodePattern.or(NodePattern.N.pos("NNS"), nonMovablePatient.form(".*s")).noDependents("det"));
    private static final NodePattern seemsMoreDefinite = NodePattern.or(NodePattern.N.form("some"), NodePattern.N.withDependent("det", NodePattern.N.form("the|this|that|both")), NodePattern.N.withDependent("amod", NodePattern.N.form("other")), NodePattern.N.withDependent("nmod:poss"));
    private static final NodePattern allowObjectRelative = NodePattern.N.form("that|which|who|what").directlyBefore(NodePattern.N.withHeadRelation("cop|aux|aux:pass")).withHead("nsubj:pass", NodePattern.N.markAs("PassiveVerb").withDependent("obl(:agent)?", NodePattern.N.withDependent("case", NodePattern.N.form("by").directlyBeforeHead().directlyAfter("PassiveVerb")).noDependents(NodePattern.N.afterHead())));
    private static final NodePattern willProduceObjectRelative = CommonPatterns.possiblyConj(NodePattern.or(NodePattern.N.withHeadRelation("acl:relcl|ccomp").and(NodePattern.markedNodeMatches("Subj", NodePattern.or(NodePattern.N.form("that"), Questions.whPhrase))), NodePattern.N.withHeadRelation("advcl.*|parataxis").and(NodePattern.markedNodeMatches("Subj", NodePattern.N.form("which")))));
    private static final NodePattern verbParticle = NodePattern.N.directlyAfterHead().andOr(NodePattern.N.withHeadRelation("compound:prt"), NodePattern.N.pos("IN").withHeadRelation("obl|advmod").noForm("before"));
    private static final NodePattern objectInsertionAnchor = NodePattern.or(NodePattern.N.directlyBefore(NodePattern.or(verbParticle.markAs("Anchor"), NodePattern.N.withHeadRelation("obj").directlyBefore(NodePattern.N.pos("IN").withHeadRelation("obl").markAs("Anchor")))), NodePattern.N.markAs("Anchor"));
    private static final NodePattern isPast = NodePattern.or(NodePattern.N.pos("VBD"), NodePattern.N.form("['\u2019`\u2018]d"));

    private static boolean hasQuotationsBetween(Node start, Node end) {
        return ((StreamEx)start.nextUntil(end).filter(EnglishTreePatterns.quotations::matches)).count() % 2L != 0L;
    }

    @Nullable
    private static TextChange invokeAction(Node head) {
        if (skipSuggestion.matches(head)) {
            return null;
        }
        Node patient = head.findSingleDependent("nsubj.*|expl");
        Node auxPass = head.findSingleDependent(AUX_PASS_COP);
        if (patient == null || auxPass == null || nonMovablePatient.matches(patient)) {
            return null;
        }
        boolean tracePatient = false;
        if (willProduceObjectRelative.match(head, NodeMatch.EMPTY.withMarkedNode("Subj", patient)) != null) {
            if (!allowObjectRelative.matches(patient)) {
                return null;
            }
            tracePatient = true;
        }
        List allVerbs = ((StreamEx)StreamEx.of((Object)head).append(head.findDependents("conj")).takeWhile(n -> n == head || !n.hasDependent("nsubj(:pass|:outer)?|csubj(:pass)?"))).toList();
        Node agent = (Node)FeatureUtil.singleOrNull(((StreamEx)StreamEx.of((Collection)allVerbs).flatCollection(Node::allDependents).filter(passiveAgent::matches)).toList());
        if (agent == null || agent.isBefore(head) || nonMovableAgent.matches(agent)) {
            return null;
        }
        Set touched = ((StreamEx)StreamEx.of((Collection)allVerbs).append((Object[])new Node[]{patient, auxPass, agent}).filter(Objects::nonNull)).toSet();
        if (touched.stream().anyMatch(n -> head.tree().crazyParseNodes().getCrazyMessage((Node)n) != null)) {
            return null;
        }
        NodePattern differentStructure = NodePattern.or(NodePattern.N.withDependent("aux", NodePattern.N.pos("VBZ|VBD")), NodePattern.N.noPos("VBN"), NodePattern.N.pos("VBP?"));
        if (allVerbs.stream().anyMatch(n -> n != head && differentStructure.matches((Node)n))) {
            return null;
        }
        boolean itself = agent.hasForm("itself");
        TextChange makeVerbsActive = PassiveToActive.makeVerbsActive(auxPass, allVerbs, itself ? patient : agent, patient);
        if (makeVerbsActive == null) {
            return null;
        }
        if (itself) {
            Node by = agent.phraseStart();
            TextChange removeBy = TextChange.replace(Objects.requireNonNull(by.prevNode()).endOffset(), by.endOffset(), "");
            return makeVerbsActive.and(removeBy);
        }
        NodeRange patientPhrase = PassiveToActive.patientPhrase(patient);
        TextChange makeAgentSubj = PassiveToActive.makeAgentSubj(tracePatient, agent, patientPhrase);
        if (makeAgentSubj == null) {
            return null;
        }
        int afterVerbs = PassiveToActive.objectInsertionOffset((Node)Iterables.getLast((Iterable)allVerbs), patient);
        TextChange makePatientObj = tracePatient || expletiveIt.matches(patient) ? TextChange.EMPTY : TextChange.insert(afterVerbs, " ").and(Formatter.moveFragment(PassiveToActive.toObjective(patient, PassiveToActive.avoidDanglingPunctuation(patientPhrase, agent)), patientPhrase, TextRange.fromLength(afterVerbs, 0)));
        TextChange moveAdv = StreamEx.of(head.findDependents("advmod")).findFirst(movableAdverb::matches).map(adv -> TextChange.insert(afterVerbs, " ").and(Formatter.moveFragment(adv.phraseText(), PassiveToActive.phraseNodeRange(adv), TextRange.fromLength(afterVerbs, 0))).and(TextChange.replace(adv.startOffset(), adv.neighbor(1).startOffset(), ""))).orElse(TextChange.EMPTY);
        return makeAgentSubj.and(moveAdv).and(makePatientObj).and(makeVerbsActive);
    }

    private static int objectInsertionOffset(Node verb, Node patient) {
        Node anchor = Objects.requireNonNull(objectInsertionAnchor.match(verb)).getMarkedNode("Anchor");
        if (anchor.prevNode() != null && verbParticle.matches(anchor) && EnglishTreePatterns.pronounToPlaceBeforeParticle.matches(patient)) {
            anchor = anchor.prevNode();
        }
        return anchor.endOffset();
    }

    @Nullable
    private static TextChange makeVerbsActive(Node auxPass, List<Node> allVerbs, Node agent, Node patient) {
        Node head = allVerbs.get(0);
        TextChange makeVerbsActive = TextChange.EMPTY;
        for (Node verb : allVerbs) {
            String finite;
            boolean needsDoSupport;
            Node localAux = Objects.requireNonNullElse(verb.findSingleDependent(AUX_PASS_COP), auxPass);
            boolean past = isPast.matches(localAux);
            VerbInflectionNumber number = VerbInflectionNumber.fromLikely(verb, agent);
            boolean bl = needsDoSupport = (EnglishTreePatterns.negation.matches(localAux.nextNode()) || localAux.isBefore(patient)) && verb.findDependents("aux").stream().noneMatch(n -> n.isBefore(localAux));
            if (verb == head || localAux != auxPass) {
                if (needsDoSupport) {
                    if (number == null) {
                        return null;
                    }
                    makeVerbsActive = makeVerbsActive.and(TextChange.replace(localAux.textRange(), TreeSupport.preserveCase(localAux.form(), number.past(past).inflectDo(), verb.language())));
                } else {
                    TextChange.Replacement removal = new TextChange.Replacement(localAux.textRange(), "");
                    makeVerbsActive = makeVerbsActive.and(UnformattedChange.from(removal).formatChange(localAux.tree()));
                }
            }
            if ((finite = PassiveToActive.inflectMainVerb(verb, needsDoSupport, past, number, verb == head ? agent : null, localAux)) == null) {
                return null;
            }
            makeVerbsActive = makeVerbsActive.and(TextChange.replace(verb.textRange(), TreeSupport.preserveCase(verb.form(), finite, verb.language())));
        }
        Node firstCopAux = Objects.requireNonNull(EnglishTreePatterns.findFirstCopAux(head));
        if (firstCopAux != auxPass && firstCopAux.hasLemma("have|be")) {
            String finite = PassiveToActive.toFinite(firstCopAux, false, isPast.matches(firstCopAux), VerbInflectionNumber.fromLikely(head, agent), agent);
            if (finite == null) {
                return null;
            }
            if (!finite.equalsIgnoreCase(firstCopAux.form())) {
                makeVerbsActive = makeVerbsActive.and(TextChange.replace(firstCopAux.textRange(), finite));
            }
        }
        return makeVerbsActive;
    }

    private static NodeRange patientPhrase(Node patient) {
        Node end = patient.phraseEnd();
        Node next = end.nextNode();
        Node prev = end.prevNode();
        Node adjustedEnd = end;
        if (CommonPatterns.comma.matches(next) && Commas.allCommaLicenses(next.tree()).stream().anyMatch(c -> c.start.isBefore(next) && c.allows(next))) {
            adjustedEnd = next;
        } else if (CommonPatterns.comma.matches(end) && prev != null && Commas.allCommaLicenses(end.tree()).stream().anyMatch(c -> c.end.isAfter(end) && c.allows(end))) {
            adjustedEnd = prev;
        }
        Node start = patient.phraseStart();
        if (start.hasForm("not|,") && start.nextNode() != null) {
            start = start.nextNode();
        }
        return new NodeRange(start, adjustedEnd);
    }

    @Nullable
    private static TextChange makeAgentSubj(boolean tracePatient, Node agent, NodeRange patientPhrase) {
        TextRange patientPhraseRange = tracePatient ? TextRange.fromLength(patientPhrase.end().endOffset(), 0) : patientPhrase.textRange();
        NodeRange agentPhrase = PassiveToActive.phraseNodeRange(agent);
        Node npEnd = agentPhrase.end();
        Node by = agentPhrase.start();
        Node npStart = by.nextNode();
        Node beforeBy = by.prevNode();
        if (beforeBy == null) {
            return null;
        }
        Object subjText = PassiveToActive.toNominative(agent, npStart, npEnd);
        if (needCommaAfter.matches(agent) && !((String)subjText).endsWith(",")) {
            subjText = (String)subjText + ",";
        }
        if (abbrDot.matches(npEnd.nextNode())) {
            subjText = (String)subjText + ".";
            npEnd = npEnd.nextNode();
        }
        boolean leaveReflexive = agent.hasForm("(my|your|him|her|them|our)(self|selves)");
        TextChange makeAgentSubj = Formatter.moveFragment((String)subjText, new NodeRange(npStart, npEnd), patientPhraseRange).and(TextChange.replace(beforeBy.endOffset(), (leaveReflexive ? by : npEnd).endOffset(), ""));
        return tracePatient ? TextChange.insert(patientPhrase.end().endOffset(), " ").and(makeAgentSubj) : makeAgentSubj;
    }

    @Nullable
    private static String inflectMainVerb(Node verb, boolean needsDoSupport, boolean past, @Nullable VerbInflectionNumber number, @Nullable Node agent, Node auxPass) {
        if (auxPass.hasPos("VBG")) {
            return PassiveToActive.inflectParticiple(verb, "VBG");
        }
        if (auxPass.hasPos("VBN")) {
            return PassiveToActive.inflectParticiple(verb, "VBN");
        }
        if (auxPass.hasPos("VB")) {
            return PassiveToActive.inflectParticiple(verb, "VB");
        }
        return PassiveToActive.toFinite(verb, needsDoSupport, past, number, agent);
    }

    @Nullable
    private static String toFinite(Node verb, boolean needsDoSupport, boolean past, @Nullable VerbInflectionNumber number, @Nullable Node localSubject) {
        if (verb.hasForm("(ha|['\u2019`\u2018])(ve|s|d)")) {
            if (past) {
                number = VerbInflectionNumber.singular;
            }
            if (number == null) {
                return null;
            }
            boolean pronounSubject = localSubject != null && localSubject.hasPos("PRP");
            boolean wasContracted = EnglishTreePatterns.startsWithApostrophe.matches(verb);
            boolean contract = wasContracted && pronounSubject;
            String prefix = wasContracted && !pronounSubject ? " " : "";
            String full = number.past(past).inflectHave();
            return contract ? verb.form().charAt(0) + full.substring(2) : prefix + full;
        }
        if (verb.hasLemma("be") && !needsDoSupport) {
            if (number == null) {
                return null;
            }
            return number.past(past).inflectBe();
        }
        if (needsDoSupport) {
            return PassiveToActive.inflectParticiple(verb, "VB");
        }
        if (past) {
            return PassiveToActive.inflectParticiple(verb, "VBD");
        }
        if (number == null) {
            return null;
        }
        return PassiveToActive.inflectParticiple(verb, number == VerbInflectionNumber.singular ? "VBZ" : "VB");
    }

    @Nullable
    private static String inflectParticiple(Node verb, String pos) {
        List<String> sug = verb.tree().treeSupport().inflectNode(verb, "VBN", pos);
        return sug.isEmpty() ? null : sug.get(0);
    }

    private static NodeRange phraseNodeRange(Node node) {
        return new NodeRange(node.phraseStart(), node.phraseEnd());
    }

    private static String toNominative(Node node, Node npStart, Node npEnd) {
        return node.hasForm("me|myself") ? "I" : (node.hasForm("him(self)?") ? "he" : (node.hasForm("her(self)?") ? "she" : (node.hasForm("them(selves)?") ? "they" : (node.hasForm("us|ourselves") ? "we" : (node.hasForm("you(rself|rselves)?") ? "you" : PassiveToActive.rangeText(npStart, npEnd))))));
    }

    private static String rangeText(NodeRange range) {
        return PassiveToActive.rangeText(range.start(), range.end());
    }

    private static String rangeText(Node start, Node end) {
        return start.tree().text().substring(start.startOffset(), end.endOffset());
    }

    private static String toObjective(Node node, NodeRange range) {
        return node.hasForm("I") ? "me" : (node.hasForm("he") ? "him" : (node.hasForm("she") ? "her" : (node.hasForm("they") ? "them" : (node.hasForm("we") ? "us" : PassiveToActive.rangeText(range)))));
    }

    private static NodeRange avoidDanglingPunctuation(NodeRange range, Node agent) {
        Node next;
        if (CommonPatterns.comma.matches(range.end()) && ((next = agent.phraseEnd().nextNode()) == null || NodePattern.PUNCT.matches(next))) {
            return new NodeRange(range.start(), range.end().neighbor(-1));
        }
        return range;
    }

    private static NodePattern anyPassive() {
        return ruleCommon.andOr(CommonPatterns.possiblyConj(withSubject), NodePattern.N.withHead("acl:relcl", NodePattern.N.pos("WP"))).and((node, match) -> {
            TextChange change = PassiveToActive.invokeAction(node);
            return change == null ? match : match.withCorrector(NodeCorrector.fromChanges(List.of(change)));
        }).message(ANY_PASSIVE_MSG);
    }

    private static NodePattern lessReadablePassive() {
        NodePattern unknownProminencePronoun = NodePattern.N.form("it|they");
        NodePattern unknownWord = CommonPatterns.letterWord.noPos().andNot(CommonPatterns.capitalized);
        NodePattern ignoreOnSameProminence = NodePattern.N.lemma("cause");
        return ruleCommon.message(LESS_READABLE_MSG).withDependent("obl(:agent)?", passiveAgent.afterHead().markAs("Agent").noLemma("some|this|that|all").noDependents("nmod:poss", NodePattern.N.form("his|her|their|its"))).andNot(NodePattern.N.noDependents("aux").and(NodePattern.markedNodeMatches("Agent", NodePattern.N.noPos()))).noDependents("conj").and(withSubject).noForm("backed|accompanied|borne?").markAs("Passive").andNot(NodePattern.markedNodeMatches("Subj", NodePattern.or(unknownProminencePronoun, unknownWord, CommonPatterns.possiblySkipDown("nmod|obl", NodePattern.N.withDependent("acl", NodePattern.N.sameWordAs("Passive"))), NodePattern.N.inFormSequence(1, "how", "many|much")))).andNot(NodePattern.N.withDependent("advmod", NodePattern.N.form("yet")).and(NodePattern.markedNodeMatches("Subj", NegativePhrases.negativeNominal))).andNot(willProduceObjectRelative.andNot(NodePattern.markedNodeMatches("Subj", allowObjectRelative))).andNot(NodePattern.N.withPhraseStart(CommonPatterns.afterSkipping(NodePattern.PUNCT, NodePattern.N.inPhrase(PASSIVE_VOICE)))).and(NodePattern.custom((node, match) -> {
            Node subj = match.getMarkedNode("Subj");
            Node agent = match.getMarkedNode("Agent");
            int agentLength = agent.phraseText().length() - "by ".length();
            if (agentLength > 20 || agentLength > 10 && subj.phraseText().length() <= agentLength) {
                return null;
            }
            CompoundAnimacy subjAnimacy = CompoundAnimacy.forNode(subj);
            CompoundAnimacy agentAnimacy = CompoundAnimacy.forNode(agent);
            if (subjAnimacy != null && agentAnimacy != null && subjAnimacy.compareTo(agentAnimacy) < 0) {
                return null;
            }
            if ((subjAnimacy == null || agentAnimacy == null || subjAnimacy.equals(agentAnimacy)) && ignoreOnSameProminence.matches(node)) {
                return null;
            }
            if (seemsProminent.matches(subj)) {
                return null;
            }
            if (seemsIndefinite.matches(agent) && seemsMoreDefinite.matches(subj)) {
                return null;
            }
            if (PassiveToActive.properNamesOfUnknownRelativeImportance(subj, agent)) {
                return null;
            }
            return match;
        })).and((node, match) -> {
            TextChange change = PassiveToActive.invokeAction(node);
            return change == null ? null : match.withCorrector(NodeCorrector.fromChanges(List.of(change)));
        });
    }

    private static boolean properNamesOfUnknownRelativeImportance(Node subj, Node agent) {
        if (CommonPatterns.capitalizedMiddle.matches(subj) && CommonPatterns.capitalizedMiddle.matches(agent)) {
            return !CommonPatterns.nerPerson.matches(subj) || !CommonPatterns.nerPerson.matches(agent);
        }
        return false;
    }

    static List<Rule.PatternRule> rules() {
        return List.of(new Rule.PatternRule("Style.LESS_READABLE_PASSIVE", "Prefer active voice for improved readability", "When a passive sentence contains the phrase <i>by X</i>\nand the subject of the preposition (<i>X</i>) is shorter or more important than the passive subject,\nit is usually easier to read when rewritten in active voice.\n", "https://www.ef.co.uk/english-resources/english-grammar/passive-voice/", PassiveToActive.lessReadablePassive(), new Example("The bread <b>is being baked</b> by him.", LESS_READABLE_MSG, "He <b>is baking</b> the bread.")).styleFlavor(StyleFlavor.Readability), new Rule.PatternRule("Style.PASSIVE_VOICE", "Avoid all passive constructions", "Passive voice is generally considered bad for your writing style. Although it is not a mistake, passive voice often hides the performer of the action, making your text feel evasive.\n", "https://www.ef.co.uk/english-resources/english-grammar/passive-voice/", PassiveToActive.anyPassive(), new Example("In my opinion, this problem must <b>be solved</b> by a teacher", ANY_PASSIVE_MSG, "In my opinion, a teacher must <b>solve</b> this problem")).disableByDefault().styleFlavor(StyleFlavor.Readability));
    }

    private record CompoundAnimacy(@NotNull Semantics.Animacy primary, @Nullable Semantics.Animacy secondary) implements Comparable<CompoundAnimacy>
    {
        @Nullable
        static CompoundAnimacy forNode(Node node) {
            Semantics.Animacy primary = Semantics.animacy(node);
            if (primary == null) {
                return null;
            }
            Semantics.Animacy secondary = StreamEx.of(node.findDependents("compound|amod")).map(Semantics::animacy).nonNull().max(Comparator.naturalOrder()).orElse(null);
            return new CompoundAnimacy(primary, secondary);
        }

        @Override
        public int compareTo(@NotNull CompoundAnimacy o) {
            int result2 = this.primary.compareTo(o.primary);
            if (result2 == 0 && this.secondary != null) {
                result2 = this.secondary.compareTo(o.primary);
            }
            if (result2 == 0 && o.secondary != null) {
                result2 = this.primary.compareTo(o.secondary);
            }
            if (result2 == 0 && this.secondary != null && o.secondary != null) {
                result2 = this.secondary.compareTo(o.secondary);
            }
            return result2;
        }
    }
}

