/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.ru;

import ai.grazie.rules.common.Valence;
import ai.grazie.rules.ru.RussianTreePatterns;
import ai.grazie.rules.ru.RussianValences;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodePattern;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

enum Case {
    Nom("Nom", "\u0438\u043c\u0435\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e", "\u0432"),
    R("R", "\u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e", "\u0431\u0435\u0437", "\u0431\u043b\u0438\u0437", "\u0432\u0434\u043e\u043b\u044c", "\u0432\u043c\u0435\u0441\u0442\u043e", "\u0432\u043d\u0435", "\u0432\u043d\u0443\u0442\u0440\u0438", "\u0432\u043e\u0437\u043b\u0435", "\u0432\u043e\u043a\u0440\u0443\u0433", "\u0432\u043f\u0435\u0440\u0435\u0434\u0438", "\u0434\u043b\u044f", "\u0434\u043e", "\u0438\u0437", "\u043a\u0440\u043e\u043c\u0435", "\u043c\u0435\u0436", "\u043c\u0438\u043c\u043e", "\u043d\u0430\u043a\u0430\u043d\u0443\u043d\u0435", "\u043e\u043a\u043e\u043b\u043e", "\u043e\u0442", "\u043f\u043e\u0441\u043b\u0435", "\u043f\u0440\u043e\u0442\u0438\u0432", "\u043d\u0430\u043f\u0440\u043e\u0442\u0438\u0432", "\u0440\u0430\u0434\u0438", "\u0441", "\u0441\u0440\u0435\u0434\u0438", "\u043f\u043e\u0441\u0440\u0435\u0434\u0438", "\u0443", "\u043c\u0430\u043b\u043e", "\u043c\u043d\u043e\u0433\u043e", "\u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e", "\u043e\u0442\u043d\u043e\u0441\u0438\u0442\u0435\u043b\u044c\u043d\u043e", "\u0441\u0432\u0435\u0440\u0445"),
    R2("2R", Case.R.presentableGen, Case.R.prepositions.toArray(new String[0])),
    D("D", "\u0434\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e", "\u043a", "\u043f\u043e", "\u0431\u043b\u0430\u0433\u043e\u0434\u0430\u0440\u044f", "\u0432\u043e\u043f\u0440\u0435\u043a\u0438", "\u043d\u0430\u043f\u0435\u0440\u0435\u043a\u043e\u0440", "\u0441\u043e\u0433\u043b\u0430\u0441\u043d\u043e"),
    V("V", "\u0432\u0438\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e", "\u0432", "\u043d\u0430", "\u0441", "\u0437\u0430", "\u043e", "\u043f\u043e\u0434", "\u043f\u043e", "\u043f\u0440\u043e", "\u0441\u043a\u0432\u043e\u0437\u044c", "\u0447\u0435\u0440\u0435\u0437"),
    T("T", "\u0442\u0432\u043e\u0440\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e", "\u043d\u0430\u0434", "\u043f\u043e\u0434", "\u0437\u0430", "\u043f\u0435\u0440\u0435\u0434", "\u043c\u0435\u0436", "\u043c\u0435\u0436\u0434\u0443", "\u0441"),
    P("P", "\u043f\u0440\u0435\u0434\u043b\u043e\u0436\u043d\u043e\u0433\u043e", "\u0432", "\u043d\u0430", "\u043f\u0440\u0438", "\u043e", "\u043f\u043e"),
    P2("2P", Case.P.presentableGen, Case.P.prepositions.toArray(new String[0]));

    private static final Set<Case> allNounArgCases;
    private static final NodePattern isDashSeparated;
    private static final NodePattern definitelyInfinitive;
    private static final NodePattern nounNoVerb;
    private static final NodePattern transitiveVerb;
    static final NodePattern hasTransitiveVerbAround;
    private static final NodePattern definitelyIntransitive;
    private static final NodePattern betweenRPlural;
    static final NodePattern izZa;
    static final NodePattern chtoXZa;
    private final String name;
    final String presentableGen;
    private final Set<String> prepositions;
    final NodePattern posPattern;

    private Case(String name, String presentableGen, String ... prepositions) {
        this.name = name;
        this.presentableGen = presentableGen;
        this.prepositions = Set.of(prepositions);
        this.posPattern = NodePattern.N.pos(".*:" + name + "($|:.*)");
    }

    Case baseCase() {
        return this == R2 ? R : (this == P2 ? P : this);
    }

    boolean isCoveredBy(Set<Case> cases) {
        return cases.contains((Object)this) || cases.contains((Object)this.baseCase());
    }

    public String toString() {
        return this.name;
    }

    @Nullable
    static Set<Case> getPrepositionCases(Node prep) {
        if (izZa.matches(prep)) {
            return Set.of(R);
        }
        if (isDashSeparated.matches(prep)) {
            return null;
        }
        if (chtoXZa.matches(prep)) {
            return null;
        }
        List<Node> fixed = prep.findDependents("fixed");
        if (!fixed.isEmpty()) {
            Node node = fixed.get(fixed.size() - 1);
            if (node.hasPos("PREP")) {
                return Case.getPrepositionCases(node);
            }
            if (fixed.size() == 1 && node.hasPos("NN.*") && !node.hasPos("ADJ.*")) {
                return Set.of(R);
            }
            return null;
        }
        if (betweenRPlural.matches(prep)) {
            return EnumSet.of(R, T);
        }
        String norm = RussianTreePatterns.normalizePreposition(prep.lowForm());
        Set cases = (Set)((StreamEx)StreamEx.of((Object[])Case.values()).filter(c -> c.prepositions.contains(norm))).toCollection(LinkedHashSet::new);
        return cases.isEmpty() ? null : cases;
    }

    @Nullable
    static Set<Case> getArgumentCases(Node node) {
        List<Valence> valences = RussianValences.get(node);
        return valences.isEmpty() ? null : Case.getArgumentCases(valences);
    }

    static LinkedHashSet<Case> getArgumentCases(List<Valence> valences) {
        return (LinkedHashSet)((StreamEx)StreamEx.of(valences).flatCollection(s -> s.arguments).select(RussianValences.NominalArgument.class).filter(a -> a.preposition == null)).map(a -> a.caze).toCollection(LinkedHashSet::new);
    }

    static Set<Case> maxArgumentCases(Node node) {
        if (nounNoVerb.matches(node)) {
            return allNounArgCases;
        }
        EnumSet<Case> verbal = EnumSet.of(Nom, R, D, V, T);
        if (definitelyIntransitive.matches(node)) {
            verbal.remove((Object)V);
        }
        if (definitelyInfinitive.matches(node) && node.head() != null) {
            verbal.remove((Object)Nom);
        }
        return verbal;
    }

    boolean isPresentOn(Node node) {
        return this.posPattern.matches(node);
    }

    static {
        allNounArgCases = Set.of(R, R2, D, T);
        isDashSeparated = NodePattern.N.directlyBefore(NodePattern.N.form("-"));
        definitelyInfinitive = RussianTreePatterns.infinitive.andNot(RussianTreePatterns.finiteVerb);
        nounNoVerb = NodePattern.N.pos("NN.*").noPos("VB.*");
        transitiveVerb = NodePattern.N.pos("VB:.*:TRANS:.*");
        hasTransitiveVerbAround = NodePattern.or(transitiveVerb, NodePattern.N.withDependent("csubj|xcomp", transitiveVerb), NodePattern.N.withDependent("conj", NodePattern.N.withDependent("csubj", transitiveVerb)));
        definitelyIntransitive = NodePattern.N.pos("VB.*:INTR.*").andNot(hasTransitiveVerbAround);
        betweenRPlural = NodePattern.N.form("\u043c\u0435\u0436(\u0434\u0443)?").withHead("case", NodePattern.N.pos("NN:.*PL:R.*"));
        izZa = NodePattern.N.inFormSequence(0, "\u0438\u0437", "-", "\u0437\u0430|\u043f\u043e\u0434\u043e?");
        chtoXZa = NodePattern.N.form("\u0437\u0430").withHead("case", NodePattern.N.withDependent("det", NodePattern.N.form("\u0447\u0442\u043e").beforeHead()));
    }
}

