/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.ru;

import ai.grazie.rules.common.Argument;
import ai.grazie.rules.common.Valence;
import ai.grazie.rules.common.ValenceParser;
import ai.grazie.rules.ru.Case;
import ai.grazie.rules.ru.Negation;
import ai.grazie.rules.ru.RussianTreePatterns;
import ai.grazie.rules.ru.SemanticRules;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.Tree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RussianValences {
    static final Pattern passiveParticiple = Pattern.compile("PT.*STR.*");
    private static final Pattern withNomSubject = Pattern.compile("VB:(Real|Past|Fut|IMP).*");
    static final Argument CCOMP = new Argument("\u0447\u0442\u043e", NodePattern.N.withHeadRelation("ccomp"));
    static final Argument XCOMP = new Argument("\u0438\u043d\u0444", NodePattern.N.withHeadRelation("xcomp").pos("VB:INF.*"));
    static final NodePattern auxAdverb = NodePattern.or(NodePattern.N.form("\u0435\u0449[\u0435\u0451]|\u0443\u0436\u0435|\u043e\u0447\u0435\u043d\u044c|\u043d\u0435"), RussianTreePatterns.emphasis);
    private static final ValenceParser parser = new ValenceParser(new Argument[]{CCOMP, XCOMP}){

        @Override
        public Argument arg(String arg) {
            return switch (arg) {
                case "\u043a\u0430\u043a" -> HOW;
                case "\u0433\u0434\u0435" -> WHERE_IN;
                case "\u043a\u0443\u0434\u0430" -> WHERE_TO;
                case "\u0422:\u0421\u043b\u043e\u0432\u0430\u043c\u0438" -> inOwnWords;
                default -> RussianValences.nominal(arg, arg, NodePattern.N);
            };
        }
    };
    private static final Argument.Composite WHERE_IN = Argument.unite("\u0433\u0434\u0435", RussianValences.parser.valence((String)"\u0432\u041f+\u043d\u0430\u041f+\u043f\u043e\u0434\u0422+\u043d\u0430\u0434\u0422").arguments);
    private static final Argument.Composite WHERE_TO = Argument.unite("\u043a\u0443\u0434\u0430", RussianValences.parser.valence((String)"\u043d\u0430\u0412+\u0432\u0412+\u043f\u043e\u0434\u0412+\u043d\u0430\u0434\u0412").arguments);
    private static final Argument.Composite WHEN = Argument.unite("\u043a\u043e\u0433\u0434\u0430", StreamEx.of((Object)parser.arg("\u043d\u0430\u0412")).append((Object)RussianValences.nominal("\u0432\u0412", "\u0432\u0412\u0440\u0435\u043c\u044f", NodePattern.or(SemanticRules.durableNoun, SemanticRules.moment))).append((Object)RussianValences.nominal("\u0412", "\u0432\u0438\u043d\u0412\u0440\u0435\u043c\u044f", SemanticRules.durable)).append((Object)RussianValences.nominal("\u0441\u0420", "\u0441\u0412\u0440\u0435\u043c\u044f", NodePattern.or(SemanticRules.durable, SemanticRules.moment))).append((Object)RussianValences.nominal("\u0441\u0422", "\u0441\u043e\u0412\u0440\u0435\u043c\u0435\u043d\u0435\u043c", NodePattern.N.lemma("\u0432\u0440\u0435\u043c\u044f"))).append((Object)RussianValences.nominal("\u0420", "\u044d\u043d\u043d\u043e\u0433\u043e\u041c\u0435\u0441\u044f\u0446\u0430", NodePattern.N.pos("Ord.*").noDependents("case"))).toList());
    private static final Argument inOwnWords = RussianValences.nominal("\u0422", "\u0422:\u0421\u043b\u043e\u0432\u0430\u043c\u0438", NodePattern.N.lemma("\u0441\u043b\u043e\u0432\u043e|\u0436\u0435\u0441\u0442|\u0433\u043e\u043b\u043e\u0441|\u0432\u043e\u043a\u0430\u043b|\u043f\u0435\u0441\u043d\u044f|\u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u0438\u0435"));
    static final Argument.Composite HOW = Argument.unite("\u043a\u0430\u043a", StreamEx.of((Object)parser.arg("\u043f\u043e\u0434\u0412")).append((Object)RussianValences.nominal("\u0432\u0412", "\u0432\u041a\u0430\u043a", NodePattern.N.lemma("\u043f\u043e\u043b\u044c\u0437\u0430|\u043e\u0447\u0435\u0440\u0435\u0434\u044c"))).append((Object)RussianValences.nominal("\u0422", "\u0422:\u041e\u0431\u0440\u0430\u0437\u043e\u043c", NodePattern.N.lemma("\u043e\u0431\u0440\u0430\u0437"))).append((Object)RussianValences.nominal("\u0422", "\u0422:\u0421\u043e\u0441\u0442\u0430\u0432", NodePattern.N.lemma("\u0441\u043e\u0441\u0442\u0430\u0432|\u043a\u043e\u043c\u0430\u043d\u0434\u0430|\u0433\u0440\u0443\u043f\u043f\u0430"))).append((Object)RussianValences.nominal("\u0441\u0420", "\u0420:\u0422\u043e\u0447\u043a\u0438", NodePattern.N.lemma("\u0442\u043e\u0447\u043a\u0430"))).append((Object)new Argument("\u043a\u0430\u043a\u041d\u0430\u0440\u0435\u0447\u0438\u0435", NodePattern.N.withHeadRelation("advmod")){

        @Override
        public boolean matchesLexically(Node node) {
            return !auxAdverb.matches(node);
        }
    }).toList());
    private static final Argument.Composite QUANTITY = Argument.unite("\u0441\u043a\u043e\u043b\u044c\u043a\u043e\u0420\u0430\u0437", List.of(RussianValences.nominal("\u0412", "\u0412:\u0421\u043a\u043e\u043b\u044c\u043a\u043e\u0420\u0430\u0437", NodePattern.N.lemma("\u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u043e|\u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e").withDependent("nmod", SemanticRules.moment))));
    private static final NodePattern comparativeAdj = NodePattern.N.pos("ADJ:Comp");
    private static final NodePattern negatedClause = NodePattern.or(Negation.negated, NodePattern.N.withHead("xcomp", Negation.negated));
    static final List<Argument> adjuncts = StreamEx.of((Object[])new Argument.Composite[]{WHERE_IN, WHEN, HOW, QUANTITY}).toFlatList(c -> c.components);
    private static final Map<String, List<Valence>> verbValences = parser.fromResource("ru/verb_arg_structures.txt");
    private static final Map<String, List<Valence>> nounValences = parser.fromResource("ru/noun_arg_structures.txt");
    private static final Map<String, List<Valence>> adjValences = parser.fromResource("ru/adj_arg_structures.txt");
    static final NodePattern genAdverb = NodePattern.N.form("(\u043c\u043d\u043e\u0433\u043e|\u043c\u0430\u043b\u043e)(\u0432\u0430\u0442\u043e)?|\u0431\u043e\u043b\u044c\u0448\u0435|\u043c\u0435\u043d\u044c\u0448\u0435");
    private static final NodePattern allowsGenSubj = NodePattern.N.lemma("\u0431\u044b\u0442\u044c|\u0431\u044b\u0432\u0430\u0442\u044c|\u0441\u0442\u0430\u0442\u044c|\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c\u0441\u044f").andOr(NodePattern.N.withDependent("nummod:gov"), NodePattern.N.withDependent("advmod|obl", genAdverb), negatedClause);
    static final NodePattern notArg = NodePattern.custom(n -> {
        Node head = n.head();
        if (head == null) {
            return true;
        }
        List<Valence> valences = RussianValences.get(head);
        return !valences.isEmpty() && valences.stream().noneMatch(s -> s.recognizesArgument((Node)n));
    });

    RussianValences() {
    }

    private static NominalArgument nominal(String arg, String presentable, NodePattern lexicalCondition) {
        Case caze;
        char last = arg.charAt(arg.length() - 1);
        Case case_ = last == '\u0418' ? Case.Nom : (last == '\u0420' ? Case.R : (last == '\u0414' ? Case.D : (last == '\u0412' ? Case.V : (last == '\u0422' ? Case.T : (caze = last == '\u041f' ? Case.P : null)))));
        if (caze == null) {
            throw new IllegalArgumentException("Can't parse " + arg);
        }
        return new NominalArgument(presentable, arg.length() == 1 ? null : arg.substring(0, arg.length() - 1), caze, lexicalCondition);
    }

    @NotNull
    static List<Valence> get(Node node) {
        LinkedHashSet<Valence> result2 = new LinkedHashSet<Valence>();
        boolean negated = negatedClause.matches(node);
        boolean genSubj = allowsGenSubj.matches(node);
        for (Tree.Reading reading : node.tokenReadings()) {
            List<Valence> valences;
            String pos = reading.pos();
            if (pos == null) {
                return List.of();
            }
            if (pos.startsWith("VB") || pos.startsWith("PT")) {
                valences = verbValences.get(reading.lemma());
                if (valences == null) {
                    return List.of();
                }
                for (Valence as2 : valences) {
                    if (genSubj) {
                        as2 = as2.append(NominalArgument.R);
                    }
                    if (withNomSubject.matcher(pos).matches()) {
                        as2 = as2.append(NominalArgument.NOM);
                        if (negated) {
                            as2 = as2.append(NominalArgument.R);
                        }
                    }
                    if (passiveParticiple.matcher(pos).matches()) {
                        as2 = as2.append(NominalArgument.NOM);
                        if (as2.arguments.contains(NominalArgument.V)) {
                            as2 = as2.withoutArg(NominalArgument.V);
                        }
                        as2 = as2.append(NominalArgument.T);
                    }
                    result2.add(as2);
                    if (!negated || !as2.arguments.contains(NominalArgument.V)) continue;
                    result2.add(as2.withoutArg(NominalArgument.V).append(NominalArgument.R));
                }
                continue;
            }
            if (pos.startsWith("NN")) {
                valences = nounValences.get(reading.lemma());
                if (valences == null) {
                    return List.of();
                }
                for (Valence as2 : valences) {
                    result2.add(as2.append(NominalArgument.R));
                }
                continue;
            }
            if (!pos.startsWith("ADJ")) continue;
            valences = adjValences.get(reading.lemma());
            if (valences == null) {
                return List.of();
            }
            if (RussianTreePatterns.clause.matches(node)) {
                valences = StreamEx.of(valences).map(as -> as.append(NominalArgument.NOM)).toList();
            }
            if (comparativeAdj.matches(node)) {
                valences = StreamEx.of((Collection)valences).map(as -> as.append(NominalArgument.R)).toList();
            }
            if (valences.isEmpty()) {
                throw new AssertionError();
            }
            result2.addAll(valences);
        }
        return new ArrayList<Valence>(result2);
    }

    static List<Case> prepositionCases(@Nullable Node prep, Argument argument) {
        return argument.destructure().toFlatList(a -> a instanceof NominalArgument && ((NominalArgument)a).prepositionMatches(prep) ? List.of(((NominalArgument)a).caze) : List.of());
    }

    static NodePattern withoutArgAround(String ... args) {
        NodePattern noArg = RussianValences.withoutArg(args);
        return noArg.andOr(RussianTreePatterns.clause, NodePattern.N.withHead("i?obj|obl.*", noArg));
    }

    static NodePattern withoutArg(String ... args) {
        HashSet<String> argSet = new HashSet<String>(List.of(args));
        return NodePattern.custom(node -> {
            List<Valence> valences = RussianValences.get(node);
            return !valences.isEmpty() && valences.stream().noneMatch(s -> s.hasAnyArgument(argSet));
        });
    }

    static class NominalArgument
    extends Argument {
        private static final Argument NOM = parser.arg("\u0418");
        private static final Argument V = parser.arg("\u0412");
        private static final Argument T = parser.arg("\u0422");
        private static final Argument R = parser.arg("\u0420");
        @Nullable
        final String preposition;
        final Case caze;
        private final NodePattern lexical;

        private NominalArgument(String presentable, @Nullable String preposition, Case caze, NodePattern lexical) {
            super(presentable, NodePattern.N.withHeadRelation("nsubj.*|i?obj|obl.*|nmod.*").and(NominalArgument.buildCasePattern(preposition, caze)).and(node -> NominalArgument.prepositionMatches(RussianTreePatterns.findOwnPreposition(node), preposition)));
            this.caze = caze;
            this.preposition = preposition;
            this.lexical = lexical;
        }

        private static NodePattern buildCasePattern(@Nullable String preposition, Case caze) {
            NodePattern pattern;
            NodePattern nodePattern = pattern = preposition == null ? caze.posPattern : NodePattern.or(caze.posPattern, NodePattern.N.noPos());
            if (caze.baseCase() != caze) {
                pattern = NodePattern.or(pattern, caze.baseCase().posPattern);
            }
            return pattern;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!super.equals(o)) {
                return false;
            }
            NominalArgument argument = (NominalArgument)o;
            return Objects.equals(this.preposition, argument.preposition) && this.caze == argument.caze;
        }

        @Override
        public boolean matchesLexically(Node node) {
            return this.lexical.matches(node);
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 31 + Objects.hash(new Object[]{this.preposition, this.caze});
        }

        private boolean prepositionMatches(@Nullable Node prep) {
            return NominalArgument.prepositionMatches(prep, this.preposition);
        }

        private static boolean prepositionMatches(@Nullable Node prep, @Nullable String expected) {
            return prep != null ? prep.allDependents().isEmpty() && RussianTreePatterns.normalizePreposition(prep.lowForm()).equals(expected) : expected == null;
        }
    }
}

