/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.settings;

import ai.grazie.rules.RuleClient;
import ai.grazie.rules.util.YamlParsingUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import one.util.streamex.StreamEx;
import org.yaml.snakeyaml.composer.Composer;
import org.yaml.snakeyaml.nodes.CollectionNode;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;

public record TextStyle(String id, Map<String, String> paramValues, Set<String> enabledRules, Set<String> disabledRules) {
    private static final String UNSPECIFIED_ID = "Unspecified";
    private static final Map<String, TextStyle> commonStyles = StreamEx.of((Object[])new String[]{"Informal", "Unspecified", "Public", "Formal", "Academic"}).mapToEntry(TextStyle::loadFrom).toCustomMap(LinkedHashMap::new);
    private static final Map<String, TextStyle> desktopOnlyStyles = StreamEx.of((Object[])new String[]{"GoogleDeveloperDocumentation", "Microsoft"}).mapToEntry(TextStyle::loadFrom).toCustomMap(LinkedHashMap::new);
    private static final Map<String, TextStyle> ideOnlyStyles = StreamEx.of((Object[])new String[]{"Commit", "CodeComment", "CodeDocumentation", "AIChat"}).mapToEntry(TextStyle::loadFrom).toCustomMap(LinkedHashMap::new);
    public static final TextStyle Unspecified = commonStyles.get("Unspecified");

    public static List<TextStyle> styles(RuleClient client) {
        ArrayList<TextStyle> result2 = new ArrayList<TextStyle>(commonStyles.values());
        if (client.showIdeStyles()) {
            result2.addAll(ideOnlyStyles.values());
        }
        if (client.showValeDependentStyles()) {
            result2.addAll(desktopOnlyStyles.values());
        }
        return result2;
    }

    private static TextStyle loadFrom(String id) {
        TextStyle textStyle;
        block15: {
            String path = "styles/" + id + ".yaml";
            InputStream stream = TextStyle.class.getClassLoader().getResourceAsStream(path);
            try {
                CollectionNode ruleSet;
                if (stream == null) {
                    throw new IllegalStateException("Can't find " + path);
                }
                HashMap<String, String> paramValues = new HashMap<String, String>();
                HashSet<String> enabledRules = new HashSet<String>();
                HashSet<String> disabledRules = new HashSet<String>();
                Composer composer = YamlParsingUtil.parseYaml(stream, StandardCharsets.UTF_8);
                Map<String, Node> root = YamlParsingUtil.asMap((MappingNode)composer.getSingleNode());
                if (!id.equals(YamlParsingUtil.asScalar(root.get("id")))) {
                    throw new IllegalArgumentException("The style profile ID must be equal to its file name: " + path);
                }
                MappingNode parameters = (MappingNode)root.get("parameters");
                if (parameters != null) {
                    for (NodeTuple tuple : parameters.getValue()) {
                        paramValues.put(YamlParsingUtil.asScalar(tuple.getKeyNode()), YamlParsingUtil.asScalar(tuple.getValueNode()));
                    }
                }
                if ((ruleSet = (CollectionNode)root.get("rule-set")) != null) {
                    for (MappingNode entry2 : ruleSet.getValue()) {
                        String disable;
                        Map<String, Node> map2 = YamlParsingUtil.asMap(entry2);
                        String enable = YamlParsingUtil.asScalar(map2.get("enable"));
                        if (enable != null) {
                            enabledRules.add(enable);
                        }
                        if ((disable = YamlParsingUtil.asScalar(map2.get("disable"))) == null) continue;
                        disabledRules.add(disable);
                    }
                }
                textStyle = new TextStyle(id, Collections.unmodifiableMap(paramValues), Collections.unmodifiableSet(enabledRules), Collections.unmodifiableSet(disabledRules));
                if (stream == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return textStyle;
    }

    public boolean isRuleEnabled(String globalId, Supplier<Boolean> enabledByDefault) {
        return this.enabledRules.contains(globalId) || !this.disabledRules.contains(globalId) && enabledByDefault.get() != false;
    }
}

