/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.toolkit;

import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.Tree;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

public abstract class StructuralWrapper {
    public List<RangeToWrap> getSyntacticWraps(Tree tree) {
        Node node;
        Node next;
        ArrayList<RangeToWrap> result2 = new ArrayList<RangeToWrap>();
        int nesting = 0;
        List<Node> nodes = tree.nodes();
        Node trailingParenthesis = null;
        if (!nodes.isEmpty()) {
            Node last = nodes.get(nodes.size() - 1);
            if (last.hasForm("[.?!]")) {
                last = last.prevNode();
            }
            if (last != null && last.hasForm("\\)")) {
                trailingParenthesis = ((StreamEx)((StreamEx)last.back().skip(1L)).takeWhile(n -> !n.hasForm("\\)"))).findFirst(n -> n.hasForm("\\(")).orElse(null);
            }
        }
        Iterator<Node> iterator = nodes.iterator();
        while (iterator.hasNext() && (next = (node = iterator.next()).nextNode()) != null) {
            Node clause2;
            Node prev = node.prevNode();
            if (this.isPunctuation(node)) {
                if (prev == null || StructuralWrapper.isDashInsideWord(node, next, prev)) continue;
                result2.add(new RangeToWrap(node.endOffset(), nesting + (this.findClauseBoundary(prev, next, ".*") != null ? 0 : 1)));
                continue;
            }
            if ("(".equals(node.form())) {
                if (node != trailingParenthesis) {
                    nesting += 2;
                }
                if (prev == null) continue;
                result2.add(new RangeToWrap(prev.endOffset(), nesting));
                continue;
            }
            if (")".equals(node.form())) {
                if (!next.hasHeadRelation("punct")) {
                    result2.add(new RangeToWrap(node.endOffset(), nesting));
                }
                nesting = Math.max(0, nesting - 2);
                continue;
            }
            if (this.isPunctuation(next) || (clause2 = this.findClauseBoundary(node, next, "conj|xcomp|ccomp|acl.*|advcl")) == null) continue;
            int depth = (int)clause2.hierarchy().count();
            if (clause2.hasHeadRelation("conj")) {
                --depth;
            }
            result2.add(new RangeToWrap(node.endOffset(), 3 + depth));
        }
        return result2;
    }

    private static boolean isDashInsideWord(Node node, Node next, Node prev) {
        return node.hasForm("-") && prev.endOffset() + 1 == next.startOffset();
    }

    protected abstract boolean isPunctuation(Node var1);

    @Nullable
    private Node findClauseBoundary(Node node1, Node node2, String clauseRelations) {
        Set headsBefore = (Set)((StreamEx)node1.hierarchy().takeWhile(n -> n.isBefore(node2))).collect(Collectors.toSet());
        for (Node n2 : (List)((StreamEx)node2.hierarchy().takeWhile(n -> n.isAfter(node1))).collect(Collectors.toList())) {
            if (!n2.hasHeadRelation(clauseRelations) || n2.tree().crazyParseNodes().getCrazyMessage(n2) != null || !this.isClauseLike(n2)) continue;
            Node head = n2.head();
            Node c2Start = n2.phraseStart();
            if (head == null || !headsBefore.contains(head) || StructuralWrapper.nodesBetween(head.phraseStart(), c2Start) <= 0L || StructuralWrapper.nodesBetween(c2Start, n2.phraseEnd()) <= 0L) continue;
            return n2;
        }
        return null;
    }

    protected abstract boolean isClauseLike(Node var1);

    private static long nodesBetween(Node c2Start, Node c2End) {
        return c2Start.nextUntil(c2End).count();
    }

    public static class RangeToWrap {
        public final int offset;
        public final int priority;

        public RangeToWrap(int offset, int priority) {
            this.offset = offset;
            this.priority = priority;
            if (priority < 0) {
                throw new AssertionError((Object)(priority + " < 0"));
            }
        }

        public String toString() {
            return "RangeToWrap{offset=" + this.offset + ", priority=" + this.priority + "}";
        }
    }
}

