/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.tree;

import ai.grazie.gec.model.problem.ProblemFix;
import ai.grazie.rules.NodeRuleMatch;
import ai.grazie.rules.Rule;
import ai.grazie.rules.RuleMatch;
import ai.grazie.rules.document.Metadata;
import ai.grazie.rules.tree.AccessedParameters;
import ai.grazie.rules.tree.ActionSuggestion;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.ReportingKind;
import ai.grazie.rules.tree.StubbedSentence;
import ai.grazie.rules.tree.TextChange;
import ai.grazie.rules.tree.TextRange;
import ai.grazie.rules.tree.Tree;
import ai.grazie.rules.tree.UnformattedChange;
import ai.grazie.rules.util.CharUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntConsumer;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeMatch {
    public static final NodeMatch EMPTY = new NodeMatch(null, Set.of(), List.of(), Map.of(), List.of(), null, null, List.of(), false, false, false, "", null, Metadata.EMPTY);
    private static final Set<Node> NO_TOUCHING = Collections.unmodifiableSet(new HashSet());
    static final NodeMatch EMPTY_NO_TOUCHING = new NodeMatch(null, NO_TOUCHING, List.of(), Map.of(), List.of(), null, null, List.of(), false, false, false, "", null, Metadata.EMPTY);
    private final Node anchor;
    private final Set<Node> touchedNodes;
    @ApiStatus.Internal
    public final List<ReportedRange> _reportedRanges;
    private final Map<String, Node> id2Node;
    private final List<NodeCorrector> correctors;
    public final Metadata metadata;
    @Nullable
    private final String message;
    @Nullable
    public final SuppressableKind suppressableKind;
    @NotNull
    public final List<ActionSuggestion> actions;
    public final boolean autoFixCapable;
    public final boolean hasLowConfidence;
    public final boolean concedeToOtherGrammarCheckers;
    @NotNull
    public final String traceLog;
    @Nullable
    public final String preventedBy;
    private volatile List<TextRange> reportedRanges;
    private volatile TextRange replacementRange;
    private volatile List<RawFix> _rawFixes;
    private volatile List<ProblemFix> fixes;

    NodeMatch(Node anchor, Set<Node> touchedNodes, List<ReportedRange> _reportedRanges, Map<String, Node> id2Node, List<NodeCorrector> correctors, @Nullable String message, @Nullable SuppressableKind suppressableKind, @NotNull List<ActionSuggestion> actions, boolean autoFixCapable, boolean hasLowConfidence, boolean concedeToOtherGrammarCheckers, @NotNull String traceLog, @Nullable String preventedBy, Metadata metadata) {
        this.anchor = anchor;
        this.touchedNodes = touchedNodes;
        this._reportedRanges = _reportedRanges;
        this.id2Node = id2Node;
        this.correctors = correctors;
        this.message = message;
        this.suppressableKind = suppressableKind;
        this.actions = actions;
        this.autoFixCapable = autoFixCapable;
        this.hasLowConfidence = hasLowConfidence;
        this.concedeToOtherGrammarCheckers = concedeToOtherGrammarCheckers;
        this.traceLog = traceLog;
        this.preventedBy = preventedBy;
        this.metadata = metadata;
    }

    @NotNull
    public Node getMarkedNode(@NotNull String id) {
        Node node = this.findMarkedNode(id);
        if (node == null) {
            throw new NullPointerException("Cannot find node marked " + id);
        }
        return node;
    }

    @Nullable
    public Node findMarkedNode(@NotNull String id) {
        return this.id2Node.get(id);
    }

    @NotNull
    public NodeMatch withCorrectors(@NotNull List<NodeCorrector> correctors) {
        if (correctors.isEmpty()) {
            return this;
        }
        ArrayList<NodeCorrector> copy = new ArrayList<NodeCorrector>(this.correctors);
        copy.addAll(correctors);
        return new NodeMatch(this.anchor, this.touchedNodes, this._reportedRanges, this.id2Node, copy, this.message, this.suppressableKind, this.actions, this.autoFixCapable, this.hasLowConfidence, this.concedeToOtherGrammarCheckers, this.traceLog, this.preventedBy, this.metadata);
    }

    @NotNull
    public NodeMatch withCorrector(@Nullable NodeCorrector corrector) {
        return corrector == null ? this : this.withCorrectors(List.of(corrector));
    }

    @NotNull
    public NodeMatch withMarkedNode(@NotNull String id, @Nullable Node node) {
        HashMap<String, Node> map2 = new HashMap<String, Node>(this.id2Node);
        if (node != null) {
            Node prev = map2.put(id, node);
            assert (prev == null) : "There's already a node marked as " + id + ": " + prev + "; can't mark as such " + node;
        } else {
            Node prev = map2.remove(id);
            assert (prev != null) : "There's no node marked as " + id;
        }
        return new NodeMatch(this.anchor, this.touchedNodes, this._reportedRanges, map2, this.correctors, this.message, this.suppressableKind, this.actions, this.autoFixCapable, this.hasLowConfidence, this.concedeToOtherGrammarCheckers, this.traceLog, this.preventedBy, this.metadata);
    }

    @NotNull
    public NodeMatch withAnchor(@NotNull Node node) {
        if (node == this.anchor) {
            return this;
        }
        return new NodeMatch(node, this.touchedNodes, this._reportedRanges, this.id2Node, this.correctors, this.message, this.suppressableKind, this.actions, this.autoFixCapable, this.hasLowConfidence, this.concedeToOtherGrammarCheckers, this.traceLog, this.preventedBy, this.metadata);
    }

    @NotNull
    public NodeMatch withTouchedNode(@Nullable Node node) {
        if (node == null || this.touchedNodes == NO_TOUCHING || this.touchedNodes.contains(node)) {
            return this;
        }
        HashSet<Node> set = new HashSet<Node>(this.touchedNodes);
        set.add(node);
        return new NodeMatch(node, set, this._reportedRanges, this.id2Node, this.correctors, this.message, this.suppressableKind, this.actions, this.autoFixCapable, this.hasLowConfidence, this.concedeToOtherGrammarCheckers, this.traceLog, this.preventedBy, this.metadata);
    }

    @NotNull
    public NodeMatch withTouchedNodes(Node ... nodes) {
        return this.withTouchedNodes(Arrays.asList(nodes));
    }

    @NotNull
    public NodeMatch withTouchedNodes(Iterable<@Nullable Node> nodes) {
        NodeMatch result2 = this;
        for (Node node : nodes) {
            result2 = result2.withTouchedNode(node);
        }
        return result2;
    }

    @NotNull
    public NodeMatch withReportedNode(@Nullable Node node) {
        return this.withReportedNode(node, ReportingKind.Always);
    }

    @NotNull
    public NodeMatch withReportedNode(@Nullable Node node, ReportingKind kind) {
        if (node == null) {
            return this;
        }
        return this.withReportedRange(node.textRange(), node.tree(), kind).withTouchedNode(node);
    }

    @NotNull
    public NodeMatch withReportedNodes(Node ... nodes) {
        return this.withReportedNodes(Arrays.asList(nodes));
    }

    @NotNull
    public NodeMatch withReportedNodes(Iterable<@Nullable Node> nodes) {
        return this.withReportedNodes(nodes, ReportingKind.Always);
    }

    @NotNull
    public NodeMatch withReportedNodes(Iterable<@Nullable Node> nodes, ReportingKind kind) {
        NodeMatch result2 = this;
        for (Node node : nodes) {
            result2 = result2.withReportedNode(node, kind);
        }
        return result2;
    }

    @NotNull
    public NodeMatch withSuppressableKind(@NotNull SuppressableKind suppressableKind) {
        return new NodeMatch(this.anchor, this.touchedNodes, this._reportedRanges, this.id2Node, this.correctors, this.message, suppressableKind, this.actions, this.autoFixCapable, this.hasLowConfidence, this.concedeToOtherGrammarCheckers, this.traceLog, this.preventedBy, this.metadata);
    }

    @NotNull
    public NodeMatch withActions(ActionSuggestion ... suggestions) {
        List newList = ((StreamEx)StreamEx.of(this.actions).append((Object[])suggestions).distinct()).toList();
        return new NodeMatch(this.anchor, this.touchedNodes, this._reportedRanges, this.id2Node, this.correctors, this.message, this.suppressableKind, newList, this.autoFixCapable, this.hasLowConfidence, this.concedeToOtherGrammarCheckers, this.traceLog, this.preventedBy, this.metadata);
    }

    @NotNull
    public NodeMatch enableAutoFix() {
        return new NodeMatch(this.anchor, this.touchedNodes, this._reportedRanges, this.id2Node, this.correctors, this.message, this.suppressableKind, this.actions, true, this.hasLowConfidence, this.concedeToOtherGrammarCheckers, this.traceLog, this.preventedBy, this.metadata);
    }

    @NotNull
    public NodeMatch concedingToOtherGrammarCheckers() {
        return new NodeMatch(this.anchor, this.touchedNodes, this._reportedRanges, this.id2Node, this.correctors, this.message, this.suppressableKind, this.actions, this.autoFixCapable, this.hasLowConfidence, true, this.traceLog, this.preventedBy, this.metadata);
    }

    @NotNull
    public NodeMatch withLowConfidence() {
        return new NodeMatch(this.anchor, this.touchedNodes, this._reportedRanges, this.id2Node, this.correctors, this.message, this.suppressableKind, this.actions, this.autoFixCapable, true, this.concedeToOtherGrammarCheckers, this.traceLog, this.preventedBy, this.metadata);
    }

    public NodeMatch withMessage(@NotNull String message) {
        if (this.message != null) {
            throw new IllegalStateException("Message already set to " + this.message);
        }
        if (message.isEmpty()) {
            throw new IllegalArgumentException("The message cannot be empty");
        }
        char last = message.charAt(message.length() - 1);
        if (CharUtil.isAnyOf(",.:;", last) && !NodeMatch.hasSeveralDots(message)) {
            throw new IllegalArgumentException("Single-sentence messages should not end with " + last + ": " + message);
        }
        return new NodeMatch(this.anchor, this.touchedNodes, this._reportedRanges, this.id2Node, this.correctors, message, this.suppressableKind, this.actions, this.autoFixCapable, this.hasLowConfidence, this.concedeToOtherGrammarCheckers, this.traceLog, this.preventedBy, this.metadata);
    }

    NodeMatch trace(String debugName) {
        String trace = this.traceLog.isEmpty() ? debugName : this.traceLog + ", " + debugName;
        return new NodeMatch(this.anchor, this.touchedNodes, this._reportedRanges, this.id2Node, this.correctors, this.message, this.suppressableKind, this.actions, this.autoFixCapable, this.hasLowConfidence, this.concedeToOtherGrammarCheckers, trace, this.preventedBy, this.metadata);
    }

    NodeMatch preventedBy(@Nullable String trace) {
        return new NodeMatch(this.anchor, this.touchedNodes, this._reportedRanges, this.id2Node, this.correctors, this.message, this.suppressableKind, this.actions, this.autoFixCapable, this.hasLowConfidence, this.concedeToOtherGrammarCheckers, this.traceLog, trace, this.metadata);
    }

    public <T> NodeMatch withMetadata(Metadata.Key<T> key, @NotNull T data2) {
        return new NodeMatch(this.anchor, this.touchedNodes, this._reportedRanges, this.id2Node, this.correctors, this.message, this.suppressableKind, this.actions, this.autoFixCapable, this.hasLowConfidence, this.concedeToOtherGrammarCheckers, this.traceLog, this.preventedBy, this.metadata.with(key, data2));
    }

    private static boolean hasSeveralDots(String message) {
        return message.endsWith(".") && message.substring(0, message.length() - 1).contains(".");
    }

    NodeMatch withoutMessage() {
        if (this.message == null) {
            return this;
        }
        return new NodeMatch(this.anchor, this.touchedNodes, this._reportedRanges, this.id2Node, this.correctors, null, this.suppressableKind, this.actions, this.autoFixCapable, this.hasLowConfidence, this.concedeToOtherGrammarCheckers, this.traceLog, this.preventedBy, this.metadata);
    }

    public List<TextRange> reportedRanges() {
        List<TextRange> result2 = this.reportedRanges;
        if (result2 == null) {
            result2 = this.explicitlyReportedRanges(ReportingKind.Always);
            if (result2.isEmpty()) {
                List changeRanges = this.changeRanges(this.calcCorrectionChanges()).toList();
                result2 = List.of(this.expandToWholeWord(this.removeEdgeSpace(changeRanges.isEmpty() ? NodeMatch.absoluteRange(this.anchor) : TextRange.spanRanges((Stream<TextRange>)StreamEx.of((Collection)changeRanges)))));
            }
            this.reportedRanges = result2;
        }
        return result2;
    }

    private TextRange removeEdgeSpace(TextRange range) {
        if (range.length() >= 3) {
            String highlighted = range.shiftLeft(this.anchor.tree().startOffset()).substring(this.anchor.tree().text());
            if (highlighted.matches(" \\S.*\\S")) {
                return new TextRange(range.start() + 1, range.end());
            }
            if (highlighted.matches("\\S.*\\S ")) {
                return new TextRange(range.start(), range.end() - 1);
            }
        }
        return range;
    }

    private static List<TextRange> spanReportedRanges(List<ReportedRange> ranges) {
        return ((StreamEx)StreamEx.of(ranges).sortedByInt(p -> p.range.start())).groupRuns((p1, p2) -> {
            TextRange r1 = p1.range;
            TextRange r2 = p2.range;
            Tree tree1 = p1.tree;
            return r1.touches(r2) || tree1 == p2.tree && NodeMatch.isWhiteSpaceAway(tree1, r1.end(), r2.start());
        }).map(pairs -> TextRange.spanRanges(pairs.stream().map(ReportedRange::range))).toList();
    }

    public NodeMatch withReportedRange(int start, int end, Tree tree) {
        return this.withReportedRange(new TextRange(start, end), tree);
    }

    public NodeMatch withReportedRange(TextRange range, Tree tree) {
        return this.withReportedRange(range, tree, ReportingKind.Always);
    }

    public NodeMatch withReportedRange(TextRange range, Tree tree, ReportingKind kind) {
        if (range.length() == 0) {
            return this;
        }
        ArrayList<ReportedRange> list = new ArrayList<ReportedRange>(this._reportedRanges);
        list.add(new ReportedRange(range.shiftRight(tree.startOffset()), tree, kind));
        return new NodeMatch(this.anchor, this.touchedNodes, list, this.id2Node, this.correctors, this.message, this.suppressableKind, this.actions, this.autoFixCapable, this.hasLowConfidence, this.concedeToOtherGrammarCheckers, this.traceLog, this.preventedBy, this.metadata);
    }

    private static boolean isWhiteSpaceAway(Tree tree, int start, int end) {
        if (start >= end) {
            return false;
        }
        int treeStart = tree.startOffset();
        return NodeMatch.isWhiteSpaceAway(tree.text(), start - treeStart, end - treeStart);
    }

    public static boolean isWhiteSpaceAway(String text2, int start, int end) {
        return start >= 0 && end <= text2.length() && text2.substring(start, end).chars().allMatch(c -> CharUtil.isAnySpace((char)c));
    }

    private static TextRange absoluteRange(Node node) {
        return node.textRange().shiftRight(node.tree().startOffset());
    }

    public TextRange replacementRange() {
        TextRange result2 = this.replacementRange;
        if (result2 == null) {
            this.replacementRange = result2 = this.calcReplacementRange();
        }
        return result2;
    }

    private TextRange calcReplacementRange() {
        if (!this.correctors.isEmpty()) {
            return this.expandToWholeWord(TextRange.spanRanges((Stream<TextRange>)((StreamEx)StreamEx.of(this.rawFixes()).map(f -> f.change.changedRange()).append(this.correctors.stream().map(c -> c.calcChangeRange().shiftRight(this.anchor.tree().startOffset())))).sortedByInt(TextRange::start)));
        }
        return this.expandToWholeWord(NodeMatch.absoluteRange(this.anchor));
    }

    private TextRange expandToWholeWord(TextRange range) {
        Node next;
        int end;
        Node token;
        Tree tree = this.anchor.tree();
        int start = range.start() - tree.startOffset();
        Node node = token = start == (end = range.end() - tree.startOffset()) ? tree.findBestNodeAt(start) : tree.findNodeAt(start);
        if (token != null) {
            if (start == end) {
                start = token.startOffset();
                end = token.endOffset();
            }
            next = token.nextNode();
            if (token.textRange().containsExclusive(start) || next != null && NodeMatch.formOneWord(token, next)) {
                start = token.startOffset();
            }
            if (start == token.startOffset()) {
                Node prev;
                while ((prev = token.prevNode()) != null && prev.endOffset() >= token.startOffset() && !NodeMatch.isPunctuation(prev)) {
                    token = prev;
                    start = token.startOffset();
                }
            }
        }
        if ((token = tree.findNodeAt(end)) != null) {
            if (token.textRange().containsExclusive(end)) {
                end = token.endOffset();
            }
            if (end == token.endOffset()) {
                while ((next = token.nextNode()) != null && next.startOffset() <= token.endOffset() && !NodeMatch.isPunctuation(next)) {
                    token = next;
                    end = token.endOffset();
                }
            }
        }
        return new TextRange(start, end).shiftRight(tree.startOffset());
    }

    private static boolean isPunctuation(Node node) {
        return node.form().chars().noneMatch(Character::isLetterOrDigit);
    }

    private static boolean formOneWord(Node n1, Node n2) {
        return n1.endOffset() == n2.startOffset() && n1.form().chars().anyMatch(Character::isLetterOrDigit) && n2.form().chars().anyMatch(Character::isLetterOrDigit);
    }

    public TextRange touchedRange() {
        return TextRange.spanRanges((Stream<TextRange>)StreamEx.of(this.allTouchedNodes()).append((Object)this.anchor).map(NodeMatch::absoluteRange).append(this.reportedRanges()).append((Object)this.replacementRange()));
    }

    @ApiStatus.Internal
    public List<RawFix> rawFixes() {
        List<RawFix> result2 = this._rawFixes;
        if (result2 == null) {
            this._rawFixes = result2 = this.calcRawFixes();
        }
        return result2;
    }

    private List<RawFix> calcRawFixes() {
        if (this.correctors.isEmpty()) {
            return List.of();
        }
        Tree tree = this.anchor.tree();
        int treeStart = tree.startOffset();
        String text2 = tree.text();
        LinkedHashSet<RawFix> rawFixes = new LinkedHashSet<RawFix>();
        for (NodeCorrector corrector : this.correctors) {
            ArrayList<TextChange> changes = new ArrayList<TextChange>();
            for (UnformattedChange c : corrector.calcSuggestions(text2)) {
                TextChange tc = c.formatChange(tree);
                if (!tc.changesAnything(text2)) continue;
                changes.add(treeStart == 0 ? tc : tc.mapOffsets(i -> i + treeStart));
            }
            for (TextChange change : changes) {
                rawFixes.add(new RawFix(change, changes.size() == 1 ? corrector.getBatchId(tree) : null, corrector.getCustomDisplayName()));
            }
        }
        return new ArrayList<RawFix>(rawFixes);
    }

    static boolean isVisible(NodeMatch match) {
        return match != null && match.preventedBy == null;
    }

    @NotNull
    static String appendPrevention(String preventedBy, NodeMatch match) {
        return preventedBy == null ? Objects.requireNonNull(match.preventedBy) : preventedBy + " && " + match.preventedBy;
    }

    public List<TextChange> calcCorrectionChanges() {
        return this.rawFixes().stream().map(RawFix::change).toList();
    }

    public List<ProblemFix> problemFixes() {
        List<ProblemFix> fixes = this.fixes;
        if (fixes == null) {
            this.fixes = fixes = this.calcProblemFixes();
        }
        return fixes;
    }

    private List<ProblemFix> calcProblemFixes() {
        List<RawFix> rawFixes = this.rawFixes();
        if (rawFixes.isEmpty()) {
            return List.of();
        }
        Tree tree = this.anchor.tree();
        int treeStart = tree.startOffset();
        String text2 = tree.text();
        List<TextRange> contextRanges = this.allContextRanges(Lists.transform(rawFixes, RawFix::change), treeStart, text2);
        return rawFixes.stream().map(fix -> {
            Map context2Replacements = StreamEx.of(fix.change.changes()).groupingBy(repl -> (TextRange)StreamEx.of((Collection)contextRanges).findFirst(cr -> cr.containsInclusive(repl.range())).orElseThrow());
            ArrayList<ProblemFix.Part> parts = new ArrayList<ProblemFix.Part>();
            for (int i = 0; i < contextRanges.size(); ++i) {
                if (i > 0) {
                    parts.add(new ProblemFix.Part.Skip());
                }
                TextRange range = (TextRange)contextRanges.get(i);
                parts.addAll(NodeMatch.contextFixParts(treeStart, text2, range, context2Replacements.getOrDefault(range, List.of())));
            }
            return new ProblemFix((ProblemFix.Part[])parts.toArray(ProblemFix.Part[]::new), fix.batchId, fix.customDisplayName);
        }).toList();
    }

    private static List<ProblemFix.Part> contextFixParts(final int treeStart, final String sentence, final TextRange contextRange, List<TextChange.Replacement> replacements) {
        final ArrayList<ProblemFix.Part> parts = new ArrayList<ProblemFix.Part>();
        var addContext = new IntConsumer(){
            int contextStart;
            {
                this.contextStart = contextRange.start();
            }

            @Override
            public void accept(int end) {
                if (end > this.contextStart) {
                    parts.add(new ProblemFix.Part.Context(sentence.substring(this.contextStart - treeStart, end - treeStart)));
                }
            }
        };
        for (TextChange.Replacement replacement : replacements) {
            addContext.accept(replacement.range().start());
            parts.add(replacement.toProblemChange());
            addContext.contextStart = replacement.range().end();
        }
        addContext.accept(contextRange.end());
        return parts;
    }

    private List<TextRange> allContextRanges(Collection<TextChange> changes, int treeStart, String sentence) {
        TextRange sentenceRange = TextRange.fromLength(treeStart, sentence.length());
        StreamEx relevant = (StreamEx)this.changeRanges(changes).append(this.explicitlyReportedRanges(ReportingKind.Always).stream().filter(sentenceRange::containsInclusive));
        return TextRange.mergeConditionally((Stream<TextRange>)relevant, (prev, next) -> next.start() - prev.end() <= 10);
    }

    private StreamEx<TextRange> changeRanges(Collection<TextChange> changes) {
        return StreamEx.of(changes).flatCollection(TextChange::changes).map(r -> this.expandToWholeWord(r.range()));
    }

    public Set<Node> allTouchedNodes() {
        return this.touchedNodes;
    }

    public String toString() {
        List<String> corrections;
        if (this.anchor == null) {
            corrections = List.of("???");
        } else {
            String sentence = " ".repeat(this.anchor.tree().startOffset()) + this.anchor.tree().text();
            TextRange range = this.replacementRange();
            corrections = this.calcCorrectionChanges().stream().map(c -> c.performOnRange(sentence, range)).distinct().toList();
        }
        return "NodeMatch{anchor=" + this.anchor + (String)(this.traceLog.isEmpty() ? "" : ", trace='" + this.traceLog + "'") + (String)(this.preventedBy == null ? "" : ", overriddenBy='" + this.preventedBy + "'") + ", message='" + this.message + "', corrections='" + corrections + "'}";
    }

    public List<TextRange> hoverReportedRanges() {
        return TextRange.mergeConditionally((Stream<TextRange>)StreamEx.of(this.reportedRanges()).append(this.explicitlyReportedRanges(ReportingKind.Hover)), TextRange::touches);
    }

    public List<TextRange> explicitlyReportedRanges(ReportingKind kind) {
        if (this._reportedRanges.isEmpty()) {
            return List.of();
        }
        List<ReportedRange> filtered = this._reportedRanges.stream().filter(r -> r.kind == kind).toList();
        if (filtered.isEmpty()) {
            return List.of();
        }
        if (filtered.size() == 1) {
            return List.of(filtered.get((int)0).range);
        }
        return NodeMatch.spanReportedRanges(filtered);
    }

    public static List<? extends RuleMatch> matchAll(Rule rule, Tree tree, NodePattern pattern) {
        String prevId;
        AccessedParameters current = AccessedParameters.current();
        String string = prevId = current == null ? null : current.ruleId;
        if (current != null) {
            current.ruleId = rule.id;
        }
        try {
            List list = ((StreamEx)StreamEx.of(tree.nodes()).map(node -> pattern.matchWithPrevention((Node)node, EMPTY)).filter(Objects::nonNull)).map(m -> new NodeRuleMatch(rule, m.checkStubbedEquivalent(pattern))).toList();
            return list;
        }
        catch (Throwable t) {
            throw new RuntimeException("While processing " + rule.id + " in " + tree.language(), t);
        }
        finally {
            if (current != null) {
                current.ruleId = prevId;
            }
        }
    }

    @NotNull
    public NodeMatch checkStubbedEquivalent(NodePattern pattern) {
        StubbedSentence stubbed = this.anchor.tree().stubbed;
        if (stubbed != null && !pattern.matches(stubbed.findStubbedEquivalent(this.anchor))) {
            return this.preventedBy("No equivalent in the stubbed tree");
        }
        return this;
    }

    public Node anchor() {
        return this.anchor;
    }

    public String message() {
        return this.message;
    }

    public List<NodeCorrector> correctors() {
        return this.correctors;
    }

    public Set<Node> touchedNodes() {
        return this.touchedNodes;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        NodeMatch that = (NodeMatch)obj;
        return Objects.equals(this.anchor, that.anchor) && Objects.equals(this.touchedNodes, that.touchedNodes) && Objects.equals(this._reportedRanges, that._reportedRanges) && Objects.equals(this.id2Node, that.id2Node) && Objects.equals(this.correctors, that.correctors) && Objects.equals(this.message, that.message) && Objects.equals((Object)this.suppressableKind, (Object)that.suppressableKind) && Objects.equals(this.actions, that.actions) && Objects.equals(this.traceLog, that.traceLog) && Objects.equals(this.preventedBy, that.preventedBy) && this.hasLowConfidence == that.hasLowConfidence && this.concedeToOtherGrammarCheckers == that.concedeToOtherGrammarCheckers && this.autoFixCapable == that.autoFixCapable;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.anchor, this.touchedNodes, this._reportedRanges, this.id2Node, this.correctors, this.message, this.suppressableKind, this.actions, this.autoFixCapable, this.hasLowConfidence, this.concedeToOtherGrammarCheckers, this.traceLog, this.preventedBy});
    }

    public static enum SuppressableKind {
        UPPERCASE_SENTENCE_START,
        INCOMPLETE_SENTENCE,
        UNFINISHED_SENTENCE,
        UNDECORATED_SENTENCE_SEPARATION,
        UNLIKELY_OPENING_PUNCTUATION;

    }

    @ApiStatus.Internal
    public record ReportedRange(TextRange range, Tree tree, ReportingKind kind) {
    }

    @ApiStatus.Internal
    public record RawFix(TextChange change, @Nullable String batchId, @Nullable String customDisplayName) {
    }
}

