/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.tree;

import ai.grazie.gec.model.problem.ProblemFix;
import ai.grazie.rules.tree.TextRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.IntUnaryOperator;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class TextChange {
    public static final TextChange EMPTY = new TextChange(Collections.emptyList());
    @TestOnly
    public static boolean diagnoseIntersections = false;
    private final List<Replacement> changes;

    TextChange(Replacement replacement) {
        this.changes = List.of(replacement);
    }

    TextChange(List<Replacement> changes) {
        this.changes = TextChange.sortReplacements((StreamEx<Replacement>)StreamEx.of(changes)).toList();
        if (diagnoseIntersections) {
            for (int i = 0; i < changes.size() - 1; ++i) {
                Replacement r1 = changes.get(i);
                Replacement r2 = changes.get(i + 1);
                if (r1.range.end() < r2.range.start()) continue;
                throw new IllegalArgumentException("Intersecting changes: " + changes);
            }
        }
    }

    public List<Replacement> changes() {
        return this.changes;
    }

    boolean changesAnything(String text2) {
        return this.changes.stream().anyMatch(r -> !r.replacement.equals(r.range.substring(text2)));
    }

    public static TextChange replace(TextRange range, String replacement) {
        return new TextChange(Collections.singletonList(new Replacement(range, replacement)));
    }

    public static TextChange replace(int startOffset, int endOffset, String replacement) {
        return TextChange.replace(new TextRange(startOffset, endOffset), replacement);
    }

    public static TextChange insert(int offset, String toInsert) {
        return TextChange.replace(offset, offset, toInsert);
    }

    public TextChange and(@NotNull TextChange another) {
        return this.and(another, null);
    }

    TextChange and(@NotNull TextChange another, @Nullable String textBefore) {
        return TextChange.mergeReplacements(textBefore, (StreamEx<Replacement>)StreamEx.of(this.changes).append(another.changes));
    }

    static TextChange mergeReplacements(@Nullable String textBefore, StreamEx<Replacement> replacements) {
        return new TextChange(TextChange.mergeReplacements(replacements, (Replacement r1, Replacement r2) -> r1.merge((Replacement)r2, textBefore)));
    }

    static List<Replacement> mergeReplacements(StreamEx<Replacement> replacements, BiFunction<Replacement, Replacement, Replacement> merge) {
        ArrayList<Replacement> joined = new ArrayList<Replacement>();
        for (Replacement next : TextChange.sortReplacements(replacements)) {
            if (joined.isEmpty()) {
                joined.add(next);
                continue;
            }
            Replacement prev = (Replacement)joined.get(joined.size() - 1);
            Replacement merged = merge.apply(prev, next);
            if (merged != null) {
                joined.set(joined.size() - 1, merged);
                continue;
            }
            joined.add(next);
        }
        return joined;
    }

    private static StreamEx<Replacement> sortReplacements(StreamEx<Replacement> replacements) {
        return (StreamEx)replacements.sorted(Comparator.comparing(r -> r.range.start()).thenComparing(r -> r.range.end()));
    }

    public TextChange mapOffsets(IntUnaryOperator mapper) {
        return new TextChange(this.changes.stream().map(r -> new Replacement(r.range.mapOffsets(mapper), r.replacement)).toList());
    }

    public String perform(String string) {
        for (Replacement change : this.reverseChanges()) {
            string = change.range.replace(string, change.replacement);
        }
        return string;
    }

    public String performOnRange(String text2, TextRange range) {
        return this.mapOffsets(i -> i - range.start()).perform(range.substring(text2));
    }

    @NotNull
    public List<Replacement> reverseChanges() {
        ArrayList<Replacement> result2 = new ArrayList<Replacement>(this.changes);
        Collections.reverse(result2);
        return result2;
    }

    public TextRange changedRange() {
        return this.changes.stream().map(c -> c.range).reduce((c1, c2) -> TextRange.span(c1, c2)).orElseThrow();
    }

    public static List<TextChange> join(String text2, List<TextChange> changes1, List<TextChange> changes2) {
        return StreamEx.of(changes1).flatMap(c1 -> changes2.contains(c1) ? Stream.of(c1) : changes2.stream().map(c2 -> c1.and((TextChange)c2, text2))).toList();
    }

    public String toString() {
        return this.changes.toString();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof TextChange && this.changes.equals(((TextChange)o).changes);
    }

    public int hashCode() {
        return Objects.hash(this.changes);
    }

    public record Replacement(TextRange range, String replacement) {
        public Replacement withString(String replacement) {
            return new Replacement(this.range, replacement);
        }

        public Replacement growRange(int startDelta, int endDelta) {
            return new Replacement(new TextRange(this.range.start() + startDelta, this.range.end() + endDelta), this.replacement);
        }

        @Override
        public String toString() {
            return this.range + "->'" + this.replacement + "'";
        }

        @Nullable
        Replacement merge(Replacement next, @Nullable String textBefore) {
            if (this.equals(next)) {
                return this;
            }
            if (!this.range.touches(next.range)) {
                return null;
            }
            if (this.range.overlaps(next.range)) {
                if (textBefore != null) {
                    Replacement min1 = this.minimize(textBefore);
                    Replacement min2 = next.minimize(textBefore);
                    if (!min1.range.overlaps(min2.range)) {
                        return Replacement.uniteReplacements(textBefore, min1, min2, TextRange.span(this.range, next.range));
                    }
                }
                if (diagnoseIntersections) {
                    throw new IntersectingChangesException("Intersecting changes: " + this + " + and " + next);
                }
                return this;
            }
            String concat = this.range.start() == next.range().start() && next.range.length() == 0 && this.range.length() > 0 ? next.replacement + this.replacement : this.replacement + next.replacement;
            return new Replacement(TextRange.span(this.range, next.range), concat);
        }

        private static Replacement uniteReplacements(String textBefore, Replacement r1, Replacement r2, TextRange range) {
            String textAfter = new TextChange(List.of(r1)).and(new TextChange(List.of(r2))).perform(textBefore);
            return new Replacement(range, textAfter.substring(range.start(), textAfter.length() - textBefore.length() + range.end()));
        }

        private Replacement minimize(@NotNull String textBefore) {
            int prefix;
            int len = Math.min(this.range.length(), this.replacement.length());
            int suffix = 0;
            for (prefix = 0; prefix < len && textBefore.charAt(prefix + this.range.start()) == this.replacement.charAt(prefix); ++prefix) {
            }
            while (suffix < len - prefix && textBefore.charAt(this.range.end() - suffix - 1) == this.replacement.charAt(this.replacement.length() - suffix - 1)) {
                ++suffix;
            }
            return new Replacement(new TextRange(this.range.start() + prefix, this.range.end() - suffix), this.replacement.substring(prefix, this.replacement.length() - suffix));
        }

        public ProblemFix.Part.Change toProblemChange() {
            return new ProblemFix.Part.Change(new ai.grazie.text.TextRange(this.range.start(), this.range.end()), this.replacement);
        }
    }

    public static class IntersectingChangesException
    extends RuntimeException {
        IntersectingChangesException(String message) {
            super(message);
        }
    }
}

