/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.uk;

import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.ReportingKind;
import ai.grazie.rules.tree.Tree;

class Euphony {
    private static final String vowel = "[\u0456\u0443\u0435\u0430\u043e\u0438]";
    static final String consonant = "[\u0439\u0446\u043a\u043d\u0433\u0491\u0448\u0449\u0437\u0445\u0444\u0432\u043f\u0440\u043b\u0434\u0436\u0447\u0441\u043c\u0442\u0431]";
    static final String joted = "[\u0457\u0439\u0454\u044f\u044e]";
    private static final String sibilantPlus = "[\u0437\u0441\u0446\u0447\u0448\u0449\u0436]";
    private static final String afterU = "(\u0432|\u0444|\u043b\u044c\u0432|\u0437\u0432|\u0441\u0432|\u0434\u0432|\u0442\u0432|\u0433\u0432|\u0445\u0432)";
    private static final String vvExceptions = "(\u0432\u0432\u0430\u0436\u0430\u0442\u0438(\u0441\u044f)?|\u0432\u0432\u0456\u0439\u0442\u0438|\u0432\u0432\u0456|\u0432\u0432\u0456\u0447\u043b\u0438\u0432.*|\u0432\u0432\u0456\u0441\u044c\u043c\u043e\u0445)";
    private static final String punctuation = "[,;:\u2026()\u2013\u2014]";
    private static final String numbers = "[0-9].*";
    private static final String vWord = "(\u0432\u043f\u043b\u0438\u0432|\u0432\u043f\u043b\u0438\u0432\u043e\u0432\u0438\u0439|\u0432\u0434\u0430\u0447\u0430|\u0432\u043a\u043b\u0430\u0434|\u0432\u043f\u0440\u0430\u0432\u0430|\u0432\u0441\u0442\u0443\u043f|\u0432\u0445\u0456\u0434|\u0432\u0445\u043e\u0434\u0438\u0442\u0438|\u0432\u0440\u0430\u0436\u0435\u043d\u043d\u044f|\u0432\u0440\u043e\u043a\u0438|\u0432\u043d\u0438\u043a.*)";
    private static final String uWord = "(\u0423\u0434\u043e\u0432\u0438\u0447\u0435\u043d\u043a\u043e|\u0443\u0434\u0430\u0447\u0430|\u0443\u043a\u043b\u0430\u0434|\u0443\u043f\u0440\u0430\u0432\u0430|\u0443\u0441\u0442\u0443\u043f|\u0443\u0445\u0456\u0434|\u0443\u043c\u043e\u0432\u0430|\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0430|\u0443\u0447\u0430\u0441\u0442\u044c|\u0443\u0445\u043e\u0434\u0438\u0442\u0438|\u0443\u0440\u043e\u043a|\u0443\u043d\u0438\u043a.*)";
    private static final NodePattern vowAbbr = NodePattern.N.pos(".*:abbr.*").noForm("[\u0411\u0412\u0413\u0490\u0414\u0404\u0416\u0417\u0407\u0419\u041a\u041f\u0422\u0425\u0426\u0427\u0428\u0429\u042e\u042f\u041b\u041c\u041d\u0420\u0421\u0424].*");
    private static final NodePattern conVowAbbr = NodePattern.N.pos(".*:abbr.*").form("[\u041b\u041c\u041d\u0420\u0421\u0424].*");
    private static final NodePattern afterVow = NodePattern.N.directlyAfter(NodePattern.N.form(".*[\u0456\u0443\u0435\u0430\u043e\u0438]").includeIntoReport(ReportingKind.Hover));
    private static final NodePattern beforeVow = NodePattern.N.directlyBefore(NodePattern.N.form("[\u0456\u0443\u0435\u0430\u043e\u0438].*"));
    private static final NodePattern beforeCons = NodePattern.N.directlyBefore(NodePattern.N.form("[\u0439\u0446\u043a\u043d\u0433\u0491\u0448\u0449\u0437\u0445\u0444\u0432\u043f\u0440\u043b\u0434\u0436\u0447\u0441\u043c\u0442\u0431].*").includeIntoReport(ReportingKind.Hover));
    private static final NodePattern beforeJWord = NodePattern.N.directlyBefore(NodePattern.N.form("[\u0457\u0439\u0454\u044f\u044e].*").includeIntoReport());
    private static final NodePattern compInf = NodePattern.N.pos("verb:rev.*inf").withHead("[cx]comp", NodePattern.N.pos("verb:rev.*"));
    private static final NodePattern compHead = NodePattern.N.pos("verb:rev.*").withDependent("[cx]comp", NodePattern.N.pos("verb:rev.*inf"));
    private static final NodePattern cConj = NodePattern.N.withHead("cc", NodePattern.N.noPos("intj").withHeadRelation("conj"));
    private static final String SJASJ_MSG = "\u0423 \u0441\u043a\u043b\u0430\u0434\u0435\u043d\u043e\u043c\u0443 \u0434\u0456\u0454\u0441\u043b\u0456\u0432\u043d\u043e\u043c\u0443 \u043f\u0440\u0438\u0441\u0443\u0434\u043a\u0443 \u043e\u0434\u043d\u0435 \u0437 \u0434\u0456\u0454\u0441\u043b\u0456\u0432 \u043c\u0430\u0454 \u0441\u0443\u0444\u0456\u043a\u0441 \u00ab-\u0441\u044f\u00bb, \u0430 \u0456\u043d\u0448\u0435 \u2014 \u00ab-\u0441\u044c\u00bb";
    private static final NodePattern afterVowOrJot = NodePattern.N.directlyAfter(NodePattern.N.form(".*[\u0456\u0443\u0435\u0430\u043e\u0438\u0457\u0454\u044f\u044e]"));
    private static final String IZ_ZI_MSG = "\u0414\u043b\u044f \u043c\u0438\u043b\u043e\u0437\u0432\u0443\u0447\u043d\u043e\u0441\u0442\u0456 \u043a\u0440\u0430\u0449\u0435 \u0432\u0436\u0438\u0432\u0430\u0442\u0438 \u00ab\u0456\u0437\u00bb \u0430\u0431\u043e \u00ab\u0437\u0456\u00bb, \u044f\u043a\u0449\u043e \u0431\u0443\u043a\u0432\u043e\u0441\u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043d\u044f \u043d\u0430\u0441\u0442\u0443\u043f\u043d\u043e\u0433\u043e \u0441\u043b\u043e\u0432\u0430 \u043c\u0430\u0454 \u043f\u043e\u0447\u0430\u0442\u043a\u043e\u0432\u0456 \u00ab\u0437\u00bb, \u00ab\u0441\u00bb, \u00ab\u0448\u00bb, \u00ab\u0448\u0447\u00bb \u0442\u0430 \u0456\u043d\u0448\u0456 \u0441\u0432\u0438\u0441\u0442\u044f\u0447\u0456 \u0442\u0430 \u0448\u0438\u043f\u043b\u044f\u0447\u0456 \u0437\u0432\u0443\u043a\u0438";
    private static final String J_MSG = "\u0414\u043b\u044f \u043c\u0438\u043b\u043e\u0437\u0432\u0443\u0447\u043d\u043e\u0441\u0442\u0456 \u043a\u0440\u0430\u0449\u0435 \u0432\u0436\u0438\u0432\u0430\u0442\u0438 \u00ab\u0439\u00bb \u043c\u0456\u0436 \u0431\u0443\u043a\u0432\u0430\u043c\u0438 \u043d\u0430 \u043f\u043e\u0437\u043d\u0430\u0447\u0435\u043d\u043d\u044f \u0433\u043e\u043b\u043e\u0441\u043d\u0438\u0445 \u0442\u0430 \u043c\u0456\u0436 \u0431\u0443\u043a\u0432\u0430\u043c\u0438, \u0449\u043e \u043f\u0435\u0440\u0435\u0434\u0430\u044e\u0442\u044c \u0433\u043e\u043b\u043e\u0441\u043d\u0438\u0439 \u0456 \u043f\u0440\u0438\u0433\u043e\u043b\u043e\u0441\u043d\u0438\u0439";
    private static final String U_DV_MSG = "\u0414\u043b\u044f \u043c\u0438\u043b\u043e\u0437\u0432\u0443\u0447\u043d\u043e\u0441\u0442\u0456 \u043a\u0440\u0430\u0449\u0435 \u0432\u0436\u0438\u0432\u0430\u0442\u0438 \u00ab\u0443\u00bb \u043f\u0435\u0440\u0435\u0434 \u043d\u0430\u0441\u0442\u0443\u043f\u043d\u0438\u043c\u0438 \u00ab\u0432\u00bb, \u00ab\u0444\u00bb, \u00ab\u043b\u044c\u0432\u00bb, \u00ab\u0437\u0432\u00bb, \u00ab\u0441\u0432\u00bb, \u00ab\u0434\u0432\u00bb, \u00ab\u0442\u0432\u00bb, \u00ab\u0433\u0432\u00bb, \u00ab\u0445\u0432\u00bb \u0456 \u043f\u043e\u0434\u0456\u0431\u043d\u0435";
    private static final String CON_U_CON_MSG = "\u0414\u043b\u044f \u043c\u0438\u043b\u043e\u0437\u0432\u0443\u0447\u043d\u043e\u0441\u0442\u0456 \u043a\u0440\u0430\u0449\u0435 \u0432\u0436\u0438\u0432\u0430\u0442\u0438 \u00ab\u0443\u00bb \u043c\u0456\u0436 \u0431\u0443\u043a\u0432\u0430\u043c\u0438, \u0449\u043e \u043f\u043e\u0437\u043d\u0430\u0447\u0430\u044e\u0442\u044c \u043f\u0440\u0438\u0433\u043e\u043b\u043e\u0441\u043d\u0456";

    Euphony() {
    }

    static Rule.PatternRule rule() {
        return new Rule.PatternRule("Style.EUPHONY", "\u041c\u0438\u043b\u043e\u0437\u0432\u0443\u0447\u043d\u0456\u0441\u0442\u044c", "\u041f\u043e\u0437\u0438\u0446\u0456\u0457 \u0432\u0436\u0438\u0432\u0430\u043d\u043d\u044f \u0441\u043f\u043e\u043b\u0443\u0447\u043d\u0438\u043a\u0456\u0432 \u0456 \u0447\u0430\u0441\u0442\u043e\u043a \u0406, \u0419, \u043f\u0440\u0438\u0439\u043c\u0435\u043d\u043d\u0438\u043a\u0456\u0432 \u0423 \u0442\u0430 \u0412 \u0442\u0430 \u0406, \u0419, \u0423 \u0442\u0430 \u0412 \u043d\u0430 \u043f\u043e\u0447\u0430\u0442\u043a\u0443 \u0441\u043b\u0456\u0432.", "http://newpravopys.mova.info/pravopys.aspx?SectionID=2865", NodePattern.or(Euphony.u_vs_v(), Euphony.i_vs_j(), Euphony.z_iz_zi(), Euphony.sj_sja()).andNot(CommonPatterns.insideQuotes), new Example("<b>\u0412\u043e\u043d\u0430 \u0456\u0434\u0435</b>.", J_MSG, "<b>\u0412\u043e\u043d\u0430 \u0439\u0434\u0435</b>."), new Example("\u0412\u0456\u043d <b>\u0436\u0438\u0432 \u0432 \u041b\u044c\u0432\u043e\u0432\u0456</b>.", CON_U_CON_MSG, "\u0412\u0456\u043d <b>\u0436\u0438\u0432 \u0443 \u041b\u044c\u0432\u043e\u0432\u0456</b>."), new Example("\u0423\u0441\u0442\u0430\u0432 \u0440\u0430\u0437\u043e\u043c <b>\u0437 \u0441\u0445\u043e\u0434\u043e\u043c</b> \u0441\u043e\u043d\u0446\u044f.", IZ_ZI_MSG, "\u0423\u0441\u0442\u0430\u0432 \u0440\u0430\u0437\u043e\u043c <b>\u0456\u0437 \u0441\u0445\u043e\u0434\u043e\u043c</b> \u0441\u043e\u043d\u0446\u044f.", "\u0423\u0441\u0442\u0430\u0432 \u0440\u0430\u0437\u043e\u043c <b>\u0437\u0456 \u0441\u0445\u043e\u0434\u043e\u043c</b> \u0441\u043e\u043d\u0446\u044f."), new Example("\u0412\u0456\u043d <b>\u043d\u0430\u043c\u0430\u0433\u0430\u0432\u0441\u044c</b><i> \u0437\u0443\u043f\u0438\u043d\u0438\u0442\u0438\u0441\u044c</i>.", SJASJ_MSG, "\u0412\u0456\u043d <b>\u043d\u0430\u043c\u0430\u0433\u0430\u0432\u0441\u044f</b><i> \u0437\u0443\u043f\u0438\u043d\u0438\u0442\u0438\u0441\u044c</i>."));
    }

    private static NodePattern i_vs_j() {
        return NodePattern.or(afterVow.andOr(NodePattern.N.form("\u0456").andNot(CommonPatterns.lastWord).and(CommonPatterns.reportWithNext).andNot(beforeJWord).andNot(NodePattern.N.directlyBefore(NodePattern.N.form(punctuation))).andNot(CommonPatterns.capitalizedMiddle).andNot(NodePattern.N.directlyAfter(NodePattern.N.markAs("First")).withHead("cc", NodePattern.N.noPos("intj").withHead("conj", NodePattern.N.alreadyMarkedAs("First").andOr(NodePattern.ROOT, NodePattern.N.withHead("amod", NodePattern.ROOT)).noPos("verb.*|.*:prop:.*")))).correct(NodeCorrector.replace("\u0439")).andOr(cConj.andNot(NodePattern.N.directlyBefore(NodePattern.N.form("\u0443.*"))).correct(NodeCorrector.replace("\u0442\u0430")).message("\u0414\u043b\u044f \u043c\u0438\u043b\u043e\u0437\u0432\u0443\u0447\u043d\u043e\u0441\u0442\u0456 \u043a\u0440\u0430\u0449\u0435 \u0432\u0436\u0438\u0432\u0430\u0442\u0438 \u00ab\u0439\u00bb \u0430\u0431\u043e \u00ab\u0442\u0430\u00bb \u043c\u0456\u0436 \u0431\u0443\u043a\u0432\u0430\u043c\u0438 \u043d\u0430 \u043f\u043e\u0437\u043d\u0430\u0447\u0435\u043d\u043d\u044f \u0433\u043e\u043b\u043e\u0441\u043d\u0438\u0445 \u0442\u0430 \u043c\u0456\u0436 \u0431\u0443\u043a\u0432\u0430\u043c\u0438, \u0449\u043e \u043f\u0435\u0440\u0435\u0434\u0430\u044e\u0442\u044c \u0433\u043e\u043b\u043e\u0441\u043d\u0438\u0439 \u0456 \u043f\u0440\u0438\u0433\u043e\u043b\u043e\u0441\u043d\u0438\u0439"), NodePattern.not(cConj.andNot(NodePattern.N.directlyBefore(NodePattern.N.form("\u0443.*")))).message(J_MSG)), NodePattern.N.form("\u0456..*").andNot(CommonPatterns.capitalizedMiddle).and(node -> Euphony.tagWithXStart(node, "\u0439").hasPos(".*")).and(node -> !Euphony.tagWithXStart(node, "\u0439").hasPos(".*:arch")).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("\u0456|\u0442\u0430|\u0443"))).andNot(NodePattern.N.directlyAfter(CommonPatterns.capitalizedMiddle)).correct(NodeCorrector.regexReplace("\u0456(.*)", "\u0439$1")).reportEverythingTouched().message(J_MSG)), NodePattern.N.form("\u0439.*").noLemma("\u0432\u0456\u043d|\u0432\u043e\u043d\u043e").andNot(CommonPatterns.capitalizedMiddle).includeIntoReport().and(node -> Euphony.tagWithXStart(node, "\u0456").hasPos(".*")).andOr(NodePattern.or(NodePattern.N.directlyAfter(NodePattern.or(NodePattern.N.form(".*[\u0439\u0446\u043a\u043d\u0433\u0491\u0448\u0449\u0437\u0445\u0444\u0432\u043f\u0440\u043b\u0434\u0436\u0447\u0441\u043c\u0442\u0431][\u044c']?").and(CommonPatterns.reportWithPrevWord).message("\u0414\u043b\u044f \u043c\u0438\u043b\u043e\u0437\u0432\u0443\u0447\u043d\u043e\u0441\u0442\u0456 \u043a\u0440\u0430\u0449\u0435 \u0432\u0436\u0438\u0432\u0430\u0442\u0438 \u00ab\u0456\u00bb \u043c\u0456\u0436 \u0431\u0443\u043a\u0432\u0430\u043c\u0438 \u043d\u0430 \u043f\u043e\u0437\u043d\u0430\u0447\u0435\u043d\u043d\u044f \u043f\u0440\u0438\u0433\u043e\u043b\u043e\u0441\u043d\u0438\u0445"), NodePattern.N.form(punctuation).message("\u0414\u043b\u044f \u043c\u0438\u043b\u043e\u0437\u0432\u0443\u0447\u043d\u043e\u0441\u0442\u0456 \u043a\u0440\u0430\u0449\u0435 \u0432\u0436\u0438\u0432\u0430\u0442\u0438 \u00ab\u0456\u00bb \u043f\u0456\u0441\u043b\u044f \u043f\u0430\u0443\u0437\u0438"))), CommonPatterns.firstWord.andNot(CommonPatterns.lastWord).andOptionally(NodePattern.N.form("\u0439").and((node, match) -> match.withReportedRange(node.startOffset(), node.startOffset() + 2, node.tree()))).message("\u0414\u043b\u044f \u043c\u0438\u043b\u043e\u0437\u0432\u0443\u0447\u043d\u043e\u0441\u0442\u0456 \u043a\u0440\u0430\u0449\u0435 \u0432\u0436\u0438\u0432\u0430\u0442\u0438 \u00ab\u0456\u00bb \u043d\u0430 \u043f\u043e\u0447\u0430\u0442\u043a\u0443 \u0440\u0435\u0447\u0435\u043d\u043d\u044f")).andOr(beforeCons.form("\u0439"), NodePattern.N.form("\u0439[\u0439\u0446\u043a\u043d\u0433\u0491\u0448\u0449\u0437\u0445\u0444\u0432\u043f\u0440\u043b\u0434\u0436\u0447\u0441\u043c\u0442\u0431].*")), NodePattern.N.form("\u0439").and(beforeJWord).message("\u0414\u043b\u044f \u043c\u0438\u043b\u043e\u0437\u0432\u0443\u0447\u043d\u043e\u0441\u0442\u0456 \u043a\u0440\u0430\u0449\u0435 \u0432\u0436\u0438\u0432\u0430\u0442\u0438 \u00ab\u0456\u00bb \u043f\u0435\u0440\u0435\u0434 \u0441\u043b\u043e\u0432\u043e\u043c, \u043d\u0430 \u043f\u043e\u0447\u0430\u0442\u043a\u0443 \u044f\u043a\u043e\u0433\u043e \u0441\u0442\u043e\u044f\u0442\u044c \u0431\u0443\u043a\u0432\u0438 \u00ab\u0439\u00bb, \u00ab\u0454\u00bb, \u00ab\u0457\u00bb, \u00ab\u044e\u00bb, \u00ab\u044f\u00bb")).correct(NodeCorrector.regexReplace("\u0439(.*)", "\u0456$1")), NodePattern.N.form("\u0439").directlyAfter(NodePattern.N.form(".*[\u0457\u0439\u0454\u044f\u044e]")).correct(NodeCorrector.replace("\u0456")).reportEverythingTouched().andOr(NodePattern.not(cConj).message("\u041f\u0456\u0441\u043b\u044f \u0431\u0443\u043a\u0432 \u0439, \u044f, \u044e, \u0454, \u0457 \u043a\u0440\u0430\u0449\u0435 \u0432\u0436\u0438\u0432\u0430\u0442\u0438 \u0441\u043f\u043e\u043b\u0443\u0447\u043d\u0438\u043a \u00ab\u0456\u00bb"), cConj.correct(NodeCorrector.replace("\u0442\u0430")).message("\u041f\u0456\u0441\u043b\u044f \u0431\u0443\u043a\u0432 \u0439, \u044f, \u044e, \u0454, \u0457 \u0432\u0436\u0438\u0432\u0430\u0454\u043c\u043e \u0454\u0434\u043d\u0430\u043b\u044c\u043d\u0456 \u0441\u043f\u043e\u043b\u0443\u0447\u043d\u0438\u043a\u0438 \u00ab\u0456\u00bb \u0430\u0431\u043e \u00ab\u0442\u0430\u00bb")));
    }

    private static NodePattern u_vs_v() {
        return NodePattern.or(NodePattern.N.form("\u0443.*").noLemma(uWord).andNot(CommonPatterns.capitalizedMiddle).and(node -> Euphony.tagWithXStart(node, "\u0432").hasPos(".*")).andOr(NodePattern.N.form("\u0443").directlyBefore(NodePattern.or(NodePattern.N.form("[\u0456\u0443\u0435\u0430\u043e\u0438].*"), vowAbbr)).message("\u0414\u043b\u044f \u043c\u0438\u043b\u043e\u0437\u0432\u0443\u0447\u043d\u043e\u0441\u0442\u0456 \u043a\u0440\u0430\u0449\u0435 \u0432\u0436\u0438\u0432\u0430\u0442\u0438 \u00ab\u0432\u00bb \u043f\u0435\u0440\u0435\u0434 \u0431\u0443\u043a\u0432\u043e\u044e, \u0449\u043e \u043f\u043e\u0437\u043d\u0430\u0447\u0430\u0454 \u0433\u043e\u043b\u043e\u0441\u043d\u0438\u0439"), NodePattern.N.form("\u0443[\u0456\u0443\u0435\u0430\u043e\u0438].*").andOr(CommonPatterns.firstWord.message("\u0414\u043b\u044f \u043c\u0438\u043b\u043e\u0437\u0432\u0443\u0447\u043d\u043e\u0441\u0442\u0456 \u043a\u0440\u0430\u0449\u0435 \u0432\u0436\u0438\u0432\u0430\u0442\u0438 \u00ab\u0432-\u00bb \u043d\u0430 \u043f\u043e\u0447\u0430\u0442\u043a\u0443 \u0440\u0435\u0447\u0435\u043d\u043d\u044f \u043f\u0435\u0440\u0435\u0434 \u0431\u0443\u043a\u0432\u043e\u044e, \u0449\u043e \u043f\u043e\u0437\u043d\u0430\u0447\u0430\u0454 \u0433\u043e\u043b\u043e\u0441\u043d\u0438\u0439"), afterVow.message("\u0414\u043b\u044f \u043c\u0438\u043b\u043e\u0437\u0432\u0443\u0447\u043d\u043e\u0441\u0442\u0456 \u043a\u0440\u0430\u0449\u0435 \u0432\u0436\u0438\u0432\u0430\u0442\u0438 \u00ab\u0432-\u00bb \u043c\u0456\u0436 \u0431\u0443\u043a\u0432\u0430\u043c\u0438 \u043d\u0430 \u043f\u043e\u0437\u043d\u0430\u0447\u0435\u043d\u043d\u044f \u0433\u043e\u043b\u043e\u0441\u043d\u0438\u0445")), afterVow.andOr(beforeCons.form("\u0443"), NodePattern.N.form("\u0443[\u0439\u0446\u043a\u043d\u0433\u0491\u0448\u0449\u0437\u0445\u0444\u0432\u043f\u0440\u043b\u0434\u0436\u0447\u0441\u043c\u0442\u0431].*")).andNot(NodePattern.or(NodePattern.N.form("\u0443((\u0432|\u0444|\u043b\u044c\u0432|\u0437\u0432|\u0441\u0432|\u0434\u0432|\u0442\u0432|\u0433\u0432|\u0445\u0432)|[\u0457\u0439\u0454\u044f\u044e]|[\u0439\u0446\u043a\u043d\u0433\u0491\u0448\u0449\u0437\u0445\u0444\u0432\u043f\u0440\u043b\u0434\u0436\u0447\u0441\u043c\u0442\u0431][\u0439\u0446\u043a\u043d\u0433\u0491\u0448\u0449\u0437\u0445\u0444\u0432\u043f\u0440\u043b\u0434\u0436\u0447\u0441\u043c\u0442\u0431]).*"), NodePattern.N.form("\u0443").directlyBefore(NodePattern.or(NodePattern.N.form("((\u0432|\u0444|\u043b\u044c\u0432|\u0437\u0432|\u0441\u0432|\u0434\u0432|\u0442\u0432|\u0433\u0432|\u0445\u0432)|[\u0457\u0439\u0454\u044f\u044e]|[\u0439\u0446\u043a\u043d\u0433\u0491\u0448\u0449\u0437\u0445\u0444\u0432\u043f\u0440\u043b\u0434\u0436\u0447\u0441\u043c\u0442\u0431][\u0439\u0446\u043a\u043d\u0433\u0491\u0448\u0449\u0437\u0445\u0444\u0432\u043f\u0440\u043b\u0434\u0436\u0447\u0441\u043c\u0442\u0431]).*"), NodePattern.N.formCaseSensitive("XX[VI]*"))))).message("\u0414\u043b\u044f \u043c\u0438\u043b\u043e\u0437\u0432\u0443\u0447\u043d\u043e\u0441\u0442\u0456 \u043a\u0440\u0430\u0449\u0435 \u0432\u0436\u0438\u0432\u0430\u0442\u0438 \u00ab\u0432\u00bb \u043f\u0456\u0441\u043b\u044f \u0431\u0443\u043a\u0432\u0438 \u043d\u0430 \u043f\u043e\u0437\u043d\u0430\u0447\u0435\u043d\u043d\u044f \u0433\u043e\u043b\u043e\u0441\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0435\u0434 \u043f\u0440\u0438\u0433\u043e\u043b\u043e\u0441\u043d\u0438\u043c (\u043a\u0440\u0456\u043c \u00ab\u0432\u00bb, \u00ab\u0444\u00bb, \u00ab\u043b\u044c\u0432\u00bb, \u00ab\u0437\u0432\u00bb, \u00ab\u0441\u0432\u00bb, \u00ab\u0434\u0432\u00bb, \u00ab\u0442\u0432\u00bb, \u00ab\u0433\u0432\u00bb, \u00ab\u0445\u0432\u00bb)")).correct(NodeCorrector.regexReplace("\u0443(.*)", "\u0432$1")), NodePattern.N.form("\u0432.*").noLemma(vWord).andNot(CommonPatterns.capitalizedMiddle).and(node -> Euphony.tagWithXStart(node, "\u0443").hasPos(".*")).andOr(NodePattern.or(NodePattern.N.form("\u0432").directlyBefore(NodePattern.N.form("[\u0439\u0446\u043a\u043d\u0433\u0491\u0448\u0449\u0437\u0445\u0444\u0432\u043f\u0440\u043b\u0434\u0436\u0447\u0441\u043c\u0442\u0431].*").andNot(conVowAbbr)), NodePattern.N.form("\u0432[\u044c']?[\u0439\u0446\u043a\u043d\u0433\u0491\u0448\u0449\u0437\u0445\u0444\u0432\u043f\u0440\u043b\u0434\u0436\u0447\u0441\u043c\u0442\u0431].*").noLemma(vvExceptions)).andOr(NodePattern.N.directlyAfter(NodePattern.or(NodePattern.N.form(punctuation).andNot(NodePattern.N.inFormSequence(1, "\u0440", ".")).message("\u0414\u043b\u044f \u043c\u0438\u043b\u043e\u0437\u0432\u0443\u0447\u043d\u043e\u0441\u0442\u0456 \u043a\u0440\u0430\u0449\u0435 \u0432\u0436\u0438\u0432\u0430\u0442\u0438 \u00ab\u0443\u00bb \u043f\u0456\u0441\u043b\u044f \u043f\u0430\u0443\u0437\u0438 \u043f\u0435\u0440\u0435\u0434 \u0431\u0443\u043a\u0432\u043e\u044e \u043d\u0430 \u043f\u043e\u0437\u043d\u0430\u0447\u0435\u043d\u043d\u044f \u043f\u0440\u0438\u0433\u043e\u043b\u043e\u0441\u043d\u043e\u0433\u043e"), NodePattern.N.form(".*[\u0439\u0446\u043a\u043d\u0433\u0491\u0448\u0449\u0437\u0445\u0444\u0432\u043f\u0440\u043b\u0434\u0436\u0447\u0441\u043c\u0442\u0431][\u044c']?").noPos(".*:abbr.*").message(CON_U_CON_MSG)).and(CommonPatterns.reportWithPrevWord)), CommonPatterns.firstWord.message("\u0414\u043b\u044f \u043c\u0438\u043b\u043e\u0437\u0432\u0443\u0447\u043d\u043e\u0441\u0442\u0456 \u043a\u0440\u0430\u0449\u0435 \u0432\u0436\u0438\u0432\u0430\u0442\u0438 \u00ab\u0443\u00bb \u043d\u0430 \u043f\u043e\u0447\u0430\u0442\u043a\u0443 \u0440\u0435\u0447\u0435\u043d\u043d\u044f \u043f\u0435\u0440\u0435\u0434 \u0431\u0443\u043a\u0432\u043e\u044e \u043d\u0430 \u043f\u043e\u0437\u043d\u0430\u0447\u0435\u043d\u043d\u044f \u043f\u0440\u0438\u0433\u043e\u043b\u043e\u0441\u043d\u043e\u0433\u043e")), NodePattern.N.form("\u0432").directlyBefore(NodePattern.or(NodePattern.N.form("(\u0432|\u0444|\u043b\u044c\u0432|\u0437\u0432|\u0441\u0432|\u0434\u0432|\u0442\u0432|\u0433\u0432|\u0445\u0432).*").noLemma(vvExceptions).andNot(conVowAbbr), NodePattern.N.formCaseSensitive("XX[VI]*"))).message(U_DV_MSG), NodePattern.N.form("\u0432(\u0432|\u0444|\u043b\u044c\u0432|\u0437\u0432|\u0441\u0432|\u0434\u0432|\u0442\u0432|\u0433\u0432|\u0445\u0432).*").andOr(afterVowOrJot.noPos("(verb|adj|adv|prep).*"), NodePattern.not(afterVowOrJot)).message(U_DV_MSG)).correct(NodeCorrector.regexReplace("\u0432(.*)", "\u0443$1"))).reportEverythingTouched();
    }

    private static NodePattern z_iz_zi() {
        return NodePattern.or(NodePattern.N.form("\u0437").andNot(NodePattern.N.directlyBefore(NodePattern.N.form("\u0432.*").noLemma(vWord).andNot(CommonPatterns.capitalizedMiddle))).andOr(NodePattern.N.directlyBefore(NodePattern.N.form("\u043b\u044c\u0432.*")).correct(NodeCorrector.regexReplace("\u0437", "\u0437\u0456")).message("\u0414\u043b\u044f \u043c\u0438\u043b\u043e\u0437\u0432\u0443\u0447\u043d\u043e\u0441\u0442\u0456 \u043a\u0440\u0430\u0449\u0435 \u0432\u0436\u0438\u0432\u0430\u0442\u0438 \u00ab\u0437\u0456\u00bb \u043f\u0435\u0440\u0435\u0434 \u0431\u0443\u043a\u0432\u043e\u0441\u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043d\u044f\u043c \u00ab\u043b\u044c\u0432\u00bb"), NodePattern.N.directlyBefore(NodePattern.N.form("[\u0437\u0441\u0446\u0447\u0448\u0449\u0436][\u044c']?[\u0439\u0446\u043a\u043d\u0433\u0491\u0448\u0449\u0437\u0445\u0444\u0432\u043f\u0440\u043b\u0434\u0436\u0447\u0441\u043c\u0442\u0431].*")).correct(NodeCorrector.regexReplace("\u0437", "\u0456\u0437")).correct(NodeCorrector.regexReplace("\u0437", "\u0437\u0456")).message(IZ_ZI_MSG), NodePattern.N.andOr(NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.form("[\u0437\u0441\u0446\u0447\u0448\u0449\u0436].*"), NodePattern.N.form("(([\u0439\u0446\u043a\u043d\u0433\u0491\u0448\u0449\u0437\u0445\u0444\u0432\u043f\u0440\u043b\u0434\u0436\u0447\u0441\u043c\u0442\u0431][\u044c']?)+)?[\u0437\u0441\u0446\u0447\u0448\u0449\u0436].*").noPos(".*:abbr.*"))), NodePattern.N.andNot(beforeVow).directlyAfter(NodePattern.or(NodePattern.N.form(".*[\u0437\u0441\u0446\u0447\u0448\u0449\u0436]"), NodePattern.N.form(".*[\u0437\u0441\u0446\u0447\u0448\u0449\u0436][\u044c']?([\u0439\u0446\u043a\u043d\u0433\u0491\u0448\u0449\u0437\u0445\u0444\u0432\u043f\u0440\u043b\u0434\u0436\u0447\u0441\u043c\u0442\u0431]+)?[\u044c']?")).and(CommonPatterns.reportWithPrevWord))).correct(NodeCorrector.regexReplace("\u0437", "\u0456\u0437")).message("\u0414\u043b\u044f \u043c\u0438\u043b\u043e\u0437\u0432\u0443\u0447\u043d\u043e\u0441\u0442\u0456 \u043a\u0440\u0430\u0449\u0435 \u0432\u0436\u0438\u0432\u0430\u0442\u0438 \u00ab\u0456\u0437\u00bb \u043f\u0435\u0440\u0435\u0434 \u0431\u0443\u043a\u0432\u0430\u043c\u0438, \u0449\u043e \u043f\u043e\u0437\u043d\u0430\u0447\u0430\u044e\u0442\u044c \u0441\u0432\u0438\u0441\u0442\u044f\u0447\u0456 \u0442\u0430 \u0448\u0438\u043f\u043b\u044f\u0447\u0456 \u0437\u0432\u0443\u043a\u0438 \u0442\u0430 \u043c\u0456\u0436 \u0431\u0443\u043a\u0432\u043e\u0441\u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043d\u044f\u043c\u0438")), NodePattern.N.form("\u0456\u0437|\u0437\u0456|\u0437\u043e").andNot(NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.form("[\u0437\u0441\u0446\u0447\u0448\u0449\u0436].*"), NodePattern.N.form("[\u0439\u0446\u043a\u043d\u0433\u0491\u0448\u0449\u0437\u0445\u0444\u0432\u043f\u0440\u043b\u0434\u0436\u0447\u0441\u043c\u0442\u0431][\u044c']?[\u0439\u0446\u043a\u043d\u0433\u0491\u0448\u0449\u0437\u0445\u0444\u0432\u043f\u0440\u043b\u0434\u0436\u0447\u0441\u043c\u0442\u0431].*"), NodePattern.N.form(numbers)))).andOr(beforeVow.message("\u0414\u043b\u044f \u043c\u0438\u043b\u043e\u0437\u0432\u0443\u0447\u043d\u043e\u0441\u0442\u0456 \u043a\u0440\u0430\u0449\u0435 \u0432\u0436\u0438\u0432\u0430\u0442\u0438 \u00ab\u0437\u00bb \u043f\u0435\u0440\u0435\u0434 \u0431\u0443\u043a\u0432\u043e\u044e, \u0449\u043e \u043f\u043e\u0437\u043d\u0430\u0447\u0430\u0454 \u0433\u043e\u043b\u043e\u0441\u043d\u0438\u0439"), CommonPatterns.firstWord.andNot(CommonPatterns.lastWord).message("\u0414\u043b\u044f \u043c\u0438\u043b\u043e\u0437\u0432\u0443\u0447\u043d\u043e\u0441\u0442\u0456 \u043a\u0440\u0430\u0449\u0435 \u0432\u0436\u0438\u0432\u0430\u0442\u0438 \u00ab\u0437\u00bb \u043d\u0430 \u043f\u043e\u0447\u0430\u0442\u043a\u0443 \u0440\u0435\u0447\u0435\u043d\u043d\u044f \u043f\u0435\u0440\u0435\u0434 \u0431\u0443\u043a\u0432\u043e\u044e, \u0449\u043e \u043f\u043e\u0437\u043d\u0430\u0447\u0430\u0454 \u043f\u0440\u0438\u0433\u043e\u043b\u043e\u0441\u043d\u0438\u0439 (\u043a\u0440\u0456\u043c \u0441\u0432\u0438\u0441\u0442\u044f\u0447\u0438\u0445 \u0442\u0430 \u0448\u0438\u043f\u043b\u044f\u0447\u0438\u0445)"), NodePattern.N.directlyAfter(NodePattern.N.form(".*([\u0456\u0443\u0435\u0430\u043e\u0438]|[\u0457\u0454\u044f\u044e])")).and(beforeCons).message("\u0414\u043b\u044f \u043c\u0438\u043b\u043e\u0437\u0432\u0443\u0447\u043d\u043e\u0441\u0442\u0456 \u043a\u0440\u0430\u0449\u0435 \u0432\u0436\u0438\u0432\u0430\u0442\u0438 \u00ab\u0437\u00bb \u043c\u0456\u0436 \u0434\u0432\u043e\u043c\u0430 \u0431\u0443\u043a\u0432\u0430\u043c\u0438, \u043f\u0435\u0440\u0448\u0430 \u0437 \u044f\u043a\u0438\u0445 \u043f\u043e\u0437\u043d\u0430\u0447\u0430\u0454 \u0433\u043e\u043b\u043e\u0441\u043d\u0438\u0439, \u0430 \u0434\u0440\u0443\u0433\u0430 \u2014 \u043f\u0440\u0438\u0433\u043e\u043b\u043e\u0441\u043d\u0438\u0439")).correct(NodeCorrector.replace("\u0437"))).reportEverythingTouched();
    }

    private static NodePattern sj_sja() {
        return NodePattern.N.pos("verb:rev.*").andNot(NodePattern.N.directlyBefore(Euphony.z_iz_zi())).andNot(NodePattern.N.directlyBefore(Euphony.u_vs_v())).andNot(NodePattern.N.directlyBefore(Euphony.i_vs_j())).andOr(NodePattern.N.form(".*\u0441\u044f").includeIntoReport().and(node -> Euphony.tagWithXEnd(node, "\u044c").hasPos(".*")).andOr(beforeVow.andNot(compHead).andNot(compInf).message("\u0429\u043e\u0431 \u0443\u043d\u0438\u043a\u043d\u0443\u0442\u0438 \u0437\u0431\u0456\u0433\u0443 \u0431\u0443\u043a\u0432, \u0449\u043e \u043f\u0435\u0440\u0435\u0434\u0430\u044e\u0442\u044c \u0433\u043e\u043b\u043e\u0441\u043d\u0456, \u043a\u0440\u0430\u0449\u0435 \u0432\u0436\u0438\u0432\u0430\u0442\u0438 \u00ab-\u0441\u044c\u00bb"), compInf.message(SJASJ_MSG)).correct(NodeCorrector.regexReplace("(.*)\u0441\u044f", "$1\u0441\u044c")).reportEverythingTouched(ReportingKind.Hover), NodePattern.N.form(".*\u0441\u044c").noForm("\u043a\u043e\u043b\u0438\u0441\u044c").includeIntoReport().and(node -> Euphony.tagWithXEnd(node, "\u044f").hasPos(".*")).andOr(beforeCons.andNot(compInf).andNot(compHead).message("\u0429\u043e\u0431 \u0443\u043d\u0438\u043a\u043d\u0443\u0442\u0438 \u0437\u0431\u0456\u0433\u0443 \u0431\u0443\u043a\u0432, \u0449\u043e \u043f\u043e\u0437\u043d\u0430\u0447\u0430\u044e\u0442\u044c \u0432\u0430\u0436\u043a\u0456 \u0434\u043b\u044f \u0432\u0438\u043c\u043e\u0432\u0438 \u043f\u0440\u0438\u0433\u043e\u043b\u043e\u0441\u043d\u0456 \u0437\u0432\u0443\u043a\u0438, \u043a\u0440\u0430\u0449\u0435 \u0432\u0436\u0438\u0432\u0430\u0442\u0438 \u00ab-\u0441\u044f\u00bb"), compHead.message(SJASJ_MSG)).correct(NodeCorrector.regexReplace("(.*)\u0441\u044c", "$1\u0441\u044f")).reportEverythingTouched(ReportingKind.Hover));
    }

    private static Tree.Token tagWithXStart(Node node, String letter) {
        return node.tree().treeSupport().tagToken(letter + node.lowForm().substring(1));
    }

    private static Tree.Token tagWithXEnd(Node node, String letter) {
        return node.tree().treeSupport().tagToken(node.lowForm().substring(0, node.form().length() - 1) + letter);
    }
}

