/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.uk;

import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.uk.UkrainianTreePatterns;
import java.util.Objects;

class WordSeparation {
    static final NodePattern hyphenateWithPrev = NodePattern.custom((node, match) -> {
        Node prev = Objects.requireNonNull(node.prevNode());
        return match.withCorrector(CommonPatterns.hyphenateNeighbors(prev, node));
    });
    private static final NodePattern hyphenateWith2Next = NodePattern.custom((first, match) -> {
        Node second = first.neighbor(1);
        Node third = first.neighbor(2);
        return match.withCorrector(NodeCorrector.replaceNodes(first, third, first.form() + "-" + second.form() + "-" + third.form()));
    });
    private static final String DIRECTIONS_MSG = "\u041d\u0430\u0437\u0432\u0438 \u0441\u0442\u043e\u0440\u0456\u043d \u0441\u0432\u0456\u0442\u0443 \u0437\u0430\u0437\u0432\u0438\u0447\u0430\u0439 \u043f\u0438\u0448\u0443\u0442\u044c\u0441\u044f \u0447\u0435\u0440\u0435\u0437 \u0434\u0435\u0444\u0456\u0441";
    private static final String HYPHEN_MSG = "\u0417\u0430\u0437\u0432\u0438\u0447\u0430\u0439 \u0446\u0435 \u0441\u043b\u043e\u0432\u043e \u043f\u0438\u0448\u0435\u0442\u044c\u0441\u044f \u0447\u0435\u0440\u0435\u0437 \u0434\u0435\u0444\u0456\u0441";
    private static final NodePattern foreignPrefix = NodePattern.N.form("\u0430\u0431\u0440\u043e|\u0430\u0432\u0456\u0430|\u0430\u0432\u0442\u043e|\u0430\u0433\u0440\u043e|\u0430\u0435\u0440\u043e|\u0430\u043a\u0432\u0430|\u0430\u043b\u043a\u043e|\u0430\u0440\u0442|\u0430\u0441\u0442\u0440\u043e|\u0430\u0443\u0434\u0456\u043e|\u0431\u0456\u043e|\u0431\u043e\u0434\u0438|\u0431\u043e\u0434\u0456|\u0432\u0435\u0431|\u0433\u0435\u043b\u0456\u043e|\u0433\u0435\u043e|\u0433\u0456\u0434\u0440\u043e|\u0434\u0435\u043d\u0434\u0440\u043e|\u0435\u043a\u0437\u043e|\u0435\u043a\u043e|\u0435\u043a\u043e\u043d\u043e\u043c|\u0435\u0442\u043d\u043e|\u0454\u0432\u0440\u043e|\u0437\u043e\u043e|\u0456\u0437\u043e|\u043a\u0456\u0431\u0435\u0440|\u043c\u0435\u0442\u0430|\u043c\u0435\u0442\u0435\u043e|\u043c\u043e\u043d\u043e|\u043c\u043e\u0442\u043e|\u043d\u0430\u0440\u043a\u043e|\u043d\u0435\u043e|\u043e\u043d\u043a\u043e|\u043f\u0430\u043b\u0435\u043e|\u043f\u0430\u043d|\u043f\u0430\u0440\u0430|\u043f\u043e\u043f|\u043f\u0440\u0435\u0441|\u043f\u0441\u0435\u0432\u0434\u043e|\u0441\u043e\u0446\u0456\u043e|\u0442\u0435\u043b\u0435|\u0444\u0456\u0442\u043e|\u0444\u043e\u043b\u044c?\u043a|\u0444\u043e\u043d\u043e\u0430\u0440\u0445\u0456|\u0430\u0440\u0445\u0438|\u0431\u043b\u0456\u0446|\u0433\u0456\u043f\u0435\u0440|\u0435\u043a\u0441\u0442\u0440\u0430|\u043c\u0430\u043a\u0440\u043e|\u043c\u0430\u043a\u0441\u0456|\u043c\u0456\u0434\u0456|\u043c\u0456\u043a\u0440\u043e|\u043c\u0456\u043d\u0456|\u043c\u0443\u043b\u044c\u0442\u0438|\u043d\u0430\u043d\u043e|\u043f\u043e\u043b\u0456|\u043f\u0440\u0435\u043c\u0456\u0443\u043c|\u0441\u0443\u043f\u0435\u0440|\u0443\u043b\u044c\u0442\u0440\u0430|\u0444\u043b\u0435\u0448\u043c\u0443\u043b\u044c\u0442\u0438|\u043a\u0432\u0430\u0437\u0456|\u0430\u043d\u0442\u0438|\u0432\u0456\u0446\u0435|\u0435\u043a\u0441|\u043a\u043e\u043d\u0442\u0440|\u043b\u0435\u0439\u0431|\u043e\u0431\u0435\u0440|\u0448\u0442\u0430\u0431\u0441|\u0443\u043d\u0442\u0435\u0440");
    private static final String numGroup = "\u043f\u0430\u0440\u0430|\u0442\u0440\u0456\u0439\u043a\u0430|\u0447\u0435\u0442\u0432\u0456\u0440\u043a\u0430|\u043f'\u044f\u0442\u0456\u0440\u043a\u0430|\u0448\u0456\u0441\u0442\u043a\u0430|\u0441\u0456\u043c\u043a\u0430|\u0432\u0456\u0441\u0456\u043c\u043a\u0430|\u0434\u0435\u0432'\u044f\u0442\u043a\u0430|\u0434\u0435\u0441\u044f\u0442\u043a\u0430|\u0434\u0432\u0430\u0434\u0446\u044f\u0442\u043a\u0430|\u0442\u0440\u0438\u0434\u0446\u044f\u0442\u043a\u0430|\u0441\u043e\u0442\u043a\u0430";
    private static final NodePattern interrogativePronoun = NodePattern.N.lemma("\u0445\u0442\u043e|\u0449\u043e|\u0447\u0438\u0439|\u044f\u043a\u0438\u0439|\u043a\u043e\u0442\u0440\u0438\u0439|\u0441\u043a\u0456\u043b\u044c\u043a\u0438|\u043a\u043e\u043b\u0438|\u043a\u0443\u0434\u0438|\u0437\u0432\u0456\u0434\u043a\u0438|\u0447\u043e\u043c\u0443|\u044f\u043a|\u0434\u0435");

    WordSeparation() {
    }

    static NodePattern pattern() {
        NodePattern missingHyphen = NodePattern.or(WordSeparation.directions(), WordSeparation.hardcodedHyphenation(), WordSeparation.hyphenatedParticles());
        return NodePattern.or(missingHyphen, WordSeparation.commonlyJoinedPrefixes(), WordSeparation.oneWordPronouns());
    }

    private static NodePattern commonlyJoinedPrefixes() {
        NodePattern possibleNoun = NodePattern.N.form("\u0430\u0432\u0442\u043e|\u043c\u0435\u0442\u0430|\u043f\u0430\u043d|\u043f\u0430\u0440\u0430|\u043f\u043e\u043b\u0456|\u0454\u0432\u0440\u043e|\u043c\u0456\u043d\u0456|\u0430\u0440\u0442|\u0432\u0435\u0431|\u0430\u0443\u0434\u0456\u043e|\u043f\u0440\u0435\u0441|\u0442\u043e\u043f").noHeadRelation("compound");
        NodePattern needsApostrophe = NodePattern.N.form(".*[\u0439\u0446\u043a\u043d\u0433\u0491\u0448\u0449\u0437\u0445\u0444\u0432\u043f\u0440\u043b\u0434\u0436\u0447\u0441\u043c\u0442\u0431]").and(CommonPatterns.beforeSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("[\u0457\u0439\u0454\u044f\u044e].*")));
        return NodePattern.or(NodePattern.or(foreignPrefix.and(CommonPatterns.beforeSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.markAs("Next").pos(".*"))), NodePattern.N.formCaseSensitive("[\u0422\u0442]\u043e\u043f").and(CommonPatterns.beforeSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.markAs("Next").noPos("number|numr:.*|.*&numr").noLemma(numGroup))), NodePattern.N.form("\u0431\u0430\u0433\u0430\u0442\u043e").directlyBefore(CommonPatterns.HYPHEN_NODE.directlyBefore(NodePattern.N.markAs("Next")))).andNot(CommonPatterns.capitalized.and(NodePattern.markedNodeMatches("Next", CommonPatterns.capitalized))).andNot(NodePattern.markedNodeMatches("Next", CommonPatterns.capitalized)).andNot(NodePattern.markedNodeMatches("Next", CommonPatterns.latin)).andNot(NodePattern.N.directlyAfter(UkrainianTreePatterns.anyQuotation)).andNot(possibleNoun).andNot(NodePattern.N.withDependent("conj")).andNot(NodePattern.N.inFormSequence(0, "\u0441\u0443\u043f\u0435\u0440", "-", "\u043f\u0443\u043f\u0435\u0440.*")).andNot(NodePattern.N.form("\u043f\u043e\u043f").and(CommonPatterns.beforeSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("\u0438\u0442")))).andNot(NodePattern.N.form("\u0430\u0443\u0434\u0456\u043e").and(CommonPatterns.beforeSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("\u0432\u0456\u0434\u0435\u043e")))).andOr(needsApostrophe.and((prefix, match) -> {
            Node next = match.getMarkedNode("Next");
            String concat = prefix.lowForm() + "'" + next.lowForm();
            return WordSeparation.prefConcat(prefix, match, next, concat);
        }), NodePattern.not(needsApostrophe).and((prefix, match) -> {
            Node next = match.getMarkedNode("Next");
            String concat = prefix.lowForm() + next.lowForm();
            return WordSeparation.prefConcat(prefix, match, next, concat);
        })).message("\u041f\u0440\u0435\u0444\u0456\u043a\u0441 \u00ab$_-\u00bb \u0437\u0430\u0437\u0432\u0438\u0447\u0430\u0439 \u043f\u0438\u0448\u0435\u0442\u044c\u0441\u044f \u0431\u0435\u0437 \u043f\u0440\u043e\u0431\u0456\u043b\u0456\u0432 \u0456 \u0434\u0435\u0444\u0456\u0441\u0456\u0432"), NodePattern.N.andOr(CommonPatterns.capitalizedMiddle, NodePattern.N.label("MISC|LOCATION")).andNot(NodePattern.N.withDependent("flat:foreign")).andNot(CommonPatterns.latin).directlyAfter(foreignPrefix.andNot(CommonPatterns.capitalizedMiddle).andNot(possibleNoun)).andNot(NodePattern.N.inFormSequence(1, "\u0421\u0443\u043f\u0435\u0440", "\u041d\u043e\u0432\u0430")).and(hyphenateWithPrev).message("\u0406\u0437 \u0432\u043b\u0430\u0441\u043d\u043e\u044e \u043d\u0430\u0437\u0432\u043e\u044e \u0441\u043b\u043e\u0432\u0430 \u0437 \u043f\u0435\u0440\u0448\u0438\u043c \u0456\u043d\u0448\u043e\u043c\u043e\u0432\u043d\u0438\u043c \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u043e\u043c \u043f\u0438\u0448\u0443\u0442\u044c\u0441\u044f \u0437 \u0434\u0435\u0444\u0456\u0441\u043e\u043c"));
    }

    private static NodePattern hyphenatedParticles() {
        return NodePattern.or(interrogativePronoun.directlyAfter(NodePattern.N.form("\u0431\u0443\u0434\u044c|\u043a\u0430\u0437\u043d\u0430|\u0445\u0442\u043e\u0437\u043d\u0430|\u0431\u043e\u0437\u043d\u0430").withHeadRelation("det|orphan").markAs("Part")).message("\u041d\u0435\u043e\u0437\u043d\u0430\u0447\u0435\u043d\u0456 \u0437\u0430\u0439\u043c\u0435\u043d\u043d\u0438\u043a\u0438 \u0437 \u0447\u0430\u0441\u0442\u043a\u043e\u044e \u00ab$Part-\u00bb \u043f\u0438\u0448\u0443\u0442\u044c\u0441\u044f \u0447\u0435\u0440\u0435\u0437 \u0434\u0435\u0444\u0456\u0441"), NodePattern.N.form("(\u043d\u0435)?\u0431\u0443\u0434\u044c").andNot(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_NODE.noSpaceBefore())).directlyAfter(interrogativePronoun.noHeadRelation("mark")).message("\u041d\u0435\u043e\u0437\u043d\u0430\u0447\u0435\u043d\u0456 \u0437\u0430\u0439\u043c\u0435\u043d\u043d\u0438\u043a\u0438 \u0437 \u0447\u0430\u0441\u0442\u043a\u043e\u044e \u00ab-$_\u00bb \u043f\u0438\u0448\u0443\u0442\u044c\u0441\u044f \u0447\u0435\u0440\u0435\u0437 \u0434\u0435\u0444\u0456\u0441"), NodePattern.N.form("\u0442\u0430\u043a\u0438").withHeadRelation("discourse").directlyAfter(NodePattern.N.form("[\u0432\u0443]\u0441\u0435").withHeadRelation("discourse").markAs("Vse")).message("\u0421\u043e\u044e\u0437 \u0430\u0431\u043e \u0447\u0430\u0441\u0442\u043a\u0430 \u00ab$Vse-\u0442\u0430\u043a\u0438\u00bb \u043f\u0438\u0448\u0435\u0442\u044c\u0441\u044f \u0447\u0435\u0440\u0435\u0437 \u0434\u0435\u0444\u0456\u0441"), NodePattern.N.directlyAfter(NodePattern.not(NodePattern.N.onlyPos("intj|part|conj:coord")).markAs("First")).withHeadRelation("discourse|fixed").noDependents().andNot(NodePattern.N.directlyAfter(NodePattern.PUNCT)).andNot(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("cc|mark").noForm("\u044f\u043a"))).andOr(NodePattern.N.form("\u0431\u043e|\u043d\u043e|\u043e\u0442").andOr(NodePattern.N.directlyAfterHead(), NodePattern.N.withPrevSibling(NodePattern.N.alreadyMarkedAs("First"))).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("\u0442\u0430\u043a").andOr(NodePattern.N.withHead("discourse", NodePattern.N.pos(".*:&pron:int:rel.*")), NodePattern.N.withNeighbor(2, NodePattern.N.pos(".*:&pron:int:rel.*"))))).andNot(NodePattern.N.inFormSequence(0, "\u043e\u0442", "\u0442\u0430\u043a")), NodePattern.N.form("\u0442\u043e").directlyAfterHead().andNot(NodePattern.N.inFormSequence(2, "\u0442\u043e", "\u0448\u043e", "\u0442\u043e")), NodePattern.N.form("\u0442\u0430\u043a\u0438").directlyAfterHead().andNot(NodePattern.N.directlyBefore(NodePattern.N.pos("verb.*")))).message("\u0427\u0430\u0441\u0442\u043a\u0430 \u00ab-$_\u00bb \u043f\u0438\u0448\u0435\u0442\u044c\u0441\u044f \u0447\u0435\u0440\u0435\u0437 \u0434\u0435\u0444\u0456\u0441")).and(hyphenateWithPrev);
    }

    private static NodePattern oneWordPronouns() {
        return NodePattern.or(interrogativePronoun.and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("\u0430\u0431\u0438|\u0430\u043d\u0456|\u0434\u0435").andNot(NodePattern.N.withHead("advmod", NodePattern.N.withHeadRelation("advcl|ccomp|xcomp"))).markAs("First")).andNot(NodePattern.N.withHead("det", NodePattern.N.withHeadRelation("nsubj")))).message("\u041d\u0435\u043e\u0437\u043d\u0430\u0447\u0435\u043d\u0456 \u0437\u0430\u0439\u043c\u0435\u043d\u043d\u0438\u043a\u0438 \u0437 \u0447\u0430\u0441\u0442\u043a\u043e\u044e \u00ab$First-\u00bb \u043f\u0438\u0448\u0443\u0442\u044c\u0441\u044f \u0440\u0430\u0437\u043e\u043c"), NodePattern.N.form("\u0441\u044c").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, interrogativePronoun.markAs("First"))).message("\u041d\u0435\u043e\u0437\u043d\u0430\u0447\u0435\u043d\u0456 \u0437\u0430\u0439\u043c\u0435\u043d\u043d\u0438\u043a\u0438 \u0437 \u0447\u0430\u0441\u0442\u043a\u043e\u044e \u00ab-\u0441\u044c\u00bb \u043f\u0438\u0448\u0443\u0442\u044c\u0441\u044f \u0440\u0430\u0437\u043e\u043c")).and((node, match) -> {
            Node first = match.getMarkedNode("First");
            return match.withCorrector(NodeCorrector.replaceNodes(first, node, first.lowForm() + node.lowForm()));
        });
    }

    private static NodeMatch prefConcat(Node prefix, NodeMatch match, Node next, String concat) {
        if (!next.tree().treeSupport().tagToken(concat).hasPos(".*") || next.tree().treeSupport().tagToken(concat).hasPos(".*:bad")) {
            return null;
        }
        return match.withCorrector(NodeCorrector.replaceNodes(prefix, next, concat));
    }

    private static NodePattern hardcodedHyphenation() {
        return NodePattern.or(NodePattern.N.inFormSequence(0, "\u043f\u043b\u0456\u0447", "\u043e", "\u043f\u043b\u0456\u0447").and(hyphenateWith2Next), NodePattern.N.inFormSequence(0, "\u0432\u0456\u0447", "\u043d\u0430", "\u0432\u0456\u0447").and(hyphenateWith2Next), NodePattern.N.inFormSequence(0, "\u0432\u0441\u044c\u043e\u0433\u043e", "\u043d\u0430", "\u0432\u0441\u044c\u043e\u0433\u043e").and(hyphenateWith2Next), NodePattern.N.inFormSequence(2, "\u0432\u0441\u044c\u043e\u0433\u043e", "-", "\u043d\u0430\u0432\u0441\u044c\u043e\u0433\u043e").correct(NodeCorrector.replace("\u043d\u0430-\u0432\u0441\u044c\u043e\u0433\u043e")), NodePattern.N.inFormSequence(0, "\u044f\u043a", "\u043d\u0435", "\u044f\u043a").and(hyphenateWith2Next), NodePattern.N.inFormSequence(0, "\u0434\u0435", "\u043d\u0435", "\u0434\u0435").and(hyphenateWith2Next), NodePattern.N.inFormSequence(0, "\u043a\u043e\u043b\u0438", "\u043d\u0435", "\u043a\u043e\u043b\u0438").and(hyphenateWith2Next), NodePattern.N.inFormSequence(0, "\u0445\u043e\u0447", "\u043d\u0435", "\u0445\u043e\u0447").and(hyphenateWith2Next), NodePattern.N.inFormSequence(0, "\u0431\u0443\u0434\u044c", "\u0449\u043e", "\u0431\u0443\u0434\u044c").and(hyphenateWith2Next), NodePattern.N.lemma("\u0439\u043e\u0440\u043a.*").directlyAfter(NodePattern.N.form("\u043d\u044c\u044e")).and(hyphenateWithPrev), NodePattern.N.form("\u0440\u0435\u0448\u0442").directlyAfter(NodePattern.N.form("[\u0432\u0443]\u0440\u0435\u0448\u0442\u0456")).and(hyphenateWithPrev), CommonPatterns.plainReplace("\u0432\u0441\u044c\u043e\u0433\u043e", "\u043d\u0430\u0432\u0441\u044c\u043e\u0433\u043e", "\u0432\u0441\u044c\u043e\u0433\u043e-\u043d\u0430-\u0432\u0441\u044c\u043e\u0433\u043e"), CommonPatterns.plainReplace("\u0434\u0430\u0432\u043d\u0438\u043c", "\u0434\u0430\u0432\u043d\u043e", "\u0434\u0430\u0432\u043d\u0438\u043c-\u0434\u0430\u0432\u043d\u043e"), CommonPatterns.plainReplace("\u043d\u0430\u0432\u0456\u043a\u0438", "\u0432\u0456\u043a\u0456\u0432", "\u043d\u0430\u0432\u0456\u043a\u0438-\u0432\u0456\u043a\u0456\u0432"), CommonPatterns.plainReplace("\u043d\u0430", "\u0433\u043e\u0440\u0430", "\u043d\u0430-\u0433\u043e\u0440\u0430").andNot(CommonPatterns.capitalizedMiddle), CommonPatterns.plainReplace("\u043f\u043e", "\u043b\u0430\u0442\u0438\u043d\u0456", "\u043f\u043e-\u043b\u0430\u0442\u0438\u043d\u0456"), CommonPatterns.plainReplace("\u0433\u0438\u0434\u043a\u043e", "\u0431\u0440\u0438\u0434\u043a\u043e", "\u0433\u0438\u0434\u043a\u043e-\u0431\u0440\u0438\u0434\u043a\u043e"), CommonPatterns.plainReplace("\u0437\u0440\u043e\u0434\u0443", "\u0432\u0438\u043a\u0443", "\u0437\u0440\u043e\u0434\u0443-\u0432\u0438\u043a\u0443"), CommonPatterns.plainReplace("\u0442\u0438\u0448\u043a\u043e\u043c", "\u043d\u0438\u0448\u043a\u043e\u043c", "\u0442\u0438\u0448\u043a\u043e\u043c-\u043d\u0438\u0448\u043a\u043e\u043c"), CommonPatterns.plainReplace("\u0447\u0430\u0441\u0442\u043e", "\u0433\u0443\u0441\u0442\u043e", "\u0447\u0430\u0441\u0442\u043e-\u0433\u0443\u0441\u0442\u043e"), CommonPatterns.plainReplace("\u0431\u0456\u043b\u044c\u0448", "\u043c\u0435\u043d\u0448", "\u0431\u0456\u043b\u044c\u0448-\u043c\u0435\u043d\u0448"), CommonPatterns.plainReplace("\u0432\u0438\u0434\u0438\u043c\u043e", "\u043d\u0435\u0432\u0438\u0434\u0438\u043c\u043e", "\u0432\u0438\u0434\u0438\u043c\u043e-\u043d\u0435\u0432\u0438\u0434\u0438\u043c\u043e"), CommonPatterns.plainReplace("\u043c\u0430\u043b\u043e", "\u043f\u043e\u043c\u0430\u043b\u0443", "\u043c\u0430\u043b\u043e-\u043f\u043e\u043c\u0430\u043b\u0443"), CommonPatterns.plainReplace("\u043f\u043e\u0432\u0456\u043a", "\u0432\u0456\u043a\u0438", "\u043f\u043e\u0432\u0456\u043a-\u0432\u0456\u043a\u0438"), CommonPatterns.plainReplace("\u0432\u0440\u044f\u0434\u0438", "\u0433\u043e\u0434\u0438", "\u0432\u0440\u044f\u0434\u0438-\u0433\u043e\u0434\u0438"), CommonPatterns.plainReplace("\u0434\u0435\u0441\u044c", "\u0456\u043d\u0434\u0435", "\u0434\u0435\u0441\u044c-\u0456\u043d\u0434\u0435"), CommonPatterns.plainReplace("\u0434\u0435\u0441\u044c", "\u0456\u043d\u043a\u043e\u043b\u0438", "\u0434\u0435\u0441\u044c-\u0456\u043d\u043a\u043e\u043b\u0438"), CommonPatterns.plainReplace("\u0441\u044f\u043a", "\u0442\u0430\u043a", "\u0441\u044f\u043a-\u0442\u0430\u043a"), CommonPatterns.plainReplace("\u0434\u0430\u0432\u043d\u0456\u0445", "\u0434\u0430\u0432\u0435\u043d", "\u0434\u0430\u0432\u043d\u0456\u0445-\u0434\u0430\u0432\u0435\u043d").withNeighbor(-2, NodePattern.N.form("\u0456?\u0437")), CommonPatterns.plainReplace("\u0434\u0456\u0434\u0430", "\u043f\u0440\u0430\u0434\u0456\u0434\u0430", "\u0434\u0456\u0434\u0430-\u043f\u0440\u0430\u0434\u0456\u0434\u0430").withNeighbor(-2, NodePattern.N.form("\u0456?\u0437")), CommonPatterns.plainReplace("\u043a\u0456\u043d\u0446\u044f", "\u043a\u0440\u0430\u044e", "\u043a\u0456\u043d\u0446\u044f-\u043a\u0440\u0430\u044e").withNeighbor(-2, NodePattern.N.form("\u0431\u0435\u0437")), CommonPatterns.plainReplace("\u043a\u0430\u0440\u0442", "\u0431\u043b\u0430\u043d\u0448.*", "\u043a\u0430\u0440\u0442-\u0431\u043b\u0430\u043d\u0448"), CommonPatterns.plainReplace("\u0441\u0442\u0430\u0442\u0443\u0441.*", "\u043a\u0432\u043e", "\u0441\u0442\u0430\u0442\u0443\u0441-\u043a\u0432\u043e"), CommonPatterns.plainReplace("\u0434\u0435", "\u0444\u0430\u043a\u0442\u043e", "\u0434\u0435-\u0444\u0430\u043a\u0442\u043e"), CommonPatterns.plainReplace("\u0434\u0435", "\u044e\u0440\u0435", "\u0434\u0435-\u044e\u0440\u0435"), NodePattern.N.form("\u0434\u0430\u043b\u0435\u043a\u043e|\u043b\u0435\u0434\u0432\u0435|\u043e\u0441\u044c|\u0442\u0438\u0445\u043e").sameWordAs(-1).and(hyphenateWithPrev)).reportEverythingTouched().message(HYPHEN_MSG);
    }

    private static NodePattern directions() {
        return NodePattern.or(NodePattern.N.lemma("\u0432\u0435\u0441\u0442|\u043e\u0441\u0442").directlyAfter(NodePattern.N.form("\u043d\u043e\u0440\u0434|\u0437\u044e\u0439\u0434")).and(hyphenateWithPrev), NodePattern.N.lemma("\u0437\u0430\u0445\u0456\u0434\u043d\u0438\u0439|\u0441\u0445\u0456\u0434\u043d\u0438\u0439").directlyAfter(NodePattern.N.form("\u043f\u0456\u0432\u043d\u0456\u0447\u043d\u043e|\u043f\u0456\u0432\u0434\u0435\u043d\u043d\u043e")).and(hyphenateWithPrev), NodePattern.N.lemma("(\u043f\u0456\u0432\u043d\u0456\u0447\u043d\u043e|\u043f\u0456\u0432\u0434\u0435\u043d\u043d\u043e)(\u0437\u0430\u0445\u0456\u0434\u043d\u0438\u0439|\u0441\u0445\u0456\u0434\u043d\u0438\u0439)").correct(NodeCorrector.regexReplace("(.*)\u043e(.*)", "$1\u043e-$2"))).message(DIRECTIONS_MSG);
    }

    static Rule rule() {
        return new Rule.PatternRule("Spelling.WORD_SEPARATION", "\u041e\u0431'\u0454\u0434\u043d\u0430\u043d\u043d\u044f \u0441\u043b\u0456\u0432 \u0430\u0431\u043e \u0440\u043e\u0437\u0434\u0456\u043b\u0435\u043d\u043d\u044f \u0441\u043b\u0456\u0432 \u0434\u0435\u0444\u0456\u0441\u043e\u043c \u0430\u0431\u043e \u043f\u0440\u043e\u0431\u0456\u043b\u043e\u043c", "\u041f\u0435\u0440\u0435\u0432\u0456\u0440\u043a\u0430, \u0447\u0438 \u043f\u043e\u0442\u0440\u0456\u0431\u043d\u043e \u0434\u0432\u0430 \u0441\u043b\u043e\u0432\u0430 \u043f\u0438\u0441\u0430\u0442\u0438 \u0440\u0430\u0437\u043e\u043c \u0430\u0431\u043e \u0440\u043e\u0437\u0434\u0456\u043b\u044f\u0442\u0438 \u0457\u0445 \u0434\u0435\u0444\u0456\u0441\u043e\u043c \u0447\u0438 \u043f\u0440\u043e\u0431\u0456\u043b\u043e\u043c.", "https://2019.pravopys.net/sections/35/", WordSeparation.pattern(), new Example("\u041d\u0430\u0434 <b>\u043f\u0456\u0432\u0434\u0435\u043d\u043d\u043e \u0437\u0430\u0445\u0456\u0434\u043d\u0438\u043c</b> \u0443\u0437\u0431\u0435\u0440\u0435\u0436\u0436\u044f\u043c \u0424\u043b\u043e\u0440\u0438\u0434\u0438.", DIRECTIONS_MSG, "\u041d\u0430\u0434 <b>\u043f\u0456\u0432\u0434\u0435\u043d\u043d\u043e-\u0437\u0430\u0445\u0456\u0434\u043d\u0438\u043c</b> \u0443\u0437\u0431\u0435\u0440\u0435\u0436\u0436\u044f\u043c \u0424\u043b\u043e\u0440\u0438\u0434\u0438."), new Example("\u042f\u043a \u0441\u043f\u0440\u0430\u0432\u0438 \u0432 <b>\u041d\u044c\u044e \u0419\u043e\u0440\u043a\u0443</b>?", HYPHEN_MSG, "\u042f\u043a \u0441\u043f\u0440\u0430\u0432\u0438 \u0432 <b>\u041d\u044c\u044e-\u0419\u043e\u0440\u043a\u0443</b>?"));
    }
}

