/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.util;

import ai.grazie.nlp.tokenizer.Tokenizer;
import ai.grazie.nlp.tokenizer.sentence.StandardSentenceTokenizer;
import ai.grazie.rules.tree.Tree;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import one.util.streamex.StreamEx;

public class BatchSentenceTokenizer {
    private final List<String> texts;
    private final Map<String, List<Tokenizer.Token>> tokenized;

    public BatchSentenceTokenizer(List<String> texts, StandardSentenceTokenizer tokenizer) {
        this.texts = texts;
        this.tokenized = ((StreamEx)StreamEx.of(texts).distinct()).mapToEntry(tokenizer::tokenize).toMap();
    }

    public List<String> sentencesToParse() {
        return ((StreamEx)StreamEx.of(this.tokenized.values()).flatCollection(Function.identity()).map(Tokenizer.Token::getToken).map(String::trim).distinct()).toList();
    }

    public LinkedHashMap<String, List<Tree>> textTrees(Map<String, Tree> sentenceTrees) {
        return (LinkedHashMap)((StreamEx)StreamEx.of(this.texts).distinct()).mapToEntry(s -> {
            List<Tokenizer.Token> sentences2 = this.tokenized.get(s);
            ArrayList<Tree> trees2 = new ArrayList<Tree>();
            for (Tokenizer.Token sentence : sentences2) {
                String trimmed = sentence.getToken().trim();
                trees2.add(((Tree)sentenceTrees.get(trimmed)).withStartOffset(sentence.getRange().getStart() + sentence.getToken().indexOf(trimmed)));
            }
            return trees2;
        }).toCustomMap(LinkedHashMap::new);
    }
}

