/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.grazie.pro;

import ai.grazie.gec.model.problem.ProblemFix;
import ai.grazie.nlp.langs.Language;
import ai.grazie.rules.Example;
import ai.grazie.rules.MatchingResult;
import ai.grazie.rules.NodeRuleMatch;
import ai.grazie.rules.Rule;
import ai.grazie.rules.RuleMatch;
import ai.grazie.rules.document.Delimiter;
import ai.grazie.rules.document.DocumentRule;
import ai.grazie.rules.document.DocumentSentence;
import ai.grazie.rules.settings.RuleSetting;
import ai.grazie.rules.toolkit.LanguageToolkit;
import ai.grazie.rules.tree.ActionSuggestion;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.Parameter;
import ai.grazie.rules.tree.Tree;
import com.google.common.collect.Sets;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.text.ProblemFilter;
import com.intellij.grazie.text.RuleGroup;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextProblem;
import com.intellij.ml.grazie.pro.ChangeLanguageVariant;
import com.intellij.ml.grazie.pro.DependencyParser;
import com.intellij.ml.grazie.pro.GrazieProBundle;
import com.intellij.ml.grazie.pro.GrazieProConfig;
import com.intellij.ml.grazie.pro.HighlightingUtil;
import com.intellij.ml.grazie.pro.ParsedSentence;
import com.intellij.ml.grazie.pro.RuleIdeClient;
import com.intellij.ml.grazie.pro.SentenceBatcher;
import com.intellij.ml.grazie.pro.SentenceTokenizer;
import com.intellij.ml.grazie.pro.cloud.APIQueries;
import com.intellij.ml.grazie.pro.editor.AutoFix;
import com.intellij.ml.grazie.pro.style.ConfigureSuggestedParameter;
import com.intellij.ml.grazie.pro.style.TextLevelFix;
import com.intellij.ml.grazie.pro.ui.StyleConfigurable;
import com.intellij.ml.grazie.pro.util.QuotedMarkup;
import com.intellij.ml.grazie.pro.utils.GrazieUtilsKt;
import com.intellij.ml.grazie.pro.utils.IdeUtils;
import com.intellij.ml.grazie.pro.utils.TextUtils;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringOperation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeRuleChecker {
    private static final Logger LOG = Logger.getInstance(TreeRuleChecker.class);
    public static final String EN_STYLE_CATEGORY = "Style";
    private static final Map<String, String> punctuationCategories = Map.of("en", "Punctuation", "ru", "\u041f\u0443\u043d\u043a\u0442\u0443\u0430\u0446\u0438\u044f", "uk", "\u041f\u0443\u043d\u043a\u0442\u0443\u0430\u0446\u0456\u044f", "de", "Interpunktion");
    private static final Map<String, String> grammarCategories = Map.of("en", "Grammar", "ru", "\u0413\u0440\u0430\u043c\u043c\u0430\u0442\u0438\u043a\u0430", "uk", "\u0413\u0440\u0430\u043c\u0430\u0442\u0438\u043a\u0430", "de", "Grammatik");
    private static final Map<String, String> styleCategories = Map.of("en", "Style", "ru", "\u0421\u0442\u0438\u043b\u044c", "uk", "\u0421\u0442\u0438\u043b\u044c", "de", "Stil");
    private static final Map<String, String> semanticCategories = Map.of("en", "Semantics", "ru", "\u041b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043e\u0448\u0438\u0431\u043a\u0438", "uk", "\u041b\u043e\u0433\u0456\u0447\u043d\u0456 \u043f\u043e\u043c\u0438\u043b\u043a\u0438", "de", "Semantische Unstimmigkeiten");
    private static final Map<String, String> typographyCategories = Map.of("en", "Typography", "ru", "\u0422\u0438\u043f\u043e\u0433\u0440\u0430\u0444\u0438\u043a\u0430", "uk", "\u0422\u0438\u043f\u043e\u0433\u0440\u0430\u0444\u0456\u044f", "de", "Typografie");
    private static final Map<String, String> spellingCategories = Map.of("en", "Possible Typo", "ru", "\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043e\u0440\u0444\u043e\u0433\u0440\u0430\u0444\u0438\u0438", "uk", "\u041e\u0440\u0444\u043e\u0433\u0440\u0430\u0444\u0456\u044f", "de", "M\u00f6gliche Tippfehler");
    @ApiStatus.Internal
    public static final String SMART_APOSTROPHE = "Grazie.RuleEngine.En.Typography.SMART_APOSTROPHE";
    public static String RULE_ENGINE_PREFIX = Strings.trimEnd((String)"Grazie.RuleEngine.", (char)'.');

    public static List<com.intellij.grazie.text.Rule> getRules(Language language) {
        if (!APIQueries.ruleLanguages.contains(language) || SentenceBatcher.findInstalledLTLanguage(language) == null) {
            return List.of();
        }
        LanguageToolkit toolkit = LanguageToolkit.forLanguage(language);
        return ContainerUtil.map(toolkit.publishedRules(), rule -> TreeRuleChecker.toGrazieRule(rule, toolkit));
    }

    public static com.intellij.grazie.text.Rule toGrazieRule(final Rule rule, final LanguageToolkit toolkit) {
        final String langCode = rule.language().getIso().toString();
        String category = rule.id.startsWith("Style.") ? styleCategories.get(langCode) : (rule.id.startsWith("Typography.") ? typographyCategories.get(langCode) : (rule.id.startsWith("Punctuation.") ? punctuationCategories.get(langCode) : (rule.id.startsWith("Semantics.") ? semanticCategories.get(langCode) : (rule.id.startsWith("Spelling.") ? spellingCategories.get(langCode) : grammarCategories.get(langCode)))));
        String id = rule.globalId();
        final List<String> categories = rule.isStyleLike() ? List.of(styleCategories.get(langCode), "Grazie Pro") : List.of(category);
        return new com.intellij.grazie.text.Rule(id, rule.displayName, categories.get(0)){

            public List<String> getCategories() {
                return categories;
            }

            @NotNull
            public String getDescription() {
                List<Example> examples = rule.getExamples(RuleIdeClient.INSTANCE);
                String result2 = rule.getDescription(RuleIdeClient.INSTANCE) + "<br><br>";
                if (!examples.isEmpty()) {
                    result2 = result2 + "<p style='padding-bottom:5px;'>" + GrazieProBundle.msg("grazie.settings.grammar.rule.examples", new String[0]) + "</p><table style='width:100%;' cellspacing=0 cellpadding=0>\n";
                    for (Example example : examples) {
                        String corrections = StreamEx.of(example.correctedTexts()).map(s -> s + "<br>").joining();
                        result2 = result2 + TreeRuleChecker.renderExampleRow(example, corrections);
                    }
                    result2 = result2 + "</table><br/>";
                }
                if (!"en".equals(langCode)) {
                    result2 = result2 + GrazieProBundle.msg("grazie.settings.grammar.cloud.only.rule", new String[0]) + "<br><br>";
                }
                String string = result2;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public boolean isEnabledByDefault() {
                return rule.isRuleEnabledByDefault(GrazieProConfig.get().getTextStyle(), RuleIdeClient.INSTANCE);
            }

            public Navigatable editSettings() {
                RuleSetting setting = new RuleSetting(rule, new Parameter[0]);
                return StyleConfigurable.affectedSettings(toolkit).contains(setting) ? StyleConfigurable.focusSetting(setting, null) : null;
            }

            @Nullable
            public URL getUrl() {
                return rule.url;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ml/grazie/pro/TreeRuleChecker$1", "getDescription"));
            }
        };
    }

    private static String renderExampleRow(Example example, String corrections) {
        String result2 = "<tr><td valign='top' style='padding-bottom: 5px; padding-right: 5px; color: gray;'>" + GrazieProBundle.msg("grazie.settings.grammar.rule.incorrect", new String[0]) + "&nbsp;</td><td style='padding-bottom: 5px; width: 100%'>" + TreeRuleChecker.visualizeSpace(example.errorText()) + "</td></tr>";
        if (!corrections.isEmpty()) {
            return result2 + "<tr><td valign='top' style='padding-bottom: 10px; padding-right: 5px; color: gray;'>" + GrazieProBundle.msg("grazie.settings.grammar.rule.correct", new String[0]) + "</td><td style='padding-bottom: 10px; width: 100%;'>" + TreeRuleChecker.visualizeSpace(corrections) + "</td></tr>";
        }
        return result2;
    }

    private static String visualizeSpace(String s) {
        return s.replaceAll("\n", "\u23ce");
    }

    private static List<MatchingResult> doCheck(TextContent text2, List<ParsedSentence> sentences2) {
        if (sentences2.isEmpty()) {
            return List.of();
        }
        Tree.ParameterValues parameters = TreeRuleChecker.calcParameters(sentences2);
        List trees2 = ContainerUtil.map(sentences2, s -> s.tree.withParameters(parameters));
        AtomicReference ref = (AtomicReference)CachedValuesManager.getManager((Project)text2.getContainingFile().getProject()).getCachedValue((UserDataHolder)text2, () -> CachedValueProvider.Result.create(new AtomicReference(), (Object[])new Object[]{HighlightingUtil.grazieConfigTracker()}));
        try {
            if (ref.get() == null) {
                List<Rule> rules = TreeRuleChecker.enabledRules(sentences2.get((int)0).tree.treeSupport().getGrazieLanguage());
                List<MatchingResult> matches = TreeRuleChecker.matchTrees(trees2, rules);
                if (matches.stream().anyMatch(m -> !m.isEmpty())) {
                    matches = TreeRuleChecker.removeMarkupDependentMatches(text2, rules, matches, parameters);
                }
                ref.set(matches);
            }
            return (List)ref.get();
        }
        catch (Throwable e) {
            Throwable cause = ExceptionUtil.getRootCause((Throwable)e);
            if (cause instanceof ProcessCanceledException) {
                ProcessCanceledException pce = (ProcessCanceledException)cause;
                throw pce;
            }
            throw e;
        }
    }

    private static List<Rule> enabledRules(Language language) {
        LanguageToolkit toolkit = LanguageToolkit.forLanguage(language);
        return ContainerUtil.filter(toolkit.publishedRules(), r -> TreeRuleChecker.toGrazieRule(r, toolkit).isCurrentlyEnabled());
    }

    private static List<MatchingResult> matchTrees(List<Tree> trees2, List<Rule> rules) {
        return StreamEx.of(trees2).map(tree -> MatchingResult.concat(rules.stream().map(rule -> {
            ProgressManager.checkCanceled();
            return rule.match(List.of(tree));
        }))).toList();
    }

    private static Tree.ParameterValues calcParameters(List<ParsedSentence> sentences2) {
        String[] countries;
        HashMap<String, String> parameters = new HashMap<String, String>();
        org.languagetool.Language ltLanguage = sentences2.get((int)0).tree.language();
        Language language = sentences2.get((int)0).tree.treeSupport().getGrazieLanguage();
        LanguageToolkit toolkit = LanguageToolkit.forLanguage(language);
        toolkit.allParameters(RuleIdeClient.INSTANCE).forEach(p -> parameters.put(p.id(), TreeRuleChecker.getParamValue(p, language)));
        if ((language == Language.ENGLISH || language == Language.GERMAN) && (countries = ltLanguage.getCountries()).length > 0) {
            String variant = countries[0];
            if (language == Language.ENGLISH && variant.equals("GB") && GrazieProConfig.get().getUseOxfordSpelling()) {
                variant = "GB-oxendict";
            }
            parameters.put("variant", variant);
        }
        return new Tree.ParameterValues(parameters);
    }

    @Nullable
    private static String getParamValue(Parameter param, Language language) {
        String value = GrazieProConfig.get().paramValue(language, param);
        if (value == null || param.possibleValues(RuleIdeClient.INSTANCE).stream().noneMatch(v -> value.equals(v.id()))) {
            return param.defaultValue(GrazieProConfig.get().getTextStyle(), RuleIdeClient.INSTANCE).id();
        }
        return value;
    }

    private static List<MatchingResult> removeMarkupDependentMatches(TextContent text2, List<Rule> rules, List<MatchingResult> result2, Tree.ParameterValues parameters) {
        QuotedMarkup quotedText = QuotedMarkup.createFrom(text2);
        if (quotedText == null) {
            return result2;
        }
        List<Tree> quotedTrees = TreeRuleChecker.getQuotedTrees(quotedText, parameters);
        List quotedMatches = StreamEx.of(TreeRuleChecker.matchTrees(quotedTrees, rules)).toFlatList(quotedResults -> quotedResults.matches);
        return ContainerUtil.map(result2, mr -> MatchingResult.from(ContainerUtil.filter(mr.matches, rm -> quotedMatches.stream().anyMatch(qm -> TreeRuleChecker.isEquivalent(quotedText, rm, qm)))));
    }

    private static List<Tree> getQuotedTrees(QuotedMarkup quoted, Tree.ParameterValues parameters) {
        SentenceBatcher.AsyncBatchParser<Tree> parser = DependencyParser.getParser(quoted.original(), false);
        if (parser == null) {
            return List.of();
        }
        List<String> toParse = quoted.sentences().stream().map(t -> t.getToken()).distinct().toList();
        if (toParse.isEmpty()) {
            return List.of();
        }
        LinkedHashMap<String, Tree> map2 = parser.parse(toParse);
        return ContainerUtil.mapNotNull(quoted.sentences(), s -> {
            Tree tree = (Tree)map2.get(s.getToken());
            return tree == null ? null : tree.withStartOffset(s.getRange().getStart()).withParameters(parameters);
        });
    }

    private static boolean isEquivalent(QuotedMarkup quotedText, RuleMatch bareMatch, RuleMatch quotedMatch) {
        ProgressManager.checkCanceled();
        return quotedMatch.rule().equals(bareMatch.rule()) && ContainerUtil.map(bareMatch.reportedRanges(), r -> TreeRuleChecker.toIdeaRange(r)).equals(ContainerUtil.map(quotedMatch.reportedRanges(), r -> quotedText.quotedToOriginal(TreeRuleChecker.toIdeaRange(r))));
    }

    public static List<TreeProblem> checkTextLevelProblems(PsiFile file) {
        List<SentenceWithContent> doc = TreeRuleChecker.obtainDocument(file);
        if (doc.isEmpty()) {
            return List.of();
        }
        List<TreeProblem> result2 = TreeRuleChecker.documentProblems(file, doc);
        List ignored = ContainerUtil.findAll(result2, p -> TreeRuleChecker.findIgnoringFilter(p) != null);
        if (ignored.isEmpty()) {
            return result2;
        }
        Set docIgnoredRanges = ContainerUtil.map2Set((Collection)ignored, p -> ai.grazie.rules.tree.TextRange.spanRanges(p.match.reportedRanges().stream()));
        return TreeRuleChecker.documentProblems(file, ContainerUtil.map(doc, swc -> new SentenceWithContent((DocumentSentence.Analyzed)swc.sentence.withSuppressions((Set)Sets.union((Set)swc.sentence.suppressions, TreeRuleChecker.sentenceRanges(docIgnoredRanges, swc.sentence))), swc.content, swc.contentStart)));
    }

    private static Set<ai.grazie.rules.tree.TextRange> sentenceRanges(Set<ai.grazie.rules.tree.TextRange> docRanges, DocumentSentence sentence) {
        TextRange sentenceRange = TextRange.from((int)sentence.offset, (int)sentence.text.length());
        return ((StreamEx)StreamEx.of(docRanges).filter(r -> sentenceRange.containsRange(r.start(), r.end()))).map(r -> r.shiftLeft(sentenceRange.getStartOffset())).toSet();
    }

    private static List<TreeProblem> documentProblems(PsiFile file, List<SentenceWithContent> doc) {
        ArrayList<TreeProblem> result2 = new ArrayList<TreeProblem>();
        MatchingResult mr = TreeRuleChecker.checkDocument(doc);
        for (RuleMatch match : mr.matches) {
            List<ai.grazie.rules.tree.TextRange> reportedRanges = match.reportedRanges();
            ai.grazie.rules.tree.TextRange firstRange = reportedRanges.get(0);
            SentenceWithContent sentence = TreeRuleChecker.findSentence(doc, firstRange.start(), firstRange.end());
            TextContent content = sentence.content;
            List highlightRanges = ContainerUtil.map(reportedRanges, r -> TreeRuleChecker.toIdeaRange(r).shiftLeft(sentence.contentStart));
            TreeProblem problem = new TreeProblem(match, content, List.of(), highlightRanges);
            result2.add(problem.withCustomFixes(ContainerUtil.map(match.problemFixes(), fix -> new TextLevelFix((PsiElement)file, TreeRuleChecker.getQuickFixText(fix, TreeRuleChecker.isAsciiContext(content)), TreeRuleChecker.fileLevelChanges(fix, doc)))));
        }
        return result2;
    }

    private static List<StringOperation> fileLevelChanges(ProblemFix fix, List<SentenceWithContent> doc) {
        return Arrays.stream(fix.getChanges()).map(c -> {
            SentenceWithContent sentence = TreeRuleChecker.findSentence(doc, c.getRange().getStart(), c.getRange().getEndExclusive());
            return StringOperation.replace((TextRange)sentence.content.textRangeToFile(IdeUtils.ijRange(c).shiftLeft(sentence.contentStart)), (CharSequence)c.getText());
        }).toList();
    }

    private static SentenceWithContent findSentence(List<SentenceWithContent> doc, int docStart, int docEnd) {
        ProgressManager.checkCanceled();
        SentenceWithContent sentence = (SentenceWithContent)ContainerUtil.find(doc, s -> s.sentence.offset <= docStart && docEnd <= s.sentence.offset + s.sentence.text.length());
        assert (sentence != null);
        return sentence;
    }

    private static MatchingResult checkDocument(List<SentenceWithContent> doc) {
        List<Language> languages = doc.stream().map(ds -> ds.sentence.language).filter(APIQueries.ruleLanguages::contains).distinct().toList();
        return MatchingResult.concat((Stream<MatchingResult>)((StreamEx)StreamEx.of(languages).flatCollection(TreeRuleChecker::enabledRules).filter(Rule::isStyleLike)).select(DocumentRule.class).map(r -> {
            ProgressManager.checkCanceled();
            return r.checkDocument(ContainerUtil.map((Collection)doc, SentenceWithContent::sentence));
        }));
    }

    private static Map<String, Set<ai.grazie.rules.tree.TextRange>> suppressedRanges() {
        HashMap<String, Set<ai.grazie.rules.tree.TextRange>> result2 = new HashMap<String, Set<ai.grazie.rules.tree.TextRange>>();
        int counter2 = 0;
        block0: for (String pattern : GrazieConfig.Companion.get().getSuppressingContext().getSuppressed()) {
            int sep = pattern.indexOf(124);
            if (sep < 2) continue;
            String fragment = pattern.substring(0, sep);
            String sentence = pattern.substring(sep + 1);
            int index = -1;
            while (true) {
                if (counter2++ % 1024 == 0) {
                    ProgressManager.checkCanceled();
                }
                if ((index = sentence.indexOf(fragment, index + 1)) < 0) continue block0;
                result2.computeIfAbsent(sentence, k -> new HashSet()).add(ai.grazie.rules.tree.TextRange.fromLength(index, fragment.length()));
            }
        }
        return result2;
    }

    private static List<SentenceWithContent> obtainDocument(PsiFile file) {
        Map<String, Set<ai.grazie.rules.tree.TextRange>> suppressedRanges = TreeRuleChecker.suppressedRanges();
        ArrayList<SentenceWithContent> doc = new ArrayList<SentenceWithContent>();
        int offset = 0;
        for (TextContent content : HighlightingUtil.getCheckedFileTexts(file.getViewProvider())) {
            List<ParsedSentence> sentences2;
            if (HighlightingUtil.isTooLargeText(List.of(content)) || (sentences2 = ParsedSentence.getSentences(content)).isEmpty()) continue;
            List<MatchingResult> matches = TreeRuleChecker.doCheck(content, sentences2);
            for (int i = 0; i < sentences2.size(); ++i) {
                ParsedSentence parsed = sentences2.get(i);
                String trimmed = parsed.text.trim();
                int trimmedStart = parsed.text.indexOf(trimmed);
                Set suppressions = ContainerUtil.map2Set((Collection)suppressedRanges.getOrDefault(trimmed, Set.of()), r -> r.shiftRight(trimmedStart));
                DocumentSentence.Analyzed ds = new DocumentSentence(parsed.text, offset + parsed.textStartOffset, parsed.tree.treeSupport().getGrazieLanguage()).withIntro(i == 0 ? TreeRuleChecker.getIntro(content) : List.of()).withExclusions(SentenceTokenizer.sentenceExclusions(content, TextRange.from((int)parsed.textStartOffset, (int)parsed.text.length()))).withSuppressions(suppressions).withTree(parsed.tree.withStartOffset(offset + parsed.textStartOffset)).withMetadata(matches.get((int)i).metadata);
                doc.add(new SentenceWithContent(ds, content, offset));
            }
            offset += content.length();
        }
        return doc;
    }

    private static List<Delimiter> getIntro(TextContent content) {
        ArrayList<Delimiter> intros = new ArrayList<Delimiter>(List.of(Delimiter.fragmentBoundary));
        switch (content.getDomain()) {
            case COMMENTS: {
                intros.add(Delimiter.codeCommentStart);
                break;
            }
            case DOCUMENTATION: {
                intros.add(Delimiter.codeDocumentationStart);
                break;
            }
            case LITERALS: {
                intros.add(Delimiter.stringLiteralStart);
                break;
            }
        }
        return intros;
    }

    private static ProblemFilter findIgnoringFilter(TreeProblem p) {
        return ProblemFilter.allIgnoringFilters((TextProblem)p).findFirst().orElse(null);
    }

    static List<TreeProblem> check(TextContent text2, List<ParsedSentence> sentences2) {
        List<MatchingResult> mr = TreeRuleChecker.doCheck(text2, sentences2);
        List<TreeProblem> problems2 = TreeRuleChecker.checkPlainProblems(text2, mr);
        AutoFix.consider(text2, problems2);
        return problems2;
    }

    private static List<TreeProblem> checkPlainProblems(TextContent text2, List<MatchingResult> matchingResults) {
        ArrayList<TreeProblem> problems2 = new ArrayList<TreeProblem>();
        for (RuleMatch match : ContainerUtil.flatMap(matchingResults, mr -> mr.matches)) {
            NodeRuleMatch nrm;
            ProgressManager.checkCanceled();
            if (match instanceof NodeRuleMatch && TreeRuleChecker.touchesUnknownFragments(text2, (nrm = (NodeRuleMatch)match).result().touchedRange(), match.rule())) continue;
            ContainerUtil.addIfNotNull(problems2, (Object)((Object)TreeRuleChecker.createProblem(text2, match)));
        }
        return problems2;
    }

    @Nullable
    private static TreeProblem createProblem(TextContent text2, RuleMatch match) {
        Rule rule = match.rule();
        if (TreeRuleChecker.shouldSuppressByPlace(rule, text2)) {
            return null;
        }
        boolean asciiContext = TreeRuleChecker.isAsciiContext(text2);
        List<ProblemFix> fixes = match.problemFixes();
        if (asciiContext && TreeRuleChecker.shouldSuppressInAsciiContext(rule, fixes)) {
            return null;
        }
        if (rule.language() == Language.ENGLISH && rule.id.equals("Typography.VARIANT_QUOTE_PUNCTUATION") && text2.getDomain() != TextContent.TextDomain.PLAIN_TEXT && match.reportedRanges().size() == 1 && match.reportedRanges().get(0).shiftRight(0).substring(text2.toString()).matches(".*['\"]\\p{P}")) {
            return null;
        }
        List suggestions = ContainerUtil.map(fixes, fix -> new MySuggestion((ProblemFix)fix, asciiContext, text2));
        if (suggestions.stream().anyMatch(s -> !s.changesText())) {
            return null;
        }
        return new TreeProblem(match, text2, suggestions);
    }

    private static boolean isAsciiContext(TextContent text2) {
        return text2.getDomain() != TextContent.TextDomain.PLAIN_TEXT || text2.getContainingFile() instanceof PsiPlainTextFile;
    }

    private static boolean shouldSuppressInAsciiContext(Rule rule, List<ProblemFix> fixes) {
        if ((rule.id.contains("DASH") || rule.id.endsWith("HYPHEN_IN_RANGES")) && fixes.stream().map(ProblemFix::getChanges).anyMatch(c -> ((ProblemFix.Part.Change[])c).length == 1 && TreeRuleChecker.ignoreDashReplacement(c[0]))) {
            return true;
        }
        return rule.id.endsWith(".ASCII_APPROXIMATIONS");
    }

    private static boolean shouldSuppressByPlace(Rule rule, TextContent text2) {
        TextContent.TextDomain domain = text2.getDomain();
        if (rule.id.endsWith("Style.VERY_ABUSE") || rule.id.matches(".*Style\\.SPELLING_OUT.*NUMBERS.*")) {
            return CommitMessage.isCommitMessage((PsiElement)text2.getContainingFile()) || domain == TextContent.TextDomain.DOCUMENTATION || domain == TextContent.TextDomain.COMMENTS;
        }
        if (rule.id.endsWith("Style.CONDESCENDING")) {
            return CommitMessage.isCommitMessage((PsiElement)text2.getContainingFile()) || domain == TextContent.TextDomain.COMMENTS;
        }
        return false;
    }

    private static boolean ignoreDashReplacement(ProblemFix.Part.Change change) {
        return change.getRange().getLength() > 1 && change.getText().contains("\u2014");
    }

    private static boolean touchesUnknownFragments(TextContent text2, ai.grazie.rules.tree.TextRange range, Rule rule) {
        TextRange ruleRangeInText = TreeRuleChecker.toIdeaRange(range);
        if (ruleRangeInText.getEndOffset() > text2.length()) {
            LOG.error("Invalid match range " + String.valueOf(ruleRangeInText) + " for rule " + String.valueOf(rule) + " in a text of length " + text2.length(), new Attachment[]{new Attachment("text.txt", text2.toString())});
            return true;
        }
        return text2.hasUnknownFragmentsIn(TextUtils.expandToTouchWords((CharSequence)text2, ruleRangeInText));
    }

    public static TextRange toIdeaRange(ai.grazie.rules.tree.TextRange reported) {
        return new TextRange(reported.start(), reported.end());
    }

    private static String getQuickFixText(ProblemFix fix, boolean asciiContext) {
        if (fix.getCustomDisplayName() != null) {
            return fix.getCustomDisplayName();
        }
        return TreeRuleChecker.visualizeSpace(StreamEx.of((Object[])fix.getParts()).map(p -> p instanceof ProblemFix.Part.Skip ? p.getDisplay() : TreeRuleChecker.adjustTypography(p.getDisplay(), asciiContext)).joining());
    }

    private static String adjustTypography(String text2, boolean asciiContext) {
        if (asciiContext) {
            text2 = Strings.replace((String)text2, List.of("\u2013", "\u2014", "\u00a0", "\u2009", "\u202f", "\u2026"), List.of("-", "-", " ", " ", " ", "..."));
            text2 = text2.replaceAll("[\u201c\u201d\u201e\u00ab\u00bb]", "\"").replaceAll("[`\u2018]", "'");
        }
        if (text2.contains("\u2019") && (asciiContext || !GrazieConfig.Companion.get().getUserEnabledRules().contains(SMART_APOSTROPHE))) {
            text2 = text2.replace('\u2019', '\'');
        }
        return text2;
    }

    private record SentenceWithContent(DocumentSentence.Analyzed sentence, TextContent content, int contentStart) {
    }

    public static class TreeProblem
    extends TextProblem {
        public final RuleMatch match;
        final boolean concedeToOtherCheckers;
        private final List<MySuggestion> suggestions;
        private final List<LocalQuickFix> customFixes;

        TreeProblem(RuleMatch match, TextContent text2, List<MySuggestion> suggestions) {
            this(match, text2, suggestions, ContainerUtil.map(match.reportedRanges(), r -> TreeRuleChecker.toIdeaRange(r)));
        }

        TreeProblem(RuleMatch match, TextContent text2, List<MySuggestion> suggestions, List<TextRange> highlightRanges) {
            this(TreeRuleChecker.toGrazieRule(match.rule(), LanguageToolkit.forLanguage(match.rule().language())), text2, highlightRanges, match, suggestions, List.of(), match.concedeToOtherGrammarCheckers());
        }

        private TreeProblem(@NotNull com.intellij.grazie.text.Rule ideaRule, @NotNull TextContent text2, @NotNull List<TextRange> highlightRanges, RuleMatch match, List<MySuggestion> suggestions, List<LocalQuickFix> customFixes, boolean concedeToOtherCheckers) {
            if (text2 == null) {
                TreeProblem.$$$reportNull$$$0(0);
            }
            if (highlightRanges == null) {
                TreeProblem.$$$reportNull$$$0(1);
            }
            if (ideaRule == null) {
                TreeProblem.$$$reportNull$$$0(2);
            }
            super(ideaRule, text2, highlightRanges);
            this.match = match;
            this.suggestions = suggestions;
            this.customFixes = customFixes;
            this.concedeToOtherCheckers = concedeToOtherCheckers;
        }

        @NotNull
        public String getShortMessage() {
            String string = Objects.requireNonNull(this.match.message());
            if (string == null) {
                TreeProblem.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String getDescriptionTemplate(boolean isOnTheFly) {
            String string = this.getShortMessage();
            if (string == null) {
                TreeProblem.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public List<TextProblem.Suggestion> getSuggestions() {
            return new ArrayList<TextProblem.Suggestion>(this.suggestions);
        }

        @NotNull
        public List<LocalQuickFix> getCustomFixes() {
            List list = ContainerUtil.concat(this.customFixes, (List)ContainerUtil.mapNotNull(this.match.actions(), sug -> {
                if (sug instanceof ActionSuggestion.ChangeParameter) {
                    ActionSuggestion.ChangeParameter cp = (ActionSuggestion.ChangeParameter)sug;
                    if (cp.parameter().id().equals("variant")) {
                        return ChangeLanguageVariant.create(this.match.rule().language(), Objects.requireNonNull(cp.suggestedValue()), cp.quickFixText());
                    }
                    return new ConfigureSuggestedParameter(cp.parameter(), cp.quickFixText());
                }
                return null;
            }));
            if (list == null) {
                TreeProblem.$$$reportNull$$$0(5);
            }
            return list;
        }

        public TreeProblem withCustomFixes(List<? extends LocalQuickFix> fixes) {
            return new TreeProblem(this.getRule(), this.getText(), this.getHighlightRanges(), this.match, this.suggestions, ContainerUtil.concat(this.customFixes, fixes), this.concedeToOtherCheckers);
        }

        public boolean fitsGroup(@NotNull RuleGroup group) {
            if (group == null) {
                TreeProblem.$$$reportNull$$$0(6);
            }
            Set rules = group.getRules();
            NodeMatch.SuppressableKind kind = this.match.suppressableKind();
            if (rules.contains("INCOMPLETE_SENTENCE") && kind == NodeMatch.SuppressableKind.INCOMPLETE_SENTENCE) {
                return true;
            }
            if (rules.contains("UPPERCASE_SENTENCE_START") && kind == NodeMatch.SuppressableKind.UPPERCASE_SENTENCE_START) {
                return true;
            }
            if (rules.contains("PUNCTUATION_PARAGRAPH_END") && kind == NodeMatch.SuppressableKind.UNFINISHED_SENTENCE) {
                return true;
            }
            if (rules.contains("UNDECORATED_SENTENCE_SEPARATION") && kind == NodeMatch.SuppressableKind.UNDECORATED_SENTENCE_SEPARATION) {
                return true;
            }
            if (rules.contains("UNLIKELY_OPENING_PUNCTUATION") && kind == NodeMatch.SuppressableKind.UNLIKELY_OPENING_PUNCTUATION) {
                return true;
            }
            return super.fitsGroup(group);
        }

        public boolean shouldSuppressInCodeLikeFragments() {
            return this.match.rule().shouldSuppressInCodeLikeFragments();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "highlightRanges";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ideaRule";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ml/grazie/pro/TreeRuleChecker$TreeProblem";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ml/grazie/pro/TreeRuleChecker$TreeProblem";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShortMessage";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescriptionTemplate";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCustomFixes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "fitsGroup";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    private record MySuggestion(ProblemFix fix, boolean asciiContext, TextContent text) implements TextProblem.Suggestion
    {
        public List<StringOperation> getChanges() {
            return ContainerUtil.map((Object[])this.fix.getChanges(), r -> StringOperation.replace((TextRange)IdeUtils.ijRange(r), (CharSequence)TreeRuleChecker.adjustTypography(r.getText(), this.asciiContext)));
        }

        public String getPresentableText() {
            return TreeRuleChecker.getQuickFixText(this.fix, this.asciiContext);
        }

        @Nullable
        public String getBatchId() {
            return this.fix.getBatchId();
        }

        boolean changesText() {
            return this.getChanges().stream().anyMatch(op -> !op.getReplacement().equals(op.getRange().substring(this.text.toString())));
        }
    }

    public static class DocProblemFilter
    extends ProblemFilter {
        private static final Pattern PY_DOC_PARAM = Pattern.compile("[a-z0-9_]+\\s*:\\s+\\p{L}+( or \\p{L}+)*");

        public boolean shouldIgnore(@NotNull TextProblem problem) {
            if (problem == null) {
                DocProblemFilter.$$$reportNull$$$0(0);
            }
            if (GrazieUtilsKt.isFunctionallyDisabled()) {
                return false;
            }
            TextContent text2 = problem.getText();
            if (text2.getDomain() == TextContent.TextDomain.DOCUMENTATION) {
                List ranges = problem.getHighlightRanges();
                String psiClass = text2.getCommonParent().getClass().getName();
                if (psiClass.equals("com.jetbrains.python.psi.impl.PyStringLiteralExpressionImpl")) {
                    Matcher matcher = PY_DOC_PARAM.matcher((CharSequence)text2);
                    while (matcher.find()) {
                        if (!ranges.stream().anyMatch(r -> r.intersects(matcher.start(), matcher.end()))) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problem", "com/intellij/ml/grazie/pro/TreeRuleChecker$DocProblemFilter", "shouldIgnore"));
        }
    }
}

