/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.grazie.pro.editor;

import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.grazie.ide.fus.AcceptanceRateTracker;
import com.intellij.grazie.ide.inspection.grammar.quickfix.GrazieReplaceTypoQuickFix;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextProblem;
import com.intellij.ml.grazie.pro.GrazieProBundle;
import com.intellij.ml.grazie.pro.GrazieProConfig;
import com.intellij.ml.grazie.pro.TreeRuleChecker;
import com.intellij.ml.grazie.pro.editor.ChangeTracker;
import com.intellij.ml.grazie.pro.fus.GrazieProCounterUsagesCollector;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;

public class AutoFix {
    public static void consider(TextContent text2, List<TreeRuleChecker.TreeProblem> problems2) {
        PsiFile file;
        Document document;
        List candidates;
        if (GrazieProConfig.get().getAutoFix() && !problems2.isEmpty() && !(candidates = ContainerUtil.filter(problems2, arg_0 -> AutoFix.lambda$consider$0(document = (file = text2.getContainingFile()).getViewProvider().getDocument(), arg_0))).isEmpty()) {
            AutoFix.scheduleAutoFix(file, candidates);
        }
    }

    private static void scheduleAutoFix(PsiFile file, List<TreeRuleChecker.TreeProblem> problems2) {
        Map<TreeRuleChecker.TreeProblem, List<IntentionAndQuickFixAction>> fixes = AutoFix.collectFixes(problems2);
        Document document = file.getViewProvider().getDocument();
        long stamp = document.getModificationStamp();
        ApplicationManager.getApplication().invokeLater(() -> {
            if (file.isValid() && stamp == document.getModificationStamp()) {
                AutoFix.applyFixes(file, fixes);
            }
        });
    }

    private static List<IntentionAndQuickFixAction> selectFixes(List<LocalQuickFix> fixes) {
        return StreamEx.of(fixes).select(IntentionAndQuickFixAction.class).toList();
    }

    private static Map<TreeRuleChecker.TreeProblem, List<IntentionAndQuickFixAction>> collectFixes(List<TreeRuleChecker.TreeProblem> candidates) {
        return StreamEx.of(candidates).mapToEntry(it -> AutoFix.selectFixes(GrazieReplaceTypoQuickFix.getReplacementFixes((TextProblem)it, List.of()))).toMap();
    }

    private static void applyFixes(final PsiFile file, Map<TreeRuleChecker.TreeProblem, List<IntentionAndQuickFixAction>> fixes) {
        final Project project = file.getProject();
        for (Map.Entry<TreeRuleChecker.TreeProblem, List<IntentionAndQuickFixAction>> entry2 : fixes.entrySet()) {
            TreeRuleChecker.TreeProblem problem = entry2.getKey();
            for (final IntentionAndQuickFixAction fix : entry2.getValue()) {
                final AcceptanceRateTracker tracker = new AcceptanceRateTracker((TextProblem)entry2.getKey());
                WriteCommandAction.runWriteCommandAction((Project)project, (String)AutoFix.commandName(problem), null, () -> {
                    var action = new BasicUndoableAction(new VirtualFile[]{file.getViewProvider().getVirtualFile()}){

                        public void undo() {
                            GrazieProCounterUsagesCollector.reportAutoFixUndone(tracker);
                        }

                        public void redo() {
                            fix.applyFix(project, file, null);
                            GrazieProCounterUsagesCollector.reportAutoFixApplied(tracker);
                        }
                    };
                    action.redo();
                    UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)action);
                }, (PsiFile[])new PsiFile[0]);
            }
        }
    }

    private static String commandName(TreeRuleChecker.TreeProblem candidate) {
        String message = candidate.getShortMessage();
        return GrazieProBundle.msg("auto.apply.fix.command.name", message);
    }

    private static boolean shouldAutoFix(Document document, TreeRuleChecker.TreeProblem problem) {
        if (!problem.match.autoFixCapable() || problem.getSuggestions().size() != 1) {
            return false;
        }
        List changes = problem.getSuggestions().get(0).getChanges();
        TextContent text2 = problem.getText();
        List fileRanges = ContainerUtil.map((Collection)changes, c -> text2.textRangeToFile(c.getRange()));
        for (Editor editor : EditorFactory.getInstance().getEditors(document, text2.getContainingFile().getProject())) {
            for (Caret caret : editor.getCaretModel().getAllCarets()) {
                if (!fileRanges.stream().anyMatch(r -> r.containsOffset(caret.getOffset()))) continue;
                return false;
            }
        }
        ChangeTracker tracker = ChangeTracker.getInstance();
        return ContainerUtil.exists((Iterable)fileRanges, r -> tracker.mayAutoChange(document, (TextRange)r)) && !ContainerUtil.exists((Iterable)fileRanges, r -> tracker.isExplicitlyUndone(document, (TextRange)r));
    }

    private static /* synthetic */ boolean lambda$consider$0(Document document, TreeRuleChecker.TreeProblem p) {
        return AutoFix.shouldAutoFix(document, p);
    }
}

