/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.grazie.pro.yaml;

import ai.grazie.rules.vale.YamlBasedRule;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.grazie.detection.LangDetector;
import com.intellij.grazie.jlanguage.Lang;
import com.intellij.grazie.text.Rule;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextProblem;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.ml.grazie.pro.HighlightingUtil;
import com.intellij.ml.grazie.pro.yaml.YamlScopeProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
public abstract class YamlRuleWrapper
extends Rule {
    private static final Set<String> POSSIBLY_NESTED_SCOPES = Set.of("emphasis", "strong", "link");
    final List<YamlBasedRule> rules;
    final String messageSuffix;
    public static String BUNDLED_YAML_PREFIX = "Bundled.Yaml";
    private static final LanguageExtension<YamlScopeProvider> SCOPE_EP = new LanguageExtension("com.intellij.ml.grazie.pro.yamlScopeProvider");

    protected YamlRuleWrapper(String globalId, String presentableName, String category, List<YamlBasedRule> rules, String messageSuffix) {
        super(globalId, presentableName, category);
        this.rules = rules;
        this.messageSuffix = messageSuffix;
    }

    public abstract boolean isBundled();

    @Nullable
    public URL getUrl() {
        try {
            YamlBasedRule.MetaData meta = this.rules.isEmpty() ? null : this.rules.get((int)0).meta;
            return meta == null || meta.link == null ? null : new URL(meta.link);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    public static String toGlobalId(String fileName) {
        return BUNDLED_YAML_PREFIX + ".En." + StringUtil.getPackageName((String)fileName).replaceAll(" ", "_").replaceAll("/", ".");
    }

    public static List<YamlProblem> checkRules(TextContent content, @Nullable Lang lang, List<YamlRuleWrapper> rules, boolean raw) {
        ArrayList<YamlProblem> result2 = new ArrayList<YamlProblem>();
        String text2 = content.toString();
        for (YamlRuleWrapper wrapper : rules) {
            for (YamlBasedRule rule : wrapper.rules) {
                ProgressManager.checkCanceled();
                PsiFile file = content.getContainingFile();
                List<YamlBasedRule.RuleMatch> matches = rule instanceof YamlBasedRule.WholeFileRule && lang != null ? YamlRuleWrapper.checkFile(file, lang, (YamlBasedRule.WholeFileRule)rule).getOrDefault(content.toString(), List.of()) : rule.check(text2);
                for (YamlBasedRule.RuleMatch match : matches) {
                    TextRange textRange = new TextRange(match.start(), match.end());
                    PsiElement minCovering = YamlRuleWrapper.findMinCoveringPsi(content, file, textRange);
                    if (minCovering == null || !wrapper.matchesScope(YamlRuleWrapper.psiScopes(minCovering), YamlRuleWrapper.contentScopes(content), raw)) continue;
                    result2.add(new YamlProblem(wrapper, rule, content, match, textRange));
                }
            }
        }
        return result2;
    }

    @Nullable
    private static PsiElement findMinCoveringPsi(TextContent content, PsiFile file, TextRange textRange) {
        TextRange fileRange = content.textRangeToFile(textRange);
        PsiElement leaf = file.findElementAt(fileRange.getStartOffset());
        return (PsiElement)SyntaxTraverser.psiApi().parents((Object)leaf).find(e -> e.getTextRange().getEndOffset() >= fileRange.getEndOffset());
    }

    private static Map<String, List<YamlBasedRule.RuleMatch>> checkFile(PsiFile file, Lang lang, YamlBasedRule.WholeFileRule rule) {
        FileViewProvider vp = file.getViewProvider();
        Map map2 = (Map)CachedValuesManager.getManager((Project)vp.getManager().getProject()).getCachedValue((UserDataHolder)vp, () -> {
            ConcurrentMap rule2Problems = ConcurrentFactoryMap.createMap(pair -> {
                List<String> texts = HighlightingUtil.getCheckedFileTexts(vp).stream().map(TextContent::toString).filter(t -> LangDetector.INSTANCE.getLang(t) == pair.second).toList();
                return ((YamlBasedRule.WholeFileRule)pair.first).checkFile(texts);
            });
            return CachedValueProvider.Result.create((Object)rule2Problems, (Object[])new Object[]{vp.getAllFiles().get(0)});
        });
        return (Map)map2.get(Pair.create((Object)rule, (Object)lang));
    }

    public boolean matchesRawScope(PsiElement psi) {
        return !this.rules.isEmpty() && this.matchesScope(POSSIBLY_NESTED_SCOPES, YamlRuleWrapper.psiScopes(psi), true);
    }

    public boolean matchesScope(TextContent content) {
        return !this.rules.isEmpty() && this.matchesScope(POSSIBLY_NESTED_SCOPES, YamlRuleWrapper.contentScopes(content), false);
    }

    private boolean matchesScope(Set<String> scopesUnderContent, Set<String> contentScopes, boolean raw) {
        List<String> ruleScopes = this.ruleScopes();
        if (ruleScopes.contains("raw") != raw) {
            return false;
        }
        if (ruleScopes.isEmpty()) {
            return true;
        }
        return ruleScopes.stream().allMatch(s -> s.equals("raw") || scopesUnderContent.contains(s) || contentScopes.contains(s));
    }

    private List<String> ruleScopes() {
        return StreamEx.of(this.rules.get((int)0).meta.ruleScopes).flatArray(s -> s.split("\\.")).toList();
    }

    private static Set<String> contentScopes(TextContent content) {
        return (Set)CachedValuesManager.getManager((Project)content.getContainingFile().getProject()).getCachedValue((UserDataHolder)content, () -> {
            PsiElement e = content.getCommonParent();
            PsiFile file = content.getContainingFile();
            HashSet<String> result2 = new HashSet<String>(YamlRuleWrapper.psiScopes(e));
            if (!(result2.contains("code") || result2.contains("text") || result2.contains("markup"))) {
                String extension = YamlRuleWrapper.getFileExtension(file);
                if (content.getDomain() != TextContent.TextDomain.PLAIN_TEXT) {
                    result2.add("code");
                } else if (extension != null && extension.matches("adoc|rst|xml")) {
                    result2.add("markup");
                } else {
                    result2.add("text");
                }
            }
            return new CachedValueProvider.Result(result2, new Object[]{file});
        });
    }

    private static Set<String> psiScopes(PsiElement e) {
        return (Set)CachedValuesManager.getProjectPsiDependentCache((PsiElement)e, __ -> {
            HashSet<String> result2 = new HashSet<String>();
            Language language = e.getLanguage();
            for (YamlScopeProvider provider : SCOPE_EP.allForLanguageOrAny(language)) {
                result2.addAll(provider.getApplicableScopes(e));
            }
            PsiElement parent = e.getParent();
            if (parent == null) {
                return result2;
            }
            Language parentLang = parent.getLanguage();
            if (parentLang != language) {
                for (YamlScopeProvider provider : SCOPE_EP.allForLanguageOrAny(parentLang)) {
                    result2.addAll(provider.getApplicableScopes(e));
                }
            }
            ContainerUtil.addIfNotNull(result2, (Object)YamlRuleWrapper.getFileExtension(e.getContainingFile()));
            result2.add("sentence");
            result2.add("paragraph");
            return result2;
        });
    }

    @Nullable
    private static String getFileExtension(@Nullable PsiFile file) {
        return file == null ? null : file.getViewProvider().getVirtualFile().getExtension();
    }

    public static class YamlProblem
    extends TextProblem {
        public final YamlBasedRule rule;
        private final YamlBasedRule.RuleMatch match;
        private final TextRange range;

        public YamlProblem(YamlRuleWrapper wrapper, YamlBasedRule rule, TextContent text2, YamlBasedRule.RuleMatch match, TextRange range) {
            super((Rule)wrapper, text2, range);
            this.rule = rule;
            this.match = match;
            this.range = range;
        }

        @Nullable
        public TextRange getPatternRange() {
            return this.range;
        }

        @NotNull
        public String getShortMessage() {
            String string = this.match.message();
            if (string == null) {
                YamlProblem.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        @InspectionMessage
        public String getDescriptionTemplate(boolean isOnTheFly) {
            String string = this.match.message().replaceAll("<", "&lt;").replaceAll(">", "&gt;") + ((YamlRuleWrapper)this.getRule()).messageSuffix;
            if (string == null) {
                YamlProblem.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public List<TextProblem.Suggestion> getSuggestions() {
            List list = ContainerUtil.map(this.match.suggestions(), s -> TextProblem.Suggestion.replace((TextRange)this.range, (CharSequence)s));
            if (list == null) {
                YamlProblem.$$$reportNull$$$0(2);
            }
            return list;
        }

        public boolean shouldSuppressInCodeLikeFragments() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/ml/grazie/pro/yaml/YamlRuleWrapper$YamlProblem";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShortMessage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescriptionTemplate";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuggestions";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

