/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.RepositoryManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0012\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005Jk\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2!\u0010\u0010\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00140\u001126\u0010\u0015\u001a2\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00140\u0016H\u0016J\b\u0010\u0019\u001a\u00020\rH\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J1\u0010\u001b\u001a\u0002H\u001c\"\u0004\b\u0000\u0010\u001c2\u0006\u0010\u000e\u001a\u00020\u000f2\u0014\u0010\u001d\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0004\u0012\u0002H\u001c0\u0011H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0018\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!H\u0016J \u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!H$J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010$\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010%\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u0014H$J\u0010\u0010'\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006("}, d2={"Lorg/jetbrains/settingsRepository/BaseRepositoryManager;", "Lorg/jetbrains/settingsRepository/RepositoryManager;", "dir", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "getDir", "()Ljava/nio/file/Path;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "processChildren", "", "path", "", "filter", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "", "processor", "Lkotlin/Function2;", "Ljava/io/InputStream;", "inputStream", "deleteRepository", "isPathIgnored", "read", "R", "consumer", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "write", "content", "", "addToIndex", "file", "delete", "deleteFromIndex", "isFile", "has", "intellij.settingsRepository"})
@SourceDebugExtension(value={"SMAP\nBaseRepositoryManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseRepositoryManager.kt\norg/jetbrains/settingsRepository/BaseRepositoryManager\n+ 2 path.kt\ncom/intellij/util/io/PathKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n159#2,2:189\n162#2,3:195\n83#3,3:191\n83#3,3:198\n61#3,5:201\n61#3,5:206\n61#3,5:211\n1#4:194\n*S KotlinDebug\n*F\n+ 1 BaseRepositoryManager.kt\norg/jetbrains/settingsRepository/BaseRepositoryManager\n*L\n35#1:189,2\n35#1:195,3\n52#1:191,3\n86#1:198,3\n97#1:201,5\n104#1:206,5\n124#1:211,5\n*E\n"})
public abstract class BaseRepositoryManager
implements RepositoryManager {
    @NotNull
    private final Path dir;
    @NotNull
    private final ReentrantReadWriteLock lock;

    public BaseRepositoryManager(@NotNull Path dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        this.dir = dir;
        this.lock = new ReentrantReadWriteLock();
    }

    @NotNull
    protected final Path getDir() {
        return this.dir;
    }

    @NotNull
    protected final ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void processChildren(@NotNull String path, @NotNull Function1<? super String, Boolean> filter, @NotNull Function2<? super String, ? super InputStream, Boolean> processor) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Path path2 = this.dir.resolve(path);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        Path path3 = path2;
        Function1 filter$iv = arg_0 -> BaseRepositoryManager.processChildren$lambda$0(filter, arg_0);
        boolean $i$f$directoryStreamIfExists = false;
        try {
            Unit unit;
            void $this$directoryStreamIfExists$iv;
            Closeable closeable = Files.newDirectoryStream((Path)$this$directoryStreamIfExists$iv, PathKt.makeFilter((Function1)filter$iv));
            Throwable throwable = null;
            try {
                DirectoryStream fileStream = (DirectoryStream)closeable;
                boolean bl = false;
                Iterator iterator = fileStream.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    boolean bl2;
                    Path file = (Path)iterator2.next();
                    BasicFileAttributes attributes = null;
                    try {
                        Intrinsics.checkNotNull((Object)file);
                        attributes = PathKt.basicAttributesIfExists((Path)file);
                    }
                    catch (IOException e) {
                        IcsManagerKt.getLOG().warn((Throwable)e);
                        continue;
                    }
                    if (attributes == null || attributes.isDirectory() || Files.isHidden(file)) continue;
                    if (attributes.size() == 0L) {
                        Object $this$runAndLogException_u24lambda_u240$iv;
                        Logger $this$runAndLogException$iv = IcsManagerKt.getLOG();
                        boolean $i$f$runAndLogException = false;
                        Logger logger = $this$runAndLogException$iv;
                        try {
                            $this$runAndLogException_u24lambda_u240$iv = logger;
                            boolean bl3 = false;
                            boolean bl4 = false;
                            IcsManagerKt.getLOG().warn("File " + path + " is empty (length 0), will be removed");
                            $this$runAndLogException_u24lambda_u240$iv = Result.constructor-impl((Object)this.delete(file, path));
                        }
                        catch (Throwable throwable2) {
                            $this$runAndLogException_u24lambda_u240$iv = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                        }
                        LoggerKt.getOrLogException((Object)$this$runAndLogException_u24lambda_u240$iv, (Logger)$this$runAndLogException$iv);
                        continue;
                    }
                    OpenOption[] openOptionArray = new OpenOption[]{};
                    InputStream inputStream = Files.newInputStream(file, Arrays.copyOf(openOptionArray, openOptionArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                    Closeable closeable2 = inputStream;
                    Throwable throwable3 = null;
                    try {
                        InputStream it = (InputStream)closeable2;
                        boolean bl5 = false;
                        bl2 = (Boolean)processor.invoke((Object)((Object)file.getFileName()).toString(), (Object)it);
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable3);
                    }
                    if (bl2) continue;
                    break;
                }
                unit = Unit.INSTANCE;
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            closeable = unit;
        }
        catch (NoSuchFileException noSuchFileException) {
            Object var7_8 = null;
        }
    }

    @Override
    public void deleteRepository() {
        PathKt.delete$default((Path)this.dir, (boolean)false, (int)1, null);
    }

    protected boolean isPathIgnored(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R read(@NotNull String path, @NotNull Function1<? super InputStream, ? extends R> consumer) {
        Object object;
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Path fileToDelete = null;
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            long l;
            boolean bl = false;
            Path file = this.dir.resolve(path);
            try {
                Intrinsics.checkNotNull((Object)file);
                l = Files.size(file);
            }
            catch (FileSystemException fileSystemException) {
                Object object2 = consumer.invoke(null);
                readLock.unlock();
                return (R)object2;
            }
            long size = l;
            if (size != 0L) {
                Object object3;
                Object object4 = file;
                Object object5 = new OpenOption[]{};
                InputStream inputStream = Files.newInputStream((Path)object4, Arrays.copyOf(object5, ((OpenOption[])object5).length));
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                object4 = inputStream;
                object5 = null;
                try {
                    object3 = consumer.invoke(object4);
                }
                catch (Throwable throwable) {
                    object5 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object4, (Throwable)object5);
                }
                Object object6 = object3;
                return (R)object6;
            }
            fileToDelete = file;
            unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
        Logger $this$runAndLogException$iv = IcsManagerKt.getLOG();
        boolean $i$f$runAndLogException = false;
        unit = $this$runAndLogException$iv;
        try {
            long l;
            Unit $this$runAndLogException_u24lambda_u240$iv = unit;
            boolean bl = false;
            boolean bl2 = false;
            try {
                l = Files.size(fileToDelete);
            }
            catch (FileSystemException fileSystemException) {
                l = -1L;
            }
            long size = l;
            if (size == 0L) {
                IcsManagerKt.getLOG().warn("File " + path + " is empty (length 0), will be removed");
                this.delete(fileToDelete, path);
            }
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
        return (R)consumer.invoke(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(@NotNull String path, @NotNull byte[] content) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Object $this$debug_u24default$iv = IcsManagerKt.getLOG();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Write " + path, e$iv);
        }
        try {
            $this$debug_u24default$iv = this.lock;
            ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)$this$debug_u24default$iv).readLock();
            int n = ((ReentrantReadWriteLock)$this$debug_u24default$iv).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)$this$debug_u24default$iv).getReadHoldCount() : 0;
            for (int i = 0; i < n; ++i) {
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)$this$debug_u24default$iv).writeLock();
            writeLock.lock();
            try {
                boolean bl = false;
                Path file = this.dir.resolve(path);
                Intrinsics.checkNotNull((Object)file);
                PathKt.write((Path)file, (byte[])content);
                if (this.isPathIgnored(path)) {
                    Logger $this$debug_u24default$iv2 = IcsManagerKt.getLOG();
                    Throwable e$iv2 = null;
                    boolean $i$f$debug2 = false;
                    if ($this$debug_u24default$iv2.isDebugEnabled()) {
                        Logger logger = $this$debug_u24default$iv2;
                        boolean bl2 = false;
                        logger.debug(path + " is ignored and will be not added to index", e$iv2);
                    }
                } else {
                    this.addToIndex(file, path, content);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                for (int i = 0; i < n; ++i) {
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }
        catch (Exception e) {
            IcsManagerKt.getLOG().error((Throwable)e);
            return false;
        }
        return true;
    }

    protected abstract void addToIndex(@NotNull Path var1, @NotNull String var2, @NotNull byte[] var3);

    @Override
    public boolean delete(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Logger $this$debug_u24default$iv = IcsManagerKt.getLOG();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Remove " + path, e$iv);
        }
        Path path2 = this.dir.resolve(path);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return this.delete(path2, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean delete(Path file, String path) {
        BasicFileAttributes basicFileAttributes = PathKt.basicAttributesIfExists((Path)file);
        if (basicFileAttributes == null) {
            return false;
        }
        BasicFileAttributes fileAttributes = basicFileAttributes;
        boolean isFile = fileAttributes.isRegularFile();
        if (!PathKt.deleteWithParentsIfEmpty((Path)file, (Path)this.dir, (boolean)isFile)) {
            return false;
        }
        if (!this.isPathIgnored(path)) {
            ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            for (int i = 0; i < n; ++i) {
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl = false;
                this.deleteFromIndex(path, isFile);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                for (int i = 0; i < n; ++i) {
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }
        return true;
    }

    protected abstract void deleteFromIndex(@NotNull String var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean has(@NotNull String path) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl2 = false;
            Path path2 = this.dir.resolve(path);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            Path path3 = path2;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            bl = Files.exists(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        }
        finally {
            readLock.unlock();
        }
        return bl;
    }

    private static final boolean processChildren$lambda$0(Function1 $filter, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Boolean)$filter.invoke((Object)((Object)it.getFileName()).toString());
    }
}

