/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.configurationStore.ApplicationStoreImplKt;
import com.intellij.configurationStore.ExportSettingsActionKt;
import com.intellij.configurationStore.LocalExportableItem;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.impl.stores.IComponentStoreKt;
import com.intellij.util.SmartList;
import com.intellij.util.lang.CompoundRuntimeException;
import java.io.Closeable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.settingsRepository.IcsManager;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u001a,\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000eR\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"copyLocalConfig", "", "storageManager", "Lcom/intellij/configurationStore/StateStorageManager;", "normalizeFileSpec", "", "absolutePath", "saveDirectory", "parent", "Ljava/nio/file/Path;", "parentFileSpec", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "streamProvider", "Lorg/jetbrains/settingsRepository/IcsManager$IcsStreamProvider;", "Lorg/jetbrains/settingsRepository/IcsManager;", "intellij.settingsRepository"})
@SourceDebugExtension(value={"SMAP\ncopyAppSettingsToRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 copyAppSettingsToRepository.kt\norg/jetbrains/settingsRepository/CopyAppSettingsToRepositoryKt\n+ 2 util.kt\ncom/intellij/util/containers/UtilKt\n+ 3 path.kt\ncom/intellij/util/io/PathKt\n*L\n1#1,72:1\n174#2,18:73\n152#3,6:91\n*S KotlinDebug\n*F\n+ 1 copyAppSettingsToRepository.kt\norg/jetbrains/settingsRepository/CopyAppSettingsToRepositoryKt\n*L\n26#1:73,18\n59#1:91,6\n*E\n"})
public final class CopyAppSettingsToRepositoryKt {
    @VisibleForTesting
    public static final void copyLocalConfig(@NotNull StateStorageManager storageManager) {
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        StreamProvider streamProvider = storageManager.getStreamProvider().getInstanceOf(IcsManager.IcsStreamProvider.class);
        Intrinsics.checkNotNull((Object)streamProvider, (String)"null cannot be cast to non-null type org.jetbrains.settingsRepository.IcsManager.IcsStreamProvider");
        IcsManager.IcsStreamProvider streamProvider2 = (IcsManager.IcsStreamProvider)streamProvider;
        Map fileToItems = ExportSettingsActionKt.getExportableItemsFromLocalStorage((Map)ExportSettingsActionKt.getExportableComponentsMap$default((boolean)false, null, (boolean)false, (boolean)false, (int)14, null), (StateStorageManager)storageManager);
        Collection $this$forEachGuaranteed$iv = fileToItems.keySet();
        boolean $i$f$forEachGuaranteed = false;
        Iterator $this$forEachGuaranteed$iv$iv = $this$forEachGuaranteed$iv.iterator();
        boolean $i$f$forEachGuaranteed2 = false;
        List errors$iv$iv = null;
        Iterator iterator = $this$forEachGuaranteed$iv$iv;
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            try {
                List list;
                String fileSpec;
                Path file;
                block8: {
                    file = (Path)element$iv$iv;
                    boolean bl = false;
                    fileSpec = null;
                    try {
                        Path path = file.toAbsolutePath();
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
                        String absolutePath = PathsKt.getInvariantSeparatorsPathString((Path)path);
                        fileSpec = CopyAppSettingsToRepositoryKt.normalizeFileSpec(storageManager, absolutePath);
                        if (!Intrinsics.areEqual((Object)fileSpec, (Object)absolutePath)) break block8;
                        Path path2 = file.toRealPath(new LinkOption[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toRealPath(...)");
                        String canonicalPath = PathsKt.getInvariantSeparatorsPathString((Path)path2);
                        if (Intrinsics.areEqual((Object)canonicalPath, (Object)absolutePath)) break block8;
                        fileSpec = CopyAppSettingsToRepositoryKt.normalizeFileSpec(storageManager, absolutePath);
                    }
                    catch (NoSuchFileException e) {
                        continue;
                    }
                }
                if ((list = (List)fileToItems.get(file)) == null || (list = (LocalExportableItem)CollectionsKt.firstOrNull((List)list)) == null || (list = ((LocalExportableItem)list).roamingType) == null) {
                    list = RoamingType.DEFAULT;
                }
                List roamingType = list;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.isRegularFile(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    byte[] fileBytes;
                    Intrinsics.checkNotNullExpressionValue((Object)Files.readAllBytes(file), (String)"readAllBytes(...)");
                    streamProvider2.doSave(fileSpec, fileBytes, (RoamingType)roamingType);
                    continue;
                }
                CopyAppSettingsToRepositoryKt.saveDirectory(file, fileSpec, (RoamingType)roamingType, streamProvider2);
            }
            catch (Throwable e$iv$iv) {
                if (errors$iv$iv == null) {
                    errors$iv$iv = (List)new SmartList();
                }
                errors$iv$iv.add(e$iv$iv);
            }
        }
        CompoundRuntimeException.throwIfNotEmpty(errors$iv$iv);
    }

    public static /* synthetic */ void copyLocalConfig$default(StateStorageManager stateStorageManager, int n, Object object) {
        if ((n & 1) != 0) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNull((Object)application);
            stateStorageManager = IComponentStoreKt.getStateStore((ComponentManager)((ComponentManager)application)).getStorageManager();
        }
        CopyAppSettingsToRepositoryKt.copyLocalConfig(stateStorageManager);
    }

    private static final String normalizeFileSpec(StateStorageManager storageManager, String absolutePath) {
        return ApplicationStoreImplKt.removeMacroIfStartsWith((String)ApplicationStoreImplKt.removeMacroIfStartsWith((String)storageManager.collapseMacro(absolutePath), (String)"$ROOT_CONFIG$"), (String)"$APP_CONFIG$");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void saveDirectory(Path parent, String parentFileSpec, RoamingType roamingType, IcsManager.IcsStreamProvider streamProvider) {
        Path $this$directoryStreamIfExists$iv = parent;
        boolean $i$f$directoryStreamIfExists = false;
        try {
            Unit unit;
            Closeable closeable = Files.newDirectoryStream($this$directoryStreamIfExists$iv);
            Throwable throwable = null;
            try {
                DirectoryStream it = (DirectoryStream)closeable;
                boolean bl = false;
                Iterator iterator = it.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    Path file = (Path)iterator2.next();
                    String childFileSpec = parentFileSpec + "/" + file.getFileName();
                    Intrinsics.checkNotNull((Object)file);
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (Files.isRegularFile(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                        byte[] fileBytes = Files.readAllBytes(file);
                        Intrinsics.checkNotNull((Object)fileBytes);
                        streamProvider.doSave(childFileSpec, fileBytes, roamingType);
                        continue;
                    }
                    CopyAppSettingsToRepositoryKt.saveDirectory(file, childFileSpec, roamingType, streamProvider);
                }
                unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            closeable = unit;
        }
        catch (NoSuchFileException noSuchFileException) {
            Object var6_7 = null;
        }
    }
}

