/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.options.BoundSearchableConfigurable;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.LabelPosition;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.nio.file.Path;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.IcsBundle;
import org.jetbrains.settingsRepository.IcsBundleKt;
import org.jetbrains.settingsRepository.IcsManager;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.IcsSettings;
import org.jetbrains.settingsRepository.IcsSettingsKt;
import org.jetbrains.settingsRepository.ReadOnlySourcesEditorKt;
import org.jetbrains.settingsRepository.RepositoryListEditorKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/settingsRepository/IcsConfigurable;", "Lcom/intellij/openapi/options/BoundSearchableConfigurable;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "icsManager", "Lorg/jetbrains/settingsRepository/IcsManager;", "settings", "Lorg/jetbrains/settingsRepository/IcsSettings;", "readOnlySourcesEditor", "Lcom/intellij/openapi/options/ConfigurableUi;", "dispose", "", "reset", "isModified", "", "apply", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "intellij.settingsRepository"})
final class IcsConfigurable
extends BoundSearchableConfigurable
implements Disposable {
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final IcsManager icsManager;
    @NotNull
    private final IcsSettings settings;
    @NotNull
    private final ConfigurableUi<IcsSettings> readOnlySourcesEditor;

    public IcsConfigurable() {
        super(IcsBundleKt.icsMessage("ics.settings", new Object[0]), "reference.settings.ics", "ics");
        IcsManager icsManager;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNull((Object)application, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
        this.coroutineScope = CoroutineScopeKt.childScope$default((CoroutineScope)((ComponentManagerEx)application).getCoroutineScope(), null, (boolean)false, (int)3, null);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Path path = PathManager.getConfigDir().resolve("settingsRepository");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            icsManager = new IcsManager(path, this.coroutineScope, null, 4, null);
        } else {
            icsManager = IcsManagerKt.getIcsManager();
        }
        this.icsManager = icsManager;
        this.settings = ApplicationManager.getApplication().isUnitTestMode() ? new IcsSettings() : this.icsManager.getSettings();
        this.readOnlySourcesEditor = ReadOnlySourcesEditorKt.createReadOnlySourcesEditor();
    }

    public void dispose() {
        this.icsManager.getAutoSyncManager$intellij_settingsRepository().setEnabled(true);
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
    }

    public void reset() {
        super.reset();
        this.icsManager.getAutoSyncManager$intellij_settingsRepository().setEnabled(false);
        this.readOnlySourcesEditor.reset((Object)this.settings);
    }

    public boolean isModified() {
        return super.isModified() || this.readOnlySourcesEditor.isModified((Object)this.settings);
    }

    public void apply() {
        super.apply();
        if (this.readOnlySourcesEditor.isModified((Object)this.settings)) {
            this.readOnlySourcesEditor.apply((Object)this.settings);
        }
        IcsSettingsKt.saveSettings(this.settings, this.icsManager.getSettingsFile());
    }

    @NotNull
    public DialogPanel createPanel() {
        DialogPanel dialogPanel;
        DialogPanel repositoryListEditor = RepositoryListEditorKt.createRepositoryListEditor(this.icsManager);
        DialogPanel $this$createPanel_u24lambda_u245 = dialogPanel = BuilderKt.panel(arg_0 -> IcsConfigurable.createPanel$lambda$4(repositoryListEditor, this, arg_0));
        boolean bl = false;
        $this$createPanel_u24lambda_u245.registerIntegratedPanel(repositoryListEditor);
        return dialogPanel;
    }

    private static final Unit createPanel$lambda$4$lambda$0(DialogPanel $repositoryListEditor, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)$repositoryListEditor);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$4$lambda$1(IcsConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ButtonKt.bindSelected((Cell)Cell.comment$default((Cell)$this$row.checkBox(IcsBundle.message("settings.auto.sync.checkbox", new Object[0])), (String)IcsBundle.message("settings.auto.sync.comment", new Object[0]), (int)0, null, (int)6, null), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.settings){

            public Object get() {
                return ((IcsSettings)this.receiver).getAutoSync();
            }

            public void set(Object value) {
                ((IcsSettings)this.receiver).setAutoSync((Boolean)value);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$4$lambda$2(IcsConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(IcsBundle.message("settings.include.hostname.into.commit.message.checkbox", new Object[0])), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.settings){

            public Object get() {
                return ((IcsSettings)this.receiver).getIncludeHostIntoCommitMessage();
            }

            public void set(Object value) {
                ((IcsSettings)this.receiver).setIncludeHostIntoCommitMessage((Boolean)value);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$4$lambda$3(IcsConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JComponent jComponent = this$0.readOnlySourcesEditor.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        $this$row.cell(jComponent).align(Align.FILL).label(IcsBundle.message("settings.read.only.sources.table.header", new Object[0]), LabelPosition.TOP);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$4(DialogPanel $repositoryListEditor, IcsConfigurable this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> IcsConfigurable.createPanel$lambda$4$lambda$0($repositoryListEditor, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> IcsConfigurable.createPanel$lambda$4$lambda$1(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> IcsConfigurable.createPanel$lambda$4$lambda$2(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> IcsConfigurable.createPanel$lambda$4$lambda$3(this$0, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }
}

