/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.schemeManager.SchemeManagerFactoryBase;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.impl.stores.IComponentStoreKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.eclipse.jgit.lib.Repository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.AutoSyncManager;
import org.jetbrains.settingsRepository.IcsBundleKt;
import org.jetbrains.settingsRepository.IcsCredentialsStore;
import org.jetbrains.settingsRepository.IcsManager;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.IcsSettings;
import org.jetbrains.settingsRepository.IcsSettingsKt;
import org.jetbrains.settingsRepository.IcsUrlBuilderKt;
import org.jetbrains.settingsRepository.ReadOnlySourceManager;
import org.jetbrains.settingsRepository.RepositoryManager;
import org.jetbrains.settingsRepository.RepositoryService;
import org.jetbrains.settingsRepository.SyncManager;
import org.jetbrains.settingsRepository.SyncType;
import org.jetbrains.settingsRepository.git.GitExKt;
import org.jetbrains.settingsRepository.git.GitRepositoryManager;
import org.jetbrains.settingsRepository.git.GitRepositoryService;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001GB)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u00105\u001a\u00020%H\u0002J(\u00106\u001a\u00020'2\u0006\u00107\u001a\u0002082\u0010\b\u0002\u00109\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010:H\u0086@\u00a2\u0006\u0002\u0010;J\b\u0010<\u001a\u00020%H\u0002J,\u0010=\u001a\u00020%2\u001c\u0010>\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0@\u0012\u0006\u0012\u0004\u0018\u00010\u00010?H\u0086@\u00a2\u0006\u0002\u0010AJ\u0014\u0010B\u001a\u00020%2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020%0:J\u0006\u0010C\u001a\u00020%J\u000e\u0010D\u001a\u00020%2\u0006\u0010E\u001a\u00020FR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010)R\u0014\u0010-\u001a\u00020.X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0014\u00101\u001a\u000202X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104\u00a8\u0006H"}, d2={"Lorg/jetbrains/settingsRepository/IcsManager;", "", "dir", "Ljava/nio/file/Path;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "schemeManagerFactory", "Lkotlin/Lazy;", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerFactoryBase;", "<init>", "(Ljava/nio/file/Path;Lkotlinx/coroutines/CoroutineScope;Lkotlin/Lazy;)V", "getSchemeManagerFactory", "()Lkotlin/Lazy;", "credentialsStore", "Lorg/jetbrains/settingsRepository/IcsCredentialsStore;", "getCredentialsStore", "settingsFile", "getSettingsFile", "()Ljava/nio/file/Path;", "settings", "Lorg/jetbrains/settingsRepository/IcsSettings;", "getSettings", "()Lorg/jetbrains/settingsRepository/IcsSettings;", "repositoryManager", "Lorg/jetbrains/settingsRepository/git/GitRepositoryManager;", "getRepositoryManager", "()Lorg/jetbrains/settingsRepository/git/GitRepositoryManager;", "readOnlySourcesManager", "Lorg/jetbrains/settingsRepository/ReadOnlySourceManager;", "getReadOnlySourcesManager", "()Lorg/jetbrains/settingsRepository/ReadOnlySourceManager;", "repositoryService", "Lorg/jetbrains/settingsRepository/RepositoryService;", "getRepositoryService", "()Lorg/jetbrains/settingsRepository/RepositoryService;", "commitRequests", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "autoCommitEnabled", "", "isRepositoryActive", "()Z", "setRepositoryActive", "(Z)V", "isActive", "autoSyncManager", "Lorg/jetbrains/settingsRepository/AutoSyncManager;", "getAutoSyncManager$intellij_settingsRepository", "()Lorg/jetbrains/settingsRepository/AutoSyncManager;", "syncManager", "Lorg/jetbrains/settingsRepository/SyncManager;", "getSyncManager$intellij_settingsRepository", "()Lorg/jetbrains/settingsRepository/SyncManager;", "scheduleCommit", "sync", "syncType", "Lorg/jetbrains/settingsRepository/SyncType;", "localRepositoryInitializer", "Lkotlin/Function0;", "(Lorg/jetbrains/settingsRepository/SyncType;Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "cancelAndDisableAutoCommit", "runInAutoCommitDisabledMode", "task", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "runInAutoCommitDisabledModeSync", "setApplicationLevelStreamProvider", "beforeApplicationLoaded", "app", "Lcom/intellij/openapi/application/Application;", "IcsStreamProvider", "intellij.settingsRepository"})
public final class IcsManager {
    @NotNull
    private final Lazy<SchemeManagerFactoryBase> schemeManagerFactory;
    @NotNull
    private final Lazy<IcsCredentialsStore> credentialsStore;
    @NotNull
    private final Path settingsFile;
    @NotNull
    private final IcsSettings settings;
    @NotNull
    private final GitRepositoryManager repositoryManager;
    @NotNull
    private final ReadOnlySourceManager readOnlySourcesManager;
    @NotNull
    private final RepositoryService repositoryService;
    @NotNull
    private final MutableSharedFlow<Unit> commitRequests;
    private volatile boolean autoCommitEnabled;
    private volatile boolean isRepositoryActive;
    @NotNull
    private final AutoSyncManager autoSyncManager;
    @NotNull
    private final SyncManager syncManager;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public IcsManager(@NotNull Path dir, @NotNull CoroutineScope coroutineScope, @NotNull Lazy<? extends SchemeManagerFactoryBase> schemeManagerFactory) {
        IcsSettings icsSettings;
        IcsManager icsManager;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(schemeManagerFactory, (String)"schemeManagerFactory");
        this.schemeManagerFactory = schemeManagerFactory;
        this.credentialsStore = LazyKt.lazy(IcsManager::credentialsStore$lambda$1);
        Path path = dir.resolve("config.json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.settingsFile = path;
        IcsManager icsManager2 = this;
        try {
            icsManager = icsManager2;
            icsSettings = IcsSettingsKt.loadSettings(this.settingsFile);
        }
        catch (Exception exception) {
            void e;
            icsManager = icsManager2;
            IcsManagerKt.getLOG().error((Throwable)e);
            icsSettings = new IcsSettings();
        }
        icsManager.settings = icsSettings;
        Path path2 = dir.resolve("repository");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        this.repositoryManager = new GitRepositoryManager(this.credentialsStore, path2);
        this.readOnlySourcesManager = new ReadOnlySourceManager(this, dir);
        this.repositoryService = new GitRepositoryService();
        this.commitRequests = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ IcsManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$launch;
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                        this.label = 1;
                        Object object2 = FlowKt.debounce-HG0u8IE((Flow)((Flow)this.this$0.commitRequests), (long)DurationKt.toDuration((int)this.this$0.getSettings().getCommitDelay(), (DurationUnit)DurationUnit.MILLISECONDS)).collect(new FlowCollector((CoroutineScope)$this$launch, this.this$0){
                            final /* synthetic */ CoroutineScope $$this$launch;
                            final /* synthetic */ IcsManager this$0;
                            {
                                this.$$this$launch = $$this$launch;
                                this.this$0 = $receiver;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object emit(Unit it, Continuation<? super Unit> $completion) {
                                void title$iv;
                                String string = IcsBundleKt.icsMessage("task.commit.title", new Object[0]);
                                CoroutineScope coroutineScope = this.$$this$launch;
                                IcsManager icsManager = this.this$0;
                                Project project$iv = null;
                                boolean cancellable$iv = true;
                                boolean $i$f$runBackgroundableTask = false;
                                ProgressManager.getInstance().run((Task)new Task.Backgroundable(project$iv, (String)title$iv, cancellable$iv, coroutineScope, icsManager){
                                    final /* synthetic */ CoroutineScope $$this$launch$inlined;
                                    final /* synthetic */ IcsManager this$0;
                                    {
                                        this.$$this$launch$inlined = coroutineScope;
                                        this.this$0 = icsManager;
                                        super($project, $title, $cancellable);
                                    }

                                    public void run(ProgressIndicator indicator) {
                                        Object object;
                                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                                        ProgressIndicator it = indicator;
                                        boolean bl = false;
                                        CoroutineScope coroutineScope = this.$$this$launch$inlined;
                                        try {
                                            CoroutineScope $this$emit_u24lambda_u241_u24lambda_u240 = coroutineScope;
                                            boolean bl2 = false;
                                            object = Result.constructor-impl((Object)((Boolean)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this.this$0, null){
                                                int label;
                                                final /* synthetic */ IcsManager this$0;
                                                {
                                                    this.this$0 = $receiver;
                                                    super(2, $completion);
                                                }

                                                /*
                                                 * Enabled force condition propagation
                                                 * Lifted jumps to return sites
                                                 */
                                                public final Object invokeSuspend(Object $result) {
                                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            this.label = 1;
                                                            Object object2 = RepositoryManager.commit$default(this.this$0.getRepositoryManager(), null, false, (Continuation)this, 1, null);
                                                            if (object2 != object) return object2;
                                                            return object;
                                                        }
                                                        case 1: {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            Object object2 = $result;
                                                            return object2;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }))));
                                        }
                                        catch (Throwable throwable) {
                                            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                                        }
                                        LoggerKt.getOrLogException((Object)object, (Logger)IcsManagerKt.getLOG());
                                    }
                                });
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        JobKt.getJob((CoroutineContext)coroutineScope.getCoroutineContext()).invokeOnCompletion(arg_0 -> IcsManager._init_$lambda$2(this, arg_0));
        this.autoCommitEnabled = true;
        this.autoSyncManager = new AutoSyncManager(this);
        this.syncManager = new SyncManager(this, this.autoSyncManager);
    }

    public /* synthetic */ IcsManager(Path path, CoroutineScope coroutineScope, Lazy lazy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            lazy = LazyKt.lazy(IcsManager::_init_$lambda$0);
        }
        this(path, coroutineScope, (Lazy<? extends SchemeManagerFactoryBase>)lazy);
    }

    @NotNull
    public final Lazy<SchemeManagerFactoryBase> getSchemeManagerFactory() {
        return this.schemeManagerFactory;
    }

    @NotNull
    public final Lazy<IcsCredentialsStore> getCredentialsStore() {
        return this.credentialsStore;
    }

    @NotNull
    public final Path getSettingsFile() {
        return this.settingsFile;
    }

    @NotNull
    public final IcsSettings getSettings() {
        return this.settings;
    }

    @NotNull
    public final GitRepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    @NotNull
    public final ReadOnlySourceManager getReadOnlySourcesManager() {
        return this.readOnlySourcesManager;
    }

    @NotNull
    public final RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public final boolean isRepositoryActive() {
        return this.isRepositoryActive;
    }

    public final void setRepositoryActive(boolean bl) {
        this.isRepositoryActive = bl;
    }

    public final boolean isActive() {
        return this.isRepositoryActive || !((Collection)this.readOnlySourcesManager.getRepositories()).isEmpty();
    }

    @NotNull
    public final AutoSyncManager getAutoSyncManager$intellij_settingsRepository() {
        return this.autoSyncManager;
    }

    @NotNull
    public final SyncManager getSyncManager$intellij_settingsRepository() {
        return this.syncManager;
    }

    private final void scheduleCommit() {
        if (this.autoCommitEnabled) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNull((Object)application);
            if (!application.isUnitTestMode() && !this.commitRequests.tryEmit((Object)Unit.INSTANCE)) {
                throw new IllegalStateException("Check failed.");
            }
        }
    }

    @Nullable
    public final Object sync(@NotNull SyncType syncType, @Nullable Function0<Unit> localRepositoryInitializer, @NotNull Continuation<? super Boolean> $completion) {
        return SyncManager.sync$default(this.syncManager, syncType, localRepositoryInitializer, false, $completion, 4, null);
    }

    public static /* synthetic */ Object sync$default(IcsManager icsManager, SyncType syncType, Function0 function0, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = null;
        }
        return icsManager.sync(syncType, (Function0<Unit>)function0, (Continuation<? super Boolean>)continuation);
    }

    private final void cancelAndDisableAutoCommit() {
        if (this.autoCommitEnabled) {
            this.autoCommitEnabled = false;
            if (!this.commitRequests.tryEmit((Object)Unit.INSTANCE)) {
                throw new IllegalStateException("Check failed.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object runInAutoCommitDisabledMode(@NotNull Function1<? super Continuation<? super Unit>, ? extends Object> task, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof runInAutoCommitDisabledMode.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ IcsManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.runInAutoCommitDisabledMode(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.cancelAndDisableAutoCommit();
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)task);
                $continuation.label = 1;
                v0 = task.invoke((Object)$continuation);
                ** if (v0 != var6_5) goto lbl20
lbl19:
                // 1 sources

                return var6_5;
lbl20:
                // 1 sources

                ** GOTO lbl34
            }
            case 1: {
                task = (Function1)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                }
                catch (Throwable var3_6) {
                    throw var3_6;
                }
                finally {
                    this.autoCommitEnabled = true;
                    this.isRepositoryActive = this.repositoryManager.isRepositoryExists();
                }
lbl34:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runInAutoCommitDisabledModeSync(@NotNull Function0<Unit> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        this.cancelAndDisableAutoCommit();
        try {
            task.invoke();
        }
        finally {
            this.autoCommitEnabled = true;
            this.isRepositoryActive = this.repositoryManager.isRepositoryExists();
        }
    }

    public final void setApplicationLevelStreamProvider() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        StateStorageManager storageManager = IComponentStoreKt.getStateStore((ComponentManager)((ComponentManager)application)).getStorageManager();
        storageManager.removeStreamProvider(IcsStreamProvider.class);
        storageManager.addStreamProvider((StreamProvider)new IcsStreamProvider(), true);
    }

    public final void beforeApplicationLoaded(@NotNull Application app) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        this.isRepositoryActive = this.repositoryManager.isRepositoryExists();
        StateStorageManager.addStreamProvider$default((StateStorageManager)IComponentStoreKt.getStateStore((ComponentManager)((ComponentManager)app)).getStorageManager(), (StreamProvider)new IcsStreamProvider(), (boolean)false, (int)2, null);
        SimpleMessageBusConnection messageBusConnection = app.getMessageBus().simpleConnect();
        Topic topic = AppLifecycleListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new AppLifecycleListener(this){
            final /* synthetic */ IcsManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void appWillBeClosed(boolean isRestart) {
                AutoSyncManager.autoSync$default(this.this$0.getAutoSyncManager$intellij_settingsRepository(), true, false, 2, null);
            }
        });
        messageBusConnection.subscribe(ProjectCloseListener.TOPIC, (Object)new ProjectCloseListener(this){
            final /* synthetic */ IcsManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void projectClosed(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                if (!ApplicationManagerEx.getApplicationEx().isExitInProgress()) {
                    AutoSyncManager.autoSync$default(this.this$0.getAutoSyncManager$intellij_settingsRepository(), false, false, 3, null);
                }
            }
        });
    }

    @JvmOverloads
    public IcsManager(@NotNull Path dir, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this(dir, coroutineScope, null, 4, null);
    }

    private static final SchemeManagerFactoryBase _init_$lambda$0() {
        SchemeManagerFactory schemeManagerFactory = SchemeManagerFactory.Companion.getInstance();
        Intrinsics.checkNotNull((Object)schemeManagerFactory, (String)"null cannot be cast to non-null type com.intellij.configurationStore.schemeManager.SchemeManagerFactoryBase");
        return (SchemeManagerFactoryBase)schemeManagerFactory;
    }

    private static final IcsCredentialsStore credentialsStore$lambda$1() {
        return new IcsCredentialsStore();
    }

    private static final Unit _init_$lambda$2(IcsManager this$0, Throwable it) {
        this$0.repositoryManager.dispose();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0088\u0001\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2!\u0010\u0010\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00050\u00112K\u0010\u0014\u001aG\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00050\u0015H\u0016J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u001d\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\rJ.\u0010\u001e\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0014\u0010\u001f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0012\u0004\u0012\u00020\u001a0\u0011H\u0016J\u0018\u0010 \u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010!\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\""}, d2={"Lorg/jetbrains/settingsRepository/IcsManager$IcsStreamProvider;", "Lcom/intellij/configurationStore/StreamProvider;", "<init>", "(Lorg/jetbrains/settingsRepository/IcsManager;)V", "enabled", "", "getEnabled", "()Z", "isExclusive", "isApplicable", "fileSpec", "", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "processChildren", "path", "filter", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "processor", "Lkotlin/Function3;", "Ljava/io/InputStream;", "input", "readOnly", "write", "", "content", "", "doSave", "read", "consumer", "delete", "deleteIfObsolete", "intellij.settingsRepository"})
    public final class IcsStreamProvider
    implements StreamProvider {
        public boolean getEnabled() {
            return IcsManager.this.isActive();
        }

        public boolean isExclusive() {
            return IcsManager.this.isRepositoryActive();
        }

        public boolean isApplicable(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
            Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
            return IcsManager.this.isRepositoryActive() && roamingType.isRoamable();
        }

        public boolean processChildren(@NotNull String path, @NotNull RoamingType roamingType, @NotNull Function1<? super String, Boolean> filter, @NotNull Function3<? super String, ? super InputStream, ? super Boolean, Boolean> processor) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
            Intrinsics.checkNotNullParameter(filter, (String)"filter");
            Intrinsics.checkNotNullParameter(processor, (String)"processor");
            String fullPath = IcsUrlBuilderKt.toRepositoryPath(path, roamingType);
            for (Repository repository : IcsManager.this.getReadOnlySourcesManager().getRepositories()) {
                GitExKt.processChildren(repository, fullPath, filter, (Function2<? super String, ? super InputStream, Boolean>)((Function2)(arg_0, arg_1) -> IcsStreamProvider.processChildren$lambda$0(processor, arg_0, arg_1)));
            }
            if (!IcsManager.this.isRepositoryActive()) {
                return false;
            }
            IcsManager.this.getRepositoryManager().processChildren(fullPath, filter, (Function2<? super String, ? super InputStream, Boolean>)((Function2)(arg_0, arg_1) -> IcsStreamProvider.processChildren$lambda$1(processor, arg_0, arg_1)));
            return true;
        }

        public void write(@NotNull String fileSpec, @NotNull byte[] content, @NotNull RoamingType roamingType) {
            Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
            if (IcsManager.this.getSyncManager$intellij_settingsRepository().getWriteAndDeleteProhibited()) {
                throw new IllegalStateException("Save is prohibited now");
            }
            if (this.doSave(fileSpec, content, roamingType)) {
                IcsManager.this.scheduleCommit();
            }
        }

        public final boolean doSave(@NotNull String fileSpec, @NotNull byte[] content, @NotNull RoamingType roamingType) {
            Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
            return IcsManager.this.getRepositoryManager().write(IcsUrlBuilderKt.toRepositoryPath(fileSpec, roamingType), content);
        }

        public boolean read(@NotNull String fileSpec, @NotNull RoamingType roamingType, @NotNull Function1<? super InputStream, Unit> consumer) {
            Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            if (!this.isApplicable(fileSpec, roamingType)) {
                return false;
            }
            IcsManager.this.getRepositoryManager().read(IcsUrlBuilderKt.toRepositoryPath(fileSpec, roamingType), consumer);
            return true;
        }

        public boolean delete(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
            Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
            if (!IcsManager.this.isRepositoryActive()) {
                return false;
            }
            if (IcsManager.this.getSyncManager$intellij_settingsRepository().getWriteAndDeleteProhibited()) {
                throw new IllegalStateException("Delete is prohibited now");
            }
            if (IcsManager.this.getRepositoryManager().delete(IcsUrlBuilderKt.toRepositoryPath(fileSpec, roamingType))) {
                IcsManager.this.scheduleCommit();
            }
            return true;
        }

        public void deleteIfObsolete(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
            Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
            if (roamingType == RoamingType.DISABLED) {
                this.delete(fileSpec, roamingType);
            }
        }

        private static final boolean processChildren$lambda$0(Function3 $processor, String name, InputStream input) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return (Boolean)$processor.invoke((Object)name, (Object)input, (Object)true);
        }

        private static final boolean processChildren$lambda$1(Function3 $processor, String name, InputStream input) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return (Boolean)$processor.invoke((Object)name, (Object)input, (Object)false);
        }
    }
}

