/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.containers.CollectionFactory;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.JobKt;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.jgit.util.io.DisabledOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.IcsManager;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.ReadOnlySourceManager;
import org.jetbrains.settingsRepository.ReadonlySource;
import org.jetbrains.settingsRepository.git.GitExKt;
import org.jetbrains.settingsRepository.git.GitRepositoryClientImpl;
import org.jetbrains.settingsRepository.git.Pull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\fJ\u0016\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016H\u0086@\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/settingsRepository/ReadOnlySourceManager;", "", "icsManager", "Lorg/jetbrains/settingsRepository/IcsManager;", "rootDir", "Ljava/nio/file/Path;", "<init>", "(Lorg/jetbrains/settingsRepository/IcsManager;Ljava/nio/file/Path;)V", "getRootDir", "()Ljava/nio/file/Path;", "repositoryList", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "", "Lorg/eclipse/jgit/lib/Repository;", "repositories", "getRepositories", "()Ljava/util/List;", "setSources", "", "sources", "Lorg/jetbrains/settingsRepository/ReadonlySource;", "update", "", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.settingsRepository"})
@SourceDebugExtension(value={"SMAP\nReadOnlySourceManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReadOnlySourceManager.kt\norg/jetbrains/settingsRepository/ReadOnlySourceManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 util.kt\ncom/intellij/util/containers/UtilKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 GitEx.kt\norg/jetbrains/settingsRepository/git/GitExKt\n*L\n1#1,98:1\n61#2,5:99\n285#3,3:104\n290#3:108\n1#4:107\n1625#5:109\n1869#5,2:110\n1626#5:112\n384#6,3:113\n400#6,2:116\n388#6,10:118\n*S KotlinDebug\n*F\n+ 1 ReadOnlySourceManager.kt\norg/jetbrains/settingsRepository/ReadOnlySourceManager\n*L\n77#1:99,5\n25#1:104,3\n25#1:108\n25#1:107\n25#1:109\n25#1:110,2\n25#1:112\n82#1:113,3\n82#1:116,2\n82#1:118,10\n*E\n"})
public final class ReadOnlySourceManager {
    @NotNull
    private final IcsManager icsManager;
    @NotNull
    private final Path rootDir;
    @NotNull
    private final SynchronizedClearableLazy<List<Repository>> repositoryList;

    public ReadOnlySourceManager(@NotNull IcsManager icsManager, @NotNull Path rootDir) {
        Intrinsics.checkNotNullParameter((Object)icsManager, (String)"icsManager");
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        this.icsManager = icsManager;
        this.rootDir = rootDir;
        this.repositoryList = new SynchronizedClearableLazy(() -> ReadOnlySourceManager.repositoryList$lambda$2(this));
    }

    @NotNull
    public final Path getRootDir() {
        return this.rootDir;
    }

    @NotNull
    public final List<Repository> getRepositories() {
        return (List)this.repositoryList.getValue();
    }

    public final void setSources(@NotNull List<ReadonlySource> sources) {
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        this.icsManager.getSettings().setReadOnlySources(sources);
        this.repositoryList.drop();
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object update(@NotNull Continuation<? super Set<String>> $completion) {
        if (!($completion instanceof update.1)) ** GOTO lbl-1000
        var11_2 = $completion;
        if ((var11_2.label & -2147483648) != 0) {
            var11_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ ReadOnlySourceManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.update((Continuation<? super Set<String>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                changedRootDirs = new Ref.ObjectRef();
                var3_6 = this.getRepositories().iterator();
lbl14:
                // 3 sources

                while (var3_6.hasNext()) {
                    repo = var3_6.next();
                    JobKt.ensureActive((CoroutineContext)$continuation.getContext());
                    $this$debug_u24default$iv = IcsManagerKt.getLOG();
                    e$iv = null;
                    $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        var9_12 = $this$debug_u24default$iv;
                        $i$a$-debug$default-ReadOnlySourceManager$update$2 = false;
                        var9_12.debug("Pull changes from read-only repo " + GitExKt.getUpstream(repo), e$iv);
                    }
                    $continuation.L$0 = changedRootDirs;
                    $continuation.L$1 = var3_6;
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)repo);
                    $continuation.label = 1;
                    v0 = Pull.fetch$default(new Pull(new GitRepositoryClientImpl(repo, this.icsManager.getCredentialsStore()), null, 2, null), null, (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, update$lambda$5(org.eclipse.jgit.lib.Repository kotlin.jvm.internal.Ref$ObjectRef org.eclipse.jgit.transport.TrackingRefUpdate ), (Lorg/eclipse/jgit/transport/TrackingRefUpdate;)Lkotlin/Unit;)((Repository)repo, (Ref.ObjectRef)changedRootDirs), (Continuation)$continuation, 1, null);
                    if (v0 != var12_4) continue;
                    return var12_4;
                }
                break;
            }
            case 1: {
                repo = (Repository)$continuation.L$2;
                var3_6 = (Iterator<Repository>)$continuation.L$1;
                changedRootDirs = (Ref.ObjectRef)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
                ** GOTO lbl14
            }
        }
        return changedRootDirs.element;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private static final List repositoryList$lambda$2(ReadOnlySourceManager this$0) {
        List list;
        if (this$0.icsManager.getSettings().getReadOnlySources().isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Collection $this$mapSmartNotNull$iv = this$0.icsManager.getSettings().getReadOnlySources();
        boolean $i$f$mapSmartNotNull = false;
        int size$iv = $this$mapSmartNotNull$iv.size();
        if (size$iv == 1) {
            Repository repository;
            block20: {
                Object $this$repositoryList_u24lambda_u242_u24lambda_u241_u24lambda_u240;
                ReadonlySource source = (ReadonlySource)CollectionsKt.first((Iterable)$this$mapSmartNotNull$iv);
                boolean bl = false;
                ReadOnlySourceManager readOnlySourceManager = this$0;
                try {
                    Repository repository2;
                    $this$repositoryList_u24lambda_u242_u24lambda_u241_u24lambda_u240 = readOnlySourceManager;
                    boolean bl2 = false;
                    if (!source.getActive()) {
                        repository2 = null;
                    } else {
                        String string = source.getPath();
                        if (string == null) {
                            repository = null;
                            break block20;
                        }
                        String path = string;
                        Path dir = ((ReadOnlySourceManager)$this$repositoryList_u24lambda_u242_u24lambda_u241_u24lambda_u240).rootDir.resolve(path);
                        Intrinsics.checkNotNull((Object)dir);
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        if (Files.exists(dir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                            repository2 = GitExKt.buildBareRepository(dir);
                        } else {
                            IcsManagerKt.getLOG().warn("Skip read-only source " + source.getUrl() + " because dir doesn't exist");
                            repository2 = null;
                        }
                    }
                    $this$repositoryList_u24lambda_u242_u24lambda_u241_u24lambda_u240 = Result.constructor-impl(repository2);
                }
                catch (Throwable bl2) {
                    $this$repositoryList_u24lambda_u242_u24lambda_u241_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
                }
                repository = (Repository)LoggerKt.getOrLogException((Object)$this$repositoryList_u24lambda_u242_u24lambda_u241_u24lambda_u240, (Logger)IcsManagerKt.getLOG());
            }
            if (repository != null) {
                Repository it$iv = repository;
                boolean bl = false;
                list = (List)new SmartList((Object)it$iv);
            } else {
                list = (List)new SmartList();
            }
        } else {
            void $this$mapNotNullTo$iv$iv;
            Iterable iterable = $this$mapSmartNotNull$iv;
            Collection destination$iv$iv = new ArrayList(size$iv);
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Repository repository;
                block21: {
                    Object object;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    ReadonlySource source = (ReadonlySource)element$iv$iv;
                    boolean bl3 = false;
                    ReadOnlySourceManager readOnlySourceManager = this$0;
                    try {
                        Repository repository3;
                        ReadOnlySourceManager $this$repositoryList_u24lambda_u242_u24lambda_u241_u24lambda_u240 = readOnlySourceManager;
                        boolean bl4 = false;
                        if (!source.getActive()) {
                            repository3 = null;
                        } else {
                            String path;
                            if (source.getPath() == null) {
                                repository = null;
                                break block21;
                            }
                            Path dir = $this$repositoryList_u24lambda_u242_u24lambda_u241_u24lambda_u240.rootDir.resolve(path);
                            Intrinsics.checkNotNull((Object)dir);
                            LinkOption[] linkOptionArray = new LinkOption[]{};
                            if (Files.exists(dir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                                repository3 = GitExKt.buildBareRepository(dir);
                            } else {
                                IcsManagerKt.getLOG().warn("Skip read-only source " + source.getUrl() + " because dir doesn't exist");
                                repository3 = null;
                            }
                        }
                        object = Result.constructor-impl(repository3);
                    }
                    catch (Throwable throwable) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    repository = (Repository)LoggerKt.getOrLogException((Object)object, (Logger)IcsManagerKt.getLOG());
                }
                if (repository == null) continue;
                Repository it$iv$iv = repository;
                boolean bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    private static final void update$addChangedPath(Ref.ObjectRef<Set<String>> changedRootDirs, String path) {
        if (path == null || Intrinsics.areEqual((Object)path, (Object)"/dev/null")) {
            return;
        }
        int firstSlash = StringsKt.indexOf$default((CharSequence)path, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (firstSlash < 0) {
            firstSlash = StringsKt.indexOf$default((CharSequence)path, (char)'\\', (int)0, (boolean)false, (int)6, null);
        }
        if (firstSlash > 0) {
            if (changedRootDirs.element == null) {
                changedRootDirs.element = CollectionFactory.createSmallMemoryFootprintSet();
            }
            Object object = changedRootDirs.element;
            Intrinsics.checkNotNull((Object)object);
            Set set = (Set)object;
            String string = path.substring(0, firstSlash);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            set.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit update$lambda$5(Repository $repo, Ref.ObjectRef $changedRootDirs, TrackingRefUpdate refUpdate) {
        Intrinsics.checkNotNullParameter((Object)refUpdate, (String)"refUpdate");
        DiffFormatter diffFormatter = new DiffFormatter((OutputStream)DisabledOutputStream.INSTANCE);
        diffFormatter.setRepository($repo);
        AutoCloseable $this$use$iv = (AutoCloseable)diffFormatter;
        boolean $i$f$use = false;
        boolean closed$iv = false;
        try {
            DiffFormatter it = (DiffFormatter)$this$use$iv;
            boolean bl = false;
            List result = diffFormatter.scan((AnyObjectId)refUpdate.getOldObjectId(), (AnyObjectId)refUpdate.getNewObjectId());
            for (DiffEntry e : result) {
                if (e.getChangeType() == DiffEntry.ChangeType.DELETE) {
                    ReadOnlySourceManager.update$addChangedPath((Ref.ObjectRef<Set<String>>)$changedRootDirs, e.getOldPath());
                    continue;
                }
                ReadOnlySourceManager.update$addChangedPath((Ref.ObjectRef<Set<String>>)$changedRootDirs, e.getOldPath());
                ReadOnlySourceManager.update$addChangedPath((Ref.ObjectRef<Set<String>>)$changedRootDirs, e.getNewPath());
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    $this$use$iv.close();
                }
                catch (Exception closeException$iv) {
                    Intrinsics.checkNotNull((Object)e$iv, (String)"null cannot be cast to non-null type java.lang.Throwable");
                    ((Throwable)e$iv).addSuppressed(closeException$iv);
                }
                throw e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    $this$use$iv.close();
                }
                throw throwable;
            }
        }
        $this$use$iv.close();
        return Unit.INSTANCE;
    }
}

