/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.platform.ide.progress.ModalTaskOwner;
import com.intellij.ui.components.DialogManager;
import com.intellij.util.text.StringKt;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.IcsBundleKt;
import org.jetbrains.settingsRepository.IcsManager;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.SyncType;
import org.jetbrains.settingsRepository.UpstreamEditorKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/settingsRepository/SyncAction;", "Ljavax/swing/AbstractAction;", "syncType", "Lorg/jetbrains/settingsRepository/SyncType;", "urlTextField", "Ljavax/swing/JTextField;", "project", "Lcom/intellij/openapi/project/Project;", "dialogManager", "Lcom/intellij/ui/components/DialogManager;", "<init>", "(Lorg/jetbrains/settingsRepository/SyncType;Ljavax/swing/JTextField;Lcom/intellij/openapi/project/Project;Lcom/intellij/ui/components/DialogManager;)V", "actionPerformed", "", "event", "Ljava/awt/event/ActionEvent;", "intellij.settingsRepository"})
@SourceDebugExtension(value={"SMAP\nupstreamEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 upstreamEditor.kt\norg/jetbrains/settingsRepository/SyncAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1#2:104\n*E\n"})
final class SyncAction
extends AbstractAction {
    @NotNull
    private final SyncType syncType;
    @NotNull
    private final JTextField urlTextField;
    @Nullable
    private final Project project;
    @NotNull
    private final DialogManager dialogManager;

    public SyncAction(@NotNull SyncType syncType, @NotNull JTextField urlTextField, @Nullable Project project, @NotNull DialogManager dialogManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)syncType), (String)"syncType");
        Intrinsics.checkNotNullParameter((Object)urlTextField, (String)"urlTextField");
        Intrinsics.checkNotNullParameter((Object)dialogManager, (String)"dialogManager");
        super(IcsBundleKt.icsMessage(syncType.getMessageKey(), new Object[0]));
        this.syncType = syncType;
        this.urlTextField = urlTextField;
        this.project = project;
        this.dialogManager = dialogManager;
    }

    @Override
    public void actionPerformed(@NotNull ActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.dialogManager.performAction(() -> SyncAction.actionPerformed$lambda$2(this, event));
    }

    private static final List actionPerformed$lambda$2(SyncAction this$0, ActionEvent $event) {
        List list;
        String error;
        Project project;
        block10: {
            ModalTaskOwner modalTaskOwner;
            Object object2;
            block9: {
                project = this$0.project;
                if (project == null) break block9;
                Project p0 = project;
                boolean object2 = false;
                ModalTaskOwner modalTaskOwner2 = ModalTaskOwner.project((Project)p0);
                project = modalTaskOwner2;
                if (modalTaskOwner2 != null) break block10;
            }
            Component component = (object2 = $event.getSource()) instanceof Component ? (Component)object2 : null;
            if (component != null) {
                Component p0 = component;
                boolean bl = false;
                modalTaskOwner = ModalTaskOwner.component((Component)p0);
            } else {
                modalTaskOwner = project = null;
            }
            if (modalTaskOwner == null) {
                ModalTaskOwner modalTaskOwner3 = ModalTaskOwner.guess();
                project = modalTaskOwner3;
                Intrinsics.checkNotNullExpressionValue((Object)modalTaskOwner3, (String)"guess(...)");
            }
        }
        Project owner = project;
        String url = StringKt.nullize((String)this$0.urlTextField.getText(), (boolean)true);
        String string = UpstreamEditorKt.validateUrl(url, this$0.project);
        if (string == null) {
            IcsManager icsManager = IcsManagerKt.getIcsManager();
            Project project2 = this$0.project;
            SyncType syncType = this$0.syncType;
            String string2 = url;
            Intrinsics.checkNotNull((Object)string2);
            string = UpstreamEditorKt.doSync(icsManager, project2, syncType, string2, (ModalTaskOwner)owner);
        }
        String string3 = error = string;
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            list = CollectionsKt.listOf((Object)new ValidationInfo(error, (JComponent)this$0.urlTextField));
        } else {
            list = null;
        }
        return list;
    }
}

