/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.platform.util.progress.ContextKt;
import com.intellij.platform.util.progress.RawProgressReporterHandle;
import com.intellij.util.SmartList;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.JobKt;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.ignore.IgnoreNode;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.OperationResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.Transport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.AuthenticationException;
import org.jetbrains.settingsRepository.BaseRepositoryManager;
import org.jetbrains.settingsRepository.IcsCredentialsStore;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.RepositoryManager;
import org.jetbrains.settingsRepository.SyncType;
import org.jetbrains.settingsRepository.UpdateResult;
import org.jetbrains.settingsRepository.git.AddLoadedFile;
import org.jetbrains.settingsRepository.git.CommitKt;
import org.jetbrains.settingsRepository.git.DirCacheEditorKt;
import org.jetbrains.settingsRepository.git.GitExKt;
import org.jetbrains.settingsRepository.git.GitRepositoryClient;
import org.jetbrains.settingsRepository.git.GitRepositoryManager;
import org.jetbrains.settingsRepository.git.GitRepositoryManagerKt;
import org.jetbrains.settingsRepository.git.JGitCoroutineProgressMonitor;
import org.jetbrains.settingsRepository.git.JGitCredentialsProvider;
import org.jetbrains.settingsRepository.git.Pull;
import org.jetbrains.settingsRepository.git.Reset;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0016H\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u001c\u0010\u001e\u001a\u00020\u00162\b\u0010\u001f\u001a\u0004\u0018\u00010\u001d2\b\u0010 \u001a\u0004\u0018\u00010\u001dH\u0016J\b\u0010!\u001a\u00020\u001aH\u0016J\b\u0010\"\u001a\u00020\u001aH\u0016J \u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'H\u0014J\u0018\u0010(\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u001aH\u0014J \u0010*\u001a\u00020\u001a2\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020\u001aH\u0096@\u00a2\u0006\u0002\u0010.J\u0016\u0010/\u001a\u00020\u001a2\u0006\u00100\u001a\u000201H\u0082@\u00a2\u0006\u0002\u00102J\b\u00103\u001a\u000204H\u0016J\u000e\u00105\u001a\u00020\u0016H\u0096@\u00a2\u0006\u0002\u00106J\u000e\u00107\u001a\u000208H\u0096@\u00a2\u0006\u0002\u00106J\u0010\u00109\u001a\u0004\u0018\u00010:H\u0096@\u00a2\u0006\u0002\u00106J\u000e\u0010;\u001a\u00020:H\u0096@\u00a2\u0006\u0002\u00106J\u001e\u0010<\u001a\u00020:2\u000e\u0010=\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010>H\u0096@\u00a2\u0006\u0002\u0010?J\b\u0010@\u001a\u00020\u001aH\u0016J\n\u0010A\u001a\u0004\u0018\u00010\u0018H\u0002J\u0010\u0010B\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u001dH\u0014R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lorg/jetbrains/settingsRepository/git/GitRepositoryManager;", "Lorg/jetbrains/settingsRepository/BaseRepositoryManager;", "Lorg/jetbrains/settingsRepository/git/GitRepositoryClient;", "credentialsStore", "Lkotlin/Lazy;", "Lorg/jetbrains/settingsRepository/IcsCredentialsStore;", "dir", "Ljava/nio/file/Path;", "<init>", "(Lkotlin/Lazy;Ljava/nio/file/Path;)V", "repository", "Lorg/eclipse/jgit/lib/Repository;", "getRepository", "()Lorg/eclipse/jgit/lib/Repository;", "_repository", "credentialsProvider", "Lorg/eclipse/jgit/transport/CredentialsProvider;", "getCredentialsProvider", "()Lorg/eclipse/jgit/transport/CredentialsProvider;", "credentialsProvider$delegate", "Lkotlin/Lazy;", "dispose", "", "ignoreRules", "Lorg/eclipse/jgit/ignore/IgnoreNode;", "createRepositoryIfNeeded", "", "deleteRepository", "getUpstream", "", "setUpstream", "url", "branch", "isRepositoryExists", "hasUpstream", "addToIndex", "file", "path", "content", "", "deleteFromIndex", "isFile", "commit", "syncType", "Lorg/jetbrains/settingsRepository/SyncType;", "fixStateIfCannotCommit", "(Lorg/jetbrains/settingsRepository/SyncType;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "commitIfCan", "state", "Lorg/eclipse/jgit/lib/RepositoryState;", "(Lorg/eclipse/jgit/lib/RepositoryState;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAheadCommitsCount", "", "push", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetch", "Lorg/jetbrains/settingsRepository/RepositoryManager$Updater;", "pull", "Lorg/jetbrains/settingsRepository/UpdateResult;", "resetToTheirs", "resetToMy", "localRepositoryInitializer", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "canCommit", "getIgnoreRules", "isPathIgnored", "intellij.settingsRepository"})
@SourceDebugExtension(value={"SMAP\nGitRepositoryManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRepositoryManager.kt\norg/jetbrains/settingsRepository/git/GitRepositoryManager\n+ 2 steps.kt\ncom/intellij/platform/util/progress/StepsKt\n+ 3 CoroutineScope.kt\nkotlinx/coroutines/CoroutineScopeKt\n+ 4 GitEx.kt\norg/jetbrains/settingsRepository/git/GitExKt\n*L\n1#1,271:1\n117#2,2:272\n374#3:274\n384#4,3:275\n400#4,2:278\n388#4,10:280\n*S KotlinDebug\n*F\n+ 1 GitRepositoryManager.kt\norg/jetbrains/settingsRepository/git/GitRepositoryManager\n*L\n151#1:272,2\n162#1:274\n232#1:275,3\n232#1:278,2\n232#1:280,10\n*E\n"})
public final class GitRepositoryManager
extends BaseRepositoryManager
implements GitRepositoryClient {
    @NotNull
    private final Lazy<IcsCredentialsStore> credentialsStore;
    @Nullable
    private Repository _repository;
    @NotNull
    private final Lazy credentialsProvider$delegate;
    @Nullable
    private IgnoreNode ignoreRules;

    public GitRepositoryManager(@NotNull Lazy<IcsCredentialsStore> credentialsStore, @NotNull Path dir) {
        Intrinsics.checkNotNullParameter(credentialsStore, (String)"credentialsStore");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        super(dir);
        this.credentialsStore = credentialsStore;
        this.credentialsProvider$delegate = LazyKt.lazy(() -> GitRepositoryManager.credentialsProvider_delegate$lambda$1(this));
    }

    @Override
    @NotNull
    public Repository getRepository() {
        Repository r = this._repository;
        if (r == null) {
            this._repository = r = GitExKt.buildRepository$default(this.getDir(), false, null, false, 14, null);
            Application application = ApplicationManager.getApplication();
            if (!(application != null ? application.isUnitTestMode() : false)) {
                ShutDownTracker.getInstance().registerShutdownTask(() -> GitRepositoryManager._get_repository_$lambda$0(this));
            }
        }
        return r;
    }

    @Override
    @NotNull
    public CredentialsProvider getCredentialsProvider() {
        Lazy lazy = this.credentialsProvider$delegate;
        return (CredentialsProvider)lazy.getValue();
    }

    public final void dispose() {
        block0: {
            Repository repository = this._repository;
            if (repository == null) break block0;
            repository.close();
        }
    }

    @Override
    public boolean createRepositoryIfNeeded() {
        this.ignoreRules = null;
        if (this.isRepositoryExists()) {
            return false;
        }
        this.getRepository().create();
        GitExKt.disableAutoCrLf(this.getRepository());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRepository() {
        this.ignoreRules = null;
        try {
            super.deleteRepository();
        }
        finally {
            Repository r = this._repository;
            if (r != null) {
                this._repository = null;
                r.close();
            }
        }
    }

    @Override
    @Nullable
    public String getUpstream() {
        return GitExKt.getUpstream(this.getRepository());
    }

    @Override
    public void setUpstream(@Nullable String url, @Nullable String branch) {
        Repository repository = this.getRepository();
        String string = branch;
        if (string == null) {
            string = "master";
        }
        GitExKt.setUpstream(repository, url, string);
    }

    @Override
    public boolean isRepositoryExists() {
        Repository repo = this._repository;
        if (repo == null) {
            return Files.exists(this.getDir(), new LinkOption[0]) && ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setWorkTree(this.getDir().toFile())).setAutonomous(true)).setup()).getObjectDirectory().exists();
        }
        return repo.getObjectDatabase().exists();
    }

    @Override
    public boolean hasUpstream() {
        return this.getUpstream() != null;
    }

    @Override
    protected void addToIndex(@NotNull Path file, @NotNull String path, @NotNull byte[] content) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Repository repository = this.getRepository();
        LinkOption[] linkOptionArray = new LinkOption[]{};
        FileTime fileTime = Files.getLastModifiedTime(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
        DirCacheEditorKt.edit(repository, new AddLoadedFile(path, content, fileTime.toMillis()));
    }

    @Override
    protected void deleteFromIndex(@NotNull String path, boolean isFile) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        DirCacheEditorKt.deletePath(this.getRepository(), path, isFile, false);
    }

    /*
     * Exception decompiling
     */
    @Override
    @Nullable
    public Object commit(@Nullable SyncType syncType, boolean fixStateIfCannotCommit, @NotNull Continuation<? super Boolean> $completion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final Object commitIfCan(RepositoryState state, Continuation<? super Boolean> $completion) {
        if (state.canCommit()) {
            return CommitKt.commit$default(this.getRepository(), null, $completion, 2, null);
        }
        IcsManagerKt.getLOG().warn("Cannot commit, repository in state " + state.getDescription());
        return Boxing.boxBoolean((boolean)false);
    }

    @Override
    public int getAheadCommitsCount() {
        return GitExKt.getAheadCommitCount(this.getRepository());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object push(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof push.1)) ** GOTO lbl-1000
        var18_2 = $completion;
        if ((var18_2.label & -2147483648) != 0) {
            var18_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ GitRepositoryManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.push((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var19_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.I$0 = $i$f$reportRawProgress = 0;
                $continuation.label = 1;
                v0 = ContextKt.internalCurrentStepAsRaw((Continuation)$continuation);
                if (v0 == var19_4) {
                    return var19_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                $i$f$reportRawProgress = $continuation.I$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                var3_6 = (AutoCloseable)v0;
                var4_7 = null;
                try {
                    handle$iv = (RawProgressReporterHandle)var3_6;
                    $i$a$-use-StepsKt$reportRawProgress$2$iv = false;
                    reporter = handle$iv.getReporter();
                    $i$a$-reportRawProgress-GitRepositoryManager$push$2 = false;
                    IcsManagerKt.getLOG().debug("Push");
                    refSpecs = new SmartList((Collection)new RemoteConfig((Config)this.getRepository().getConfig(), "origin").getPushRefSpecs());
                    if (refSpecs.isEmpty() && (head = this.getRepository().findRef("HEAD")) != null && head.isSymbolic()) {
                        refSpecs.add((Object)new RefSpec(head.getLeaf().getName()));
                    }
                    $completion$iv = $continuation;
                    $i$f$currentCoroutineContext = false;
                    monitor = new JGitCoroutineProgressMonitor(JobKt.getJob((CoroutineContext)$continuation.getContext()), reporter);
                    block15: for (Transport transport : Transport.openAll((Repository)this.getRepository(), (String)"origin", (Transport.Operation)Transport.Operation.PUSH)) {
                        for (attempt = 0; attempt < 2; ++attempt) {
                            transport.setCredentialsProvider(this.getCredentialsProvider());
                            try {
                                result = transport.push((ProgressMonitor)monitor, transport.findRemoteRefUpdatesFor((Collection)refSpecs));
                                if (!IcsManagerKt.getLOG().isDebugEnabled()) continue block15;
                                Intrinsics.checkNotNull((Object)result);
                                GitRepositoryManagerKt.printMessages((OperationResult)result);
                                for (RemoteRefUpdate refUpdate : result.getRemoteUpdates()) {
                                    IcsManagerKt.getLOG().debug(refUpdate.toString());
                                }
                                continue block15;
                            }
                            catch (TransportException e) {
                                if (e.getStatus() == TransportException.Status.NOT_PERMITTED) {
                                    if (attempt == 0) {
                                        this.getCredentialsProvider().reset(transport.getURI());
                                        continue;
                                    }
                                    throw new AuthenticationException(e);
                                }
                                if (e.getStatus() == TransportException.Status.BAD_GATEWAY) {
                                    continue;
                                }
                                GitExKt.wrapIfNeedAndReThrow(e);
                                continue;
                            }
                            finally {
                                transport.close();
                                continue block15;
                            }
                        }
                    }
                    var5_8 = Unit.INSTANCE;
                }
                catch (Throwable var6_10) {
                    var4_7 = var6_10;
                    throw var6_10;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)var3_6, (Throwable)var4_7);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object fetch(@NotNull Continuation<? super RepositoryManager.Updater> $completion) {
        if (!($completion instanceof fetch.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ GitRepositoryManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.fetch((Continuation<? super RepositoryManager.Updater>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                pullTask = new Pull(this, null, 2, null);
                $continuation.L$0 = pullTask;
                $continuation.label = 1;
                v0 = Pull.fetch$default(pullTask, null, null, (Continuation)$continuation, 3, null);
                if (v0 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl23
            }
            case 1: {
                pullTask = (Pull)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                refToMerge = (Ref)v0;
                return new RepositoryManager.Updater(this, refToMerge, pullTask){
                    private boolean definitelySkipPush;
                    final /* synthetic */ GitRepositoryManager this$0;
                    final /* synthetic */ Ref $refToMerge;
                    final /* synthetic */ Pull $pullTask;
                    {
                        this.this$0 = $receiver;
                        this.$refToMerge = $refToMerge;
                        this.$pullTask = $pullTask;
                    }

                    public boolean getDefinitelySkipPush() {
                        return this.definitelySkipPush;
                    }

                    public void setDefinitelySkipPush(boolean bl) {
                        this.definitelySkipPush = bl;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Unable to fully structure code
                     */
                    public Object merge(Continuation<? super UpdateResult> $completion) {
                        if (!($completion instanceof fetch.merge.1)) ** GOTO lbl-1000
                        var15_2 = $completion;
                        if ((var15_2.label & -2147483648) != 0) {
                            var15_2.label -= -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $continuation = new ContinuationImpl(this, $completion){
                                Object L$0;
                                Object L$1;
                                Object L$2;
                                Object L$3;
                                Object L$4;
                                int I$0;
                                int I$1;
                                boolean Z$0;
                                /* synthetic */ Object result;
                                final /* synthetic */ fetch.2 this$0;
                                int label;
                                {
                                    this.this$0 = this$0;
                                    super($completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    this.result = $result;
                                    this.label |= Integer.MIN_VALUE;
                                    return this.this$0.merge((Continuation<? super UpdateResult>)((Continuation)this));
                                }
                            };
                        }
                        $result = $continuation.result;
                        var16_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch ($continuation.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                var2_5 = GitRepositoryManager.access$getLock(this.this$0);
                                var3_6 = this.this$0;
                                var4_7 = this.$refToMerge;
                                var5_8 = this.$pullTask;
                                var6_9 = var2_5.readLock();
                                var7_10 = var2_5.getWriteHoldCount() == 0 ? var2_5.getReadHoldCount() : 0;
                                for (var8_11 = 0; var8_11 < var7_10; ++var8_11) {
                                    var6_9.unlock();
                                }
                                var8_12 = var2_5.writeLock();
                                var8_12.lock();
                                $i$a$-write-GitRepositoryManager$fetch$2$merge$2 = 0;
                                $continuation.L$0 = var3_6;
                                $continuation.L$1 = var4_7;
                                $continuation.L$2 = var5_8;
                                $continuation.L$3 = var6_9;
                                $continuation.L$4 = var8_12;
                                $continuation.I$0 = var7_10;
                                $continuation.I$1 = $i$a$-write-GitRepositoryManager$fetch$2$merge$2;
                                $continuation.label = 1;
                                v0 = RepositoryManager.commit$default(var3_6, null, false, (Continuation)$continuation, 3, null);
                                ** if (v0 != var16_4) goto lbl37
lbl36:
                                // 1 sources

                                return var16_4;
lbl37:
                                // 1 sources

                                ** GOTO lbl50
                            }
                            case 1: {
                                $i$a$-write-GitRepositoryManager$fetch$2$merge$2 = $continuation.I$1;
                                var7_10 = $continuation.I$0;
                                var8_12 = (ReentrantReadWriteLock.WriteLock)$continuation.L$4;
                                var6_9 = (ReentrantReadWriteLock.ReadLock)$continuation.L$3;
                                var5_8 = (Pull)$continuation.L$2;
                                var4_7 = (Ref)$continuation.L$1;
                                var3_6 = (GitRepositoryManager)$continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl50:
                                // 2 sources

                                committed = ((Boolean)v0).booleanValue();
                                if (var4_7 != null) ** GOTO lbl60
                                this.setDefinitelySkipPush(committed == 0 && var3_6.getAheadCommitsCount() == 0);
                                var13_16 = null;
                                for (committed = 0; committed < var7_10; ++committed) {
                                    var6_9.lock();
                                }
                                var8_12.unlock();
                                return var13_16;
lbl60:
                                // 2 sources

                                $continuation.L$0 = var6_9;
                                $continuation.L$1 = var8_12;
                                $continuation.L$2 = null;
                                $continuation.L$3 = null;
                                $continuation.L$4 = null;
                                $continuation.I$0 = var7_10;
                                $continuation.I$1 = $i$a$-write-GitRepositoryManager$fetch$2$merge$2;
                                $continuation.Z$0 = committed;
                                $continuation.label = 2;
                                v1 = Pull.pull$default(var5_8, null, null, var4_7, (Continuation)$continuation, 3, null);
                                ** if (v1 != var16_4) goto lbl72
lbl71:
                                // 1 sources

                                return var16_4;
lbl72:
                                // 1 sources

                                ** GOTO lbl83
                            }
                            case 2: {
                                committed = $continuation.Z$0;
                                $i$a$-write-GitRepositoryManager$fetch$2$merge$2 = $continuation.I$1;
                                var7_10 = $continuation.I$0;
                                var8_12 = (ReentrantReadWriteLock.WriteLock)$continuation.L$1;
                                var6_9 = (ReentrantReadWriteLock.ReadLock)$continuation.L$0;
                                try {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v1 = $result;
lbl83:
                                    // 2 sources

                                    var12_17 = v1;
                                    return var12_17;
                                }
                                catch (Throwable var10_15) {
                                    throw var10_15;
                                }
                                finally {
                                    for (var10_14 = 0; var10_14 < var7_10; ++var10_14) {
                                        var6_9.lock();
                                    }
                                    var8_12.unlock();
                                }
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                };
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object pull(@NotNull Continuation<? super UpdateResult> $completion) {
        return Pull.pull$default(new Pull(this, null, 2, null), null, null, null, $completion, 7, null);
    }

    @Override
    @Nullable
    public Object resetToTheirs(@NotNull Continuation<? super UpdateResult> $completion) {
        return Reset.reset$default(new Reset(this), true, null, $completion, 2, null);
    }

    @Override
    @Nullable
    public Object resetToMy(@Nullable Function0<Unit> localRepositoryInitializer, @NotNull Continuation<? super UpdateResult> $completion) {
        return new Reset(this).reset(false, localRepositoryInitializer, $completion);
    }

    @Override
    public boolean canCommit() {
        return this.getRepository().getRepositoryState().canCommit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IgnoreNode getIgnoreRules() {
        IgnoreNode node;
        block7: {
            node = null;
            node = this.ignoreRules;
            if (node != null) break block7;
            Path file = this.getDir().resolve(".gitignore");
            Intrinsics.checkNotNull((Object)file);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block7;
            node = new IgnoreNode();
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream(file, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
            AutoCloseable $this$use$iv = inputStream;
            boolean $i$f$use = false;
            boolean closed$iv = false;
            try {
                InputStream it = (InputStream)$this$use$iv;
                boolean bl = false;
                node.parse(it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Exception e$iv) {
                try {
                    closed$iv = true;
                    try {
                        $this$use$iv.close();
                    }
                    catch (Exception closeException$iv) {
                        Intrinsics.checkNotNull((Object)e$iv, (String)"null cannot be cast to non-null type java.lang.Throwable");
                        ((Throwable)e$iv).addSuppressed(closeException$iv);
                    }
                    throw e$iv;
                }
                catch (Throwable throwable) {
                    if (!closed$iv) {
                        $this$use$iv.close();
                    }
                    throw throwable;
                }
            }
            $this$use$iv.close();
            this.ignoreRules = node;
        }
        return node;
    }

    @Override
    protected boolean isPathIgnored(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        IgnoreNode ignoreNode = this.getIgnoreRules();
        return (ignoreNode != null ? ignoreNode.isIgnored("/" + path, false) : null) == IgnoreNode.MatchResult.IGNORED;
    }

    private static final void _get_repository_$lambda$0(GitRepositoryManager this$0) {
        block0: {
            Repository repository = this$0._repository;
            if (repository == null) break block0;
            repository.close();
        }
    }

    private static final JGitCredentialsProvider credentialsProvider_delegate$lambda$1(GitRepositoryManager this$0) {
        return new JGitCredentialsProvider(this$0.credentialsStore, this$0.getRepository());
    }

    public static final /* synthetic */ Object access$commitIfCan(GitRepositoryManager $this, RepositoryState state, Continuation $completion) {
        return $this.commitIfCan(state, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ ReentrantReadWriteLock access$getLock(GitRepositoryManager $this) {
        return $this.getLock();
    }
}

