/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.platform.util.progress.ContextKt;
import com.intellij.platform.util.progress.RawProgressReporterHandle;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.JobKt;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.merge.MergeMessageFormatter;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.Merger;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.merge.SquashMessageFormatter;
import org.eclipse.jgit.merge.ThreeWayMergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.RevWalkUtils;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.OperationResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.ImmutableUpdateResult;
import org.jetbrains.settingsRepository.RepositoryManagerKt;
import org.jetbrains.settingsRepository.UpdateResult;
import org.jetbrains.settingsRepository.git.CommitMessageFormatter;
import org.jetbrains.settingsRepository.git.GitExKt;
import org.jetbrains.settingsRepository.git.GitRepositoryClient;
import org.jetbrains.settingsRepository.git.GitRepositoryManagerKt;
import org.jetbrains.settingsRepository.git.IdeaCommitMessageFormatter;
import org.jetbrains.settingsRepository.git.JGitCoroutineProgressMonitor;
import org.jetbrains.settingsRepository.git.MergeResultEx;
import org.jetbrains.settingsRepository.git.Pull;
import org.jetbrains.settingsRepository.git.PullKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0010\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J2\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0086@\u00a2\u0006\u0002\u0010\u001eJ4\u0010\u001f\u001a\u0004\u0018\u00010\u001d2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!2\u0016\b\u0002\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%\u0018\u00010#H\u0086@\u00a2\u0006\u0002\u0010&JT\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001d2\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010*\u001a\u00020+2\b\b\u0002\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020+2\b\b\u0002\u0010/\u001a\u00020+2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0086@\u00a2\u0006\u0002\u00100R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00061"}, d2={"Lorg/jetbrains/settingsRepository/git/Pull;", "", "manager", "Lorg/jetbrains/settingsRepository/git/GitRepositoryClient;", "commitMessageFormatter", "Lorg/jetbrains/settingsRepository/git/CommitMessageFormatter;", "<init>", "(Lorg/jetbrains/settingsRepository/git/GitRepositoryClient;Lorg/jetbrains/settingsRepository/git/CommitMessageFormatter;)V", "getManager", "()Lorg/jetbrains/settingsRepository/git/GitRepositoryClient;", "getCommitMessageFormatter", "()Lorg/jetbrains/settingsRepository/git/CommitMessageFormatter;", "repository", "Lorg/eclipse/jgit/lib/Repository;", "getRepository", "()Lorg/eclipse/jgit/lib/Repository;", "config", "Lorg/eclipse/jgit/lib/StoredConfig;", "remoteConfig", "Lorg/eclipse/jgit/transport/RemoteConfig;", "getRemoteConfig", "()Lorg/eclipse/jgit/transport/RemoteConfig;", "pull", "Lorg/jetbrains/settingsRepository/UpdateResult;", "mergeStrategy", "Lorg/eclipse/jgit/merge/MergeStrategy;", "commitMessage", "", "prefetchedRefToMerge", "Lorg/eclipse/jgit/lib/Ref;", "(Lorg/eclipse/jgit/merge/MergeStrategy;Ljava/lang/String;Lorg/eclipse/jgit/lib/Ref;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetch", "prevRefUpdateResult", "Lorg/eclipse/jgit/lib/RefUpdate$Result;", "refUpdateProcessor", "Lkotlin/Function1;", "Lorg/eclipse/jgit/transport/TrackingRefUpdate;", "", "(Lorg/eclipse/jgit/lib/RefUpdate$Result;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "merge", "Lorg/jetbrains/settingsRepository/git/MergeResultEx;", "unpeeledRef", "commit", "", "fastForwardMode", "Lorg/eclipse/jgit/api/MergeCommand$FastForwardMode;", "squash", "forceMerge", "(Lorg/eclipse/jgit/lib/Ref;Lorg/eclipse/jgit/merge/MergeStrategy;ZLorg/eclipse/jgit/api/MergeCommand$FastForwardMode;ZZLjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.settingsRepository"})
@SourceDebugExtension(value={"SMAP\npull.kt\nKotlin\n*S Kotlin\n*F\n+ 1 pull.kt\norg/jetbrains/settingsRepository/git/Pull\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 steps.kt\ncom/intellij/platform/util/progress/StepsKt\n+ 4 CoroutineScope.kt\nkotlinx/coroutines/CoroutineScopeKt\n*L\n1#1,358:1\n61#2,5:359\n117#3,2:364\n374#4:366\n*S KotlinDebug\n*F\n+ 1 pull.kt\norg/jetbrains/settingsRepository/git/Pull\n*L\n73#1:359,5\n88#1:364,2\n89#1:366\n*E\n"})
public class Pull {
    @NotNull
    private final GitRepositoryClient manager;
    @NotNull
    private final CommitMessageFormatter commitMessageFormatter;
    @NotNull
    private final Repository repository;
    @NotNull
    private final StoredConfig config;
    @NotNull
    private final RemoteConfig remoteConfig;

    public Pull(@NotNull GitRepositoryClient manager, @NotNull CommitMessageFormatter commitMessageFormatter) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)commitMessageFormatter, (String)"commitMessageFormatter");
        this.manager = manager;
        this.commitMessageFormatter = commitMessageFormatter;
        this.repository = this.manager.getRepository();
        StoredConfig storedConfig = this.repository.getConfig();
        Intrinsics.checkNotNull((Object)storedConfig);
        this.config = storedConfig;
        this.remoteConfig = new RemoteConfig((Config)this.config, "origin");
    }

    public /* synthetic */ Pull(GitRepositoryClient gitRepositoryClient, CommitMessageFormatter commitMessageFormatter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            commitMessageFormatter = new IdeaCommitMessageFormatter();
        }
        this(gitRepositoryClient, commitMessageFormatter);
    }

    @NotNull
    public final GitRepositoryClient getManager() {
        return this.manager;
    }

    @NotNull
    public final CommitMessageFormatter getCommitMessageFormatter() {
        return this.commitMessageFormatter;
    }

    @NotNull
    public final Repository getRepository() {
        return this.repository;
    }

    @NotNull
    public final RemoteConfig getRemoteConfig() {
        return this.remoteConfig;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object pull(@NotNull MergeStrategy mergeStrategy, @Nullable String commitMessage, @Nullable Ref prefetchedRefToMerge, @NotNull Continuation<? super UpdateResult> $completion) {
        block17: {
            if (!($completion instanceof pull.1)) ** GOTO lbl-1000
            var15_5 = $completion;
            if ((var15_5.label & -2147483648) != 0) {
                var15_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    Object L$6;
                    /* synthetic */ Object result;
                    final /* synthetic */ Pull this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.pull(null, null, null, (Continuation<? super UpdateResult>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var16_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    JobKt.ensureActive((CoroutineContext)$continuation.getContext());
                    IcsManagerKt.getLOG().debug("Pull");
                    $continuation.L$0 = mergeStrategy;
                    $continuation.L$1 = commitMessage;
                    $continuation.L$2 = prefetchedRefToMerge;
                    $continuation.label = 1;
                    v0 = PullKt.fixAndGetState(this.repository, (Continuation<? super RepositoryState>)$continuation);
                    if (v0 == var16_7) {
                        return var16_7;
                    }
                    ** GOTO lbl28
                }
                case 1: {
                    prefetchedRefToMerge = (Ref)$continuation.L$2;
                    commitMessage = (String)$continuation.L$1;
                    mergeStrategy = (MergeStrategy)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl28:
                    // 2 sources

                    if (!(state = (RepositoryState)v0).canCheckout()) {
                        IcsManagerKt.getLOG().error("Cannot pull, repository in state " + state.getDescription());
                        return null;
                    }
                    v1 = prefetchedRefToMerge;
                    if (v1 != null) ** GOTO lbl51
                    $continuation.L$0 = mergeStrategy;
                    $continuation.L$1 = commitMessage;
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)prefetchedRefToMerge);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)state);
                    $continuation.label = 2;
                    v2 = Pull.fetch$default(this, null, null, (Continuation)$continuation, 3, null);
                    if (v2 == var16_7) {
                        return var16_7;
                    }
                    ** GOTO lbl49
                }
                case 2: {
                    state = (RepositoryState)$continuation.L$3;
                    prefetchedRefToMerge = (Ref)$continuation.L$2;
                    commitMessage = (String)$continuation.L$1;
                    mergeStrategy = (MergeStrategy)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl49:
                    // 2 sources

                    if ((v1 = (Ref)v2) == null) {
                        return null;
                    }
lbl51:
                    // 3 sources

                    refToMerge = v1;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)mergeStrategy);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)commitMessage);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)prefetchedRefToMerge);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)state);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)refToMerge);
                    $continuation.label = 3;
                    v3 = Pull.merge$default(this, refToMerge, mergeStrategy, false, null, false, false, commitMessage, (Continuation)$continuation, 60, null);
                    if (v3 == var16_7) {
                        return var16_7;
                    }
                    ** GOTO lbl70
                }
                case 3: {
                    refToMerge = (Ref)$continuation.L$4;
                    state = (RepositoryState)$continuation.L$3;
                    prefetchedRefToMerge = (Ref)$continuation.L$2;
                    commitMessage = (String)$continuation.L$1;
                    mergeStrategy = (MergeStrategy)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl70:
                    // 2 sources

                    mergeResult = (MergeResultEx)v3;
                    mergeStatus = mergeResult.getStatus();
                    $this$debug_u24default$iv = IcsManagerKt.getLOG();
                    e$iv = null;
                    $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        var13_19 = $this$debug_u24default$iv;
                        $i$a$-debug$default-Pull$pull$2 = false;
                        var13_19.debug(mergeStatus.toString(), e$iv);
                    }
                    if (mergeStatus != MergeResult.MergeStatus.CONFLICTING) break;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)mergeStrategy);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)commitMessage);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)prefetchedRefToMerge);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)state);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)refToMerge);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)mergeResult);
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)mergeStatus);
                    $continuation.label = 4;
                    v4 = PullKt.access$resolveConflicts(mergeResult, this.repository, (Continuation)$continuation);
                    if (v4 == var16_7) {
                        return var16_7;
                    }
                    ** GOTO lbl104
                }
                case 4: {
                    mergeStatus = (MergeResult.MergeStatus)$continuation.L$6;
                    mergeResult = (MergeResultEx)$continuation.L$5;
                    refToMerge = (Ref)$continuation.L$4;
                    state = (RepositoryState)$continuation.L$3;
                    prefetchedRefToMerge = (Ref)$continuation.L$2;
                    commitMessage = (String)$continuation.L$1;
                    mergeStrategy = (MergeStrategy)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl104:
                    // 2 sources

                    v5 = (UpdateResult)v4;
                    break block17;
                }
            }
            if (!mergeStatus.isSuccessful()) {
                throw new IllegalStateException(mergeResult.toString());
            }
            v5 = mergeResult.getResult();
        }
        return v5;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object pull$default(Pull pull2, MergeStrategy mergeStrategy, String string, Ref ref, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: pull");
        }
        if ((n & 1) != 0) {
            ThreeWayMergeStrategy threeWayMergeStrategy = MergeStrategy.RECURSIVE;
            Intrinsics.checkNotNullExpressionValue((Object)threeWayMergeStrategy, (String)"RECURSIVE");
            mergeStrategy = (MergeStrategy)threeWayMergeStrategy;
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            ref = null;
        }
        return pull2.pull(mergeStrategy, string, ref, (Continuation<? super UpdateResult>)continuation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object fetch(@Nullable RefUpdate.Result prevRefUpdateResult, @Nullable Function1<? super TrackingRefUpdate, Unit> refUpdateProcessor, @NotNull Continuation<? super Ref> $completion) {
        block26: {
            if (!($completion instanceof fetch.1)) ** GOTO lbl-1000
            var17_4 = $completion;
            if ((var17_4.label & -2147483648) != 0) {
                var17_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ Pull this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.fetch(null, null, (Continuation<? super Ref>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var18_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            block2 : switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    JobKt.ensureActive((CoroutineContext)$continuation.getContext());
                    $i$f$reportRawProgress = 0;
                    $continuation.L$0 = prevRefUpdateResult;
                    $continuation.L$1 = refUpdateProcessor;
                    $continuation.I$0 = $i$f$reportRawProgress;
                    $continuation.label = 1;
                    v0 = ContextKt.internalCurrentStepAsRaw((Continuation)$continuation);
                    if (v0 == var18_6) {
                        return var18_6;
                    }
                    ** GOTO lbl28
                }
                case 1: {
                    $i$f$reportRawProgress = $continuation.I$0;
                    refUpdateProcessor = (Function1)$continuation.L$1;
                    prevRefUpdateResult = (RefUpdate.Result)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl28:
                    // 2 sources

                    var7_10 = (AutoCloseable)v0;
                    var8_12 = null;
                    try {
                        handle$iv = (RawProgressReporterHandle)var7_10;
                        $i$a$-use-StepsKt$reportRawProgress$2$iv = false;
                        reporter = handle$iv.getReporter();
                        $i$a$-reportRawProgress-Pull$fetch$fetchResult$1 = false;
                        $completion$iv = $continuation;
                        $i$f$currentCoroutineContext = false;
                        progressMonitor = new JGitCoroutineProgressMonitor(JobKt.getJob((CoroutineContext)$continuation.getContext()), reporter);
                        handle$iv = GitExKt.fetch(this.repository, this.remoteConfig, this.manager.getCredentialsProvider(), progressMonitor);
                        v1 = handle$iv;
                    }
                    catch (Throwable var10_17) {
                        var8_12 = var10_17;
                        throw var10_17;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)var7_10, (Throwable)var8_12);
                    }
                    if (v1 == null) {
                        return null;
                    }
                    fetchResult = v1;
                    if (IcsManagerKt.getLOG().isDebugEnabled()) {
                        GitRepositoryManagerKt.printMessages((OperationResult)fetchResult);
                        for (TrackingRefUpdate refUpdate : fetchResult.getTrackingRefUpdates()) {
                            IcsManagerKt.getLOG().debug(refUpdate.toString());
                        }
                    }
                    JobKt.ensureActive((CoroutineContext)$continuation.getContext());
                    hasChanges = 0;
lbl60:
                    // 4 sources

                    for (RefSpec fetchRefSpec : this.remoteConfig.getFetchRefSpecs()) {
                        refUpdate = fetchResult.getTrackingRefUpdate(fetchRefSpec.getDestination());
                        if (refUpdate == null) {
                            IcsManagerKt.getLOG().debug("No ref update for " + fetchRefSpec);
                            continue;
                        }
                        refUpdateResult = refUpdate.getResult();
                        if (refUpdateResult != RefUpdate.Result.LOCK_FAILURE && refUpdateResult != RefUpdate.Result.IO_FAILURE) break block2;
                        if (prevRefUpdateResult == refUpdateResult) {
                            throw new IOException("Ref update result " + refUpdateResult.name() + ", we have already tried to fetch again, but no luck");
                        }
                        IcsManagerKt.getLOG().warn("Ref update result " + refUpdateResult.name() + ", trying again after 500 ms");
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)prevRefUpdateResult);
                        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)refUpdateProcessor);
                        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)fetchResult);
                        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)fetchRefSpec);
                        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)refUpdate);
                        $continuation.L$5 = refUpdateResult;
                        $continuation.I$0 = hasChanges;
                        $continuation.label = 2;
                        v2 = DelayKt.delay((long)500L, (Continuation)$continuation);
                        if (v2 == var18_6) {
                            return var18_6;
                        }
                        ** GOTO lbl93
                    }
                    break block26;
                }
                case 2: {
                    hasChanges = $continuation.I$0;
                    refUpdateResult = (RefUpdate.Result)$continuation.L$5;
                    refUpdate = (TrackingRefUpdate)$continuation.L$4;
                    fetchRefSpec = (RefSpec)$continuation.L$3;
                    fetchResult = (FetchResult)$continuation.L$2;
                    refUpdateProcessor = (Function1)$continuation.L$1;
                    prevRefUpdateResult = (RefUpdate.Result)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl93:
                    // 2 sources

                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)prevRefUpdateResult);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)refUpdateProcessor);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)fetchResult);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)fetchRefSpec);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)refUpdate);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)refUpdateResult);
                    $continuation.I$0 = hasChanges;
                    $continuation.label = 3;
                    v3 = Pull.fetch$default(this, refUpdateResult, null, (Continuation)$continuation, 2, null);
                    if (v3 == var18_6) {
                        return var18_6;
                    }
                    ** GOTO lbl115
                }
                case 3: {
                    hasChanges = $continuation.I$0;
                    refUpdateResult = (RefUpdate.Result)$continuation.L$5;
                    refUpdate = (TrackingRefUpdate)$continuation.L$4;
                    fetchRefSpec = (RefSpec)$continuation.L$3;
                    fetchResult = (FetchResult)$continuation.L$2;
                    refUpdateProcessor = (Function1)$continuation.L$1;
                    prevRefUpdateResult = (RefUpdate.Result)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl115:
                    // 2 sources

                    return v3;
                }
            }
            if (refUpdateResult != RefUpdate.Result.FAST_FORWARD && refUpdateResult != RefUpdate.Result.NEW && refUpdateResult != RefUpdate.Result.FORCED) {
                throw new UnsupportedOperationException("Unsupported ref update result");
            }
            if (hasChanges == 0) {
                hasChanges = refUpdateResult != RefUpdate.Result.NO_CHANGE ? 1 : 0;
            }
            v4 = refUpdateProcessor;
            if (v4 == null) ** GOTO lbl60
            v4.invoke((Object)refUpdate);
            ** GOTO lbl60
        }
        if (hasChanges == 0) {
            IcsManagerKt.getLOG().debug("No remote changes");
            return null;
        }
        v5 = fetchResult.getAdvertisedRef(GitExKt.getRemoteBranchFullName((Config)this.config));
        if (v5 == null) {
            throw new IllegalStateException("Could not get advertised ref");
        }
        return v5;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object fetch$default(Pull pull2, RefUpdate.Result result, Function1 function1, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: fetch");
        }
        if ((n & 1) != 0) {
            result = null;
        }
        if ((n & 2) != 0) {
            function1 = null;
        }
        return pull2.fetch(result, (Function1<? super TrackingRefUpdate, Unit>)function1, (Continuation<? super Ref>)continuation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Object merge(@NotNull Ref unpeeledRef, @NotNull MergeStrategy mergeStrategy, boolean commit2, @NotNull MergeCommand.FastForwardMode fastForwardMode, boolean squash, boolean forceMerge, @Nullable String commitMessage, @NotNull Continuation<? super MergeResultEx> $completion) {
        JobKt.ensureActive((CoroutineContext)$completion.getContext());
        Ref ref = this.repository.findRef("HEAD");
        if (ref == null) {
            throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
        }
        Ref head = ref;
        Ref ref2 = this.repository.getRefDatabase().peel(unpeeledRef);
        ObjectId objectId = ref2.getPeeledObjectId();
        if (objectId == null) {
            objectId = ref2.getObjectId();
        }
        ObjectId objectId2 = objectId;
        List dirCacheCheckout = null;
        try (RevWalk revWalk = new RevWalk(this.repository);){
            ImmutableUpdateResult immutableUpdateResult;
            RevCommit srcCommit = revWalk.lookupCommit((AnyObjectId)objectId2);
            ObjectId headId = head.getObjectId();
            if (headId == null) {
                revWalk.parseHeaders((RevObject)srcCommit);
                dirCacheCheckout = new DirCacheCheckout(this.repository, this.repository.lockDirCache(), (ObjectId)srcCommit.getTree());
                dirCacheCheckout.setFailOnConflict(false);
                dirCacheCheckout.checkout();
                RefUpdate refUpdate = this.repository.updateRef(head.getTarget().getName());
                refUpdate.setNewObjectId((AnyObjectId)objectId2);
                refUpdate.setExpectedOldObjectId(null);
                refUpdate.setRefLogMessage("initial pull", false);
                if (refUpdate.update() != RefUpdate.Result.NEW) {
                    throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
                }
                Object object = new ObjectId[]{null, srcCommit};
                Collection collection = dirCacheCheckout.getUpdated().keySet();
                List list = dirCacheCheckout.getRemoved();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRemoved(...)");
                object = new MergeResultEx(MergeResult.MergeStatus.FAST_FORWARD, (ObjectId[])object, new ImmutableUpdateResult(collection, list), null, 8, null);
                return object;
            }
            StringBuilder refLogMessage = new StringBuilder("merge ");
            refLogMessage.append(ref2.getName());
            RevCommit headCommit = revWalk.lookupCommit((AnyObjectId)headId);
            if (!forceMerge && revWalk.isMergedInto(srcCommit, headCommit)) {
                Object object = new ObjectId[]{headCommit, srcCommit};
                object = new MergeResultEx(MergeResult.MergeStatus.ALREADY_UP_TO_DATE, (ObjectId[])object, RepositoryManagerKt.getEMPTY_UPDATE_RESULT(), null, 8, null);
                return object;
            }
            if (!forceMerge && fastForwardMode != MergeCommand.FastForwardMode.NO_FF && revWalk.isMergedInto(headCommit, srcCommit)) {
                Object squashedCommits;
                refLogMessage.append(": ").append(MergeResult.MergeStatus.FAST_FORWARD);
                dirCacheCheckout = new DirCacheCheckout(this.repository, (ObjectId)headCommit.getTree(), this.repository.lockDirCache(), (ObjectId)srcCommit.getTree());
                dirCacheCheckout.setFailOnConflict(false);
                dirCacheCheckout.checkout();
                MergeResult.MergeStatus mergeStatus = null;
                if (squash) {
                    mergeStatus = MergeResult.MergeStatus.FAST_FORWARD_SQUASHED;
                    squashedCommits = RevWalkUtils.find((RevWalk)revWalk, (RevCommit)srcCommit, (RevCommit)headCommit);
                    this.repository.writeSquashCommitMsg(new SquashMessageFormatter().format((List)squashedCommits, head));
                } else {
                    Intrinsics.checkNotNull((Object)srcCommit);
                    PullKt.access$updateHead(refLogMessage, (ObjectId)srcCommit, headId, this.repository);
                    mergeStatus = MergeResult.MergeStatus.FAST_FORWARD;
                }
                squashedCommits = new ObjectId[]{headCommit, srcCommit};
                Collection collection = dirCacheCheckout.getUpdated().keySet();
                List list = dirCacheCheckout.getRemoved();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRemoved(...)");
                squashedCommits = new MergeResultEx(mergeStatus, (ObjectId[])squashedCommits, new ImmutableUpdateResult(collection, list), null, 8, null);
                return squashedCommits;
            }
            if (fastForwardMode == MergeCommand.FastForwardMode.FF_ONLY) {
                Object mergeStatus = new ObjectId[]{headCommit, srcCommit};
                mergeStatus = new MergeResultEx(MergeResult.MergeStatus.ABORTED, (ObjectId[])mergeStatus, RepositoryManagerKt.getEMPTY_UPDATE_RESULT(), null, 8, null);
                return mergeStatus;
            }
            String mergeMessage = null;
            if (squash) {
                mergeMessage = "";
                this.repository.writeSquashCommitMsg(new SquashMessageFormatter().format(RevWalkUtils.find((RevWalk)revWalk, (RevCommit)srcCommit, (RevCommit)headCommit), head));
            } else {
                mergeMessage = this.commitMessageFormatter.mergeMessage(CollectionsKt.listOf((Object)ref2), head);
                this.repository.writeMergeCommitMsg(mergeMessage);
                this.repository.writeMergeHeads(CollectionsKt.listOf((Object)ref2.getObjectId()));
            }
            Merger merger = mergeStrategy.newMerger(this.repository);
            boolean noProblems = false;
            Map lowLevelResults = null;
            Map failingPaths = null;
            List unmergedPaths = null;
            if (merger instanceof ResolveMerger) {
                var24_32 = new String[]{"BASE", "HEAD", ref2.getName()};
                ((ResolveMerger)merger).setCommitNames((String[])var24_32);
                ((ResolveMerger)merger).setWorkingTreeIterator((WorkingTreeIterator)new FileTreeIterator(this.repository));
                var24_32 = new AnyObjectId[]{headCommit, srcCommit};
                noProblems = ((ResolveMerger)merger).merge(var24_32);
                lowLevelResults = ((ResolveMerger)merger).getMergeResults();
                failingPaths = ((ResolveMerger)merger).getFailingPaths();
                unmergedPaths = ((ResolveMerger)merger).getUnmergedPaths();
            } else {
                var24_32 = new AnyObjectId[]{headCommit, srcCommit};
                noProblems = merger.merge(var24_32);
            }
            refLogMessage.append(": Merge made by ");
            refLogMessage.append(revWalk.isMergedInto(headCommit, srcCommit) ? "recursive" : mergeStrategy.getName());
            refLogMessage.append('.');
            if (merger instanceof ResolveMerger) {
                Collection collection = ((ResolveMerger)merger).getToBeCheckedOut().keySet();
                Set set = ((ResolveMerger)merger).getToBeDeleted();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getToBeDeleted(...)");
                immutableUpdateResult = new ImmutableUpdateResult(collection, set);
            } else {
                immutableUpdateResult = null;
            }
            ImmutableUpdateResult result = immutableUpdateResult;
            if (noProblems) {
                if (!(merger instanceof ResolveMerger)) {
                    dirCacheCheckout = new DirCacheCheckout(this.repository, (ObjectId)headCommit.getTree(), this.repository.lockDirCache(), merger.getResultTreeId());
                    dirCacheCheckout.setFailOnConflict(false);
                    dirCacheCheckout.checkout();
                    Collection collection = dirCacheCheckout.getUpdated().keySet();
                    List list = dirCacheCheckout.getRemoved();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRemoved(...)");
                    result = new ImmutableUpdateResult(collection, list);
                }
                MergeResult.MergeStatus mergeStatus = null;
                if (!commit2 && squash) {
                    mergeStatus = MergeResult.MergeStatus.MERGED_SQUASHED_NOT_COMMITTED;
                }
                if (!commit2 && !squash) {
                    mergeStatus = MergeResult.MergeStatus.MERGED_NOT_COMMITTED;
                }
                if (commit2 && !squash) {
                    GitExKt.commit$default(this.repository, commitMessage, refLogMessage.toString(), null, null, 12, null).getId();
                    mergeStatus = MergeResult.MergeStatus.MERGED;
                }
                if (commit2 && squash) {
                    mergeStatus = MergeResult.MergeStatus.MERGED_SQUASHED;
                }
                MergeResult.MergeStatus mergeStatus2 = mergeStatus;
                Intrinsics.checkNotNull((Object)mergeStatus2);
                Object object = new ObjectId[]{headCommit.getId(), srcCommit.getId()};
                ImmutableUpdateResult immutableUpdateResult2 = result;
                Intrinsics.checkNotNull((Object)immutableUpdateResult2);
                object = new MergeResultEx(mergeStatus2, (ObjectId[])object, immutableUpdateResult2, null, 8, null);
                return object;
            }
            if (failingPaths == null) {
                this.repository.writeMergeCommitMsg(new MergeMessageFormatter().formatWithConflicts(mergeMessage, unmergedPaths));
                Object object = new ObjectId[]{headCommit.getId(), srcCommit.getId()};
                ImmutableUpdateResult immutableUpdateResult3 = result;
                Intrinsics.checkNotNull((Object)immutableUpdateResult3);
                object = new MergeResultEx(MergeResult.MergeStatus.CONFLICTING, (ObjectId[])object, immutableUpdateResult3, lowLevelResults);
                return object;
            }
            this.repository.writeMergeCommitMsg(null);
            this.repository.writeMergeHeads(null);
            Object object = new ObjectId[]{headCommit.getId(), srcCommit.getId()};
            ImmutableUpdateResult immutableUpdateResult4 = result;
            Intrinsics.checkNotNull((Object)immutableUpdateResult4);
            object = new MergeResultEx(MergeResult.MergeStatus.FAILED, (ObjectId[])object, immutableUpdateResult4, lowLevelResults);
            return object;
        }
    }

    public static /* synthetic */ Object merge$default(Pull pull2, Ref ref, MergeStrategy mergeStrategy, boolean bl, MergeCommand.FastForwardMode fastForwardMode, boolean bl2, boolean bl3, String string, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: merge");
        }
        if ((n & 2) != 0) {
            ThreeWayMergeStrategy threeWayMergeStrategy = MergeStrategy.RECURSIVE;
            Intrinsics.checkNotNullExpressionValue((Object)threeWayMergeStrategy, (String)"RECURSIVE");
            mergeStrategy = (MergeStrategy)threeWayMergeStrategy;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            fastForwardMode = MergeCommand.FastForwardMode.FF;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        if ((n & 0x20) != 0) {
            bl3 = false;
        }
        if ((n & 0x40) != 0) {
            string = null;
        }
        return pull2.merge(ref, mergeStrategy, bl, fastForwardMode, bl2, bl3, string, (Continuation<? super MergeResultEx>)continuation);
    }
}

