/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.commitgraph;

import org.eclipse.jgit.internal.storage.commitgraph.CommitGraph;
import org.eclipse.jgit.internal.storage.commitgraph.GraphCommitData;
import org.eclipse.jgit.internal.storage.commitgraph.GraphObjectIndex;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;

class CommitGraphV1
implements CommitGraph {
    private final GraphObjectIndex idx;
    private final GraphCommitData commitData;

    CommitGraphV1(GraphObjectIndex index, GraphCommitData commitData) {
        this.idx = index;
        this.commitData = commitData;
    }

    @Override
    public int findGraphPosition(AnyObjectId commit) {
        return this.idx.findGraphPosition(commit);
    }

    @Override
    public CommitGraph.CommitData getCommitData(int graphPos) {
        if (graphPos < 0 || (long)graphPos >= this.getCommitCnt()) {
            return null;
        }
        return this.commitData.getCommitData(graphPos);
    }

    @Override
    public ObjectId getObjectId(int graphPos) {
        return this.idx.getObjectId(graphPos);
    }

    @Override
    public long getCommitCnt() {
        return this.idx.getCommitCnt();
    }
}

