/*
 * Decompiled with CFR 0.152.
 */
package uk.co.ben_gibson.git.link.listener;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import uk.co.ben_gibson.git.link.GitLinkBundle;
import uk.co.ben_gibson.git.link.platform.Platform;
import uk.co.ben_gibson.git.link.platform.PlatformDetector;
import uk.co.ben_gibson.git.link.settings.ApplicationSettings;
import uk.co.ben_gibson.git.link.settings.ProjectSettings;
import uk.co.ben_gibson.git.link.ui.notification.Notification;
import uk.co.ben_gibson.git.link.ui.notification.NotifierKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0096@\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"Luk/co/ben_gibson/git/link/listener/ApplicationStartupListener;", "Lcom/intellij/openapi/startup/ProjectActivity;", "()V", "detectPlatform", "", "project", "Lcom/intellij/openapi/project/Project;", "execute", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "showVersionNotification", "GitLink"})
@SourceDebugExtension(value={"SMAP\nApplicationStartupListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplicationStartupListener.kt\nuk/co/ben_gibson/git/link/listener/ApplicationStartupListener\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,50:1\n43#2,3:51\n30#3,3:54\n30#3,3:57\n*S KotlinDebug\n*F\n+ 1 ApplicationStartupListener.kt\nuk/co/ben_gibson/git/link/listener/ApplicationStartupListener\n*L\n20#1:51,3\n32#1:54,3\n38#1:57,3\n*E\n"})
public final class ApplicationStartupListener
implements ProjectActivity {
    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        this.showVersionNotification(project);
        this.detectPlatform(project);
        return Unit.INSTANCE;
    }

    private final void showVersionNotification(Project project) {
        String version;
        boolean $i$f$service = false;
        Class<ApplicationSettings> serviceClass$iv = ApplicationSettings.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        ApplicationSettings settings2 = (ApplicationSettings)object;
        IdeaPluginDescriptor ideaPluginDescriptor = GitLinkBundle.INSTANCE.plugin();
        String string = version = ideaPluginDescriptor != null ? ideaPluginDescriptor.getVersion() : null;
        if (Intrinsics.areEqual((Object)version, (Object)settings2.getLastVersion())) {
            return;
        }
        settings2.setLastVersion(version);
        String string2 = version;
        if (string2 == null) {
            string2 = "Unknown";
        }
        NotifierKt.sendNotification(Notification.Companion.welcome(string2), project);
    }

    private final void detectPlatform(Project project) {
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class serviceClass$iv = ProjectSettings.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        ProjectSettings projectSettings = (ProjectSettings)object;
        if (projectSettings.getHost() != null) {
            return;
        }
        $this$service$iv = (ComponentManager)project;
        $i$f$service = false;
        serviceClass$iv = PlatformDetector.class;
        object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        ((PlatformDetector)object).detect((Function1<? super Platform, Unit>)((Function1)new Function1<Platform, Unit>(project, projectSettings){
            final /* synthetic */ Project $project;
            final /* synthetic */ ProjectSettings $projectSettings;
            {
                this.$project = $project;
                this.$projectSettings = $projectSettings;
                super(1);
            }

            public final void invoke(@Nullable Platform platform) {
                if (platform == null) {
                    NotifierKt.sendNotification(Notification.Companion.couldNotDetectPlatform(this.$project), this.$project);
                    return;
                }
                NotifierKt.sendNotification(Notification.Companion.platformAutoDetected(platform, this.$project), this.$project);
                this.$projectSettings.setHost(platform.getId().toString());
            }
        }));
    }
}

