/*
 * Decompiled with CFR 0.152.
 */
package uk.co.ben_gibson.git.link.url.factory;

import com.intellij.openapi.components.Service;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import uk.co.ben_gibson.git.link.git.File;
import uk.co.ben_gibson.git.link.ui.LineSelection;
import uk.co.ben_gibson.git.link.url.UrlOptions;
import uk.co.ben_gibson.git.link.url.factory.UrlFactory;
import uk.co.ben_gibson.url.Host;
import uk.co.ben_gibson.url.Path;
import uk.co.ben_gibson.url.QueryString;
import uk.co.ben_gibson.url.URL;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a8\u0006\u0018"}, d2={"Luk/co/ben_gibson/git/link/url/factory/AzureUrlFactory;", "Luk/co/ben_gibson/git/link/url/factory/UrlFactory;", "()V", "addLineSelectionParameters", "Luk/co/ben_gibson/url/QueryString;", "queryString", "lineSelection", "Luk/co/ben_gibson/git/link/ui/LineSelection;", "createFileParameter", "", "file", "Luk/co/ben_gibson/git/link/git/File;", "createUrl", "Luk/co/ben_gibson/url/URL;", "baseUrl", "options", "Luk/co/ben_gibson/git/link/url/UrlOptions;", "createUrlToCommit", "Luk/co/ben_gibson/git/link/url/UrlOptions$UrlOptionsCommit;", "createUrlToFileAtBranch", "Luk/co/ben_gibson/git/link/url/UrlOptions$UrlOptionsFileAtBranch;", "createUrlToFileAtCommit", "Luk/co/ben_gibson/git/link/url/UrlOptions$UrlOptionsFileAtCommit;", "normaliseBaseUrl", "GitLink"})
@SourceDebugExtension(value={"SMAP\nAzureUrlFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AzureUrlFactory.kt\nuk/co/ben_gibson/git/link/url/factory/AzureUrlFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
public final class AzureUrlFactory
implements UrlFactory {
    @Override
    @NotNull
    public URL createUrl(@NotNull URL baseUrl, @NotNull UrlOptions options) {
        URL uRL;
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        URL normalisedBaseUrl = this.normaliseBaseUrl(baseUrl);
        UrlOptions urlOptions = options;
        if (urlOptions instanceof UrlOptions.UrlOptionsFileAtBranch) {
            uRL = this.createUrlToFileAtBranch(normalisedBaseUrl, (UrlOptions.UrlOptionsFileAtBranch)options);
        } else if (urlOptions instanceof UrlOptions.UrlOptionsFileAtCommit) {
            uRL = this.createUrlToFileAtCommit(normalisedBaseUrl, (UrlOptions.UrlOptionsFileAtCommit)options);
        } else if (urlOptions instanceof UrlOptions.UrlOptionsCommit) {
            uRL = this.createUrlToCommit(normalisedBaseUrl, (UrlOptions.UrlOptionsCommit)options);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return uRL;
    }

    private final URL createUrlToFileAtCommit(URL baseUrl, UrlOptions.UrlOptionsFileAtCommit options) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"version", (Object)CollectionsKt.listOf((Object)("GC" + options.getCommit()))), TuplesKt.to((Object)"path", (Object)CollectionsKt.listOf((Object)this.createFileParameter(options.getFile())))};
        QueryString queryString = QueryString.Companion.fromMap(MapsKt.mapOf((Pair[])pairArray));
        if (options.getLineSelection() != null) {
            queryString = this.addLineSelectionParameters(queryString, options.getLineSelection());
        }
        return baseUrl.withQueryString(queryString);
    }

    private final URL createUrlToFileAtBranch(URL baseUrl, UrlOptions.UrlOptionsFileAtBranch options) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"version", (Object)CollectionsKt.listOf((Object)("GB" + options.getBranch()))), TuplesKt.to((Object)"path", (Object)CollectionsKt.listOf((Object)this.createFileParameter(options.getFile())))};
        QueryString queryString = QueryString.Companion.fromMap(MapsKt.mapOf((Pair[])pairArray));
        if (options.getLineSelection() != null) {
            queryString = this.addLineSelectionParameters(queryString, options.getLineSelection());
        }
        return baseUrl.withQueryString(queryString);
    }

    private final String createFileParameter(File file) {
        String fileName = file.isRoot() ? "" : file.getName();
        return file.getPath() + "/" + fileName;
    }

    private final URL createUrlToCommit(URL baseUrl, UrlOptions.UrlOptionsCommit options) {
        Path path = baseUrl.getPath();
        if (path == null) {
            boolean bl = false;
            String string = "Unexpected error: repository path must be present in remote URL";
            throw new IllegalArgumentException(string.toString());
        }
        Path path2 = path;
        Object[] objectArray = new String[]{"commit", options.getCommit().toString()};
        return baseUrl.withPath(path2.with(Path.Companion.fromSegments(CollectionsKt.listOf((Object[])objectArray))));
    }

    private final QueryString addLineSelectionParameters(QueryString queryString, LineSelection lineSelection) {
        return queryString.withParameter("line", String.valueOf(lineSelection.getStart())).withParameter("lineEnd", String.valueOf(lineSelection.getEnd() + 1)).withParameter("lineStartColumn", "1").withParameter("lineEndColumn", "1");
    }

    private final URL normaliseBaseUrl(URL baseUrl) {
        String[] stringArray = new String[]{"/"};
        List basePathParts = CollectionsKt.toMutableList((Collection)StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)String.valueOf(baseUrl.getPath()), (CharSequence)"v3/"), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        if (!basePathParts.contains("_git")) {
            int indexToAddGit = basePathParts.size() >= 3 ? 2 : 1;
            basePathParts.add(indexToAddGit, "_git");
        }
        URL normalisedBaseUrl = URL.copy$default((URL)baseUrl, null, null, null, null, (Path)Path.Companion.invoke(CollectionsKt.joinToString$default((Iterable)basePathParts, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null)), null, null, (int)111, null);
        if (StringsKt.startsWith$default((String)baseUrl.getHost().toString(), (String)"ssh.", (boolean)false, (int)2, null)) {
            normalisedBaseUrl = URL.copy$default((URL)normalisedBaseUrl, null, (Host)Host.Companion.invoke(StringsKt.removePrefix((String)baseUrl.getHost().toString(), (CharSequence)"ssh.")), null, null, null, null, null, (int)125, null);
        }
        return normalisedBaseUrl;
    }
}

