/*
 * Decompiled with CFR 0.152.
 */
package uk.co.ben_gibson.git.link.url.factory;

import com.google.common.base.Function;
import com.google.common.net.UrlEscapers;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import uk.co.ben_gibson.git.link.git.Commit;
import uk.co.ben_gibson.git.link.git.File;
import uk.co.ben_gibson.git.link.ui.LineSelection;
import uk.co.ben_gibson.git.link.url.UrlOptions;
import uk.co.ben_gibson.git.link.url.factory.UrlFactory;
import uk.co.ben_gibson.git.link.url.template.UrlTemplates;
import uk.co.ben_gibson.url.URL;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\fH\u0002J\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u0018\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\"\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u001eH\u0002J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u001fH\u0002J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0002RN\u0010\u0005\u001aB\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b* \u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Luk/co/ben_gibson/git/link/url/factory/TemplatedUrlFactory;", "Luk/co/ben_gibson/git/link/url/factory/UrlFactory;", "templates", "Luk/co/ben_gibson/git/link/url/template/UrlTemplates;", "(Luk/co/ben_gibson/git/link/url/template/UrlTemplates;)V", "escape", "Lcom/google/common/base/Function;", "", "kotlin.jvm.PlatformType", "remotePathPattern", "Ljava/util/regex/Pattern;", "createUrl", "Luk/co/ben_gibson/url/URL;", "baseUrl", "options", "Luk/co/ben_gibson/git/link/url/UrlOptions;", "processBaseUrl", "template", "processBranch", "branch", "processCommit", "commit", "Luk/co/ben_gibson/git/link/git/Commit;", "processFile", "file", "Luk/co/ben_gibson/git/link/git/File;", "processLineSelection", "lineSelection", "Luk/co/ben_gibson/git/link/ui/LineSelection;", "processTemplate", "Luk/co/ben_gibson/git/link/url/UrlOptions$UrlOptionsCommit;", "Luk/co/ben_gibson/git/link/url/UrlOptions$UrlOptionsFileAtBranch;", "Luk/co/ben_gibson/git/link/url/UrlOptions$UrlOptionsFileAtCommit;", "removeUnmatchedSubstitutions", "GitLink"})
@SourceDebugExtension(value={"SMAP\nTemplatedUrlFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TemplatedUrlFactory.kt\nuk/co/ben_gibson/git/link/url/factory/TemplatedUrlFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1#2:104\n*E\n"})
public class TemplatedUrlFactory
implements UrlFactory {
    @NotNull
    private final UrlTemplates templates;
    private final Function<String, String> escape;
    private final Pattern remotePathPattern;

    public TemplatedUrlFactory(@NotNull UrlTemplates templates) {
        Intrinsics.checkNotNullParameter((Object)templates, (String)"templates");
        this.templates = templates;
        this.escape = UrlEscapers.urlPathSegmentEscaper().asFunction();
        this.remotePathPattern = Pattern.compile("\\{remote:url:path:(\\d)}");
    }

    @Override
    @NotNull
    public URL createUrl(@NotNull URL baseUrl, @NotNull UrlOptions options) {
        String string;
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Object object = options;
        if (object instanceof UrlOptions.UrlOptionsFileAtCommit) {
            string = this.processTemplate((UrlOptions.UrlOptionsFileAtCommit)options);
        } else if (object instanceof UrlOptions.UrlOptionsFileAtBranch) {
            string = this.processTemplate((UrlOptions.UrlOptionsFileAtBranch)options);
        } else if (object instanceof UrlOptions.UrlOptionsCommit) {
            string = this.processTemplate((UrlOptions.UrlOptionsCommit)options);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String processTemplate = string;
        processTemplate = this.processBaseUrl(processTemplate, baseUrl);
        processTemplate = this.removeUnmatchedSubstitutions(processTemplate);
        object = processTemplate;
        Regex regex = new Regex("(?<!:)/{2,}");
        String string2 = "/";
        processTemplate = regex.replace((CharSequence)object, string2);
        return URL.Companion.fromString(processTemplate);
    }

    private final String removeUnmatchedSubstitutions(String template) {
        CharSequence charSequence = template;
        Regex regex = new Regex("\\{.+?}");
        String string = "";
        return regex.replace(charSequence, string);
    }

    private final String processTemplate(UrlOptions.UrlOptionsFileAtBranch options) {
        String template = this.templates.getFileAtBranch();
        template = this.processFile(template, options.getFile());
        template = this.processBranch(template, options.getBranch());
        template = this.processLineSelection(template, options.getLineSelection(), options.getFile());
        return template;
    }

    private final String processTemplate(UrlOptions.UrlOptionsFileAtCommit options) {
        String template = this.templates.getFileAtCommit();
        template = this.processFile(template, options.getFile());
        template = this.processCommit(template, options.getCommit());
        template = this.processBranch(template, options.getCurrentBranch());
        template = this.processLineSelection(template, options.getLineSelection(), options.getFile());
        return template;
    }

    private final String processTemplate(UrlOptions.UrlOptionsCommit options) {
        String template = this.templates.getCommit();
        template = this.processCommit(template, options.getCommit());
        template = this.processBranch(template, options.getCurrentBranch());
        return template;
    }

    private final String processBaseUrl(String template, URL baseUrl) {
        String processed = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)template, (String)"{remote:url:protocol}", (String)baseUrl.getScheme().toString(), (boolean)false, (int)4, null), (String)"{remote:url:host}", (String)baseUrl.getHost().toString(), (boolean)false, (int)4, null), (String)"{remote:url}", (String)baseUrl.toString(), (boolean)false, (int)4, null), (String)"{remote:url:path}", (String)String.valueOf(baseUrl.getPath()), (boolean)false, (int)4, null);
        String[] stringArray = new String[]{"/"};
        List pathParts = StringsKt.split$default((CharSequence)String.valueOf(baseUrl.getPath()), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        Matcher remotePathMatcher = this.remotePathPattern.matcher(template);
        while (remotePathMatcher.find()) {
            Object object;
            String string = remotePathMatcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            int position = Integer.parseInt(string);
            String string2 = processed;
            String string3 = "{remote:url:path:" + position + "}";
            List list = pathParts;
            if (position >= 0 && position <= CollectionsKt.getLastIndex((List)list)) {
                object = list.get(position);
            } else {
                int n = position;
                String string4 = string3;
                String string5 = string2;
                boolean bl = false;
                String string6 = "";
                string2 = string5;
                string3 = string4;
                object = string6;
            }
            processed = StringsKt.replace$default((String)string2, (String)string3, (String)((String)object), (boolean)false, (int)4, null);
        }
        return processed;
    }

    private final String processBranch(String template, String branch) {
        Object object = this.escape.apply((Object)branch);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"apply(...)");
        return StringsKt.replace$default((String)template, (String)"{branch}", (String)((String)object), (boolean)false, (int)4, null);
    }

    private final String processFile(String template, File file) {
        String string = StringsKt.replace$default((String)template, (String)"{object}", (String)(file.isDirectory() ? "tree" : "blob"), (boolean)false, (int)4, null);
        String[] stringArray = file.isRoot() ? "" : (String)this.escape.apply((Object)file.getName());
        Intrinsics.checkNotNull((Object)stringArray);
        String string2 = StringsKt.replace$default((String)string, (String)"{file:name}", (String)stringArray, (boolean)false, (int)4, null);
        stringArray = new String[]{"/"};
        return StringsKt.replace$default((String)string2, (String)"{file:path}", (String)CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)file.getPath(), (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"/", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(this){
            final /* synthetic */ TemplatedUrlFactory this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object object = TemplatedUrlFactory.access$getEscape$p(this.this$0).apply((Object)it);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"apply(...)");
                return (CharSequence)object;
            }
        }), (int)30, null), (boolean)false, (int)4, null);
    }

    private final String processCommit(String template, Commit commit) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)template, (String)"{commit}", (String)commit.toString(), (boolean)false, (int)4, null), (String)"{commit:short}", (String)commit.getShortHash(), (boolean)false, (int)4, null);
    }

    private final String processLineSelection(String template, LineSelection lineSelection, File file) {
        if (lineSelection == null || file.isDirectory()) {
            CharSequence charSequence = template;
            Regex regex = new Regex("\\{line-block:start}.+\\{line-block:end}");
            String string = "";
            return regex.replace(charSequence, string);
        }
        return StringsKt.replace$default((String)StringsKt.replace$default((String)template, (String)"{line:start}", (String)String.valueOf(lineSelection.getStart()), (boolean)false, (int)4, null), (String)"{line:end}", (String)String.valueOf(lineSelection.getEnd()), (boolean)false, (int)4, null);
    }

    public static final /* synthetic */ Function access$getEscape$p(TemplatedUrlFactory $this) {
        return $this.escape;
    }
}

