/*
 * Decompiled with CFR 0.152.
 */
package mobi.hsz.idea.gitignore.command;

import com.intellij.codeWithMe.ClientId;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mobi.hsz.idea.gitignore.IgnoreBundle;
import mobi.hsz.idea.gitignore.command.CommandAction;
import mobi.hsz.idea.gitignore.psi.IgnoreEntry;
import mobi.hsz.idea.gitignore.psi.IgnoreVisitor;
import mobi.hsz.idea.gitignore.settings.IgnoreSettings;
import mobi.hsz.idea.gitignore.util.ContentGenerator;
import mobi.hsz.idea.gitignore.util.Notify;
import mobi.hsz.idea.gitignore.util.Utils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\u000f\u001a\u00020\u0002H\u0014R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lmobi/hsz/idea/gitignore/command/AppendFileCommandAction;", "Lmobi/hsz/idea/gitignore/command/CommandAction;", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "file", "content", "", "", "ignoreDuplicates", "", "ignoreComments", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiFile;Ljava/util/Set;ZZ)V", "settings", "Lmobi/hsz/idea/gitignore/settings/IgnoreSettings;", "compute", "idea-gitignore"})
@SourceDebugExtension(value={"SMAP\nAppendFileCommandAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppendFileCommandAction.kt\nmobi/hsz/idea/gitignore/command/AppendFileCommandAction\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,80:1\n43#2,3:81\n*S KotlinDebug\n*F\n+ 1 AppendFileCommandAction.kt\nmobi/hsz/idea/gitignore/command/AppendFileCommandAction\n*L\n29#1:81,3\n*E\n"})
public final class AppendFileCommandAction
extends CommandAction<PsiFile> {
    @NotNull
    private final Project project;
    @NotNull
    private final PsiFile file;
    @NotNull
    private final Set<String> content;
    private final boolean ignoreDuplicates;
    private final boolean ignoreComments;
    @NotNull
    private final IgnoreSettings settings;

    public AppendFileCommandAction(@NotNull Project project, @NotNull PsiFile file, @NotNull Set<String> content, boolean ignoreDuplicates, boolean ignoreComments) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(content, (String)"content");
        super(project);
        this.project = project;
        this.file = file;
        this.content = content;
        this.ignoreDuplicates = ignoreDuplicates;
        this.ignoreComments = ignoreComments;
        boolean $i$f$service = false;
        Class<IgnoreSettings> serviceClass$iv = IgnoreSettings.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        this.settings = (IgnoreSettings)object;
    }

    public /* synthetic */ AppendFileCommandAction(Project project, PsiFile psiFile, Set set, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        this(project, psiFile, set, bl, bl2);
    }

    @Override
    @NotNull
    protected PsiFile compute() {
        block4: {
            if (this.content.isEmpty()) {
                return this.file;
            }
            PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)this.project);
            Document document = manager.getDocument(this.file);
            if (document == null) break block4;
            Document document2 = document;
            boolean bl = false;
            int offset = 0;
            offset = document2.getTextLength();
            this.file.acceptChildren((PsiElementVisitor)new IgnoreVisitor(this){
                final /* synthetic */ AppendFileCommandAction this$0;
                {
                    this.this$0 = $receiver;
                }

                public void visitEntry(@NotNull IgnoreEntry entry) {
                    Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                    VirtualFile virtualFile = AppendFileCommandAction.access$getFile$p(this.this$0).getVirtualFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                    VirtualFile moduleDir = Utils.INSTANCE.getModuleRootForFile(virtualFile, AppendFileCommandAction.access$getProject$p(this.this$0));
                    if (AppendFileCommandAction.access$getContent$p(this.this$0).contains(entry.getText()) && moduleDir != null) {
                        Project project = AppendFileCommandAction.access$getProject$p(this.this$0);
                        Object[] objectArray = new Object[]{entry.getText()};
                        String string = IgnoreBundle.INSTANCE.message("action.appendFile.entryExists", objectArray);
                        objectArray = new Object[1];
                        VirtualFile virtualFile2 = AppendFileCommandAction.access$getFile$p(this.this$0).getVirtualFile();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
                        objectArray[0] = Utils.INSTANCE.getRelativePath(moduleDir, virtualFile2);
                        Notify.show$default(Notify.INSTANCE, project, string, IgnoreBundle.INSTANCE.message("action.appendFile.entryExists.in", objectArray), NotificationType.WARNING, null, 16, null);
                        AppendFileCommandAction.access$getContent$p(this.this$0).remove(entry.getText());
                    }
                }
            });
            if (this.settings.getInsertAtCursor()) {
                Editor[] editorArray = EditorFactory.getInstance().getEditors(document2);
                Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"getEditors(...)");
                Editor editor = (Editor)ArraysKt.firstOrNull((Object[])editorArray);
                if (editor != null) {
                    Editor editor2 = editor;
                    boolean bl2 = false;
                    VisualPosition visualPosition = editor2.getSelectionModel().getSelectionStartPosition();
                    if (visualPosition != null) {
                        VisualPosition position = visualPosition;
                        boolean bl3 = false;
                        offset = document2.getLineStartOffset(position.line);
                    }
                }
            }
            String string = document2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String generatedContent = ContentGenerator.Companion.generate(string, this.content, this.ignoreDuplicates, this.ignoreComments);
            document2.insertString(offset, (CharSequence)generatedContent);
            manager.commitDocument(document2);
        }
        return this.file;
    }

    public static final /* synthetic */ PsiFile access$getFile$p(AppendFileCommandAction $this) {
        return $this.file;
    }

    public static final /* synthetic */ Project access$getProject$p(AppendFileCommandAction $this) {
        return $this.project;
    }

    public static final /* synthetic */ Set access$getContent$p(AppendFileCommandAction $this) {
        return $this.content;
    }
}

