/*
 * Decompiled with CFR 0.152.
 */
package mobi.hsz.idea.gitignore.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mobi.hsz.idea.gitignore.IgnoreBundle;
import mobi.hsz.idea.gitignore.file.type.IgnoreFileType;
import mobi.hsz.idea.gitignore.lang.IgnoreLanguage;
import mobi.hsz.idea.gitignore.psi.IgnoreFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\u00020\n2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\rJ\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bJ\u001d\u0010\u0014\u001a\t\u0018\u00010\u0015\u00a2\u0006\u0002\b\u00162\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0012J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\r2\u0006\u0010\u001c\u001a\u00020\u0019J\u0016\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0012J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0015\u00a8\u0006!"}, d2={"Lmobi/hsz/idea/gitignore/util/Utils;", "", "()V", "createPreviewEditor", "Lcom/intellij/openapi/editor/Editor;", "document", "Lcom/intellij/openapi/editor/Document;", "project", "Lcom/intellij/openapi/project/Project;", "isViewer", "", "equalLists", "l1", "", "l2", "getModuleForFile", "Lcom/intellij/openapi/module/Module;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getModuleRootForFile", "getPsiFile", "Lcom/intellij/psi/PsiFile;", "Lorg/jetbrains/annotations/Nullable;", "virtualFile", "getRelativePath", "", "directory", "getWords", "filter", "isInProject", "isVcsDirectory", "openFile", "", "idea-gitignore"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\nmobi/hsz/idea/gitignore/util/Utils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,158:1\n1#2:159\n766#3:160\n857#3,2:161\n1109#4,2:163\n*S KotlinDebug\n*F\n+ 1 Utils.kt\nmobi/hsz/idea/gitignore/util/Utils\n*L\n86#1:160\n86#1:161,2\n113#1:163,2\n*E\n"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    @Nullable
    public final String getRelativePath(@NotNull VirtualFile directory, @NotNull VirtualFile file) {
        String string;
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string2 = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)directory, (char)'/');
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            Character c = Character.valueOf('/');
            char c2 = c.charValue();
            String string3 = it;
            boolean bl2 = false;
            Object object = Boolean.valueOf(file.isDirectory()) != false ? c : null;
            if (object == null) {
                object = "";
            }
            string = string3 + object;
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public final PsiFile getPsiFile(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        PsiManager $this$getPsiFile_u24lambda_u243 = PsiManager.getInstance((Project)project);
        boolean bl = false;
        PsiFile psiFile = $this$getPsiFile_u24lambda_u243.findFile(virtualFile);
        if (psiFile == null) {
            IgnoreFile ignoreFile;
            FileViewProvider fileViewProvider = $this$getPsiFile_u24lambda_u243.findViewProvider(virtualFile);
            if (fileViewProvider != null) {
                FileViewProvider it = fileViewProvider;
                boolean bl2 = false;
                IgnoreLanguage ignoreLanguage = IgnoreBundle.INSTANCE.obtainLanguage(virtualFile);
                if (ignoreLanguage != null) {
                    Intrinsics.checkNotNull((Object)it);
                    ignoreFile = ignoreLanguage.createFile(it);
                } else {
                    ignoreFile = null;
                }
            } else {
                ignoreFile = null;
            }
            psiFile = (PsiFile)ignoreFile;
        }
        return psiFile;
    }

    public final void openFile(@NotNull Project project, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileEditorManager.getInstance((Project)project).openFile(file.getVirtualFile(), true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isVcsDirectory(@NotNull VirtualFile directory) {
        Object t;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        if (!directory.isDirectory()) {
            return false;
        }
        Iterable iterable = IgnoreBundle.INSTANCE.getVCS_LANGUAGES();
        Iterator iterator = iterable.iterator();
        do {
            if (!iterator.hasNext()) return false;
            t = iterator.next();
            IgnoreLanguage it = (IgnoreLanguage)((Object)t);
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)directory.getName(), (Object)it.getVcsDirectory())) {
                Boolean bl3 = IgnoreBundle.INSTANCE.getENABLED_LANGUAGES().get(it.getFileType());
                if (bl3 != null ? bl3 : false) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        Object v2 = t;
        if (v2 == null) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getWords(@NotNull String filter) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        String string = filter.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String[] stringArray = new String[]{"\\W+"};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String p0 = (String)element$iv$iv;
            boolean bl = false;
            if (!(((CharSequence)p0).length() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final boolean equalLists(@NotNull List<?> l1, @NotNull List<?> l2) {
        Intrinsics.checkNotNullParameter(l1, (String)"l1");
        Intrinsics.checkNotNullParameter(l2, (String)"l2");
        return l1.size() == l2.size() && ((Collection)l1).containsAll((Collection)l2) && ((Collection)l2).containsAll((Collection)l1);
    }

    @Nullable
    public final Module getModuleForFile(@NotNull VirtualFile file, @NotNull Project project) {
        Module module;
        block1: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Module[] moduleArray = ModuleManager.Companion.getInstance(project).getModules();
            int n = moduleArray.length;
            for (int i = 0; i < n; ++i) {
                Module module2;
                Module it = module2 = moduleArray[i];
                boolean bl = false;
                if (!it.getModuleContentScope().contains(file)) continue;
                module = module2;
                break block1;
            }
            module = null;
        }
        return module;
    }

    @Nullable
    public final VirtualFile getModuleRootForFile(@NotNull VirtualFile file, @NotNull Project project) {
        VirtualFile virtualFile;
        block3: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Module module = this.getModuleForFile(file, project);
            if (module == null || ModuleType.isInternal((Module)module)) {
                virtualFile = ProjectUtil.guessProjectDir((Project)project);
            } else {
                VirtualFile[] roots;
                VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module).getContentRoots();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
                VirtualFile[] $this$first$iv = roots = virtualFileArray;
                boolean $i$f$first = false;
                int n = $this$first$iv.length;
                for (int i = 0; i < n; ++i) {
                    VirtualFile element$iv;
                    VirtualFile it = element$iv = $this$first$iv[i];
                    boolean bl = false;
                    if (!it.isDirectory()) continue;
                    virtualFile = element$iv;
                    break block3;
                }
                throw new NoSuchElementException("Array contains no element matching the predicate.");
            }
        }
        return virtualFile;
    }

    public final boolean isInProject(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.getModuleForFile(file, project) != null || StringUtil.startsWith((CharSequence)file.getUrl(), (CharSequence)"temp://");
    }

    @NotNull
    public final Editor createPreviewEditor(@NotNull Document document, @Nullable Project project, boolean isViewer) {
        EditorSettings editorSettings;
        Editor editor;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Editor $this$createPreviewEditor_u24lambda_u248 = editor = EditorFactory.getInstance().createEditor(document, project, (FileType)IgnoreFileType.Companion.getINSTANCE(), isViewer);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$createPreviewEditor_u24lambda_u248, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        ((EditorEx)$this$createPreviewEditor_u24lambda_u248).setCaretEnabled(!isViewer);
        EditorSettings $this$createPreviewEditor_u24lambda_u248_u24lambda_u247 = editorSettings = ((EditorEx)$this$createPreviewEditor_u24lambda_u248).getSettings();
        boolean bl2 = false;
        $this$createPreviewEditor_u24lambda_u248_u24lambda_u247.setLineNumbersShown(false);
        $this$createPreviewEditor_u24lambda_u248_u24lambda_u247.setAdditionalColumnsCount(1);
        $this$createPreviewEditor_u24lambda_u248_u24lambda_u247.setAdditionalLinesCount(0);
        $this$createPreviewEditor_u24lambda_u248_u24lambda_u247.setRightMarginShown(false);
        $this$createPreviewEditor_u24lambda_u248_u24lambda_u247.setFoldingOutlineShown(false);
        $this$createPreviewEditor_u24lambda_u248_u24lambda_u247.setLineMarkerAreaShown(false);
        $this$createPreviewEditor_u24lambda_u248_u24lambda_u247.setIndentGuidesShown(false);
        $this$createPreviewEditor_u24lambda_u248_u24lambda_u247.setVirtualSpace(false);
        $this$createPreviewEditor_u24lambda_u248_u24lambda_u247.setWheelFontChangeEnabled(false);
        ((EditorEx)$this$createPreviewEditor_u24lambda_u248).getColorsScheme().setColor(EditorColors.CARET_ROW_COLOR, null);
        Editor editor2 = editor;
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"apply(...)");
        return editor2;
    }
}

