/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.actions.message;

import com.intellij.icons.AllIcons;
import com.intellij.ml.llm.core.chat.actions.AIAssistantChatActionsUtil;
import com.intellij.ml.llm.core.chat.messages.ChatMessage;
import com.intellij.ml.llm.core.chat.messages.ChatMessageAuthor;
import com.intellij.ml.llm.core.chat.messages.CompletedState;
import com.intellij.ml.llm.core.chat.messages.ErrorState;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.core.chat.ui.chat.AIAssistantChatMessageView;
import com.intellij.ml.llm.core.statistics.fus.AIAssistantChatEventLogger;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.io.StringWriter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/core/chat/actions/message/AIAssistantCopyMessageAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nAIAssistantCopyMessageAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIAssistantCopyMessageAction.kt\ncom/intellij/ml/llm/core/chat/actions/message/AIAssistantCopyMessageAction\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,55:1\n24#2:56\n24#2:57\n*S KotlinDebug\n*F\n+ 1 AIAssistantCopyMessageAction.kt\ncom/intellij/ml/llm/core/chat/actions/message/AIAssistantCopyMessageAction\n*L\n23#1:56\n39#1:57\n*E\n"})
public final class AIAssistantCopyMessageAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataKey<AIAssistantChatMessageView> dataKey = AIAssistantChatMessageView.Companion.getAIAssistantChatMessageViewKey();
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        AIAssistantChatMessageView aIAssistantChatMessageView = (AIAssistantChatMessageView)dataKey.getData(dataContext);
        if (aIAssistantChatMessageView == null) {
            AIAssistantCopyMessageAction $this$actionPerformed_u24lambda_u240 = this;
            boolean bl = false;
            AIAssistantCopyMessageAction $this$thisLogger$iv = $this$actionPerformed_u24lambda_u240;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(AIAssistantCopyMessageAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("No message view is found in the data context");
            return;
        }
        AIAssistantChatMessageView messageView = aIAssistantChatMessageView;
        DataContext $this$actionPerformed_u24lambda_u241 = e.getDataContext();
        boolean bl = false;
        Project project = (Project)$this$actionPerformed_u24lambda_u241.getData(CommonDataKeys.PROJECT);
        ChatSession chatSession2 = (ChatSession)$this$actionPerformed_u24lambda_u241.getData(ChatSession.Companion.getCurrentSession());
        if (chatSession2 != null) {
            ChatSession session = chatSession2;
            ChatMessage chatMessage = (ChatMessage)$this$actionPerformed_u24lambda_u241.getData(ChatMessage.Companion.getKey());
            if (chatMessage != null) {
                ChatMessage message = chatMessage;
                AIAssistantChatEventLogger.logTextCopiedEvent(project, session, message);
            }
        }
        try {
            CopyPasteManager.getInstance().setContents(AIAssistantChatActionsUtil.INSTANCE.createHtmlMarkdownTransferable((Function2<? super StringWriter, ? super StringWriter, Unit>)((Function2)(arg_0, arg_1) -> AIAssistantCopyMessageAction.actionPerformed$lambda$2(messageView, arg_0, arg_1))));
        }
        catch (Exception exception) {
            AIAssistantCopyMessageAction $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(AIAssistantCopyMessageAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn((Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void update(@NotNull AnActionEvent e) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        DataKey<AIAssistantChatMessageView> dataKey = AIAssistantChatMessageView.Companion.getAIAssistantChatMessageViewKey();
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        AIAssistantChatMessageView messageView = (AIAssistantChatMessageView)dataKey.getData(dataContext);
        Presentation presentation = e.getPresentation();
        Object object = messageView;
        if (object != null && (object = ((AIAssistantChatMessageView)object).getChatMessage()) != null) {
            void it;
            Object object2 = object;
            Presentation presentation2 = presentation;
            boolean bl2 = false;
            boolean bl3 = it.getAuthor() == ChatMessageAuthor.Assistant && it.getState() instanceof CompletedState && !(it.getState() instanceof ErrorState);
            presentation = presentation2;
            bl = bl3;
        } else {
            bl = false;
        }
        presentation.setEnabledAndVisible(bl);
        e.getPresentation().setIcon(AllIcons.Actions.Copy);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private static final Unit actionPerformed$lambda$2(AIAssistantChatMessageView $messageView, StringWriter md, StringWriter html) {
        Intrinsics.checkNotNullParameter((Object)md, (String)"md");
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        $messageView.writeContent(md, html);
        return Unit.INSTANCE;
    }
}

