/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.attachments;

import com.intellij.lang.Language;
import com.intellij.ml.llm.context.ContextEntitySource;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.attachments.VisibleChatAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.CurrentFileContextAttachment;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B?\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/core/chat/attachments/CurrentFileChatAttachment;", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "Lcom/intellij/ml/llm/core/chat/attachments/VisibleChatAttachment;", "project", "Lcom/intellij/openapi/project/Project;", "currentFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "text", "Lcom/intellij/ml/llm/privacy/PSString;", "language", "Lcom/intellij/lang/Language;", "source", "Lcom/intellij/ml/llm/context/ContextEntitySource;", "kind", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment$Kind;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/lang/Language;Lcom/intellij/ml/llm/context/ContextEntitySource;Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment$Kind;)V", "toContextAttachment", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachment;", "intellij.ml.llm.chat"})
public final class CurrentFileChatAttachment
extends ChatAttachment
implements VisibleChatAttachment {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile currentFile;

    public CurrentFileChatAttachment(@NotNull Project project, @NotNull VirtualFile currentFile, @NotNull PSString text2, @Nullable Language language, @NotNull ContextEntitySource source2, @Nullable ChatAttachment.Kind kind) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)currentFile, (String)"currentFile");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        PSString pSString = ConstantsKt.getPrivacyConst((String)"Information about open file in the editor");
        ChatAttachment.Kind kind2 = kind;
        if (kind2 == null) {
            kind2 = ChatAttachment.Kind.Visible;
        }
        super(pSString, text2, kind2, (VirtualFilePointer)new LightFilePointer(currentFile), source2, null, language, 32, null);
        this.project = project;
        this.currentFile = currentFile;
    }

    public /* synthetic */ CurrentFileChatAttachment(Project project, VirtualFile virtualFile2, PSString pSString, Language language, ContextEntitySource contextEntitySource, ChatAttachment.Kind kind, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            language = null;
        }
        if ((n & 0x20) != 0) {
            kind = null;
        }
        this(project, virtualFile2, pSString, language, contextEntitySource, kind);
    }

    @Override
    @NotNull
    public ContextAttachment toContextAttachment() {
        return new CurrentFileContextAttachment(this.project, this.currentFile, this.getSource());
    }
}

