/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.attachments;

import com.intellij.ml.llm.context.ContextEntityPrivacy;
import com.intellij.ml.llm.context.ContextEntitySource;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentBase;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010$\u001a\u00020%H\u0096@\u00a2\u0006\u0002\u0010&J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0014\u0010\u0019\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012R\u0014\u0010\u001b\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0012R\u001c\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0016R\u0014\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006+"}, d2={"Lcom/intellij/ml/llm/core/chat/attachments/FileProblemsContextAttachment;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentBase;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "text", "Lcom/intellij/ml/llm/privacy/PSString;", "attachedBy", "Lcom/intellij/ml/llm/context/ContextEntitySource;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/context/ContextEntitySource;)V", "getText", "()Lcom/intellij/ml/llm/privacy/PSString;", "getAttachedBy", "()Lcom/intellij/ml/llm/context/ContextEntitySource;", "attachmentName", "id", "", "getId", "()Ljava/lang/String;", "name", "Lcom/intellij/openapi/observable/properties/ObservableProperty;", "getName", "()Lcom/intellij/openapi/observable/properties/ObservableProperty;", "hint", "getHint", "tooltipText", "getTooltipText", "popupPresentationText", "getPopupPresentationText", "icon", "Ljavax/swing/Icon;", "getIcon", "privacy", "Lcom/intellij/ml/llm/context/ContextEntityPrivacy;", "getPrivacy", "()Lcom/intellij/ml/llm/context/ContextEntityPrivacy;", "createChatAttachment", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "performAction", "", "isInMessage", "", "intellij.ml.llm.chat"})
public final class FileProblemsContextAttachment
extends ContextAttachmentBase {
    @NotNull
    private final PSString text;
    @NotNull
    private final ContextEntitySource attachedBy;
    @NotNull
    private final PSString attachmentName;
    @NotNull
    private final String id;
    @NotNull
    private final ObservableProperty<String> name;
    @Nullable
    private final ObservableProperty<String> hint;
    @NotNull
    private final String tooltipText;
    @NotNull
    private final String popupPresentationText;
    @Nullable
    private final ObservableProperty<Icon> icon;
    @NotNull
    private final ContextEntityPrivacy privacy;

    public FileProblemsContextAttachment(@NotNull VirtualFile file, @NotNull PSString text2, @NotNull ContextEntitySource attachedBy) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)attachedBy, (String)"attachedBy");
        this.text = text2;
        this.attachedBy = attachedBy;
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{ExtensionsKtKt.getPrivacySafe((VirtualFile)file).getName()};
        this.attachmentName = ConstantsKt.getPrivacyConst((String)"%s problems").format(pSStringConvertibleArray);
        this.id = (String)this.attachmentName.unwrap();
        this.name = (ObservableProperty)new AtomicProperty((Object)this.getId());
        this.tooltipText = "";
        this.popupPresentationText = "";
        this.privacy = (ContextEntityPrivacy)new ContextEntityPrivacy.FileRelated(file);
    }

    @Override
    @NotNull
    public PSString getText() {
        return this.text;
    }

    @NotNull
    public ContextEntitySource getAttachedBy() {
        return this.attachedBy;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public ObservableProperty<String> getName() {
        return this.name;
    }

    @Override
    @Nullable
    public ObservableProperty<String> getHint() {
        return this.hint;
    }

    @Override
    @NotNull
    public String getTooltipText() {
        return this.tooltipText;
    }

    @Override
    @NotNull
    public String getPopupPresentationText() {
        return this.popupPresentationText;
    }

    @Override
    @Nullable
    public ObservableProperty<Icon> getIcon() {
        return this.icon;
    }

    @NotNull
    public ContextEntityPrivacy getPrivacy() {
        return this.privacy;
    }

    @Override
    @Nullable
    public Object createChatAttachment(@NotNull Continuation<? super ChatAttachment> $completion) {
        return new ChatAttachment(this.attachmentName, this.getText(), ChatAttachment.Kind.Visible, null, null, null, null, 120, null);
    }

    @Override
    public void performAction(boolean isInMessage) {
    }
}

