/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.context;

import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.attachments.VisibleChatAttachment;
import com.intellij.ml.llm.core.chat.context.ContextAttachmentFileWrapper;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.FileContextAttachment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Deprecated(message="File attachments should always include path if possible")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/core/chat/context/ChatAttachmentWithFilePathWrapper;", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "Lcom/intellij/ml/llm/core/chat/attachments/VisibleChatAttachment;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "chatAttachment", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getChatAttachment", "()Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "toContextAttachment", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachment;", "intellij.ml.llm.chat"})
public final class ChatAttachmentWithFilePathWrapper
extends ChatAttachment
implements VisibleChatAttachment {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final ChatAttachment chatAttachment;

    public ChatAttachmentWithFilePathWrapper(@NotNull Project project, @NotNull VirtualFile file, @NotNull ChatAttachment chatAttachment) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)chatAttachment, (String)"chatAttachment");
        super(chatAttachment.getName(), chatAttachment.getText(), chatAttachment.getKind(), chatAttachment.getVirtualFilePointer(), chatAttachment.getSource(), chatAttachment.getRawText(), chatAttachment.getLanguage());
        this.project = project;
        this.file = file;
        this.chatAttachment = chatAttachment;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public final ChatAttachment getChatAttachment() {
        return this.chatAttachment;
    }

    @Override
    @NotNull
    public ContextAttachment toContextAttachment() {
        VirtualFilePointer virtualFilePointer = this.getVirtualFilePointer();
        if (virtualFilePointer == null || (virtualFilePointer = virtualFilePointer.getFile()) == null) {
            virtualFilePointer = this.file;
        }
        VirtualFilePointer file = virtualFilePointer;
        FileContextAttachment attachment = new FileContextAttachment(this.project, (VirtualFile)file, this.getSource(), null, 8, null);
        return new ContextAttachmentFileWrapper(this.project, attachment);
    }
}

