/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.context.renderer;

import com.intellij.ml.llm.context.RetrievalSession;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.attachments.CurrentFileChatAttachment;
import com.intellij.ml.llm.core.chat.attachments.TargetElementCodeChatAttachment;
import com.intellij.ml.llm.core.chat.context.ContextItemRenderer;
import com.intellij.ml.llm.core.chat.context.renderer.AIAssistantChatAttachmentRenderer;
import com.intellij.ml.llm.core.chat.context.renderer.ChatAttachmentRenderBuilder;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u001e\u0010\u0011\u001a\u00020\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/core/chat/context/renderer/DefaultChatAttachmentRenderer;", "Lcom/intellij/ml/llm/core/chat/context/renderer/AIAssistantChatAttachmentRenderer;", "<init>", "()V", "getRegistryValue", "", "getBuilder", "Lcom/intellij/ml/llm/core/chat/context/renderer/ChatAttachmentRenderBuilder;", "renderAll", "Lcom/intellij/ml/llm/privacy/PSString;", "retrievalSession", "Lcom/intellij/ml/llm/context/RetrievalSession;", "attachments", "", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "render", "attachment", "getAttachmentsPS", "numTargetElementCodeChatAttachments", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nDefaultChatAttachmentRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultChatAttachmentRenderer.kt\ncom/intellij/ml/llm/core/chat/context/renderer/DefaultChatAttachmentRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n808#2,11:55\n808#2,11:66\n*S KotlinDebug\n*F\n+ 1 DefaultChatAttachmentRenderer.kt\ncom/intellij/ml/llm/core/chat/context/renderer/DefaultChatAttachmentRenderer\n*L\n23#1:55,11\n24#1:66,11\n*E\n"})
public final class DefaultChatAttachmentRenderer
implements AIAssistantChatAttachmentRenderer {
    @Override
    @NotNull
    public String getRegistryValue() {
        return "NONE";
    }

    @Override
    @NotNull
    public ChatAttachmentRenderBuilder getBuilder() {
        throw new IllegalStateException("Default renderer should not call getBuilder() method");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PSString renderAll(@NotNull RetrievalSession retrievalSession, @NotNull List<? extends ChatAttachment> attachments) {
        PSString pSString;
        PSString pSString2;
        PSString pSString3;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)retrievalSession, (String)"retrievalSession");
        Intrinsics.checkNotNullParameter(attachments, (String)"attachments");
        Iterable $this$filterIsInstance$iv = attachments;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof TargetElementCodeChatAttachment)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List targetElementAttachments = (List)destination$iv$iv;
        Iterable $this$filterIsInstance$iv2 = attachments;
        boolean $i$f$filterIsInstance2 = false;
        destination$iv$iv = $this$filterIsInstance$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof CurrentFileChatAttachment)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List currentFileAttachments = (List)destination$iv$iv2;
        List relatedItemsAttachments = CollectionsKt.minus((Iterable)CollectionsKt.minus((Iterable)attachments, (Iterable)targetElementAttachments), (Iterable)currentFileAttachments);
        PSString it = this.getAttachmentsPS(targetElementAttachments, retrievalSession);
        boolean bl = false;
        if (((CharSequence)it).length() > 0) {
            Object element$iv$iv;
            element$iv$iv = new PSStringConvertible[]{it};
            pSString3 = ConstantsKt.getPrivacyConst((String)"\nSelected code or element under caret in the editor:\n%s\n").format((PSStringConvertible[])element$iv$iv);
        } else {
            pSString3 = ConstantsKt.getEMPTY();
        }
        PSString targetElementAttachmentsPart = pSString3;
        PSString it2 = this.getAttachmentsPS(currentFileAttachments, retrievalSession);
        boolean bl2 = false;
        if (((CharSequence)it2).length() > 0) {
            Object element$iv$iv;
            element$iv$iv = new PSStringConvertible[]{it2};
            pSString2 = ConstantsKt.getPrivacyConst((String)"\nInformation about open file in the editor:\n%s\n").format(element$iv$iv);
        } else {
            pSString2 = ConstantsKt.getEMPTY();
        }
        PSString currentFileAttachmentsPart = pSString2;
        PSString it3 = this.getAttachmentsPS(relatedItemsAttachments, retrievalSession);
        boolean bl3 = false;
        if (((CharSequence)it3).length() > 0) {
            PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{it3};
            pSString = ConstantsKt.getPrivacyConst((String)"\nRelated information and code that may be helpful:\n%s\n").format(pSStringConvertibleArray);
        } else {
            pSString = ConstantsKt.getEMPTY();
        }
        PSString relatedItemsAttachmentsPart = pSString;
        return targetElementAttachmentsPart.plus(currentFileAttachmentsPart).plus(relatedItemsAttachmentsPart);
    }

    @Override
    @NotNull
    public PSString render(@NotNull RetrievalSession retrievalSession, @NotNull ChatAttachment attachment) {
        Intrinsics.checkNotNullParameter((Object)retrievalSession, (String)"retrievalSession");
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        PSString pSString = ContextItemRenderer.Companion.render(retrievalSession, attachment);
        if (pSString == null) {
            pSString = ConstantsKt.getEMPTY();
        }
        return pSString;
    }

    private final PSString getAttachmentsPS(List<? extends ChatAttachment> numTargetElementCodeChatAttachments, RetrievalSession retrievalSession) {
        PSString targetElementCodeChatAttachmentsPlaceholder = ConstantsKt.getPrivacyConst((String)"");
        for (ChatAttachment chatAttachment : numTargetElementCodeChatAttachments) {
            PSString rendered = this.render(retrievalSession, chatAttachment);
            if (Intrinsics.areEqual((Object)rendered, (Object)ConstantsKt.getEMPTY())) continue;
            targetElementCodeChatAttachmentsPlaceholder = targetElementCodeChatAttachmentsPlaceholder.plus(rendered.plus(ConstantsKt.getPrivacyConst((String)"\n")));
        }
        return targetElementCodeChatAttachmentsPlaceholder;
    }
}

