/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.context.renderer.xml;

import com.intellij.ml.llm.core.chat.context.renderer.ChatAttachmentRenderBuilder;
import com.intellij.ml.llm.core.chat.context.renderer.ChatAttachmentTagsRegistry;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.PSStringKt;
import com.intellij.ml.llm.privacy.PrivacySafe;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\t\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u000b2\u0017\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\n0\r\u00a2\u0006\u0002\b\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\b\u0010\u0011\u001a\u00020\u0006H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/core/chat/context/renderer/xml/ChatAttachmentXmlBuilder;", "Lcom/intellij/ml/llm/core/chat/context/renderer/ChatAttachmentRenderBuilder;", "<init>", "()V", "parts", "", "Lcom/intellij/ml/llm/privacy/PSString;", "indentLevel", "", "tag", "", "Lcom/intellij/ml/llm/core/chat/context/renderer/ChatAttachmentTagsRegistry;", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "text", "content", "build", "intellij.ml.llm.chat"})
public final class ChatAttachmentXmlBuilder
implements ChatAttachmentRenderBuilder {
    @NotNull
    private final List<PSString> parts = new ArrayList();
    private int indentLevel;

    @Override
    public void tag(@NotNull ChatAttachmentTagsRegistry tag, @NotNull Function1<? super ChatAttachmentRenderBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        PSString indent = ConstantsKt.getPrivacyConst((String)"  ").repeat(this.indentLevel);
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{tag.getTagName()};
        this.parts.add(indent.plus(ConstantsKt.getPrivacyConst((String)"<%s>").format(pSStringConvertibleArray)));
        int n = this.indentLevel;
        this.indentLevel = n + 1;
        block.invoke((Object)this);
        n = this.indentLevel;
        this.indentLevel = n + -1;
        PSStringConvertible[] pSStringConvertibleArray2 = new PSStringConvertible[]{tag.getTagName()};
        this.parts.add(indent.plus(ConstantsKt.getPrivacyConst((String)"</%s>").format(pSStringConvertibleArray2)));
    }

    @Override
    public void text(@NotNull PSString content2) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        if (this.indentLevel <= 0) {
            this.parts.add(content2);
        }
        PSString indent = ConstantsKt.getPrivacyConst((String)"  ").repeat(this.indentLevel);
        PSString indentedContent = PSStringKt.joinToString$default((Iterable)content2.lines(), (PrivacySafe)((PrivacySafe)ConstantsKt.getPrivacyConst((String)"\n")), null, null, (int)0, null, arg_0 -> ChatAttachmentXmlBuilder.text$lambda$0(indent, arg_0), (int)30, null);
        this.parts.add(indentedContent);
    }

    @Override
    @NotNull
    public PSString build() {
        return PSStringKt.joinToString$default((Iterable)this.parts, (PrivacySafe)((PrivacySafe)ConstantsKt.getPrivacyConst((String)"\n")), null, null, (int)0, null, (int)30, null);
    }

    private static final PrivacySafe text$lambda$0(PSString $indent, PSString line) {
        PrivacySafe privacySafe;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (((CharSequence)line.trim()).length() > 0) {
            PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{$indent, line};
            privacySafe = (PrivacySafe)ConstantsKt.getPrivacyConst((String)"%s%s").format(pSStringConvertibleArray);
        } else {
            privacySafe = (PrivacySafe)line;
        }
        return privacySafe;
    }
}

