/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.context.retrievers;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.ml.llm.context.ContextEntity;
import com.intellij.ml.llm.context.ContextRetrievalRequest;
import com.intellij.ml.llm.context.ContextRetriever;
import com.intellij.ml.llm.context.markers.PsiFileAwareContext;
import com.intellij.ml.llm.core.chat.attachments.FileProblemsContextAttachment;
import com.intellij.ml.llm.core.chat.context.retrievers.FileProblemsContextRequest;
import com.intellij.ml.llm.core.chat.context.retrievers.FileProblemsContextRetrieverKt;
import com.intellij.ml.llm.core.chat.context.retrievers.FileProblemsRetrieverSource;
import com.intellij.ml.llm.editor.AICaretAttributeKeys;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.PSStringKt;
import com.intellij.ml.llm.privacy.PrivacySafe;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\tH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/llm/core/chat/context/retrievers/FileProblemsContextRetriever;", "Lcom/intellij/ml/llm/context/ContextRetriever;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "supportedProblemSeverityTypes", "", "Lcom/intellij/lang/annotation/HighlightSeverity;", "kotlin.jvm.PlatformType", "isApplicable", "", "request", "Lcom/intellij/ml/llm/context/ContextRetrievalRequest;", "computeContextFlow", "Lkotlinx/coroutines/flow/Flow;", "Lcom/intellij/ml/llm/context/ContextEntity;", "getFileProblems", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "file", "Lcom/intellij/psi/PsiFile;", "toContextAttachment", "Lcom/intellij/ml/llm/core/chat/attachments/FileProblemsContextAttachment;", "problems", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nFileProblemsContextRetriever.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileProblemsContextRetriever.kt\ncom/intellij/ml/llm/core/chat/context/retrievers/FileProblemsContextRetriever\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n11546#2,9:110\n13472#2:119\n13473#2:121\n11555#2:122\n1#3:120\n774#4:123\n865#4,2:124\n*S KotlinDebug\n*F\n+ 1 FileProblemsContextRetriever.kt\ncom/intellij/ml/llm/core/chat/context/retrievers/FileProblemsContextRetriever\n*L\n52#1:110,9\n52#1:119\n52#1:121\n52#1:122\n52#1:120\n53#1:123\n53#1:124,2\n*E\n"})
public final class FileProblemsContextRetriever
implements ContextRetriever {
    @NotNull
    private final Project project;
    @NotNull
    private final List<HighlightSeverity> supportedProblemSeverityTypes;

    public FileProblemsContextRetriever(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.supportedProblemSeverityTypes = CollectionsKt.listOf((Object)HighlightSeverity.ERROR);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public boolean isApplicable(@NotNull ContextRetrievalRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!(request instanceof FileProblemsContextRequest)) {
            return false;
        }
        return ((PsiFileAwareContext)request).getPsiFile() != null;
    }

    @NotNull
    public Flow<ContextEntity> computeContextFlow(@NotNull ContextRetrievalRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!(request instanceof FileProblemsContextRequest)) {
            return FlowKt.emptyFlow();
        }
        PsiFile psiFile = ((PsiFileAwareContext)request).getPsiFile();
        if (psiFile == null) {
            return FlowKt.emptyFlow();
        }
        PsiFile file = psiFile;
        List<HighlightInfo> problems = this.getFileProblems(file);
        if (problems.isEmpty()) {
            return FlowKt.emptyFlow();
        }
        return FlowKt.flowOf((Object)this.toContextAttachment(file, problems));
    }

    /*
     * WARNING - void declaration
     */
    private final List<HighlightInfo> getFileProblems(PsiFile file) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        RangeHighlighter[] highlighters;
        RangeHighlighter[] rangeHighlighterArray = DocumentMarkupModel.forDocument((Document)file.getFileDocument(), (Project)this.project, (boolean)false).getAllHighlighters();
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterArray, (String)"getAllHighlighters(...)");
        RangeHighlighter[] $this$mapNotNull$iv = highlighters = rangeHighlighterArray;
        boolean $i$f$mapNotNull = false;
        RangeHighlighter[] rangeHighlighterArray2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            HighlightInfo it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            Object object = it.getErrorStripeTooltip();
            if ((object instanceof HighlightInfo ? (HighlightInfo)object : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CharSequence charSequence;
            HighlightInfo it = (HighlightInfo)element$iv$iv;
            boolean bl = false;
            if (!(this.supportedProblemSeverityTypes.contains(it.getSeverity()) && !Intrinsics.areEqual((Object)it.forcedTextAttributesKey, (Object)AICaretAttributeKeys.INLINE_PROMPT_ATTRS) && !((charSequence = (CharSequence)it.getDescription()) == null || StringsKt.isBlank((CharSequence)charSequence)))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final FileProblemsContextAttachment toContextAttachment(PsiFile file, List<? extends HighlightInfo> problems) {
        VirtualFile virtualFile2 = file.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
        PSString pSString = ExtensionsKtKt.getPrivacySafe((PsiNamedElement)((PsiNamedElement)file)).getName();
        if (pSString == null) {
            pSString = ConstantsKt.getPrivacyConst((String)"****");
        }
        return new FileProblemsContextAttachment(virtualFile2, FileProblemsContextRetriever.toContextAttachment$getProblemsSummary(problems, file, pSString), FileProblemsRetrieverSource.INSTANCE);
    }

    private static final PrivacySafe toContextAttachment$getProblemsSummary$lambda$2(PsiFile $file, HighlightInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Project project = $file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Document document = $file.getFileDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getFileDocument(...)");
        return (PrivacySafe)FileProblemsContextRetrieverKt.getProblemDescription(project, document, it);
    }

    private static final PSString toContextAttachment$getProblemsSummary(List<? extends HighlightInfo> $problems, PsiFile $file, PSString fileName) {
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{fileName, PSStringKt.joinToString$default((Iterable)$problems, (PrivacySafe)((PrivacySafe)ConstantsKt.getPrivacyConst((String)"----------\n")), null, null, (int)0, null, arg_0 -> FileProblemsContextRetriever.toContextAttachment$getProblemsSummary$lambda$2($file, arg_0), (int)30, null)};
        return ConstantsKt.getPrivacyConst((String)"\n%s file contains the following detected problems:\n%s\n").format(pSStringConvertibleArray);
    }
}

