/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.context.retrievers;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.ml.llm.core.chat.context.retrievers.FileProblemsContextRetriever;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.extensions.SharedExtensionsKtKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.DocumentUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u001a \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\"\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u001a\u001e\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"log", "Lcom/intellij/openapi/diagnostic/Logger;", "getProblemLines", "Lcom/intellij/ml/llm/privacy/PSString;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "problem", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "getLineRangeForOffsets", "Lcom/intellij/openapi/util/TextRange;", "startOffset", "", "endOffset", "getProblemDescription", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nFileProblemsContextRetriever.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileProblemsContextRetriever.kt\ncom/intellij/ml/llm/core/chat/context/retrievers/FileProblemsContextRetrieverKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,109:1\n14#2:110\n*S KotlinDebug\n*F\n+ 1 FileProblemsContextRetriever.kt\ncom/intellij/ml/llm/core/chat/context/retrievers/FileProblemsContextRetrieverKt\n*L\n26#1:110\n*E\n"})
public final class FileProblemsContextRetrieverKt {
    @NotNull
    private static final Logger log;

    private static final PSString getProblemLines(Project project, Document document, HighlightInfo problem) {
        TextRange textRange = FileProblemsContextRetrieverKt.getLineRangeForOffsets(document, problem.startOffset, problem.endOffset);
        if (textRange == null) {
            return ConstantsKt.getPrivacyConst((String)"");
        }
        TextRange lineRange = textRange;
        return ExtensionsKtKt.privacySafe((Document)document, (Project)project).getText().substring(lineRange.getStartOffset(), lineRange.getEndOffset());
    }

    private static final TextRange getLineRangeForOffsets(Document document, int startOffset, int endOffset) {
        int lineEnd;
        if (!DocumentUtil.isValidOffset((int)startOffset, (Document)document) || !DocumentUtil.isValidOffset((int)endOffset, (Document)document) || startOffset > endOffset) {
            log.warn("Invalid offsets provided: " + startOffset + "-" + endOffset + " for document length: " + document.getTextLength());
            return null;
        }
        int lineStart = document.getLineStartOffset(document.getLineNumber(startOffset));
        return lineStart <= (lineEnd = document.getLineEndOffset(document.getLineNumber(endOffset))) ? new TextRange(lineStart, lineEnd) : null;
    }

    @NotNull
    public static final PSString getProblemDescription(@NotNull Project project, @NotNull Document document, @NotNull HighlightInfo problem) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{SharedExtensionsKtKt.getPrivacySafe((HighlightInfo)problem).getDescription(), SharedExtensionsKtKt.getPrivacySafe((HighlightInfo)problem).getText(), FileProblemsContextRetrieverKt.getProblemLines(project, document, problem)};
        return ConstantsKt.getPrivacyConst((String)"\n%s\nat: %s\non the lines:\n%s\n").format(pSStringConvertibleArray);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FileProblemsContextRetriever.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }
}

