/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.messages;

import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.messages.ChatMessageAuthor;
import com.intellij.ml.llm.core.chat.messages.MarkdownChatMessage;
import com.intellij.ml.llm.core.chat.messages.impl.FunctionCall;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"dumpChatMessage", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "message", "Lcom/intellij/ml/llm/core/chat/messages/MarkdownChatMessage;", "headerLength", "", "intellij.ml.llm.chat"})
public final class ChatMessageDumpKt {
    public static final void dumpChatMessage(@NotNull StringBuilder builder, @NotNull MarkdownChatMessage message, int headerLength) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        StringBuilder $this$dumpChatMessage_u24lambda_u241 = builder;
        boolean bl = false;
        $this$dumpChatMessage_u24lambda_u241.append((Object)message.getAuthor());
        $this$dumpChatMessage_u24lambda_u241.append(": \n");
        $this$dumpChatMessage_u24lambda_u241.append((CharSequence)message.getDisplayText());
        if (!Intrinsics.areEqual((Object)message.getText(), (Object)message.getDisplayText())) {
            $this$dumpChatMessage_u24lambda_u241.append("\n");
            $this$dumpChatMessage_u24lambda_u241.append("Internal text:\n");
            $this$dumpChatMessage_u24lambda_u241.append((CharSequence)message.getText().plus(ConstantsKt.getNL()));
        }
        if (!((Collection)message.getAttachments()).isEmpty()) {
            $this$dumpChatMessage_u24lambda_u241.append('\n');
            $this$dumpChatMessage_u24lambda_u241.append("Attachments:\n");
            for (ChatAttachment attachment : message.getAttachments()) {
                $this$dumpChatMessage_u24lambda_u241.append("Attachment Name: " + attachment.getName() + "\n");
                $this$dumpChatMessage_u24lambda_u241.append("Attachments Kind: " + attachment.getKind() + "\n");
                $this$dumpChatMessage_u24lambda_u241.append("Attachments Source: " + Reflection.getOrCreateKotlinClass(attachment.getSource().getClass()).getSimpleName() + " / " + Reflection.getOrCreateKotlinClass(attachment.getClass()).getSimpleName() + "\n");
                $this$dumpChatMessage_u24lambda_u241.append("Attachments Text:\n");
                $this$dumpChatMessage_u24lambda_u241.append((CharSequence)attachment.getText());
                $this$dumpChatMessage_u24lambda_u241.append("\n");
            }
        }
        if (!((Collection)message.getFunctionCalls()).isEmpty()) {
            if (message.getAuthor() == ChatMessageAuthor.Assistant) {
                $this$dumpChatMessage_u24lambda_u241.append("\nBefore answering it did these function calls:\n");
            }
            for (FunctionCall functionCallResponse : message.getFunctionCalls()) {
                $this$dumpChatMessage_u24lambda_u241.append(StringsKt.trimIndent((String)("\n              functionName: " + functionCallResponse.getSmartChatEndpoint() + "\n              parameters: " + functionCallResponse.getFunctionArguments() + "\n              content: " + functionCallResponse.getResult().getResponse() + "\n            ")));
                $this$dumpChatMessage_u24lambda_u241.append("\n" + StringsKt.repeat((CharSequence)"-", (int)(headerLength - 1)) + "\n");
            }
        }
        String string = message.getAdditionalDumpText();
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            $this$dumpChatMessage_u24lambda_u241.append("\n\n" + it);
        }
        $this$dumpChatMessage_u24lambda_u241.append("\n\n");
    }
}

