/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.messages.impl;

import com.intellij.ml.llm.core.chat.messages.impl.FunctionCallError;
import com.intellij.ml.llm.core.chat.messages.impl.FunctionCallResult;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.rag.ContextPrivacyFilterChecker;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \f2\u00020\u0001:\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016B\u0019\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0001\u0006\u0017\u0018\u0019\u001a\u001b\u001c\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult;", "", "response", "Lcom/intellij/ml/llm/privacy/PSString;", "provider", "", "<init>", "(Lcom/intellij/ml/llm/privacy/PSString;Ljava/lang/String;)V", "getResponse", "()Lcom/intellij/ml/llm/privacy/PSString;", "getProvider", "()Ljava/lang/String;", "Companion", "ResponseMetadata", "EmptyResponseMetadata", "NonEmptyResponseMetadata", "ReturnedIgnoredFileException", "Success", "EmptyResult", "VirtualFileRelatedResult", "TrimmedResult", "IgnoredResult", "Error", "Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$EmptyResult;", "Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$Error;", "Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$IgnoredResult;", "Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$Success;", "Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$TrimmedResult;", "Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$VirtualFileRelatedResult;", "intellij.ml.llm.chat"})
public abstract class FunctionCallResult {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PSString response;
    @NotNull
    private final String provider;
    @NotNull
    public static final String DEFAULT_PROVIDER = "Other";

    private FunctionCallResult(PSString response, String provider) {
        this.response = response;
        this.provider = provider;
    }

    @NotNull
    public PSString getResponse() {
        return this.response;
    }

    @NotNull
    public String getProvider() {
        return this.provider;
    }

    public /* synthetic */ FunctionCallResult(PSString response, String provider, DefaultConstructorMarker $constructor_marker) {
        this(response, provider);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$Companion;", "", "<init>", "()V", "DEFAULT_PROVIDER", "", "intellij.ml.llm.chat"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$EmptyResponseMetadata;", "Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$ResponseMetadata;", "<init>", "()V", "intellij.ml.llm.chat"})
    public static final class EmptyResponseMetadata
    implements ResponseMetadata {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0007H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$EmptyResult;", "Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult;", "response", "Lcom/intellij/ml/llm/privacy/PSString;", "responseMetadata", "Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$ResponseMetadata;", "provider", "", "<init>", "(Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$ResponseMetadata;Ljava/lang/String;)V", "getResponse", "()Lcom/intellij/ml/llm/privacy/PSString;", "getResponseMetadata", "()Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$ResponseMetadata;", "getProvider", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.ml.llm.chat"})
    public static final class EmptyResult
    extends FunctionCallResult {
        @NotNull
        private final PSString response;
        @NotNull
        private final ResponseMetadata responseMetadata;
        @NotNull
        private final String provider;

        public EmptyResult(@NotNull PSString response, @NotNull ResponseMetadata responseMetadata, @NotNull String provider) {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            Intrinsics.checkNotNullParameter((Object)responseMetadata, (String)"responseMetadata");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            super(response, provider, null);
            this.response = response;
            this.responseMetadata = responseMetadata;
            this.provider = provider;
        }

        public /* synthetic */ EmptyResult(PSString pSString, ResponseMetadata responseMetadata, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                responseMetadata = new EmptyResponseMetadata();
            }
            if ((n & 4) != 0) {
                string = FunctionCallResult.DEFAULT_PROVIDER;
            }
            this(pSString, responseMetadata, string);
        }

        @Override
        @NotNull
        public PSString getResponse() {
            return this.response;
        }

        @NotNull
        public final ResponseMetadata getResponseMetadata() {
            return this.responseMetadata;
        }

        @Override
        @NotNull
        public String getProvider() {
            return this.provider;
        }

        @NotNull
        public final PSString component1() {
            return this.response;
        }

        @NotNull
        public final ResponseMetadata component2() {
            return this.responseMetadata;
        }

        @NotNull
        public final String component3() {
            return this.provider;
        }

        @NotNull
        public final EmptyResult copy(@NotNull PSString response, @NotNull ResponseMetadata responseMetadata, @NotNull String provider) {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            Intrinsics.checkNotNullParameter((Object)responseMetadata, (String)"responseMetadata");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            return new EmptyResult(response, responseMetadata, provider);
        }

        public static /* synthetic */ EmptyResult copy$default(EmptyResult emptyResult, PSString pSString, ResponseMetadata responseMetadata, String string, int n, Object object) {
            if ((n & 1) != 0) {
                pSString = emptyResult.response;
            }
            if ((n & 2) != 0) {
                responseMetadata = emptyResult.responseMetadata;
            }
            if ((n & 4) != 0) {
                string = emptyResult.provider;
            }
            return emptyResult.copy(pSString, responseMetadata, string);
        }

        @NotNull
        public String toString() {
            return "EmptyResult(response=" + this.response + ", responseMetadata=" + this.responseMetadata + ", provider=" + this.provider + ")";
        }

        public int hashCode() {
            int result2 = this.response.hashCode();
            result2 = result2 * 31 + this.responseMetadata.hashCode();
            result2 = result2 * 31 + this.provider.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EmptyResult)) {
                return false;
            }
            EmptyResult emptyResult = (EmptyResult)other;
            if (!Intrinsics.areEqual((Object)this.response, (Object)emptyResult.response)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.responseMetadata, (Object)emptyResult.responseMetadata)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.provider, (Object)emptyResult.provider);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$Error;", "Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult;", "error", "Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallError;", "provider", "", "<init>", "(Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallError;Ljava/lang/String;)V", "getError", "()Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallError;", "getProvider", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.ml.llm.chat"})
    public static final class Error
    extends FunctionCallResult {
        @NotNull
        private final FunctionCallError error;
        @NotNull
        private final String provider;

        public Error(@NotNull FunctionCallError error, @NotNull String provider) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            super(error.getText(), provider, null);
            this.error = error;
            this.provider = provider;
        }

        public /* synthetic */ Error(FunctionCallError functionCallError, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string = FunctionCallResult.DEFAULT_PROVIDER;
            }
            this(functionCallError, string);
        }

        @NotNull
        public final FunctionCallError getError() {
            return this.error;
        }

        @Override
        @NotNull
        public String getProvider() {
            return this.provider;
        }

        @NotNull
        public final FunctionCallError component1() {
            return this.error;
        }

        @NotNull
        public final String component2() {
            return this.provider;
        }

        @NotNull
        public final Error copy(@NotNull FunctionCallError error, @NotNull String provider) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            return new Error(error, provider);
        }

        public static /* synthetic */ Error copy$default(Error error, FunctionCallError functionCallError, String string, int n, Object object) {
            if ((n & 1) != 0) {
                functionCallError = error.error;
            }
            if ((n & 2) != 0) {
                string = error.provider;
            }
            return error.copy(functionCallError, string);
        }

        @NotNull
        public String toString() {
            return "Error(error=" + this.error + ", provider=" + this.provider + ")";
        }

        public int hashCode() {
            int result2 = this.error.hashCode();
            result2 = result2 * 31 + this.provider.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Error)) {
                return false;
            }
            Error error = (Error)other;
            if (!Intrinsics.areEqual((Object)this.error, (Object)error.error)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.provider, (Object)error.provider);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$IgnoredResult;", "Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult;", "provider", "", "<init>", "(Ljava/lang/String;)V", "getProvider", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.ml.llm.chat"})
    public static final class IgnoredResult
    extends FunctionCallResult {
        @NotNull
        private final String provider;

        public IgnoredResult(@NotNull String provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            super(ConstantsKt.getPrivacyConst((String)"Function call contains results that are under ignorance e.g in gitignore."), provider, null);
            this.provider = provider;
        }

        public /* synthetic */ IgnoredResult(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = FunctionCallResult.DEFAULT_PROVIDER;
            }
            this(string);
        }

        @Override
        @NotNull
        public String getProvider() {
            return this.provider;
        }

        @NotNull
        public final String component1() {
            return this.provider;
        }

        @NotNull
        public final IgnoredResult copy(@NotNull String provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            return new IgnoredResult(provider);
        }

        public static /* synthetic */ IgnoredResult copy$default(IgnoredResult ignoredResult, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = ignoredResult.provider;
            }
            return ignoredResult.copy(string);
        }

        @NotNull
        public String toString() {
            return "IgnoredResult(provider=" + this.provider + ")";
        }

        public int hashCode() {
            return this.provider.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IgnoredResult)) {
                return false;
            }
            IgnoredResult ignoredResult = (IgnoredResult)other;
            return Intrinsics.areEqual((Object)this.provider, (Object)ignoredResult.provider);
        }

        public IgnoredResult() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB3\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u0015\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0005H\u00c6\u0003J9\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0005H\u00c2\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$NonEmptyResponseMetadata;", "Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$ResponseMetadata;", "project", "Lcom/intellij/openapi/project/Project;", "files", "", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "elements", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;Ljava/util/Collection;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getFiles", "()Ljava/util/Collection;", "getElements", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "intellij.ml.llm.chat"})
    public static final class NonEmptyResponseMetadata
    implements ResponseMetadata {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Project project;
        @NotNull
        private final Collection<VirtualFilePointer> files;
        @NotNull
        private final Collection<SmartPsiElementPointer<PsiElement>> elements;

        private NonEmptyResponseMetadata(Project project, Collection<? extends VirtualFilePointer> files, Collection<? extends SmartPsiElementPointer<PsiElement>> elements) {
            this.project = project;
            this.files = files;
            this.elements = elements;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final Collection<VirtualFilePointer> getFiles() {
            return this.files;
        }

        @NotNull
        public final Collection<SmartPsiElementPointer<PsiElement>> getElements() {
            return this.elements;
        }

        @NotNull
        public final Project component1() {
            return this.project;
        }

        @NotNull
        public final Collection<VirtualFilePointer> component2() {
            return this.files;
        }

        @NotNull
        public final Collection<SmartPsiElementPointer<PsiElement>> component3() {
            return this.elements;
        }

        private final NonEmptyResponseMetadata copy(Project project, Collection<? extends VirtualFilePointer> files, Collection<? extends SmartPsiElementPointer<PsiElement>> elements) {
            return new NonEmptyResponseMetadata(project, files, elements);
        }

        static /* synthetic */ NonEmptyResponseMetadata copy$default(NonEmptyResponseMetadata nonEmptyResponseMetadata, Project project, Collection collection, Collection collection2, int n, Object object) {
            if ((n & 1) != 0) {
                project = nonEmptyResponseMetadata.project;
            }
            if ((n & 2) != 0) {
                collection = nonEmptyResponseMetadata.files;
            }
            if ((n & 4) != 0) {
                collection2 = nonEmptyResponseMetadata.elements;
            }
            return nonEmptyResponseMetadata.copy(project, collection, collection2);
        }

        @NotNull
        public String toString() {
            return "NonEmptyResponseMetadata(project=" + this.project + ", files=" + this.files + ", elements=" + this.elements + ")";
        }

        public int hashCode() {
            int result2 = this.project.hashCode();
            result2 = result2 * 31 + ((Object)this.files).hashCode();
            result2 = result2 * 31 + ((Object)this.elements).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NonEmptyResponseMetadata)) {
                return false;
            }
            NonEmptyResponseMetadata nonEmptyResponseMetadata = (NonEmptyResponseMetadata)other;
            if (!Intrinsics.areEqual((Object)this.project, (Object)nonEmptyResponseMetadata.project)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.files, nonEmptyResponseMetadata.files)) {
                return false;
            }
            return Intrinsics.areEqual(this.elements, nonEmptyResponseMetadata.elements);
        }

        public /* synthetic */ NonEmptyResponseMetadata(Project project, Collection files, Collection elements, DefaultConstructorMarker $constructor_marker) {
            this(project, files, elements);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\tH\u0086@\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$NonEmptyResponseMetadata$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$NonEmptyResponseMetadata;", "project", "Lcom/intellij/openapi/project/Project;", "files", "", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "elements", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;Ljava/util/Collection;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.ml.llm.chat"})
        @SourceDebugExtension(value={"SMAP\nFunctionCallsMessage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionCallsMessage.kt\ncom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$NonEmptyResponseMetadata$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,275:1\n1869#2,2:276\n1869#2,2:278\n*S KotlinDebug\n*F\n+ 1 FunctionCallsMessage.kt\ncom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$NonEmptyResponseMetadata$Companion\n*L\n90#1:276,2\n97#1:278,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object create(@NotNull Project project, @NotNull Collection<? extends VirtualFilePointer> files, @NotNull Collection<? extends SmartPsiElementPointer<PsiElement>> elements, @NotNull Continuation<? super NonEmptyResponseMetadata> $completion) {
                if (!($completion instanceof create.1)) ** GOTO lbl-1000
                var15_5 = $completion;
                if ((var15_5.label & -2147483648) != 0) {
                    var15_5.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        Object L$3;
                        Object L$4;
                        Object L$5;
                        Object L$6;
                        Object L$7;
                        Object L$8;
                        int I$0;
                        int I$1;
                        /* synthetic */ Object result;
                        final /* synthetic */ Companion this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.create(null, null, null, (Continuation<? super NonEmptyResponseMetadata>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var16_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        privacyFilterChecker = ContextPrivacyFilterChecker.Companion.getInstance(project);
                        $this$forEach$iv = files;
                        $i$f$forEach = 0;
                        var8_11 = $this$forEach$iv.iterator();
lbl16:
                        // 3 sources

                        while (var8_11.hasNext()) {
                            element$iv = var8_11.next();
                            virtualFilePointer = (VirtualFilePointer)element$iv;
                            $i$a$-forEach-FunctionCallResult$NonEmptyResponseMetadata$Companion$create$2 = 0;
                            $continuation.L$0 = project;
                            $continuation.L$1 = files;
                            $continuation.L$2 = elements;
                            $continuation.L$3 = privacyFilterChecker;
                            $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv);
                            $continuation.L$5 = var8_11;
                            $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                            $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)virtualFilePointer);
                            $continuation.L$8 = null;
                            $continuation.I$0 = $i$f$forEach;
                            $continuation.I$1 = $i$a$-forEach-FunctionCallResult$NonEmptyResponseMetadata$Companion$create$2;
                            $continuation.label = 1;
                            v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, create$lambda$1$lambda$0(com.intellij.openapi.vfs.pointers.VirtualFilePointer ), ()Lcom/intellij/openapi/vfs/VirtualFile;)((VirtualFilePointer)virtualFilePointer), (Continuation)$continuation);
                            if (v0 == var16_7) {
                                return var16_7;
                            }
                            ** GOTO lbl50
                        }
                        break;
                    }
                    case 1: {
                        $i$a$-forEach-FunctionCallResult$NonEmptyResponseMetadata$Companion$create$2 = $continuation.I$1;
                        $i$f$forEach = $continuation.I$0;
                        virtualFilePointer = (VirtualFilePointer)$continuation.L$7;
                        element$iv = $continuation.L$6;
                        var8_11 = (Iterator<T>)$continuation.L$5;
                        $this$forEach$iv = (Iterable)$continuation.L$4;
                        privacyFilterChecker = (ContextPrivacyFilterChecker)$continuation.L$3;
                        elements = (Collection)$continuation.L$2;
                        files = (Collection)$continuation.L$1;
                        project = (Project)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl50:
                        // 2 sources

                        if ((VirtualFile)v0 == null) ** GOTO lbl16
                        $continuation.L$0 = project;
                        $continuation.L$1 = files;
                        $continuation.L$2 = elements;
                        $continuation.L$3 = privacyFilterChecker;
                        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv);
                        $continuation.L$5 = var8_11;
                        $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                        $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)virtualFilePointer);
                        $continuation.L$8 = virtualFile;
                        $continuation.I$0 = $i$f$forEach;
                        $continuation.I$1 = $i$a$-forEach-FunctionCallResult$NonEmptyResponseMetadata$Companion$create$2;
                        $continuation.label = 2;
                        v1 = privacyFilterChecker.passesPrivacyFilters(virtualFile, (Continuation)$continuation);
                        if (v1 == var16_7) {
                            return var16_7;
                        }
                        ** GOTO lbl81
                    }
                    case 2: {
                        $i$a$-forEach-FunctionCallResult$NonEmptyResponseMetadata$Companion$create$2 = $continuation.I$1;
                        $i$f$forEach = $continuation.I$0;
                        virtualFile = (VirtualFile)$continuation.L$8;
                        virtualFilePointer = (VirtualFilePointer)$continuation.L$7;
                        element$iv = $continuation.L$6;
                        var8_11 = (Iterator)$continuation.L$5;
                        $this$forEach$iv = (Iterable)$continuation.L$4;
                        privacyFilterChecker = (ContextPrivacyFilterChecker)$continuation.L$3;
                        elements = (Collection)$continuation.L$2;
                        files = (Collection)$continuation.L$1;
                        project = (Project)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl81:
                        // 2 sources

                        if (isApplicableVirtualFile = ((Boolean)v1).booleanValue()) ** GOTO lbl16
                        throw new ReturnedIgnoredFileException("Function call returns ignored file: " + virtualFile + " located in `" + Reflection.getOrCreateKotlinClass(NonEmptyResponseMetadata.class).getSimpleName() + "#files`");
                    }
                }
                $this$forEach$iv = elements;
                $i$f$forEach = 0;
                var8_11 = $this$forEach$iv.iterator();
lbl86:
                // 3 sources

                while (var8_11.hasNext()) {
                    element$iv = var8_11.next();
                    smartPsiElementPointer = (SmartPsiElementPointer)element$iv;
                    $i$a$-forEach-FunctionCallResult$NonEmptyResponseMetadata$Companion$create$3 = 0;
                    $continuation.L$0 = project;
                    $continuation.L$1 = files;
                    $continuation.L$2 = elements;
                    $continuation.L$3 = privacyFilterChecker;
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv);
                    $continuation.L$5 = var8_11;
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                    $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)smartPsiElementPointer);
                    $continuation.L$8 = null;
                    $continuation.I$0 = $i$f$forEach;
                    $continuation.I$1 = $i$a$-forEach-FunctionCallResult$NonEmptyResponseMetadata$Companion$create$3;
                    $continuation.label = 3;
                    v2 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, create$lambda$3$lambda$2(com.intellij.psi.SmartPsiElementPointer ), ()Lcom/intellij/openapi/vfs/VirtualFile;)((SmartPsiElementPointer)smartPsiElementPointer), (Continuation)$continuation);
                    if (v2 == var16_7) {
                        return var16_7;
                    }
                    ** GOTO lbl120
                }
                {
                    break;
                    case 3: {
                        $i$a$-forEach-FunctionCallResult$NonEmptyResponseMetadata$Companion$create$3 = $continuation.I$1;
                        $i$f$forEach = $continuation.I$0;
                        smartPsiElementPointer = (SmartPsiElementPointer)$continuation.L$7;
                        element$iv = $continuation.L$6;
                        var8_11 = (Iterator)$continuation.L$5;
                        $this$forEach$iv = (Iterable)$continuation.L$4;
                        privacyFilterChecker = (ContextPrivacyFilterChecker)$continuation.L$3;
                        elements = (Collection)$continuation.L$2;
                        files = (Collection)$continuation.L$1;
                        project = (Project)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl120:
                        // 2 sources

                        if ((VirtualFile)v2 == null) ** GOTO lbl86
                        $continuation.L$0 = project;
                        $continuation.L$1 = files;
                        $continuation.L$2 = elements;
                        $continuation.L$3 = privacyFilterChecker;
                        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv);
                        $continuation.L$5 = var8_11;
                        $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                        $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)smartPsiElementPointer);
                        $continuation.L$8 = virtualFile;
                        $continuation.I$0 = $i$f$forEach;
                        $continuation.I$1 = $i$a$-forEach-FunctionCallResult$NonEmptyResponseMetadata$Companion$create$3;
                        $continuation.label = 4;
                        v3 = privacyFilterChecker.passesPrivacyFilters(virtualFile, (Continuation)$continuation);
                        if (v3 == var16_7) {
                            return var16_7;
                        }
                        ** GOTO lbl151
                    }
                    case 4: {
                        $i$a$-forEach-FunctionCallResult$NonEmptyResponseMetadata$Companion$create$3 = $continuation.I$1;
                        $i$f$forEach = $continuation.I$0;
                        virtualFile = (VirtualFile)$continuation.L$8;
                        smartPsiElementPointer = (SmartPsiElementPointer)$continuation.L$7;
                        element$iv = $continuation.L$6;
                        var8_11 = (Iterator)$continuation.L$5;
                        $this$forEach$iv = (Iterable)$continuation.L$4;
                        privacyFilterChecker = (ContextPrivacyFilterChecker)$continuation.L$3;
                        elements = (Collection)$continuation.L$2;
                        files = (Collection)$continuation.L$1;
                        project = (Project)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl151:
                        // 2 sources

                        if (isApplicableVirtualFile = ((Boolean)v3).booleanValue()) ** GOTO lbl86
                        throw new ReturnedIgnoredFileException("Function call returns ignored file: " + virtualFile + " located in `" + Reflection.getOrCreateKotlinClass(NonEmptyResponseMetadata.class).getSimpleName() + "#elements`");
                    }
                }
                return new NonEmptyResponseMetadata(project, files, elements, null);
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public static /* synthetic */ Object create$default(Companion companion, Project project, Collection collection, Collection collection2, Continuation continuation, int n, Object object) {
                if ((n & 2) != 0) {
                    collection = CollectionsKt.emptyList();
                }
                if ((n & 4) != 0) {
                    collection2 = CollectionsKt.emptyList();
                }
                return companion.create(project, collection, collection2, (Continuation<? super NonEmptyResponseMetadata>)continuation);
            }

            private static final VirtualFile create$lambda$1$lambda$0(VirtualFilePointer $virtualFilePointer) {
                return $virtualFilePointer.getFile();
            }

            private static final VirtualFile create$lambda$3$lambda$2(SmartPsiElementPointer $smartPsiElementPointer) {
                PsiElement psiElement = $smartPsiElementPointer.getElement();
                return psiElement != null && (psiElement = psiElement.getContainingFile()) != null ? psiElement.getVirtualFile() : null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001\u0082\u0001\u0002\u0002\u0003\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$ResponseMetadata;", "", "Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$EmptyResponseMetadata;", "Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$NonEmptyResponseMetadata;", "intellij.ml.llm.chat"})
    public static interface ResponseMetadata {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$ReturnedIgnoredFileException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "<init>", "(Ljava/lang/String;)V", "intellij.ml.llm.chat"})
    public static final class ReturnedIgnoredFileException
    extends Exception {
        public ReturnedIgnoredFileException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0007H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$Success;", "Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult;", "response", "Lcom/intellij/ml/llm/privacy/PSString;", "responseMetadata", "Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$ResponseMetadata;", "provider", "", "<init>", "(Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$ResponseMetadata;Ljava/lang/String;)V", "getResponse", "()Lcom/intellij/ml/llm/privacy/PSString;", "getResponseMetadata", "()Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$ResponseMetadata;", "getProvider", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.ml.llm.chat"})
    public static final class Success
    extends FunctionCallResult {
        @NotNull
        private final PSString response;
        @NotNull
        private final ResponseMetadata responseMetadata;
        @NotNull
        private final String provider;

        public Success(@NotNull PSString response, @NotNull ResponseMetadata responseMetadata, @NotNull String provider) {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            Intrinsics.checkNotNullParameter((Object)responseMetadata, (String)"responseMetadata");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            super(response, provider, null);
            this.response = response;
            this.responseMetadata = responseMetadata;
            this.provider = provider;
        }

        public /* synthetic */ Success(PSString pSString, ResponseMetadata responseMetadata, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                responseMetadata = new EmptyResponseMetadata();
            }
            if ((n & 4) != 0) {
                string = FunctionCallResult.DEFAULT_PROVIDER;
            }
            this(pSString, responseMetadata, string);
        }

        @Override
        @NotNull
        public PSString getResponse() {
            return this.response;
        }

        @NotNull
        public final ResponseMetadata getResponseMetadata() {
            return this.responseMetadata;
        }

        @Override
        @NotNull
        public String getProvider() {
            return this.provider;
        }

        @NotNull
        public final PSString component1() {
            return this.response;
        }

        @NotNull
        public final ResponseMetadata component2() {
            return this.responseMetadata;
        }

        @NotNull
        public final String component3() {
            return this.provider;
        }

        @NotNull
        public final Success copy(@NotNull PSString response, @NotNull ResponseMetadata responseMetadata, @NotNull String provider) {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            Intrinsics.checkNotNullParameter((Object)responseMetadata, (String)"responseMetadata");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            return new Success(response, responseMetadata, provider);
        }

        public static /* synthetic */ Success copy$default(Success success, PSString pSString, ResponseMetadata responseMetadata, String string, int n, Object object) {
            if ((n & 1) != 0) {
                pSString = success.response;
            }
            if ((n & 2) != 0) {
                responseMetadata = success.responseMetadata;
            }
            if ((n & 4) != 0) {
                string = success.provider;
            }
            return success.copy(pSString, responseMetadata, string);
        }

        @NotNull
        public String toString() {
            return "Success(response=" + this.response + ", responseMetadata=" + this.responseMetadata + ", provider=" + this.provider + ")";
        }

        public int hashCode() {
            int result2 = this.response.hashCode();
            result2 = result2 * 31 + this.responseMetadata.hashCode();
            result2 = result2 * 31 + this.provider.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Success)) {
                return false;
            }
            Success success = (Success)other;
            if (!Intrinsics.areEqual((Object)this.response, (Object)success.response)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.responseMetadata, (Object)success.responseMetadata)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.provider, (Object)success.provider);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$TrimmedResult;", "Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult;", "trimmedResponse", "Lcom/intellij/ml/llm/privacy/PSString;", "provider", "", "<init>", "(Lcom/intellij/ml/llm/privacy/PSString;Ljava/lang/String;)V", "getTrimmedResponse", "()Lcom/intellij/ml/llm/privacy/PSString;", "getProvider", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.ml.llm.chat"})
    public static final class TrimmedResult
    extends FunctionCallResult {
        @NotNull
        private final PSString trimmedResponse;
        @NotNull
        private final String provider;

        public TrimmedResult(@NotNull PSString trimmedResponse, @NotNull String provider) {
            Intrinsics.checkNotNullParameter((Object)trimmedResponse, (String)"trimmedResponse");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            super(ConstantsKt.getPrivacyConst((String)"Function call result is too big and it was truncated. \n").plus(trimmedResponse), provider, null);
            this.trimmedResponse = trimmedResponse;
            this.provider = provider;
        }

        @NotNull
        public final PSString getTrimmedResponse() {
            return this.trimmedResponse;
        }

        @Override
        @NotNull
        public String getProvider() {
            return this.provider;
        }

        @NotNull
        public final PSString component1() {
            return this.trimmedResponse;
        }

        @NotNull
        public final String component2() {
            return this.provider;
        }

        @NotNull
        public final TrimmedResult copy(@NotNull PSString trimmedResponse, @NotNull String provider) {
            Intrinsics.checkNotNullParameter((Object)trimmedResponse, (String)"trimmedResponse");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            return new TrimmedResult(trimmedResponse, provider);
        }

        public static /* synthetic */ TrimmedResult copy$default(TrimmedResult trimmedResult, PSString pSString, String string, int n, Object object) {
            if ((n & 1) != 0) {
                pSString = trimmedResult.trimmedResponse;
            }
            if ((n & 2) != 0) {
                string = trimmedResult.provider;
            }
            return trimmedResult.copy(pSString, string);
        }

        @NotNull
        public String toString() {
            return "TrimmedResult(trimmedResponse=" + this.trimmedResponse + ", provider=" + this.provider + ")";
        }

        public int hashCode() {
            int result2 = this.trimmedResponse.hashCode();
            result2 = result2 * 31 + this.provider.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TrimmedResult)) {
                return false;
            }
            TrimmedResult trimmedResult = (TrimmedResult)other;
            if (!Intrinsics.areEqual((Object)this.trimmedResponse, (Object)trimmedResult.trimmedResponse)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.provider, (Object)trimmedResult.provider);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003J1\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$VirtualFileRelatedResult;", "Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult;", "responseTemplate", "Lcom/intellij/ml/llm/privacy/PSString;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "responseMetadata", "Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$ResponseMetadata;", "provider", "", "<init>", "(Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$ResponseMetadata;Ljava/lang/String;)V", "getResponseTemplate", "()Lcom/intellij/ml/llm/privacy/PSString;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getResponseMetadata", "()Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCallResult$ResponseMetadata;", "getProvider", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.ml.llm.chat"})
    public static final class VirtualFileRelatedResult
    extends FunctionCallResult {
        @NotNull
        private final PSString responseTemplate;
        @NotNull
        private final VirtualFile virtualFile;
        @NotNull
        private final ResponseMetadata responseMetadata;
        @NotNull
        private final String provider;

        public VirtualFileRelatedResult(@NotNull PSString responseTemplate, @NotNull VirtualFile virtualFile2, @NotNull ResponseMetadata responseMetadata, @NotNull String provider) {
            Intrinsics.checkNotNullParameter((Object)responseTemplate, (String)"responseTemplate");
            Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
            Intrinsics.checkNotNullParameter((Object)responseMetadata, (String)"responseMetadata");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            super(ConstantsKt.getPrivacyConst((String)"Unsupported field, the FunctionCall#trimResponseIfNeeded post-processor has to be called on this class first."), provider, null);
            this.responseTemplate = responseTemplate;
            this.virtualFile = virtualFile2;
            this.responseMetadata = responseMetadata;
            this.provider = provider;
        }

        public /* synthetic */ VirtualFileRelatedResult(PSString pSString, VirtualFile virtualFile2, ResponseMetadata responseMetadata, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                responseMetadata = new EmptyResponseMetadata();
            }
            this(pSString, virtualFile2, responseMetadata, string);
        }

        @NotNull
        public final PSString getResponseTemplate() {
            return this.responseTemplate;
        }

        @NotNull
        public final VirtualFile getVirtualFile() {
            return this.virtualFile;
        }

        @NotNull
        public final ResponseMetadata getResponseMetadata() {
            return this.responseMetadata;
        }

        @Override
        @NotNull
        public String getProvider() {
            return this.provider;
        }

        @NotNull
        public final PSString component1() {
            return this.responseTemplate;
        }

        @NotNull
        public final VirtualFile component2() {
            return this.virtualFile;
        }

        @NotNull
        public final ResponseMetadata component3() {
            return this.responseMetadata;
        }

        @NotNull
        public final String component4() {
            return this.provider;
        }

        @NotNull
        public final VirtualFileRelatedResult copy(@NotNull PSString responseTemplate, @NotNull VirtualFile virtualFile2, @NotNull ResponseMetadata responseMetadata, @NotNull String provider) {
            Intrinsics.checkNotNullParameter((Object)responseTemplate, (String)"responseTemplate");
            Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
            Intrinsics.checkNotNullParameter((Object)responseMetadata, (String)"responseMetadata");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            return new VirtualFileRelatedResult(responseTemplate, virtualFile2, responseMetadata, provider);
        }

        public static /* synthetic */ VirtualFileRelatedResult copy$default(VirtualFileRelatedResult virtualFileRelatedResult, PSString pSString, VirtualFile virtualFile2, ResponseMetadata responseMetadata, String string, int n, Object object) {
            if ((n & 1) != 0) {
                pSString = virtualFileRelatedResult.responseTemplate;
            }
            if ((n & 2) != 0) {
                virtualFile2 = virtualFileRelatedResult.virtualFile;
            }
            if ((n & 4) != 0) {
                responseMetadata = virtualFileRelatedResult.responseMetadata;
            }
            if ((n & 8) != 0) {
                string = virtualFileRelatedResult.provider;
            }
            return virtualFileRelatedResult.copy(pSString, virtualFile2, responseMetadata, string);
        }

        @NotNull
        public String toString() {
            return "VirtualFileRelatedResult(responseTemplate=" + this.responseTemplate + ", virtualFile=" + this.virtualFile + ", responseMetadata=" + this.responseMetadata + ", provider=" + this.provider + ")";
        }

        public int hashCode() {
            int result2 = this.responseTemplate.hashCode();
            result2 = result2 * 31 + this.virtualFile.hashCode();
            result2 = result2 * 31 + this.responseMetadata.hashCode();
            result2 = result2 * 31 + this.provider.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VirtualFileRelatedResult)) {
                return false;
            }
            VirtualFileRelatedResult virtualFileRelatedResult = (VirtualFileRelatedResult)other;
            if (!Intrinsics.areEqual((Object)this.responseTemplate, (Object)virtualFileRelatedResult.responseTemplate)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.virtualFile, (Object)virtualFileRelatedResult.virtualFile)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.responseMetadata, (Object)virtualFileRelatedResult.responseMetadata)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.provider, (Object)virtualFileRelatedResult.provider);
        }
    }
}

