/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.promptLibrary.entryPoints;

import com.intellij.lang.Language;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.chat.context.ChatContextItem;
import com.intellij.ml.llm.core.chat.promptLibrary.entryPoints.AIChatLibraryPromptPrivacyWrapper;
import com.intellij.ml.llm.core.chat.session.ChatCreationContext;
import com.intellij.ml.llm.core.chat.session.ChatCreationContextWithSelection;
import com.intellij.ml.llm.core.chat.session.ChatOrigin;
import com.intellij.ml.llm.core.chat.session.ChatSourceAction;
import com.intellij.ml.llm.core.promptLibrary.AIChatLibraryPrompt;
import com.intellij.ml.llm.core.promptLibrary.variables.AIAssistantPromptLibraryVariable;
import com.intellij.ml.llm.core.promptLibrary.variables.AIAssistantPromptLibraryVariablesResolver;
import com.intellij.ml.llm.intentions.chat.AbstractChatIntention;
import com.intellij.ml.llm.intentions.chat.ChatIntentionTarget;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.extensions.SharedExtensionsKtKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\tJ\r\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fH\u0016J\r\u0010\r\u001a\u00070\u000b\u00a2\u0006\u0002\b\u000eH\u0016J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J0\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0094@\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\tH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/ml/llm/core/chat/promptLibrary/entryPoints/AIAssistantPromptIntention;", "Lcom/intellij/ml/llm/intentions/chat/AbstractChatIntention;", "libraryPrompt", "Lcom/intellij/ml/llm/core/promptLibrary/AIChatLibraryPrompt;", "<init>", "(Lcom/intellij/ml/llm/core/promptLibrary/AIChatLibraryPrompt;)V", "getPriority", "", "isBuiltIn", "", "getFamilyName", "", "Lorg/jetbrains/annotations/Nls;", "getText", "Lcom/intellij/openapi/util/NlsSafe;", "getPrompt", "Lcom/intellij/ml/llm/intentions/chat/AbstractChatIntention$Prompt;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intentionTarget", "Lcom/intellij/ml/llm/intentions/chat/ChatIntentionTarget;", "getChatCreationContext", "Lcom/intellij/ml/llm/core/chat/session/ChatCreationContext;", "extraItems", "", "Lcom/intellij/ml/llm/core/chat/context/ChatContextItem;", "sourceFile", "Lcom/intellij/psi/PsiFile;", "selectionRange", "Lcom/intellij/openapi/editor/RangeMarker;", "(Ljava/util/List;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/RangeMarker;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendMessageImmediately", "intellij.ml.llm.chat"})
public final class AIAssistantPromptIntention
extends AbstractChatIntention {
    @NotNull
    private final AIChatLibraryPrompt libraryPrompt;

    public AIAssistantPromptIntention(@NotNull AIChatLibraryPrompt libraryPrompt) {
        Intrinsics.checkNotNullParameter((Object)libraryPrompt, (String)"libraryPrompt");
        super(null, 1, null);
        this.libraryPrompt = libraryPrompt;
    }

    public final int getPriority() {
        return this.libraryPrompt.isBuiltIn() ? 100500 + this.libraryPrompt.getPriority() : this.libraryPrompt.getPriority();
    }

    public final boolean isBuiltIn() {
        return this.libraryPrompt.isBuiltIn();
    }

    @NotNull
    public String getFamilyName() {
        return this.isBuiltIn() ? LLMBundle.INSTANCE.getMessage("intention.category.small.on.selected.code", new Object[0]) : LLMBundle.INSTANCE.getMessage("intention.category.small.custom.prompt", new Object[0]);
    }

    @NotNull
    public String getText() {
        return this.libraryPrompt.getFormattedName();
    }

    @Override
    @NotNull
    public AbstractChatIntention.Prompt getPrompt(@NotNull Project project, @Nullable Editor editor, @NotNull ChatIntentionTarget intentionTarget) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)intentionTarget, (String)"intentionTarget");
        Language language = intentionTarget.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        PSString language2 = ExtensionsKtKt.getPrivacySafe((Language)language).getDisplayName();
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"getInstance(...)");
        PSString productName = SharedExtensionsKtKt.getPrivacySafe((ApplicationNamesInfo)applicationNamesInfo).getFullProductName();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)AIAssistantPromptLibraryVariable.PRODUCT, (Object)productName), TuplesKt.to((Object)AIAssistantPromptLibraryVariable.PRODUCT_NAME, (Object)productName), TuplesKt.to((Object)AIAssistantPromptLibraryVariable.SELECTION, (Object)ConstantsKt.getPrivacyConst((String)"$SELECTION")), TuplesKt.to((Object)AIAssistantPromptLibraryVariable.SELECTION_RAW, (Object)ConstantsKt.getPrivacyConst((String)"$SELECTION")), TuplesKt.to((Object)AIAssistantPromptLibraryVariable.LANGUAGE, (Object)language2), TuplesKt.to((Object)AIAssistantPromptLibraryVariable.SELECTION_LANG, (Object)language2)};
        return new AbstractChatIntention.Prompt(new AIAssistantPromptLibraryVariablesResolver(this.libraryPrompt).resolve(MapsKt.mapOf((Pair[])pairArray)), null, 2, null);
    }

    @Override
    @Nullable
    protected Object getChatCreationContext(@NotNull List<ChatContextItem> extraItems, @Nullable PsiFile sourceFile, @Nullable RangeMarker selectionRange, @NotNull Continuation<? super ChatCreationContext> $completion) {
        ChatSourceAction sourceAction = this.libraryPrompt.getStatId();
        String promptId = this.libraryPrompt.getId();
        Collection collection = extraItems;
        String string = Reflection.getOrCreateKotlinClass(AIChatLibraryPrompt.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        List newExtraItems = CollectionsKt.plus((Collection)collection, (Object)new ChatContextItem(string, new AIChatLibraryPromptPrivacyWrapper(promptId).getId(), null, 4, null));
        return selectionRange != null ? (ChatCreationContext)new ChatCreationContextWithSelection(ChatOrigin.CustomIntention.INSTANCE, sourceAction, sourceFile, newExtraItems, null, selectionRange, 16, null) : new ChatCreationContext(ChatOrigin.CustomIntention.INSTANCE, sourceAction, sourceFile, newExtraItems, null, 16, null);
    }

    @Override
    protected boolean sendMessageImmediately() {
        return !this.libraryPrompt.getWaitForInput();
    }
}

