/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.proxy;

import com.intellij.CommonBundle;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.messages.ChatMessage;
import com.intellij.ml.llm.core.chat.messages.ChatMessageAuthor;
import com.intellij.ml.llm.core.chat.messages.ChatMessageKt;
import com.intellij.ml.llm.core.chat.messages.ChatUserMessageFactory;
import com.intellij.ml.llm.core.chat.messages.CompletableMessage;
import com.intellij.ml.llm.core.chat.messages.UserMessage;
import com.intellij.ml.llm.core.chat.messages.UserMessageRequest;
import com.intellij.ml.llm.core.chat.messages.impl.ChatUserMessageRequest;
import com.intellij.ml.llm.core.chat.messages.impl.RestoredMessage;
import com.intellij.ml.llm.core.chat.messages.impl.UserMessageFactory;
import com.intellij.ml.llm.core.chat.proxy.AIAChatInputProxy;
import com.intellij.ml.llm.core.chat.proxy.AIAChatInputProxyMonolith;
import com.intellij.ml.llm.core.chat.proxy.AIAChatMessagesSearchProxy;
import com.intellij.ml.llm.core.chat.proxy.AIAChatMessagesSearchProxyMonolith;
import com.intellij.ml.llm.core.chat.proxy.AIAChatMessagesViewProxy;
import com.intellij.ml.llm.core.chat.proxy.AIAChatMessagesViewProxyMonolith;
import com.intellij.ml.llm.core.chat.proxy.AIAChatSessionProxy;
import com.intellij.ml.llm.core.chat.proxy.AIAChatSessionProxyKt;
import com.intellij.ml.llm.core.chat.proxy.AIAChatSessionProxyMonolith;
import com.intellij.ml.llm.core.chat.proxy.AIAInputSubmitListener;
import com.intellij.ml.llm.core.chat.proxy.AIAssistantProxyBackdoorsKt;
import com.intellij.ml.llm.core.chat.services.AIAssistantServiceScope;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.core.chat.session.ChatSessionState;
import com.intellij.ml.llm.core.chat.session.ChatSessionUtils;
import com.intellij.ml.llm.core.chat.session.FocusedChatSessionHost;
import com.intellij.ml.llm.core.chat.session.impl.ChatSessionImpl;
import com.intellij.ml.llm.core.chat.ui.AIAssistantChatSplitKt;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtil;
import com.intellij.ml.llm.core.chat.ui.chat.AIAssistantChatCustomNotificationViewModel;
import com.intellij.ml.llm.core.chat.ui.chat.AIAssistantChatMessageListener;
import com.intellij.ml.llm.core.chat.ui.chat.AIAssistantChatMessageViewModel;
import com.intellij.ml.llm.core.chat.ui.chat.AIAssistantChatPanel;
import com.intellij.ml.llm.core.chat.ui.chat.AIAssistantChatPanelComponent;
import com.intellij.ml.llm.core.chat.ui.chat.AIAssistantChatPanelComponentProvider;
import com.intellij.ml.llm.core.chat.ui.chat.AIAssistantMessagesView;
import com.intellij.ml.llm.core.chat.ui.chat.AIAssistantMessagesViewImpl;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentSource;
import com.intellij.ml.llm.core.chat.ui.chat.input.AIAssistantInput;
import com.intellij.ml.llm.core.chat.ui.chat.input.AIAssistantInputTrigger;
import com.intellij.ml.llm.core.chat.ui.chat.input.chatModeSelector.NewChatMode;
import com.intellij.ml.llm.core.chat.ui.chat.notification.AIAssistantNotification;
import com.intellij.ml.llm.core.chat.ui.chat.notification.ChatNotificationManager;
import com.intellij.ml.llm.core.statistics.fus.AIAssistantChatEventLogger;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.observable.properties.AtomicBooleanProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.TimeoutUtil;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00d0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001ZB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0096@\u00a2\u0006\u0002\u0010#J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020*H\u0016J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u000fH\u0016J\u0010\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00020\"H\u0016J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020 H\u0016J\u0010\u00102\u001a\u00020 2\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\r2\u0006\u00103\u001a\u000204H\u0016J\b\u00106\u001a\u00020\rH\u0016J\u000e\u0010:\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010;J\b\u0010<\u001a\u00020 H\u0016J\b\u0010=\u001a\u00020>H\u0016J\b\u0010?\u001a\u00020\rH\u0016J\b\u0010@\u001a\u00020AH\u0016J\b\u0010B\u001a\u00020CH\u0016J\b\u0010D\u001a\u00020EH\u0016J\b\u0010F\u001a\u00020\rH\u0016J\u0010\u0010G\u001a\u0004\u0018\u00010H2\u0006\u0010I\u001a\u00020JJ\u0010\u0010K\u001a\u0004\u0018\u00010H2\u0006\u0010L\u001a\u00020\u0010J\f\u0010M\u001a\u00020N*\u00020NH\u0002J\u0010\u0010O\u001a\u00020\r2\u0006\u0010I\u001a\u00020\u0010H\u0002J\u0010\u0010P\u001a\u00020\r2\u0006\u0010I\u001a\u00020\u0010H\u0002J$\u0010Q\u001a\u00020\r2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020S0\u000f2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020S0\u000fH\u0002J\u0006\u0010U\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001bR\u0014\u00107\u001a\u000208X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00109R\u0010\u0010V\u001a\u0004\u0018\u00010WX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010X\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\bX\u0010Y\u00a8\u0006["}, d2={"Lcom/intellij/ml/llm/core/chat/proxy/AIAChatSessionProxyMonolith;", "Lcom/intellij/ml/llm/core/chat/proxy/AIAChatSessionProxy;", "project", "Lcom/intellij/openapi/project/Project;", "chatSession", "Lcom/intellij/ml/llm/core/chat/session/impl/ChatSessionImpl;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/core/chat/session/impl/ChatSessionImpl;)V", "getChatSession", "()Lcom/intellij/ml/llm/core/chat/session/impl/ChatSessionImpl;", "chatPanel", "Lcom/intellij/ml/llm/core/chat/ui/chat/AIAssistantChatPanel;", "setChatPanel", "", "messages", "", "Lcom/intellij/ml/llm/core/chat/ui/chat/AIAssistantChatMessageViewModel;", "getMessages", "()Ljava/util/List;", "input", "Lcom/intellij/ml/llm/core/chat/ui/chat/input/AIAssistantInput;", "getInput", "()Lcom/intellij/ml/llm/core/chat/ui/chat/input/AIAssistantInput;", "state", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/intellij/ml/llm/core/chat/session/ChatSessionState;", "getState", "()Lkotlinx/coroutines/flow/StateFlow;", "chatMode", "Lcom/intellij/ml/llm/core/chat/ui/chat/input/chatModeSelector/NewChatMode;", "getChatMode", "executeSubmitAction", "", "inputText", "Lcom/intellij/ml/llm/privacy/PSString;", "(Lcom/intellij/ml/llm/privacy/PSString;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createMessagesView", "Lcom/intellij/ml/llm/core/chat/ui/chat/AIAssistantMessagesView;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "updateUiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "createAdditionalComponents", "Lcom/intellij/ml/llm/core/chat/ui/chat/AIAssistantChatPanelComponent;", "showChatExample", "request", "getCustomNotificationViewModel", "Lcom/intellij/ml/llm/core/chat/ui/chat/AIAssistantChatCustomNotificationViewModel;", "isInEditMessageMode", "canEnterEditMessageMode", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "enterEditMessageMode", "exitEditMessageMode", "isInEditMode", "Lcom/intellij/openapi/observable/properties/AtomicBooleanProperty;", "()Lcom/intellij/openapi/observable/properties/AtomicBooleanProperty;", "restoreInputFieldAfterSubmitting", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "shouldShowMessagesView", "createInputSubmitListener", "Lcom/intellij/ml/llm/core/chat/proxy/AIAInputSubmitListener;", "focusChatSession", "createAIAChatInputProxy", "Lcom/intellij/ml/llm/core/chat/proxy/AIAChatInputProxy;", "createMessagesSearchProxy", "Lcom/intellij/ml/llm/core/chat/proxy/AIAChatMessagesSearchProxy;", "createMessagesViewProxy", "Lcom/intellij/ml/llm/core/chat/proxy/AIAChatMessagesViewProxy;", "logEditUserMessageCancelledWithMouse", "regenerateResponse", "Lkotlinx/coroutines/Job;", "message", "Lcom/intellij/ml/llm/core/chat/messages/ChatMessage;", "recoverFromError", "errorMessage", "removeAutomaticallyCollectedAttachments", "Lcom/intellij/ml/llm/core/chat/messages/UserMessage;", "restartChatFromMessage", "enterEditMode", "replaceContextAttachments", "previousAttachments", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachment;", "newAttachments", "restartChatFromEditedMessage", "editingContext", "Lcom/intellij/ml/llm/core/chat/proxy/AIAChatSessionProxyMonolith$EditingMessageContext;", "isEditMode", "()Z", "EditingMessageContext", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nAIAChatSessionProxy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIAChatSessionProxy.kt\ncom/intellij/ml/llm/core/chat/proxy/AIAChatSessionProxyMonolith\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,528:1\n1563#2:529\n1634#2,3:530\n295#2,2:533\n360#2,7:537\n774#2:544\n865#2,2:545\n1869#2,2:547\n1869#2,2:549\n30#3,2:535\n*S KotlinDebug\n*F\n+ 1 AIAChatSessionProxy.kt\ncom/intellij/ml/llm/core/chat/proxy/AIAChatSessionProxyMonolith\n*L\n190#1:529\n190#1:530,3\n221#1:533,2\n303#1:537,7\n354#1:544\n354#1:545,2\n397#1:547,2\n400#1:549,2\n283#1:535,2\n*E\n"})
public final class AIAChatSessionProxyMonolith
implements AIAChatSessionProxy {
    @NotNull
    private final Project project;
    @NotNull
    private final ChatSessionImpl chatSession;
    private AIAssistantChatPanel chatPanel;
    @NotNull
    private final AtomicBooleanProperty isInEditMode;
    @Nullable
    private EditingMessageContext editingContext;

    public AIAChatSessionProxyMonolith(@NotNull Project project, @NotNull ChatSessionImpl chatSession2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)chatSession2, (String)"chatSession");
        this.project = project;
        this.chatSession = chatSession2;
        this.isInEditMode = new AtomicBooleanProperty(false);
    }

    @NotNull
    public final ChatSessionImpl getChatSession() {
        return this.chatSession;
    }

    @Override
    public void setChatPanel(@NotNull AIAssistantChatPanel chatPanel2) {
        Intrinsics.checkNotNullParameter((Object)chatPanel2, (String)"chatPanel");
        this.chatPanel = chatPanel2;
    }

    private final List<AIAssistantChatMessageViewModel> getMessages() {
        Object object;
        AIAssistantChatPanel aIAssistantChatPanel = this.chatPanel;
        if (aIAssistantChatPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chatPanel");
            aIAssistantChatPanel = null;
        }
        if ((object = AIAssistantProxyBackdoorsKt.messageViewBackdoor(aIAssistantChatPanel)) == null || (object = ((AIAssistantMessagesViewImpl)object).getMessages$intellij_ml_llm_chat()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final AIAssistantInput getInput() {
        AIAssistantChatPanel aIAssistantChatPanel = this.chatPanel;
        if (aIAssistantChatPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chatPanel");
            aIAssistantChatPanel = null;
        }
        return aIAssistantChatPanel.getInput();
    }

    @Override
    @NotNull
    public StateFlow<ChatSessionState> getState() {
        return this.chatSession.getStateFlow();
    }

    @Override
    @NotNull
    public StateFlow<NewChatMode> getChatMode() {
        return this.chatSession.getChatMode().getCurrentChatMode();
    }

    @Override
    @Nullable
    public Object executeSubmitAction(@NotNull PSString inputText, @NotNull Continuation<? super Boolean> $completion) {
        Object object;
        ChatMessage messageToEdit = this.isInEditMessageMode() ? ((object = this.editingContext) != null && (object = ((EditingMessageContext)object).getMessage()) != null ? ((AIAssistantChatMessageViewModel)object).getChatMessage() : null) : null;
        return this.chatSession.executeSubmitAction(inputText, messageToEdit, $completion);
    }

    @Override
    @NotNull
    public AIAssistantMessagesView createMessagesView(@NotNull CoroutineScope scope) {
        AIAssistantMessagesView aIAssistantMessagesView;
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        if (Registry.Companion.is("llm.chat.compose")) {
            AIAssistantMessagesView aIAssistantMessagesView2;
            AIAssistantMessagesView it = aIAssistantMessagesView2 = AIAssistantChatSplitKt.createMessagesSplitView(scope, this.chatSession);
            boolean bl = false;
            aIAssistantMessagesView = aIAssistantMessagesView2;
        } else {
            AIAssistantChatPanel aIAssistantChatPanel = this.chatPanel;
            if (aIAssistantChatPanel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"chatPanel");
                aIAssistantChatPanel = null;
            }
            aIAssistantMessagesView = new AIAssistantMessagesViewImpl(scope, this.project, aIAssistantChatPanel, this.createMessagesViewProxy());
        }
        return aIAssistantMessagesView;
    }

    @Override
    public void updateUiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        sink.set(ChatSession.Companion.getCurrentSession(), (Object)this.chatSession);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AIAssistantChatPanelComponent> createAdditionalComponents() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = AIAssistantChatPanelComponentProvider.Companion.getEP().getExtensionList();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AIAssistantChatPanelComponentProvider aIAssistantChatPanelComponentProvider = (AIAssistantChatPanelComponentProvider)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            AIAssistantChatPanel aIAssistantChatPanel = this.chatPanel;
            if (aIAssistantChatPanel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"chatPanel");
                aIAssistantChatPanel = null;
            }
            collection.add(it.createChatPanelComponent(this.project, aIAssistantChatPanel, this.chatSession, AIAssistantServiceScope.Companion.getScope(this.project)));
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void showChatExample(@NotNull PSString request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.chatSession.sendRequest(request);
    }

    @Override
    @NotNull
    public AIAssistantChatCustomNotificationViewModel getCustomNotificationViewModel() {
        return this.chatSession.getCustomNotification();
    }

    @Override
    public boolean isInEditMessageMode() {
        return this.editingContext != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canEnterEditMessageMode(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        ChatSession session = (ChatSession)ChatSession.Companion.getCurrentSession().getData(dataContext);
        ChatMessage message = (ChatMessage)ChatMessage.Companion.getKey().getData(dataContext);
        AIAChatSessionProxyKt.access$getLogger$p().assertTrue(session == this.chatSession, (Object)"Session from data context differs from stored session");
        if (session == null) return false;
        ChatMessage chatMessage = message;
        if ((chatMessage != null ? chatMessage.getAuthor() : null) != ChatMessageAuthor.User) return false;
        if (!AIAssistantUIUtil.INSTANCE.isAssistantActive(this.project)) return false;
        if (session.getState() == ChatSessionState.Busy) return false;
        return true;
    }

    @Override
    public void enterEditMessageMode(@NotNull DataContext dataContext) {
        Object v1;
        ChatMessage message;
        block3: {
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            ChatMessage chatMessage = (ChatMessage)ChatMessage.Companion.getKey().getData(dataContext);
            if (chatMessage == null) {
                return;
            }
            message = chatMessage;
            AIAssistantChatEventLogger.logEditUserMessageStarted(this.project, this.chatSession, message);
            Iterable $this$firstOrNull$iv = this.getMessages();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AIAssistantChatMessageViewModel it = (AIAssistantChatMessageViewModel)element$iv;
                boolean bl = false;
                if (!(it.getChatMessage() == message)) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        AIAssistantChatMessageViewModel vm = v1;
        if (vm == null) {
            AIAChatSessionProxyKt.access$getLogger$p().error("Message " + message.getUid() + " was not found in AIAssistantChatPanel");
            return;
        }
        this.enterEditMode(vm);
    }

    @Override
    public void exitEditMessageMode() {
        EditingMessageContext editingMessageContext = this.editingContext;
        if (editingMessageContext == null) {
            return;
        }
        EditingMessageContext currentContext = editingMessageContext;
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(currentContext.getDispatcher());
        this.getInput().setText(currentContext.getPreviousText());
        this.replaceContextAttachments(this.getInput().getContextPanelModel().getModelImpl().getContextItems(), currentContext.getPreviousContextAttachments());
        this.editingContext = null;
        ChatNotificationManager.Companion.getInstance(this.project).hideNotification(this.chatSession);
        this.isInEditMode().set(false);
    }

    @Override
    @NotNull
    public AtomicBooleanProperty isInEditMode() {
        return this.isInEditMode;
    }

    @Override
    @Nullable
    public Object restoreInputFieldAfterSubmitting(@NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ AIAChatSessionProxyMonolith this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = CoroutinesKt.writeIntentReadAction(() -> restoreInputFieldAfterSubmitting.2.invokeSuspend$lambda$0(this.this$0), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(AIAChatSessionProxyMonolith this$0) {
                if (this$0.isEditMode()) {
                    this$0.restartChatFromEditedMessage();
                } else {
                    AIAChatSessionProxyMonolith.access$getInput(this$0).setText("");
                }
                return Unit.INSTANCE;
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    public boolean shouldShowMessagesView() {
        return !((Collection)this.chatSession.getMessages()).isEmpty() || !((Collection)this.getMessages()).isEmpty();
    }

    @Override
    @NotNull
    public AIAInputSubmitListener createInputSubmitListener() {
        return new AIAInputSubmitListener(this){
            private long timeSendWithRagStarted;
            final /* synthetic */ AIAChatSessionProxyMonolith this$0;
            {
                this.this$0 = $receiver;
            }

            public void onInputSubmitTriggered(AIAssistantInputTrigger trigger) {
                block4: {
                    Object object;
                    block3: {
                        Intrinsics.checkNotNullParameter((Object)((Object)trigger), (String)"trigger");
                        if (this.this$0.getChatSession().getState() != ChatSessionState.Idle) break block3;
                        if (ChatSessionUtils.INSTANCE.isCodebaseEnabled(this.this$0.getChatSession())) {
                            this.timeSendWithRagStarted = System.nanoTime();
                            AIAssistantChatEventLogger.logSendWithRagClicked(this.this$0.getChatSession());
                        }
                        AIAssistantChatEventLogger.logSendButtonClicked(this.this$0.getChatSession(), CollectionsKt.toList((Iterable)ChatSessionUtils.INSTANCE.getActiveModes(this.this$0.getChatSession())));
                        break block4;
                    }
                    if (trigger != AIAssistantInputTrigger.Button) break block4;
                    if (ChatSessionUtils.INSTANCE.isCodebaseEnabled(this.this$0.getChatSession())) {
                        AIAssistantChatEventLogger.logSendWithRagCanceled(this.this$0.getChatSession(), TimeoutUtil.getDurationMillis((long)this.timeSendWithRagStarted));
                    }
                    CompletableMessage completableMessage = (object = CollectionsKt.lastOrNull(this.this$0.getChatSession().getMessages())) instanceof CompletableMessage ? (CompletableMessage)object : null;
                    if (completableMessage != null) {
                        completableMessage.cancel();
                    }
                }
            }
        };
    }

    @Override
    public void focusChatSession() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<FocusedChatSessionHost> serviceClass$iv = FocusedChatSessionHost.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((FocusedChatSessionHost)object).focusChatSession(this.chatSession);
    }

    @Override
    @NotNull
    public AIAChatInputProxy createAIAChatInputProxy() {
        return new AIAChatInputProxyMonolith(this.chatSession);
    }

    @Override
    @NotNull
    public AIAChatMessagesSearchProxy createMessagesSearchProxy() {
        return new AIAChatMessagesSearchProxyMonolith(this.chatSession);
    }

    @Override
    @NotNull
    public AIAChatMessagesViewProxy createMessagesViewProxy() {
        ChatSession chatSession2 = this.chatSession;
        AIAssistantChatPanel aIAssistantChatPanel = this.chatPanel;
        if (aIAssistantChatPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chatPanel");
            aIAssistantChatPanel = null;
        }
        return new AIAChatMessagesViewProxyMonolith(chatSession2, aIAssistantChatPanel);
    }

    @Override
    public void logEditUserMessageCancelledWithMouse() {
        AIAssistantChatEventLogger.logEditUserMessageCancelledWithMouse(this.project, this.chatSession);
    }

    @Nullable
    public final Job regenerateResponse(@NotNull ChatMessage message) {
        Job job2;
        int n;
        block10: {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            List<AIAssistantChatMessageViewModel> $this$indexOfFirst$iv = this.getMessages();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<AIAssistantChatMessageViewModel> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                AIAssistantChatMessageViewModel item$iv;
                AIAssistantChatMessageViewModel it = item$iv = iterator.next();
                boolean bl = false;
                if (it.getChatMessage() == message) {
                    n = index$iv;
                    break block10;
                }
                ++index$iv;
            }
            n = -1;
        }
        int chatMessageIndex = n;
        switch (chatMessageIndex) {
            case -1: {
                AIAChatSessionProxyKt.access$getLogger$p().error("Message " + message.getUid() + " was not found in AIAssistantChatPanel");
                return null;
            }
            case 0: {
                AIAChatSessionProxyKt.access$getLogger$p().error("Message " + message.getUid() + " cannot be a response, as it's the first message in the list.");
                return null;
            }
        }
        AIAssistantChatEventLogger.logMessageRegenerate(this.project, this.chatSession, message);
        AIAssistantChatMessageViewModel previousMessageViewModel = this.getMessages().get(chatMessageIndex - 1);
        ((AIAssistantChatMessageListener)this.chatSession.getChatMessageListeners().getMulticaster()).onRegenerateResponse(message);
        ChatMessage previousMessage = previousMessageViewModel.getChatMessage();
        if (previousMessage instanceof UserMessage) {
            this.restartChatFromMessage(previousMessageViewModel);
            job2 = this.chatSession.sendRequest(this.removeAutomaticallyCollectedAttachments((UserMessage)previousMessage));
        } else if (previousMessage instanceof RestoredMessage) {
            this.restartChatFromMessage(previousMessageViewModel);
            UserMessage userMessage = ChatUserMessageFactory.Companion.createUserMessage((UserMessageRequest)new ChatUserMessageRequest(this.chatSession, ((RestoredMessage)previousMessage).getDisplayText(), previousMessage.getFormattedText(), null, ((RestoredMessage)previousMessage).getAttachments(), ((RestoredMessage)previousMessage).getMedia(), null, null, ((RestoredMessage)previousMessage).getMarkupLanguage(), null, null, false, 3784, null));
            job2 = this.chatSession.sendRequest(this.removeAutomaticallyCollectedAttachments(userMessage));
        } else {
            AIAChatSessionProxyKt.access$getLogger$p().error("Message " + message.getUid() + " is not user message or either restored message");
            job2 = null;
        }
        return job2;
    }

    @Nullable
    public final Job recoverFromError(@NotNull AIAssistantChatMessageViewModel errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        AIAssistantChatMessageViewModel previous = this.getMessages().get(this.getMessages().indexOf(errorMessage) - 1);
        if (previous.getChatMessage() instanceof UserMessage) {
            this.restartChatFromMessage(previous);
            return this.chatSession.sendRequest((UserMessage)previous.getChatMessage());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final UserMessage removeAutomaticallyCollectedAttachments(UserMessage $this$removeAutomaticallyCollectedAttachments) {
        void $this$filterTo$iv$iv;
        List filteredAttachments = CollectionsKt.toMutableList((Collection)$this$removeAutomaticallyCollectedAttachments.getAttachments());
        Iterable $this$filter$iv = $this$removeAutomaticallyCollectedAttachments.getAttachments();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ChatAttachment it = (ChatAttachment)element$iv$iv;
            boolean bl = false;
            if (!(it.getSource() instanceof ContextAttachmentSource && ((ContextAttachmentSource)it.getSource()).isAutomaticallyCollected())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List automaticallyCollected = (List)destination$iv$iv;
        filteredAttachments.removeAll(automaticallyCollected);
        return UserMessageFactory.Companion.copy($this$removeAutomaticallyCollectedAttachments, filteredAttachments, $this$removeAutomaticallyCollectedAttachments.getContext());
    }

    private final void restartChatFromMessage(AIAssistantChatMessageViewModel message) {
        int targetMessageIndex = this.getMessages().indexOf(message);
        BuildersKt.launch((CoroutineScope)AIAssistantServiceScope.Companion.getScope(this.project), (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (CoroutineStart)CoroutineStart.UNDISPATCHED, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, targetMessageIndex, null){
            int label;
            final /* synthetic */ AIAChatSessionProxyMonolith this$0;
            final /* synthetic */ int $targetMessageIndex;
            {
                this.this$0 = $receiver;
                this.$targetMessageIndex = $targetMessageIndex;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.getChatSession().rewind(this.$targetMessageIndex, (Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final void enterEditMode(AIAssistantChatMessageViewModel message) {
        KeyEventDispatcher dispatcher = arg_0 -> AIAChatSessionProxyMonolith.enterEditMode$lambda$5(this, message, arg_0);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(dispatcher);
        this.editingContext = new EditingMessageContext(message, (String)this.getInput().getText().unwrap(), this.getInput().getContextPanelModel().getModelImpl().getContextItems(), dispatcher);
        this.replaceContextAttachments(this.getInput().getContextPanelModel().getModelImpl().getContextItems(), ChatMessageKt.manuallyAttachedContextAttachments(message.getChatMessage()));
        this.getInput().setText(message.getText());
        this.chatSession.transferUserDataFromMessage(message.getChatMessage());
        AIAssistantNotification.Builder builder = new AIAssistantNotification.Builder(LLMBundle.message((String)"llm.warning.history.deleted", (Object[])new Object[0]), NotificationType.WARNING).isCompactNotification(true);
        String string = CommonBundle.getCancelButtonText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCancelButtonText(...)");
        AIAssistantNotification notification = builder.link(string, AIAssistantNotification.NotificationLinkPosition.Right, (Function0<Unit>)((Function0)() -> AIAChatSessionProxyMonolith.enterEditMode$lambda$6(this))).build();
        ChatNotificationManager.Companion.getInstance(this.project).showNotification(this.chatSession, notification);
        this.isInEditMode().set(true);
        AIAssistantChatPanel aIAssistantChatPanel = this.chatPanel;
        if (aIAssistantChatPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chatPanel");
            aIAssistantChatPanel = null;
        }
        aIAssistantChatPanel.focusInput();
    }

    private final void replaceContextAttachments(List<? extends ContextAttachment> previousAttachments, List<? extends ContextAttachment> newAttachments) {
        ContextAttachment it;
        Iterable $this$forEach$iv = previousAttachments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ContextAttachment)element$iv;
            boolean bl = false;
            this.getInput().getContextPanelModel().getModelImpl().removeContextItem(it);
        }
        $this$forEach$iv = newAttachments;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ContextAttachment)element$iv;
            boolean bl = false;
            this.getInput().getContextPanelModel().getModelImpl().addContextItem(it);
        }
    }

    public final void restartChatFromEditedMessage() {
        Object object = this.editingContext;
        if (object == null || (object = ((EditingMessageContext)object).getMessage()) == null) {
            return;
        }
        Object message = object;
        AIAssistantChatEventLogger.logEditUserMessageFinished(this.project, this.chatSession, ((AIAssistantChatMessageViewModel)message).getChatMessage());
        this.exitEditMessageMode();
    }

    public final boolean isEditMode() {
        return this.editingContext != null;
    }

    private static final boolean enterEditMode$lambda$5(AIAChatSessionProxyMonolith this$0, AIAssistantChatMessageViewModel $message, KeyEvent e) {
        KeyEvent keyEvent = e;
        boolean bl = keyEvent != null ? keyEvent.getKeyCode() == 27 : false;
        if (bl) {
            AIAssistantChatEventLogger.logEditUserMessageCancelled(this$0.project, this$0.chatSession, $message.getChatMessage());
            this$0.exitEditMessageMode();
        }
        return false;
    }

    private static final Unit enterEditMode$lambda$6(AIAChatSessionProxyMonolith this$0) {
        this$0.logEditUserMessageCancelledWithMouse();
        this$0.exitEditMessageMode();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ AIAssistantInput access$getInput(AIAChatSessionProxyMonolith $this) {
        return $this.getInput();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/core/chat/proxy/AIAChatSessionProxyMonolith$EditingMessageContext;", "", "message", "Lcom/intellij/ml/llm/core/chat/ui/chat/AIAssistantChatMessageViewModel;", "previousText", "", "previousContextAttachments", "", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachment;", "dispatcher", "Ljava/awt/KeyEventDispatcher;", "<init>", "(Lcom/intellij/ml/llm/core/chat/ui/chat/AIAssistantChatMessageViewModel;Ljava/lang/String;Ljava/util/List;Ljava/awt/KeyEventDispatcher;)V", "getMessage", "()Lcom/intellij/ml/llm/core/chat/ui/chat/AIAssistantChatMessageViewModel;", "getPreviousText", "()Ljava/lang/String;", "getPreviousContextAttachments", "()Ljava/util/List;", "getDispatcher", "()Ljava/awt/KeyEventDispatcher;", "intellij.ml.llm.chat"})
    private static final class EditingMessageContext {
        @NotNull
        private final AIAssistantChatMessageViewModel message;
        @NotNull
        private final String previousText;
        @NotNull
        private final List<ContextAttachment> previousContextAttachments;
        @NotNull
        private final KeyEventDispatcher dispatcher;

        public EditingMessageContext(@NotNull AIAssistantChatMessageViewModel message, @NotNull String previousText, @NotNull List<? extends ContextAttachment> previousContextAttachments, @NotNull KeyEventDispatcher dispatcher) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)previousText, (String)"previousText");
            Intrinsics.checkNotNullParameter(previousContextAttachments, (String)"previousContextAttachments");
            Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
            this.message = message;
            this.previousText = previousText;
            this.previousContextAttachments = previousContextAttachments;
            this.dispatcher = dispatcher;
        }

        @NotNull
        public final AIAssistantChatMessageViewModel getMessage() {
            return this.message;
        }

        @NotNull
        public final String getPreviousText() {
            return this.previousText;
        }

        @NotNull
        public final List<ContextAttachment> getPreviousContextAttachments() {
            return this.previousContextAttachments;
        }

        @NotNull
        public final KeyEventDispatcher getDispatcher() {
            return this.dispatcher;
        }
    }
}

