/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.services;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ml.llm.core.chat.services.ChatComposer;
import com.intellij.ml.llm.core.chat.services.FunctionCallResponseFormatter;
import com.intellij.ml.llm.core.chat.services.FunctionRequestAndResponse;
import com.intellij.ml.llm.core.chat.services.IgnoreFunctionCall;
import com.intellij.ml.llm.core.models.LlmProfileService;
import com.intellij.ml.llm.core.models.api.AiaLlmProfileID;
import com.intellij.openapi.application.ApplicationManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/core/chat/services/ChatComposerFactory;", "", "<init>", "()V", "createComposer", "Lcom/intellij/ml/llm/core/chat/services/ChatComposer;", "model", "Lcom/intellij/ml/llm/core/models/api/AiaLlmProfileID;", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nChatComposerFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatComposerFactory.kt\ncom/intellij/ml/llm/core/chat/services/ChatComposerFactory\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,23:1\n40#2,3:24\n*S KotlinDebug\n*F\n+ 1 ChatComposerFactory.kt\ncom/intellij/ml/llm/core/chat/services/ChatComposerFactory\n*L\n9#1:24,3\n*E\n"})
public final class ChatComposerFactory {
    @NotNull
    public static final ChatComposerFactory INSTANCE = new ChatComposerFactory();

    private ChatComposerFactory() {
    }

    @NotNull
    public final ChatComposer createComposer(@NotNull AiaLlmProfileID model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        boolean $i$f$service = false;
        Class<LlmProfileService> serviceClass$iv = LlmProfileService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        LlmProfileService llmService = (LlmProfileService)object;
        FunctionCallResponseFormatter formatter = llmService.isFunctionCallingSupported(model) ? (FunctionCallResponseFormatter)new FunctionRequestAndResponse() : (FunctionCallResponseFormatter)new IgnoreFunctionCall();
        boolean hasSystemMessage = llmService.isSystemMessageSupported(model);
        return new ChatComposer(formatter, hasSystemMessage){
            private final FunctionCallResponseFormatter functionCallResponseFormatter;
            private final boolean systemMessageSupported;
            {
                this.functionCallResponseFormatter = $formatter;
                this.systemMessageSupported = $hasSystemMessage;
            }

            public FunctionCallResponseFormatter getFunctionCallResponseFormatter() {
                return this.functionCallResponseFormatter;
            }

            public boolean getSystemMessageSupported() {
                return this.systemMessageSupported;
            }
        };
    }
}

