/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.SearchReplaceComponent;
import com.intellij.find.SearchSession;
import com.intellij.find.editorHeaderActions.NextOccurrenceAction;
import com.intellij.find.editorHeaderActions.PrevOccurrenceAction;
import com.intellij.find.editorHeaderActions.StatusTextAction;
import com.intellij.ml.llm.core.chat.proxy.AIAChatMessagesSearchProxy;
import com.intellij.ml.llm.core.chat.ui.chat.AIAssistantChatSearchHandler;
import com.intellij.ml.llm.core.chat.ui.chat.AIAssistantMessagesViewImpl;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B/\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u001a\u001a\u00020\u0013H\u0002J\b\u0010\u001b\u001a\u00020\u0013H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u001e\u001a\u00020\u0015H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u001dH\u0016J\b\u0010\"\u001a\u00020\u001dH\u0016J\b\u0010#\u001a\u00020\u001dH\u0016J\u0018\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0002J\b\u0010(\u001a\u00020\u001dH\u0016J\b\u0010)\u001a\u00020\u0015H\u0002J\u0010\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020,H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/AIAssistantChatSearchSession;", "Lcom/intellij/find/SearchSession;", "Lcom/intellij/find/FindModel$FindModelObserver;", "Lcom/intellij/find/SearchReplaceComponent$Listener;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "messagesView", "Lcom/intellij/ml/llm/core/chat/ui/chat/AIAssistantMessagesViewImpl;", "proxy", "Lcom/intellij/ml/llm/core/chat/proxy/AIAChatMessagesSearchProxy;", "project", "Lcom/intellij/openapi/project/Project;", "scrollBar", "Ljavax/swing/JScrollBar;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/ml/llm/core/chat/ui/chat/AIAssistantMessagesViewImpl;Lcom/intellij/ml/llm/core/chat/proxy/AIAChatMessagesSearchProxy;Lcom/intellij/openapi/project/Project;Ljavax/swing/JScrollBar;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "findModel", "Lcom/intellij/find/FindModel;", "searchComponent", "Lcom/intellij/find/SearchReplaceComponent;", "searchHandler", "Lcom/intellij/ml/llm/core/chat/ui/chat/AIAssistantChatSearchHandler;", "debounceJob", "Lkotlinx/coroutines/Job;", "createFindModel", "getFindModel", "findModelChanged", "", "getComponent", "hasMatches", "", "searchForward", "searchBackward", "searchFieldDocumentChanged", "modifyStatusText", "current", "", "total", "close", "createSearchComponent", "registerTextComponentActionShortcuts", "component", "Ljavax/swing/text/JTextComponent;", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nAIAssistantChatSearchSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIAssistantChatSearchSession.kt\ncom/intellij/ml/llm/core/chat/ui/chat/AIAssistantChatSearchSession\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1617#2,9:140\n1869#2:149\n1870#2:151\n1626#2:152\n1869#2,2:153\n1#3:150\n*S KotlinDebug\n*F\n+ 1 AIAssistantChatSearchSession.kt\ncom/intellij/ml/llm/core/chat/ui/chat/AIAssistantChatSearchSession\n*L\n134#1:140,9\n134#1:149\n134#1:151\n134#1:152\n136#1:153,2\n134#1:150\n*E\n"})
public final class AIAssistantChatSearchSession
implements SearchSession,
FindModel.FindModelObserver,
SearchReplaceComponent.Listener {
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final AIAssistantMessagesViewImpl messagesView;
    @NotNull
    private final AIAChatMessagesSearchProxy proxy;
    @NotNull
    private final Project project;
    @NotNull
    private final FindModel findModel;
    @NotNull
    private final SearchReplaceComponent searchComponent;
    @NotNull
    private final AIAssistantChatSearchHandler searchHandler;
    @Nullable
    private Job debounceJob;

    public AIAssistantChatSearchSession(@NotNull CoroutineScope cs, @NotNull AIAssistantMessagesViewImpl messagesView, @NotNull AIAChatMessagesSearchProxy proxy, @NotNull Project project, @NotNull JScrollBar scrollBar) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)messagesView, (String)"messagesView");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scrollBar, (String)"scrollBar");
        this.cs = cs;
        this.messagesView = messagesView;
        this.proxy = proxy;
        this.project = project;
        this.findModel = this.createFindModel();
        this.searchComponent = this.createSearchComponent();
        this.searchHandler = new AIAssistantChatSearchHandler(this.messagesView, this.findModel, this.project, scrollBar);
        Object[] objectArray = new Object[]{0};
        this.getComponent().setStatusText(ApplicationBundle.message((String)"editorsearch.matches", (Object[])objectArray));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final FindModel createFindModel() {
        FindModel findModel = new FindModel();
        FindModel findModel2 = FindManager.getInstance((Project)this.project).getFindInFileModel();
        Intrinsics.checkNotNullExpressionValue((Object)findModel2, (String)"getFindInFileModel(...)");
        findModel.copyFrom(findModel2);
        findModel.addObserver((FindModel.FindModelObserver)this);
        return findModel;
    }

    @NotNull
    public FindModel getFindModel() {
        return this.findModel;
    }

    public void findModelChanged(@NotNull FindModel findModel) {
        Intrinsics.checkNotNullParameter((Object)findModel, (String)"findModel");
        this.searchHandler.update();
        this.getComponent().update(findModel.getStringToFind(), "", false, false);
        this.modifyStatusText(this.searchHandler.getCurrentIndex(), this.searchHandler.getOccurrenceCount());
    }

    @NotNull
    public SearchReplaceComponent getComponent() {
        return this.searchComponent;
    }

    public boolean hasMatches() {
        return this.searchHandler.getOccurrenceCount() > 0;
    }

    public void searchForward() {
        this.searchHandler.goToNextOccurrence();
        this.modifyStatusText(this.searchHandler.getCurrentIndex(), this.searchHandler.getOccurrenceCount());
        this.proxy.logSearchNextOccurrenceClicked(this.searchHandler.getOccurrenceCount());
    }

    public void searchBackward() {
        this.searchHandler.goToPreviousOccurrence();
        this.modifyStatusText(this.searchHandler.getCurrentIndex(), this.searchHandler.getOccurrenceCount());
        this.proxy.logSearchPreviousOccurrenceClicked(this.searchHandler.getOccurrenceCount());
    }

    public void searchFieldDocumentChanged() {
        Job job2 = this.debounceJob;
        if (job2 != null) {
            Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
        }
        this.debounceJob = BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ AIAssistantChatSearchSession this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = DelayKt.delay((long)200L, (Continuation)((Continuation)this));
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        textToFind = this.this$0.getComponent().getSearchTextComponent().getText();
                        v1 = AIAssistantChatSearchSession.access$getFindModel$p(this.this$0);
                        Intrinsics.checkNotNull((Object)textToFind);
                        v1.setStringToFind(textToFind);
                        AIAssistantChatSearchSession.access$getFindModel$p(this.this$0).setMultiline(StringsKt.contains$default((CharSequence)textToFind, (CharSequence)"\n", (boolean)false, (int)2, null));
                        this.this$0.getComponent().update(AIAssistantChatSearchSession.access$getFindModel$p(this.this$0).getStringToFind(), "", false, AIAssistantChatSearchSession.access$getFindModel$p(this.this$0).isMultiline());
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void modifyStatusText(int current, int total) {
        if (this.searchHandler.getOccurrenceCount() > 0) {
            this.getComponent().setRegularBackground();
            Object[] objectArray = new Object[]{current, total};
            this.getComponent().setStatusText(ApplicationBundle.message((String)"editorsearch.current.cursor.position", (Object[])objectArray));
        } else {
            if (((CharSequence)this.findModel.getStringToFind()).length() > 0) {
                this.getComponent().setNotFoundBackground();
            }
            Object[] objectArray = new Object[]{total};
            this.getComponent().setStatusText(ApplicationBundle.message((String)"editorsearch.matches", (Object[])objectArray));
        }
    }

    public void close() {
        Job job2 = this.debounceJob;
        if (job2 != null) {
            Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
        }
        this.getComponent().getSearchTextComponent().setText("");
        this.getComponent().setVisible(false);
        this.findModel.setStringToFind("");
        this.findModel.setMultiline(false);
        this.getComponent().update(this.findModel.getStringToFind(), "", false, this.findModel.isMultiline());
        this.searchHandler.update();
        this.messagesView.getParentChatPanel$intellij_ml_llm_chat().focusInput();
        this.proxy.logSearchClosed();
    }

    private final SearchReplaceComponent createSearchComponent() {
        SearchReplaceComponent searchReplaceComponent;
        AnAction[] anActionArray = new AnAction[]{new StatusTextAction(), new PrevOccurrenceAction(), new NextOccurrenceAction()};
        SearchReplaceComponent searchReplaceComponent2 = SearchReplaceComponent.buildFor((Project)this.project, (JComponent)this.messagesView.getParentComponent$intellij_ml_llm_chat(), (SearchSession)this).withMaximizeLeftPanelOnResize().addPrimarySearchActions(anActionArray).withCloseAction(() -> AIAssistantChatSearchSession.createSearchComponent$lambda$0(this)).build();
        Intrinsics.checkNotNullExpressionValue((Object)searchReplaceComponent2, (String)"build(...)");
        SearchReplaceComponent $this$createSearchComponent_u24lambda_u241 = searchReplaceComponent = searchReplaceComponent2;
        boolean bl = false;
        $this$createSearchComponent_u24lambda_u241.setVisible(false);
        $this$createSearchComponent_u24lambda_u241.addListener((SearchReplaceComponent.Listener)this);
        JTextComponent jTextComponent = $this$createSearchComponent_u24lambda_u241.getSearchTextComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jTextComponent, (String)"getSearchTextComponent(...)");
        this.registerTextComponentActionShortcuts(jTextComponent);
        return searchReplaceComponent;
    }

    /*
     * WARNING - void declaration
     */
    private final void registerTextComponentActionShortcuts(JTextComponent component) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        ActionManager actionManager = ActionManager.getInstance();
        Object object = new String[]{"EditorCopy", "EditorCut", "EditorPaste", "$SelectAll", "$Undo", "$Redo"};
        object = CollectionsKt.listOf((Object[])object);
        boolean $i$f$mapNotNull = false;
        Iterator iterator = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            AnAction it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String p0 = (String)element$iv$iv;
            boolean bl2 = false;
            if (actionManager.getAction(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List actions = (List)destination$iv$iv;
        Iterable $this$forEach$iv = actions;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            AnAction it = (AnAction)element$iv;
            boolean bl = false;
            it.registerCustomShortcutSet((JComponent)component, null);
        }
    }

    private static final void createSearchComponent$lambda$0(AIAssistantChatSearchSession this$0) {
        this$0.close();
    }

    public static final /* synthetic */ FindModel access$getFindModel$p(AIAssistantChatSearchSession $this) {
        return $this.findModel;
    }
}

